/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.network;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.network.models.GatewayConnectDisconnectOrTestParameters;
import com.microsoft.windowsazure.management.network.models.GatewayConnectionCreateParameters;
import com.microsoft.windowsazure.management.network.models.GatewayConnectionGetResponse;
import com.microsoft.windowsazure.management.network.models.GatewayCreateParameters;
import com.microsoft.windowsazure.management.network.models.GatewayDiagnosticsStatus;
import com.microsoft.windowsazure.management.network.models.GatewayGenerateVpnClientPackageParameters;
import com.microsoft.windowsazure.management.network.models.GatewayGetDeviceConfigurationScriptParameters;
import com.microsoft.windowsazure.management.network.models.GatewayGetDeviceConfigurationScriptResponse;
import com.microsoft.windowsazure.management.network.models.GatewayGetIPsecParametersResponse;
import com.microsoft.windowsazure.management.network.models.GatewayGetOperationStatusResponse;
import com.microsoft.windowsazure.management.network.models.GatewayGetResponse;
import com.microsoft.windowsazure.management.network.models.GatewayGetSharedKeyResponse;
import com.microsoft.windowsazure.management.network.models.GatewayListConnectionsResponse;
import com.microsoft.windowsazure.management.network.models.GatewayListGatewayConnectionsResponse;
import com.microsoft.windowsazure.management.network.models.GatewayListSupportedDevicesResponse;
import com.microsoft.windowsazure.management.network.models.GatewayOperationResponse;
import com.microsoft.windowsazure.management.network.models.GatewayResetSharedKeyParameters;
import com.microsoft.windowsazure.management.network.models.GatewaySetDefaultSiteListParameters;
import com.microsoft.windowsazure.management.network.models.GatewaySetIPsecParametersParameters;
import com.microsoft.windowsazure.management.network.models.GatewaySetSharedKeyParameters;
import com.microsoft.windowsazure.management.network.models.ListLocalNetworkGatewaysResponse;
import com.microsoft.windowsazure.management.network.models.ListVirtualNetworkGatewaysResponse;
import com.microsoft.windowsazure.management.network.models.LocalNetworkGatewayCreateParameters;
import com.microsoft.windowsazure.management.network.models.LocalNetworkGatewayCreateResponse;
import com.microsoft.windowsazure.management.network.models.LocalNetworkGatewayGetResponse;
import com.microsoft.windowsazure.management.network.models.ResetGatewayParameters;
import com.microsoft.windowsazure.management.network.models.ResizeGatewayParameters;
import com.microsoft.windowsazure.management.network.models.StartGatewayPublicDiagnosticsParameters;
import com.microsoft.windowsazure.management.network.models.StopGatewayPublicDiagnosticsParameters;
import com.microsoft.windowsazure.management.network.models.UpdateGatewayConnectionParameters;
import com.microsoft.windowsazure.management.network.models.UpdateLocalNetworkGatewayParameters;
import com.microsoft.windowsazure.management.network.models.VirtualNetworkGatewayCreateParameters;
import com.microsoft.windowsazure.management.network.models.VirtualNetworkGatewayGetResponse;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Network Management API includes operations for managing the gateways for
* your subscription.  (see
* http://msdn.microsoft.com/en-us/library/windowsazure/jj154113.aspx for more
* information)
*/
public interface GatewayOperations {
    /**
    * To connect to, disconnect from, or test your connection to a local
    * network site, access the connection resource representing the local
    * network and specify Connect, Disconnect or Test to perform the desired
    * operation.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154107.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkSiteName Required. The name of the site to connect to.
    * @param parameters Required. Parameters supplied to the Begin Connect
    * Disconnect Or Testing Gateway operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginConnectDisconnectOrTesting(String networkName, String localNetworkSiteName, GatewayConnectDisconnectOrTestParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * To connect to, disconnect from, or test your connection to a local
    * network site, access the connection resource representing the local
    * network and specify Connect, Disconnect or Test to perform the desired
    * operation.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154107.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkSiteName Required. The name of the site to connect to.
    * @param parameters Required. Parameters supplied to the Begin Connect
    * Disconnect Or Testing Gateway operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginConnectDisconnectOrTestingAsync(String networkName, String localNetworkSiteName, GatewayConnectDisconnectOrTestParameters parameters);
    
    /**
    * The Begin Creating Virtual network Gateway operation creates a new
    * network gateway for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Creating
    * Virtual Network Gateway operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginCreating(String networkName, GatewayCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Creating Virtual network Gateway operation creates a new
    * network gateway for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Creating
    * Virtual Network Gateway operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginCreatingAsync(String networkName, GatewayCreateParameters parameters);
    
    /**
    * The Begin Creating Virtual network Gateway connection operation creates a
    * new network gateway connection.
    *
    * @param parameters Required. Parameters supplied to the Begin Creating
    * Gateway Connection operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginCreatingGatewayConnection(GatewayConnectionCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Creating Virtual network Gateway connection operation creates a
    * new network gateway connection.
    *
    * @param parameters Required. Parameters supplied to the Begin Creating
    * Gateway Connection operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginCreatingGatewayConnectionAsync(GatewayConnectionCreateParameters parameters);
    
    /**
    * The Begin Creating Virtual network Gateway operation creates a new
    * network gateway.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Creating
    * Virtual Network Gateway operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginCreatingVirtualNetworkGateway(String networkName, VirtualNetworkGatewayCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Creating Virtual network Gateway operation creates a new
    * network gateway.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Creating
    * Virtual Network Gateway operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginCreatingVirtualNetworkGatewayAsync(String networkName, VirtualNetworkGatewayCreateParameters parameters);
    
    /**
    * The Begin Deleting Virtual Network Gateway operation deletes a network
    * gateway for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154129.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginDeleting(String networkName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Begin Deleting Virtual Network Gateway operation deletes a network
    * gateway for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154129.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginDeletingAsync(String networkName);
    
    /**
    * The Begin Deleting Virtual Network Gateway connection deletes a network
    * gateway connection.
    *
    * @param gatewayId Required. The virtual network gateway Id.
    * @param connectedentityId Required. The connected entity Id.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginDeletingGatewayConnection(String gatewayId, String connectedentityId) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Begin Deleting Virtual Network Gateway connection deletes a network
    * gateway connection.
    *
    * @param gatewayId Required. The virtual network gateway Id.
    * @param connectedentityId Required. The connected entity Id.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginDeletingGatewayConnectionAsync(String gatewayId, String connectedentityId);
    
    /**
    * The Begin Deleting Virtual Network Gateway operation deletes a network
    * gateway
    *
    * @param gatewayId Required. The virtual network gateway id.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginDeletingVirtualNetworkGateway(String gatewayId) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Begin Deleting Virtual Network Gateway operation deletes a network
    * gateway
    *
    * @param gatewayId Required. The virtual network gateway id.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginDeletingVirtualNetworkGatewayAsync(String gatewayId);
    
    /**
    * The Begin Failover Virtual Network Gateway operation causes a network
    * gateway failover for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154118.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network in Azure.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginFailover(String networkName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Begin Failover Virtual Network Gateway operation causes a network
    * gateway failover for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154118.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network in Azure.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginFailoverAsync(String networkName);
    
    /**
    * The Generate VPN Client Package operation creates a VPN client package
    * for the specified virtual network and gateway in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn205126.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Generate VPN
    * Client Package operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginGenerateVpnClientPackage(String networkName, GatewayGenerateVpnClientPackageParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Generate VPN Client Package operation creates a VPN client package
    * for the specified virtual network and gateway in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn205126.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Generate VPN
    * Client Package operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginGenerateVpnClientPackageAsync(String networkName, GatewayGenerateVpnClientPackageParameters parameters);
    
    /**
    * The Begin Remove Virtual Network Gateway Shared Key operation removes the
    * default sites on the virtual network gateway for the specified virtual
    * network.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginRemoveDefaultSites(String networkName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Begin Remove Virtual Network Gateway Shared Key operation removes the
    * default sites on the virtual network gateway for the specified virtual
    * network.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginRemoveDefaultSitesAsync(String networkName);
    
    /**
    * The Begin Reset Virtual network Gateway operation resets an existing
    * gateway.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Reset
    * Virtual Network Gateway operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginReset(String networkName, ResetGatewayParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Reset Virtual network Gateway operation resets an existing
    * gateway.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Reset
    * Virtual Network Gateway operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginResetAsync(String networkName, ResetGatewayParameters parameters);
    
    /**
    * The Begin Reset Virtual Network Gateway Shared Key operation resets the
    * shared key on the virtual network gateway for the specified virtual
    * network connection to the specified local network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Reset Shared Key request.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginResetSharedKey(String networkName, String localNetworkName, GatewayResetSharedKeyParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Reset Virtual Network Gateway Shared Key operation resets the
    * shared key on the virtual network gateway for the specified virtual
    * network connection to the specified local network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Reset Shared Key request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginResetSharedKeyAsync(String networkName, String localNetworkName, GatewayResetSharedKeyParameters parameters);
    
    /**
    * The Begin Reset Virtual Network Gateway Shared Key V2 operation resets
    * the shared key used between the gateway and customer vpn.
    *
    * @param gatewayId Required. The virtual network for this gateway Id.
    * @param connectedentityId Required. The connected entity Id.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Reset Shared Key V2 request.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginResetSharedKeyV2(String gatewayId, String connectedentityId, GatewayResetSharedKeyParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Reset Virtual Network Gateway Shared Key V2 operation resets
    * the shared key used between the gateway and customer vpn.
    *
    * @param gatewayId Required. The virtual network for this gateway Id.
    * @param connectedentityId Required. The connected entity Id.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Reset Shared Key V2 request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginResetSharedKeyV2Async(String gatewayId, String connectedentityId, GatewayResetSharedKeyParameters parameters);
    
    /**
    * The Begin Reset Virtual network Gateway operation resets an existing
    * gateway.
    *
    * @param gatewayId Required. The virtual network for this gateway.
    * @param parameters Required. Parameters supplied to the Begin Reset
    * Virtual Network Gateway operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginResetVirtualNetworkGateway(String gatewayId, ResetGatewayParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Reset Virtual network Gateway operation resets an existing
    * gateway.
    *
    * @param gatewayId Required. The virtual network for this gateway.
    * @param parameters Required. Parameters supplied to the Begin Reset
    * Virtual Network Gateway operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginResetVirtualNetworkGatewayAsync(String gatewayId, ResetGatewayParameters parameters);
    
    /**
    * The Begin Resize Virtual network Gateway operation resizes an existing
    * gateway to a different GatewaySKU.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Resize
    * Virtual Network Gateway operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginResize(String networkName, ResizeGatewayParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Resize Virtual network Gateway operation resizes an existing
    * gateway to a different GatewaySKU.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Resize
    * Virtual Network Gateway operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginResizeAsync(String networkName, ResizeGatewayParameters parameters);
    
    /**
    * The Begin Resize Virtual network Gateway operation resizes an existing
    * gateway to a different GatewaySKU.
    *
    * @param gatewayId Required. The virtual network for this gateway id.
    * @param parameters Required. Parameters supplied to the Begin Resize
    * Virtual Network Gateway operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginResizeVirtualNetworkGateway(String gatewayId, ResizeGatewayParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Resize Virtual network Gateway operation resizes an existing
    * gateway to a different GatewaySKU.
    *
    * @param gatewayId Required. The virtual network for this gateway id.
    * @param parameters Required. Parameters supplied to the Begin Resize
    * Virtual Network Gateway operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginResizeVirtualNetworkGatewayAsync(String gatewayId, ResizeGatewayParameters parameters);
    
    /**
    * The Begin Set Virtual Network Gateway Shared Key operation sets the
    * default sites on the virtual network gateway for the specified virtual
    * network.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Set Default Sites request.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginSetDefaultSites(String networkName, GatewaySetDefaultSiteListParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Set Virtual Network Gateway Shared Key operation sets the
    * default sites on the virtual network gateway for the specified virtual
    * network.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Set Default Sites request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginSetDefaultSitesAsync(String networkName, GatewaySetDefaultSiteListParameters parameters);
    
    /**
    * The Begin Set Virtual Network Gateway IPsec Parameters operation sets the
    * IPsec parameters on the virtual network gateway for the specified
    * connection to the specified local network in Azure.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Set IPsec Parameters request.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginSetIPsecParameters(String networkName, String localNetworkName, GatewaySetIPsecParametersParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Set Virtual Network Gateway IPsec Parameters operation sets the
    * IPsec parameters on the virtual network gateway for the specified
    * connection to the specified local network in Azure.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Set IPsec Parameters request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginSetIPsecParametersAsync(String networkName, String localNetworkName, GatewaySetIPsecParametersParameters parameters);
    
    /**
    * The Begin Set Virtual Network Gateway IPsec Parameters V2 operation sets
    * the IPsec parameters on the virtual network gateway connection.
    *
    * @param gatewayId Required. The virtual network for this gateway Id.
    * @param connectedentityId Required. The connected entity Id.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Set IPsec Parameters V2 request.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginSetIPsecParametersV2(String gatewayId, String connectedentityId, GatewaySetIPsecParametersParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Set Virtual Network Gateway IPsec Parameters V2 operation sets
    * the IPsec parameters on the virtual network gateway connection.
    *
    * @param gatewayId Required. The virtual network for this gateway Id.
    * @param connectedentityId Required. The connected entity Id.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Set IPsec Parameters V2 request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginSetIPsecParametersV2Async(String gatewayId, String connectedentityId, GatewaySetIPsecParametersParameters parameters);
    
    /**
    * The Begin Set Virtual Network Gateway Shared Key operation sets the
    * shared key on the virtual network gateway for the specified virtual
    * network connection to the specified local network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Set Shared Key request.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginSetSharedKey(String networkName, String localNetworkName, GatewaySetSharedKeyParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Set Virtual Network Gateway Shared Key operation sets the
    * shared key on the virtual network gateway for the specified virtual
    * network connection to the specified local network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Set Shared Key request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginSetSharedKeyAsync(String networkName, String localNetworkName, GatewaySetSharedKeyParameters parameters);
    
    /**
    * The Begin Set Virtual Network Gateway Shared Key V2 operation sets the
    * shared key used between the gateway and customer vpn for the specified
    * site.
    *
    * @param gatewayId Required. The virtual network for this gateway Id.
    * @param connectedentityId Required. The connected entity Id.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Set Shared Key V2 request.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginSetSharedKeyV2(String gatewayId, String connectedentityId, GatewaySetSharedKeyParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Set Virtual Network Gateway Shared Key V2 operation sets the
    * shared key used between the gateway and customer vpn for the specified
    * site.
    *
    * @param gatewayId Required. The virtual network for this gateway Id.
    * @param connectedentityId Required. The connected entity Id.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Set Shared Key V2 request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginSetSharedKeyV2Async(String gatewayId, String connectedentityId, GatewaySetSharedKeyParameters parameters);
    
    /**
    * The Begin Start Diagnostics operation begins an asynchronous operation to
    * starta diagnostics session for the specified virtual network gateway in
    * Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Start
    * Diagnostics operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginStartDiagnostics(String networkName, StartGatewayPublicDiagnosticsParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Start Diagnostics operation begins an asynchronous operation to
    * starta diagnostics session for the specified virtual network gateway in
    * Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Start
    * Diagnostics operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginStartDiagnosticsAsync(String networkName, StartGatewayPublicDiagnosticsParameters parameters);
    
    /**
    * The Begin Start Diagnostics V2 operation begins an asynchronous operation
    * to starta diagnostics session for the specified virtual network gateway.
    *
    * @param gatewayId Required. The virtual network for this gateway Id.
    * @param parameters Required. Parameters supplied to the Begin Start
    * Diagnostics V2 operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginStartDiagnosticsV2(String gatewayId, StartGatewayPublicDiagnosticsParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Begin Start Diagnostics V2 operation begins an asynchronous operation
    * to starta diagnostics session for the specified virtual network gateway.
    *
    * @param gatewayId Required. The virtual network for this gateway Id.
    * @param parameters Required. Parameters supplied to the Begin Start
    * Diagnostics V2 operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginStartDiagnosticsV2Async(String gatewayId, StartGatewayPublicDiagnosticsParameters parameters);
    
    /**
    * Operation to update existing gateway connection.
    *
    * @param gatewayId Required. The virtual network gateway Id.
    * @param connectedentityId Required. The connected entity Id.
    * @param parameters Required. Parameters supplied to the Begin Update
    * gateway conneciton operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse beginUpdateGatewayConnection(String gatewayId, String connectedentityId, UpdateGatewayConnectionParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * Operation to update existing gateway connection.
    *
    * @param gatewayId Required. The virtual network gateway Id.
    * @param connectedentityId Required. The connected entity Id.
    * @param parameters Required. Parameters supplied to the Begin Update
    * gateway conneciton operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> beginUpdateGatewayConnectionAsync(String gatewayId, String connectedentityId, UpdateGatewayConnectionParameters parameters);
    
    /**
    * To connect to, disconnect from, or test your connection to a local
    * network site, access the connection resource representing the local
    * network and specify Connect, Disconnect or Test to perform the desired
    * operation.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154107.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkSiteName Required. The name of the site to connect to.
    * @param parameters Required. Parameters supplied to the Connect Disconnect
    * Or Testing Gateway operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse connectDisconnectOrTest(String networkName, String localNetworkSiteName, GatewayConnectDisconnectOrTestParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * To connect to, disconnect from, or test your connection to a local
    * network site, access the connection resource representing the local
    * network and specify Connect, Disconnect or Test to perform the desired
    * operation.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154107.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkSiteName Required. The name of the site to connect to.
    * @param parameters Required. Parameters supplied to the Connect Disconnect
    * Or Testing Gateway operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> connectDisconnectOrTestAsync(String networkName, String localNetworkSiteName, GatewayConnectDisconnectOrTestParameters parameters);
    
    /**
    * The Create Virtual network Gateway operation creates a new network
    * gateway for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Create Virtual
    * Network Gateway operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse create(String networkName, GatewayCreateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException, ParserConfigurationException, SAXException;
    
    /**
    * The Create Virtual network Gateway operation creates a new network
    * gateway for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Create Virtual
    * Network Gateway operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> createAsync(String networkName, GatewayCreateParameters parameters);
    
    /**
    * The Create Virtual network Gateway Connection operation creates a new
    * network gateway.
    *
    * @param parameters Required. Parameters supplied to the Begin Creating
    * Gateway Connection operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse createGatewayConnection(GatewayConnectionCreateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Create Virtual network Gateway Connection operation creates a new
    * network gateway.
    *
    * @param parameters Required. Parameters supplied to the Begin Creating
    * Gateway Connection operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> createGatewayConnectionAsync(GatewayConnectionCreateParameters parameters);
    
    /**
    * The Create Local network Gateway operation creates a new local network
    * gateway.
    *
    * @param parameters Required. Parameters supplied to Create Local Network
    * Gateway operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The Create Local Network Gateway operation response.
    */
    LocalNetworkGatewayCreateResponse createLocalNetworkGateway(LocalNetworkGatewayCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Create Local network Gateway operation creates a new local network
    * gateway.
    *
    * @param parameters Required. Parameters supplied to Create Local Network
    * Gateway operation.
    * @return The Create Local Network Gateway operation response.
    */
    Future<LocalNetworkGatewayCreateResponse> createLocalNetworkGatewayAsync(LocalNetworkGatewayCreateParameters parameters);
    
    /**
    * The Create Virtual network Gateway operation creates a new network
    * gateway.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Create Virtual
    * Network Gateway operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse createVirtualNetworkGateway(String networkName, VirtualNetworkGatewayCreateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Create Virtual network Gateway operation creates a new network
    * gateway.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Create Virtual
    * Network Gateway operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> createVirtualNetworkGatewayAsync(String networkName, VirtualNetworkGatewayCreateParameters parameters);
    
    /**
    * The Delete Virtual Network Gateway operation deletes a network gateway
    * for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154129.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse delete(String networkName) throws InterruptedException, ExecutionException, ServiceException, IOException, ParserConfigurationException, SAXException;
    
    /**
    * The Delete Virtual Network Gateway operation deletes a network gateway
    * for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154129.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> deleteAsync(String networkName);
    
    /**
    * The Delete Virtual network Gateway Connection operation deletes a network
    * gateway connection.
    *
    * @param gatewayId Required. The virtual network gateway Id.
    * @param connectedentityId Required. The connected entity Id.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse deleteGatewayConnection(String gatewayId, String connectedentityId) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Delete Virtual network Gateway Connection operation deletes a network
    * gateway connection.
    *
    * @param gatewayId Required. The virtual network gateway Id.
    * @param connectedentityId Required. The connected entity Id.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> deleteGatewayConnectionAsync(String gatewayId, String connectedentityId);
    
    /**
    * The Delete Local Network Gateway operation deletes a local network gateway
    *
    * @param gatewayId Required. The local network gateway id.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse deleteLocalNetworkGateway(String gatewayId) throws IOException, ServiceException;
    
    /**
    * The Delete Local Network Gateway operation deletes a local network gateway
    *
    * @param gatewayId Required. The local network gateway id.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteLocalNetworkGatewayAsync(String gatewayId);
    
    /**
    * The Delete Virtual Network Gateway operation deletes a network gateway
    *
    * @param gatewayId Required. The virtual network gateway id.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse deleteVirtualNetworkGateway(String gatewayId) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Delete Virtual Network Gateway operation deletes a network gateway
    *
    * @param gatewayId Required. The virtual network gateway id.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> deleteVirtualNetworkGatewayAsync(String gatewayId);
    
    /**
    * The Failover Virtual Network Gateway operation causes a network gateway
    * failover for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154118.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network in Azure.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse failover(String networkName) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Failover Virtual Network Gateway operation causes a network gateway
    * failover for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154118.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network in Azure.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> failoverAsync(String networkName);
    
    /**
    * The Generate VPN Client Package operation creates a VPN client package
    * for the specified virtual network and gateway in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Generate VPN
    * Client Package operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse generateVpnClientPackage(String networkName, GatewayGenerateVpnClientPackageParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Generate VPN Client Package operation creates a VPN client package
    * for the specified virtual network and gateway in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Generate VPN
    * Client Package operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> generateVpnClientPackageAsync(String networkName, GatewayGenerateVpnClientPackageParameters parameters);
    
    /**
    * The Get Virtual Network Gateway operation gets information about the
    * network gateway for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154109.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayGetResponse get(String networkName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Get Virtual Network Gateway operation gets information about the
    * network gateway for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154109.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayGetResponse> getAsync(String networkName);
    
    /**
    * The Get Device Configuration Script operation returns a script that you
    * can use to configure local VPN devices to connect to the gateway.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154115.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. The parameters for the Get Device
    * Configuration Script operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The configuration script returned from the get device
    * configuration script operation.
    */
    GatewayGetDeviceConfigurationScriptResponse getDeviceConfigurationScript(String networkName, GatewayGetDeviceConfigurationScriptParameters parameters) throws IOException, ServiceException;
    
    /**
    * The Get Device Configuration Script operation returns a script that you
    * can use to configure local VPN devices to connect to the gateway.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154115.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. The parameters for the Get Device
    * Configuration Script operation.
    * @return The configuration script returned from the get device
    * configuration script operation.
    */
    Future<GatewayGetDeviceConfigurationScriptResponse> getDeviceConfigurationScriptAsync(String networkName, GatewayGetDeviceConfigurationScriptParameters parameters);
    
    /**
    * The Get Diagnostics operation gets information about the current gateway
    * diagnostics session for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The status of a gateway diagnostics operation.
    */
    GatewayDiagnosticsStatus getDiagnostics(String networkName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Get Diagnostics operation gets information about the current gateway
    * diagnostics session for the specified virtual network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @return The status of a gateway diagnostics operation.
    */
    Future<GatewayDiagnosticsStatus> getDiagnosticsAsync(String networkName);
    
    /**
    * The Get Diagnostics V2 operation gets information about the current
    * virtual network gateway diagnostics session
    *
    * @param gatewayId Required. The virtual network gateway Id.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The status of a gateway diagnostics operation.
    */
    GatewayDiagnosticsStatus getDiagnosticsV2(String gatewayId) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Get Diagnostics V2 operation gets information about the current
    * virtual network gateway diagnostics session
    *
    * @param gatewayId Required. The virtual network gateway Id.
    * @return The status of a gateway diagnostics operation.
    */
    Future<GatewayDiagnosticsStatus> getDiagnosticsV2Async(String gatewayId);
    
    /**
    * The Get Virtual Network Gateway Connection operation gets information
    * about the virtual network gateway connection.
    *
    * @param gatewayId Required. The virtual network gateway id.
    * @param connectedentityId Required. The virtual network gateway connected
    * entity Id.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayConnectionGetResponse getGatewayConnection(String gatewayId, String connectedentityId) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Get Virtual Network Gateway Connection operation gets information
    * about the virtual network gateway connection.
    *
    * @param gatewayId Required. The virtual network gateway id.
    * @param connectedentityId Required. The virtual network gateway connected
    * entity Id.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayConnectionGetResponse> getGatewayConnectionAsync(String gatewayId, String connectedentityId);
    
    /**
    * The Get IPsec Parameters operation gets the IPsec parameters that have
    * been set for the connection between the provided virtual network gateway
    * and the provided local network site.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response that will be returned from a GetIPsecParameters
    * request. This contains the IPsec parameters for the specified connection.
    */
    GatewayGetIPsecParametersResponse getIPsecParameters(String networkName, String localNetworkName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Get IPsec Parameters operation gets the IPsec parameters that have
    * been set for the connection between the provided virtual network gateway
    * and the provided local network site.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @return The response that will be returned from a GetIPsecParameters
    * request. This contains the IPsec parameters for the specified connection.
    */
    Future<GatewayGetIPsecParametersResponse> getIPsecParametersAsync(String networkName, String localNetworkName);
    
    /**
    * The Get IPsec Parameters V2 operation gets the IPsec parameters that have
    * been set for the virtual network gateway  connection
    *
    * @param gatewayId Required. The virtual network for this gateway Id.
    * @param connectedentityId Required. The connected entity Id.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response that will be returned from a GetIPsecParameters
    * request. This contains the IPsec parameters for the specified connection.
    */
    GatewayGetIPsecParametersResponse getIPsecParametersV2(String gatewayId, String connectedentityId) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Get IPsec Parameters V2 operation gets the IPsec parameters that have
    * been set for the virtual network gateway  connection
    *
    * @param gatewayId Required. The virtual network for this gateway Id.
    * @param connectedentityId Required. The connected entity Id.
    * @return The response that will be returned from a GetIPsecParameters
    * request. This contains the IPsec parameters for the specified connection.
    */
    Future<GatewayGetIPsecParametersResponse> getIPsecParametersV2Async(String gatewayId, String connectedentityId);
    
    /**
    * The Get Local Network Gateway operation gets information about the local
    * network gateway
    *
    * @param gatewayId Required. The local network gateway id.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    LocalNetworkGatewayGetResponse getLocalNetworkGateway(String gatewayId) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Get Local Network Gateway operation gets information about the local
    * network gateway
    *
    * @param gatewayId Required. The local network gateway id.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<LocalNetworkGatewayGetResponse> getLocalNetworkGatewayAsync(String gatewayId);
    
    /**
    * The Get Virtual Network Gateway Operation Status gets information on the
    * status of network gateway operations in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154112.aspx for
    * more information)
    *
    * @param operationId Required. The ID of the network operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse getOperationStatus(String operationId) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Get Virtual Network Gateway Operation Status gets information on the
    * status of network gateway operations in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154112.aspx for
    * more information)
    *
    * @param operationId Required. The ID of the network operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> getOperationStatusAsync(String operationId);
    
    /**
    * The Get Virtual Network Gateway Shared Key operation gets the shared key
    * on the virtual network gateway for the specified virtual network
    * connection to the specified local network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154122.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response to the get shared key request.
    */
    GatewayGetSharedKeyResponse getSharedKey(String networkName, String localNetworkName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Get Virtual Network Gateway Shared Key operation gets the shared key
    * on the virtual network gateway for the specified virtual network
    * connection to the specified local network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154122.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @return The response to the get shared key request.
    */
    Future<GatewayGetSharedKeyResponse> getSharedKeyAsync(String networkName, String localNetworkName);
    
    /**
    * The Get Virtual Network Gateway Shared Key V2 operation gets the shared
    * key used between the gateway and customer vpn.
    *
    * @param gatewayId Required. The virtual network for this gateway Id.
    * @param connectedentityId Required. The connected entity Id.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response to the get shared key request.
    */
    GatewayGetSharedKeyResponse getSharedKeyV2(String gatewayId, String connectedentityId) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Get Virtual Network Gateway Shared Key V2 operation gets the shared
    * key used between the gateway and customer vpn.
    *
    * @param gatewayId Required. The virtual network for this gateway Id.
    * @param connectedentityId Required. The connected entity Id.
    * @return The response to the get shared key request.
    */
    Future<GatewayGetSharedKeyResponse> getSharedKeyV2Async(String gatewayId, String connectedentityId);
    
    /**
    * The Get Virtual Network Gateway operation gets information about the
    * virtual network gateway
    *
    * @param gatewayId Required. The virtual network gateway id.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    VirtualNetworkGatewayGetResponse getVirtualNetworkGateway(String gatewayId) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Get Virtual Network Gateway operation gets information about the
    * virtual network gateway
    *
    * @param gatewayId Required. The virtual network gateway id.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<VirtualNetworkGatewayGetResponse> getVirtualNetworkGatewayAsync(String gatewayId);
    
    /**
    * The List Connections operation returns a list of the local network
    * connections that can be accessed through the gateway.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154120.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response to a ListConnections request to a Virtual Network
    * Gateway.
    */
    GatewayListConnectionsResponse listConnections(String networkName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The List Connections operation returns a list of the local network
    * connections that can be accessed through the gateway.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154120.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @return The response to a ListConnections request to a Virtual Network
    * Gateway.
    */
    Future<GatewayListConnectionsResponse> listConnectionsAsync(String networkName);
    
    /**
    * The List Connections operation Lists all GatewayConnections.
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response to a ListGatewayConnections request to a Virtual
    * Network Gateway.
    */
    GatewayListGatewayConnectionsResponse listGatewayConnections() throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The List Connections operation Lists all GatewayConnections.
    *
    * @return The response to a ListGatewayConnections request to a Virtual
    * Network Gateway.
    */
    Future<GatewayListGatewayConnectionsResponse> listGatewayConnectionsAsync();
    
    /**
    * The List Local network gateways operation returns a list of the local
    * network gateways.
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response to a ListLocalNetworkGateways request.
    */
    ListLocalNetworkGatewaysResponse listLocalNetworkGateways() throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The List Local network gateways operation returns a list of the local
    * network gateways.
    *
    * @return The response to a ListLocalNetworkGateways request.
    */
    Future<ListLocalNetworkGatewaysResponse> listLocalNetworkGatewaysAsync();
    
    /**
    * The List Virtual Network Gateway Supported Devices operation lists the
    * supported, on-premise network devices that can connect to the gateway.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj154102.aspx
    * for more information)
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response to the list supported devices request.
    */
    GatewayListSupportedDevicesResponse listSupportedDevices() throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The List Virtual Network Gateway Supported Devices operation lists the
    * supported, on-premise network devices that can connect to the gateway.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj154102.aspx
    * for more information)
    *
    * @return The response to the list supported devices request.
    */
    Future<GatewayListSupportedDevicesResponse> listSupportedDevicesAsync();
    
    /**
    * The List Virtual network gateways operation returns a list of the virtual
    * network gateways.
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response to a ListVirtualNetworkGateways request.
    */
    ListVirtualNetworkGatewaysResponse listVirtualNetworkGateways() throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The List Virtual network gateways operation returns a list of the virtual
    * network gateways.
    *
    * @return The response to a ListVirtualNetworkGateways request.
    */
    Future<ListVirtualNetworkGatewaysResponse> listVirtualNetworkGatewaysAsync();
    
    /**
    * The Remove Virtual Network Gateway Shared Key operation sets the default
    * sites on the virtual network gateway for the specified virtual network.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse removeDefaultSites(String networkName) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Remove Virtual Network Gateway Shared Key operation sets the default
    * sites on the virtual network gateway for the specified virtual network.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> removeDefaultSitesAsync(String networkName);
    
    /**
    * The Begin Reset Virtual network Gateway operation resets an existing
    * gateway.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Reset Virtual
    * Network Gateway operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse reset(String networkName, ResetGatewayParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Begin Reset Virtual network Gateway operation resets an existing
    * gateway.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Reset Virtual
    * Network Gateway operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> resetAsync(String networkName, ResetGatewayParameters parameters);
    
    /**
    * The Reset Virtual Network Gateway Shared Key operation resets the shared
    * key on the virtual network gateway for the specified virtual network
    * connection to the specified local network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @param parameters Required. The parameters to the Virtual Network Gateway
    * Reset Shared Key request.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse resetSharedKey(String networkName, String localNetworkName, GatewayResetSharedKeyParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Reset Virtual Network Gateway Shared Key operation resets the shared
    * key on the virtual network gateway for the specified virtual network
    * connection to the specified local network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @param parameters Required. The parameters to the Virtual Network Gateway
    * Reset Shared Key request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> resetSharedKeyAsync(String networkName, String localNetworkName, GatewayResetSharedKeyParameters parameters);
    
    /**
    * The Reset Virtual Network Gateway Shared Key V2 operation resets the
    * shared key used between the gateway and customer vpn.
    *
    * @param gatewayId Required. The virtual network for this gateway Id.
    * @param connectedentityId Required. The connected entity Id.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Reset Shared Key request.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse resetSharedKeyV2(String gatewayId, String connectedentityId, GatewayResetSharedKeyParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Reset Virtual Network Gateway Shared Key V2 operation resets the
    * shared key used between the gateway and customer vpn.
    *
    * @param gatewayId Required. The virtual network for this gateway Id.
    * @param connectedentityId Required. The connected entity Id.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Reset Shared Key request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> resetSharedKeyV2Async(String gatewayId, String connectedentityId, GatewayResetSharedKeyParameters parameters);
    
    /**
    * The Begin Reset Virtual network Gateway operation resets an existing
    * gateway.
    *
    * @param gatewayId Required. The virtual network for this gateway.
    * @param parameters Required. Parameters supplied to the Reset Virtual
    * Network Gateway operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse resetVirtualNetworkGateway(String gatewayId, ResetGatewayParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Begin Reset Virtual network Gateway operation resets an existing
    * gateway.
    *
    * @param gatewayId Required. The virtual network for this gateway.
    * @param parameters Required. Parameters supplied to the Reset Virtual
    * Network Gateway operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> resetVirtualNetworkGatewayAsync(String gatewayId, ResetGatewayParameters parameters);
    
    /**
    * The Begin Resize Virtual network Gateway operation resizes an existing
    * gateway to a different GatewaySKU.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Resize Virtual
    * Network Gateway operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse resize(String networkName, ResizeGatewayParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Begin Resize Virtual network Gateway operation resizes an existing
    * gateway to a different GatewaySKU.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Resize Virtual
    * Network Gateway operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> resizeAsync(String networkName, ResizeGatewayParameters parameters);
    
    /**
    * The Begin Resize Virtual network Gateway operation resizes an existing
    * gateway to a different GatewaySKU.
    *
    * @param gatewayId Required. The virtual network for this gateway id.
    * @param parameters Required. Parameters supplied to the Resize Virtual
    * Network Gateway operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse resizeVirtualNetworkGateway(String gatewayId, ResizeGatewayParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Begin Resize Virtual network Gateway operation resizes an existing
    * gateway to a different GatewaySKU.
    *
    * @param gatewayId Required. The virtual network for this gateway id.
    * @param parameters Required. Parameters supplied to the Resize Virtual
    * Network Gateway operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> resizeVirtualNetworkGatewayAsync(String gatewayId, ResizeGatewayParameters parameters);
    
    /**
    * The Set Virtual Network Gateway Shared Key operation sets the default
    * sites on the virtual network gateway for the specified virtual network.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Set Default Sites request.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse setDefaultSites(String networkName, GatewaySetDefaultSiteListParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Set Virtual Network Gateway Shared Key operation sets the default
    * sites on the virtual network gateway for the specified virtual network.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Set Default Sites request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> setDefaultSitesAsync(String networkName, GatewaySetDefaultSiteListParameters parameters);
    
    /**
    * The Begin Set Virtual Network Gateway IPsec Parameters operation sets the
    * IPsec parameters on the virtual network gateway for the specified
    * connection to the specified local network in Azure.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Set IPsec Parameters request.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse setIPsecParameters(String networkName, String localNetworkName, GatewaySetIPsecParametersParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Begin Set Virtual Network Gateway IPsec Parameters operation sets the
    * IPsec parameters on the virtual network gateway for the specified
    * connection to the specified local network in Azure.
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Set IPsec Parameters request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> setIPsecParametersAsync(String networkName, String localNetworkName, GatewaySetIPsecParametersParameters parameters);
    
    /**
    * The Begin Set Virtual Network Gateway IPsec Parameters V2 operation sets
    * the IPsec parameters on the virtual network gateway connection.
    *
    * @param gatewayId Required. The virtual network for this gateway Id.
    * @param connectedentityId Required. The connected entity Id.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Set IPsec Parameters V2 request.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse setIPsecParametersV2(String gatewayId, String connectedentityId, GatewaySetIPsecParametersParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Begin Set Virtual Network Gateway IPsec Parameters V2 operation sets
    * the IPsec parameters on the virtual network gateway connection.
    *
    * @param gatewayId Required. The virtual network for this gateway Id.
    * @param connectedentityId Required. The connected entity Id.
    * @param parameters Required. Parameters supplied to the Begin Virtual
    * Network Gateway Set IPsec Parameters V2 request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> setIPsecParametersV2Async(String gatewayId, String connectedentityId, GatewaySetIPsecParametersParameters parameters);
    
    /**
    * The Set Virtual Network Gateway Shared Key operation sets the shared key
    * on the virtual network gateway for the specified virtual network
    * connection to the specified local network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @param parameters Required. The parameters to the Virtual Network Gateway
    * Set Shared Key request.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse setSharedKey(String networkName, String localNetworkName, GatewaySetSharedKeyParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Set Virtual Network Gateway Shared Key operation sets the shared key
    * on the virtual network gateway for the specified virtual network
    * connection to the specified local network in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154114.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param localNetworkName Required. The name of the local network.
    * @param parameters Required. The parameters to the Virtual Network Gateway
    * Set Shared Key request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> setSharedKeyAsync(String networkName, String localNetworkName, GatewaySetSharedKeyParameters parameters);
    
    /**
    * The Set Virtual Network Gateway Shared Key V2 operation sets the shared
    * key used between the gateway and customer vpn for the specified site.
    *
    * @param gatewayId Required. The virtual network for this gateway Id.
    * @param connectedentityId Required. The connected entity Id.
    * @param parameters Required. Parameters supplied to Virtual Network
    * Gateway Set Shared Key V2 request.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse setSharedKeyV2(String gatewayId, String connectedentityId, GatewaySetSharedKeyParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Set Virtual Network Gateway Shared Key V2 operation sets the shared
    * key used between the gateway and customer vpn for the specified site.
    *
    * @param gatewayId Required. The virtual network for this gateway Id.
    * @param connectedentityId Required. The connected entity Id.
    * @param parameters Required. Parameters supplied to Virtual Network
    * Gateway Set Shared Key V2 request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> setSharedKeyV2Async(String gatewayId, String connectedentityId, GatewaySetSharedKeyParameters parameters);
    
    /**
    * The Start Diagnostics operation starts a diagnostics session for the
    * specified virtual network gateway in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Start Diagnostics
    * operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse startDiagnostics(String networkName, StartGatewayPublicDiagnosticsParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Start Diagnostics operation starts a diagnostics session for the
    * specified virtual network gateway in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx for
    * more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to the Start Diagnostics
    * operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> startDiagnosticsAsync(String networkName, StartGatewayPublicDiagnosticsParameters parameters);
    
    /**
    * The Start Diagnostics V2 operation starts a diagnostics session for the
    * specified virtual network gateway.
    *
    * @param gatewayId Required. The virtual network for this gateway Id.
    * @param parameters Required. Parameters supplied to the Start Diagnostics
    * V2 operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse startDiagnosticsV2(String gatewayId, StartGatewayPublicDiagnosticsParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Start Diagnostics V2 operation starts a diagnostics session for the
    * specified virtual network gateway.
    *
    * @param gatewayId Required. The virtual network for this gateway Id.
    * @param parameters Required. Parameters supplied to the Start Diagnostics
    * V2 operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> startDiagnosticsV2Async(String gatewayId, StartGatewayPublicDiagnosticsParameters parameters);
    
    /**
    * The Stop Diagnostics operation begins an asynchronous operation to stopa
    * diagnostics session for the specified virtual network gateway in Azure.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx
    * for more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to Stop Diagnostics
    * operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse stopDiagnostics(String networkName, StopGatewayPublicDiagnosticsParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Stop Diagnostics operation begins an asynchronous operation to stopa
    * diagnostics session for the specified virtual network gateway in Azure.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/jj154119.aspx
    * for more information)
    *
    * @param networkName Required. The name of the virtual network for this
    * gateway.
    * @param parameters Required. Parameters supplied to Stop Diagnostics
    * operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> stopDiagnosticsAsync(String networkName, StopGatewayPublicDiagnosticsParameters parameters);
    
    /**
    * The Stop Diagnostics V2 operation begins an asynchronous operation to
    * stopa diagnostics session for the specified virtual network gateway.
    *
    * @param gatewayId Required. The virtual network for this gateway Id.
    * @param parameters Required. Parameters supplied to Stop Diagnostics V2
    * operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    GatewayOperationResponse stopDiagnosticsV2(String gatewayId, StopGatewayPublicDiagnosticsParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Stop Diagnostics V2 operation begins an asynchronous operation to
    * stopa diagnostics session for the specified virtual network gateway.
    *
    * @param gatewayId Required. The virtual network for this gateway Id.
    * @param parameters Required. Parameters supplied to Stop Diagnostics V2
    * operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<GatewayOperationResponse> stopDiagnosticsV2Async(String gatewayId, StopGatewayPublicDiagnosticsParameters parameters);
    
    /**
    * Operation to update existing gateway connection.
    *
    * @param gatewayId Required. The virtual network gateway Id.
    * @param connectedentityId Required. The connected entity Id.
    * @param parameters Required. Parameters supplied to the Begin Update
    * gateway conneciton operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    GatewayGetOperationStatusResponse updateGatewayConnection(String gatewayId, String connectedentityId, UpdateGatewayConnectionParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * Operation to update existing gateway connection.
    *
    * @param gatewayId Required. The virtual network gateway Id.
    * @param connectedentityId Required. The connected entity Id.
    * @param parameters Required. Parameters supplied to the Begin Update
    * gateway conneciton operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is in
    * progress, or has failed. Note that this status is distinct from the HTTP
    * status code returned for the Get Operation Status operation itself. If
    * the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<GatewayGetOperationStatusResponse> updateGatewayConnectionAsync(String gatewayId, String connectedentityId, UpdateGatewayConnectionParameters parameters);
    
    /**
    * The Update Local Network Gateway operation updates a local network gateway
    *
    * @param gatewayId Required. The virtual network for this gateway.
    * @param parameters Required. Parameters supplied to update the Local
    * Network Gateway operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse updateLocalNetworkGateway(String gatewayId, UpdateLocalNetworkGatewayParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * The Update Local Network Gateway operation updates a local network gateway
    *
    * @param gatewayId Required. The virtual network for this gateway.
    * @param parameters Required. Parameters supplied to update the Local
    * Network Gateway operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> updateLocalNetworkGatewayAsync(String gatewayId, UpdateLocalNetworkGatewayParameters parameters);
}
