/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.network;

import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.network.models.IPForwardingGetResponse;
import com.microsoft.windowsazure.management.network.models.IPForwardingSetParameters;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Network Management API includes operations for managing the IP Forwarding
* for your roles and network interfaces in your subscription.
*/
public interface IPForwardingOperations {
    /**
    * Sets IP Forwarding on a network interface.
    *
    * @param serviceName Required.
    * @param deploymentName Required.
    * @param roleName Required.
    * @param networkInterfaceName Required.
    * @param parameters Required. Parameters supplied to the Set IP Forwarding
    * on network interface operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    OperationStatusResponse beginSettingIPForwardingOnNetworkInterface(String serviceName, String deploymentName, String roleName, String networkInterfaceName, IPForwardingSetParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * Sets IP Forwarding on a network interface.
    *
    * @param serviceName Required.
    * @param deploymentName Required.
    * @param roleName Required.
    * @param networkInterfaceName Required.
    * @param parameters Required. Parameters supplied to the Set IP Forwarding
    * on network interface operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<OperationStatusResponse> beginSettingIPForwardingOnNetworkInterfaceAsync(String serviceName, String deploymentName, String roleName, String networkInterfaceName, IPForwardingSetParameters parameters);
    
    /**
    * Sets IP Forwarding on a role.
    *
    * @param serviceName Required.
    * @param deploymentName Required.
    * @param roleName Required.
    * @param parameters Required. Parameters supplied to the Set IP Forwarding
    * on role operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    OperationStatusResponse beginSettingIPForwardingOnRole(String serviceName, String deploymentName, String roleName, IPForwardingSetParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * Sets IP Forwarding on a role.
    *
    * @param serviceName Required.
    * @param deploymentName Required.
    * @param roleName Required.
    * @param parameters Required. Parameters supplied to the Set IP Forwarding
    * on role operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<OperationStatusResponse> beginSettingIPForwardingOnRoleAsync(String serviceName, String deploymentName, String roleName, IPForwardingSetParameters parameters);
    
    /**
    * Gets the IP Forwarding applied to a network interface.
    *
    * @param serviceName Required.
    * @param deploymentName Required.
    * @param roleName Required.
    * @param networkInterfaceName Required.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The IP Forwarding state associated with a role or network
    * interface.
    */
    IPForwardingGetResponse getForNetworkInterface(String serviceName, String deploymentName, String roleName, String networkInterfaceName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * Gets the IP Forwarding applied to a network interface.
    *
    * @param serviceName Required.
    * @param deploymentName Required.
    * @param roleName Required.
    * @param networkInterfaceName Required.
    * @return The IP Forwarding state associated with a role or network
    * interface.
    */
    Future<IPForwardingGetResponse> getForNetworkInterfaceAsync(String serviceName, String deploymentName, String roleName, String networkInterfaceName);
    
    /**
    * Gets the IP Forwarding applied to a role.
    *
    * @param serviceName Required.
    * @param deploymentName Required.
    * @param roleName Required.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The IP Forwarding state associated with a role or network
    * interface.
    */
    IPForwardingGetResponse getForRole(String serviceName, String deploymentName, String roleName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * Gets the IP Forwarding applied to a role.
    *
    * @param serviceName Required.
    * @param deploymentName Required.
    * @param roleName Required.
    * @return The IP Forwarding state associated with a role or network
    * interface.
    */
    Future<IPForwardingGetResponse> getForRoleAsync(String serviceName, String deploymentName, String roleName);
    
    /**
    * Sets IP Forwarding on a network interface.
    *
    * @param serviceName Required.
    * @param deploymentName Required.
    * @param roleName Required.
    * @param networkInterfaceName Required.
    * @param parameters Required. Parameters supplied to the Set IP Forwarding
    * on network interface operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    OperationStatusResponse setOnNetworkInterface(String serviceName, String deploymentName, String roleName, String networkInterfaceName, IPForwardingSetParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * Sets IP Forwarding on a network interface.
    *
    * @param serviceName Required.
    * @param deploymentName Required.
    * @param roleName Required.
    * @param networkInterfaceName Required.
    * @param parameters Required. Parameters supplied to the Set IP Forwarding
    * on network interface operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<OperationStatusResponse> setOnNetworkInterfaceAsync(String serviceName, String deploymentName, String roleName, String networkInterfaceName, IPForwardingSetParameters parameters);
    
    /**
    * Sets IP Forwarding on a role.
    *
    * @param serviceName Required.
    * @param deploymentName Required.
    * @param roleName Required.
    * @param parameters Required. Parameters supplied to the Set IP Forwarding
    * on role operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    OperationStatusResponse setOnRole(String serviceName, String deploymentName, String roleName, IPForwardingSetParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * Sets IP Forwarding on a role.
    *
    * @param serviceName Required.
    * @param deploymentName Required.
    * @param roleName Required.
    * @param parameters Required. Parameters supplied to the Set IP Forwarding
    * on role operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<OperationStatusResponse> setOnRoleAsync(String serviceName, String deploymentName, String roleName, IPForwardingSetParameters parameters);
}
