/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.network;

import com.microsoft.windowsazure.core.FilterableService;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.credentials.SubscriptionCloudCredentials;
import com.microsoft.windowsazure.exception.ServiceException;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Future;

/**
* The Service Management API includes operations for managing the virtual
* networks for your subscription.  (see
* http://msdn.microsoft.com/en-us/library/windowsazure/jj157182.aspx for more
* information)
*/
public interface NetworkManagementClient extends Closeable, FilterableService<NetworkManagementClient> {
    /**
    * Gets the API version.
    * @return The ApiVersion value.
    */
    String getApiVersion();
    
    /**
    * Gets the URI used as the base for all cloud service requests.
    * @return The BaseUri value.
    */
    URI getBaseUri();
    
    /**
    * Gets subscription credentials which uniquely identify Microsoft Azure
    * subscription. The subscription ID forms part of the URI for every
    * service call.
    * @return The Credentials value.
    */
    SubscriptionCloudCredentials getCredentials();
    
    /**
    * Gets or sets the initial timeout for Long Running Operations.
    * @return The LongRunningOperationInitialTimeout value.
    */
    int getLongRunningOperationInitialTimeout();
    
    /**
    * Gets or sets the initial timeout for Long Running Operations.
    * @param longRunningOperationInitialTimeoutValue The
    * LongRunningOperationInitialTimeout value.
    */
    void setLongRunningOperationInitialTimeout(final int longRunningOperationInitialTimeoutValue);
    /**
    * Gets or sets the retry timeout for Long Running Operations.
    * @return The LongRunningOperationRetryTimeout value.
    */
    int getLongRunningOperationRetryTimeout();
    
    /**
    * Gets or sets the retry timeout for Long Running Operations.
    * @param longRunningOperationRetryTimeoutValue The
    * LongRunningOperationRetryTimeout value.
    */
    void setLongRunningOperationRetryTimeout(final int longRunningOperationRetryTimeoutValue);
    /**
    * The Application Gateway Management API includes operations for managing
    * application gateways in your subscription.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154113.aspx for
    * more information)
    * @return The ApplicationGatewaysOperations value.
    */
    ApplicationGatewayOperations getApplicationGatewaysOperations();
    
    /**
    * The Network Management API includes operations for managing the client
    * root certificates for your subscription.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154113.aspx for
    * more information)
    * @return The ClientRootCertificatesOperations value.
    */
    ClientRootCertificateOperations getClientRootCertificatesOperations();
    
    /**
    * The Network Management API includes operations for managing the gateways
    * for your subscription.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154113.aspx for
    * more information)
    * @return The GatewaysOperations value.
    */
    GatewayOperations getGatewaysOperations();
    
    /**
    * The Network Management API includes operations for managing the IP
    * Forwarding for your roles and network interfaces in your subscription.
    * @return The IPForwardingOperations value.
    */
    IPForwardingOperations getIPForwardingOperations();
    
    /**
    * The Network Management API includes operations for managing the virtual
    * networks for your subscription.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj157182.aspx for
    * more information)
    * @return The NetworksOperations value.
    */
    NetworkOperations getNetworksOperations();
    
    /**
    * The Network Management API includes operations for managing the Network
    * Security Groups for your subscription.
    * @return The NetworkSecurityGroupsOperations value.
    */
    NetworkSecurityGroupOperations getNetworkSecurityGroupsOperations();
    
    /**
    * The Network Management API includes operations for managing the reserved
    * IPs for your subscription.
    * @return The ReservedIPsOperations value.
    */
    ReservedIPOperations getReservedIPsOperations();
    
    /**
    * The Network Management API includes operations for managing the routes
    * for your subscription.
    * @return The RoutesOperations value.
    */
    RouteOperations getRoutesOperations();
    
    /**
    * The Network Management API includes operations for managing the static
    * IPs for your subscription.
    * @return The StaticIPsOperations value.
    */
    StaticIPOperations getStaticIPsOperations();
    
    /**
    * The Network Management API includes operations for managing the Virtual
    * IPs for your deployment.
    * @return The VirtualIPsOperations value.
    */
    VirtualIPOperations getVirtualIPsOperations();
    
    /**
    * The Get Operation Status operation returns the status of the specified
    * operation. After calling an asynchronous operation, you can call Get
    * Operation Status to determine whether the operation has succeeded,
    * failed, or is still in progress.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460783.aspx for
    * more information)
    *
    * @param requestId Required. The request ID for the request you wish to
    * track. The request ID is returned in the x-ms-request-id response header
    * for every request.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    OperationStatusResponse getOperationStatus(String requestId) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The Get Operation Status operation returns the status of the specified
    * operation. After calling an asynchronous operation, you can call Get
    * Operation Status to determine whether the operation has succeeded,
    * failed, or is still in progress.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460783.aspx for
    * more information)
    *
    * @param requestId Required. The request ID for the request you wish to
    * track. The request ID is returned in the x-ms-request-id response header
    * for every request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<OperationStatusResponse> getOperationStatusAsync(String requestId);
}
