/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.network;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.CloudError;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.network.models.AddRouteTableToSubnetParameters;
import com.microsoft.windowsazure.management.network.models.CreateRouteTableParameters;
import com.microsoft.windowsazure.management.network.models.EffectiveNextHop;
import com.microsoft.windowsazure.management.network.models.EffectiveRoute;
import com.microsoft.windowsazure.management.network.models.EffectiveRouteTable;
import com.microsoft.windowsazure.management.network.models.GetEffectiveRouteTableResponse;
import com.microsoft.windowsazure.management.network.models.GetRouteTableForSubnetResponse;
import com.microsoft.windowsazure.management.network.models.GetRouteTableResponse;
import com.microsoft.windowsazure.management.network.models.ListRouteTablesResponse;
import com.microsoft.windowsazure.management.network.models.NextHop;
import com.microsoft.windowsazure.management.network.models.Route;
import com.microsoft.windowsazure.management.network.models.RouteState;
import com.microsoft.windowsazure.management.network.models.RouteTable;
import com.microsoft.windowsazure.management.network.models.RouteTableState;
import com.microsoft.windowsazure.management.network.models.SetRouteParameters;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Network Management API includes operations for managing the routes for
* your subscription.
*/
public class RouteOperationsImpl implements ServiceOperations<NetworkManagementClientImpl>, RouteOperations {
    /**
    * Initializes a new instance of the RouteOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    RouteOperationsImpl(NetworkManagementClientImpl client) {
        this.client = client;
    }
    
    private NetworkManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.windowsazure.management.network.NetworkManagementClientImpl.
    * @return The Client value.
    */
    public NetworkManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Set the specified route table for the provided subnet in the provided
    * virtual network in this subscription.
    *
    * @param vnetName Required. The name of the virtual network that contains
    * the provided subnet.
    * @param subnetName Required. The name of the subnet that the route table
    * will be added to.
    * @param parameters Required. The parameters necessary to add a route table
    * to the provided subnet.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    @Override
    public Future<OperationStatusResponse> addRouteTableToSubnetAsync(final String vnetName, final String subnetName, final AddRouteTableToSubnetParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return addRouteTableToSubnet(vnetName, subnetName, parameters);
            }
         });
    }
    
    /**
    * Set the specified route table for the provided subnet in the provided
    * virtual network in this subscription.
    *
    * @param vnetName Required. The name of the virtual network that contains
    * the provided subnet.
    * @param subnetName Required. The name of the subnet that the route table
    * will be added to.
    * @param parameters Required. The parameters necessary to add a route table
    * to the provided subnet.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    @Override
    public OperationStatusResponse addRouteTableToSubnet(String vnetName, String subnetName, AddRouteTableToSubnetParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("vnetName", vnetName);
            tracingParameters.put("subnetName", subnetName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "addRouteTableToSubnetAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getRoutesOperations().beginAddRouteTableToSubnetAsync(vnetName, subnetName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * Set the specified route table for the provided subnet in the provided
    * virtual network in this subscription.
    *
    * @param vnetName Required. The name of the virtual network that contains
    * the provided subnet.
    * @param subnetName Required. The name of the subnet that the route table
    * will be added to.
    * @param parameters Required. The parameters necessary to add a route table
    * to the provided subnet.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginAddRouteTableToSubnetAsync(final String vnetName, final String subnetName, final AddRouteTableToSubnetParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginAddRouteTableToSubnet(vnetName, subnetName, parameters);
            }
         });
    }
    
    /**
    * Set the specified route table for the provided subnet in the provided
    * virtual network in this subscription.
    *
    * @param vnetName Required. The name of the virtual network that contains
    * the provided subnet.
    * @param subnetName Required. The name of the subnet that the route table
    * will be added to.
    * @param parameters Required. The parameters necessary to add a route table
    * to the provided subnet.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginAddRouteTableToSubnet(String vnetName, String subnetName, AddRouteTableToSubnetParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (vnetName == null) {
            throw new NullPointerException("vnetName");
        }
        if (subnetName == null) {
            throw new NullPointerException("subnetName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("vnetName", vnetName);
            tracingParameters.put("subnetName", subnetName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginAddRouteTableToSubnetAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/networking/virtualnetwork/";
        url = url + URLEncoder.encode(vnetName, "UTF-8");
        url = url + "/subnets/";
        url = url + URLEncoder.encode(subnetName, "UTF-8");
        url = url + "/routetables";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element routeTableAssociationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RouteTableAssociation");
        requestDoc.appendChild(routeTableAssociationElement);
        
        if (parameters.getRouteTableName() != null) {
            Element routeTableNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RouteTableName");
            routeTableNameElement.appendChild(requestDoc.createTextNode(parameters.getRouteTableName()));
            routeTableAssociationElement.appendChild(routeTableNameElement);
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Create the specified route table for this subscription.
    *
    * @param parameters Required. The parameters necessary to create a new
    * route table.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginCreateRouteTableAsync(final CreateRouteTableParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginCreateRouteTable(parameters);
            }
         });
    }
    
    /**
    * Create the specified route table for this subscription.
    *
    * @param parameters Required. The parameters necessary to create a new
    * route table.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginCreateRouteTable(CreateRouteTableParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginCreateRouteTableAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/networking/routetables";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element routeTableElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RouteTable");
        requestDoc.appendChild(routeTableElement);
        
        if (parameters.getName() != null) {
            Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
            nameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
            routeTableElement.appendChild(nameElement);
        }
        
        if (parameters.getLabel() != null) {
            Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
            labelElement.appendChild(requestDoc.createTextNode(parameters.getLabel()));
            routeTableElement.appendChild(labelElement);
        }
        
        if (parameters.getLocation() != null) {
            Element locationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Location");
            locationElement.appendChild(requestDoc.createTextNode(parameters.getLocation()));
            routeTableElement.appendChild(locationElement);
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Set the specified route for the provided table in this subscription.
    *
    * @param routeTableName Required. The name of the route table where the
    * provided route will be set.
    * @param routeName Required. The name of the route that will be set on the
    * provided route table.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginDeleteRouteAsync(final String routeTableName, final String routeName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginDeleteRoute(routeTableName, routeName);
            }
         });
    }
    
    /**
    * Set the specified route for the provided table in this subscription.
    *
    * @param routeTableName Required. The name of the route table where the
    * provided route will be set.
    * @param routeName Required. The name of the route that will be set on the
    * provided route table.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginDeleteRoute(String routeTableName, String routeName) throws IOException, ServiceException {
        // Validate
        if (routeTableName == null) {
            throw new NullPointerException("routeTableName");
        }
        if (routeName == null) {
            throw new NullPointerException("routeName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("routeTableName", routeTableName);
            tracingParameters.put("routeName", routeName);
            CloudTracing.enter(invocationId, this, "beginDeleteRouteAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/networking/routetables/";
        url = url + URLEncoder.encode(routeTableName, "UTF-8");
        url = url + "/routes/";
        url = url + URLEncoder.encode(routeName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Delete the specified route table for this subscription.
    *
    * @param routeTableName Required. The name of the route table to delete.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginDeleteRouteTableAsync(final String routeTableName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginDeleteRouteTable(routeTableName);
            }
         });
    }
    
    /**
    * Delete the specified route table for this subscription.
    *
    * @param routeTableName Required. The name of the route table to delete.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginDeleteRouteTable(String routeTableName) throws IOException, ServiceException {
        // Validate
        if (routeTableName == null) {
            throw new NullPointerException("routeTableName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("routeTableName", routeTableName);
            CloudTracing.enter(invocationId, this, "beginDeleteRouteTableAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/networking/routetables/";
        url = url + URLEncoder.encode(routeTableName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Remove the route table from the provided subnet in the provided virtual
    * network in this subscription.
    *
    * @param vnetName Required. The name of the virtual network that contains
    * the provided subnet.
    * @param subnetName Required. The name of the subnet that the route table
    * will be removed from.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginRemoveRouteTableFromSubnetAsync(final String vnetName, final String subnetName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginRemoveRouteTableFromSubnet(vnetName, subnetName);
            }
         });
    }
    
    /**
    * Remove the route table from the provided subnet in the provided virtual
    * network in this subscription.
    *
    * @param vnetName Required. The name of the virtual network that contains
    * the provided subnet.
    * @param subnetName Required. The name of the subnet that the route table
    * will be removed from.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginRemoveRouteTableFromSubnet(String vnetName, String subnetName) throws IOException, ServiceException {
        // Validate
        if (vnetName == null) {
            throw new NullPointerException("vnetName");
        }
        if (subnetName == null) {
            throw new NullPointerException("subnetName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("vnetName", vnetName);
            tracingParameters.put("subnetName", subnetName);
            CloudTracing.enter(invocationId, this, "beginRemoveRouteTableFromSubnetAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/networking/virtualnetwork/";
        url = url + URLEncoder.encode(vnetName, "UTF-8");
        url = url + "/subnets/";
        url = url + URLEncoder.encode(subnetName, "UTF-8");
        url = url + "/routetables";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Set the specified route for the provided table in this subscription.
    *
    * @param routeTableName Required. The name of the route table where the
    * provided route will be set.
    * @param routeName Required. The name of the route that will be set on the
    * provided route table.
    * @param parameters Required. The parameters necessary to create a new
    * route table.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginSetRouteAsync(final String routeTableName, final String routeName, final SetRouteParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginSetRoute(routeTableName, routeName, parameters);
            }
         });
    }
    
    /**
    * Set the specified route for the provided table in this subscription.
    *
    * @param routeTableName Required. The name of the route table where the
    * provided route will be set.
    * @param routeName Required. The name of the route that will be set on the
    * provided route table.
    * @param parameters Required. The parameters necessary to create a new
    * route table.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginSetRoute(String routeTableName, String routeName, SetRouteParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (routeTableName == null) {
            throw new NullPointerException("routeTableName");
        }
        if (routeName == null) {
            throw new NullPointerException("routeName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("routeTableName", routeTableName);
            tracingParameters.put("routeName", routeName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginSetRouteAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/networking/routetables/";
        url = url + URLEncoder.encode(routeTableName, "UTF-8");
        url = url + "/routes/";
        url = url + URLEncoder.encode(routeName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element routeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Route");
        requestDoc.appendChild(routeElement);
        
        if (parameters.getName() != null) {
            Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
            nameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
            routeElement.appendChild(nameElement);
        }
        
        if (parameters.getAddressPrefix() != null) {
            Element addressPrefixElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AddressPrefix");
            addressPrefixElement.appendChild(requestDoc.createTextNode(parameters.getAddressPrefix()));
            routeElement.appendChild(addressPrefixElement);
        }
        
        if (parameters.getNextHop() != null) {
            Element nextHopTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NextHopType");
            routeElement.appendChild(nextHopTypeElement);
            
            if (parameters.getNextHop().getType() != null) {
                Element typeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Type");
                typeElement.appendChild(requestDoc.createTextNode(parameters.getNextHop().getType()));
                nextHopTypeElement.appendChild(typeElement);
            }
            
            if (parameters.getNextHop().getIpAddress() != null) {
                Element ipAddressElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IpAddress");
                ipAddressElement.appendChild(requestDoc.createTextNode(parameters.getNextHop().getIpAddress()));
                nextHopTypeElement.appendChild(ipAddressElement);
            }
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Create the specified route table for this subscription.
    *
    * @param parameters Required. The parameters necessary to create a new
    * route table.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    @Override
    public Future<OperationStatusResponse> createRouteTableAsync(final CreateRouteTableParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return createRouteTable(parameters);
            }
         });
    }
    
    /**
    * Create the specified route table for this subscription.
    *
    * @param parameters Required. The parameters necessary to create a new
    * route table.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    @Override
    public OperationStatusResponse createRouteTable(CreateRouteTableParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createRouteTableAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getRoutesOperations().beginCreateRouteTableAsync(parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * Set the specified route for the provided table in this subscription.
    *
    * @param routeTableName Required. The name of the route table where the
    * provided route will be set.
    * @param routeName Required. The name of the route that will be set on the
    * provided route table.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    @Override
    public Future<OperationStatusResponse> deleteRouteAsync(final String routeTableName, final String routeName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return deleteRoute(routeTableName, routeName);
            }
         });
    }
    
    /**
    * Set the specified route for the provided table in this subscription.
    *
    * @param routeTableName Required. The name of the route table where the
    * provided route will be set.
    * @param routeName Required. The name of the route that will be set on the
    * provided route table.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    @Override
    public OperationStatusResponse deleteRoute(String routeTableName, String routeName) throws InterruptedException, ExecutionException, ServiceException, IOException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("routeTableName", routeTableName);
            tracingParameters.put("routeName", routeName);
            CloudTracing.enter(invocationId, this, "deleteRouteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getRoutesOperations().beginDeleteRouteAsync(routeTableName, routeName).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * Delete the specified route table for this subscription.
    *
    * @param routeTableName Required. The name of the route table to delete.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    @Override
    public Future<OperationStatusResponse> deleteRouteTableAsync(final String routeTableName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return deleteRouteTable(routeTableName);
            }
         });
    }
    
    /**
    * Delete the specified route table for this subscription.
    *
    * @param routeTableName Required. The name of the route table to delete.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    @Override
    public OperationStatusResponse deleteRouteTable(String routeTableName) throws InterruptedException, ExecutionException, ServiceException, IOException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("routeTableName", routeTableName);
            CloudTracing.enter(invocationId, this, "deleteRouteTableAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getRoutesOperations().beginDeleteRouteTableAsync(routeTableName).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * Get the effective route table for the provided network interface in this
    * subscription.
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of the deployment.
    * @param roleinstanceName Required. The name of the role instance.
    * @param networkInterfaceName Required. The name of the network interface.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<GetEffectiveRouteTableResponse> getEffectiveRouteTableForNetworkInterfaceAsync(final String serviceName, final String deploymentName, final String roleinstanceName, final String networkInterfaceName) {
        return this.getClient().getExecutorService().submit(new Callable<GetEffectiveRouteTableResponse>() { 
            @Override
            public GetEffectiveRouteTableResponse call() throws Exception {
                return getEffectiveRouteTableForNetworkInterface(serviceName, deploymentName, roleinstanceName, networkInterfaceName);
            }
         });
    }
    
    /**
    * Get the effective route table for the provided network interface in this
    * subscription.
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of the deployment.
    * @param roleinstanceName Required. The name of the role instance.
    * @param networkInterfaceName Required. The name of the network interface.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public GetEffectiveRouteTableResponse getEffectiveRouteTableForNetworkInterface(String serviceName, String deploymentName, String roleinstanceName, String networkInterfaceName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (roleinstanceName == null) {
            throw new NullPointerException("roleinstanceName");
        }
        if (networkInterfaceName == null) {
            throw new NullPointerException("networkInterfaceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleinstanceName", roleinstanceName);
            tracingParameters.put("networkInterfaceName", networkInterfaceName);
            CloudTracing.enter(invocationId, this, "getEffectiveRouteTableForNetworkInterfaceAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/roleinstances/";
        url = url + URLEncoder.encode(roleinstanceName, "UTF-8");
        url = url + "/networkinterfaces/";
        url = url + URLEncoder.encode(networkInterfaceName, "UTF-8");
        url = url + "/effectiveroutetable";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            GetEffectiveRouteTableResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new GetEffectiveRouteTableResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
            
            Element effectiveRouteTableElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "EffectiveRouteTable");
            if (effectiveRouteTableElement != null) {
                EffectiveRouteTable effectiveRouteTableInstance = new EffectiveRouteTable();
                result.setEffectiveRouteTable(effectiveRouteTableInstance);
                
                Element effectiveRouteListSequenceElement = XmlUtility.getElementByTagNameNS(effectiveRouteTableElement, "http://schemas.microsoft.com/windowsazure", "EffectiveRouteList");
                if (effectiveRouteListSequenceElement != null) {
                    for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(effectiveRouteListSequenceElement, "http://schemas.microsoft.com/windowsazure", "EffectiveRoute").size(); i1 = i1 + 1) {
                        org.w3c.dom.Element effectiveRouteListElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(effectiveRouteListSequenceElement, "http://schemas.microsoft.com/windowsazure", "EffectiveRoute").get(i1));
                        EffectiveRoute effectiveRouteInstance = new EffectiveRoute();
                        effectiveRouteTableInstance.getEffectiveRoutes().add(effectiveRouteInstance);
                        
                        Element nameElement = XmlUtility.getElementByTagNameNS(effectiveRouteListElement, "http://schemas.microsoft.com/windowsazure", "Name");
                        if (nameElement != null) {
                            String nameInstance;
                            nameInstance = nameElement.getTextContent();
                            effectiveRouteInstance.setName(nameInstance);
                        }
                        
                        Element sourceElement = XmlUtility.getElementByTagNameNS(effectiveRouteListElement, "http://schemas.microsoft.com/windowsazure", "Source");
                        if (sourceElement != null) {
                            String sourceInstance;
                            sourceInstance = sourceElement.getTextContent();
                            effectiveRouteInstance.setSource(sourceInstance);
                        }
                        
                        Element statusElement = XmlUtility.getElementByTagNameNS(effectiveRouteListElement, "http://schemas.microsoft.com/windowsazure", "Status");
                        if (statusElement != null) {
                            String statusInstance;
                            statusInstance = statusElement.getTextContent();
                            effectiveRouteInstance.setStatus(statusInstance);
                        }
                        
                        Element addressPrefixesSequenceElement = XmlUtility.getElementByTagNameNS(effectiveRouteListElement, "http://schemas.microsoft.com/windowsazure", "AddressPrefixes");
                        if (addressPrefixesSequenceElement != null) {
                            for (int i2 = 0; i2 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(addressPrefixesSequenceElement, "http://schemas.microsoft.com/windowsazure", "AddressPrefix").size(); i2 = i2 + 1) {
                                org.w3c.dom.Element addressPrefixesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(addressPrefixesSequenceElement, "http://schemas.microsoft.com/windowsazure", "AddressPrefix").get(i2));
                                effectiveRouteInstance.getAddressPrefixes().add(addressPrefixesElement.getTextContent());
                            }
                        }
                        
                        Element effectiveNextHopElement = XmlUtility.getElementByTagNameNS(effectiveRouteListElement, "http://schemas.microsoft.com/windowsazure", "EffectiveNextHop");
                        if (effectiveNextHopElement != null) {
                            EffectiveNextHop effectiveNextHopInstance = new EffectiveNextHop();
                            effectiveRouteInstance.setEffectiveNextHop(effectiveNextHopInstance);
                            
                            Element typeElement = XmlUtility.getElementByTagNameNS(effectiveNextHopElement, "http://schemas.microsoft.com/windowsazure", "Type");
                            if (typeElement != null) {
                                String typeInstance;
                                typeInstance = typeElement.getTextContent();
                                effectiveNextHopInstance.setType(typeInstance);
                            }
                            
                            Element ipAddressesSequenceElement = XmlUtility.getElementByTagNameNS(effectiveNextHopElement, "http://schemas.microsoft.com/windowsazure", "IpAddresses");
                            if (ipAddressesSequenceElement != null) {
                                for (int i3 = 0; i3 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(ipAddressesSequenceElement, "http://schemas.microsoft.com/windowsazure", "IpAddress").size(); i3 = i3 + 1) {
                                    org.w3c.dom.Element ipAddressesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(ipAddressesSequenceElement, "http://schemas.microsoft.com/windowsazure", "IpAddress").get(i3));
                                    effectiveNextHopInstance.getIpAddresses().add(ipAddressesElement.getTextContent());
                                }
                            }
                        }
                    }
                }
            }
            
            result.setStatusCode(statusCode);
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Get the effective route table for the provided role instance in this
    * subscription.
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of the deployment.
    * @param roleinstanceName Required. The name of the role instance.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<GetEffectiveRouteTableResponse> getEffectiveRouteTableForRoleInstanceAsync(final String serviceName, final String deploymentName, final String roleinstanceName) {
        return this.getClient().getExecutorService().submit(new Callable<GetEffectiveRouteTableResponse>() { 
            @Override
            public GetEffectiveRouteTableResponse call() throws Exception {
                return getEffectiveRouteTableForRoleInstance(serviceName, deploymentName, roleinstanceName);
            }
         });
    }
    
    /**
    * Get the effective route table for the provided role instance in this
    * subscription.
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of the deployment.
    * @param roleinstanceName Required. The name of the role instance.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public GetEffectiveRouteTableResponse getEffectiveRouteTableForRoleInstance(String serviceName, String deploymentName, String roleinstanceName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (roleinstanceName == null) {
            throw new NullPointerException("roleinstanceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleinstanceName", roleinstanceName);
            CloudTracing.enter(invocationId, this, "getEffectiveRouteTableForRoleInstanceAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/hostedservices/";
        url = url + URLEncoder.encode(serviceName, "UTF-8");
        url = url + "/deployments/";
        url = url + URLEncoder.encode(deploymentName, "UTF-8");
        url = url + "/roleinstances/";
        url = url + URLEncoder.encode(roleinstanceName, "UTF-8");
        url = url + "/effectiveroutetable";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            GetEffectiveRouteTableResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new GetEffectiveRouteTableResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
            
            Element effectiveRouteTableElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "EffectiveRouteTable");
            if (effectiveRouteTableElement != null) {
                EffectiveRouteTable effectiveRouteTableInstance = new EffectiveRouteTable();
                result.setEffectiveRouteTable(effectiveRouteTableInstance);
                
                Element effectiveRouteListSequenceElement = XmlUtility.getElementByTagNameNS(effectiveRouteTableElement, "http://schemas.microsoft.com/windowsazure", "EffectiveRouteList");
                if (effectiveRouteListSequenceElement != null) {
                    for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(effectiveRouteListSequenceElement, "http://schemas.microsoft.com/windowsazure", "EffectiveRoute").size(); i1 = i1 + 1) {
                        org.w3c.dom.Element effectiveRouteListElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(effectiveRouteListSequenceElement, "http://schemas.microsoft.com/windowsazure", "EffectiveRoute").get(i1));
                        EffectiveRoute effectiveRouteInstance = new EffectiveRoute();
                        effectiveRouteTableInstance.getEffectiveRoutes().add(effectiveRouteInstance);
                        
                        Element nameElement = XmlUtility.getElementByTagNameNS(effectiveRouteListElement, "http://schemas.microsoft.com/windowsazure", "Name");
                        if (nameElement != null) {
                            String nameInstance;
                            nameInstance = nameElement.getTextContent();
                            effectiveRouteInstance.setName(nameInstance);
                        }
                        
                        Element sourceElement = XmlUtility.getElementByTagNameNS(effectiveRouteListElement, "http://schemas.microsoft.com/windowsazure", "Source");
                        if (sourceElement != null) {
                            String sourceInstance;
                            sourceInstance = sourceElement.getTextContent();
                            effectiveRouteInstance.setSource(sourceInstance);
                        }
                        
                        Element statusElement = XmlUtility.getElementByTagNameNS(effectiveRouteListElement, "http://schemas.microsoft.com/windowsazure", "Status");
                        if (statusElement != null) {
                            String statusInstance;
                            statusInstance = statusElement.getTextContent();
                            effectiveRouteInstance.setStatus(statusInstance);
                        }
                        
                        Element addressPrefixesSequenceElement = XmlUtility.getElementByTagNameNS(effectiveRouteListElement, "http://schemas.microsoft.com/windowsazure", "AddressPrefixes");
                        if (addressPrefixesSequenceElement != null) {
                            for (int i2 = 0; i2 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(addressPrefixesSequenceElement, "http://schemas.microsoft.com/windowsazure", "AddressPrefix").size(); i2 = i2 + 1) {
                                org.w3c.dom.Element addressPrefixesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(addressPrefixesSequenceElement, "http://schemas.microsoft.com/windowsazure", "AddressPrefix").get(i2));
                                effectiveRouteInstance.getAddressPrefixes().add(addressPrefixesElement.getTextContent());
                            }
                        }
                        
                        Element effectiveNextHopElement = XmlUtility.getElementByTagNameNS(effectiveRouteListElement, "http://schemas.microsoft.com/windowsazure", "EffectiveNextHop");
                        if (effectiveNextHopElement != null) {
                            EffectiveNextHop effectiveNextHopInstance = new EffectiveNextHop();
                            effectiveRouteInstance.setEffectiveNextHop(effectiveNextHopInstance);
                            
                            Element typeElement = XmlUtility.getElementByTagNameNS(effectiveNextHopElement, "http://schemas.microsoft.com/windowsazure", "Type");
                            if (typeElement != null) {
                                String typeInstance;
                                typeInstance = typeElement.getTextContent();
                                effectiveNextHopInstance.setType(typeInstance);
                            }
                            
                            Element ipAddressesSequenceElement = XmlUtility.getElementByTagNameNS(effectiveNextHopElement, "http://schemas.microsoft.com/windowsazure", "IpAddresses");
                            if (ipAddressesSequenceElement != null) {
                                for (int i3 = 0; i3 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(ipAddressesSequenceElement, "http://schemas.microsoft.com/windowsazure", "IpAddress").size(); i3 = i3 + 1) {
                                    org.w3c.dom.Element ipAddressesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(ipAddressesSequenceElement, "http://schemas.microsoft.com/windowsazure", "IpAddress").get(i3));
                                    effectiveNextHopInstance.getIpAddresses().add(ipAddressesElement.getTextContent());
                                }
                            }
                        }
                    }
                }
            }
            
            result.setStatusCode(statusCode);
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Get the specified route table for this subscription.
    *
    * @param routeTableName Required. The name of the route table in this
    * subscription to retrieve.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<GetRouteTableResponse> getRouteTableAsync(final String routeTableName) {
        return this.getClient().getExecutorService().submit(new Callable<GetRouteTableResponse>() { 
            @Override
            public GetRouteTableResponse call() throws Exception {
                return getRouteTable(routeTableName);
            }
         });
    }
    
    /**
    * Get the specified route table for this subscription.
    *
    * @param routeTableName Required. The name of the route table in this
    * subscription to retrieve.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public GetRouteTableResponse getRouteTable(String routeTableName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        if (routeTableName == null) {
            throw new NullPointerException("routeTableName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("routeTableName", routeTableName);
            CloudTracing.enter(invocationId, this, "getRouteTableAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/networking/routetables/";
        url = url + URLEncoder.encode(routeTableName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            GetRouteTableResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new GetRouteTableResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element routeTableElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "RouteTable");
                if (routeTableElement != null) {
                    RouteTable routeTableInstance = new RouteTable();
                    result.setRouteTable(routeTableInstance);
                    
                    Element nameElement = XmlUtility.getElementByTagNameNS(routeTableElement, "http://schemas.microsoft.com/windowsazure", "Name");
                    if (nameElement != null) {
                        String nameInstance;
                        nameInstance = nameElement.getTextContent();
                        routeTableInstance.setName(nameInstance);
                    }
                    
                    Element labelElement = XmlUtility.getElementByTagNameNS(routeTableElement, "http://schemas.microsoft.com/windowsazure", "Label");
                    if (labelElement != null) {
                        String labelInstance;
                        labelInstance = labelElement.getTextContent();
                        routeTableInstance.setLabel(labelInstance);
                    }
                    
                    Element locationElement = XmlUtility.getElementByTagNameNS(routeTableElement, "http://schemas.microsoft.com/windowsazure", "Location");
                    if (locationElement != null) {
                        String locationInstance;
                        locationInstance = locationElement.getTextContent();
                        routeTableInstance.setLocation(locationInstance);
                    }
                    
                    Element routeTableStateElement = XmlUtility.getElementByTagNameNS(routeTableElement, "http://schemas.microsoft.com/windowsazure", "RouteTableState");
                    if (routeTableStateElement != null && routeTableStateElement.getTextContent() != null && !routeTableStateElement.getTextContent().isEmpty()) {
                        RouteTableState routeTableStateInstance;
                        routeTableStateInstance = RouteTableState.valueOf(routeTableStateElement.getTextContent());
                        routeTableInstance.setRouteTableState(routeTableStateInstance);
                    }
                    
                    Element routeListSequenceElement = XmlUtility.getElementByTagNameNS(routeTableElement, "http://schemas.microsoft.com/windowsazure", "RouteList");
                    if (routeListSequenceElement != null) {
                        for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(routeListSequenceElement, "http://schemas.microsoft.com/windowsazure", "Route").size(); i1 = i1 + 1) {
                            org.w3c.dom.Element routeListElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(routeListSequenceElement, "http://schemas.microsoft.com/windowsazure", "Route").get(i1));
                            Route routeInstance = new Route();
                            routeTableInstance.getRouteList().add(routeInstance);
                            
                            Element nameElement2 = XmlUtility.getElementByTagNameNS(routeListElement, "http://schemas.microsoft.com/windowsazure", "Name");
                            if (nameElement2 != null) {
                                String nameInstance2;
                                nameInstance2 = nameElement2.getTextContent();
                                routeInstance.setName(nameInstance2);
                            }
                            
                            Element addressPrefixElement = XmlUtility.getElementByTagNameNS(routeListElement, "http://schemas.microsoft.com/windowsazure", "AddressPrefix");
                            if (addressPrefixElement != null) {
                                String addressPrefixInstance;
                                addressPrefixInstance = addressPrefixElement.getTextContent();
                                routeInstance.setAddressPrefix(addressPrefixInstance);
                            }
                            
                            Element nextHopTypeElement = XmlUtility.getElementByTagNameNS(routeListElement, "http://schemas.microsoft.com/windowsazure", "NextHopType");
                            if (nextHopTypeElement != null) {
                                NextHop nextHopTypeInstance = new NextHop();
                                routeInstance.setNextHop(nextHopTypeInstance);
                                
                                Element typeElement = XmlUtility.getElementByTagNameNS(nextHopTypeElement, "http://schemas.microsoft.com/windowsazure", "Type");
                                if (typeElement != null) {
                                    String typeInstance;
                                    typeInstance = typeElement.getTextContent();
                                    nextHopTypeInstance.setType(typeInstance);
                                }
                                
                                Element ipAddressElement = XmlUtility.getElementByTagNameNS(nextHopTypeElement, "http://schemas.microsoft.com/windowsazure", "IpAddress");
                                if (ipAddressElement != null) {
                                    String ipAddressInstance;
                                    ipAddressInstance = ipAddressElement.getTextContent();
                                    nextHopTypeInstance.setIpAddress(ipAddressInstance);
                                }
                            }
                            
                            Element metricElement = XmlUtility.getElementByTagNameNS(routeListElement, "http://schemas.microsoft.com/windowsazure", "Metric");
                            if (metricElement != null) {
                                int metricInstance;
                                metricInstance = DatatypeConverter.parseInt(metricElement.getTextContent());
                                routeInstance.setMetric(metricInstance);
                            }
                            
                            Element routeStateElement = XmlUtility.getElementByTagNameNS(routeListElement, "http://schemas.microsoft.com/windowsazure", "RouteState");
                            if (routeStateElement != null && routeStateElement.getTextContent() != null && !routeStateElement.getTextContent().isEmpty()) {
                                RouteState routeStateInstance;
                                routeStateInstance = RouteState.valueOf(routeStateElement.getTextContent());
                                routeInstance.setState(routeStateInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Get the specified route table for the provided subnet in the provided
    * virtual network in this subscription.
    *
    * @param vnetName Required. The name of the virtual network that contains
    * the provided subnet.
    * @param subnetName Required. The name of the subnet.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<GetRouteTableForSubnetResponse> getRouteTableForSubnetAsync(final String vnetName, final String subnetName) {
        return this.getClient().getExecutorService().submit(new Callable<GetRouteTableForSubnetResponse>() { 
            @Override
            public GetRouteTableForSubnetResponse call() throws Exception {
                return getRouteTableForSubnet(vnetName, subnetName);
            }
         });
    }
    
    /**
    * Get the specified route table for the provided subnet in the provided
    * virtual network in this subscription.
    *
    * @param vnetName Required. The name of the virtual network that contains
    * the provided subnet.
    * @param subnetName Required. The name of the subnet.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public GetRouteTableForSubnetResponse getRouteTableForSubnet(String vnetName, String subnetName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        if (vnetName == null) {
            throw new NullPointerException("vnetName");
        }
        if (subnetName == null) {
            throw new NullPointerException("subnetName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("vnetName", vnetName);
            tracingParameters.put("subnetName", subnetName);
            CloudTracing.enter(invocationId, this, "getRouteTableForSubnetAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/networking/virtualnetwork/";
        url = url + URLEncoder.encode(vnetName, "UTF-8");
        url = url + "/subnets/";
        url = url + URLEncoder.encode(subnetName, "UTF-8");
        url = url + "/routetables";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            GetRouteTableForSubnetResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new GetRouteTableForSubnetResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
            
            Element routeTableAssociationElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "RouteTableAssociation");
            if (routeTableAssociationElement != null) {
                Element routeTableNameElement = XmlUtility.getElementByTagNameNS(routeTableAssociationElement, "http://schemas.microsoft.com/windowsazure", "RouteTableName");
                if (routeTableNameElement != null) {
                    String routeTableNameInstance;
                    routeTableNameInstance = routeTableNameElement.getTextContent();
                    result.setRouteTableName(routeTableNameInstance);
                }
            }
            
            result.setStatusCode(statusCode);
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Get the specified route table for this subscription.
    *
    * @param routeTableName Required. The name of the route table in this
    * subscription to retrieve.
    * @param detailLevel Required. The amount of detail about the requested
    * route table that will be returned.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<GetRouteTableResponse> getRouteTableWithDetailsAsync(final String routeTableName, final String detailLevel) {
        return this.getClient().getExecutorService().submit(new Callable<GetRouteTableResponse>() { 
            @Override
            public GetRouteTableResponse call() throws Exception {
                return getRouteTableWithDetails(routeTableName, detailLevel);
            }
         });
    }
    
    /**
    * Get the specified route table for this subscription.
    *
    * @param routeTableName Required. The name of the route table in this
    * subscription to retrieve.
    * @param detailLevel Required. The amount of detail about the requested
    * route table that will be returned.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public GetRouteTableResponse getRouteTableWithDetails(String routeTableName, String detailLevel) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        if (routeTableName == null) {
            throw new NullPointerException("routeTableName");
        }
        if (detailLevel == null) {
            throw new NullPointerException("detailLevel");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("routeTableName", routeTableName);
            tracingParameters.put("detailLevel", detailLevel);
            CloudTracing.enter(invocationId, this, "getRouteTableWithDetailsAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/networking/routetables/";
        url = url + URLEncoder.encode(routeTableName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("detailLevel=" + URLEncoder.encode(detailLevel, "UTF-8"));
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            GetRouteTableResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new GetRouteTableResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element routeTableElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "RouteTable");
                if (routeTableElement != null) {
                    RouteTable routeTableInstance = new RouteTable();
                    result.setRouteTable(routeTableInstance);
                    
                    Element nameElement = XmlUtility.getElementByTagNameNS(routeTableElement, "http://schemas.microsoft.com/windowsazure", "Name");
                    if (nameElement != null) {
                        String nameInstance;
                        nameInstance = nameElement.getTextContent();
                        routeTableInstance.setName(nameInstance);
                    }
                    
                    Element labelElement = XmlUtility.getElementByTagNameNS(routeTableElement, "http://schemas.microsoft.com/windowsazure", "Label");
                    if (labelElement != null) {
                        String labelInstance;
                        labelInstance = labelElement.getTextContent();
                        routeTableInstance.setLabel(labelInstance);
                    }
                    
                    Element locationElement = XmlUtility.getElementByTagNameNS(routeTableElement, "http://schemas.microsoft.com/windowsazure", "Location");
                    if (locationElement != null) {
                        String locationInstance;
                        locationInstance = locationElement.getTextContent();
                        routeTableInstance.setLocation(locationInstance);
                    }
                    
                    Element routeTableStateElement = XmlUtility.getElementByTagNameNS(routeTableElement, "http://schemas.microsoft.com/windowsazure", "RouteTableState");
                    if (routeTableStateElement != null && routeTableStateElement.getTextContent() != null && !routeTableStateElement.getTextContent().isEmpty()) {
                        RouteTableState routeTableStateInstance;
                        routeTableStateInstance = RouteTableState.valueOf(routeTableStateElement.getTextContent());
                        routeTableInstance.setRouteTableState(routeTableStateInstance);
                    }
                    
                    Element routeListSequenceElement = XmlUtility.getElementByTagNameNS(routeTableElement, "http://schemas.microsoft.com/windowsazure", "RouteList");
                    if (routeListSequenceElement != null) {
                        for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(routeListSequenceElement, "http://schemas.microsoft.com/windowsazure", "Route").size(); i1 = i1 + 1) {
                            org.w3c.dom.Element routeListElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(routeListSequenceElement, "http://schemas.microsoft.com/windowsazure", "Route").get(i1));
                            Route routeInstance = new Route();
                            routeTableInstance.getRouteList().add(routeInstance);
                            
                            Element nameElement2 = XmlUtility.getElementByTagNameNS(routeListElement, "http://schemas.microsoft.com/windowsazure", "Name");
                            if (nameElement2 != null) {
                                String nameInstance2;
                                nameInstance2 = nameElement2.getTextContent();
                                routeInstance.setName(nameInstance2);
                            }
                            
                            Element addressPrefixElement = XmlUtility.getElementByTagNameNS(routeListElement, "http://schemas.microsoft.com/windowsazure", "AddressPrefix");
                            if (addressPrefixElement != null) {
                                String addressPrefixInstance;
                                addressPrefixInstance = addressPrefixElement.getTextContent();
                                routeInstance.setAddressPrefix(addressPrefixInstance);
                            }
                            
                            Element nextHopTypeElement = XmlUtility.getElementByTagNameNS(routeListElement, "http://schemas.microsoft.com/windowsazure", "NextHopType");
                            if (nextHopTypeElement != null) {
                                NextHop nextHopTypeInstance = new NextHop();
                                routeInstance.setNextHop(nextHopTypeInstance);
                                
                                Element typeElement = XmlUtility.getElementByTagNameNS(nextHopTypeElement, "http://schemas.microsoft.com/windowsazure", "Type");
                                if (typeElement != null) {
                                    String typeInstance;
                                    typeInstance = typeElement.getTextContent();
                                    nextHopTypeInstance.setType(typeInstance);
                                }
                                
                                Element ipAddressElement = XmlUtility.getElementByTagNameNS(nextHopTypeElement, "http://schemas.microsoft.com/windowsazure", "IpAddress");
                                if (ipAddressElement != null) {
                                    String ipAddressInstance;
                                    ipAddressInstance = ipAddressElement.getTextContent();
                                    nextHopTypeInstance.setIpAddress(ipAddressInstance);
                                }
                            }
                            
                            Element metricElement = XmlUtility.getElementByTagNameNS(routeListElement, "http://schemas.microsoft.com/windowsazure", "Metric");
                            if (metricElement != null) {
                                int metricInstance;
                                metricInstance = DatatypeConverter.parseInt(metricElement.getTextContent());
                                routeInstance.setMetric(metricInstance);
                            }
                            
                            Element routeStateElement = XmlUtility.getElementByTagNameNS(routeListElement, "http://schemas.microsoft.com/windowsazure", "RouteState");
                            if (routeStateElement != null && routeStateElement.getTextContent() != null && !routeStateElement.getTextContent().isEmpty()) {
                                RouteState routeStateInstance;
                                routeStateInstance = RouteState.valueOf(routeStateElement.getTextContent());
                                routeInstance.setState(routeStateInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * List the existing route tables for this subscription.
    *
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<ListRouteTablesResponse> listRouteTablesAsync() {
        return this.getClient().getExecutorService().submit(new Callable<ListRouteTablesResponse>() { 
            @Override
            public ListRouteTablesResponse call() throws Exception {
                return listRouteTables();
            }
         });
    }
    
    /**
    * List the existing route tables for this subscription.
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public ListRouteTablesResponse listRouteTables() throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            CloudTracing.enter(invocationId, this, "listRouteTablesAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/networking/routetables";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ListRouteTablesResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ListRouteTablesResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element routeTablesSequenceElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "RouteTables");
                if (routeTablesSequenceElement != null) {
                    for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(routeTablesSequenceElement, "http://schemas.microsoft.com/windowsazure", "RouteTable").size(); i1 = i1 + 1) {
                        org.w3c.dom.Element routeTablesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(routeTablesSequenceElement, "http://schemas.microsoft.com/windowsazure", "RouteTable").get(i1));
                        RouteTable routeTableInstance = new RouteTable();
                        result.getRouteTables().add(routeTableInstance);
                        
                        Element nameElement = XmlUtility.getElementByTagNameNS(routeTablesElement, "http://schemas.microsoft.com/windowsazure", "Name");
                        if (nameElement != null) {
                            String nameInstance;
                            nameInstance = nameElement.getTextContent();
                            routeTableInstance.setName(nameInstance);
                        }
                        
                        Element labelElement = XmlUtility.getElementByTagNameNS(routeTablesElement, "http://schemas.microsoft.com/windowsazure", "Label");
                        if (labelElement != null) {
                            String labelInstance;
                            labelInstance = labelElement.getTextContent();
                            routeTableInstance.setLabel(labelInstance);
                        }
                        
                        Element locationElement = XmlUtility.getElementByTagNameNS(routeTablesElement, "http://schemas.microsoft.com/windowsazure", "Location");
                        if (locationElement != null) {
                            String locationInstance;
                            locationInstance = locationElement.getTextContent();
                            routeTableInstance.setLocation(locationInstance);
                        }
                        
                        Element routeTableStateElement = XmlUtility.getElementByTagNameNS(routeTablesElement, "http://schemas.microsoft.com/windowsazure", "RouteTableState");
                        if (routeTableStateElement != null && routeTableStateElement.getTextContent() != null && !routeTableStateElement.getTextContent().isEmpty()) {
                            RouteTableState routeTableStateInstance;
                            routeTableStateInstance = RouteTableState.valueOf(routeTableStateElement.getTextContent());
                            routeTableInstance.setRouteTableState(routeTableStateInstance);
                        }
                        
                        Element routeListSequenceElement = XmlUtility.getElementByTagNameNS(routeTablesElement, "http://schemas.microsoft.com/windowsazure", "RouteList");
                        if (routeListSequenceElement != null) {
                            for (int i2 = 0; i2 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(routeListSequenceElement, "http://schemas.microsoft.com/windowsazure", "Route").size(); i2 = i2 + 1) {
                                org.w3c.dom.Element routeListElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(routeListSequenceElement, "http://schemas.microsoft.com/windowsazure", "Route").get(i2));
                                Route routeInstance = new Route();
                                routeTableInstance.getRouteList().add(routeInstance);
                                
                                Element nameElement2 = XmlUtility.getElementByTagNameNS(routeListElement, "http://schemas.microsoft.com/windowsazure", "Name");
                                if (nameElement2 != null) {
                                    String nameInstance2;
                                    nameInstance2 = nameElement2.getTextContent();
                                    routeInstance.setName(nameInstance2);
                                }
                                
                                Element addressPrefixElement = XmlUtility.getElementByTagNameNS(routeListElement, "http://schemas.microsoft.com/windowsazure", "AddressPrefix");
                                if (addressPrefixElement != null) {
                                    String addressPrefixInstance;
                                    addressPrefixInstance = addressPrefixElement.getTextContent();
                                    routeInstance.setAddressPrefix(addressPrefixInstance);
                                }
                                
                                Element nextHopTypeElement = XmlUtility.getElementByTagNameNS(routeListElement, "http://schemas.microsoft.com/windowsazure", "NextHopType");
                                if (nextHopTypeElement != null) {
                                    NextHop nextHopTypeInstance = new NextHop();
                                    routeInstance.setNextHop(nextHopTypeInstance);
                                    
                                    Element typeElement = XmlUtility.getElementByTagNameNS(nextHopTypeElement, "http://schemas.microsoft.com/windowsazure", "Type");
                                    if (typeElement != null) {
                                        String typeInstance;
                                        typeInstance = typeElement.getTextContent();
                                        nextHopTypeInstance.setType(typeInstance);
                                    }
                                    
                                    Element ipAddressElement = XmlUtility.getElementByTagNameNS(nextHopTypeElement, "http://schemas.microsoft.com/windowsazure", "IpAddress");
                                    if (ipAddressElement != null) {
                                        String ipAddressInstance;
                                        ipAddressInstance = ipAddressElement.getTextContent();
                                        nextHopTypeInstance.setIpAddress(ipAddressInstance);
                                    }
                                }
                                
                                Element metricElement = XmlUtility.getElementByTagNameNS(routeListElement, "http://schemas.microsoft.com/windowsazure", "Metric");
                                if (metricElement != null) {
                                    int metricInstance;
                                    metricInstance = DatatypeConverter.parseInt(metricElement.getTextContent());
                                    routeInstance.setMetric(metricInstance);
                                }
                                
                                Element routeStateElement = XmlUtility.getElementByTagNameNS(routeListElement, "http://schemas.microsoft.com/windowsazure", "RouteState");
                                if (routeStateElement != null && routeStateElement.getTextContent() != null && !routeStateElement.getTextContent().isEmpty()) {
                                    RouteState routeStateInstance;
                                    routeStateInstance = RouteState.valueOf(routeStateElement.getTextContent());
                                    routeInstance.setState(routeStateInstance);
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Remove the route table from the provided subnet in the provided virtual
    * network in this subscription.
    *
    * @param vnetName Required. The name of the virtual network that contains
    * the provided subnet.
    * @param subnetName Required. The name of the subnet that the route table
    * will be removed from.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    @Override
    public Future<OperationStatusResponse> removeRouteTableFromSubnetAsync(final String vnetName, final String subnetName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return removeRouteTableFromSubnet(vnetName, subnetName);
            }
         });
    }
    
    /**
    * Remove the route table from the provided subnet in the provided virtual
    * network in this subscription.
    *
    * @param vnetName Required. The name of the virtual network that contains
    * the provided subnet.
    * @param subnetName Required. The name of the subnet that the route table
    * will be removed from.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    @Override
    public OperationStatusResponse removeRouteTableFromSubnet(String vnetName, String subnetName) throws InterruptedException, ExecutionException, ServiceException, IOException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("vnetName", vnetName);
            tracingParameters.put("subnetName", subnetName);
            CloudTracing.enter(invocationId, this, "removeRouteTableFromSubnetAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getRoutesOperations().beginRemoveRouteTableFromSubnetAsync(vnetName, subnetName).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * Set the specified route for the provided table in this subscription.
    *
    * @param routeTableName Required. The name of the route table where the
    * provided route will be set.
    * @param routeName Required. The name of the route that will be set on the
    * provided route table.
    * @param parameters Required. The parameters necessary to create a new
    * route table.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    @Override
    public Future<OperationStatusResponse> setRouteAsync(final String routeTableName, final String routeName, final SetRouteParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return setRoute(routeTableName, routeName, parameters);
            }
         });
    }
    
    /**
    * Set the specified route for the provided table in this subscription.
    *
    * @param routeTableName Required. The name of the route table where the
    * provided route will be set.
    * @param routeName Required. The name of the route that will be set on the
    * provided route table.
    * @param parameters Required. The parameters necessary to create a new
    * route table.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    @Override
    public OperationStatusResponse setRoute(String routeTableName, String routeName, SetRouteParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        NetworkManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("routeTableName", routeTableName);
            tracingParameters.put("routeName", routeName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "setRouteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getRoutesOperations().beginSetRouteAsync(routeTableName, routeName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
}
