/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.network;

import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Network Management API includes operations for managing the Virtual IPs
* for your deployment.
*/
public interface VirtualIPOperations {
    /**
    * The Add Virtual IP operation adds a logical Virtual IP to the deployment.
    *
    * @param serviceName Required. The name of the hosted service that contains
    * the given deployment.
    * @param deploymentName Required. The name of the deployment where the
    * logical Virtual IP is to be added.
    * @param virtualIPName Required. The name of the logical Virtual IP to be
    * added.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    OperationStatusResponse add(String serviceName, String deploymentName, String virtualIPName) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Add Virtual IP operation adds a logical Virtual IP to the deployment.
    *
    * @param serviceName Required. The name of the hosted service that contains
    * the given deployment.
    * @param deploymentName Required. The name of the deployment where the
    * logical Virtual IP is to be added.
    * @param virtualIPName Required. The name of the logical Virtual IP to be
    * added.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<OperationStatusResponse> addAsync(String serviceName, String deploymentName, String virtualIPName);
    
    /**
    * The Begin Adding Virtual IP operation adds a logical Virtual IP to the
    * deployment.
    *
    * @param serviceName Required. The name of the hosted service that contains
    * the given deployment.
    * @param deploymentName Required. The name of the deployment where the
    * logical Virtual IP is to be added.
    * @param virtualIPName Required. The name of the logical Virtual IP to be
    * added.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    OperationStatusResponse beginAdding(String serviceName, String deploymentName, String virtualIPName) throws IOException, ServiceException;
    
    /**
    * The Begin Adding Virtual IP operation adds a logical Virtual IP to the
    * deployment.
    *
    * @param serviceName Required. The name of the hosted service that contains
    * the given deployment.
    * @param deploymentName Required. The name of the deployment where the
    * logical Virtual IP is to be added.
    * @param virtualIPName Required. The name of the logical Virtual IP to be
    * added.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<OperationStatusResponse> beginAddingAsync(String serviceName, String deploymentName, String virtualIPName);
    
    /**
    * The Begin Removing Virtual IP operation removes a logical Virtual IP from
    * the deployment.
    *
    * @param serviceName Required. The name of the hosted service that contains
    * the given deployment.
    * @param deploymentName Required. The name of the deployment whose logical
    * Virtual IP is to be removed.
    * @param virtualIPName Required. The name of the logical Virtual IP to be
    * added.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    OperationStatusResponse beginRemoving(String serviceName, String deploymentName, String virtualIPName) throws IOException, ServiceException;
    
    /**
    * The Begin Removing Virtual IP operation removes a logical Virtual IP from
    * the deployment.
    *
    * @param serviceName Required. The name of the hosted service that contains
    * the given deployment.
    * @param deploymentName Required. The name of the deployment whose logical
    * Virtual IP is to be removed.
    * @param virtualIPName Required. The name of the logical Virtual IP to be
    * added.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<OperationStatusResponse> beginRemovingAsync(String serviceName, String deploymentName, String virtualIPName);
    
    /**
    * The Remove Virtual IP operation removes a logical Virtual IP from the
    * deployment.
    *
    * @param serviceName Required. The name of the hosted service that contains
    * the given deployment.
    * @param deploymentName Required. The name of the deployment whose logical
    * Virtual IP is to be removed.
    * @param virtualIPName Required. The name of the logical Virtual IP to be
    * removed.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    OperationStatusResponse remove(String serviceName, String deploymentName, String virtualIPName) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * The Remove Virtual IP operation removes a logical Virtual IP from the
    * deployment.
    *
    * @param serviceName Required. The name of the hosted service that contains
    * the given deployment.
    * @param deploymentName Required. The name of the deployment whose logical
    * Virtual IP is to be removed.
    * @param virtualIPName Required. The name of the logical Virtual IP to be
    * removed.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    Future<OperationStatusResponse> removeAsync(String serviceName, String deploymentName, String virtualIPName);
}
