/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.network.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Iterator;

/**
* The response of ListApplicationGateways request.
*/
public class ApplicationGatewayListResponse extends OperationResponse implements Iterable<ApplicationGatewayGetResponse> {
    private ArrayList<ApplicationGatewayGetResponse> applicationGateways;
    
    /**
    * Optional.
    * @return The ApplicationGateways value.
    */
    public ArrayList<ApplicationGatewayGetResponse> getApplicationGateways() {
        return this.applicationGateways;
    }
    
    /**
    * Optional.
    * @param applicationGatewaysValue The ApplicationGateways value.
    */
    public void setApplicationGateways(final ArrayList<ApplicationGatewayGetResponse> applicationGatewaysValue) {
        this.applicationGateways = applicationGatewaysValue;
    }
    
    /**
    * Initializes a new instance of the ApplicationGatewayListResponse class.
    *
    */
    public ApplicationGatewayListResponse() {
        super();
        this.setApplicationGateways(new LazyArrayList<ApplicationGatewayGetResponse>());
    }
    
    /**
    * Gets the sequence of ApplicationGateways.
    *
    */
    public Iterator<ApplicationGatewayGetResponse> iterator() {
        return this.getApplicationGateways().iterator();
    }
}
