/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.network.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

/**
* The next hop of this route.
*/
public class EffectiveNextHop {
    private ArrayList<String> ipAddresses;
    
    /**
    * Required. Gets or sets the effective next hop IP addresses.
    * @return The IpAddresses value.
    */
    public ArrayList<String> getIpAddresses() {
        return this.ipAddresses;
    }
    
    /**
    * Required. Gets or sets the effective next hop IP addresses.
    * @param ipAddressesValue The IpAddresses value.
    */
    public void setIpAddresses(final ArrayList<String> ipAddressesValue) {
        this.ipAddresses = ipAddressesValue;
    }
    
    private String type;
    
    /**
    * Required. Gets or sets the type of the effective next hop.
    * @return The Type value.
    */
    public String getType() {
        return this.type;
    }
    
    /**
    * Required. Gets or sets the type of the effective next hop.
    * @param typeValue The Type value.
    */
    public void setType(final String typeValue) {
        this.type = typeValue;
    }
    
    /**
    * Initializes a new instance of the EffectiveNextHop class.
    *
    */
    public EffectiveNextHop() {
        this.setIpAddresses(new LazyArrayList<String>());
    }
    
    /**
    * Initializes a new instance of the EffectiveNextHop class with required
    * arguments.
    *
    * @param type Gets or sets the type of the effective next hop.
    * @param ipAddresses Gets or sets the effective next hop IP addresses.
    */
    public EffectiveNextHop(String type, ArrayList<String> ipAddresses) {
        this();
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (ipAddresses == null) {
            throw new NullPointerException("ipAddresses");
        }
        this.setType(type);
        this.setIpAddresses(ipAddresses);
    }
}
