/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.network.models;

import java.net.InetAddress;

/**
* The parameters for the Connect, Disconnect, or Test request
*/
public class GatewayConnectDisconnectOrTestParameters {
    private InetAddress iPAddress;
    
    /**
    * Optional. Required if operation is set to Test; otherwise not used.
    * Specifies the IP address of the target local network site with which the
    * gateway will test connectivity.
    * @return The IPAddress value.
    */
    public InetAddress getIPAddress() {
        return this.iPAddress;
    }
    
    /**
    * Optional. Required if operation is set to Test; otherwise not used.
    * Specifies the IP address of the target local network site with which the
    * gateway will test connectivity.
    * @param iPAddressValue The IPAddress value.
    */
    public void setIPAddress(final InetAddress iPAddressValue) {
        this.iPAddress = iPAddressValue;
    }
    
    private GatewayConnectionUpdateOperation operation;
    
    /**
    * Required. Specifies the operation to perform on the connection. Can be
    * set to Connect, Disconnect, or Test to connect to a local network,
    * disconnect from a local network, or test the gateway's connection to a
    * local network site.
    * @return The Operation value.
    */
    public GatewayConnectionUpdateOperation getOperation() {
        return this.operation;
    }
    
    /**
    * Required. Specifies the operation to perform on the connection. Can be
    * set to Connect, Disconnect, or Test to connect to a local network,
    * disconnect from a local network, or test the gateway's connection to a
    * local network site.
    * @param operationValue The Operation value.
    */
    public void setOperation(final GatewayConnectionUpdateOperation operationValue) {
        this.operation = operationValue;
    }
    
    /**
    * Initializes a new instance of the
    * GatewayConnectDisconnectOrTestParameters class.
    *
    */
    public GatewayConnectDisconnectOrTestParameters() {
    }
    
    /**
    * Initializes a new instance of the
    * GatewayConnectDisconnectOrTestParameters class with required arguments.
    *
    * @param operation Specifies the operation to perform on the connection.
    * Can be set to Connect, Disconnect, or Test to connect to a local
    * network, disconnect from a local network, or test the gateway's
    * connection to a local network site.
    */
    public GatewayConnectDisconnectOrTestParameters(GatewayConnectionUpdateOperation operation) {
        if (operation == null) {
            throw new NullPointerException("operation");
        }
        this.setOperation(operation);
    }
}
