/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.network.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;

/**
* The response to a ListConnections request to a Virtual Network Gateway.
*/
public class GatewayListConnectionsResponse extends OperationResponse implements Iterable<GatewayListConnectionsResponse.GatewayConnection> {
    private ArrayList<GatewayListConnectionsResponse.GatewayConnection> connections;
    
    /**
    * Optional. The list of connections.
    * @return The Connections value.
    */
    public ArrayList<GatewayListConnectionsResponse.GatewayConnection> getConnections() {
        return this.connections;
    }
    
    /**
    * Optional. The list of connections.
    * @param connectionsValue The Connections value.
    */
    public void setConnections(final ArrayList<GatewayListConnectionsResponse.GatewayConnection> connectionsValue) {
        this.connections = connectionsValue;
    }
    
    /**
    * Initializes a new instance of the GatewayListConnectionsResponse class.
    *
    */
    public GatewayListConnectionsResponse() {
        super();
        this.setConnections(new LazyArrayList<GatewayListConnectionsResponse.GatewayConnection>());
    }
    
    /**
    * Gets the sequence of Connections.
    *
    */
    public Iterator<GatewayListConnectionsResponse.GatewayConnection> iterator() {
        return this.getConnections().iterator();
    }
    
    public static class GatewayConnection {
        private ArrayList<String> allocatedIPAddresses;
        
        /**
        * Optional. If LocalNetworkSiteName is defined as VPNClientConnection,
        * this element contains a list of IP addresses (represented as
        * strings) that are assigned to currently connected VPN clients.
        * @return The AllocatedIPAddresses value.
        */
        public ArrayList<String> getAllocatedIPAddresses() {
            return this.allocatedIPAddresses;
        }
        
        /**
        * Optional. If LocalNetworkSiteName is defined as VPNClientConnection,
        * this element contains a list of IP addresses (represented as
        * strings) that are assigned to currently connected VPN clients.
        * @param allocatedIPAddressesValue The AllocatedIPAddresses value.
        */
        public void setAllocatedIPAddresses(final ArrayList<String> allocatedIPAddressesValue) {
            this.allocatedIPAddresses = allocatedIPAddressesValue;
        }
        
        private GatewayConnectivityState connectivityState;
        
        /**
        * Optional. The connection state of the site. You can set the
        * connection state to Connected, Connecting, or NotConnected.
        * @return The ConnectivityState value.
        */
        public GatewayConnectivityState getConnectivityState() {
            return this.connectivityState;
        }
        
        /**
        * Optional. The connection state of the site. You can set the
        * connection state to Connected, Connecting, or NotConnected.
        * @param connectivityStateValue The ConnectivityState value.
        */
        public void setConnectivityState(final GatewayConnectivityState connectivityStateValue) {
            this.connectivityState = connectivityStateValue;
        }
        
        private long egressBytesTransferred;
        
        /**
        * Optional. The number of bytes of data transferred out through this
        * connection since it was started.
        * @return The EgressBytesTransferred value.
        */
        public long getEgressBytesTransferred() {
            return this.egressBytesTransferred;
        }
        
        /**
        * Optional. The number of bytes of data transferred out through this
        * connection since it was started.
        * @param egressBytesTransferredValue The EgressBytesTransferred value.
        */
        public void setEgressBytesTransferred(final long egressBytesTransferredValue) {
            this.egressBytesTransferred = egressBytesTransferredValue;
        }
        
        private long ingressBytesTransferred;
        
        /**
        * Optional. The number of bytes of data transferred in through this
        * connection since it was started.
        * @return The IngressBytesTransferred value.
        */
        public long getIngressBytesTransferred() {
            return this.ingressBytesTransferred;
        }
        
        /**
        * Optional. The number of bytes of data transferred in through this
        * connection since it was started.
        * @param ingressBytesTransferredValue The IngressBytesTransferred value.
        */
        public void setIngressBytesTransferred(final long ingressBytesTransferredValue) {
            this.ingressBytesTransferred = ingressBytesTransferredValue;
        }
        
        private Calendar lastConnectionEstablished;
        
        /**
        * Optional. The time that the last connection was established.
        * @return The LastConnectionEstablished value.
        */
        public Calendar getLastConnectionEstablished() {
            return this.lastConnectionEstablished;
        }
        
        /**
        * Optional. The time that the last connection was established.
        * @param lastConnectionEstablishedValue The LastConnectionEstablished
        * value.
        */
        public void setLastConnectionEstablished(final Calendar lastConnectionEstablishedValue) {
            this.lastConnectionEstablished = lastConnectionEstablishedValue;
        }
        
        private GatewayEvent lastEvent;
        
        /**
        * Optional. A record of the last provisioning event for this connection.
        * @return The LastEvent value.
        */
        public GatewayEvent getLastEvent() {
            return this.lastEvent;
        }
        
        /**
        * Optional. A record of the last provisioning event for this connection.
        * @param lastEventValue The LastEvent value.
        */
        public void setLastEvent(final GatewayEvent lastEventValue) {
            this.lastEvent = lastEventValue;
        }
        
        private String localNetworkSiteName;
        
        /**
        * Optional. The name of the local network site represented by the
        * connection.
        * @return The LocalNetworkSiteName value.
        */
        public String getLocalNetworkSiteName() {
            return this.localNetworkSiteName;
        }
        
        /**
        * Optional. The name of the local network site represented by the
        * connection.
        * @param localNetworkSiteNameValue The LocalNetworkSiteName value.
        */
        public void setLocalNetworkSiteName(final String localNetworkSiteNameValue) {
            this.localNetworkSiteName = localNetworkSiteNameValue;
        }
        
        /**
        * Initializes a new instance of the GatewayConnection class.
        *
        */
        public GatewayConnection() {
            this.setAllocatedIPAddresses(new LazyArrayList<String>());
        }
    }
}
