/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.network.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Iterator;

/**
* The response to a ListLocalNetworkGateways request.
*/
public class ListLocalNetworkGatewaysResponse extends OperationResponse implements Iterable<ListLocalNetworkGatewaysResponse.LocalNetworkGateway> {
    private ArrayList<ListLocalNetworkGatewaysResponse.LocalNetworkGateway> localNetworkGateways;
    
    /**
    * Optional. The list of local network gateways.
    * @return The LocalNetworkGateways value.
    */
    public ArrayList<ListLocalNetworkGatewaysResponse.LocalNetworkGateway> getLocalNetworkGateways() {
        return this.localNetworkGateways;
    }
    
    /**
    * Optional. The list of local network gateways.
    * @param localNetworkGatewaysValue The LocalNetworkGateways value.
    */
    public void setLocalNetworkGateways(final ArrayList<ListLocalNetworkGatewaysResponse.LocalNetworkGateway> localNetworkGatewaysValue) {
        this.localNetworkGateways = localNetworkGatewaysValue;
    }
    
    /**
    * Initializes a new instance of the ListLocalNetworkGatewaysResponse class.
    *
    */
    public ListLocalNetworkGatewaysResponse() {
        super();
        this.setLocalNetworkGateways(new LazyArrayList<ListLocalNetworkGatewaysResponse.LocalNetworkGateway>());
    }
    
    /**
    * Gets the sequence of LocalNetworkGateways.
    *
    */
    public Iterator<ListLocalNetworkGatewaysResponse.LocalNetworkGateway> iterator() {
        return this.getLocalNetworkGateways().iterator();
    }
    
    public static class LocalNetworkGateway {
        private ArrayList<String> addressSpace;
        
        /**
        * Optional. Address space of local network gateway
        * @return The AddressSpace value.
        */
        public ArrayList<String> getAddressSpace() {
            return this.addressSpace;
        }
        
        /**
        * Optional. Address space of local network gateway
        * @param addressSpaceValue The AddressSpace value.
        */
        public void setAddressSpace(final ArrayList<String> addressSpaceValue) {
            this.addressSpace = addressSpaceValue;
        }
        
        private String gatewayName;
        
        /**
        * Optional. The local network gateway Name.
        * @return The GatewayName value.
        */
        public String getGatewayName() {
            return this.gatewayName;
        }
        
        /**
        * Optional. The local network gateway Name.
        * @param gatewayNameValue The GatewayName value.
        */
        public void setGatewayName(final String gatewayNameValue) {
            this.gatewayName = gatewayNameValue;
        }
        
        private String id;
        
        /**
        * Optional. The local network Gateway Id
        * @return The Id value.
        */
        public String getId() {
            return this.id;
        }
        
        /**
        * Optional. The local network Gateway Id
        * @param idValue The Id value.
        */
        public void setId(final String idValue) {
            this.id = idValue;
        }
        
        private String ipAddress;
        
        /**
        * Optional. The IP address of local network gateway.
        * @return The IpAddress value.
        */
        public String getIpAddress() {
            return this.ipAddress;
        }
        
        /**
        * Optional. The IP address of local network gateway.
        * @param ipAddressValue The IpAddress value.
        */
        public void setIpAddress(final String ipAddressValue) {
            this.ipAddress = ipAddressValue;
        }
        
        /**
        * Initializes a new instance of the LocalNetworkGateway class.
        *
        */
        public LocalNetworkGateway() {
            this.setAddressSpace(new LazyArrayList<String>());
        }
    }
}
