/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.network.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Iterator;

/**
* The response to a ListVirtualNetworkGateways request.
*/
public class ListVirtualNetworkGatewaysResponse extends OperationResponse implements Iterable<ListVirtualNetworkGatewaysResponse.VirtualNetworkGateway> {
    private ArrayList<ListVirtualNetworkGatewaysResponse.VirtualNetworkGateway> virtualNetworkGateways;
    
    /**
    * Optional. The list of virtual network gateways.
    * @return The VirtualNetworkGateways value.
    */
    public ArrayList<ListVirtualNetworkGatewaysResponse.VirtualNetworkGateway> getVirtualNetworkGateways() {
        return this.virtualNetworkGateways;
    }
    
    /**
    * Optional. The list of virtual network gateways.
    * @param virtualNetworkGatewaysValue The VirtualNetworkGateways value.
    */
    public void setVirtualNetworkGateways(final ArrayList<ListVirtualNetworkGatewaysResponse.VirtualNetworkGateway> virtualNetworkGatewaysValue) {
        this.virtualNetworkGateways = virtualNetworkGatewaysValue;
    }
    
    /**
    * Initializes a new instance of the ListVirtualNetworkGatewaysResponse
    * class.
    *
    */
    public ListVirtualNetworkGatewaysResponse() {
        super();
        this.setVirtualNetworkGateways(new LazyArrayList<ListVirtualNetworkGatewaysResponse.VirtualNetworkGateway>());
    }
    
    /**
    * Gets the sequence of VirtualNetworkGateways.
    *
    */
    public Iterator<ListVirtualNetworkGatewaysResponse.VirtualNetworkGateway> iterator() {
        return this.getVirtualNetworkGateways().iterator();
    }
    
    public static class VirtualNetworkGateway {
        private GatewayDefaultSite defaultSite;
        
        /**
        * Optional. The default site on the gateway.
        * @return The DefaultSite value.
        */
        public GatewayDefaultSite getDefaultSite() {
            return this.defaultSite;
        }
        
        /**
        * Optional. The default site on the gateway.
        * @param defaultSiteValue The DefaultSite value.
        */
        public void setDefaultSite(final GatewayDefaultSite defaultSiteValue) {
            this.defaultSite = defaultSiteValue;
        }
        
        private boolean enableBgp;
        
        /**
        * Optional. EnableBgp flag
        * @return The EnableBgp value.
        */
        public boolean isEnableBgp() {
            return this.enableBgp;
        }
        
        /**
        * Optional. EnableBgp flag
        * @param enableBgpValue The EnableBgp value.
        */
        public void setEnableBgp(final boolean enableBgpValue) {
            this.enableBgp = enableBgpValue;
        }
        
        private String gatewayId;
        
        /**
        * Optional. The local network Gateway Id
        * @return The GatewayId value.
        */
        public String getGatewayId() {
            return this.gatewayId;
        }
        
        /**
        * Optional. The local network Gateway Id
        * @param gatewayIdValue The GatewayId value.
        */
        public void setGatewayId(final String gatewayIdValue) {
            this.gatewayId = gatewayIdValue;
        }
        
        private String gatewayName;
        
        /**
        * Optional. The virtual network gateway Name.
        * @return The GatewayName value.
        */
        public String getGatewayName() {
            return this.gatewayName;
        }
        
        /**
        * Optional. The virtual network gateway Name.
        * @param gatewayNameValue The GatewayName value.
        */
        public void setGatewayName(final String gatewayNameValue) {
            this.gatewayName = gatewayNameValue;
        }
        
        private String gatewaySKU;
        
        /**
        * Optional. The SKU for this virtual network gateway.
        * @return The GatewaySKU value.
        */
        public String getGatewaySKU() {
            return this.gatewaySKU;
        }
        
        /**
        * Optional. The SKU for this virtual network gateway.
        * @param gatewaySKUValue The GatewaySKU value.
        */
        public void setGatewaySKU(final String gatewaySKUValue) {
            this.gatewaySKU = gatewaySKUValue;
        }
        
        private String gatewayType;
        
        /**
        * Optional. The type of gateway routing used for this virtual network.
        * @return The GatewayType value.
        */
        public String getGatewayType() {
            return this.gatewayType;
        }
        
        /**
        * Optional. The type of gateway routing used for this virtual network.
        * @param gatewayTypeValue The GatewayType value.
        */
        public void setGatewayType(final String gatewayTypeValue) {
            this.gatewayType = gatewayTypeValue;
        }
        
        private GatewayEvent lastEvent;
        
        /**
        * Optional. The last recorded event for this virtual network gateway.
        * @return The LastEvent value.
        */
        public GatewayEvent getLastEvent() {
            return this.lastEvent;
        }
        
        /**
        * Optional. The last recorded event for this virtual network gateway.
        * @param lastEventValue The LastEvent value.
        */
        public void setLastEvent(final GatewayEvent lastEventValue) {
            this.lastEvent = lastEventValue;
        }
        
        private String location;
        
        /**
        * Optional. Location
        * @return The Location value.
        */
        public String getLocation() {
            return this.location;
        }
        
        /**
        * Optional. Location
        * @param locationValue The Location value.
        */
        public void setLocation(final String locationValue) {
            this.location = locationValue;
        }
        
        private String state;
        
        /**
        * Optional. The provisioning state of the virtual network gateway.
        * @return The State value.
        */
        public String getState() {
            return this.state;
        }
        
        /**
        * Optional. The provisioning state of the virtual network gateway.
        * @param stateValue The State value.
        */
        public void setState(final String stateValue) {
            this.state = stateValue;
        }
        
        private String subnetId;
        
        /**
        * Optional. SubnetId
        * @return The SubnetId value.
        */
        public String getSubnetId() {
            return this.subnetId;
        }
        
        /**
        * Optional. SubnetId
        * @param subnetIdValue The SubnetId value.
        */
        public void setSubnetId(final String subnetIdValue) {
            this.subnetId = subnetIdValue;
        }
        
        private String vipAddress;
        
        /**
        * Optional. The virtual IP address for this virtual network gateway.
        * @return The VipAddress value.
        */
        public String getVipAddress() {
            return this.vipAddress;
        }
        
        /**
        * Optional. The virtual IP address for this virtual network gateway.
        * @param vipAddressValue The VipAddress value.
        */
        public void setVipAddress(final String vipAddressValue) {
            this.vipAddress = vipAddressValue;
        }
        
        private String vnetId;
        
        /**
        * Optional. VnetId
        * @return The VnetId value.
        */
        public String getVnetId() {
            return this.vnetId;
        }
        
        /**
        * Optional. VnetId
        * @param vnetIdValue The VnetId value.
        */
        public void setVnetId(final String vnetIdValue) {
            this.vnetId = vnetIdValue;
        }
    }
}
