/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.network.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

/**
* Parameters supplied to the Create Local Network Gateway operation.
*/
public class LocalNetworkGatewayCreateParameters {
    private ArrayList<String> addressSpace;
    
    /**
    * Optional. Address space of local network gateway
    * @return The AddressSpace value.
    */
    public ArrayList<String> getAddressSpace() {
        return this.addressSpace;
    }
    
    /**
    * Optional. Address space of local network gateway
    * @param addressSpaceValue The AddressSpace value.
    */
    public void setAddressSpace(final ArrayList<String> addressSpaceValue) {
        this.addressSpace = addressSpaceValue;
    }
    
    private String gatewayName;
    
    /**
    * Optional. The name of the local network gateway.
    * @return The GatewayName value.
    */
    public String getGatewayName() {
        return this.gatewayName;
    }
    
    /**
    * Optional. The name of the local network gateway.
    * @param gatewayNameValue The GatewayName value.
    */
    public void setGatewayName(final String gatewayNameValue) {
        this.gatewayName = gatewayNameValue;
    }
    
    private String ipAddress;
    
    /**
    * Optional. The Ip address of the local network gateway.
    * @return The IpAddress value.
    */
    public String getIpAddress() {
        return this.ipAddress;
    }
    
    /**
    * Optional. The Ip address of the local network gateway.
    * @param ipAddressValue The IpAddress value.
    */
    public void setIpAddress(final String ipAddressValue) {
        this.ipAddress = ipAddressValue;
    }
    
    /**
    * Initializes a new instance of the LocalNetworkGatewayCreateParameters
    * class.
    *
    */
    public LocalNetworkGatewayCreateParameters() {
        this.setAddressSpace(new LazyArrayList<String>());
    }
}
