/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.network.models;

import com.microsoft.windowsazure.core.OperationResponse;

/**
* The Create Local Network Gateway operation response.
*/
public class LocalNetworkGatewayCreateResponse extends OperationResponse {
    private String localNetworkGatewayId;
    
    /**
    * Required. The local network gateway Id.
    * @return The LocalNetworkGatewayId value.
    */
    public String getLocalNetworkGatewayId() {
        return this.localNetworkGatewayId;
    }
    
    /**
    * Required. The local network gateway Id.
    * @param localNetworkGatewayIdValue The LocalNetworkGatewayId value.
    */
    public void setLocalNetworkGatewayId(final String localNetworkGatewayIdValue) {
        this.localNetworkGatewayId = localNetworkGatewayIdValue;
    }
    
    /**
    * Initializes a new instance of the LocalNetworkGatewayCreateResponse class.
    *
    */
    public LocalNetworkGatewayCreateResponse() {
        super();
    }
    
    /**
    * Initializes a new instance of the LocalNetworkGatewayCreateResponse class
    * with required arguments.
    *
    * @param localNetworkGatewayId The local network gateway Id.
    */
    public LocalNetworkGatewayCreateResponse(String localNetworkGatewayId) {
        if (localNetworkGatewayId == null) {
            throw new NullPointerException("localNetworkGatewayId");
        }
        this.setLocalNetworkGatewayId(localNetworkGatewayId);
    }
}
