/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.network.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Iterator;

/**
* The List Definitions operation response.
*/
public class NetworkSecurityGroupListResponse extends OperationResponse implements Iterable<NetworkSecurityGroup> {
    private ArrayList<NetworkSecurityGroup> networkSecurityGroups;
    
    /**
    * Optional. All Network Security Groups in a subscription.
    * @return The NetworkSecurityGroups value.
    */
    public ArrayList<NetworkSecurityGroup> getNetworkSecurityGroups() {
        return this.networkSecurityGroups;
    }
    
    /**
    * Optional. All Network Security Groups in a subscription.
    * @param networkSecurityGroupsValue The NetworkSecurityGroups value.
    */
    public void setNetworkSecurityGroups(final ArrayList<NetworkSecurityGroup> networkSecurityGroupsValue) {
        this.networkSecurityGroups = networkSecurityGroupsValue;
    }
    
    /**
    * Initializes a new instance of the NetworkSecurityGroupListResponse class.
    *
    */
    public NetworkSecurityGroupListResponse() {
        super();
        this.setNetworkSecurityGroups(new LazyArrayList<NetworkSecurityGroup>());
    }
    
    /**
    * Gets the sequence of NetworkSecurityGroups.
    *
    */
    public Iterator<NetworkSecurityGroup> iterator() {
        return this.getNetworkSecurityGroups().iterator();
    }
}
