/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.network.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.net.InetAddress;
import java.util.ArrayList;

/**
* A response that indicates the availability of a static IP address, and if
* not, provides a list of suggestions.
*/
public class NetworkStaticIPAvailabilityResponse extends OperationResponse {
    private ArrayList<InetAddress> availableAddresses;
    
    /**
    * Optional. The list of the available IP addresses.
    * @return The AvailableAddresses value.
    */
    public ArrayList<InetAddress> getAvailableAddresses() {
        return this.availableAddresses;
    }
    
    /**
    * Optional. The list of the available IP addresses.
    * @param availableAddressesValue The AvailableAddresses value.
    */
    public void setAvailableAddresses(final ArrayList<InetAddress> availableAddressesValue) {
        this.availableAddresses = availableAddressesValue;
    }
    
    private boolean isAvailable;
    
    /**
    * Optional. Whether the IP address is available.
    * @return The IsAvailable value.
    */
    public boolean isAvailable() {
        return this.isAvailable;
    }
    
    /**
    * Optional. Whether the IP address is available.
    * @param isAvailableValue The IsAvailable value.
    */
    public void setIsAvailable(final boolean isAvailableValue) {
        this.isAvailable = isAvailableValue;
    }
    
    /**
    * Initializes a new instance of the NetworkStaticIPAvailabilityResponse
    * class.
    *
    */
    public NetworkStaticIPAvailabilityResponse() {
        super();
        this.setAvailableAddresses(new LazyArrayList<InetAddress>());
    }
}
