/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.network.models;

/**
* Represents the parameters necessary to the update a gateway connection
*/
public class UpdateGatewayConnectionParameters {
    private int routingWeight;
    
    /**
    * Required. The Routing Weight
    * @return The RoutingWeight value.
    */
    public int getRoutingWeight() {
        return this.routingWeight;
    }
    
    /**
    * Required. The Routing Weight
    * @param routingWeightValue The RoutingWeight value.
    */
    public void setRoutingWeight(final int routingWeightValue) {
        this.routingWeight = routingWeightValue;
    }
    
    private String sharedKey;
    
    /**
    * Optional. Ipsec share key
    * @return The SharedKey value.
    */
    public String getSharedKey() {
        return this.sharedKey;
    }
    
    /**
    * Optional. Ipsec share key
    * @param sharedKeyValue The SharedKey value.
    */
    public void setSharedKey(final String sharedKeyValue) {
        this.sharedKey = sharedKeyValue;
    }
    
    /**
    * Initializes a new instance of the UpdateGatewayConnectionParameters class.
    *
    */
    public UpdateGatewayConnectionParameters() {
    }
    
    /**
    * Initializes a new instance of the UpdateGatewayConnectionParameters class
    * with required arguments.
    *
    * @param routingWeight The Routing Weight
    */
    public UpdateGatewayConnectionParameters(int routingWeight) {
        this.setRoutingWeight(routingWeight);
    }
}
