/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.scheduler;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.CloudError;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.scheduler.models.CloudServiceCreateParameters;
import com.microsoft.windowsazure.management.scheduler.models.CloudServiceGetResponse;
import com.microsoft.windowsazure.management.scheduler.models.CloudServiceListResponse;
import com.microsoft.windowsazure.management.scheduler.models.CloudServiceOperationStatus;
import com.microsoft.windowsazure.management.scheduler.models.CloudServiceOperationStatusResponse;
import com.microsoft.windowsazure.management.scheduler.models.Error;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class CloudServiceOperationsImpl implements ServiceOperations<CloudServiceManagementClientImpl>, CloudServiceOperations {
    /**
    * Initializes a new instance of the CloudServiceOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    CloudServiceOperationsImpl(CloudServiceManagementClientImpl client) {
        this.client = client;
    }
    
    private CloudServiceManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.windowsazure.management.scheduler.CloudServiceManagementClientImpl.
    * @return The Client value.
    */
    public CloudServiceManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Create a cloud service.
    *
    * @param cloudServiceName Required. The cloud service name.
    * @param parameters Required. Parameters supplied to the Create cloud
    * service operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginCreatingAsync(final String cloudServiceName, final CloudServiceCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginCreating(cloudServiceName, parameters);
            }
         });
    }
    
    /**
    * Create a cloud service.
    *
    * @param cloudServiceName Required. The cloud service name.
    * @param parameters Required. Parameters supplied to the Create cloud
    * service operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginCreating(String cloudServiceName, CloudServiceCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (cloudServiceName == null) {
            throw new NullPointerException("cloudServiceName");
        }
        if (cloudServiceName.length() > 100) {
            throw new IllegalArgumentException("cloudServiceName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getDescription() == null) {
            throw new NullPointerException("parameters.Description");
        }
        if (parameters.getDescription().length() > 1024) {
            throw new IllegalArgumentException("parameters.Description");
        }
        if (parameters.getGeoRegion() == null) {
            throw new NullPointerException("parameters.GeoRegion");
        }
        if (parameters.getLabel() == null) {
            throw new NullPointerException("parameters.Label");
        }
        if (parameters.getLabel().length() > 100) {
            throw new IllegalArgumentException("parameters.Label");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("cloudServiceName", cloudServiceName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginCreatingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/CloudServices/";
        url = url + URLEncoder.encode(cloudServiceName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2013-03-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element cloudServiceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CloudService");
        requestDoc.appendChild(cloudServiceElement);
        
        Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
        labelElement.appendChild(requestDoc.createTextNode(parameters.getLabel()));
        cloudServiceElement.appendChild(labelElement);
        
        Element descriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Description");
        descriptionElement.appendChild(requestDoc.createTextNode(parameters.getDescription()));
        cloudServiceElement.appendChild(descriptionElement);
        
        Element geoRegionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "GeoRegion");
        geoRegionElement.appendChild(requestDoc.createTextNode(parameters.getGeoRegion()));
        cloudServiceElement.appendChild(geoRegionElement);
        
        if (parameters.getEmail() != null) {
            Element emailElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Email");
            emailElement.appendChild(requestDoc.createTextNode(parameters.getEmail()));
            cloudServiceElement.appendChild(emailElement);
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Delete a cloud service.
    *
    * @param cloudServiceName Required. The cloud service name.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginDeletingAsync(final String cloudServiceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginDeleting(cloudServiceName);
            }
         });
    }
    
    /**
    * Delete a cloud service.
    *
    * @param cloudServiceName Required. The cloud service name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginDeleting(String cloudServiceName) throws IOException, ServiceException {
        // Validate
        if (cloudServiceName == null) {
            throw new NullPointerException("cloudServiceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("cloudServiceName", cloudServiceName);
            CloudTracing.enter(invocationId, this, "beginDeletingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/CloudServices/";
        url = url + URLEncoder.encode(cloudServiceName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2013-03-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Create a cloud service.
    *
    * @param cloudServiceName Required. The cloud service name.
    * @param parameters Required. Parameters supplied to the Create cloud
    * service operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request.  If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    @Override
    public Future<CloudServiceOperationStatusResponse> createAsync(final String cloudServiceName, final CloudServiceCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<CloudServiceOperationStatusResponse>() { 
            @Override
            public CloudServiceOperationStatusResponse call() throws Exception {
                return create(cloudServiceName, parameters);
            }
         });
    }
    
    /**
    * Create a cloud service.
    *
    * @param cloudServiceName Required. The cloud service name.
    * @param parameters Required. Parameters supplied to the Create cloud
    * service operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request.  If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    @Override
    public CloudServiceOperationStatusResponse create(String cloudServiceName, CloudServiceCreateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        CloudServiceManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("cloudServiceName", cloudServiceName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getCloudServicesOperations().beginCreatingAsync(cloudServiceName, parameters).get();
            CloudServiceOperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 10;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(CloudServiceOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 5;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != CloudServiceOperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * Delete a cloud service.
    *
    * @param cloudServiceName Required. The cloud service name.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request.  If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    @Override
    public Future<CloudServiceOperationStatusResponse> deleteAsync(final String cloudServiceName) {
        return this.getClient().getExecutorService().submit(new Callable<CloudServiceOperationStatusResponse>() { 
            @Override
            public CloudServiceOperationStatusResponse call() throws Exception {
                return delete(cloudServiceName);
            }
         });
    }
    
    /**
    * Delete a cloud service.
    *
    * @param cloudServiceName Required. The cloud service name.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request.  If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request, and also includes error information regarding the
    * failure.
    */
    @Override
    public CloudServiceOperationStatusResponse delete(String cloudServiceName) throws InterruptedException, ExecutionException, ServiceException, IOException {
        CloudServiceManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("cloudServiceName", cloudServiceName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getCloudServicesOperations().beginDeletingAsync(cloudServiceName).get();
            CloudServiceOperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 10;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(CloudServiceOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 5;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != CloudServiceOperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * Retreive a cloud service.
    *
    * @param cloudServiceName Required. The cloud service name.
    * @return Information about a retrieved Cloud Service.
    */
    @Override
    public Future<CloudServiceGetResponse> getAsync(final String cloudServiceName) {
        return this.getClient().getExecutorService().submit(new Callable<CloudServiceGetResponse>() { 
            @Override
            public CloudServiceGetResponse call() throws Exception {
                return get(cloudServiceName);
            }
         });
    }
    
    /**
    * Retreive a cloud service.
    *
    * @param cloudServiceName Required. The cloud service name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return Information about a retrieved Cloud Service.
    */
    @Override
    public CloudServiceGetResponse get(String cloudServiceName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        if (cloudServiceName == null) {
            throw new NullPointerException("cloudServiceName");
        }
        if (cloudServiceName.length() > 100) {
            throw new IllegalArgumentException("cloudServiceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("cloudServiceName", cloudServiceName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/CloudServices/";
        url = url + URLEncoder.encode(cloudServiceName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2013-03-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            CloudServiceGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new CloudServiceGetResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element cloudServiceElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "CloudService");
                if (cloudServiceElement != null) {
                    Element geoLocationElement = XmlUtility.getElementByTagNameNS(cloudServiceElement, "http://schemas.microsoft.com/windowsazure", "GeoLocation");
                    if (geoLocationElement != null) {
                        String geoLocationInstance;
                        geoLocationInstance = geoLocationElement.getTextContent();
                        result.setGeoLocation(geoLocationInstance);
                    }
                    
                    Element resourcesSequenceElement = XmlUtility.getElementByTagNameNS(cloudServiceElement, "http://schemas.microsoft.com/windowsazure", "Resources");
                    if (resourcesSequenceElement != null) {
                        for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(resourcesSequenceElement, "http://schemas.microsoft.com/windowsazure", "Resource").size(); i1 = i1 + 1) {
                            org.w3c.dom.Element resourcesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(resourcesSequenceElement, "http://schemas.microsoft.com/windowsazure", "Resource").get(i1));
                            CloudServiceGetResponse.Resource resourceInstance = new CloudServiceGetResponse.Resource();
                            result.getResources().add(resourceInstance);
                            
                            Element resourceProviderNamespaceElement = XmlUtility.getElementByTagNameNS(resourcesElement, "http://schemas.microsoft.com/windowsazure", "ResourceProviderNamespace");
                            if (resourceProviderNamespaceElement != null) {
                                String resourceProviderNamespaceInstance;
                                resourceProviderNamespaceInstance = resourceProviderNamespaceElement.getTextContent();
                                resourceInstance.setResourceProviderNamespace(resourceProviderNamespaceInstance);
                            }
                            
                            Element typeElement = XmlUtility.getElementByTagNameNS(resourcesElement, "http://schemas.microsoft.com/windowsazure", "Type");
                            if (typeElement != null) {
                                String typeInstance;
                                typeInstance = typeElement.getTextContent();
                                resourceInstance.setType(typeInstance);
                            }
                            
                            Element eTagElement = XmlUtility.getElementByTagNameNS(resourcesElement, "http://schemas.microsoft.com/windowsazure", "ETag");
                            if (eTagElement != null) {
                                String eTagInstance;
                                eTagInstance = eTagElement.getTextContent();
                                resourceInstance.setETag(eTagInstance);
                            }
                            
                            Element schemaVersionElement = XmlUtility.getElementByTagNameNS(resourcesElement, "http://schemas.microsoft.com/windowsazure", "SchemaVersion");
                            if (schemaVersionElement != null) {
                                String schemaVersionInstance;
                                schemaVersionInstance = schemaVersionElement.getTextContent();
                                resourceInstance.setSchemaVersion(schemaVersionInstance);
                            }
                            
                            Element nameElement = XmlUtility.getElementByTagNameNS(resourcesElement, "http://schemas.microsoft.com/windowsazure", "Name");
                            if (nameElement != null) {
                                String nameInstance;
                                nameInstance = nameElement.getTextContent();
                                resourceInstance.setName(nameInstance);
                            }
                            
                            Element planElement = XmlUtility.getElementByTagNameNS(resourcesElement, "http://schemas.microsoft.com/windowsazure", "Plan");
                            if (planElement != null) {
                                String planInstance;
                                planInstance = planElement.getTextContent();
                                resourceInstance.setPlan(planInstance);
                            }
                            
                            Element outputItemsSequenceElement = XmlUtility.getElementByTagNameNS(resourcesElement, "http://schemas.microsoft.com/windowsazure", "OutputItems");
                            if (outputItemsSequenceElement != null) {
                                for (int i2 = 0; i2 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(outputItemsSequenceElement, "http://schemas.microsoft.com/windowsazure", "OutputItem").size(); i2 = i2 + 1) {
                                    org.w3c.dom.Element outputItemsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(outputItemsSequenceElement, "http://schemas.microsoft.com/windowsazure", "OutputItem").get(i2));
                                    String outputItemsKey = XmlUtility.getElementByTagNameNS(outputItemsElement, "http://schemas.microsoft.com/windowsazure", "Key").getTextContent();
                                    String outputItemsValue = XmlUtility.getElementByTagNameNS(outputItemsElement, "http://schemas.microsoft.com/windowsazure", "Value").getTextContent();
                                    resourceInstance.getOutputItems().put(outputItemsKey, outputItemsValue);
                                }
                            }
                            
                            Element stateElement = XmlUtility.getElementByTagNameNS(resourcesElement, "http://schemas.microsoft.com/windowsazure", "State");
                            if (stateElement != null) {
                                String stateInstance;
                                stateInstance = stateElement.getTextContent();
                                resourceInstance.setState(stateInstance);
                            }
                            
                            Element subStateElement = XmlUtility.getElementByTagNameNS(resourcesElement, "http://schemas.microsoft.com/windowsazure", "SubState");
                            if (subStateElement != null) {
                                String subStateInstance;
                                subStateInstance = subStateElement.getTextContent();
                                resourceInstance.setSubState(subStateInstance);
                            }
                            
                            Element labelElement = XmlUtility.getElementByTagNameNS(resourcesElement, "http://schemas.microsoft.com/windowsazure", "Label");
                            if (labelElement != null) {
                                String labelInstance;
                                labelInstance = labelElement.getTextContent();
                                resourceInstance.setLabel(labelInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The List Cloud Services operation enumerates services that are
    * provisioned for a subscription.
    *
    * @return The response structure for the Cloud Service List operation.
    */
    @Override
    public Future<CloudServiceListResponse> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<CloudServiceListResponse>() { 
            @Override
            public CloudServiceListResponse call() throws Exception {
                return list();
            }
         });
    }
    
    /**
    * The List Cloud Services operation enumerates services that are
    * provisioned for a subscription.
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response structure for the Cloud Service List operation.
    */
    @Override
    public CloudServiceListResponse list() throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/CloudServices";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2013-03-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            CloudServiceListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new CloudServiceListResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element cloudServicesSequenceElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "CloudServices");
                if (cloudServicesSequenceElement != null) {
                    for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(cloudServicesSequenceElement, "http://schemas.microsoft.com/windowsazure", "CloudService").size(); i1 = i1 + 1) {
                        org.w3c.dom.Element cloudServicesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(cloudServicesSequenceElement, "http://schemas.microsoft.com/windowsazure", "CloudService").get(i1));
                        CloudServiceListResponse.CloudService cloudServiceInstance = new CloudServiceListResponse.CloudService();
                        result.getCloudServices().add(cloudServiceInstance);
                        
                        Element nameElement = XmlUtility.getElementByTagNameNS(cloudServicesElement, "http://schemas.microsoft.com/windowsazure", "Name");
                        if (nameElement != null) {
                            String nameInstance;
                            nameInstance = nameElement.getTextContent();
                            cloudServiceInstance.setName(nameInstance);
                        }
                        
                        Element labelElement = XmlUtility.getElementByTagNameNS(cloudServicesElement, "http://schemas.microsoft.com/windowsazure", "Label");
                        if (labelElement != null) {
                            String labelInstance;
                            labelInstance = labelElement.getTextContent();
                            cloudServiceInstance.setLabel(labelInstance);
                        }
                        
                        Element descriptionElement = XmlUtility.getElementByTagNameNS(cloudServicesElement, "http://schemas.microsoft.com/windowsazure", "Description");
                        if (descriptionElement != null) {
                            String descriptionInstance;
                            descriptionInstance = descriptionElement.getTextContent();
                            cloudServiceInstance.setDescription(descriptionInstance);
                        }
                        
                        Element geoRegionElement = XmlUtility.getElementByTagNameNS(cloudServicesElement, "http://schemas.microsoft.com/windowsazure", "GeoRegion");
                        if (geoRegionElement != null) {
                            String geoRegionInstance;
                            geoRegionInstance = geoRegionElement.getTextContent();
                            cloudServiceInstance.setGeoRegion(geoRegionInstance);
                        }
                        
                        Element resourcesSequenceElement = XmlUtility.getElementByTagNameNS(cloudServicesElement, "http://schemas.microsoft.com/windowsazure", "Resources");
                        if (resourcesSequenceElement != null) {
                            for (int i2 = 0; i2 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(resourcesSequenceElement, "http://schemas.microsoft.com/windowsazure", "Resource").size(); i2 = i2 + 1) {
                                org.w3c.dom.Element resourcesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(resourcesSequenceElement, "http://schemas.microsoft.com/windowsazure", "Resource").get(i2));
                                CloudServiceListResponse.CloudService.AddOnResource resourceInstance = new CloudServiceListResponse.CloudService.AddOnResource();
                                cloudServiceInstance.getResources().add(resourceInstance);
                                
                                Element resourceProviderNamespaceElement = XmlUtility.getElementByTagNameNS(resourcesElement, "http://schemas.microsoft.com/windowsazure", "ResourceProviderNamespace");
                                if (resourceProviderNamespaceElement != null) {
                                    String resourceProviderNamespaceInstance;
                                    resourceProviderNamespaceInstance = resourceProviderNamespaceElement.getTextContent();
                                    resourceInstance.setNamespace(resourceProviderNamespaceInstance);
                                }
                                
                                Element typeElement = XmlUtility.getElementByTagNameNS(resourcesElement, "http://schemas.microsoft.com/windowsazure", "Type");
                                if (typeElement != null) {
                                    String typeInstance;
                                    typeInstance = typeElement.getTextContent();
                                    resourceInstance.setType(typeInstance);
                                }
                                
                                Element nameElement2 = XmlUtility.getElementByTagNameNS(resourcesElement, "http://schemas.microsoft.com/windowsazure", "Name");
                                if (nameElement2 != null) {
                                    String nameInstance2;
                                    nameInstance2 = nameElement2.getTextContent();
                                    resourceInstance.setName(nameInstance2);
                                }
                                
                                Element planElement = XmlUtility.getElementByTagNameNS(resourcesElement, "http://schemas.microsoft.com/windowsazure", "Plan");
                                if (planElement != null) {
                                    String planInstance;
                                    planInstance = planElement.getTextContent();
                                    resourceInstance.setPlan(planInstance);
                                }
                                
                                Element schemaVersionElement = XmlUtility.getElementByTagNameNS(resourcesElement, "http://schemas.microsoft.com/windowsazure", "SchemaVersion");
                                if (schemaVersionElement != null) {
                                    String schemaVersionInstance;
                                    schemaVersionInstance = schemaVersionElement.getTextContent();
                                    resourceInstance.setSchemaVersion(schemaVersionInstance);
                                }
                                
                                Element eTagElement = XmlUtility.getElementByTagNameNS(resourcesElement, "http://schemas.microsoft.com/windowsazure", "ETag");
                                if (eTagElement != null) {
                                    String eTagInstance;
                                    eTagInstance = eTagElement.getTextContent();
                                    resourceInstance.setETag(eTagInstance);
                                }
                                
                                Element stateElement = XmlUtility.getElementByTagNameNS(resourcesElement, "http://schemas.microsoft.com/windowsazure", "State");
                                if (stateElement != null) {
                                    String stateInstance;
                                    stateInstance = stateElement.getTextContent();
                                    resourceInstance.setState(stateInstance);
                                }
                                
                                Element usageMetersSequenceElement = XmlUtility.getElementByTagNameNS(resourcesElement, "http://schemas.microsoft.com/windowsazure", "UsageMeters");
                                if (usageMetersSequenceElement != null) {
                                    for (int i3 = 0; i3 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(usageMetersSequenceElement, "http://schemas.microsoft.com/windowsazure", "UsageMeter").size(); i3 = i3 + 1) {
                                        org.w3c.dom.Element usageMetersElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(usageMetersSequenceElement, "http://schemas.microsoft.com/windowsazure", "UsageMeter").get(i3));
                                        CloudServiceListResponse.CloudService.AddOnResource.UsageLimit usageMeterInstance = new CloudServiceListResponse.CloudService.AddOnResource.UsageLimit();
                                        resourceInstance.getUsageLimits().add(usageMeterInstance);
                                        
                                        Element nameElement3 = XmlUtility.getElementByTagNameNS(usageMetersElement, "http://schemas.microsoft.com/windowsazure", "Name");
                                        if (nameElement3 != null) {
                                            String nameInstance3;
                                            nameInstance3 = nameElement3.getTextContent();
                                            usageMeterInstance.setName(nameInstance3);
                                        }
                                        
                                        Element unitElement = XmlUtility.getElementByTagNameNS(usageMetersElement, "http://schemas.microsoft.com/windowsazure", "Unit");
                                        if (unitElement != null) {
                                            String unitInstance;
                                            unitInstance = unitElement.getTextContent();
                                            usageMeterInstance.setUnit(unitInstance);
                                        }
                                        
                                        Element includedElement = XmlUtility.getElementByTagNameNS(usageMetersElement, "http://schemas.microsoft.com/windowsazure", "Included");
                                        if (includedElement != null) {
                                            String includedInstance;
                                            includedInstance = includedElement.getTextContent();
                                            usageMeterInstance.setAmountIncluded(includedInstance);
                                        }
                                        
                                        Element usedElement = XmlUtility.getElementByTagNameNS(usageMetersElement, "http://schemas.microsoft.com/windowsazure", "Used");
                                        if (usedElement != null) {
                                            String usedInstance;
                                            usedInstance = usedElement.getTextContent();
                                            usageMeterInstance.setAmountUsed(usedInstance);
                                        }
                                    }
                                }
                                
                                Element outputItemsSequenceElement = XmlUtility.getElementByTagNameNS(resourcesElement, "http://schemas.microsoft.com/windowsazure", "OutputItems");
                                if (outputItemsSequenceElement != null) {
                                    for (int i4 = 0; i4 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(outputItemsSequenceElement, "http://schemas.microsoft.com/windowsazure", "OutputItem").size(); i4 = i4 + 1) {
                                        org.w3c.dom.Element outputItemsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(outputItemsSequenceElement, "http://schemas.microsoft.com/windowsazure", "OutputItem").get(i4));
                                        String outputItemsKey = XmlUtility.getElementByTagNameNS(outputItemsElement, "http://schemas.microsoft.com/windowsazure", "Key").getTextContent();
                                        String outputItemsValue = XmlUtility.getElementByTagNameNS(outputItemsElement, "http://schemas.microsoft.com/windowsazure", "Value").getTextContent();
                                        resourceInstance.getOutputItems().put(outputItemsKey, outputItemsValue);
                                    }
                                }
                                
                                Element operationStatusElement = XmlUtility.getElementByTagNameNS(resourcesElement, "http://schemas.microsoft.com/windowsazure", "OperationStatus");
                                if (operationStatusElement != null) {
                                    CloudServiceListResponse.CloudService.AddOnResource.OperationStatus operationStatusInstance = new CloudServiceListResponse.CloudService.AddOnResource.OperationStatus();
                                    resourceInstance.setStatus(operationStatusInstance);
                                    
                                    Element typeElement2 = XmlUtility.getElementByTagNameNS(operationStatusElement, "http://schemas.microsoft.com/windowsazure", "Type");
                                    if (typeElement2 != null) {
                                        String typeInstance2;
                                        typeInstance2 = typeElement2.getTextContent();
                                        operationStatusInstance.setType(typeInstance2);
                                    }
                                    
                                    Element resultElement = XmlUtility.getElementByTagNameNS(operationStatusElement, "http://schemas.microsoft.com/windowsazure", "Result");
                                    if (resultElement != null) {
                                        String resultInstance;
                                        resultInstance = resultElement.getTextContent();
                                        operationStatusInstance.setResult(resultInstance);
                                    }
                                    
                                    Element errorElement = XmlUtility.getElementByTagNameNS(operationStatusElement, "http://schemas.microsoft.com/windowsazure", "Error");
                                    if (errorElement != null) {
                                        Error errorInstance = new Error();
                                        operationStatusInstance.setError(errorInstance);
                                        
                                        Element httpCodeElement = XmlUtility.getElementByTagNameNS(errorElement, "http://schemas.microsoft.com/windowsazure", "HttpCode");
                                        if (httpCodeElement != null) {
                                            String httpCodeInstance;
                                            httpCodeInstance = httpCodeElement.getTextContent();
                                            errorInstance.setHttpCode(httpCodeInstance);
                                        }
                                        
                                        Element messageElement = XmlUtility.getElementByTagNameNS(errorElement, "http://schemas.microsoft.com/windowsazure", "Message");
                                        if (messageElement != null) {
                                            String messageInstance;
                                            messageInstance = messageElement.getTextContent();
                                            errorInstance.setMessage(messageInstance);
                                        }
                                        
                                        Element extendedCodeElement = XmlUtility.getElementByTagNameNS(errorElement, "http://schemas.microsoft.com/windowsazure", "ExtendedCode");
                                        if (extendedCodeElement != null) {
                                            String extendedCodeInstance;
                                            extendedCodeInstance = extendedCodeElement.getTextContent();
                                            errorInstance.setExtendedCode(extendedCodeInstance);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
