/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.scheduler.models;

public class CloudServiceCreateParameters {
    private String description;
    
    /**
    * Required. Description for the cloud service.
    * @return The Description value.
    */
    public String getDescription() {
        return this.description;
    }
    
    /**
    * Required. Description for the cloud service.
    * @param descriptionValue The Description value.
    */
    public void setDescription(final String descriptionValue) {
        this.description = descriptionValue;
    }
    
    private String email;
    
    /**
    * Optional. Optional e-mail address to associate with the service.
    * @return The Email value.
    */
    public String getEmail() {
        return this.email;
    }
    
    /**
    * Optional. Optional e-mail address to associate with the service.
    * @param emailValue The Email value.
    */
    public void setEmail(final String emailValue) {
        this.email = emailValue;
    }
    
    private String geoRegion;
    
    /**
    * Required. The region for the cloud service. This field cannot be updated
    * after the cloud service is created.
    * @return The GeoRegion value.
    */
    public String getGeoRegion() {
        return this.geoRegion;
    }
    
    /**
    * Required. The region for the cloud service. This field cannot be updated
    * after the cloud service is created.
    * @param geoRegionValue The GeoRegion value.
    */
    public void setGeoRegion(final String geoRegionValue) {
        this.geoRegion = geoRegionValue;
    }
    
    private String label;
    
    /**
    * Required. Label for the cloud service.
    * @return The Label value.
    */
    public String getLabel() {
        return this.label;
    }
    
    /**
    * Required. Label for the cloud service.
    * @param labelValue The Label value.
    */
    public void setLabel(final String labelValue) {
        this.label = labelValue;
    }
    
    /**
    * Initializes a new instance of the CloudServiceCreateParameters class.
    *
    */
    public CloudServiceCreateParameters() {
    }
    
    /**
    * Initializes a new instance of the CloudServiceCreateParameters class with
    * required arguments.
    *
    * @param label Label for the cloud service.
    * @param description Description for the cloud service.
    * @param geoRegion The region for the cloud service. This field cannot be
    * updated after the cloud service is created.
    */
    public CloudServiceCreateParameters(String label, String description, String geoRegion) {
        if (label == null) {
            throw new NullPointerException("label");
        }
        if (description == null) {
            throw new NullPointerException("description");
        }
        if (geoRegion == null) {
            throw new NullPointerException("geoRegion");
        }
        this.setLabel(label);
        this.setDescription(description);
        this.setGeoRegion(geoRegion);
    }
}
