/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.scheduler.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.LazyHashMap;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

/**
* The response structure for the Cloud Service List operation.
*/
public class CloudServiceListResponse extends OperationResponse implements Iterable<CloudServiceListResponse.CloudService> {
    private ArrayList<CloudServiceListResponse.CloudService> cloudServices;
    
    /**
    * Optional. The list of cloud service locations for this subscription.
    * @return The CloudServices value.
    */
    public ArrayList<CloudServiceListResponse.CloudService> getCloudServices() {
        return this.cloudServices;
    }
    
    /**
    * Optional. The list of cloud service locations for this subscription.
    * @param cloudServicesValue The CloudServices value.
    */
    public void setCloudServices(final ArrayList<CloudServiceListResponse.CloudService> cloudServicesValue) {
        this.cloudServices = cloudServicesValue;
    }
    
    /**
    * Initializes a new instance of the CloudServiceListResponse class.
    *
    */
    public CloudServiceListResponse() {
        super();
        this.setCloudServices(new LazyArrayList<CloudServiceListResponse.CloudService>());
    }
    
    /**
    * Gets the sequence of CloudServices.
    *
    */
    public Iterator<CloudServiceListResponse.CloudService> iterator() {
        return this.getCloudServices().iterator();
    }
    
    /**
    * Defines a cloud service-supporting region in which a item is located.
    */
    public static class CloudService {
        private String description;
        
        /**
        * Optional. The description of the cloud service region.
        * @return The Description value.
        */
        public String getDescription() {
            return this.description;
        }
        
        /**
        * Optional. The description of the cloud service region.
        * @param descriptionValue The Description value.
        */
        public void setDescription(final String descriptionValue) {
            this.description = descriptionValue;
        }
        
        private String geoRegion;
        
        /**
        * Optional. The geographical region in which this cloud service can run.
        * @return The GeoRegion value.
        */
        public String getGeoRegion() {
            return this.geoRegion;
        }
        
        /**
        * Optional. The geographical region in which this cloud service can run.
        * @param geoRegionValue The GeoRegion value.
        */
        public void setGeoRegion(final String geoRegionValue) {
            this.geoRegion = geoRegionValue;
        }
        
        private String label;
        
        /**
        * Optional. The label of the cloud service region.
        * @return The Label value.
        */
        public String getLabel() {
            return this.label;
        }
        
        /**
        * Optional. The label of the cloud service region.
        * @param labelValue The Label value.
        */
        public void setLabel(final String labelValue) {
            this.label = labelValue;
        }
        
        private String name;
        
        /**
        * Optional. The name of the cloud service region.
        * @return The Name value.
        */
        public String getName() {
            return this.name;
        }
        
        /**
        * Optional. The name of the cloud service region.
        * @param nameValue The Name value.
        */
        public void setName(final String nameValue) {
            this.name = nameValue;
        }
        
        private ArrayList<CloudServiceListResponse.CloudService.AddOnResource> resources;
        
        /**
        * Optional. A list of existing resources installed into a cloud service
        * region.
        * @return The Resources value.
        */
        public ArrayList<CloudServiceListResponse.CloudService.AddOnResource> getResources() {
            return this.resources;
        }
        
        /**
        * Optional. A list of existing resources installed into a cloud service
        * region.
        * @param resourcesValue The Resources value.
        */
        public void setResources(final ArrayList<CloudServiceListResponse.CloudService.AddOnResource> resourcesValue) {
            this.resources = resourcesValue;
        }
        
        /**
        * Initializes a new instance of the CloudService class.
        *
        */
        public CloudService() {
            this.setResources(new LazyArrayList<CloudServiceListResponse.CloudService.AddOnResource>());
        }
        
        /**
        * A store add-on item.
        */
        public static class AddOnResource {
            private String eTag;
            
            /**
            * Optional. The ETag for this resource.
            * @return The ETag value.
            */
            public String getETag() {
                return this.eTag;
            }
            
            /**
            * Optional. The ETag for this resource.
            * @param eTagValue The ETag value.
            */
            public void setETag(final String eTagValue) {
                this.eTag = eTagValue;
            }
            
            private String name;
            
            /**
            * Optional. The user-input name of this item.
            * @return The Name value.
            */
            public String getName() {
                return this.name;
            }
            
            /**
            * Optional. The user-input name of this item.
            * @param nameValue The Name value.
            */
            public void setName(final String nameValue) {
                this.name = nameValue;
            }
            
            private String namespace;
            
            /**
            * Optional. The namespace in which this item resides.
            * @return The Namespace value.
            */
            public String getNamespace() {
                return this.namespace;
            }
            
            /**
            * Optional. The namespace in which this item resides.
            * @param namespaceValue The Namespace value.
            */
            public void setNamespace(final String namespaceValue) {
                this.namespace = namespaceValue;
            }
            
            private HashMap<String, String> outputItems;
            
            /**
            * Optional. Output items associated with an individual resource.
            * @return The OutputItems value.
            */
            public HashMap<String, String> getOutputItems() {
                return this.outputItems;
            }
            
            /**
            * Optional. Output items associated with an individual resource.
            * @param outputItemsValue The OutputItems value.
            */
            public void setOutputItems(final HashMap<String, String> outputItemsValue) {
                this.outputItems = outputItemsValue;
            }
            
            private String plan;
            
            /**
            * Optional. The plan for this item as selected by the user.
            * @return The Plan value.
            */
            public String getPlan() {
                return this.plan;
            }
            
            /**
            * Optional. The plan for this item as selected by the user.
            * @param planValue The Plan value.
            */
            public void setPlan(final String planValue) {
                this.plan = planValue;
            }
            
            private String schemaVersion;
            
            /**
            * Optional. The schema version for this resource.
            * @return The SchemaVersion value.
            */
            public String getSchemaVersion() {
                return this.schemaVersion;
            }
            
            /**
            * Optional. The schema version for this resource.
            * @param schemaVersionValue The SchemaVersion value.
            */
            public void setSchemaVersion(final String schemaVersionValue) {
                this.schemaVersion = schemaVersionValue;
            }
            
            private String state;
            
            /**
            * Optional. The state of this resource.
            * @return The State value.
            */
            public String getState() {
                return this.state;
            }
            
            /**
            * Optional. The state of this resource.
            * @param stateValue The State value.
            */
            public void setState(final String stateValue) {
                this.state = stateValue;
            }
            
            private CloudServiceListResponse.CloudService.AddOnResource.OperationStatus status;
            
            /**
            * Optional. Operation status items associated with an individual
            * resource.
            * @return The Status value.
            */
            public CloudServiceListResponse.CloudService.AddOnResource.OperationStatus getStatus() {
                return this.status;
            }
            
            /**
            * Optional. Operation status items associated with an individual
            * resource.
            * @param statusValue The Status value.
            */
            public void setStatus(final CloudServiceListResponse.CloudService.AddOnResource.OperationStatus statusValue) {
                this.status = statusValue;
            }
            
            private String type;
            
            /**
            * Optional. The type of store item.
            * @return The Type value.
            */
            public String getType() {
                return this.type;
            }
            
            /**
            * Optional. The type of store item.
            * @param typeValue The Type value.
            */
            public void setType(final String typeValue) {
                this.type = typeValue;
            }
            
            private ArrayList<CloudServiceListResponse.CloudService.AddOnResource.UsageLimit> usageLimits;
            
            /**
            * Optional. Usage meters associated with an individual resource.
            * @return The UsageLimits value.
            */
            public ArrayList<CloudServiceListResponse.CloudService.AddOnResource.UsageLimit> getUsageLimits() {
                return this.usageLimits;
            }
            
            /**
            * Optional. Usage meters associated with an individual resource.
            * @param usageLimitsValue The UsageLimits value.
            */
            public void setUsageLimits(final ArrayList<CloudServiceListResponse.CloudService.AddOnResource.UsageLimit> usageLimitsValue) {
                this.usageLimits = usageLimitsValue;
            }
            
            /**
            * Initializes a new instance of the AddOnResource class.
            *
            */
            public AddOnResource() {
                this.setOutputItems(new LazyHashMap<String, String>());
                this.setUsageLimits(new LazyArrayList<CloudServiceListResponse.CloudService.AddOnResource.UsageLimit>());
            }
            
            /**
            * The operation status of an individual resource item.
            */
            public static class OperationStatus {
                private Error error;
                
                /**
                * Optional. The error details for operations that failed.
                * @return The Error value.
                */
                public Error getError() {
                    return this.error;
                }
                
                /**
                * Optional. The error details for operations that failed.
                * @param errorValue The Error value.
                */
                public void setError(final Error errorValue) {
                    this.error = errorValue;
                }
                
                private String result;
                
                /**
                * Optional. The result of this operation status.
                * @return The Result value.
                */
                public String getResult() {
                    return this.result;
                }
                
                /**
                * Optional. The result of this operation status.
                * @param resultValue The Result value.
                */
                public void setResult(final String resultValue) {
                    this.result = resultValue;
                }
                
                private String type;
                
                /**
                * Optional. The type of this operation status.
                * @return The Type value.
                */
                public String getType() {
                    return this.type;
                }
                
                /**
                * Optional. The type of this operation status.
                * @param typeValue The Type value.
                */
                public void setType(final String typeValue) {
                    this.type = typeValue;
                }
            }
            
            /**
            * Describes the current utilization and metering of a resource item.
            */
            public static class UsageLimit {
                private String amountIncluded;
                
                /**
                * Optional. Defines the limit of this usage included in this
                * resource's plan.
                * @return The AmountIncluded value.
                */
                public String getAmountIncluded() {
                    return this.amountIncluded;
                }
                
                /**
                * Optional. Defines the limit of this usage included in this
                * resource's plan.
                * @param amountIncludedValue The AmountIncluded value.
                */
                public void setAmountIncluded(final String amountIncludedValue) {
                    this.amountIncluded = amountIncludedValue;
                }
                
                private String amountUsed;
                
                /**
                * Optional. The amount of this resource that has already been
                * used.
                * @return The AmountUsed value.
                */
                public String getAmountUsed() {
                    return this.amountUsed;
                }
                
                /**
                * Optional. The amount of this resource that has already been
                * used.
                * @param amountUsedValue The AmountUsed value.
                */
                public void setAmountUsed(final String amountUsedValue) {
                    this.amountUsed = amountUsedValue;
                }
                
                private String name;
                
                /**
                * Optional. The name of this usage limit.
                * @return The Name value.
                */
                public String getName() {
                    return this.name;
                }
                
                /**
                * Optional. The name of this usage limit.
                * @param nameValue The Name value.
                */
                public void setName(final String nameValue) {
                    this.name = nameValue;
                }
                
                private String unit;
                
                /**
                * Optional. The unit in which this usage limit is measured.
                * @return The Unit value.
                */
                public String getUnit() {
                    return this.unit;
                }
                
                /**
                * Optional. The unit in which this usage limit is measured.
                * @param unitValue The Unit value.
                */
                public void setUnit(final String unitValue) {
                    this.unit = unitValue;
                }
            }
        }
    }
}
