/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.scheduler.models;

import com.microsoft.windowsazure.core.OperationResponse;

/**
* The Get Job Collection operation response.
*/
public class JobCollectionGetResponse extends OperationResponse {
    private String eTag;
    
    /**
    * Optional. ETag of the Job Collection.
    * @return The ETag value.
    */
    public String getETag() {
        return this.eTag;
    }
    
    /**
    * Optional. ETag of the Job Collection.
    * @param eTagValue The ETag value.
    */
    public void setETag(final String eTagValue) {
        this.eTag = eTagValue;
    }
    
    private JobCollectionIntrinsicSettings intrinsicSettings;
    
    /**
    * Optional. Intrinsic settings for the scheduler job collections.
    * @return The IntrinsicSettings value.
    */
    public JobCollectionIntrinsicSettings getIntrinsicSettings() {
        return this.intrinsicSettings;
    }
    
    /**
    * Optional. Intrinsic settings for the scheduler job collections.
    * @param intrinsicSettingsValue The IntrinsicSettings value.
    */
    public void setIntrinsicSettings(final JobCollectionIntrinsicSettings intrinsicSettingsValue) {
        this.intrinsicSettings = intrinsicSettingsValue;
    }
    
    private String label;
    
    /**
    * Optional. Label for the resource.
    * @return The Label value.
    */
    public String getLabel() {
        return this.label;
    }
    
    /**
    * Optional. Label for the resource.
    * @param labelValue The Label value.
    */
    public void setLabel(final String labelValue) {
        this.label = labelValue;
    }
    
    private JobCollectionGetResponse.OperationStatus lastOperationStatus;
    
    /**
    * Optional. The promotion code for buying the resource.
    * @return The LastOperationStatus value.
    */
    public JobCollectionGetResponse.OperationStatus getLastOperationStatus() {
        return this.lastOperationStatus;
    }
    
    /**
    * Optional. The promotion code for buying the resource.
    * @param lastOperationStatusValue The LastOperationStatus value.
    */
    public void setLastOperationStatus(final JobCollectionGetResponse.OperationStatus lastOperationStatusValue) {
        this.lastOperationStatus = lastOperationStatusValue;
    }
    
    private String name;
    
    /**
    * Optional. Name of the Job Collection.
    * @return The Name value.
    */
    public String getName() {
        return this.name;
    }
    
    /**
    * Optional. Name of the Job Collection.
    * @param nameValue The Name value.
    */
    public void setName(final String nameValue) {
        this.name = nameValue;
    }
    
    private String promotionCode;
    
    /**
    * Optional. The promotion code for buying the resource.
    * @return The PromotionCode value.
    */
    public String getPromotionCode() {
        return this.promotionCode;
    }
    
    /**
    * Optional. The promotion code for buying the resource.
    * @param promotionCodeValue The PromotionCode value.
    */
    public void setPromotionCode(final String promotionCodeValue) {
        this.promotionCode = promotionCodeValue;
    }
    
    private String schemaVersion;
    
    /**
    * Optional. The version of the Intrinsic Properties for your Resource. If
    * not specified, you must conform to the contract resource version you
    * registered as default.
    * @return The SchemaVersion value.
    */
    public String getSchemaVersion() {
        return this.schemaVersion;
    }
    
    /**
    * Optional. The version of the Intrinsic Properties for your Resource. If
    * not specified, you must conform to the contract resource version you
    * registered as default.
    * @param schemaVersionValue The SchemaVersion value.
    */
    public void setSchemaVersion(final String schemaVersionValue) {
        this.schemaVersion = schemaVersionValue;
    }
    
    private JobCollectionState state;
    
    /**
    * Optional. State of the Job Collection.
    * @return The State value.
    */
    public JobCollectionState getState() {
        return this.state;
    }
    
    /**
    * Optional. State of the Job Collection.
    * @param stateValue The State value.
    */
    public void setState(final JobCollectionState stateValue) {
        this.state = stateValue;
    }
    
    /**
    * Result of a previous operation.
    */
    public static class OperationStatus {
        private JobCollectionGetResponse.OperationStatusResponseDetails responseDetails;
        
        /**
        * Optional. Details about the last operation.
        * @return The ResponseDetails value.
        */
        public JobCollectionGetResponse.OperationStatusResponseDetails getResponseDetails() {
            return this.responseDetails;
        }
        
        /**
        * Optional. Details about the last operation.
        * @param responseDetailsValue The ResponseDetails value.
        */
        public void setResponseDetails(final JobCollectionGetResponse.OperationStatusResponseDetails responseDetailsValue) {
            this.responseDetails = responseDetailsValue;
        }
        
        private SchedulerOperationStatus status;
        
        /**
        * Optional. Status of the last operation.
        * @return The Status value.
        */
        public SchedulerOperationStatus getStatus() {
            return this.status;
        }
        
        /**
        * Optional. Status of the last operation.
        * @param statusValue The Status value.
        */
        public void setStatus(final SchedulerOperationStatus statusValue) {
            this.status = statusValue;
        }
    }
    
    /**
    * Response details about an operation.
    */
    public static class OperationStatusResponseDetails {
        private String message;
        
        /**
        * Optional. Message returned by the operation.
        * @return The Message value.
        */
        public String getMessage() {
            return this.message;
        }
        
        /**
        * Optional. Message returned by the operation.
        * @param messageValue The Message value.
        */
        public void setMessage(final String messageValue) {
            this.message = messageValue;
        }
        
        private Integer statusCode;
        
        /**
        * Optional. The HTTP status code of the operation.
        * @return The StatusCode value.
        */
        public Integer getStatusCode() {
            return this.statusCode;
        }
        
        /**
        * Optional. The HTTP status code of the operation.
        * @param statusCodeValue The StatusCode value.
        */
        public void setStatusCode(final Integer statusCodeValue) {
            this.statusCode = statusCodeValue;
        }
    }
}
