/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.scheduler;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.scheduler.models.JobCollectionJobsUpdateStateParameters;
import com.microsoft.windowsazure.scheduler.models.JobCollectionJobsUpdateStateResponse;
import com.microsoft.windowsazure.scheduler.models.JobCreateOrUpdateParameters;
import com.microsoft.windowsazure.scheduler.models.JobCreateOrUpdateResponse;
import com.microsoft.windowsazure.scheduler.models.JobCreateParameters;
import com.microsoft.windowsazure.scheduler.models.JobCreateResponse;
import com.microsoft.windowsazure.scheduler.models.JobGetHistoryParameters;
import com.microsoft.windowsazure.scheduler.models.JobGetHistoryResponse;
import com.microsoft.windowsazure.scheduler.models.JobGetHistoryWithFilterParameters;
import com.microsoft.windowsazure.scheduler.models.JobGetResponse;
import com.microsoft.windowsazure.scheduler.models.JobListParameters;
import com.microsoft.windowsazure.scheduler.models.JobListResponse;
import com.microsoft.windowsazure.scheduler.models.JobListWithFilterParameters;
import com.microsoft.windowsazure.scheduler.models.JobUpdateStateParameters;
import com.microsoft.windowsazure.scheduler.models.JobUpdateStateResponse;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.Future;

public interface JobOperations {
    /**
    * Creates a new Job, allowing the service to generate a job id. Use
    * CreateOrUpdate if a user-chosen job id is required.
    *
    * @param parameters Required. Parameters specifying the job definition for
    * a Create Job operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Create Job operation response.
    */
    JobCreateResponse create(JobCreateParameters parameters) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Creates a new Job, allowing the service to generate a job id. Use
    * CreateOrUpdate if a user-chosen job id is required.
    *
    * @param parameters Required. Parameters specifying the job definition for
    * a Create Job operation.
    * @return The Create Job operation response.
    */
    Future<JobCreateResponse> createAsync(JobCreateParameters parameters);
    
    /**
    * Creates a new Job with a user-provided job id, or updates an existing
    * job, replacing its definition with that specified.
    *
    * @param jobId Required. Id of the job to create or update.
    * @param parameters Required. Parameters specifying the job definition for
    * a CreateOrUpdate Job operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The CreateOrUpdate Job operation response.
    */
    JobCreateOrUpdateResponse createOrUpdate(String jobId, JobCreateOrUpdateParameters parameters) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Creates a new Job with a user-provided job id, or updates an existing
    * job, replacing its definition with that specified.
    *
    * @param jobId Required. Id of the job to create or update.
    * @param parameters Required. Parameters specifying the job definition for
    * a CreateOrUpdate Job operation.
    * @return The CreateOrUpdate Job operation response.
    */
    Future<JobCreateOrUpdateResponse> createOrUpdateAsync(String jobId, JobCreateOrUpdateParameters parameters);
    
    /**
    * Deletes a job.
    *
    * @param jobId Required. Id of the job to delete.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse delete(String jobId) throws IOException, ServiceException;
    
    /**
    * Deletes a job.
    *
    * @param jobId Required. Id of the job to delete.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteAsync(String jobId);
    
    /**
    * Get the definition and status of a job.
    *
    * @param jobId Required. Id of the job to get.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Get Job operation response.
    */
    JobGetResponse get(String jobId) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Get the definition and status of a job.
    *
    * @param jobId Required. Id of the job to get.
    * @return The Get Job operation response.
    */
    Future<JobGetResponse> getAsync(String jobId);
    
    /**
    * Get the execution history of a Job.
    *
    * @param jobId Required. Id of the job to get the history of.
    * @param parameters Required. Parameters supplied to the Get Job History
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The Get Job History operation response.
    */
    JobGetHistoryResponse getHistory(String jobId, JobGetHistoryParameters parameters) throws IOException, ServiceException;
    
    /**
    * Get the execution history of a Job.
    *
    * @param jobId Required. Id of the job to get the history of.
    * @param parameters Required. Parameters supplied to the Get Job History
    * operation.
    * @return The Get Job History operation response.
    */
    Future<JobGetHistoryResponse> getHistoryAsync(String jobId, JobGetHistoryParameters parameters);
    
    /**
    * Get the execution history of a Job with a filter on the job Status.
    *
    * @param jobId Required. Id of the job to get the history of.
    * @param parameters Required. Parameters supplied to the Get Job History
    * With Filter operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The Get Job History operation response.
    */
    JobGetHistoryResponse getHistoryWithFilter(String jobId, JobGetHistoryWithFilterParameters parameters) throws IOException, ServiceException;
    
    /**
    * Get the execution history of a Job with a filter on the job Status.
    *
    * @param jobId Required. Id of the job to get the history of.
    * @param parameters Required. Parameters supplied to the Get Job History
    * With Filter operation.
    * @return The Get Job History operation response.
    */
    Future<JobGetHistoryResponse> getHistoryWithFilterAsync(String jobId, JobGetHistoryWithFilterParameters parameters);
    
    /**
    * Get the list of all jobs in a job collection.
    *
    * @param parameters Required. Parameters supplied to the List Jobs
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The List Jobs operation response.
    */
    JobListResponse list(JobListParameters parameters) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Get the list of all jobs in a job collection.
    *
    * @param parameters Required. Parameters supplied to the List Jobs
    * operation.
    * @return The List Jobs operation response.
    */
    Future<JobListResponse> listAsync(JobListParameters parameters);
    
    /**
    * Get the list of jobs in a job collection matching a filter on job state.
    *
    * @param parameters Required. Parameters supplied to the List Jobs with
    * filter operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The List Jobs operation response.
    */
    JobListResponse listWithFilter(JobListWithFilterParameters parameters) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Get the list of jobs in a job collection matching a filter on job state.
    *
    * @param parameters Required. Parameters supplied to the List Jobs with
    * filter operation.
    * @return The List Jobs operation response.
    */
    Future<JobListResponse> listWithFilterAsync(JobListWithFilterParameters parameters);
    
    /**
    * Update the state of all jobs in a job collections.
    *
    * @param parameters Required. Parameters supplied to the Update Jobs State
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Update Jobs State operation response.
    */
    JobCollectionJobsUpdateStateResponse updateJobCollectionState(JobCollectionJobsUpdateStateParameters parameters) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Update the state of all jobs in a job collections.
    *
    * @param parameters Required. Parameters supplied to the Update Jobs State
    * operation.
    * @return The Update Jobs State operation response.
    */
    Future<JobCollectionJobsUpdateStateResponse> updateJobCollectionStateAsync(JobCollectionJobsUpdateStateParameters parameters);
    
    /**
    * Update the state of a job.
    *
    * @param jobId Required. Id of the job to update.
    * @param parameters Required. Parameters supplied to the Update Job State
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Update Job State operation response.
    */
    JobUpdateStateResponse updateState(String jobId, JobUpdateStateParameters parameters) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Update the state of a job.
    *
    * @param jobId Required. Id of the job to update.
    * @param parameters Required. Parameters supplied to the Update Job State
    * operation.
    * @return The Update Job State operation response.
    */
    Future<JobUpdateStateResponse> updateStateAsync(String jobId, JobUpdateStateParameters parameters);
}
