/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.scheduler;

import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.TimeSpan8601Converter;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.scheduler.models.AADOAuthAuthentication;
import com.microsoft.windowsazure.scheduler.models.BasicAuthentication;
import com.microsoft.windowsazure.scheduler.models.ClientCertAuthentication;
import com.microsoft.windowsazure.scheduler.models.HttpAuthenticationType;
import com.microsoft.windowsazure.scheduler.models.Job;
import com.microsoft.windowsazure.scheduler.models.JobAction;
import com.microsoft.windowsazure.scheduler.models.JobActionType;
import com.microsoft.windowsazure.scheduler.models.JobCollectionJobsUpdateStateParameters;
import com.microsoft.windowsazure.scheduler.models.JobCollectionJobsUpdateStateResponse;
import com.microsoft.windowsazure.scheduler.models.JobCreateOrUpdateParameters;
import com.microsoft.windowsazure.scheduler.models.JobCreateOrUpdateResponse;
import com.microsoft.windowsazure.scheduler.models.JobCreateParameters;
import com.microsoft.windowsazure.scheduler.models.JobCreateResponse;
import com.microsoft.windowsazure.scheduler.models.JobErrorAction;
import com.microsoft.windowsazure.scheduler.models.JobGetHistoryParameters;
import com.microsoft.windowsazure.scheduler.models.JobGetHistoryResponse;
import com.microsoft.windowsazure.scheduler.models.JobGetHistoryWithFilterParameters;
import com.microsoft.windowsazure.scheduler.models.JobGetResponse;
import com.microsoft.windowsazure.scheduler.models.JobHistoryActionName;
import com.microsoft.windowsazure.scheduler.models.JobHistoryStatus;
import com.microsoft.windowsazure.scheduler.models.JobHttpRequest;
import com.microsoft.windowsazure.scheduler.models.JobListParameters;
import com.microsoft.windowsazure.scheduler.models.JobListResponse;
import com.microsoft.windowsazure.scheduler.models.JobListWithFilterParameters;
import com.microsoft.windowsazure.scheduler.models.JobQueueMessage;
import com.microsoft.windowsazure.scheduler.models.JobRecurrence;
import com.microsoft.windowsazure.scheduler.models.JobRecurrenceFrequency;
import com.microsoft.windowsazure.scheduler.models.JobRecurrenceSchedule;
import com.microsoft.windowsazure.scheduler.models.JobScheduleDay;
import com.microsoft.windowsazure.scheduler.models.JobScheduleMonthlyOccurrence;
import com.microsoft.windowsazure.scheduler.models.JobServiceBusAuthentication;
import com.microsoft.windowsazure.scheduler.models.JobServiceBusAuthenticationType;
import com.microsoft.windowsazure.scheduler.models.JobServiceBusBrokeredMessageProperties;
import com.microsoft.windowsazure.scheduler.models.JobServiceBusQueueMessage;
import com.microsoft.windowsazure.scheduler.models.JobServiceBusTopicMessage;
import com.microsoft.windowsazure.scheduler.models.JobServiceBusTransportType;
import com.microsoft.windowsazure.scheduler.models.JobState;
import com.microsoft.windowsazure.scheduler.models.JobStatus;
import com.microsoft.windowsazure.scheduler.models.JobUpdateStateParameters;
import com.microsoft.windowsazure.scheduler.models.JobUpdateStateResponse;
import com.microsoft.windowsazure.scheduler.models.RetryPolicy;
import com.microsoft.windowsazure.scheduler.models.RetryType;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import javax.xml.bind.DatatypeConverter;
import javax.xml.datatype.Duration;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class JobOperationsImpl implements ServiceOperations<SchedulerClientImpl>, JobOperations {
    /**
    * Initializes a new instance of the JobOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    JobOperationsImpl(SchedulerClientImpl client) {
        this.client = client;
    }
    
    private SchedulerClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.windowsazure.scheduler.SchedulerClientImpl.
    * @return The Client value.
    */
    public SchedulerClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Creates a new Job, allowing the service to generate a job id. Use
    * CreateOrUpdate if a user-chosen job id is required.
    *
    * @param parameters Required. Parameters specifying the job definition for
    * a Create Job operation.
    * @return The Create Job operation response.
    */
    @Override
    public Future<JobCreateResponse> createAsync(final JobCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<JobCreateResponse>() { 
            @Override
            public JobCreateResponse call() throws Exception {
                return create(parameters);
            }
         });
    }
    
    /**
    * Creates a new Job, allowing the service to generate a job id. Use
    * CreateOrUpdate if a user-chosen job id is required.
    *
    * @param parameters Required. Parameters specifying the job definition for
    * a Create Job operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Create Job operation response.
    */
    @Override
    public JobCreateResponse create(JobCreateParameters parameters) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getAction() == null) {
            throw new NullPointerException("parameters.Action");
        }
        if (parameters.getAction().getErrorAction() != null) {
            if (parameters.getAction().getErrorAction().getQueueMessage() != null) {
                if (parameters.getAction().getErrorAction().getQueueMessage().getMessage() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.QueueMessage.Message");
                }
                if (parameters.getAction().getErrorAction().getQueueMessage().getQueueName() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.QueueMessage.QueueName");
                }
                if (parameters.getAction().getErrorAction().getQueueMessage().getSasToken() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.QueueMessage.SasToken");
                }
                if (parameters.getAction().getErrorAction().getQueueMessage().getStorageAccountName() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.QueueMessage.StorageAccountName");
                }
            }
            if (parameters.getAction().getErrorAction().getRequest() != null) {
                if (parameters.getAction().getErrorAction().getRequest().getMethod() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.Request.Method");
                }
                if (parameters.getAction().getErrorAction().getRequest().getUri() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.Request.Uri");
                }
            }
            if (parameters.getAction().getErrorAction().getServiceBusQueueMessage() != null) {
                if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getAuthentication() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusQueueMessage.Authentication");
                }
                if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getAuthentication().getSasKey() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusQueueMessage.Authentication.SasKey");
                }
                if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getAuthentication().getSasKeyName() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusQueueMessage.Authentication.SasKeyName");
                }
                if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getAuthentication().getType() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusQueueMessage.Authentication.Type");
                }
                if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getMessage() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusQueueMessage.Message");
                }
                if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getNamespace() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusQueueMessage.Namespace");
                }
                if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getQueueName() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusQueueMessage.QueueName");
                }
                if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getTransportType() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusQueueMessage.TransportType");
                }
            }
            if (parameters.getAction().getErrorAction().getServiceBusTopicMessage() != null) {
                if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getAuthentication() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusTopicMessage.Authentication");
                }
                if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getAuthentication().getSasKey() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusTopicMessage.Authentication.SasKey");
                }
                if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getAuthentication().getSasKeyName() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusTopicMessage.Authentication.SasKeyName");
                }
                if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getAuthentication().getType() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusTopicMessage.Authentication.Type");
                }
                if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getMessage() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusTopicMessage.Message");
                }
                if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getNamespace() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusTopicMessage.Namespace");
                }
                if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getTopicPath() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusTopicMessage.TopicPath");
                }
                if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getTransportType() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusTopicMessage.TransportType");
                }
            }
            if (parameters.getAction().getErrorAction().getType() == null) {
                throw new NullPointerException("parameters.Action.ErrorAction.Type");
            }
        }
        if (parameters.getAction().getQueueMessage() != null) {
            if (parameters.getAction().getQueueMessage().getMessage() == null) {
                throw new NullPointerException("parameters.Action.QueueMessage.Message");
            }
            if (parameters.getAction().getQueueMessage().getQueueName() == null) {
                throw new NullPointerException("parameters.Action.QueueMessage.QueueName");
            }
            if (parameters.getAction().getQueueMessage().getSasToken() == null) {
                throw new NullPointerException("parameters.Action.QueueMessage.SasToken");
            }
            if (parameters.getAction().getQueueMessage().getStorageAccountName() == null) {
                throw new NullPointerException("parameters.Action.QueueMessage.StorageAccountName");
            }
        }
        if (parameters.getAction().getRequest() != null) {
            if (parameters.getAction().getRequest().getMethod() == null) {
                throw new NullPointerException("parameters.Action.Request.Method");
            }
            if (parameters.getAction().getRequest().getUri() == null) {
                throw new NullPointerException("parameters.Action.Request.Uri");
            }
        }
        if (parameters.getAction().getRetryPolicy() != null) {
            if (parameters.getAction().getRetryPolicy().getRetryType() == null) {
                throw new NullPointerException("parameters.Action.RetryPolicy.RetryType");
            }
        }
        if (parameters.getAction().getServiceBusQueueMessage() != null) {
            if (parameters.getAction().getServiceBusQueueMessage().getAuthentication() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusQueueMessage.Authentication");
            }
            if (parameters.getAction().getServiceBusQueueMessage().getAuthentication().getSasKey() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusQueueMessage.Authentication.SasKey");
            }
            if (parameters.getAction().getServiceBusQueueMessage().getAuthentication().getSasKeyName() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusQueueMessage.Authentication.SasKeyName");
            }
            if (parameters.getAction().getServiceBusQueueMessage().getAuthentication().getType() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusQueueMessage.Authentication.Type");
            }
            if (parameters.getAction().getServiceBusQueueMessage().getMessage() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusQueueMessage.Message");
            }
            if (parameters.getAction().getServiceBusQueueMessage().getNamespace() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusQueueMessage.Namespace");
            }
            if (parameters.getAction().getServiceBusQueueMessage().getQueueName() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusQueueMessage.QueueName");
            }
            if (parameters.getAction().getServiceBusQueueMessage().getTransportType() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusQueueMessage.TransportType");
            }
        }
        if (parameters.getAction().getServiceBusTopicMessage() != null) {
            if (parameters.getAction().getServiceBusTopicMessage().getAuthentication() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusTopicMessage.Authentication");
            }
            if (parameters.getAction().getServiceBusTopicMessage().getAuthentication().getSasKey() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusTopicMessage.Authentication.SasKey");
            }
            if (parameters.getAction().getServiceBusTopicMessage().getAuthentication().getSasKeyName() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusTopicMessage.Authentication.SasKeyName");
            }
            if (parameters.getAction().getServiceBusTopicMessage().getAuthentication().getType() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusTopicMessage.Authentication.Type");
            }
            if (parameters.getAction().getServiceBusTopicMessage().getMessage() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusTopicMessage.Message");
            }
            if (parameters.getAction().getServiceBusTopicMessage().getNamespace() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusTopicMessage.Namespace");
            }
            if (parameters.getAction().getServiceBusTopicMessage().getTopicPath() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusTopicMessage.TopicPath");
            }
            if (parameters.getAction().getServiceBusTopicMessage().getTransportType() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusTopicMessage.TransportType");
            }
        }
        if (parameters.getAction().getType() == null) {
            throw new NullPointerException("parameters.Action.Type");
        }
        if (parameters.getRecurrence() != null) {
            if (parameters.getRecurrence().getFrequency() == null) {
                throw new NullPointerException("parameters.Recurrence.Frequency");
            }
            if (parameters.getRecurrence().getSchedule() != null) {
                if (parameters.getRecurrence().getSchedule().getMonthlyOccurrences() != null) {
                    for (JobScheduleMonthlyOccurrence monthlyOccurrencesParameterItem : parameters.getRecurrence().getSchedule().getMonthlyOccurrences()) {
                        if (monthlyOccurrencesParameterItem.getDay() == null) {
                            throw new NullPointerException("parameters.Recurrence.Schedule.MonthlyOccurrences.Day");
                        }
                    }
                }
            }
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/cloudservices/";
        url = url + URLEncoder.encode(this.getClient().getCloudServiceName(), "UTF-8");
        url = url + "/resources/";
        url = url + "scheduler";
        url = url + "/~/";
        url = url + "JobCollections";
        url = url + "/";
        url = url + URLEncoder.encode(this.getClient().getJobCollectionName(), "UTF-8");
        url = url + "/jobs";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        httpRequest.setHeader("x-ms-version", "2013-03-01");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode jobCreateParametersValue = objectMapper.createObjectNode();
        requestDoc = jobCreateParametersValue;
        
        if (parameters.getStartTime() != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            ((ObjectNode) jobCreateParametersValue).put("startTime", simpleDateFormat.format(parameters.getStartTime().getTime()));
        }
        
        ObjectNode actionValue = objectMapper.createObjectNode();
        ((ObjectNode) jobCreateParametersValue).put("action", actionValue);
        
        ((ObjectNode) actionValue).put("type", SchedulerClientImpl.jobActionTypeToString(parameters.getAction().getType()));
        
        if (parameters.getAction().getRetryPolicy() != null) {
            ObjectNode retryPolicyValue = objectMapper.createObjectNode();
            ((ObjectNode) actionValue).put("retryPolicy", retryPolicyValue);
            
            ((ObjectNode) retryPolicyValue).put("retryType", SchedulerClientImpl.retryTypeToString(parameters.getAction().getRetryPolicy().getRetryType()));
            
            if (parameters.getAction().getRetryPolicy().getRetryInterval() != null) {
                ((ObjectNode) retryPolicyValue).put("retryInterval", TimeSpan8601Converter.format(parameters.getAction().getRetryPolicy().getRetryInterval()));
            }
            
            if (parameters.getAction().getRetryPolicy().getRetryCount() != null) {
                ((ObjectNode) retryPolicyValue).put("retryCount", parameters.getAction().getRetryPolicy().getRetryCount());
            }
        }
        
        if (parameters.getAction().getErrorAction() != null) {
            ObjectNode errorActionValue = objectMapper.createObjectNode();
            ((ObjectNode) actionValue).put("errorAction", errorActionValue);
            
            ((ObjectNode) errorActionValue).put("type", SchedulerClientImpl.jobActionTypeToString(parameters.getAction().getErrorAction().getType()));
            
            if (parameters.getAction().getErrorAction().getRequest() != null) {
                ObjectNode requestValue = objectMapper.createObjectNode();
                ((ObjectNode) errorActionValue).put("request", requestValue);
                
                ((ObjectNode) requestValue).put("uri", parameters.getAction().getErrorAction().getRequest().getUri().toString());
                
                ((ObjectNode) requestValue).put("method", parameters.getAction().getErrorAction().getRequest().getMethod());
                
                if (parameters.getAction().getErrorAction().getRequest().getHeaders() != null) {
                    if (parameters.getAction().getErrorAction().getRequest().getHeaders() instanceof LazyCollection == false || ((LazyCollection) parameters.getAction().getErrorAction().getRequest().getHeaders()).isInitialized()) {
                        ObjectNode headersDictionary = objectMapper.createObjectNode();
                        for (Map.Entry<String, String> entry : parameters.getAction().getErrorAction().getRequest().getHeaders().entrySet()) {
                            String headersKey = entry.getKey();
                            String headersValue = entry.getValue();
                            ((ObjectNode) headersDictionary).put(headersKey, headersValue);
                        }
                        ((ObjectNode) requestValue).put("headers", headersDictionary);
                    }
                }
                
                if (parameters.getAction().getErrorAction().getRequest().getBody() != null) {
                    ((ObjectNode) requestValue).put("body", parameters.getAction().getErrorAction().getRequest().getBody());
                }
                
                if (parameters.getAction().getErrorAction().getRequest().getAuthentication() != null) {
                    ObjectNode authenticationValue = objectMapper.createObjectNode();
                    ((ObjectNode) requestValue).put("authentication", authenticationValue);
                    if (parameters.getAction().getErrorAction().getRequest().getAuthentication() instanceof ClientCertAuthentication) {
                        ((ObjectNode) authenticationValue).put("type", "ClientCertificate");
                        ClientCertAuthentication derived = ((ClientCertAuthentication) parameters.getAction().getErrorAction().getRequest().getAuthentication());
                        
                        if (derived.getPassword() != null) {
                            ((ObjectNode) authenticationValue).put("password", derived.getPassword());
                        }
                        
                        if (derived.getPfx() != null) {
                            ((ObjectNode) authenticationValue).put("pfx", derived.getPfx());
                        }
                        
                        if (derived.getCertificateThumbprint() != null) {
                            ((ObjectNode) authenticationValue).put("certificateThumbprint", derived.getCertificateThumbprint());
                        }
                        
                        if (derived.getCertificateExpiration() != null) {
                            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                            simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
                            ((ObjectNode) authenticationValue).put("certificateExpiration", simpleDateFormat2.format(derived.getCertificateExpiration().getTime()));
                        }
                        
                        if (derived.getCertificateSubjectName() != null) {
                            ((ObjectNode) authenticationValue).put("certificateSubjectName", derived.getCertificateSubjectName());
                        }
                        
                        if (derived.getType() != null) {
                            ((ObjectNode) authenticationValue).put("type", SchedulerClientImpl.httpAuthenticationTypeToString(derived.getType()));
                        }
                    }
                    if (parameters.getAction().getErrorAction().getRequest().getAuthentication() instanceof AADOAuthAuthentication) {
                        ((ObjectNode) authenticationValue).put("type", "ActiveDirectoryOAuth");
                        AADOAuthAuthentication derived2 = ((AADOAuthAuthentication) parameters.getAction().getErrorAction().getRequest().getAuthentication());
                        
                        if (derived2.getSecret() != null) {
                            ((ObjectNode) authenticationValue).put("secret", derived2.getSecret());
                        }
                        
                        if (derived2.getTenant() != null) {
                            ((ObjectNode) authenticationValue).put("tenant", derived2.getTenant());
                        }
                        
                        if (derived2.getAudience() != null) {
                            ((ObjectNode) authenticationValue).put("audience", derived2.getAudience());
                        }
                        
                        if (derived2.getClientId() != null) {
                            ((ObjectNode) authenticationValue).put("clientId", derived2.getClientId());
                        }
                        
                        if (derived2.getType() != null) {
                            ((ObjectNode) authenticationValue).put("type", SchedulerClientImpl.httpAuthenticationTypeToString(derived2.getType()));
                        }
                    }
                    if (parameters.getAction().getErrorAction().getRequest().getAuthentication() instanceof BasicAuthentication) {
                        ((ObjectNode) authenticationValue).put("type", "Basic");
                        BasicAuthentication derived3 = ((BasicAuthentication) parameters.getAction().getErrorAction().getRequest().getAuthentication());
                        
                        ((ObjectNode) authenticationValue).put("username", derived3.getUsername());
                        
                        if (derived3.getPassword() != null) {
                            ((ObjectNode) authenticationValue).put("password", derived3.getPassword());
                        }
                        
                        if (derived3.getType() != null) {
                            ((ObjectNode) authenticationValue).put("type", SchedulerClientImpl.httpAuthenticationTypeToString(derived3.getType()));
                        }
                    }
                }
            }
            
            if (parameters.getAction().getErrorAction().getQueueMessage() != null) {
                ObjectNode queueMessageValue = objectMapper.createObjectNode();
                ((ObjectNode) errorActionValue).put("queueMessage", queueMessageValue);
                
                ((ObjectNode) queueMessageValue).put("storageAccount", parameters.getAction().getErrorAction().getQueueMessage().getStorageAccountName());
                
                ((ObjectNode) queueMessageValue).put("queueName", parameters.getAction().getErrorAction().getQueueMessage().getQueueName());
                
                ((ObjectNode) queueMessageValue).put("sasToken", parameters.getAction().getErrorAction().getQueueMessage().getSasToken());
                
                ((ObjectNode) queueMessageValue).put("message", parameters.getAction().getErrorAction().getQueueMessage().getMessage());
            }
            
            if (parameters.getAction().getErrorAction().getServiceBusTopicMessage() != null) {
                ObjectNode serviceBusTopicMessageValue = objectMapper.createObjectNode();
                ((ObjectNode) errorActionValue).put("serviceBusTopicMessage", serviceBusTopicMessageValue);
                
                ((ObjectNode) serviceBusTopicMessageValue).put("topicPath", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getTopicPath());
                
                ((ObjectNode) serviceBusTopicMessageValue).put("namespace", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getNamespace());
                
                ((ObjectNode) serviceBusTopicMessageValue).put("transportType", SchedulerClientImpl.jobServiceBusTransportTypeToString(parameters.getAction().getErrorAction().getServiceBusTopicMessage().getTransportType()));
                
                ObjectNode authenticationValue2 = objectMapper.createObjectNode();
                ((ObjectNode) serviceBusTopicMessageValue).put("authentication", authenticationValue2);
                
                ((ObjectNode) authenticationValue2).put("sasKeyName", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getAuthentication().getSasKeyName());
                
                ((ObjectNode) authenticationValue2).put("sasKey", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getAuthentication().getSasKey());
                
                ((ObjectNode) authenticationValue2).put("type", SchedulerClientImpl.jobServiceBusAuthenticationTypeToString(parameters.getAction().getErrorAction().getServiceBusTopicMessage().getAuthentication().getType()));
                
                ((ObjectNode) serviceBusTopicMessageValue).put("message", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getMessage());
                
                if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties() != null) {
                    ObjectNode brokeredMessagePropertiesValue = objectMapper.createObjectNode();
                    ((ObjectNode) serviceBusTopicMessageValue).put("brokeredMessageProperties", brokeredMessagePropertiesValue);
                    
                    if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getContentType() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue).put("contentType", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getContentType());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getCorrelationId() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue).put("correlationId", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getCorrelationId());
                    }
                    
                    ((ObjectNode) brokeredMessagePropertiesValue).put("forcePersistence", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().isForcePersistence());
                    
                    if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getLabel() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue).put("label", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getLabel());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getMessageId() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue).put("messageId", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getMessageId());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getPartitionKey() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue).put("partitionKey", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getPartitionKey());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getReplyTo() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue).put("replyTo", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getReplyTo());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getReplyToSessionId() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue).put("replyToSessionId", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getReplyToSessionId());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getScheduledEnqueueTimeUtc() != null) {
                        SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                        simpleDateFormat3.setTimeZone(TimeZone.getTimeZone("UTC"));
                        ((ObjectNode) brokeredMessagePropertiesValue).put("scheduledEnqueueTimeUtc", simpleDateFormat3.format(parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getScheduledEnqueueTimeUtc().getTime()));
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getSessionId() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue).put("sessionId", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getSessionId());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getTimeToLive() != null) {
                        SimpleDateFormat simpleDateFormat4 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                        simpleDateFormat4.setTimeZone(TimeZone.getTimeZone("UTC"));
                        ((ObjectNode) brokeredMessagePropertiesValue).put("timeToLive", simpleDateFormat4.format(parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getTimeToLive().getTime()));
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getTo() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue).put("to", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getTo());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getViaPartitionKey() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue).put("viaPartitionKey", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getViaPartitionKey());
                    }
                }
                
                if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getCustomMessageProperties() != null) {
                    ObjectNode customMessagePropertiesDictionary = objectMapper.createObjectNode();
                    for (Map.Entry<String, String> entry2 : parameters.getAction().getErrorAction().getServiceBusTopicMessage().getCustomMessageProperties().entrySet()) {
                        String customMessagePropertiesKey = entry2.getKey();
                        String customMessagePropertiesValue = entry2.getValue();
                        ((ObjectNode) customMessagePropertiesDictionary).put(customMessagePropertiesKey, customMessagePropertiesValue);
                    }
                    ((ObjectNode) serviceBusTopicMessageValue).put("customMessageProperties", customMessagePropertiesDictionary);
                }
            }
            
            if (parameters.getAction().getErrorAction().getServiceBusQueueMessage() != null) {
                ObjectNode serviceBusQueueMessageValue = objectMapper.createObjectNode();
                ((ObjectNode) errorActionValue).put("serviceBusQueueMessage", serviceBusQueueMessageValue);
                
                ((ObjectNode) serviceBusQueueMessageValue).put("queueName", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getQueueName());
                
                ((ObjectNode) serviceBusQueueMessageValue).put("namespace", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getNamespace());
                
                ((ObjectNode) serviceBusQueueMessageValue).put("transportType", SchedulerClientImpl.jobServiceBusTransportTypeToString(parameters.getAction().getErrorAction().getServiceBusQueueMessage().getTransportType()));
                
                ObjectNode authenticationValue3 = objectMapper.createObjectNode();
                ((ObjectNode) serviceBusQueueMessageValue).put("authentication", authenticationValue3);
                
                ((ObjectNode) authenticationValue3).put("sasKeyName", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getAuthentication().getSasKeyName());
                
                ((ObjectNode) authenticationValue3).put("sasKey", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getAuthentication().getSasKey());
                
                ((ObjectNode) authenticationValue3).put("type", SchedulerClientImpl.jobServiceBusAuthenticationTypeToString(parameters.getAction().getErrorAction().getServiceBusQueueMessage().getAuthentication().getType()));
                
                ((ObjectNode) serviceBusQueueMessageValue).put("message", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getMessage());
                
                if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties() != null) {
                    ObjectNode brokeredMessagePropertiesValue2 = objectMapper.createObjectNode();
                    ((ObjectNode) serviceBusQueueMessageValue).put("brokeredMessageProperties", brokeredMessagePropertiesValue2);
                    
                    if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getContentType() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue2).put("contentType", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getContentType());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getCorrelationId() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue2).put("correlationId", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getCorrelationId());
                    }
                    
                    ((ObjectNode) brokeredMessagePropertiesValue2).put("forcePersistence", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().isForcePersistence());
                    
                    if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getLabel() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue2).put("label", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getLabel());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getMessageId() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue2).put("messageId", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getMessageId());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getPartitionKey() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue2).put("partitionKey", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getPartitionKey());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getReplyTo() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue2).put("replyTo", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getReplyTo());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getReplyToSessionId() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue2).put("replyToSessionId", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getReplyToSessionId());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getScheduledEnqueueTimeUtc() != null) {
                        SimpleDateFormat simpleDateFormat5 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                        simpleDateFormat5.setTimeZone(TimeZone.getTimeZone("UTC"));
                        ((ObjectNode) brokeredMessagePropertiesValue2).put("scheduledEnqueueTimeUtc", simpleDateFormat5.format(parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getScheduledEnqueueTimeUtc().getTime()));
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getSessionId() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue2).put("sessionId", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getSessionId());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getTimeToLive() != null) {
                        SimpleDateFormat simpleDateFormat6 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                        simpleDateFormat6.setTimeZone(TimeZone.getTimeZone("UTC"));
                        ((ObjectNode) brokeredMessagePropertiesValue2).put("timeToLive", simpleDateFormat6.format(parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getTimeToLive().getTime()));
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getTo() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue2).put("to", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getTo());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getViaPartitionKey() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue2).put("viaPartitionKey", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getViaPartitionKey());
                    }
                }
                
                if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getCustomMessageProperties() != null) {
                    ObjectNode customMessagePropertiesDictionary2 = objectMapper.createObjectNode();
                    for (Map.Entry<String, String> entry3 : parameters.getAction().getErrorAction().getServiceBusQueueMessage().getCustomMessageProperties().entrySet()) {
                        String customMessagePropertiesKey2 = entry3.getKey();
                        String customMessagePropertiesValue2 = entry3.getValue();
                        ((ObjectNode) customMessagePropertiesDictionary2).put(customMessagePropertiesKey2, customMessagePropertiesValue2);
                    }
                    ((ObjectNode) serviceBusQueueMessageValue).put("customMessageProperties", customMessagePropertiesDictionary2);
                }
            }
        }
        
        if (parameters.getAction().getRequest() != null) {
            ObjectNode requestValue2 = objectMapper.createObjectNode();
            ((ObjectNode) actionValue).put("request", requestValue2);
            
            ((ObjectNode) requestValue2).put("uri", parameters.getAction().getRequest().getUri().toString());
            
            ((ObjectNode) requestValue2).put("method", parameters.getAction().getRequest().getMethod());
            
            if (parameters.getAction().getRequest().getHeaders() != null) {
                if (parameters.getAction().getRequest().getHeaders() instanceof LazyCollection == false || ((LazyCollection) parameters.getAction().getRequest().getHeaders()).isInitialized()) {
                    ObjectNode headersDictionary2 = objectMapper.createObjectNode();
                    for (Map.Entry<String, String> entry4 : parameters.getAction().getRequest().getHeaders().entrySet()) {
                        String headersKey2 = entry4.getKey();
                        String headersValue2 = entry4.getValue();
                        ((ObjectNode) headersDictionary2).put(headersKey2, headersValue2);
                    }
                    ((ObjectNode) requestValue2).put("headers", headersDictionary2);
                }
            }
            
            if (parameters.getAction().getRequest().getBody() != null) {
                ((ObjectNode) requestValue2).put("body", parameters.getAction().getRequest().getBody());
            }
            
            if (parameters.getAction().getRequest().getAuthentication() != null) {
                ObjectNode authenticationValue4 = objectMapper.createObjectNode();
                ((ObjectNode) requestValue2).put("authentication", authenticationValue4);
                if (parameters.getAction().getRequest().getAuthentication() instanceof ClientCertAuthentication) {
                    ((ObjectNode) authenticationValue4).put("type", "ClientCertificate");
                    ClientCertAuthentication derived4 = ((ClientCertAuthentication) parameters.getAction().getRequest().getAuthentication());
                    
                    if (derived4.getPassword() != null) {
                        ((ObjectNode) authenticationValue4).put("password", derived4.getPassword());
                    }
                    
                    if (derived4.getPfx() != null) {
                        ((ObjectNode) authenticationValue4).put("pfx", derived4.getPfx());
                    }
                    
                    if (derived4.getCertificateThumbprint() != null) {
                        ((ObjectNode) authenticationValue4).put("certificateThumbprint", derived4.getCertificateThumbprint());
                    }
                    
                    if (derived4.getCertificateExpiration() != null) {
                        SimpleDateFormat simpleDateFormat7 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                        simpleDateFormat7.setTimeZone(TimeZone.getTimeZone("UTC"));
                        ((ObjectNode) authenticationValue4).put("certificateExpiration", simpleDateFormat7.format(derived4.getCertificateExpiration().getTime()));
                    }
                    
                    if (derived4.getCertificateSubjectName() != null) {
                        ((ObjectNode) authenticationValue4).put("certificateSubjectName", derived4.getCertificateSubjectName());
                    }
                    
                    if (derived4.getType() != null) {
                        ((ObjectNode) authenticationValue4).put("type", SchedulerClientImpl.httpAuthenticationTypeToString(derived4.getType()));
                    }
                }
                if (parameters.getAction().getRequest().getAuthentication() instanceof AADOAuthAuthentication) {
                    ((ObjectNode) authenticationValue4).put("type", "ActiveDirectoryOAuth");
                    AADOAuthAuthentication derived5 = ((AADOAuthAuthentication) parameters.getAction().getRequest().getAuthentication());
                    
                    if (derived5.getSecret() != null) {
                        ((ObjectNode) authenticationValue4).put("secret", derived5.getSecret());
                    }
                    
                    if (derived5.getTenant() != null) {
                        ((ObjectNode) authenticationValue4).put("tenant", derived5.getTenant());
                    }
                    
                    if (derived5.getAudience() != null) {
                        ((ObjectNode) authenticationValue4).put("audience", derived5.getAudience());
                    }
                    
                    if (derived5.getClientId() != null) {
                        ((ObjectNode) authenticationValue4).put("clientId", derived5.getClientId());
                    }
                    
                    if (derived5.getType() != null) {
                        ((ObjectNode) authenticationValue4).put("type", SchedulerClientImpl.httpAuthenticationTypeToString(derived5.getType()));
                    }
                }
                if (parameters.getAction().getRequest().getAuthentication() instanceof BasicAuthentication) {
                    ((ObjectNode) authenticationValue4).put("type", "Basic");
                    BasicAuthentication derived6 = ((BasicAuthentication) parameters.getAction().getRequest().getAuthentication());
                    
                    ((ObjectNode) authenticationValue4).put("username", derived6.getUsername());
                    
                    if (derived6.getPassword() != null) {
                        ((ObjectNode) authenticationValue4).put("password", derived6.getPassword());
                    }
                    
                    if (derived6.getType() != null) {
                        ((ObjectNode) authenticationValue4).put("type", SchedulerClientImpl.httpAuthenticationTypeToString(derived6.getType()));
                    }
                }
            }
        }
        
        if (parameters.getAction().getQueueMessage() != null) {
            ObjectNode queueMessageValue2 = objectMapper.createObjectNode();
            ((ObjectNode) actionValue).put("queueMessage", queueMessageValue2);
            
            ((ObjectNode) queueMessageValue2).put("storageAccount", parameters.getAction().getQueueMessage().getStorageAccountName());
            
            ((ObjectNode) queueMessageValue2).put("queueName", parameters.getAction().getQueueMessage().getQueueName());
            
            ((ObjectNode) queueMessageValue2).put("sasToken", parameters.getAction().getQueueMessage().getSasToken());
            
            ((ObjectNode) queueMessageValue2).put("message", parameters.getAction().getQueueMessage().getMessage());
        }
        
        if (parameters.getAction().getServiceBusTopicMessage() != null) {
            ObjectNode serviceBusTopicMessageValue2 = objectMapper.createObjectNode();
            ((ObjectNode) actionValue).put("serviceBusTopicMessage", serviceBusTopicMessageValue2);
            
            ((ObjectNode) serviceBusTopicMessageValue2).put("topicPath", parameters.getAction().getServiceBusTopicMessage().getTopicPath());
            
            ((ObjectNode) serviceBusTopicMessageValue2).put("namespace", parameters.getAction().getServiceBusTopicMessage().getNamespace());
            
            ((ObjectNode) serviceBusTopicMessageValue2).put("transportType", SchedulerClientImpl.jobServiceBusTransportTypeToString(parameters.getAction().getServiceBusTopicMessage().getTransportType()));
            
            ObjectNode authenticationValue5 = objectMapper.createObjectNode();
            ((ObjectNode) serviceBusTopicMessageValue2).put("authentication", authenticationValue5);
            
            ((ObjectNode) authenticationValue5).put("sasKeyName", parameters.getAction().getServiceBusTopicMessage().getAuthentication().getSasKeyName());
            
            ((ObjectNode) authenticationValue5).put("sasKey", parameters.getAction().getServiceBusTopicMessage().getAuthentication().getSasKey());
            
            ((ObjectNode) authenticationValue5).put("type", SchedulerClientImpl.jobServiceBusAuthenticationTypeToString(parameters.getAction().getServiceBusTopicMessage().getAuthentication().getType()));
            
            ((ObjectNode) serviceBusTopicMessageValue2).put("message", parameters.getAction().getServiceBusTopicMessage().getMessage());
            
            if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties() != null) {
                ObjectNode brokeredMessagePropertiesValue3 = objectMapper.createObjectNode();
                ((ObjectNode) serviceBusTopicMessageValue2).put("brokeredMessageProperties", brokeredMessagePropertiesValue3);
                
                if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getContentType() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue3).put("contentType", parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getContentType());
                }
                
                if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getCorrelationId() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue3).put("correlationId", parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getCorrelationId());
                }
                
                ((ObjectNode) brokeredMessagePropertiesValue3).put("forcePersistence", parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().isForcePersistence());
                
                if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getLabel() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue3).put("label", parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getLabel());
                }
                
                if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getMessageId() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue3).put("messageId", parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getMessageId());
                }
                
                if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getPartitionKey() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue3).put("partitionKey", parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getPartitionKey());
                }
                
                if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getReplyTo() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue3).put("replyTo", parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getReplyTo());
                }
                
                if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getReplyToSessionId() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue3).put("replyToSessionId", parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getReplyToSessionId());
                }
                
                if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getScheduledEnqueueTimeUtc() != null) {
                    SimpleDateFormat simpleDateFormat8 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat8.setTimeZone(TimeZone.getTimeZone("UTC"));
                    ((ObjectNode) brokeredMessagePropertiesValue3).put("scheduledEnqueueTimeUtc", simpleDateFormat8.format(parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getScheduledEnqueueTimeUtc().getTime()));
                }
                
                if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getSessionId() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue3).put("sessionId", parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getSessionId());
                }
                
                if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getTimeToLive() != null) {
                    SimpleDateFormat simpleDateFormat9 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat9.setTimeZone(TimeZone.getTimeZone("UTC"));
                    ((ObjectNode) brokeredMessagePropertiesValue3).put("timeToLive", simpleDateFormat9.format(parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getTimeToLive().getTime()));
                }
                
                if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getTo() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue3).put("to", parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getTo());
                }
                
                if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getViaPartitionKey() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue3).put("viaPartitionKey", parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getViaPartitionKey());
                }
            }
            
            if (parameters.getAction().getServiceBusTopicMessage().getCustomMessageProperties() != null) {
                ObjectNode customMessagePropertiesDictionary3 = objectMapper.createObjectNode();
                for (Map.Entry<String, String> entry5 : parameters.getAction().getServiceBusTopicMessage().getCustomMessageProperties().entrySet()) {
                    String customMessagePropertiesKey3 = entry5.getKey();
                    String customMessagePropertiesValue3 = entry5.getValue();
                    ((ObjectNode) customMessagePropertiesDictionary3).put(customMessagePropertiesKey3, customMessagePropertiesValue3);
                }
                ((ObjectNode) serviceBusTopicMessageValue2).put("customMessageProperties", customMessagePropertiesDictionary3);
            }
        }
        
        if (parameters.getAction().getServiceBusQueueMessage() != null) {
            ObjectNode serviceBusQueueMessageValue2 = objectMapper.createObjectNode();
            ((ObjectNode) actionValue).put("serviceBusQueueMessage", serviceBusQueueMessageValue2);
            
            ((ObjectNode) serviceBusQueueMessageValue2).put("queueName", parameters.getAction().getServiceBusQueueMessage().getQueueName());
            
            ((ObjectNode) serviceBusQueueMessageValue2).put("namespace", parameters.getAction().getServiceBusQueueMessage().getNamespace());
            
            ((ObjectNode) serviceBusQueueMessageValue2).put("transportType", SchedulerClientImpl.jobServiceBusTransportTypeToString(parameters.getAction().getServiceBusQueueMessage().getTransportType()));
            
            ObjectNode authenticationValue6 = objectMapper.createObjectNode();
            ((ObjectNode) serviceBusQueueMessageValue2).put("authentication", authenticationValue6);
            
            ((ObjectNode) authenticationValue6).put("sasKeyName", parameters.getAction().getServiceBusQueueMessage().getAuthentication().getSasKeyName());
            
            ((ObjectNode) authenticationValue6).put("sasKey", parameters.getAction().getServiceBusQueueMessage().getAuthentication().getSasKey());
            
            ((ObjectNode) authenticationValue6).put("type", SchedulerClientImpl.jobServiceBusAuthenticationTypeToString(parameters.getAction().getServiceBusQueueMessage().getAuthentication().getType()));
            
            ((ObjectNode) serviceBusQueueMessageValue2).put("message", parameters.getAction().getServiceBusQueueMessage().getMessage());
            
            if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties() != null) {
                ObjectNode brokeredMessagePropertiesValue4 = objectMapper.createObjectNode();
                ((ObjectNode) serviceBusQueueMessageValue2).put("brokeredMessageProperties", brokeredMessagePropertiesValue4);
                
                if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getContentType() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue4).put("contentType", parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getContentType());
                }
                
                if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getCorrelationId() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue4).put("correlationId", parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getCorrelationId());
                }
                
                ((ObjectNode) brokeredMessagePropertiesValue4).put("forcePersistence", parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().isForcePersistence());
                
                if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getLabel() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue4).put("label", parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getLabel());
                }
                
                if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getMessageId() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue4).put("messageId", parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getMessageId());
                }
                
                if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getPartitionKey() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue4).put("partitionKey", parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getPartitionKey());
                }
                
                if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getReplyTo() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue4).put("replyTo", parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getReplyTo());
                }
                
                if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getReplyToSessionId() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue4).put("replyToSessionId", parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getReplyToSessionId());
                }
                
                if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getScheduledEnqueueTimeUtc() != null) {
                    SimpleDateFormat simpleDateFormat10 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat10.setTimeZone(TimeZone.getTimeZone("UTC"));
                    ((ObjectNode) brokeredMessagePropertiesValue4).put("scheduledEnqueueTimeUtc", simpleDateFormat10.format(parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getScheduledEnqueueTimeUtc().getTime()));
                }
                
                if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getSessionId() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue4).put("sessionId", parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getSessionId());
                }
                
                if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getTimeToLive() != null) {
                    SimpleDateFormat simpleDateFormat11 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat11.setTimeZone(TimeZone.getTimeZone("UTC"));
                    ((ObjectNode) brokeredMessagePropertiesValue4).put("timeToLive", simpleDateFormat11.format(parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getTimeToLive().getTime()));
                }
                
                if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getTo() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue4).put("to", parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getTo());
                }
                
                if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getViaPartitionKey() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue4).put("viaPartitionKey", parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getViaPartitionKey());
                }
            }
            
            if (parameters.getAction().getServiceBusQueueMessage().getCustomMessageProperties() != null) {
                ObjectNode customMessagePropertiesDictionary4 = objectMapper.createObjectNode();
                for (Map.Entry<String, String> entry6 : parameters.getAction().getServiceBusQueueMessage().getCustomMessageProperties().entrySet()) {
                    String customMessagePropertiesKey4 = entry6.getKey();
                    String customMessagePropertiesValue4 = entry6.getValue();
                    ((ObjectNode) customMessagePropertiesDictionary4).put(customMessagePropertiesKey4, customMessagePropertiesValue4);
                }
                ((ObjectNode) serviceBusQueueMessageValue2).put("customMessageProperties", customMessagePropertiesDictionary4);
            }
        }
        
        if (parameters.getRecurrence() != null) {
            ObjectNode recurrenceValue = objectMapper.createObjectNode();
            ((ObjectNode) jobCreateParametersValue).put("recurrence", recurrenceValue);
            
            ((ObjectNode) recurrenceValue).put("frequency", SchedulerClientImpl.jobRecurrenceFrequencyToString(parameters.getRecurrence().getFrequency()));
            
            if (parameters.getRecurrence().getInterval() != null) {
                ((ObjectNode) recurrenceValue).put("interval", parameters.getRecurrence().getInterval());
            }
            
            if (parameters.getRecurrence().getCount() != null) {
                ((ObjectNode) recurrenceValue).put("count", parameters.getRecurrence().getCount());
            }
            
            if (parameters.getRecurrence().getEndTime() != null) {
                SimpleDateFormat simpleDateFormat12 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                simpleDateFormat12.setTimeZone(TimeZone.getTimeZone("UTC"));
                ((ObjectNode) recurrenceValue).put("endTime", simpleDateFormat12.format(parameters.getRecurrence().getEndTime().getTime()));
            }
            
            if (parameters.getRecurrence().getSchedule() != null) {
                ObjectNode scheduleValue = objectMapper.createObjectNode();
                ((ObjectNode) recurrenceValue).put("schedule", scheduleValue);
                
                if (parameters.getRecurrence().getSchedule().getMinutes() != null) {
                    ArrayNode minutesArray = objectMapper.createArrayNode();
                    for (int minutesItem : parameters.getRecurrence().getSchedule().getMinutes()) {
                        minutesArray.add(minutesItem);
                    }
                    ((ObjectNode) scheduleValue).put("minutes", minutesArray);
                }
                
                if (parameters.getRecurrence().getSchedule().getHours() != null) {
                    ArrayNode hoursArray = objectMapper.createArrayNode();
                    for (int hoursItem : parameters.getRecurrence().getSchedule().getHours()) {
                        hoursArray.add(hoursItem);
                    }
                    ((ObjectNode) scheduleValue).put("hours", hoursArray);
                }
                
                if (parameters.getRecurrence().getSchedule().getDays() != null) {
                    ArrayNode weekDaysArray = objectMapper.createArrayNode();
                    for (JobScheduleDay weekDaysItem : parameters.getRecurrence().getSchedule().getDays()) {
                        weekDaysArray.add(SchedulerClientImpl.jobScheduleDayToString(weekDaysItem));
                    }
                    ((ObjectNode) scheduleValue).put("weekDays", weekDaysArray);
                }
                
                if (parameters.getRecurrence().getSchedule().getMonths() != null) {
                    ArrayNode monthsArray = objectMapper.createArrayNode();
                    for (int monthsItem : parameters.getRecurrence().getSchedule().getMonths()) {
                        monthsArray.add(monthsItem);
                    }
                    ((ObjectNode) scheduleValue).put("months", monthsArray);
                }
                
                if (parameters.getRecurrence().getSchedule().getMonthDays() != null) {
                    ArrayNode monthDaysArray = objectMapper.createArrayNode();
                    for (int monthDaysItem : parameters.getRecurrence().getSchedule().getMonthDays()) {
                        monthDaysArray.add(monthDaysItem);
                    }
                    ((ObjectNode) scheduleValue).put("monthDays", monthDaysArray);
                }
                
                if (parameters.getRecurrence().getSchedule().getMonthlyOccurrences() != null) {
                    ArrayNode monthlyOccurrencesArray = objectMapper.createArrayNode();
                    for (JobScheduleMonthlyOccurrence monthlyOccurrencesItem : parameters.getRecurrence().getSchedule().getMonthlyOccurrences()) {
                        ObjectNode jobScheduleMonthlyOccurrenceValue = objectMapper.createObjectNode();
                        monthlyOccurrencesArray.add(jobScheduleMonthlyOccurrenceValue);
                        
                        ((ObjectNode) jobScheduleMonthlyOccurrenceValue).put("day", SchedulerClientImpl.jobScheduleDayToString(monthlyOccurrencesItem.getDay()));
                        
                        if (monthlyOccurrencesItem.getOccurrence() != null) {
                            ((ObjectNode) jobScheduleMonthlyOccurrenceValue).put("occurrence", monthlyOccurrencesItem.getOccurrence());
                        }
                    }
                    ((ObjectNode) scheduleValue).put("monthlyOccurrences", monthlyOccurrencesArray);
                }
            }
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            JobCreateResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new JobCreateResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    Job jobInstance = new Job();
                    result.setJob(jobInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        jobInstance.setId(idInstance);
                    }
                    
                    JsonNode startTimeValue = responseDoc.get("startTime");
                    if (startTimeValue != null && startTimeValue instanceof NullNode == false) {
                        Calendar startTimeInstance;
                        startTimeInstance = DatatypeConverter.parseDateTime(startTimeValue.getTextValue());
                        jobInstance.setStartTime(startTimeInstance);
                    }
                    
                    JsonNode actionValue2 = responseDoc.get("action");
                    if (actionValue2 != null && actionValue2 instanceof NullNode == false) {
                        JobAction actionInstance = new JobAction();
                        jobInstance.setAction(actionInstance);
                        
                        JsonNode typeValue = actionValue2.get("type");
                        if (typeValue != null && typeValue instanceof NullNode == false) {
                            JobActionType typeInstance;
                            typeInstance = SchedulerClientImpl.parseJobActionType(typeValue.getTextValue());
                            actionInstance.setType(typeInstance);
                        }
                        
                        JsonNode retryPolicyValue2 = actionValue2.get("retryPolicy");
                        if (retryPolicyValue2 != null && retryPolicyValue2 instanceof NullNode == false) {
                            RetryPolicy retryPolicyInstance = new RetryPolicy();
                            actionInstance.setRetryPolicy(retryPolicyInstance);
                            
                            JsonNode retryTypeValue = retryPolicyValue2.get("retryType");
                            if (retryTypeValue != null && retryTypeValue instanceof NullNode == false) {
                                RetryType retryTypeInstance;
                                retryTypeInstance = SchedulerClientImpl.parseRetryType(retryTypeValue.getTextValue());
                                retryPolicyInstance.setRetryType(retryTypeInstance);
                            }
                            
                            JsonNode retryIntervalValue = retryPolicyValue2.get("retryInterval");
                            if (retryIntervalValue != null && retryIntervalValue instanceof NullNode == false) {
                                Duration retryIntervalInstance;
                                retryIntervalInstance = TimeSpan8601Converter.parse(retryIntervalValue.getTextValue());
                                retryPolicyInstance.setRetryInterval(retryIntervalInstance);
                            }
                            
                            JsonNode retryCountValue = retryPolicyValue2.get("retryCount");
                            if (retryCountValue != null && retryCountValue instanceof NullNode == false) {
                                int retryCountInstance;
                                retryCountInstance = retryCountValue.getIntValue();
                                retryPolicyInstance.setRetryCount(retryCountInstance);
                            }
                        }
                        
                        JsonNode errorActionValue2 = actionValue2.get("errorAction");
                        if (errorActionValue2 != null && errorActionValue2 instanceof NullNode == false) {
                            JobErrorAction errorActionInstance = new JobErrorAction();
                            actionInstance.setErrorAction(errorActionInstance);
                            
                            JsonNode typeValue2 = errorActionValue2.get("type");
                            if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                JobActionType typeInstance2;
                                typeInstance2 = SchedulerClientImpl.parseJobActionType(typeValue2.getTextValue());
                                errorActionInstance.setType(typeInstance2);
                            }
                            
                            JsonNode requestValue3 = errorActionValue2.get("request");
                            if (requestValue3 != null && requestValue3 instanceof NullNode == false) {
                                JobHttpRequest requestInstance = new JobHttpRequest();
                                errorActionInstance.setRequest(requestInstance);
                                
                                JsonNode uriValue = requestValue3.get("uri");
                                if (uriValue != null && uriValue instanceof NullNode == false) {
                                    URI uriInstance;
                                    uriInstance = new URI(uriValue.getTextValue());
                                    requestInstance.setUri(uriInstance);
                                }
                                
                                JsonNode methodValue = requestValue3.get("method");
                                if (methodValue != null && methodValue instanceof NullNode == false) {
                                    String methodInstance;
                                    methodInstance = methodValue.getTextValue();
                                    requestInstance.setMethod(methodInstance);
                                }
                                
                                JsonNode headersSequenceElement = ((JsonNode) requestValue3.get("headers"));
                                if (headersSequenceElement != null && headersSequenceElement instanceof NullNode == false) {
                                    Iterator<Map.Entry<String, JsonNode>> itr = headersSequenceElement.getFields();
                                    while (itr.hasNext()) {
                                        Map.Entry<String, JsonNode> property = itr.next();
                                        String headersKey3 = property.getKey();
                                        String headersValue3 = property.getValue().getTextValue();
                                        requestInstance.getHeaders().put(headersKey3, headersValue3);
                                    }
                                }
                                
                                JsonNode bodyValue = requestValue3.get("body");
                                if (bodyValue != null && bodyValue instanceof NullNode == false) {
                                    String bodyInstance;
                                    bodyInstance = bodyValue.getTextValue();
                                    requestInstance.setBody(bodyInstance);
                                }
                                
                                JsonNode authenticationValue7 = requestValue3.get("authentication");
                                if (authenticationValue7 != null && authenticationValue7 instanceof NullNode == false) {
                                    String typeName = authenticationValue7.get("type").getTextValue();
                                    if ("ClientCertificate".equals(typeName)) {
                                        ClientCertAuthentication clientCertAuthenticationInstance = new ClientCertAuthentication();
                                        
                                        JsonNode passwordValue = authenticationValue7.get("password");
                                        if (passwordValue != null && passwordValue instanceof NullNode == false) {
                                            String passwordInstance;
                                            passwordInstance = passwordValue.getTextValue();
                                            clientCertAuthenticationInstance.setPassword(passwordInstance);
                                        }
                                        
                                        JsonNode pfxValue = authenticationValue7.get("pfx");
                                        if (pfxValue != null && pfxValue instanceof NullNode == false) {
                                            String pfxInstance;
                                            pfxInstance = pfxValue.getTextValue();
                                            clientCertAuthenticationInstance.setPfx(pfxInstance);
                                        }
                                        
                                        JsonNode certificateThumbprintValue = authenticationValue7.get("certificateThumbprint");
                                        if (certificateThumbprintValue != null && certificateThumbprintValue instanceof NullNode == false) {
                                            String certificateThumbprintInstance;
                                            certificateThumbprintInstance = certificateThumbprintValue.getTextValue();
                                            clientCertAuthenticationInstance.setCertificateThumbprint(certificateThumbprintInstance);
                                        }
                                        
                                        JsonNode certificateExpirationValue = authenticationValue7.get("certificateExpiration");
                                        if (certificateExpirationValue != null && certificateExpirationValue instanceof NullNode == false) {
                                            Calendar certificateExpirationInstance;
                                            certificateExpirationInstance = DatatypeConverter.parseDateTime(certificateExpirationValue.getTextValue());
                                            clientCertAuthenticationInstance.setCertificateExpiration(certificateExpirationInstance);
                                        }
                                        
                                        JsonNode certificateSubjectNameValue = authenticationValue7.get("certificateSubjectName");
                                        if (certificateSubjectNameValue != null && certificateSubjectNameValue instanceof NullNode == false) {
                                            String certificateSubjectNameInstance;
                                            certificateSubjectNameInstance = certificateSubjectNameValue.getTextValue();
                                            clientCertAuthenticationInstance.setCertificateSubjectName(certificateSubjectNameInstance);
                                        }
                                        
                                        JsonNode typeValue3 = authenticationValue7.get("type");
                                        if (typeValue3 != null && typeValue3 instanceof NullNode == false) {
                                            HttpAuthenticationType typeInstance3;
                                            typeInstance3 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue3.getTextValue());
                                            clientCertAuthenticationInstance.setType(typeInstance3);
                                        }
                                        requestInstance.setAuthentication(clientCertAuthenticationInstance);
                                    }
                                    if ("ActiveDirectoryOAuth".equals(typeName)) {
                                        AADOAuthAuthentication aADOAuthAuthenticationInstance = new AADOAuthAuthentication();
                                        
                                        JsonNode secretValue = authenticationValue7.get("secret");
                                        if (secretValue != null && secretValue instanceof NullNode == false) {
                                            String secretInstance;
                                            secretInstance = secretValue.getTextValue();
                                            aADOAuthAuthenticationInstance.setSecret(secretInstance);
                                        }
                                        
                                        JsonNode tenantValue = authenticationValue7.get("tenant");
                                        if (tenantValue != null && tenantValue instanceof NullNode == false) {
                                            String tenantInstance;
                                            tenantInstance = tenantValue.getTextValue();
                                            aADOAuthAuthenticationInstance.setTenant(tenantInstance);
                                        }
                                        
                                        JsonNode audienceValue = authenticationValue7.get("audience");
                                        if (audienceValue != null && audienceValue instanceof NullNode == false) {
                                            String audienceInstance;
                                            audienceInstance = audienceValue.getTextValue();
                                            aADOAuthAuthenticationInstance.setAudience(audienceInstance);
                                        }
                                        
                                        JsonNode clientIdValue = authenticationValue7.get("clientId");
                                        if (clientIdValue != null && clientIdValue instanceof NullNode == false) {
                                            String clientIdInstance;
                                            clientIdInstance = clientIdValue.getTextValue();
                                            aADOAuthAuthenticationInstance.setClientId(clientIdInstance);
                                        }
                                        
                                        JsonNode typeValue4 = authenticationValue7.get("type");
                                        if (typeValue4 != null && typeValue4 instanceof NullNode == false) {
                                            HttpAuthenticationType typeInstance4;
                                            typeInstance4 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue4.getTextValue());
                                            aADOAuthAuthenticationInstance.setType(typeInstance4);
                                        }
                                        requestInstance.setAuthentication(aADOAuthAuthenticationInstance);
                                    }
                                    if ("Basic".equals(typeName)) {
                                        BasicAuthentication basicAuthenticationInstance = new BasicAuthentication();
                                        
                                        JsonNode usernameValue = authenticationValue7.get("username");
                                        if (usernameValue != null && usernameValue instanceof NullNode == false) {
                                            String usernameInstance;
                                            usernameInstance = usernameValue.getTextValue();
                                            basicAuthenticationInstance.setUsername(usernameInstance);
                                        }
                                        
                                        JsonNode passwordValue2 = authenticationValue7.get("password");
                                        if (passwordValue2 != null && passwordValue2 instanceof NullNode == false) {
                                            String passwordInstance2;
                                            passwordInstance2 = passwordValue2.getTextValue();
                                            basicAuthenticationInstance.setPassword(passwordInstance2);
                                        }
                                        
                                        JsonNode typeValue5 = authenticationValue7.get("type");
                                        if (typeValue5 != null && typeValue5 instanceof NullNode == false) {
                                            HttpAuthenticationType typeInstance5;
                                            typeInstance5 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue5.getTextValue());
                                            basicAuthenticationInstance.setType(typeInstance5);
                                        }
                                        requestInstance.setAuthentication(basicAuthenticationInstance);
                                    }
                                }
                            }
                            
                            JsonNode queueMessageValue3 = errorActionValue2.get("queueMessage");
                            if (queueMessageValue3 != null && queueMessageValue3 instanceof NullNode == false) {
                                JobQueueMessage queueMessageInstance = new JobQueueMessage();
                                errorActionInstance.setQueueMessage(queueMessageInstance);
                                
                                JsonNode storageAccountValue = queueMessageValue3.get("storageAccount");
                                if (storageAccountValue != null && storageAccountValue instanceof NullNode == false) {
                                    String storageAccountInstance;
                                    storageAccountInstance = storageAccountValue.getTextValue();
                                    queueMessageInstance.setStorageAccountName(storageAccountInstance);
                                }
                                
                                JsonNode queueNameValue = queueMessageValue3.get("queueName");
                                if (queueNameValue != null && queueNameValue instanceof NullNode == false) {
                                    String queueNameInstance;
                                    queueNameInstance = queueNameValue.getTextValue();
                                    queueMessageInstance.setQueueName(queueNameInstance);
                                }
                                
                                JsonNode sasTokenValue = queueMessageValue3.get("sasToken");
                                if (sasTokenValue != null && sasTokenValue instanceof NullNode == false) {
                                    String sasTokenInstance;
                                    sasTokenInstance = sasTokenValue.getTextValue();
                                    queueMessageInstance.setSasToken(sasTokenInstance);
                                }
                                
                                JsonNode messageValue = queueMessageValue3.get("message");
                                if (messageValue != null && messageValue instanceof NullNode == false) {
                                    String messageInstance;
                                    messageInstance = messageValue.getTextValue();
                                    queueMessageInstance.setMessage(messageInstance);
                                }
                            }
                            
                            JsonNode serviceBusTopicMessageValue3 = errorActionValue2.get("serviceBusTopicMessage");
                            if (serviceBusTopicMessageValue3 != null && serviceBusTopicMessageValue3 instanceof NullNode == false) {
                                JobServiceBusTopicMessage serviceBusTopicMessageInstance = new JobServiceBusTopicMessage();
                                errorActionInstance.setServiceBusTopicMessage(serviceBusTopicMessageInstance);
                                
                                JsonNode topicPathValue = serviceBusTopicMessageValue3.get("topicPath");
                                if (topicPathValue != null && topicPathValue instanceof NullNode == false) {
                                    String topicPathInstance;
                                    topicPathInstance = topicPathValue.getTextValue();
                                    serviceBusTopicMessageInstance.setTopicPath(topicPathInstance);
                                }
                                
                                JsonNode namespaceValue = serviceBusTopicMessageValue3.get("namespace");
                                if (namespaceValue != null && namespaceValue instanceof NullNode == false) {
                                    String namespaceInstance;
                                    namespaceInstance = namespaceValue.getTextValue();
                                    serviceBusTopicMessageInstance.setNamespace(namespaceInstance);
                                }
                                
                                JsonNode transportTypeValue = serviceBusTopicMessageValue3.get("transportType");
                                if (transportTypeValue != null && transportTypeValue instanceof NullNode == false) {
                                    JobServiceBusTransportType transportTypeInstance;
                                    transportTypeInstance = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue.getTextValue());
                                    serviceBusTopicMessageInstance.setTransportType(transportTypeInstance);
                                }
                                
                                JsonNode authenticationValue8 = serviceBusTopicMessageValue3.get("authentication");
                                if (authenticationValue8 != null && authenticationValue8 instanceof NullNode == false) {
                                    JobServiceBusAuthentication authenticationInstance = new JobServiceBusAuthentication();
                                    serviceBusTopicMessageInstance.setAuthentication(authenticationInstance);
                                    
                                    JsonNode sasKeyNameValue = authenticationValue8.get("sasKeyName");
                                    if (sasKeyNameValue != null && sasKeyNameValue instanceof NullNode == false) {
                                        String sasKeyNameInstance;
                                        sasKeyNameInstance = sasKeyNameValue.getTextValue();
                                        authenticationInstance.setSasKeyName(sasKeyNameInstance);
                                    }
                                    
                                    JsonNode sasKeyValue = authenticationValue8.get("sasKey");
                                    if (sasKeyValue != null && sasKeyValue instanceof NullNode == false) {
                                        String sasKeyInstance;
                                        sasKeyInstance = sasKeyValue.getTextValue();
                                        authenticationInstance.setSasKey(sasKeyInstance);
                                    }
                                    
                                    JsonNode typeValue6 = authenticationValue8.get("type");
                                    if (typeValue6 != null && typeValue6 instanceof NullNode == false) {
                                        JobServiceBusAuthenticationType typeInstance6;
                                        typeInstance6 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue6.getTextValue());
                                        authenticationInstance.setType(typeInstance6);
                                    }
                                }
                                
                                JsonNode messageValue2 = serviceBusTopicMessageValue3.get("message");
                                if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                    String messageInstance2;
                                    messageInstance2 = messageValue2.getTextValue();
                                    serviceBusTopicMessageInstance.setMessage(messageInstance2);
                                }
                                
                                JsonNode brokeredMessagePropertiesValue5 = serviceBusTopicMessageValue3.get("brokeredMessageProperties");
                                if (brokeredMessagePropertiesValue5 != null && brokeredMessagePropertiesValue5 instanceof NullNode == false) {
                                    JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance = new JobServiceBusBrokeredMessageProperties();
                                    serviceBusTopicMessageInstance.setBrokeredMessageProperties(brokeredMessagePropertiesInstance);
                                    
                                    JsonNode contentTypeValue = brokeredMessagePropertiesValue5.get("contentType");
                                    if (contentTypeValue != null && contentTypeValue instanceof NullNode == false) {
                                        String contentTypeInstance;
                                        contentTypeInstance = contentTypeValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setContentType(contentTypeInstance);
                                    }
                                    
                                    JsonNode correlationIdValue = brokeredMessagePropertiesValue5.get("correlationId");
                                    if (correlationIdValue != null && correlationIdValue instanceof NullNode == false) {
                                        String correlationIdInstance;
                                        correlationIdInstance = correlationIdValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setCorrelationId(correlationIdInstance);
                                    }
                                    
                                    JsonNode forcePersistenceValue = brokeredMessagePropertiesValue5.get("forcePersistence");
                                    if (forcePersistenceValue != null && forcePersistenceValue instanceof NullNode == false) {
                                        boolean forcePersistenceInstance;
                                        forcePersistenceInstance = forcePersistenceValue.getBooleanValue();
                                        brokeredMessagePropertiesInstance.setForcePersistence(forcePersistenceInstance);
                                    }
                                    
                                    JsonNode labelValue = brokeredMessagePropertiesValue5.get("label");
                                    if (labelValue != null && labelValue instanceof NullNode == false) {
                                        String labelInstance;
                                        labelInstance = labelValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setLabel(labelInstance);
                                    }
                                    
                                    JsonNode messageIdValue = brokeredMessagePropertiesValue5.get("messageId");
                                    if (messageIdValue != null && messageIdValue instanceof NullNode == false) {
                                        String messageIdInstance;
                                        messageIdInstance = messageIdValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setMessageId(messageIdInstance);
                                    }
                                    
                                    JsonNode partitionKeyValue = brokeredMessagePropertiesValue5.get("partitionKey");
                                    if (partitionKeyValue != null && partitionKeyValue instanceof NullNode == false) {
                                        String partitionKeyInstance;
                                        partitionKeyInstance = partitionKeyValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setPartitionKey(partitionKeyInstance);
                                    }
                                    
                                    JsonNode replyToValue = brokeredMessagePropertiesValue5.get("replyTo");
                                    if (replyToValue != null && replyToValue instanceof NullNode == false) {
                                        String replyToInstance;
                                        replyToInstance = replyToValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setReplyTo(replyToInstance);
                                    }
                                    
                                    JsonNode replyToSessionIdValue = brokeredMessagePropertiesValue5.get("replyToSessionId");
                                    if (replyToSessionIdValue != null && replyToSessionIdValue instanceof NullNode == false) {
                                        String replyToSessionIdInstance;
                                        replyToSessionIdInstance = replyToSessionIdValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setReplyToSessionId(replyToSessionIdInstance);
                                    }
                                    
                                    JsonNode scheduledEnqueueTimeUtcValue = brokeredMessagePropertiesValue5.get("scheduledEnqueueTimeUtc");
                                    if (scheduledEnqueueTimeUtcValue != null && scheduledEnqueueTimeUtcValue instanceof NullNode == false) {
                                        Calendar scheduledEnqueueTimeUtcInstance;
                                        scheduledEnqueueTimeUtcInstance = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue.getTextValue());
                                        brokeredMessagePropertiesInstance.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance);
                                    }
                                    
                                    JsonNode sessionIdValue = brokeredMessagePropertiesValue5.get("sessionId");
                                    if (sessionIdValue != null && sessionIdValue instanceof NullNode == false) {
                                        String sessionIdInstance;
                                        sessionIdInstance = sessionIdValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setSessionId(sessionIdInstance);
                                    }
                                    
                                    JsonNode timeToLiveValue = brokeredMessagePropertiesValue5.get("timeToLive");
                                    if (timeToLiveValue != null && timeToLiveValue instanceof NullNode == false) {
                                        Calendar timeToLiveInstance;
                                        timeToLiveInstance = DatatypeConverter.parseDateTime(timeToLiveValue.getTextValue());
                                        brokeredMessagePropertiesInstance.setTimeToLive(timeToLiveInstance);
                                    }
                                    
                                    JsonNode toValue = brokeredMessagePropertiesValue5.get("to");
                                    if (toValue != null && toValue instanceof NullNode == false) {
                                        String toInstance;
                                        toInstance = toValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setTo(toInstance);
                                    }
                                    
                                    JsonNode viaPartitionKeyValue = brokeredMessagePropertiesValue5.get("viaPartitionKey");
                                    if (viaPartitionKeyValue != null && viaPartitionKeyValue instanceof NullNode == false) {
                                        String viaPartitionKeyInstance;
                                        viaPartitionKeyInstance = viaPartitionKeyValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setViaPartitionKey(viaPartitionKeyInstance);
                                    }
                                }
                                
                                JsonNode customMessagePropertiesSequenceElement = ((JsonNode) serviceBusTopicMessageValue3.get("customMessageProperties"));
                                if (customMessagePropertiesSequenceElement != null && customMessagePropertiesSequenceElement instanceof NullNode == false) {
                                    Iterator<Map.Entry<String, JsonNode>> itr2 = customMessagePropertiesSequenceElement.getFields();
                                    while (itr2.hasNext()) {
                                        Map.Entry<String, JsonNode> property2 = itr2.next();
                                        String customMessagePropertiesKey5 = property2.getKey();
                                        String customMessagePropertiesValue5 = property2.getValue().getTextValue();
                                        serviceBusTopicMessageInstance.getCustomMessageProperties().put(customMessagePropertiesKey5, customMessagePropertiesValue5);
                                    }
                                }
                            }
                            
                            JsonNode serviceBusQueueMessageValue3 = errorActionValue2.get("serviceBusQueueMessage");
                            if (serviceBusQueueMessageValue3 != null && serviceBusQueueMessageValue3 instanceof NullNode == false) {
                                JobServiceBusQueueMessage serviceBusQueueMessageInstance = new JobServiceBusQueueMessage();
                                errorActionInstance.setServiceBusQueueMessage(serviceBusQueueMessageInstance);
                                
                                JsonNode queueNameValue2 = serviceBusQueueMessageValue3.get("queueName");
                                if (queueNameValue2 != null && queueNameValue2 instanceof NullNode == false) {
                                    String queueNameInstance2;
                                    queueNameInstance2 = queueNameValue2.getTextValue();
                                    serviceBusQueueMessageInstance.setQueueName(queueNameInstance2);
                                }
                                
                                JsonNode namespaceValue2 = serviceBusQueueMessageValue3.get("namespace");
                                if (namespaceValue2 != null && namespaceValue2 instanceof NullNode == false) {
                                    String namespaceInstance2;
                                    namespaceInstance2 = namespaceValue2.getTextValue();
                                    serviceBusQueueMessageInstance.setNamespace(namespaceInstance2);
                                }
                                
                                JsonNode transportTypeValue2 = serviceBusQueueMessageValue3.get("transportType");
                                if (transportTypeValue2 != null && transportTypeValue2 instanceof NullNode == false) {
                                    JobServiceBusTransportType transportTypeInstance2;
                                    transportTypeInstance2 = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue2.getTextValue());
                                    serviceBusQueueMessageInstance.setTransportType(transportTypeInstance2);
                                }
                                
                                JsonNode authenticationValue9 = serviceBusQueueMessageValue3.get("authentication");
                                if (authenticationValue9 != null && authenticationValue9 instanceof NullNode == false) {
                                    JobServiceBusAuthentication authenticationInstance2 = new JobServiceBusAuthentication();
                                    serviceBusQueueMessageInstance.setAuthentication(authenticationInstance2);
                                    
                                    JsonNode sasKeyNameValue2 = authenticationValue9.get("sasKeyName");
                                    if (sasKeyNameValue2 != null && sasKeyNameValue2 instanceof NullNode == false) {
                                        String sasKeyNameInstance2;
                                        sasKeyNameInstance2 = sasKeyNameValue2.getTextValue();
                                        authenticationInstance2.setSasKeyName(sasKeyNameInstance2);
                                    }
                                    
                                    JsonNode sasKeyValue2 = authenticationValue9.get("sasKey");
                                    if (sasKeyValue2 != null && sasKeyValue2 instanceof NullNode == false) {
                                        String sasKeyInstance2;
                                        sasKeyInstance2 = sasKeyValue2.getTextValue();
                                        authenticationInstance2.setSasKey(sasKeyInstance2);
                                    }
                                    
                                    JsonNode typeValue7 = authenticationValue9.get("type");
                                    if (typeValue7 != null && typeValue7 instanceof NullNode == false) {
                                        JobServiceBusAuthenticationType typeInstance7;
                                        typeInstance7 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue7.getTextValue());
                                        authenticationInstance2.setType(typeInstance7);
                                    }
                                }
                                
                                JsonNode messageValue3 = serviceBusQueueMessageValue3.get("message");
                                if (messageValue3 != null && messageValue3 instanceof NullNode == false) {
                                    String messageInstance3;
                                    messageInstance3 = messageValue3.getTextValue();
                                    serviceBusQueueMessageInstance.setMessage(messageInstance3);
                                }
                                
                                JsonNode brokeredMessagePropertiesValue6 = serviceBusQueueMessageValue3.get("brokeredMessageProperties");
                                if (brokeredMessagePropertiesValue6 != null && brokeredMessagePropertiesValue6 instanceof NullNode == false) {
                                    JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance2 = new JobServiceBusBrokeredMessageProperties();
                                    serviceBusQueueMessageInstance.setBrokeredMessageProperties(brokeredMessagePropertiesInstance2);
                                    
                                    JsonNode contentTypeValue2 = brokeredMessagePropertiesValue6.get("contentType");
                                    if (contentTypeValue2 != null && contentTypeValue2 instanceof NullNode == false) {
                                        String contentTypeInstance2;
                                        contentTypeInstance2 = contentTypeValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setContentType(contentTypeInstance2);
                                    }
                                    
                                    JsonNode correlationIdValue2 = brokeredMessagePropertiesValue6.get("correlationId");
                                    if (correlationIdValue2 != null && correlationIdValue2 instanceof NullNode == false) {
                                        String correlationIdInstance2;
                                        correlationIdInstance2 = correlationIdValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setCorrelationId(correlationIdInstance2);
                                    }
                                    
                                    JsonNode forcePersistenceValue2 = brokeredMessagePropertiesValue6.get("forcePersistence");
                                    if (forcePersistenceValue2 != null && forcePersistenceValue2 instanceof NullNode == false) {
                                        boolean forcePersistenceInstance2;
                                        forcePersistenceInstance2 = forcePersistenceValue2.getBooleanValue();
                                        brokeredMessagePropertiesInstance2.setForcePersistence(forcePersistenceInstance2);
                                    }
                                    
                                    JsonNode labelValue2 = brokeredMessagePropertiesValue6.get("label");
                                    if (labelValue2 != null && labelValue2 instanceof NullNode == false) {
                                        String labelInstance2;
                                        labelInstance2 = labelValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setLabel(labelInstance2);
                                    }
                                    
                                    JsonNode messageIdValue2 = brokeredMessagePropertiesValue6.get("messageId");
                                    if (messageIdValue2 != null && messageIdValue2 instanceof NullNode == false) {
                                        String messageIdInstance2;
                                        messageIdInstance2 = messageIdValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setMessageId(messageIdInstance2);
                                    }
                                    
                                    JsonNode partitionKeyValue2 = brokeredMessagePropertiesValue6.get("partitionKey");
                                    if (partitionKeyValue2 != null && partitionKeyValue2 instanceof NullNode == false) {
                                        String partitionKeyInstance2;
                                        partitionKeyInstance2 = partitionKeyValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setPartitionKey(partitionKeyInstance2);
                                    }
                                    
                                    JsonNode replyToValue2 = brokeredMessagePropertiesValue6.get("replyTo");
                                    if (replyToValue2 != null && replyToValue2 instanceof NullNode == false) {
                                        String replyToInstance2;
                                        replyToInstance2 = replyToValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setReplyTo(replyToInstance2);
                                    }
                                    
                                    JsonNode replyToSessionIdValue2 = brokeredMessagePropertiesValue6.get("replyToSessionId");
                                    if (replyToSessionIdValue2 != null && replyToSessionIdValue2 instanceof NullNode == false) {
                                        String replyToSessionIdInstance2;
                                        replyToSessionIdInstance2 = replyToSessionIdValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setReplyToSessionId(replyToSessionIdInstance2);
                                    }
                                    
                                    JsonNode scheduledEnqueueTimeUtcValue2 = brokeredMessagePropertiesValue6.get("scheduledEnqueueTimeUtc");
                                    if (scheduledEnqueueTimeUtcValue2 != null && scheduledEnqueueTimeUtcValue2 instanceof NullNode == false) {
                                        Calendar scheduledEnqueueTimeUtcInstance2;
                                        scheduledEnqueueTimeUtcInstance2 = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue2.getTextValue());
                                        brokeredMessagePropertiesInstance2.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance2);
                                    }
                                    
                                    JsonNode sessionIdValue2 = brokeredMessagePropertiesValue6.get("sessionId");
                                    if (sessionIdValue2 != null && sessionIdValue2 instanceof NullNode == false) {
                                        String sessionIdInstance2;
                                        sessionIdInstance2 = sessionIdValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setSessionId(sessionIdInstance2);
                                    }
                                    
                                    JsonNode timeToLiveValue2 = brokeredMessagePropertiesValue6.get("timeToLive");
                                    if (timeToLiveValue2 != null && timeToLiveValue2 instanceof NullNode == false) {
                                        Calendar timeToLiveInstance2;
                                        timeToLiveInstance2 = DatatypeConverter.parseDateTime(timeToLiveValue2.getTextValue());
                                        brokeredMessagePropertiesInstance2.setTimeToLive(timeToLiveInstance2);
                                    }
                                    
                                    JsonNode toValue2 = brokeredMessagePropertiesValue6.get("to");
                                    if (toValue2 != null && toValue2 instanceof NullNode == false) {
                                        String toInstance2;
                                        toInstance2 = toValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setTo(toInstance2);
                                    }
                                    
                                    JsonNode viaPartitionKeyValue2 = brokeredMessagePropertiesValue6.get("viaPartitionKey");
                                    if (viaPartitionKeyValue2 != null && viaPartitionKeyValue2 instanceof NullNode == false) {
                                        String viaPartitionKeyInstance2;
                                        viaPartitionKeyInstance2 = viaPartitionKeyValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setViaPartitionKey(viaPartitionKeyInstance2);
                                    }
                                }
                                
                                JsonNode customMessagePropertiesSequenceElement2 = ((JsonNode) serviceBusQueueMessageValue3.get("customMessageProperties"));
                                if (customMessagePropertiesSequenceElement2 != null && customMessagePropertiesSequenceElement2 instanceof NullNode == false) {
                                    Iterator<Map.Entry<String, JsonNode>> itr3 = customMessagePropertiesSequenceElement2.getFields();
                                    while (itr3.hasNext()) {
                                        Map.Entry<String, JsonNode> property3 = itr3.next();
                                        String customMessagePropertiesKey6 = property3.getKey();
                                        String customMessagePropertiesValue6 = property3.getValue().getTextValue();
                                        serviceBusQueueMessageInstance.getCustomMessageProperties().put(customMessagePropertiesKey6, customMessagePropertiesValue6);
                                    }
                                }
                            }
                        }
                        
                        JsonNode requestValue4 = actionValue2.get("request");
                        if (requestValue4 != null && requestValue4 instanceof NullNode == false) {
                            JobHttpRequest requestInstance2 = new JobHttpRequest();
                            actionInstance.setRequest(requestInstance2);
                            
                            JsonNode uriValue2 = requestValue4.get("uri");
                            if (uriValue2 != null && uriValue2 instanceof NullNode == false) {
                                URI uriInstance2;
                                uriInstance2 = new URI(uriValue2.getTextValue());
                                requestInstance2.setUri(uriInstance2);
                            }
                            
                            JsonNode methodValue2 = requestValue4.get("method");
                            if (methodValue2 != null && methodValue2 instanceof NullNode == false) {
                                String methodInstance2;
                                methodInstance2 = methodValue2.getTextValue();
                                requestInstance2.setMethod(methodInstance2);
                            }
                            
                            JsonNode headersSequenceElement2 = ((JsonNode) requestValue4.get("headers"));
                            if (headersSequenceElement2 != null && headersSequenceElement2 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr4 = headersSequenceElement2.getFields();
                                while (itr4.hasNext()) {
                                    Map.Entry<String, JsonNode> property4 = itr4.next();
                                    String headersKey4 = property4.getKey();
                                    String headersValue4 = property4.getValue().getTextValue();
                                    requestInstance2.getHeaders().put(headersKey4, headersValue4);
                                }
                            }
                            
                            JsonNode bodyValue2 = requestValue4.get("body");
                            if (bodyValue2 != null && bodyValue2 instanceof NullNode == false) {
                                String bodyInstance2;
                                bodyInstance2 = bodyValue2.getTextValue();
                                requestInstance2.setBody(bodyInstance2);
                            }
                            
                            JsonNode authenticationValue10 = requestValue4.get("authentication");
                            if (authenticationValue10 != null && authenticationValue10 instanceof NullNode == false) {
                                String typeName2 = authenticationValue10.get("type").getTextValue();
                                if ("ClientCertificate".equals(typeName2)) {
                                    ClientCertAuthentication clientCertAuthenticationInstance2 = new ClientCertAuthentication();
                                    
                                    JsonNode passwordValue3 = authenticationValue10.get("password");
                                    if (passwordValue3 != null && passwordValue3 instanceof NullNode == false) {
                                        String passwordInstance3;
                                        passwordInstance3 = passwordValue3.getTextValue();
                                        clientCertAuthenticationInstance2.setPassword(passwordInstance3);
                                    }
                                    
                                    JsonNode pfxValue2 = authenticationValue10.get("pfx");
                                    if (pfxValue2 != null && pfxValue2 instanceof NullNode == false) {
                                        String pfxInstance2;
                                        pfxInstance2 = pfxValue2.getTextValue();
                                        clientCertAuthenticationInstance2.setPfx(pfxInstance2);
                                    }
                                    
                                    JsonNode certificateThumbprintValue2 = authenticationValue10.get("certificateThumbprint");
                                    if (certificateThumbprintValue2 != null && certificateThumbprintValue2 instanceof NullNode == false) {
                                        String certificateThumbprintInstance2;
                                        certificateThumbprintInstance2 = certificateThumbprintValue2.getTextValue();
                                        clientCertAuthenticationInstance2.setCertificateThumbprint(certificateThumbprintInstance2);
                                    }
                                    
                                    JsonNode certificateExpirationValue2 = authenticationValue10.get("certificateExpiration");
                                    if (certificateExpirationValue2 != null && certificateExpirationValue2 instanceof NullNode == false) {
                                        Calendar certificateExpirationInstance2;
                                        certificateExpirationInstance2 = DatatypeConverter.parseDateTime(certificateExpirationValue2.getTextValue());
                                        clientCertAuthenticationInstance2.setCertificateExpiration(certificateExpirationInstance2);
                                    }
                                    
                                    JsonNode certificateSubjectNameValue2 = authenticationValue10.get("certificateSubjectName");
                                    if (certificateSubjectNameValue2 != null && certificateSubjectNameValue2 instanceof NullNode == false) {
                                        String certificateSubjectNameInstance2;
                                        certificateSubjectNameInstance2 = certificateSubjectNameValue2.getTextValue();
                                        clientCertAuthenticationInstance2.setCertificateSubjectName(certificateSubjectNameInstance2);
                                    }
                                    
                                    JsonNode typeValue8 = authenticationValue10.get("type");
                                    if (typeValue8 != null && typeValue8 instanceof NullNode == false) {
                                        HttpAuthenticationType typeInstance8;
                                        typeInstance8 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue8.getTextValue());
                                        clientCertAuthenticationInstance2.setType(typeInstance8);
                                    }
                                    requestInstance2.setAuthentication(clientCertAuthenticationInstance2);
                                }
                                if ("ActiveDirectoryOAuth".equals(typeName2)) {
                                    AADOAuthAuthentication aADOAuthAuthenticationInstance2 = new AADOAuthAuthentication();
                                    
                                    JsonNode secretValue2 = authenticationValue10.get("secret");
                                    if (secretValue2 != null && secretValue2 instanceof NullNode == false) {
                                        String secretInstance2;
                                        secretInstance2 = secretValue2.getTextValue();
                                        aADOAuthAuthenticationInstance2.setSecret(secretInstance2);
                                    }
                                    
                                    JsonNode tenantValue2 = authenticationValue10.get("tenant");
                                    if (tenantValue2 != null && tenantValue2 instanceof NullNode == false) {
                                        String tenantInstance2;
                                        tenantInstance2 = tenantValue2.getTextValue();
                                        aADOAuthAuthenticationInstance2.setTenant(tenantInstance2);
                                    }
                                    
                                    JsonNode audienceValue2 = authenticationValue10.get("audience");
                                    if (audienceValue2 != null && audienceValue2 instanceof NullNode == false) {
                                        String audienceInstance2;
                                        audienceInstance2 = audienceValue2.getTextValue();
                                        aADOAuthAuthenticationInstance2.setAudience(audienceInstance2);
                                    }
                                    
                                    JsonNode clientIdValue2 = authenticationValue10.get("clientId");
                                    if (clientIdValue2 != null && clientIdValue2 instanceof NullNode == false) {
                                        String clientIdInstance2;
                                        clientIdInstance2 = clientIdValue2.getTextValue();
                                        aADOAuthAuthenticationInstance2.setClientId(clientIdInstance2);
                                    }
                                    
                                    JsonNode typeValue9 = authenticationValue10.get("type");
                                    if (typeValue9 != null && typeValue9 instanceof NullNode == false) {
                                        HttpAuthenticationType typeInstance9;
                                        typeInstance9 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue9.getTextValue());
                                        aADOAuthAuthenticationInstance2.setType(typeInstance9);
                                    }
                                    requestInstance2.setAuthentication(aADOAuthAuthenticationInstance2);
                                }
                                if ("Basic".equals(typeName2)) {
                                    BasicAuthentication basicAuthenticationInstance2 = new BasicAuthentication();
                                    
                                    JsonNode usernameValue2 = authenticationValue10.get("username");
                                    if (usernameValue2 != null && usernameValue2 instanceof NullNode == false) {
                                        String usernameInstance2;
                                        usernameInstance2 = usernameValue2.getTextValue();
                                        basicAuthenticationInstance2.setUsername(usernameInstance2);
                                    }
                                    
                                    JsonNode passwordValue4 = authenticationValue10.get("password");
                                    if (passwordValue4 != null && passwordValue4 instanceof NullNode == false) {
                                        String passwordInstance4;
                                        passwordInstance4 = passwordValue4.getTextValue();
                                        basicAuthenticationInstance2.setPassword(passwordInstance4);
                                    }
                                    
                                    JsonNode typeValue10 = authenticationValue10.get("type");
                                    if (typeValue10 != null && typeValue10 instanceof NullNode == false) {
                                        HttpAuthenticationType typeInstance10;
                                        typeInstance10 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue10.getTextValue());
                                        basicAuthenticationInstance2.setType(typeInstance10);
                                    }
                                    requestInstance2.setAuthentication(basicAuthenticationInstance2);
                                }
                            }
                        }
                        
                        JsonNode queueMessageValue4 = actionValue2.get("queueMessage");
                        if (queueMessageValue4 != null && queueMessageValue4 instanceof NullNode == false) {
                            JobQueueMessage queueMessageInstance2 = new JobQueueMessage();
                            actionInstance.setQueueMessage(queueMessageInstance2);
                            
                            JsonNode storageAccountValue2 = queueMessageValue4.get("storageAccount");
                            if (storageAccountValue2 != null && storageAccountValue2 instanceof NullNode == false) {
                                String storageAccountInstance2;
                                storageAccountInstance2 = storageAccountValue2.getTextValue();
                                queueMessageInstance2.setStorageAccountName(storageAccountInstance2);
                            }
                            
                            JsonNode queueNameValue3 = queueMessageValue4.get("queueName");
                            if (queueNameValue3 != null && queueNameValue3 instanceof NullNode == false) {
                                String queueNameInstance3;
                                queueNameInstance3 = queueNameValue3.getTextValue();
                                queueMessageInstance2.setQueueName(queueNameInstance3);
                            }
                            
                            JsonNode sasTokenValue2 = queueMessageValue4.get("sasToken");
                            if (sasTokenValue2 != null && sasTokenValue2 instanceof NullNode == false) {
                                String sasTokenInstance2;
                                sasTokenInstance2 = sasTokenValue2.getTextValue();
                                queueMessageInstance2.setSasToken(sasTokenInstance2);
                            }
                            
                            JsonNode messageValue4 = queueMessageValue4.get("message");
                            if (messageValue4 != null && messageValue4 instanceof NullNode == false) {
                                String messageInstance4;
                                messageInstance4 = messageValue4.getTextValue();
                                queueMessageInstance2.setMessage(messageInstance4);
                            }
                        }
                        
                        JsonNode serviceBusTopicMessageValue4 = actionValue2.get("serviceBusTopicMessage");
                        if (serviceBusTopicMessageValue4 != null && serviceBusTopicMessageValue4 instanceof NullNode == false) {
                            JobServiceBusTopicMessage serviceBusTopicMessageInstance2 = new JobServiceBusTopicMessage();
                            actionInstance.setServiceBusTopicMessage(serviceBusTopicMessageInstance2);
                            
                            JsonNode topicPathValue2 = serviceBusTopicMessageValue4.get("topicPath");
                            if (topicPathValue2 != null && topicPathValue2 instanceof NullNode == false) {
                                String topicPathInstance2;
                                topicPathInstance2 = topicPathValue2.getTextValue();
                                serviceBusTopicMessageInstance2.setTopicPath(topicPathInstance2);
                            }
                            
                            JsonNode namespaceValue3 = serviceBusTopicMessageValue4.get("namespace");
                            if (namespaceValue3 != null && namespaceValue3 instanceof NullNode == false) {
                                String namespaceInstance3;
                                namespaceInstance3 = namespaceValue3.getTextValue();
                                serviceBusTopicMessageInstance2.setNamespace(namespaceInstance3);
                            }
                            
                            JsonNode transportTypeValue3 = serviceBusTopicMessageValue4.get("transportType");
                            if (transportTypeValue3 != null && transportTypeValue3 instanceof NullNode == false) {
                                JobServiceBusTransportType transportTypeInstance3;
                                transportTypeInstance3 = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue3.getTextValue());
                                serviceBusTopicMessageInstance2.setTransportType(transportTypeInstance3);
                            }
                            
                            JsonNode authenticationValue11 = serviceBusTopicMessageValue4.get("authentication");
                            if (authenticationValue11 != null && authenticationValue11 instanceof NullNode == false) {
                                JobServiceBusAuthentication authenticationInstance3 = new JobServiceBusAuthentication();
                                serviceBusTopicMessageInstance2.setAuthentication(authenticationInstance3);
                                
                                JsonNode sasKeyNameValue3 = authenticationValue11.get("sasKeyName");
                                if (sasKeyNameValue3 != null && sasKeyNameValue3 instanceof NullNode == false) {
                                    String sasKeyNameInstance3;
                                    sasKeyNameInstance3 = sasKeyNameValue3.getTextValue();
                                    authenticationInstance3.setSasKeyName(sasKeyNameInstance3);
                                }
                                
                                JsonNode sasKeyValue3 = authenticationValue11.get("sasKey");
                                if (sasKeyValue3 != null && sasKeyValue3 instanceof NullNode == false) {
                                    String sasKeyInstance3;
                                    sasKeyInstance3 = sasKeyValue3.getTextValue();
                                    authenticationInstance3.setSasKey(sasKeyInstance3);
                                }
                                
                                JsonNode typeValue11 = authenticationValue11.get("type");
                                if (typeValue11 != null && typeValue11 instanceof NullNode == false) {
                                    JobServiceBusAuthenticationType typeInstance11;
                                    typeInstance11 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue11.getTextValue());
                                    authenticationInstance3.setType(typeInstance11);
                                }
                            }
                            
                            JsonNode messageValue5 = serviceBusTopicMessageValue4.get("message");
                            if (messageValue5 != null && messageValue5 instanceof NullNode == false) {
                                String messageInstance5;
                                messageInstance5 = messageValue5.getTextValue();
                                serviceBusTopicMessageInstance2.setMessage(messageInstance5);
                            }
                            
                            JsonNode brokeredMessagePropertiesValue7 = serviceBusTopicMessageValue4.get("brokeredMessageProperties");
                            if (brokeredMessagePropertiesValue7 != null && brokeredMessagePropertiesValue7 instanceof NullNode == false) {
                                JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance3 = new JobServiceBusBrokeredMessageProperties();
                                serviceBusTopicMessageInstance2.setBrokeredMessageProperties(brokeredMessagePropertiesInstance3);
                                
                                JsonNode contentTypeValue3 = brokeredMessagePropertiesValue7.get("contentType");
                                if (contentTypeValue3 != null && contentTypeValue3 instanceof NullNode == false) {
                                    String contentTypeInstance3;
                                    contentTypeInstance3 = contentTypeValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setContentType(contentTypeInstance3);
                                }
                                
                                JsonNode correlationIdValue3 = brokeredMessagePropertiesValue7.get("correlationId");
                                if (correlationIdValue3 != null && correlationIdValue3 instanceof NullNode == false) {
                                    String correlationIdInstance3;
                                    correlationIdInstance3 = correlationIdValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setCorrelationId(correlationIdInstance3);
                                }
                                
                                JsonNode forcePersistenceValue3 = brokeredMessagePropertiesValue7.get("forcePersistence");
                                if (forcePersistenceValue3 != null && forcePersistenceValue3 instanceof NullNode == false) {
                                    boolean forcePersistenceInstance3;
                                    forcePersistenceInstance3 = forcePersistenceValue3.getBooleanValue();
                                    brokeredMessagePropertiesInstance3.setForcePersistence(forcePersistenceInstance3);
                                }
                                
                                JsonNode labelValue3 = brokeredMessagePropertiesValue7.get("label");
                                if (labelValue3 != null && labelValue3 instanceof NullNode == false) {
                                    String labelInstance3;
                                    labelInstance3 = labelValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setLabel(labelInstance3);
                                }
                                
                                JsonNode messageIdValue3 = brokeredMessagePropertiesValue7.get("messageId");
                                if (messageIdValue3 != null && messageIdValue3 instanceof NullNode == false) {
                                    String messageIdInstance3;
                                    messageIdInstance3 = messageIdValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setMessageId(messageIdInstance3);
                                }
                                
                                JsonNode partitionKeyValue3 = brokeredMessagePropertiesValue7.get("partitionKey");
                                if (partitionKeyValue3 != null && partitionKeyValue3 instanceof NullNode == false) {
                                    String partitionKeyInstance3;
                                    partitionKeyInstance3 = partitionKeyValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setPartitionKey(partitionKeyInstance3);
                                }
                                
                                JsonNode replyToValue3 = brokeredMessagePropertiesValue7.get("replyTo");
                                if (replyToValue3 != null && replyToValue3 instanceof NullNode == false) {
                                    String replyToInstance3;
                                    replyToInstance3 = replyToValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setReplyTo(replyToInstance3);
                                }
                                
                                JsonNode replyToSessionIdValue3 = brokeredMessagePropertiesValue7.get("replyToSessionId");
                                if (replyToSessionIdValue3 != null && replyToSessionIdValue3 instanceof NullNode == false) {
                                    String replyToSessionIdInstance3;
                                    replyToSessionIdInstance3 = replyToSessionIdValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setReplyToSessionId(replyToSessionIdInstance3);
                                }
                                
                                JsonNode scheduledEnqueueTimeUtcValue3 = brokeredMessagePropertiesValue7.get("scheduledEnqueueTimeUtc");
                                if (scheduledEnqueueTimeUtcValue3 != null && scheduledEnqueueTimeUtcValue3 instanceof NullNode == false) {
                                    Calendar scheduledEnqueueTimeUtcInstance3;
                                    scheduledEnqueueTimeUtcInstance3 = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue3.getTextValue());
                                    brokeredMessagePropertiesInstance3.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance3);
                                }
                                
                                JsonNode sessionIdValue3 = brokeredMessagePropertiesValue7.get("sessionId");
                                if (sessionIdValue3 != null && sessionIdValue3 instanceof NullNode == false) {
                                    String sessionIdInstance3;
                                    sessionIdInstance3 = sessionIdValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setSessionId(sessionIdInstance3);
                                }
                                
                                JsonNode timeToLiveValue3 = brokeredMessagePropertiesValue7.get("timeToLive");
                                if (timeToLiveValue3 != null && timeToLiveValue3 instanceof NullNode == false) {
                                    Calendar timeToLiveInstance3;
                                    timeToLiveInstance3 = DatatypeConverter.parseDateTime(timeToLiveValue3.getTextValue());
                                    brokeredMessagePropertiesInstance3.setTimeToLive(timeToLiveInstance3);
                                }
                                
                                JsonNode toValue3 = brokeredMessagePropertiesValue7.get("to");
                                if (toValue3 != null && toValue3 instanceof NullNode == false) {
                                    String toInstance3;
                                    toInstance3 = toValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setTo(toInstance3);
                                }
                                
                                JsonNode viaPartitionKeyValue3 = brokeredMessagePropertiesValue7.get("viaPartitionKey");
                                if (viaPartitionKeyValue3 != null && viaPartitionKeyValue3 instanceof NullNode == false) {
                                    String viaPartitionKeyInstance3;
                                    viaPartitionKeyInstance3 = viaPartitionKeyValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setViaPartitionKey(viaPartitionKeyInstance3);
                                }
                            }
                            
                            JsonNode customMessagePropertiesSequenceElement3 = ((JsonNode) serviceBusTopicMessageValue4.get("customMessageProperties"));
                            if (customMessagePropertiesSequenceElement3 != null && customMessagePropertiesSequenceElement3 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr5 = customMessagePropertiesSequenceElement3.getFields();
                                while (itr5.hasNext()) {
                                    Map.Entry<String, JsonNode> property5 = itr5.next();
                                    String customMessagePropertiesKey7 = property5.getKey();
                                    String customMessagePropertiesValue7 = property5.getValue().getTextValue();
                                    serviceBusTopicMessageInstance2.getCustomMessageProperties().put(customMessagePropertiesKey7, customMessagePropertiesValue7);
                                }
                            }
                        }
                        
                        JsonNode serviceBusQueueMessageValue4 = actionValue2.get("serviceBusQueueMessage");
                        if (serviceBusQueueMessageValue4 != null && serviceBusQueueMessageValue4 instanceof NullNode == false) {
                            JobServiceBusQueueMessage serviceBusQueueMessageInstance2 = new JobServiceBusQueueMessage();
                            actionInstance.setServiceBusQueueMessage(serviceBusQueueMessageInstance2);
                            
                            JsonNode queueNameValue4 = serviceBusQueueMessageValue4.get("queueName");
                            if (queueNameValue4 != null && queueNameValue4 instanceof NullNode == false) {
                                String queueNameInstance4;
                                queueNameInstance4 = queueNameValue4.getTextValue();
                                serviceBusQueueMessageInstance2.setQueueName(queueNameInstance4);
                            }
                            
                            JsonNode namespaceValue4 = serviceBusQueueMessageValue4.get("namespace");
                            if (namespaceValue4 != null && namespaceValue4 instanceof NullNode == false) {
                                String namespaceInstance4;
                                namespaceInstance4 = namespaceValue4.getTextValue();
                                serviceBusQueueMessageInstance2.setNamespace(namespaceInstance4);
                            }
                            
                            JsonNode transportTypeValue4 = serviceBusQueueMessageValue4.get("transportType");
                            if (transportTypeValue4 != null && transportTypeValue4 instanceof NullNode == false) {
                                JobServiceBusTransportType transportTypeInstance4;
                                transportTypeInstance4 = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue4.getTextValue());
                                serviceBusQueueMessageInstance2.setTransportType(transportTypeInstance4);
                            }
                            
                            JsonNode authenticationValue12 = serviceBusQueueMessageValue4.get("authentication");
                            if (authenticationValue12 != null && authenticationValue12 instanceof NullNode == false) {
                                JobServiceBusAuthentication authenticationInstance4 = new JobServiceBusAuthentication();
                                serviceBusQueueMessageInstance2.setAuthentication(authenticationInstance4);
                                
                                JsonNode sasKeyNameValue4 = authenticationValue12.get("sasKeyName");
                                if (sasKeyNameValue4 != null && sasKeyNameValue4 instanceof NullNode == false) {
                                    String sasKeyNameInstance4;
                                    sasKeyNameInstance4 = sasKeyNameValue4.getTextValue();
                                    authenticationInstance4.setSasKeyName(sasKeyNameInstance4);
                                }
                                
                                JsonNode sasKeyValue4 = authenticationValue12.get("sasKey");
                                if (sasKeyValue4 != null && sasKeyValue4 instanceof NullNode == false) {
                                    String sasKeyInstance4;
                                    sasKeyInstance4 = sasKeyValue4.getTextValue();
                                    authenticationInstance4.setSasKey(sasKeyInstance4);
                                }
                                
                                JsonNode typeValue12 = authenticationValue12.get("type");
                                if (typeValue12 != null && typeValue12 instanceof NullNode == false) {
                                    JobServiceBusAuthenticationType typeInstance12;
                                    typeInstance12 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue12.getTextValue());
                                    authenticationInstance4.setType(typeInstance12);
                                }
                            }
                            
                            JsonNode messageValue6 = serviceBusQueueMessageValue4.get("message");
                            if (messageValue6 != null && messageValue6 instanceof NullNode == false) {
                                String messageInstance6;
                                messageInstance6 = messageValue6.getTextValue();
                                serviceBusQueueMessageInstance2.setMessage(messageInstance6);
                            }
                            
                            JsonNode brokeredMessagePropertiesValue8 = serviceBusQueueMessageValue4.get("brokeredMessageProperties");
                            if (brokeredMessagePropertiesValue8 != null && brokeredMessagePropertiesValue8 instanceof NullNode == false) {
                                JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance4 = new JobServiceBusBrokeredMessageProperties();
                                serviceBusQueueMessageInstance2.setBrokeredMessageProperties(brokeredMessagePropertiesInstance4);
                                
                                JsonNode contentTypeValue4 = brokeredMessagePropertiesValue8.get("contentType");
                                if (contentTypeValue4 != null && contentTypeValue4 instanceof NullNode == false) {
                                    String contentTypeInstance4;
                                    contentTypeInstance4 = contentTypeValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setContentType(contentTypeInstance4);
                                }
                                
                                JsonNode correlationIdValue4 = brokeredMessagePropertiesValue8.get("correlationId");
                                if (correlationIdValue4 != null && correlationIdValue4 instanceof NullNode == false) {
                                    String correlationIdInstance4;
                                    correlationIdInstance4 = correlationIdValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setCorrelationId(correlationIdInstance4);
                                }
                                
                                JsonNode forcePersistenceValue4 = brokeredMessagePropertiesValue8.get("forcePersistence");
                                if (forcePersistenceValue4 != null && forcePersistenceValue4 instanceof NullNode == false) {
                                    boolean forcePersistenceInstance4;
                                    forcePersistenceInstance4 = forcePersistenceValue4.getBooleanValue();
                                    brokeredMessagePropertiesInstance4.setForcePersistence(forcePersistenceInstance4);
                                }
                                
                                JsonNode labelValue4 = brokeredMessagePropertiesValue8.get("label");
                                if (labelValue4 != null && labelValue4 instanceof NullNode == false) {
                                    String labelInstance4;
                                    labelInstance4 = labelValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setLabel(labelInstance4);
                                }
                                
                                JsonNode messageIdValue4 = brokeredMessagePropertiesValue8.get("messageId");
                                if (messageIdValue4 != null && messageIdValue4 instanceof NullNode == false) {
                                    String messageIdInstance4;
                                    messageIdInstance4 = messageIdValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setMessageId(messageIdInstance4);
                                }
                                
                                JsonNode partitionKeyValue4 = brokeredMessagePropertiesValue8.get("partitionKey");
                                if (partitionKeyValue4 != null && partitionKeyValue4 instanceof NullNode == false) {
                                    String partitionKeyInstance4;
                                    partitionKeyInstance4 = partitionKeyValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setPartitionKey(partitionKeyInstance4);
                                }
                                
                                JsonNode replyToValue4 = brokeredMessagePropertiesValue8.get("replyTo");
                                if (replyToValue4 != null && replyToValue4 instanceof NullNode == false) {
                                    String replyToInstance4;
                                    replyToInstance4 = replyToValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setReplyTo(replyToInstance4);
                                }
                                
                                JsonNode replyToSessionIdValue4 = brokeredMessagePropertiesValue8.get("replyToSessionId");
                                if (replyToSessionIdValue4 != null && replyToSessionIdValue4 instanceof NullNode == false) {
                                    String replyToSessionIdInstance4;
                                    replyToSessionIdInstance4 = replyToSessionIdValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setReplyToSessionId(replyToSessionIdInstance4);
                                }
                                
                                JsonNode scheduledEnqueueTimeUtcValue4 = brokeredMessagePropertiesValue8.get("scheduledEnqueueTimeUtc");
                                if (scheduledEnqueueTimeUtcValue4 != null && scheduledEnqueueTimeUtcValue4 instanceof NullNode == false) {
                                    Calendar scheduledEnqueueTimeUtcInstance4;
                                    scheduledEnqueueTimeUtcInstance4 = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue4.getTextValue());
                                    brokeredMessagePropertiesInstance4.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance4);
                                }
                                
                                JsonNode sessionIdValue4 = brokeredMessagePropertiesValue8.get("sessionId");
                                if (sessionIdValue4 != null && sessionIdValue4 instanceof NullNode == false) {
                                    String sessionIdInstance4;
                                    sessionIdInstance4 = sessionIdValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setSessionId(sessionIdInstance4);
                                }
                                
                                JsonNode timeToLiveValue4 = brokeredMessagePropertiesValue8.get("timeToLive");
                                if (timeToLiveValue4 != null && timeToLiveValue4 instanceof NullNode == false) {
                                    Calendar timeToLiveInstance4;
                                    timeToLiveInstance4 = DatatypeConverter.parseDateTime(timeToLiveValue4.getTextValue());
                                    brokeredMessagePropertiesInstance4.setTimeToLive(timeToLiveInstance4);
                                }
                                
                                JsonNode toValue4 = brokeredMessagePropertiesValue8.get("to");
                                if (toValue4 != null && toValue4 instanceof NullNode == false) {
                                    String toInstance4;
                                    toInstance4 = toValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setTo(toInstance4);
                                }
                                
                                JsonNode viaPartitionKeyValue4 = brokeredMessagePropertiesValue8.get("viaPartitionKey");
                                if (viaPartitionKeyValue4 != null && viaPartitionKeyValue4 instanceof NullNode == false) {
                                    String viaPartitionKeyInstance4;
                                    viaPartitionKeyInstance4 = viaPartitionKeyValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setViaPartitionKey(viaPartitionKeyInstance4);
                                }
                            }
                            
                            JsonNode customMessagePropertiesSequenceElement4 = ((JsonNode) serviceBusQueueMessageValue4.get("customMessageProperties"));
                            if (customMessagePropertiesSequenceElement4 != null && customMessagePropertiesSequenceElement4 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr6 = customMessagePropertiesSequenceElement4.getFields();
                                while (itr6.hasNext()) {
                                    Map.Entry<String, JsonNode> property6 = itr6.next();
                                    String customMessagePropertiesKey8 = property6.getKey();
                                    String customMessagePropertiesValue8 = property6.getValue().getTextValue();
                                    serviceBusQueueMessageInstance2.getCustomMessageProperties().put(customMessagePropertiesKey8, customMessagePropertiesValue8);
                                }
                            }
                        }
                    }
                    
                    JsonNode recurrenceValue2 = responseDoc.get("recurrence");
                    if (recurrenceValue2 != null && recurrenceValue2 instanceof NullNode == false) {
                        JobRecurrence recurrenceInstance = new JobRecurrence();
                        jobInstance.setRecurrence(recurrenceInstance);
                        
                        JsonNode frequencyValue = recurrenceValue2.get("frequency");
                        if (frequencyValue != null && frequencyValue instanceof NullNode == false) {
                            JobRecurrenceFrequency frequencyInstance;
                            frequencyInstance = SchedulerClientImpl.parseJobRecurrenceFrequency(frequencyValue.getTextValue());
                            recurrenceInstance.setFrequency(frequencyInstance);
                        }
                        
                        JsonNode intervalValue = recurrenceValue2.get("interval");
                        if (intervalValue != null && intervalValue instanceof NullNode == false) {
                            int intervalInstance;
                            intervalInstance = intervalValue.getIntValue();
                            recurrenceInstance.setInterval(intervalInstance);
                        }
                        
                        JsonNode countValue = recurrenceValue2.get("count");
                        if (countValue != null && countValue instanceof NullNode == false) {
                            int countInstance;
                            countInstance = countValue.getIntValue();
                            recurrenceInstance.setCount(countInstance);
                        }
                        
                        JsonNode endTimeValue = recurrenceValue2.get("endTime");
                        if (endTimeValue != null && endTimeValue instanceof NullNode == false) {
                            Calendar endTimeInstance;
                            endTimeInstance = DatatypeConverter.parseDateTime(endTimeValue.getTextValue());
                            recurrenceInstance.setEndTime(endTimeInstance);
                        }
                        
                        JsonNode scheduleValue2 = recurrenceValue2.get("schedule");
                        if (scheduleValue2 != null && scheduleValue2 instanceof NullNode == false) {
                            JobRecurrenceSchedule scheduleInstance = new JobRecurrenceSchedule();
                            recurrenceInstance.setSchedule(scheduleInstance);
                            
                            JsonNode minutesArray2 = scheduleValue2.get("minutes");
                            if (minutesArray2 != null && minutesArray2 instanceof NullNode == false) {
                                scheduleInstance.setMinutes(new ArrayList<Integer>());
                                for (JsonNode minutesValue : ((ArrayNode) minutesArray2)) {
                                    scheduleInstance.getMinutes().add(minutesValue.getIntValue());
                                }
                            }
                            
                            JsonNode hoursArray2 = scheduleValue2.get("hours");
                            if (hoursArray2 != null && hoursArray2 instanceof NullNode == false) {
                                scheduleInstance.setHours(new ArrayList<Integer>());
                                for (JsonNode hoursValue : ((ArrayNode) hoursArray2)) {
                                    scheduleInstance.getHours().add(hoursValue.getIntValue());
                                }
                            }
                            
                            JsonNode weekDaysArray2 = scheduleValue2.get("weekDays");
                            if (weekDaysArray2 != null && weekDaysArray2 instanceof NullNode == false) {
                                scheduleInstance.setDays(new ArrayList<JobScheduleDay>());
                                for (JsonNode weekDaysValue : ((ArrayNode) weekDaysArray2)) {
                                    scheduleInstance.getDays().add(SchedulerClientImpl.parseJobScheduleDay(weekDaysValue.getTextValue()));
                                }
                            }
                            
                            JsonNode monthsArray2 = scheduleValue2.get("months");
                            if (monthsArray2 != null && monthsArray2 instanceof NullNode == false) {
                                scheduleInstance.setMonths(new ArrayList<Integer>());
                                for (JsonNode monthsValue : ((ArrayNode) monthsArray2)) {
                                    scheduleInstance.getMonths().add(monthsValue.getIntValue());
                                }
                            }
                            
                            JsonNode monthDaysArray2 = scheduleValue2.get("monthDays");
                            if (monthDaysArray2 != null && monthDaysArray2 instanceof NullNode == false) {
                                scheduleInstance.setMonthDays(new ArrayList<Integer>());
                                for (JsonNode monthDaysValue : ((ArrayNode) monthDaysArray2)) {
                                    scheduleInstance.getMonthDays().add(monthDaysValue.getIntValue());
                                }
                            }
                            
                            JsonNode monthlyOccurrencesArray2 = scheduleValue2.get("monthlyOccurrences");
                            if (monthlyOccurrencesArray2 != null && monthlyOccurrencesArray2 instanceof NullNode == false) {
                                scheduleInstance.setMonthlyOccurrences(new ArrayList<JobScheduleMonthlyOccurrence>());
                                for (JsonNode monthlyOccurrencesValue : ((ArrayNode) monthlyOccurrencesArray2)) {
                                    JobScheduleMonthlyOccurrence jobScheduleMonthlyOccurrenceInstance = new JobScheduleMonthlyOccurrence();
                                    scheduleInstance.getMonthlyOccurrences().add(jobScheduleMonthlyOccurrenceInstance);
                                    
                                    JsonNode dayValue = monthlyOccurrencesValue.get("day");
                                    if (dayValue != null && dayValue instanceof NullNode == false) {
                                        JobScheduleDay dayInstance;
                                        dayInstance = SchedulerClientImpl.parseJobScheduleDay(dayValue.getTextValue());
                                        jobScheduleMonthlyOccurrenceInstance.setDay(dayInstance);
                                    }
                                    
                                    JsonNode occurrenceValue = monthlyOccurrencesValue.get("occurrence");
                                    if (occurrenceValue != null && occurrenceValue instanceof NullNode == false) {
                                        int occurrenceInstance;
                                        occurrenceInstance = occurrenceValue.getIntValue();
                                        jobScheduleMonthlyOccurrenceInstance.setOccurrence(occurrenceInstance);
                                    }
                                }
                            }
                        }
                    }
                    
                    JsonNode statusValue = responseDoc.get("status");
                    if (statusValue != null && statusValue instanceof NullNode == false) {
                        JobStatus statusInstance = new JobStatus();
                        jobInstance.setStatus(statusInstance);
                        
                        JsonNode lastExecutionTimeValue = statusValue.get("lastExecutionTime");
                        if (lastExecutionTimeValue != null && lastExecutionTimeValue instanceof NullNode == false) {
                            Calendar lastExecutionTimeInstance;
                            lastExecutionTimeInstance = DatatypeConverter.parseDateTime(lastExecutionTimeValue.getTextValue());
                            statusInstance.setLastExecutionTime(lastExecutionTimeInstance);
                        }
                        
                        JsonNode nextExecutionTimeValue = statusValue.get("nextExecutionTime");
                        if (nextExecutionTimeValue != null && nextExecutionTimeValue instanceof NullNode == false) {
                            Calendar nextExecutionTimeInstance;
                            nextExecutionTimeInstance = DatatypeConverter.parseDateTime(nextExecutionTimeValue.getTextValue());
                            statusInstance.setNextExecutionTime(nextExecutionTimeInstance);
                        }
                        
                        JsonNode executionCountValue = statusValue.get("executionCount");
                        if (executionCountValue != null && executionCountValue instanceof NullNode == false) {
                            int executionCountInstance;
                            executionCountInstance = executionCountValue.getIntValue();
                            statusInstance.setExecutionCount(executionCountInstance);
                        }
                        
                        JsonNode failureCountValue = statusValue.get("failureCount");
                        if (failureCountValue != null && failureCountValue instanceof NullNode == false) {
                            int failureCountInstance;
                            failureCountInstance = failureCountValue.getIntValue();
                            statusInstance.setFailureCount(failureCountInstance);
                        }
                        
                        JsonNode faultedCountValue = statusValue.get("faultedCount");
                        if (faultedCountValue != null && faultedCountValue instanceof NullNode == false) {
                            int faultedCountInstance;
                            faultedCountInstance = faultedCountValue.getIntValue();
                            statusInstance.setFaultedCount(faultedCountInstance);
                        }
                    }
                    
                    JsonNode stateValue = responseDoc.get("state");
                    if (stateValue != null && stateValue instanceof NullNode == false) {
                        JobState stateInstance;
                        stateInstance = SchedulerClientImpl.parseJobState(stateValue.getTextValue());
                        jobInstance.setState(stateInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Creates a new Job with a user-provided job id, or updates an existing
    * job, replacing its definition with that specified.
    *
    * @param jobId Required. Id of the job to create or update.
    * @param parameters Required. Parameters specifying the job definition for
    * a CreateOrUpdate Job operation.
    * @return The CreateOrUpdate Job operation response.
    */
    @Override
    public Future<JobCreateOrUpdateResponse> createOrUpdateAsync(final String jobId, final JobCreateOrUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<JobCreateOrUpdateResponse>() { 
            @Override
            public JobCreateOrUpdateResponse call() throws Exception {
                return createOrUpdate(jobId, parameters);
            }
         });
    }
    
    /**
    * Creates a new Job with a user-provided job id, or updates an existing
    * job, replacing its definition with that specified.
    *
    * @param jobId Required. Id of the job to create or update.
    * @param parameters Required. Parameters specifying the job definition for
    * a CreateOrUpdate Job operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The CreateOrUpdate Job operation response.
    */
    @Override
    public JobCreateOrUpdateResponse createOrUpdate(String jobId, JobCreateOrUpdateParameters parameters) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (jobId == null) {
            throw new NullPointerException("jobId");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getAction() == null) {
            throw new NullPointerException("parameters.Action");
        }
        if (parameters.getAction().getErrorAction() != null) {
            if (parameters.getAction().getErrorAction().getQueueMessage() != null) {
                if (parameters.getAction().getErrorAction().getQueueMessage().getMessage() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.QueueMessage.Message");
                }
                if (parameters.getAction().getErrorAction().getQueueMessage().getQueueName() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.QueueMessage.QueueName");
                }
                if (parameters.getAction().getErrorAction().getQueueMessage().getSasToken() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.QueueMessage.SasToken");
                }
                if (parameters.getAction().getErrorAction().getQueueMessage().getStorageAccountName() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.QueueMessage.StorageAccountName");
                }
            }
            if (parameters.getAction().getErrorAction().getRequest() != null) {
                if (parameters.getAction().getErrorAction().getRequest().getMethod() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.Request.Method");
                }
                if (parameters.getAction().getErrorAction().getRequest().getUri() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.Request.Uri");
                }
            }
            if (parameters.getAction().getErrorAction().getServiceBusQueueMessage() != null) {
                if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getAuthentication() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusQueueMessage.Authentication");
                }
                if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getAuthentication().getSasKey() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusQueueMessage.Authentication.SasKey");
                }
                if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getAuthentication().getSasKeyName() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusQueueMessage.Authentication.SasKeyName");
                }
                if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getAuthentication().getType() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusQueueMessage.Authentication.Type");
                }
                if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getMessage() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusQueueMessage.Message");
                }
                if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getNamespace() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusQueueMessage.Namespace");
                }
                if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getQueueName() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusQueueMessage.QueueName");
                }
                if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getTransportType() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusQueueMessage.TransportType");
                }
            }
            if (parameters.getAction().getErrorAction().getServiceBusTopicMessage() != null) {
                if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getAuthentication() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusTopicMessage.Authentication");
                }
                if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getAuthentication().getSasKey() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusTopicMessage.Authentication.SasKey");
                }
                if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getAuthentication().getSasKeyName() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusTopicMessage.Authentication.SasKeyName");
                }
                if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getAuthentication().getType() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusTopicMessage.Authentication.Type");
                }
                if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getMessage() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusTopicMessage.Message");
                }
                if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getNamespace() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusTopicMessage.Namespace");
                }
                if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getTopicPath() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusTopicMessage.TopicPath");
                }
                if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getTransportType() == null) {
                    throw new NullPointerException("parameters.Action.ErrorAction.ServiceBusTopicMessage.TransportType");
                }
            }
            if (parameters.getAction().getErrorAction().getType() == null) {
                throw new NullPointerException("parameters.Action.ErrorAction.Type");
            }
        }
        if (parameters.getAction().getQueueMessage() != null) {
            if (parameters.getAction().getQueueMessage().getMessage() == null) {
                throw new NullPointerException("parameters.Action.QueueMessage.Message");
            }
            if (parameters.getAction().getQueueMessage().getQueueName() == null) {
                throw new NullPointerException("parameters.Action.QueueMessage.QueueName");
            }
            if (parameters.getAction().getQueueMessage().getSasToken() == null) {
                throw new NullPointerException("parameters.Action.QueueMessage.SasToken");
            }
            if (parameters.getAction().getQueueMessage().getStorageAccountName() == null) {
                throw new NullPointerException("parameters.Action.QueueMessage.StorageAccountName");
            }
        }
        if (parameters.getAction().getRequest() != null) {
            if (parameters.getAction().getRequest().getMethod() == null) {
                throw new NullPointerException("parameters.Action.Request.Method");
            }
            if (parameters.getAction().getRequest().getUri() == null) {
                throw new NullPointerException("parameters.Action.Request.Uri");
            }
        }
        if (parameters.getAction().getRetryPolicy() != null) {
            if (parameters.getAction().getRetryPolicy().getRetryType() == null) {
                throw new NullPointerException("parameters.Action.RetryPolicy.RetryType");
            }
        }
        if (parameters.getAction().getServiceBusQueueMessage() != null) {
            if (parameters.getAction().getServiceBusQueueMessage().getAuthentication() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusQueueMessage.Authentication");
            }
            if (parameters.getAction().getServiceBusQueueMessage().getAuthentication().getSasKey() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusQueueMessage.Authentication.SasKey");
            }
            if (parameters.getAction().getServiceBusQueueMessage().getAuthentication().getSasKeyName() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusQueueMessage.Authentication.SasKeyName");
            }
            if (parameters.getAction().getServiceBusQueueMessage().getAuthentication().getType() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusQueueMessage.Authentication.Type");
            }
            if (parameters.getAction().getServiceBusQueueMessage().getMessage() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusQueueMessage.Message");
            }
            if (parameters.getAction().getServiceBusQueueMessage().getNamespace() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusQueueMessage.Namespace");
            }
            if (parameters.getAction().getServiceBusQueueMessage().getQueueName() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusQueueMessage.QueueName");
            }
            if (parameters.getAction().getServiceBusQueueMessage().getTransportType() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusQueueMessage.TransportType");
            }
        }
        if (parameters.getAction().getServiceBusTopicMessage() != null) {
            if (parameters.getAction().getServiceBusTopicMessage().getAuthentication() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusTopicMessage.Authentication");
            }
            if (parameters.getAction().getServiceBusTopicMessage().getAuthentication().getSasKey() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusTopicMessage.Authentication.SasKey");
            }
            if (parameters.getAction().getServiceBusTopicMessage().getAuthentication().getSasKeyName() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusTopicMessage.Authentication.SasKeyName");
            }
            if (parameters.getAction().getServiceBusTopicMessage().getAuthentication().getType() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusTopicMessage.Authentication.Type");
            }
            if (parameters.getAction().getServiceBusTopicMessage().getMessage() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusTopicMessage.Message");
            }
            if (parameters.getAction().getServiceBusTopicMessage().getNamespace() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusTopicMessage.Namespace");
            }
            if (parameters.getAction().getServiceBusTopicMessage().getTopicPath() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusTopicMessage.TopicPath");
            }
            if (parameters.getAction().getServiceBusTopicMessage().getTransportType() == null) {
                throw new NullPointerException("parameters.Action.ServiceBusTopicMessage.TransportType");
            }
        }
        if (parameters.getAction().getType() == null) {
            throw new NullPointerException("parameters.Action.Type");
        }
        if (parameters.getRecurrence() != null) {
            if (parameters.getRecurrence().getFrequency() == null) {
                throw new NullPointerException("parameters.Recurrence.Frequency");
            }
            if (parameters.getRecurrence().getSchedule() != null) {
                if (parameters.getRecurrence().getSchedule().getMonthlyOccurrences() != null) {
                    for (JobScheduleMonthlyOccurrence monthlyOccurrencesParameterItem : parameters.getRecurrence().getSchedule().getMonthlyOccurrences()) {
                        if (monthlyOccurrencesParameterItem.getDay() == null) {
                            throw new NullPointerException("parameters.Recurrence.Schedule.MonthlyOccurrences.Day");
                        }
                    }
                }
            }
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("jobId", jobId);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/cloudservices/";
        url = url + URLEncoder.encode(this.getClient().getCloudServiceName(), "UTF-8");
        url = url + "/resources/";
        url = url + "scheduler";
        url = url + "/~/";
        url = url + "JobCollections";
        url = url + "/";
        url = url + URLEncoder.encode(this.getClient().getJobCollectionName(), "UTF-8");
        url = url + "/jobs/";
        url = url + URLEncoder.encode(jobId, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        httpRequest.setHeader("x-ms-version", "2013-03-01");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode jobCreateOrUpdateParametersValue = objectMapper.createObjectNode();
        requestDoc = jobCreateOrUpdateParametersValue;
        
        if (parameters.getStartTime() != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            ((ObjectNode) jobCreateOrUpdateParametersValue).put("startTime", simpleDateFormat.format(parameters.getStartTime().getTime()));
        }
        
        ObjectNode actionValue = objectMapper.createObjectNode();
        ((ObjectNode) jobCreateOrUpdateParametersValue).put("action", actionValue);
        
        ((ObjectNode) actionValue).put("type", SchedulerClientImpl.jobActionTypeToString(parameters.getAction().getType()));
        
        if (parameters.getAction().getRetryPolicy() != null) {
            ObjectNode retryPolicyValue = objectMapper.createObjectNode();
            ((ObjectNode) actionValue).put("retryPolicy", retryPolicyValue);
            
            ((ObjectNode) retryPolicyValue).put("retryType", SchedulerClientImpl.retryTypeToString(parameters.getAction().getRetryPolicy().getRetryType()));
            
            if (parameters.getAction().getRetryPolicy().getRetryInterval() != null) {
                ((ObjectNode) retryPolicyValue).put("retryInterval", TimeSpan8601Converter.format(parameters.getAction().getRetryPolicy().getRetryInterval()));
            }
            
            if (parameters.getAction().getRetryPolicy().getRetryCount() != null) {
                ((ObjectNode) retryPolicyValue).put("retryCount", parameters.getAction().getRetryPolicy().getRetryCount());
            }
        }
        
        if (parameters.getAction().getErrorAction() != null) {
            ObjectNode errorActionValue = objectMapper.createObjectNode();
            ((ObjectNode) actionValue).put("errorAction", errorActionValue);
            
            ((ObjectNode) errorActionValue).put("type", SchedulerClientImpl.jobActionTypeToString(parameters.getAction().getErrorAction().getType()));
            
            if (parameters.getAction().getErrorAction().getRequest() != null) {
                ObjectNode requestValue = objectMapper.createObjectNode();
                ((ObjectNode) errorActionValue).put("request", requestValue);
                
                ((ObjectNode) requestValue).put("uri", parameters.getAction().getErrorAction().getRequest().getUri().toString());
                
                ((ObjectNode) requestValue).put("method", parameters.getAction().getErrorAction().getRequest().getMethod());
                
                if (parameters.getAction().getErrorAction().getRequest().getHeaders() != null) {
                    if (parameters.getAction().getErrorAction().getRequest().getHeaders() instanceof LazyCollection == false || ((LazyCollection) parameters.getAction().getErrorAction().getRequest().getHeaders()).isInitialized()) {
                        ObjectNode headersDictionary = objectMapper.createObjectNode();
                        for (Map.Entry<String, String> entry : parameters.getAction().getErrorAction().getRequest().getHeaders().entrySet()) {
                            String headersKey = entry.getKey();
                            String headersValue = entry.getValue();
                            ((ObjectNode) headersDictionary).put(headersKey, headersValue);
                        }
                        ((ObjectNode) requestValue).put("headers", headersDictionary);
                    }
                }
                
                if (parameters.getAction().getErrorAction().getRequest().getBody() != null) {
                    ((ObjectNode) requestValue).put("body", parameters.getAction().getErrorAction().getRequest().getBody());
                }
                
                if (parameters.getAction().getErrorAction().getRequest().getAuthentication() != null) {
                    ObjectNode authenticationValue = objectMapper.createObjectNode();
                    ((ObjectNode) requestValue).put("authentication", authenticationValue);
                    if (parameters.getAction().getErrorAction().getRequest().getAuthentication() instanceof ClientCertAuthentication) {
                        ((ObjectNode) authenticationValue).put("type", "ClientCertificate");
                        ClientCertAuthentication derived = ((ClientCertAuthentication) parameters.getAction().getErrorAction().getRequest().getAuthentication());
                        
                        if (derived.getPassword() != null) {
                            ((ObjectNode) authenticationValue).put("password", derived.getPassword());
                        }
                        
                        if (derived.getPfx() != null) {
                            ((ObjectNode) authenticationValue).put("pfx", derived.getPfx());
                        }
                        
                        if (derived.getCertificateThumbprint() != null) {
                            ((ObjectNode) authenticationValue).put("certificateThumbprint", derived.getCertificateThumbprint());
                        }
                        
                        if (derived.getCertificateExpiration() != null) {
                            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                            simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
                            ((ObjectNode) authenticationValue).put("certificateExpiration", simpleDateFormat2.format(derived.getCertificateExpiration().getTime()));
                        }
                        
                        if (derived.getCertificateSubjectName() != null) {
                            ((ObjectNode) authenticationValue).put("certificateSubjectName", derived.getCertificateSubjectName());
                        }
                        
                        if (derived.getType() != null) {
                            ((ObjectNode) authenticationValue).put("type", SchedulerClientImpl.httpAuthenticationTypeToString(derived.getType()));
                        }
                    }
                    if (parameters.getAction().getErrorAction().getRequest().getAuthentication() instanceof AADOAuthAuthentication) {
                        ((ObjectNode) authenticationValue).put("type", "ActiveDirectoryOAuth");
                        AADOAuthAuthentication derived2 = ((AADOAuthAuthentication) parameters.getAction().getErrorAction().getRequest().getAuthentication());
                        
                        if (derived2.getSecret() != null) {
                            ((ObjectNode) authenticationValue).put("secret", derived2.getSecret());
                        }
                        
                        if (derived2.getTenant() != null) {
                            ((ObjectNode) authenticationValue).put("tenant", derived2.getTenant());
                        }
                        
                        if (derived2.getAudience() != null) {
                            ((ObjectNode) authenticationValue).put("audience", derived2.getAudience());
                        }
                        
                        if (derived2.getClientId() != null) {
                            ((ObjectNode) authenticationValue).put("clientId", derived2.getClientId());
                        }
                        
                        if (derived2.getType() != null) {
                            ((ObjectNode) authenticationValue).put("type", SchedulerClientImpl.httpAuthenticationTypeToString(derived2.getType()));
                        }
                    }
                    if (parameters.getAction().getErrorAction().getRequest().getAuthentication() instanceof BasicAuthentication) {
                        ((ObjectNode) authenticationValue).put("type", "Basic");
                        BasicAuthentication derived3 = ((BasicAuthentication) parameters.getAction().getErrorAction().getRequest().getAuthentication());
                        
                        ((ObjectNode) authenticationValue).put("username", derived3.getUsername());
                        
                        if (derived3.getPassword() != null) {
                            ((ObjectNode) authenticationValue).put("password", derived3.getPassword());
                        }
                        
                        if (derived3.getType() != null) {
                            ((ObjectNode) authenticationValue).put("type", SchedulerClientImpl.httpAuthenticationTypeToString(derived3.getType()));
                        }
                    }
                }
            }
            
            if (parameters.getAction().getErrorAction().getQueueMessage() != null) {
                ObjectNode queueMessageValue = objectMapper.createObjectNode();
                ((ObjectNode) errorActionValue).put("queueMessage", queueMessageValue);
                
                ((ObjectNode) queueMessageValue).put("storageAccount", parameters.getAction().getErrorAction().getQueueMessage().getStorageAccountName());
                
                ((ObjectNode) queueMessageValue).put("queueName", parameters.getAction().getErrorAction().getQueueMessage().getQueueName());
                
                ((ObjectNode) queueMessageValue).put("sasToken", parameters.getAction().getErrorAction().getQueueMessage().getSasToken());
                
                ((ObjectNode) queueMessageValue).put("message", parameters.getAction().getErrorAction().getQueueMessage().getMessage());
            }
            
            if (parameters.getAction().getErrorAction().getServiceBusTopicMessage() != null) {
                ObjectNode serviceBusTopicMessageValue = objectMapper.createObjectNode();
                ((ObjectNode) errorActionValue).put("serviceBusTopicMessage", serviceBusTopicMessageValue);
                
                ((ObjectNode) serviceBusTopicMessageValue).put("topicPath", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getTopicPath());
                
                ((ObjectNode) serviceBusTopicMessageValue).put("namespace", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getNamespace());
                
                ((ObjectNode) serviceBusTopicMessageValue).put("transportType", SchedulerClientImpl.jobServiceBusTransportTypeToString(parameters.getAction().getErrorAction().getServiceBusTopicMessage().getTransportType()));
                
                ObjectNode authenticationValue2 = objectMapper.createObjectNode();
                ((ObjectNode) serviceBusTopicMessageValue).put("authentication", authenticationValue2);
                
                ((ObjectNode) authenticationValue2).put("sasKeyName", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getAuthentication().getSasKeyName());
                
                ((ObjectNode) authenticationValue2).put("sasKey", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getAuthentication().getSasKey());
                
                ((ObjectNode) authenticationValue2).put("type", SchedulerClientImpl.jobServiceBusAuthenticationTypeToString(parameters.getAction().getErrorAction().getServiceBusTopicMessage().getAuthentication().getType()));
                
                ((ObjectNode) serviceBusTopicMessageValue).put("message", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getMessage());
                
                if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties() != null) {
                    ObjectNode brokeredMessagePropertiesValue = objectMapper.createObjectNode();
                    ((ObjectNode) serviceBusTopicMessageValue).put("brokeredMessageProperties", brokeredMessagePropertiesValue);
                    
                    if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getContentType() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue).put("contentType", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getContentType());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getCorrelationId() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue).put("correlationId", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getCorrelationId());
                    }
                    
                    ((ObjectNode) brokeredMessagePropertiesValue).put("forcePersistence", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().isForcePersistence());
                    
                    if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getLabel() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue).put("label", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getLabel());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getMessageId() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue).put("messageId", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getMessageId());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getPartitionKey() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue).put("partitionKey", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getPartitionKey());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getReplyTo() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue).put("replyTo", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getReplyTo());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getReplyToSessionId() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue).put("replyToSessionId", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getReplyToSessionId());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getScheduledEnqueueTimeUtc() != null) {
                        SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                        simpleDateFormat3.setTimeZone(TimeZone.getTimeZone("UTC"));
                        ((ObjectNode) brokeredMessagePropertiesValue).put("scheduledEnqueueTimeUtc", simpleDateFormat3.format(parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getScheduledEnqueueTimeUtc().getTime()));
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getSessionId() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue).put("sessionId", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getSessionId());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getTimeToLive() != null) {
                        SimpleDateFormat simpleDateFormat4 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                        simpleDateFormat4.setTimeZone(TimeZone.getTimeZone("UTC"));
                        ((ObjectNode) brokeredMessagePropertiesValue).put("timeToLive", simpleDateFormat4.format(parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getTimeToLive().getTime()));
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getTo() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue).put("to", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getTo());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getViaPartitionKey() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue).put("viaPartitionKey", parameters.getAction().getErrorAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getViaPartitionKey());
                    }
                }
                
                if (parameters.getAction().getErrorAction().getServiceBusTopicMessage().getCustomMessageProperties() != null) {
                    ObjectNode customMessagePropertiesDictionary = objectMapper.createObjectNode();
                    for (Map.Entry<String, String> entry2 : parameters.getAction().getErrorAction().getServiceBusTopicMessage().getCustomMessageProperties().entrySet()) {
                        String customMessagePropertiesKey = entry2.getKey();
                        String customMessagePropertiesValue = entry2.getValue();
                        ((ObjectNode) customMessagePropertiesDictionary).put(customMessagePropertiesKey, customMessagePropertiesValue);
                    }
                    ((ObjectNode) serviceBusTopicMessageValue).put("customMessageProperties", customMessagePropertiesDictionary);
                }
            }
            
            if (parameters.getAction().getErrorAction().getServiceBusQueueMessage() != null) {
                ObjectNode serviceBusQueueMessageValue = objectMapper.createObjectNode();
                ((ObjectNode) errorActionValue).put("serviceBusQueueMessage", serviceBusQueueMessageValue);
                
                ((ObjectNode) serviceBusQueueMessageValue).put("queueName", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getQueueName());
                
                ((ObjectNode) serviceBusQueueMessageValue).put("namespace", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getNamespace());
                
                ((ObjectNode) serviceBusQueueMessageValue).put("transportType", SchedulerClientImpl.jobServiceBusTransportTypeToString(parameters.getAction().getErrorAction().getServiceBusQueueMessage().getTransportType()));
                
                ObjectNode authenticationValue3 = objectMapper.createObjectNode();
                ((ObjectNode) serviceBusQueueMessageValue).put("authentication", authenticationValue3);
                
                ((ObjectNode) authenticationValue3).put("sasKeyName", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getAuthentication().getSasKeyName());
                
                ((ObjectNode) authenticationValue3).put("sasKey", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getAuthentication().getSasKey());
                
                ((ObjectNode) authenticationValue3).put("type", SchedulerClientImpl.jobServiceBusAuthenticationTypeToString(parameters.getAction().getErrorAction().getServiceBusQueueMessage().getAuthentication().getType()));
                
                ((ObjectNode) serviceBusQueueMessageValue).put("message", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getMessage());
                
                if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties() != null) {
                    ObjectNode brokeredMessagePropertiesValue2 = objectMapper.createObjectNode();
                    ((ObjectNode) serviceBusQueueMessageValue).put("brokeredMessageProperties", brokeredMessagePropertiesValue2);
                    
                    if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getContentType() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue2).put("contentType", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getContentType());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getCorrelationId() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue2).put("correlationId", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getCorrelationId());
                    }
                    
                    ((ObjectNode) brokeredMessagePropertiesValue2).put("forcePersistence", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().isForcePersistence());
                    
                    if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getLabel() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue2).put("label", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getLabel());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getMessageId() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue2).put("messageId", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getMessageId());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getPartitionKey() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue2).put("partitionKey", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getPartitionKey());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getReplyTo() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue2).put("replyTo", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getReplyTo());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getReplyToSessionId() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue2).put("replyToSessionId", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getReplyToSessionId());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getScheduledEnqueueTimeUtc() != null) {
                        SimpleDateFormat simpleDateFormat5 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                        simpleDateFormat5.setTimeZone(TimeZone.getTimeZone("UTC"));
                        ((ObjectNode) brokeredMessagePropertiesValue2).put("scheduledEnqueueTimeUtc", simpleDateFormat5.format(parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getScheduledEnqueueTimeUtc().getTime()));
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getSessionId() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue2).put("sessionId", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getSessionId());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getTimeToLive() != null) {
                        SimpleDateFormat simpleDateFormat6 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                        simpleDateFormat6.setTimeZone(TimeZone.getTimeZone("UTC"));
                        ((ObjectNode) brokeredMessagePropertiesValue2).put("timeToLive", simpleDateFormat6.format(parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getTimeToLive().getTime()));
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getTo() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue2).put("to", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getTo());
                    }
                    
                    if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getViaPartitionKey() != null) {
                        ((ObjectNode) brokeredMessagePropertiesValue2).put("viaPartitionKey", parameters.getAction().getErrorAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getViaPartitionKey());
                    }
                }
                
                if (parameters.getAction().getErrorAction().getServiceBusQueueMessage().getCustomMessageProperties() != null) {
                    ObjectNode customMessagePropertiesDictionary2 = objectMapper.createObjectNode();
                    for (Map.Entry<String, String> entry3 : parameters.getAction().getErrorAction().getServiceBusQueueMessage().getCustomMessageProperties().entrySet()) {
                        String customMessagePropertiesKey2 = entry3.getKey();
                        String customMessagePropertiesValue2 = entry3.getValue();
                        ((ObjectNode) customMessagePropertiesDictionary2).put(customMessagePropertiesKey2, customMessagePropertiesValue2);
                    }
                    ((ObjectNode) serviceBusQueueMessageValue).put("customMessageProperties", customMessagePropertiesDictionary2);
                }
            }
        }
        
        if (parameters.getAction().getRequest() != null) {
            ObjectNode requestValue2 = objectMapper.createObjectNode();
            ((ObjectNode) actionValue).put("request", requestValue2);
            
            ((ObjectNode) requestValue2).put("uri", parameters.getAction().getRequest().getUri().toString());
            
            ((ObjectNode) requestValue2).put("method", parameters.getAction().getRequest().getMethod());
            
            if (parameters.getAction().getRequest().getHeaders() != null) {
                if (parameters.getAction().getRequest().getHeaders() instanceof LazyCollection == false || ((LazyCollection) parameters.getAction().getRequest().getHeaders()).isInitialized()) {
                    ObjectNode headersDictionary2 = objectMapper.createObjectNode();
                    for (Map.Entry<String, String> entry4 : parameters.getAction().getRequest().getHeaders().entrySet()) {
                        String headersKey2 = entry4.getKey();
                        String headersValue2 = entry4.getValue();
                        ((ObjectNode) headersDictionary2).put(headersKey2, headersValue2);
                    }
                    ((ObjectNode) requestValue2).put("headers", headersDictionary2);
                }
            }
            
            if (parameters.getAction().getRequest().getBody() != null) {
                ((ObjectNode) requestValue2).put("body", parameters.getAction().getRequest().getBody());
            }
            
            if (parameters.getAction().getRequest().getAuthentication() != null) {
                ObjectNode authenticationValue4 = objectMapper.createObjectNode();
                ((ObjectNode) requestValue2).put("authentication", authenticationValue4);
                if (parameters.getAction().getRequest().getAuthentication() instanceof ClientCertAuthentication) {
                    ((ObjectNode) authenticationValue4).put("type", "ClientCertificate");
                    ClientCertAuthentication derived4 = ((ClientCertAuthentication) parameters.getAction().getRequest().getAuthentication());
                    
                    if (derived4.getPassword() != null) {
                        ((ObjectNode) authenticationValue4).put("password", derived4.getPassword());
                    }
                    
                    if (derived4.getPfx() != null) {
                        ((ObjectNode) authenticationValue4).put("pfx", derived4.getPfx());
                    }
                    
                    if (derived4.getCertificateThumbprint() != null) {
                        ((ObjectNode) authenticationValue4).put("certificateThumbprint", derived4.getCertificateThumbprint());
                    }
                    
                    if (derived4.getCertificateExpiration() != null) {
                        SimpleDateFormat simpleDateFormat7 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                        simpleDateFormat7.setTimeZone(TimeZone.getTimeZone("UTC"));
                        ((ObjectNode) authenticationValue4).put("certificateExpiration", simpleDateFormat7.format(derived4.getCertificateExpiration().getTime()));
                    }
                    
                    if (derived4.getCertificateSubjectName() != null) {
                        ((ObjectNode) authenticationValue4).put("certificateSubjectName", derived4.getCertificateSubjectName());
                    }
                    
                    if (derived4.getType() != null) {
                        ((ObjectNode) authenticationValue4).put("type", SchedulerClientImpl.httpAuthenticationTypeToString(derived4.getType()));
                    }
                }
                if (parameters.getAction().getRequest().getAuthentication() instanceof AADOAuthAuthentication) {
                    ((ObjectNode) authenticationValue4).put("type", "ActiveDirectoryOAuth");
                    AADOAuthAuthentication derived5 = ((AADOAuthAuthentication) parameters.getAction().getRequest().getAuthentication());
                    
                    if (derived5.getSecret() != null) {
                        ((ObjectNode) authenticationValue4).put("secret", derived5.getSecret());
                    }
                    
                    if (derived5.getTenant() != null) {
                        ((ObjectNode) authenticationValue4).put("tenant", derived5.getTenant());
                    }
                    
                    if (derived5.getAudience() != null) {
                        ((ObjectNode) authenticationValue4).put("audience", derived5.getAudience());
                    }
                    
                    if (derived5.getClientId() != null) {
                        ((ObjectNode) authenticationValue4).put("clientId", derived5.getClientId());
                    }
                    
                    if (derived5.getType() != null) {
                        ((ObjectNode) authenticationValue4).put("type", SchedulerClientImpl.httpAuthenticationTypeToString(derived5.getType()));
                    }
                }
                if (parameters.getAction().getRequest().getAuthentication() instanceof BasicAuthentication) {
                    ((ObjectNode) authenticationValue4).put("type", "Basic");
                    BasicAuthentication derived6 = ((BasicAuthentication) parameters.getAction().getRequest().getAuthentication());
                    
                    ((ObjectNode) authenticationValue4).put("username", derived6.getUsername());
                    
                    if (derived6.getPassword() != null) {
                        ((ObjectNode) authenticationValue4).put("password", derived6.getPassword());
                    }
                    
                    if (derived6.getType() != null) {
                        ((ObjectNode) authenticationValue4).put("type", SchedulerClientImpl.httpAuthenticationTypeToString(derived6.getType()));
                    }
                }
            }
        }
        
        if (parameters.getAction().getQueueMessage() != null) {
            ObjectNode queueMessageValue2 = objectMapper.createObjectNode();
            ((ObjectNode) actionValue).put("queueMessage", queueMessageValue2);
            
            ((ObjectNode) queueMessageValue2).put("storageAccount", parameters.getAction().getQueueMessage().getStorageAccountName());
            
            ((ObjectNode) queueMessageValue2).put("queueName", parameters.getAction().getQueueMessage().getQueueName());
            
            ((ObjectNode) queueMessageValue2).put("sasToken", parameters.getAction().getQueueMessage().getSasToken());
            
            ((ObjectNode) queueMessageValue2).put("message", parameters.getAction().getQueueMessage().getMessage());
        }
        
        if (parameters.getAction().getServiceBusTopicMessage() != null) {
            ObjectNode serviceBusTopicMessageValue2 = objectMapper.createObjectNode();
            ((ObjectNode) actionValue).put("serviceBusTopicMessage", serviceBusTopicMessageValue2);
            
            ((ObjectNode) serviceBusTopicMessageValue2).put("topicPath", parameters.getAction().getServiceBusTopicMessage().getTopicPath());
            
            ((ObjectNode) serviceBusTopicMessageValue2).put("namespace", parameters.getAction().getServiceBusTopicMessage().getNamespace());
            
            ((ObjectNode) serviceBusTopicMessageValue2).put("transportType", SchedulerClientImpl.jobServiceBusTransportTypeToString(parameters.getAction().getServiceBusTopicMessage().getTransportType()));
            
            ObjectNode authenticationValue5 = objectMapper.createObjectNode();
            ((ObjectNode) serviceBusTopicMessageValue2).put("authentication", authenticationValue5);
            
            ((ObjectNode) authenticationValue5).put("sasKeyName", parameters.getAction().getServiceBusTopicMessage().getAuthentication().getSasKeyName());
            
            ((ObjectNode) authenticationValue5).put("sasKey", parameters.getAction().getServiceBusTopicMessage().getAuthentication().getSasKey());
            
            ((ObjectNode) authenticationValue5).put("type", SchedulerClientImpl.jobServiceBusAuthenticationTypeToString(parameters.getAction().getServiceBusTopicMessage().getAuthentication().getType()));
            
            ((ObjectNode) serviceBusTopicMessageValue2).put("message", parameters.getAction().getServiceBusTopicMessage().getMessage());
            
            if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties() != null) {
                ObjectNode brokeredMessagePropertiesValue3 = objectMapper.createObjectNode();
                ((ObjectNode) serviceBusTopicMessageValue2).put("brokeredMessageProperties", brokeredMessagePropertiesValue3);
                
                if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getContentType() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue3).put("contentType", parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getContentType());
                }
                
                if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getCorrelationId() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue3).put("correlationId", parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getCorrelationId());
                }
                
                ((ObjectNode) brokeredMessagePropertiesValue3).put("forcePersistence", parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().isForcePersistence());
                
                if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getLabel() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue3).put("label", parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getLabel());
                }
                
                if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getMessageId() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue3).put("messageId", parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getMessageId());
                }
                
                if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getPartitionKey() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue3).put("partitionKey", parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getPartitionKey());
                }
                
                if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getReplyTo() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue3).put("replyTo", parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getReplyTo());
                }
                
                if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getReplyToSessionId() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue3).put("replyToSessionId", parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getReplyToSessionId());
                }
                
                if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getScheduledEnqueueTimeUtc() != null) {
                    SimpleDateFormat simpleDateFormat8 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat8.setTimeZone(TimeZone.getTimeZone("UTC"));
                    ((ObjectNode) brokeredMessagePropertiesValue3).put("scheduledEnqueueTimeUtc", simpleDateFormat8.format(parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getScheduledEnqueueTimeUtc().getTime()));
                }
                
                if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getSessionId() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue3).put("sessionId", parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getSessionId());
                }
                
                if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getTimeToLive() != null) {
                    SimpleDateFormat simpleDateFormat9 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat9.setTimeZone(TimeZone.getTimeZone("UTC"));
                    ((ObjectNode) brokeredMessagePropertiesValue3).put("timeToLive", simpleDateFormat9.format(parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getTimeToLive().getTime()));
                }
                
                if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getTo() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue3).put("to", parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getTo());
                }
                
                if (parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getViaPartitionKey() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue3).put("viaPartitionKey", parameters.getAction().getServiceBusTopicMessage().getBrokeredMessageProperties().getViaPartitionKey());
                }
            }
            
            if (parameters.getAction().getServiceBusTopicMessage().getCustomMessageProperties() != null) {
                ObjectNode customMessagePropertiesDictionary3 = objectMapper.createObjectNode();
                for (Map.Entry<String, String> entry5 : parameters.getAction().getServiceBusTopicMessage().getCustomMessageProperties().entrySet()) {
                    String customMessagePropertiesKey3 = entry5.getKey();
                    String customMessagePropertiesValue3 = entry5.getValue();
                    ((ObjectNode) customMessagePropertiesDictionary3).put(customMessagePropertiesKey3, customMessagePropertiesValue3);
                }
                ((ObjectNode) serviceBusTopicMessageValue2).put("customMessageProperties", customMessagePropertiesDictionary3);
            }
        }
        
        if (parameters.getAction().getServiceBusQueueMessage() != null) {
            ObjectNode serviceBusQueueMessageValue2 = objectMapper.createObjectNode();
            ((ObjectNode) actionValue).put("serviceBusQueueMessage", serviceBusQueueMessageValue2);
            
            ((ObjectNode) serviceBusQueueMessageValue2).put("queueName", parameters.getAction().getServiceBusQueueMessage().getQueueName());
            
            ((ObjectNode) serviceBusQueueMessageValue2).put("namespace", parameters.getAction().getServiceBusQueueMessage().getNamespace());
            
            ((ObjectNode) serviceBusQueueMessageValue2).put("transportType", SchedulerClientImpl.jobServiceBusTransportTypeToString(parameters.getAction().getServiceBusQueueMessage().getTransportType()));
            
            ObjectNode authenticationValue6 = objectMapper.createObjectNode();
            ((ObjectNode) serviceBusQueueMessageValue2).put("authentication", authenticationValue6);
            
            ((ObjectNode) authenticationValue6).put("sasKeyName", parameters.getAction().getServiceBusQueueMessage().getAuthentication().getSasKeyName());
            
            ((ObjectNode) authenticationValue6).put("sasKey", parameters.getAction().getServiceBusQueueMessage().getAuthentication().getSasKey());
            
            ((ObjectNode) authenticationValue6).put("type", SchedulerClientImpl.jobServiceBusAuthenticationTypeToString(parameters.getAction().getServiceBusQueueMessage().getAuthentication().getType()));
            
            ((ObjectNode) serviceBusQueueMessageValue2).put("message", parameters.getAction().getServiceBusQueueMessage().getMessage());
            
            if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties() != null) {
                ObjectNode brokeredMessagePropertiesValue4 = objectMapper.createObjectNode();
                ((ObjectNode) serviceBusQueueMessageValue2).put("brokeredMessageProperties", brokeredMessagePropertiesValue4);
                
                if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getContentType() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue4).put("contentType", parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getContentType());
                }
                
                if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getCorrelationId() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue4).put("correlationId", parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getCorrelationId());
                }
                
                ((ObjectNode) brokeredMessagePropertiesValue4).put("forcePersistence", parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().isForcePersistence());
                
                if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getLabel() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue4).put("label", parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getLabel());
                }
                
                if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getMessageId() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue4).put("messageId", parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getMessageId());
                }
                
                if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getPartitionKey() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue4).put("partitionKey", parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getPartitionKey());
                }
                
                if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getReplyTo() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue4).put("replyTo", parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getReplyTo());
                }
                
                if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getReplyToSessionId() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue4).put("replyToSessionId", parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getReplyToSessionId());
                }
                
                if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getScheduledEnqueueTimeUtc() != null) {
                    SimpleDateFormat simpleDateFormat10 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat10.setTimeZone(TimeZone.getTimeZone("UTC"));
                    ((ObjectNode) brokeredMessagePropertiesValue4).put("scheduledEnqueueTimeUtc", simpleDateFormat10.format(parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getScheduledEnqueueTimeUtc().getTime()));
                }
                
                if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getSessionId() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue4).put("sessionId", parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getSessionId());
                }
                
                if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getTimeToLive() != null) {
                    SimpleDateFormat simpleDateFormat11 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat11.setTimeZone(TimeZone.getTimeZone("UTC"));
                    ((ObjectNode) brokeredMessagePropertiesValue4).put("timeToLive", simpleDateFormat11.format(parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getTimeToLive().getTime()));
                }
                
                if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getTo() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue4).put("to", parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getTo());
                }
                
                if (parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getViaPartitionKey() != null) {
                    ((ObjectNode) brokeredMessagePropertiesValue4).put("viaPartitionKey", parameters.getAction().getServiceBusQueueMessage().getBrokeredMessageProperties().getViaPartitionKey());
                }
            }
            
            if (parameters.getAction().getServiceBusQueueMessage().getCustomMessageProperties() != null) {
                ObjectNode customMessagePropertiesDictionary4 = objectMapper.createObjectNode();
                for (Map.Entry<String, String> entry6 : parameters.getAction().getServiceBusQueueMessage().getCustomMessageProperties().entrySet()) {
                    String customMessagePropertiesKey4 = entry6.getKey();
                    String customMessagePropertiesValue4 = entry6.getValue();
                    ((ObjectNode) customMessagePropertiesDictionary4).put(customMessagePropertiesKey4, customMessagePropertiesValue4);
                }
                ((ObjectNode) serviceBusQueueMessageValue2).put("customMessageProperties", customMessagePropertiesDictionary4);
            }
        }
        
        if (parameters.getRecurrence() != null) {
            ObjectNode recurrenceValue = objectMapper.createObjectNode();
            ((ObjectNode) jobCreateOrUpdateParametersValue).put("recurrence", recurrenceValue);
            
            ((ObjectNode) recurrenceValue).put("frequency", SchedulerClientImpl.jobRecurrenceFrequencyToString(parameters.getRecurrence().getFrequency()));
            
            if (parameters.getRecurrence().getInterval() != null) {
                ((ObjectNode) recurrenceValue).put("interval", parameters.getRecurrence().getInterval());
            }
            
            if (parameters.getRecurrence().getCount() != null) {
                ((ObjectNode) recurrenceValue).put("count", parameters.getRecurrence().getCount());
            }
            
            if (parameters.getRecurrence().getEndTime() != null) {
                SimpleDateFormat simpleDateFormat12 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                simpleDateFormat12.setTimeZone(TimeZone.getTimeZone("UTC"));
                ((ObjectNode) recurrenceValue).put("endTime", simpleDateFormat12.format(parameters.getRecurrence().getEndTime().getTime()));
            }
            
            if (parameters.getRecurrence().getSchedule() != null) {
                ObjectNode scheduleValue = objectMapper.createObjectNode();
                ((ObjectNode) recurrenceValue).put("schedule", scheduleValue);
                
                if (parameters.getRecurrence().getSchedule().getMinutes() != null) {
                    ArrayNode minutesArray = objectMapper.createArrayNode();
                    for (int minutesItem : parameters.getRecurrence().getSchedule().getMinutes()) {
                        minutesArray.add(minutesItem);
                    }
                    ((ObjectNode) scheduleValue).put("minutes", minutesArray);
                }
                
                if (parameters.getRecurrence().getSchedule().getHours() != null) {
                    ArrayNode hoursArray = objectMapper.createArrayNode();
                    for (int hoursItem : parameters.getRecurrence().getSchedule().getHours()) {
                        hoursArray.add(hoursItem);
                    }
                    ((ObjectNode) scheduleValue).put("hours", hoursArray);
                }
                
                if (parameters.getRecurrence().getSchedule().getDays() != null) {
                    ArrayNode weekDaysArray = objectMapper.createArrayNode();
                    for (JobScheduleDay weekDaysItem : parameters.getRecurrence().getSchedule().getDays()) {
                        weekDaysArray.add(SchedulerClientImpl.jobScheduleDayToString(weekDaysItem));
                    }
                    ((ObjectNode) scheduleValue).put("weekDays", weekDaysArray);
                }
                
                if (parameters.getRecurrence().getSchedule().getMonths() != null) {
                    ArrayNode monthsArray = objectMapper.createArrayNode();
                    for (int monthsItem : parameters.getRecurrence().getSchedule().getMonths()) {
                        monthsArray.add(monthsItem);
                    }
                    ((ObjectNode) scheduleValue).put("months", monthsArray);
                }
                
                if (parameters.getRecurrence().getSchedule().getMonthDays() != null) {
                    ArrayNode monthDaysArray = objectMapper.createArrayNode();
                    for (int monthDaysItem : parameters.getRecurrence().getSchedule().getMonthDays()) {
                        monthDaysArray.add(monthDaysItem);
                    }
                    ((ObjectNode) scheduleValue).put("monthDays", monthDaysArray);
                }
                
                if (parameters.getRecurrence().getSchedule().getMonthlyOccurrences() != null) {
                    ArrayNode monthlyOccurrencesArray = objectMapper.createArrayNode();
                    for (JobScheduleMonthlyOccurrence monthlyOccurrencesItem : parameters.getRecurrence().getSchedule().getMonthlyOccurrences()) {
                        ObjectNode jobScheduleMonthlyOccurrenceValue = objectMapper.createObjectNode();
                        monthlyOccurrencesArray.add(jobScheduleMonthlyOccurrenceValue);
                        
                        ((ObjectNode) jobScheduleMonthlyOccurrenceValue).put("day", SchedulerClientImpl.jobScheduleDayToString(monthlyOccurrencesItem.getDay()));
                        
                        if (monthlyOccurrencesItem.getOccurrence() != null) {
                            ((ObjectNode) jobScheduleMonthlyOccurrenceValue).put("occurrence", monthlyOccurrencesItem.getOccurrence());
                        }
                    }
                    ((ObjectNode) scheduleValue).put("monthlyOccurrences", monthlyOccurrencesArray);
                }
            }
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            JobCreateOrUpdateResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new JobCreateOrUpdateResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    Job jobInstance = new Job();
                    result.setJob(jobInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        jobInstance.setId(idInstance);
                    }
                    
                    JsonNode startTimeValue = responseDoc.get("startTime");
                    if (startTimeValue != null && startTimeValue instanceof NullNode == false) {
                        Calendar startTimeInstance;
                        startTimeInstance = DatatypeConverter.parseDateTime(startTimeValue.getTextValue());
                        jobInstance.setStartTime(startTimeInstance);
                    }
                    
                    JsonNode actionValue2 = responseDoc.get("action");
                    if (actionValue2 != null && actionValue2 instanceof NullNode == false) {
                        JobAction actionInstance = new JobAction();
                        jobInstance.setAction(actionInstance);
                        
                        JsonNode typeValue = actionValue2.get("type");
                        if (typeValue != null && typeValue instanceof NullNode == false) {
                            JobActionType typeInstance;
                            typeInstance = SchedulerClientImpl.parseJobActionType(typeValue.getTextValue());
                            actionInstance.setType(typeInstance);
                        }
                        
                        JsonNode retryPolicyValue2 = actionValue2.get("retryPolicy");
                        if (retryPolicyValue2 != null && retryPolicyValue2 instanceof NullNode == false) {
                            RetryPolicy retryPolicyInstance = new RetryPolicy();
                            actionInstance.setRetryPolicy(retryPolicyInstance);
                            
                            JsonNode retryTypeValue = retryPolicyValue2.get("retryType");
                            if (retryTypeValue != null && retryTypeValue instanceof NullNode == false) {
                                RetryType retryTypeInstance;
                                retryTypeInstance = SchedulerClientImpl.parseRetryType(retryTypeValue.getTextValue());
                                retryPolicyInstance.setRetryType(retryTypeInstance);
                            }
                            
                            JsonNode retryIntervalValue = retryPolicyValue2.get("retryInterval");
                            if (retryIntervalValue != null && retryIntervalValue instanceof NullNode == false) {
                                Duration retryIntervalInstance;
                                retryIntervalInstance = TimeSpan8601Converter.parse(retryIntervalValue.getTextValue());
                                retryPolicyInstance.setRetryInterval(retryIntervalInstance);
                            }
                            
                            JsonNode retryCountValue = retryPolicyValue2.get("retryCount");
                            if (retryCountValue != null && retryCountValue instanceof NullNode == false) {
                                int retryCountInstance;
                                retryCountInstance = retryCountValue.getIntValue();
                                retryPolicyInstance.setRetryCount(retryCountInstance);
                            }
                        }
                        
                        JsonNode errorActionValue2 = actionValue2.get("errorAction");
                        if (errorActionValue2 != null && errorActionValue2 instanceof NullNode == false) {
                            JobErrorAction errorActionInstance = new JobErrorAction();
                            actionInstance.setErrorAction(errorActionInstance);
                            
                            JsonNode typeValue2 = errorActionValue2.get("type");
                            if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                JobActionType typeInstance2;
                                typeInstance2 = SchedulerClientImpl.parseJobActionType(typeValue2.getTextValue());
                                errorActionInstance.setType(typeInstance2);
                            }
                            
                            JsonNode requestValue3 = errorActionValue2.get("request");
                            if (requestValue3 != null && requestValue3 instanceof NullNode == false) {
                                JobHttpRequest requestInstance = new JobHttpRequest();
                                errorActionInstance.setRequest(requestInstance);
                                
                                JsonNode uriValue = requestValue3.get("uri");
                                if (uriValue != null && uriValue instanceof NullNode == false) {
                                    URI uriInstance;
                                    uriInstance = new URI(uriValue.getTextValue());
                                    requestInstance.setUri(uriInstance);
                                }
                                
                                JsonNode methodValue = requestValue3.get("method");
                                if (methodValue != null && methodValue instanceof NullNode == false) {
                                    String methodInstance;
                                    methodInstance = methodValue.getTextValue();
                                    requestInstance.setMethod(methodInstance);
                                }
                                
                                JsonNode headersSequenceElement = ((JsonNode) requestValue3.get("headers"));
                                if (headersSequenceElement != null && headersSequenceElement instanceof NullNode == false) {
                                    Iterator<Map.Entry<String, JsonNode>> itr = headersSequenceElement.getFields();
                                    while (itr.hasNext()) {
                                        Map.Entry<String, JsonNode> property = itr.next();
                                        String headersKey3 = property.getKey();
                                        String headersValue3 = property.getValue().getTextValue();
                                        requestInstance.getHeaders().put(headersKey3, headersValue3);
                                    }
                                }
                                
                                JsonNode bodyValue = requestValue3.get("body");
                                if (bodyValue != null && bodyValue instanceof NullNode == false) {
                                    String bodyInstance;
                                    bodyInstance = bodyValue.getTextValue();
                                    requestInstance.setBody(bodyInstance);
                                }
                                
                                JsonNode authenticationValue7 = requestValue3.get("authentication");
                                if (authenticationValue7 != null && authenticationValue7 instanceof NullNode == false) {
                                    String typeName = authenticationValue7.get("type").getTextValue();
                                    if ("ClientCertificate".equals(typeName)) {
                                        ClientCertAuthentication clientCertAuthenticationInstance = new ClientCertAuthentication();
                                        
                                        JsonNode passwordValue = authenticationValue7.get("password");
                                        if (passwordValue != null && passwordValue instanceof NullNode == false) {
                                            String passwordInstance;
                                            passwordInstance = passwordValue.getTextValue();
                                            clientCertAuthenticationInstance.setPassword(passwordInstance);
                                        }
                                        
                                        JsonNode pfxValue = authenticationValue7.get("pfx");
                                        if (pfxValue != null && pfxValue instanceof NullNode == false) {
                                            String pfxInstance;
                                            pfxInstance = pfxValue.getTextValue();
                                            clientCertAuthenticationInstance.setPfx(pfxInstance);
                                        }
                                        
                                        JsonNode certificateThumbprintValue = authenticationValue7.get("certificateThumbprint");
                                        if (certificateThumbprintValue != null && certificateThumbprintValue instanceof NullNode == false) {
                                            String certificateThumbprintInstance;
                                            certificateThumbprintInstance = certificateThumbprintValue.getTextValue();
                                            clientCertAuthenticationInstance.setCertificateThumbprint(certificateThumbprintInstance);
                                        }
                                        
                                        JsonNode certificateExpirationValue = authenticationValue7.get("certificateExpiration");
                                        if (certificateExpirationValue != null && certificateExpirationValue instanceof NullNode == false) {
                                            Calendar certificateExpirationInstance;
                                            certificateExpirationInstance = DatatypeConverter.parseDateTime(certificateExpirationValue.getTextValue());
                                            clientCertAuthenticationInstance.setCertificateExpiration(certificateExpirationInstance);
                                        }
                                        
                                        JsonNode certificateSubjectNameValue = authenticationValue7.get("certificateSubjectName");
                                        if (certificateSubjectNameValue != null && certificateSubjectNameValue instanceof NullNode == false) {
                                            String certificateSubjectNameInstance;
                                            certificateSubjectNameInstance = certificateSubjectNameValue.getTextValue();
                                            clientCertAuthenticationInstance.setCertificateSubjectName(certificateSubjectNameInstance);
                                        }
                                        
                                        JsonNode typeValue3 = authenticationValue7.get("type");
                                        if (typeValue3 != null && typeValue3 instanceof NullNode == false) {
                                            HttpAuthenticationType typeInstance3;
                                            typeInstance3 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue3.getTextValue());
                                            clientCertAuthenticationInstance.setType(typeInstance3);
                                        }
                                        requestInstance.setAuthentication(clientCertAuthenticationInstance);
                                    }
                                    if ("ActiveDirectoryOAuth".equals(typeName)) {
                                        AADOAuthAuthentication aADOAuthAuthenticationInstance = new AADOAuthAuthentication();
                                        
                                        JsonNode secretValue = authenticationValue7.get("secret");
                                        if (secretValue != null && secretValue instanceof NullNode == false) {
                                            String secretInstance;
                                            secretInstance = secretValue.getTextValue();
                                            aADOAuthAuthenticationInstance.setSecret(secretInstance);
                                        }
                                        
                                        JsonNode tenantValue = authenticationValue7.get("tenant");
                                        if (tenantValue != null && tenantValue instanceof NullNode == false) {
                                            String tenantInstance;
                                            tenantInstance = tenantValue.getTextValue();
                                            aADOAuthAuthenticationInstance.setTenant(tenantInstance);
                                        }
                                        
                                        JsonNode audienceValue = authenticationValue7.get("audience");
                                        if (audienceValue != null && audienceValue instanceof NullNode == false) {
                                            String audienceInstance;
                                            audienceInstance = audienceValue.getTextValue();
                                            aADOAuthAuthenticationInstance.setAudience(audienceInstance);
                                        }
                                        
                                        JsonNode clientIdValue = authenticationValue7.get("clientId");
                                        if (clientIdValue != null && clientIdValue instanceof NullNode == false) {
                                            String clientIdInstance;
                                            clientIdInstance = clientIdValue.getTextValue();
                                            aADOAuthAuthenticationInstance.setClientId(clientIdInstance);
                                        }
                                        
                                        JsonNode typeValue4 = authenticationValue7.get("type");
                                        if (typeValue4 != null && typeValue4 instanceof NullNode == false) {
                                            HttpAuthenticationType typeInstance4;
                                            typeInstance4 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue4.getTextValue());
                                            aADOAuthAuthenticationInstance.setType(typeInstance4);
                                        }
                                        requestInstance.setAuthentication(aADOAuthAuthenticationInstance);
                                    }
                                    if ("Basic".equals(typeName)) {
                                        BasicAuthentication basicAuthenticationInstance = new BasicAuthentication();
                                        
                                        JsonNode usernameValue = authenticationValue7.get("username");
                                        if (usernameValue != null && usernameValue instanceof NullNode == false) {
                                            String usernameInstance;
                                            usernameInstance = usernameValue.getTextValue();
                                            basicAuthenticationInstance.setUsername(usernameInstance);
                                        }
                                        
                                        JsonNode passwordValue2 = authenticationValue7.get("password");
                                        if (passwordValue2 != null && passwordValue2 instanceof NullNode == false) {
                                            String passwordInstance2;
                                            passwordInstance2 = passwordValue2.getTextValue();
                                            basicAuthenticationInstance.setPassword(passwordInstance2);
                                        }
                                        
                                        JsonNode typeValue5 = authenticationValue7.get("type");
                                        if (typeValue5 != null && typeValue5 instanceof NullNode == false) {
                                            HttpAuthenticationType typeInstance5;
                                            typeInstance5 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue5.getTextValue());
                                            basicAuthenticationInstance.setType(typeInstance5);
                                        }
                                        requestInstance.setAuthentication(basicAuthenticationInstance);
                                    }
                                }
                            }
                            
                            JsonNode queueMessageValue3 = errorActionValue2.get("queueMessage");
                            if (queueMessageValue3 != null && queueMessageValue3 instanceof NullNode == false) {
                                JobQueueMessage queueMessageInstance = new JobQueueMessage();
                                errorActionInstance.setQueueMessage(queueMessageInstance);
                                
                                JsonNode storageAccountValue = queueMessageValue3.get("storageAccount");
                                if (storageAccountValue != null && storageAccountValue instanceof NullNode == false) {
                                    String storageAccountInstance;
                                    storageAccountInstance = storageAccountValue.getTextValue();
                                    queueMessageInstance.setStorageAccountName(storageAccountInstance);
                                }
                                
                                JsonNode queueNameValue = queueMessageValue3.get("queueName");
                                if (queueNameValue != null && queueNameValue instanceof NullNode == false) {
                                    String queueNameInstance;
                                    queueNameInstance = queueNameValue.getTextValue();
                                    queueMessageInstance.setQueueName(queueNameInstance);
                                }
                                
                                JsonNode sasTokenValue = queueMessageValue3.get("sasToken");
                                if (sasTokenValue != null && sasTokenValue instanceof NullNode == false) {
                                    String sasTokenInstance;
                                    sasTokenInstance = sasTokenValue.getTextValue();
                                    queueMessageInstance.setSasToken(sasTokenInstance);
                                }
                                
                                JsonNode messageValue = queueMessageValue3.get("message");
                                if (messageValue != null && messageValue instanceof NullNode == false) {
                                    String messageInstance;
                                    messageInstance = messageValue.getTextValue();
                                    queueMessageInstance.setMessage(messageInstance);
                                }
                            }
                            
                            JsonNode serviceBusTopicMessageValue3 = errorActionValue2.get("serviceBusTopicMessage");
                            if (serviceBusTopicMessageValue3 != null && serviceBusTopicMessageValue3 instanceof NullNode == false) {
                                JobServiceBusTopicMessage serviceBusTopicMessageInstance = new JobServiceBusTopicMessage();
                                errorActionInstance.setServiceBusTopicMessage(serviceBusTopicMessageInstance);
                                
                                JsonNode topicPathValue = serviceBusTopicMessageValue3.get("topicPath");
                                if (topicPathValue != null && topicPathValue instanceof NullNode == false) {
                                    String topicPathInstance;
                                    topicPathInstance = topicPathValue.getTextValue();
                                    serviceBusTopicMessageInstance.setTopicPath(topicPathInstance);
                                }
                                
                                JsonNode namespaceValue = serviceBusTopicMessageValue3.get("namespace");
                                if (namespaceValue != null && namespaceValue instanceof NullNode == false) {
                                    String namespaceInstance;
                                    namespaceInstance = namespaceValue.getTextValue();
                                    serviceBusTopicMessageInstance.setNamespace(namespaceInstance);
                                }
                                
                                JsonNode transportTypeValue = serviceBusTopicMessageValue3.get("transportType");
                                if (transportTypeValue != null && transportTypeValue instanceof NullNode == false) {
                                    JobServiceBusTransportType transportTypeInstance;
                                    transportTypeInstance = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue.getTextValue());
                                    serviceBusTopicMessageInstance.setTransportType(transportTypeInstance);
                                }
                                
                                JsonNode authenticationValue8 = serviceBusTopicMessageValue3.get("authentication");
                                if (authenticationValue8 != null && authenticationValue8 instanceof NullNode == false) {
                                    JobServiceBusAuthentication authenticationInstance = new JobServiceBusAuthentication();
                                    serviceBusTopicMessageInstance.setAuthentication(authenticationInstance);
                                    
                                    JsonNode sasKeyNameValue = authenticationValue8.get("sasKeyName");
                                    if (sasKeyNameValue != null && sasKeyNameValue instanceof NullNode == false) {
                                        String sasKeyNameInstance;
                                        sasKeyNameInstance = sasKeyNameValue.getTextValue();
                                        authenticationInstance.setSasKeyName(sasKeyNameInstance);
                                    }
                                    
                                    JsonNode sasKeyValue = authenticationValue8.get("sasKey");
                                    if (sasKeyValue != null && sasKeyValue instanceof NullNode == false) {
                                        String sasKeyInstance;
                                        sasKeyInstance = sasKeyValue.getTextValue();
                                        authenticationInstance.setSasKey(sasKeyInstance);
                                    }
                                    
                                    JsonNode typeValue6 = authenticationValue8.get("type");
                                    if (typeValue6 != null && typeValue6 instanceof NullNode == false) {
                                        JobServiceBusAuthenticationType typeInstance6;
                                        typeInstance6 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue6.getTextValue());
                                        authenticationInstance.setType(typeInstance6);
                                    }
                                }
                                
                                JsonNode messageValue2 = serviceBusTopicMessageValue3.get("message");
                                if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                    String messageInstance2;
                                    messageInstance2 = messageValue2.getTextValue();
                                    serviceBusTopicMessageInstance.setMessage(messageInstance2);
                                }
                                
                                JsonNode brokeredMessagePropertiesValue5 = serviceBusTopicMessageValue3.get("brokeredMessageProperties");
                                if (brokeredMessagePropertiesValue5 != null && brokeredMessagePropertiesValue5 instanceof NullNode == false) {
                                    JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance = new JobServiceBusBrokeredMessageProperties();
                                    serviceBusTopicMessageInstance.setBrokeredMessageProperties(brokeredMessagePropertiesInstance);
                                    
                                    JsonNode contentTypeValue = brokeredMessagePropertiesValue5.get("contentType");
                                    if (contentTypeValue != null && contentTypeValue instanceof NullNode == false) {
                                        String contentTypeInstance;
                                        contentTypeInstance = contentTypeValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setContentType(contentTypeInstance);
                                    }
                                    
                                    JsonNode correlationIdValue = brokeredMessagePropertiesValue5.get("correlationId");
                                    if (correlationIdValue != null && correlationIdValue instanceof NullNode == false) {
                                        String correlationIdInstance;
                                        correlationIdInstance = correlationIdValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setCorrelationId(correlationIdInstance);
                                    }
                                    
                                    JsonNode forcePersistenceValue = brokeredMessagePropertiesValue5.get("forcePersistence");
                                    if (forcePersistenceValue != null && forcePersistenceValue instanceof NullNode == false) {
                                        boolean forcePersistenceInstance;
                                        forcePersistenceInstance = forcePersistenceValue.getBooleanValue();
                                        brokeredMessagePropertiesInstance.setForcePersistence(forcePersistenceInstance);
                                    }
                                    
                                    JsonNode labelValue = brokeredMessagePropertiesValue5.get("label");
                                    if (labelValue != null && labelValue instanceof NullNode == false) {
                                        String labelInstance;
                                        labelInstance = labelValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setLabel(labelInstance);
                                    }
                                    
                                    JsonNode messageIdValue = brokeredMessagePropertiesValue5.get("messageId");
                                    if (messageIdValue != null && messageIdValue instanceof NullNode == false) {
                                        String messageIdInstance;
                                        messageIdInstance = messageIdValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setMessageId(messageIdInstance);
                                    }
                                    
                                    JsonNode partitionKeyValue = brokeredMessagePropertiesValue5.get("partitionKey");
                                    if (partitionKeyValue != null && partitionKeyValue instanceof NullNode == false) {
                                        String partitionKeyInstance;
                                        partitionKeyInstance = partitionKeyValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setPartitionKey(partitionKeyInstance);
                                    }
                                    
                                    JsonNode replyToValue = brokeredMessagePropertiesValue5.get("replyTo");
                                    if (replyToValue != null && replyToValue instanceof NullNode == false) {
                                        String replyToInstance;
                                        replyToInstance = replyToValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setReplyTo(replyToInstance);
                                    }
                                    
                                    JsonNode replyToSessionIdValue = brokeredMessagePropertiesValue5.get("replyToSessionId");
                                    if (replyToSessionIdValue != null && replyToSessionIdValue instanceof NullNode == false) {
                                        String replyToSessionIdInstance;
                                        replyToSessionIdInstance = replyToSessionIdValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setReplyToSessionId(replyToSessionIdInstance);
                                    }
                                    
                                    JsonNode scheduledEnqueueTimeUtcValue = brokeredMessagePropertiesValue5.get("scheduledEnqueueTimeUtc");
                                    if (scheduledEnqueueTimeUtcValue != null && scheduledEnqueueTimeUtcValue instanceof NullNode == false) {
                                        Calendar scheduledEnqueueTimeUtcInstance;
                                        scheduledEnqueueTimeUtcInstance = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue.getTextValue());
                                        brokeredMessagePropertiesInstance.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance);
                                    }
                                    
                                    JsonNode sessionIdValue = brokeredMessagePropertiesValue5.get("sessionId");
                                    if (sessionIdValue != null && sessionIdValue instanceof NullNode == false) {
                                        String sessionIdInstance;
                                        sessionIdInstance = sessionIdValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setSessionId(sessionIdInstance);
                                    }
                                    
                                    JsonNode timeToLiveValue = brokeredMessagePropertiesValue5.get("timeToLive");
                                    if (timeToLiveValue != null && timeToLiveValue instanceof NullNode == false) {
                                        Calendar timeToLiveInstance;
                                        timeToLiveInstance = DatatypeConverter.parseDateTime(timeToLiveValue.getTextValue());
                                        brokeredMessagePropertiesInstance.setTimeToLive(timeToLiveInstance);
                                    }
                                    
                                    JsonNode toValue = brokeredMessagePropertiesValue5.get("to");
                                    if (toValue != null && toValue instanceof NullNode == false) {
                                        String toInstance;
                                        toInstance = toValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setTo(toInstance);
                                    }
                                    
                                    JsonNode viaPartitionKeyValue = brokeredMessagePropertiesValue5.get("viaPartitionKey");
                                    if (viaPartitionKeyValue != null && viaPartitionKeyValue instanceof NullNode == false) {
                                        String viaPartitionKeyInstance;
                                        viaPartitionKeyInstance = viaPartitionKeyValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setViaPartitionKey(viaPartitionKeyInstance);
                                    }
                                }
                                
                                JsonNode customMessagePropertiesSequenceElement = ((JsonNode) serviceBusTopicMessageValue3.get("customMessageProperties"));
                                if (customMessagePropertiesSequenceElement != null && customMessagePropertiesSequenceElement instanceof NullNode == false) {
                                    Iterator<Map.Entry<String, JsonNode>> itr2 = customMessagePropertiesSequenceElement.getFields();
                                    while (itr2.hasNext()) {
                                        Map.Entry<String, JsonNode> property2 = itr2.next();
                                        String customMessagePropertiesKey5 = property2.getKey();
                                        String customMessagePropertiesValue5 = property2.getValue().getTextValue();
                                        serviceBusTopicMessageInstance.getCustomMessageProperties().put(customMessagePropertiesKey5, customMessagePropertiesValue5);
                                    }
                                }
                            }
                            
                            JsonNode serviceBusQueueMessageValue3 = errorActionValue2.get("serviceBusQueueMessage");
                            if (serviceBusQueueMessageValue3 != null && serviceBusQueueMessageValue3 instanceof NullNode == false) {
                                JobServiceBusQueueMessage serviceBusQueueMessageInstance = new JobServiceBusQueueMessage();
                                errorActionInstance.setServiceBusQueueMessage(serviceBusQueueMessageInstance);
                                
                                JsonNode queueNameValue2 = serviceBusQueueMessageValue3.get("queueName");
                                if (queueNameValue2 != null && queueNameValue2 instanceof NullNode == false) {
                                    String queueNameInstance2;
                                    queueNameInstance2 = queueNameValue2.getTextValue();
                                    serviceBusQueueMessageInstance.setQueueName(queueNameInstance2);
                                }
                                
                                JsonNode namespaceValue2 = serviceBusQueueMessageValue3.get("namespace");
                                if (namespaceValue2 != null && namespaceValue2 instanceof NullNode == false) {
                                    String namespaceInstance2;
                                    namespaceInstance2 = namespaceValue2.getTextValue();
                                    serviceBusQueueMessageInstance.setNamespace(namespaceInstance2);
                                }
                                
                                JsonNode transportTypeValue2 = serviceBusQueueMessageValue3.get("transportType");
                                if (transportTypeValue2 != null && transportTypeValue2 instanceof NullNode == false) {
                                    JobServiceBusTransportType transportTypeInstance2;
                                    transportTypeInstance2 = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue2.getTextValue());
                                    serviceBusQueueMessageInstance.setTransportType(transportTypeInstance2);
                                }
                                
                                JsonNode authenticationValue9 = serviceBusQueueMessageValue3.get("authentication");
                                if (authenticationValue9 != null && authenticationValue9 instanceof NullNode == false) {
                                    JobServiceBusAuthentication authenticationInstance2 = new JobServiceBusAuthentication();
                                    serviceBusQueueMessageInstance.setAuthentication(authenticationInstance2);
                                    
                                    JsonNode sasKeyNameValue2 = authenticationValue9.get("sasKeyName");
                                    if (sasKeyNameValue2 != null && sasKeyNameValue2 instanceof NullNode == false) {
                                        String sasKeyNameInstance2;
                                        sasKeyNameInstance2 = sasKeyNameValue2.getTextValue();
                                        authenticationInstance2.setSasKeyName(sasKeyNameInstance2);
                                    }
                                    
                                    JsonNode sasKeyValue2 = authenticationValue9.get("sasKey");
                                    if (sasKeyValue2 != null && sasKeyValue2 instanceof NullNode == false) {
                                        String sasKeyInstance2;
                                        sasKeyInstance2 = sasKeyValue2.getTextValue();
                                        authenticationInstance2.setSasKey(sasKeyInstance2);
                                    }
                                    
                                    JsonNode typeValue7 = authenticationValue9.get("type");
                                    if (typeValue7 != null && typeValue7 instanceof NullNode == false) {
                                        JobServiceBusAuthenticationType typeInstance7;
                                        typeInstance7 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue7.getTextValue());
                                        authenticationInstance2.setType(typeInstance7);
                                    }
                                }
                                
                                JsonNode messageValue3 = serviceBusQueueMessageValue3.get("message");
                                if (messageValue3 != null && messageValue3 instanceof NullNode == false) {
                                    String messageInstance3;
                                    messageInstance3 = messageValue3.getTextValue();
                                    serviceBusQueueMessageInstance.setMessage(messageInstance3);
                                }
                                
                                JsonNode brokeredMessagePropertiesValue6 = serviceBusQueueMessageValue3.get("brokeredMessageProperties");
                                if (brokeredMessagePropertiesValue6 != null && brokeredMessagePropertiesValue6 instanceof NullNode == false) {
                                    JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance2 = new JobServiceBusBrokeredMessageProperties();
                                    serviceBusQueueMessageInstance.setBrokeredMessageProperties(brokeredMessagePropertiesInstance2);
                                    
                                    JsonNode contentTypeValue2 = brokeredMessagePropertiesValue6.get("contentType");
                                    if (contentTypeValue2 != null && contentTypeValue2 instanceof NullNode == false) {
                                        String contentTypeInstance2;
                                        contentTypeInstance2 = contentTypeValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setContentType(contentTypeInstance2);
                                    }
                                    
                                    JsonNode correlationIdValue2 = brokeredMessagePropertiesValue6.get("correlationId");
                                    if (correlationIdValue2 != null && correlationIdValue2 instanceof NullNode == false) {
                                        String correlationIdInstance2;
                                        correlationIdInstance2 = correlationIdValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setCorrelationId(correlationIdInstance2);
                                    }
                                    
                                    JsonNode forcePersistenceValue2 = brokeredMessagePropertiesValue6.get("forcePersistence");
                                    if (forcePersistenceValue2 != null && forcePersistenceValue2 instanceof NullNode == false) {
                                        boolean forcePersistenceInstance2;
                                        forcePersistenceInstance2 = forcePersistenceValue2.getBooleanValue();
                                        brokeredMessagePropertiesInstance2.setForcePersistence(forcePersistenceInstance2);
                                    }
                                    
                                    JsonNode labelValue2 = brokeredMessagePropertiesValue6.get("label");
                                    if (labelValue2 != null && labelValue2 instanceof NullNode == false) {
                                        String labelInstance2;
                                        labelInstance2 = labelValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setLabel(labelInstance2);
                                    }
                                    
                                    JsonNode messageIdValue2 = brokeredMessagePropertiesValue6.get("messageId");
                                    if (messageIdValue2 != null && messageIdValue2 instanceof NullNode == false) {
                                        String messageIdInstance2;
                                        messageIdInstance2 = messageIdValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setMessageId(messageIdInstance2);
                                    }
                                    
                                    JsonNode partitionKeyValue2 = brokeredMessagePropertiesValue6.get("partitionKey");
                                    if (partitionKeyValue2 != null && partitionKeyValue2 instanceof NullNode == false) {
                                        String partitionKeyInstance2;
                                        partitionKeyInstance2 = partitionKeyValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setPartitionKey(partitionKeyInstance2);
                                    }
                                    
                                    JsonNode replyToValue2 = brokeredMessagePropertiesValue6.get("replyTo");
                                    if (replyToValue2 != null && replyToValue2 instanceof NullNode == false) {
                                        String replyToInstance2;
                                        replyToInstance2 = replyToValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setReplyTo(replyToInstance2);
                                    }
                                    
                                    JsonNode replyToSessionIdValue2 = brokeredMessagePropertiesValue6.get("replyToSessionId");
                                    if (replyToSessionIdValue2 != null && replyToSessionIdValue2 instanceof NullNode == false) {
                                        String replyToSessionIdInstance2;
                                        replyToSessionIdInstance2 = replyToSessionIdValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setReplyToSessionId(replyToSessionIdInstance2);
                                    }
                                    
                                    JsonNode scheduledEnqueueTimeUtcValue2 = brokeredMessagePropertiesValue6.get("scheduledEnqueueTimeUtc");
                                    if (scheduledEnqueueTimeUtcValue2 != null && scheduledEnqueueTimeUtcValue2 instanceof NullNode == false) {
                                        Calendar scheduledEnqueueTimeUtcInstance2;
                                        scheduledEnqueueTimeUtcInstance2 = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue2.getTextValue());
                                        brokeredMessagePropertiesInstance2.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance2);
                                    }
                                    
                                    JsonNode sessionIdValue2 = brokeredMessagePropertiesValue6.get("sessionId");
                                    if (sessionIdValue2 != null && sessionIdValue2 instanceof NullNode == false) {
                                        String sessionIdInstance2;
                                        sessionIdInstance2 = sessionIdValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setSessionId(sessionIdInstance2);
                                    }
                                    
                                    JsonNode timeToLiveValue2 = brokeredMessagePropertiesValue6.get("timeToLive");
                                    if (timeToLiveValue2 != null && timeToLiveValue2 instanceof NullNode == false) {
                                        Calendar timeToLiveInstance2;
                                        timeToLiveInstance2 = DatatypeConverter.parseDateTime(timeToLiveValue2.getTextValue());
                                        brokeredMessagePropertiesInstance2.setTimeToLive(timeToLiveInstance2);
                                    }
                                    
                                    JsonNode toValue2 = brokeredMessagePropertiesValue6.get("to");
                                    if (toValue2 != null && toValue2 instanceof NullNode == false) {
                                        String toInstance2;
                                        toInstance2 = toValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setTo(toInstance2);
                                    }
                                    
                                    JsonNode viaPartitionKeyValue2 = brokeredMessagePropertiesValue6.get("viaPartitionKey");
                                    if (viaPartitionKeyValue2 != null && viaPartitionKeyValue2 instanceof NullNode == false) {
                                        String viaPartitionKeyInstance2;
                                        viaPartitionKeyInstance2 = viaPartitionKeyValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setViaPartitionKey(viaPartitionKeyInstance2);
                                    }
                                }
                                
                                JsonNode customMessagePropertiesSequenceElement2 = ((JsonNode) serviceBusQueueMessageValue3.get("customMessageProperties"));
                                if (customMessagePropertiesSequenceElement2 != null && customMessagePropertiesSequenceElement2 instanceof NullNode == false) {
                                    Iterator<Map.Entry<String, JsonNode>> itr3 = customMessagePropertiesSequenceElement2.getFields();
                                    while (itr3.hasNext()) {
                                        Map.Entry<String, JsonNode> property3 = itr3.next();
                                        String customMessagePropertiesKey6 = property3.getKey();
                                        String customMessagePropertiesValue6 = property3.getValue().getTextValue();
                                        serviceBusQueueMessageInstance.getCustomMessageProperties().put(customMessagePropertiesKey6, customMessagePropertiesValue6);
                                    }
                                }
                            }
                        }
                        
                        JsonNode requestValue4 = actionValue2.get("request");
                        if (requestValue4 != null && requestValue4 instanceof NullNode == false) {
                            JobHttpRequest requestInstance2 = new JobHttpRequest();
                            actionInstance.setRequest(requestInstance2);
                            
                            JsonNode uriValue2 = requestValue4.get("uri");
                            if (uriValue2 != null && uriValue2 instanceof NullNode == false) {
                                URI uriInstance2;
                                uriInstance2 = new URI(uriValue2.getTextValue());
                                requestInstance2.setUri(uriInstance2);
                            }
                            
                            JsonNode methodValue2 = requestValue4.get("method");
                            if (methodValue2 != null && methodValue2 instanceof NullNode == false) {
                                String methodInstance2;
                                methodInstance2 = methodValue2.getTextValue();
                                requestInstance2.setMethod(methodInstance2);
                            }
                            
                            JsonNode headersSequenceElement2 = ((JsonNode) requestValue4.get("headers"));
                            if (headersSequenceElement2 != null && headersSequenceElement2 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr4 = headersSequenceElement2.getFields();
                                while (itr4.hasNext()) {
                                    Map.Entry<String, JsonNode> property4 = itr4.next();
                                    String headersKey4 = property4.getKey();
                                    String headersValue4 = property4.getValue().getTextValue();
                                    requestInstance2.getHeaders().put(headersKey4, headersValue4);
                                }
                            }
                            
                            JsonNode bodyValue2 = requestValue4.get("body");
                            if (bodyValue2 != null && bodyValue2 instanceof NullNode == false) {
                                String bodyInstance2;
                                bodyInstance2 = bodyValue2.getTextValue();
                                requestInstance2.setBody(bodyInstance2);
                            }
                            
                            JsonNode authenticationValue10 = requestValue4.get("authentication");
                            if (authenticationValue10 != null && authenticationValue10 instanceof NullNode == false) {
                                String typeName2 = authenticationValue10.get("type").getTextValue();
                                if ("ClientCertificate".equals(typeName2)) {
                                    ClientCertAuthentication clientCertAuthenticationInstance2 = new ClientCertAuthentication();
                                    
                                    JsonNode passwordValue3 = authenticationValue10.get("password");
                                    if (passwordValue3 != null && passwordValue3 instanceof NullNode == false) {
                                        String passwordInstance3;
                                        passwordInstance3 = passwordValue3.getTextValue();
                                        clientCertAuthenticationInstance2.setPassword(passwordInstance3);
                                    }
                                    
                                    JsonNode pfxValue2 = authenticationValue10.get("pfx");
                                    if (pfxValue2 != null && pfxValue2 instanceof NullNode == false) {
                                        String pfxInstance2;
                                        pfxInstance2 = pfxValue2.getTextValue();
                                        clientCertAuthenticationInstance2.setPfx(pfxInstance2);
                                    }
                                    
                                    JsonNode certificateThumbprintValue2 = authenticationValue10.get("certificateThumbprint");
                                    if (certificateThumbprintValue2 != null && certificateThumbprintValue2 instanceof NullNode == false) {
                                        String certificateThumbprintInstance2;
                                        certificateThumbprintInstance2 = certificateThumbprintValue2.getTextValue();
                                        clientCertAuthenticationInstance2.setCertificateThumbprint(certificateThumbprintInstance2);
                                    }
                                    
                                    JsonNode certificateExpirationValue2 = authenticationValue10.get("certificateExpiration");
                                    if (certificateExpirationValue2 != null && certificateExpirationValue2 instanceof NullNode == false) {
                                        Calendar certificateExpirationInstance2;
                                        certificateExpirationInstance2 = DatatypeConverter.parseDateTime(certificateExpirationValue2.getTextValue());
                                        clientCertAuthenticationInstance2.setCertificateExpiration(certificateExpirationInstance2);
                                    }
                                    
                                    JsonNode certificateSubjectNameValue2 = authenticationValue10.get("certificateSubjectName");
                                    if (certificateSubjectNameValue2 != null && certificateSubjectNameValue2 instanceof NullNode == false) {
                                        String certificateSubjectNameInstance2;
                                        certificateSubjectNameInstance2 = certificateSubjectNameValue2.getTextValue();
                                        clientCertAuthenticationInstance2.setCertificateSubjectName(certificateSubjectNameInstance2);
                                    }
                                    
                                    JsonNode typeValue8 = authenticationValue10.get("type");
                                    if (typeValue8 != null && typeValue8 instanceof NullNode == false) {
                                        HttpAuthenticationType typeInstance8;
                                        typeInstance8 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue8.getTextValue());
                                        clientCertAuthenticationInstance2.setType(typeInstance8);
                                    }
                                    requestInstance2.setAuthentication(clientCertAuthenticationInstance2);
                                }
                                if ("ActiveDirectoryOAuth".equals(typeName2)) {
                                    AADOAuthAuthentication aADOAuthAuthenticationInstance2 = new AADOAuthAuthentication();
                                    
                                    JsonNode secretValue2 = authenticationValue10.get("secret");
                                    if (secretValue2 != null && secretValue2 instanceof NullNode == false) {
                                        String secretInstance2;
                                        secretInstance2 = secretValue2.getTextValue();
                                        aADOAuthAuthenticationInstance2.setSecret(secretInstance2);
                                    }
                                    
                                    JsonNode tenantValue2 = authenticationValue10.get("tenant");
                                    if (tenantValue2 != null && tenantValue2 instanceof NullNode == false) {
                                        String tenantInstance2;
                                        tenantInstance2 = tenantValue2.getTextValue();
                                        aADOAuthAuthenticationInstance2.setTenant(tenantInstance2);
                                    }
                                    
                                    JsonNode audienceValue2 = authenticationValue10.get("audience");
                                    if (audienceValue2 != null && audienceValue2 instanceof NullNode == false) {
                                        String audienceInstance2;
                                        audienceInstance2 = audienceValue2.getTextValue();
                                        aADOAuthAuthenticationInstance2.setAudience(audienceInstance2);
                                    }
                                    
                                    JsonNode clientIdValue2 = authenticationValue10.get("clientId");
                                    if (clientIdValue2 != null && clientIdValue2 instanceof NullNode == false) {
                                        String clientIdInstance2;
                                        clientIdInstance2 = clientIdValue2.getTextValue();
                                        aADOAuthAuthenticationInstance2.setClientId(clientIdInstance2);
                                    }
                                    
                                    JsonNode typeValue9 = authenticationValue10.get("type");
                                    if (typeValue9 != null && typeValue9 instanceof NullNode == false) {
                                        HttpAuthenticationType typeInstance9;
                                        typeInstance9 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue9.getTextValue());
                                        aADOAuthAuthenticationInstance2.setType(typeInstance9);
                                    }
                                    requestInstance2.setAuthentication(aADOAuthAuthenticationInstance2);
                                }
                                if ("Basic".equals(typeName2)) {
                                    BasicAuthentication basicAuthenticationInstance2 = new BasicAuthentication();
                                    
                                    JsonNode usernameValue2 = authenticationValue10.get("username");
                                    if (usernameValue2 != null && usernameValue2 instanceof NullNode == false) {
                                        String usernameInstance2;
                                        usernameInstance2 = usernameValue2.getTextValue();
                                        basicAuthenticationInstance2.setUsername(usernameInstance2);
                                    }
                                    
                                    JsonNode passwordValue4 = authenticationValue10.get("password");
                                    if (passwordValue4 != null && passwordValue4 instanceof NullNode == false) {
                                        String passwordInstance4;
                                        passwordInstance4 = passwordValue4.getTextValue();
                                        basicAuthenticationInstance2.setPassword(passwordInstance4);
                                    }
                                    
                                    JsonNode typeValue10 = authenticationValue10.get("type");
                                    if (typeValue10 != null && typeValue10 instanceof NullNode == false) {
                                        HttpAuthenticationType typeInstance10;
                                        typeInstance10 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue10.getTextValue());
                                        basicAuthenticationInstance2.setType(typeInstance10);
                                    }
                                    requestInstance2.setAuthentication(basicAuthenticationInstance2);
                                }
                            }
                        }
                        
                        JsonNode queueMessageValue4 = actionValue2.get("queueMessage");
                        if (queueMessageValue4 != null && queueMessageValue4 instanceof NullNode == false) {
                            JobQueueMessage queueMessageInstance2 = new JobQueueMessage();
                            actionInstance.setQueueMessage(queueMessageInstance2);
                            
                            JsonNode storageAccountValue2 = queueMessageValue4.get("storageAccount");
                            if (storageAccountValue2 != null && storageAccountValue2 instanceof NullNode == false) {
                                String storageAccountInstance2;
                                storageAccountInstance2 = storageAccountValue2.getTextValue();
                                queueMessageInstance2.setStorageAccountName(storageAccountInstance2);
                            }
                            
                            JsonNode queueNameValue3 = queueMessageValue4.get("queueName");
                            if (queueNameValue3 != null && queueNameValue3 instanceof NullNode == false) {
                                String queueNameInstance3;
                                queueNameInstance3 = queueNameValue3.getTextValue();
                                queueMessageInstance2.setQueueName(queueNameInstance3);
                            }
                            
                            JsonNode sasTokenValue2 = queueMessageValue4.get("sasToken");
                            if (sasTokenValue2 != null && sasTokenValue2 instanceof NullNode == false) {
                                String sasTokenInstance2;
                                sasTokenInstance2 = sasTokenValue2.getTextValue();
                                queueMessageInstance2.setSasToken(sasTokenInstance2);
                            }
                            
                            JsonNode messageValue4 = queueMessageValue4.get("message");
                            if (messageValue4 != null && messageValue4 instanceof NullNode == false) {
                                String messageInstance4;
                                messageInstance4 = messageValue4.getTextValue();
                                queueMessageInstance2.setMessage(messageInstance4);
                            }
                        }
                        
                        JsonNode serviceBusTopicMessageValue4 = actionValue2.get("serviceBusTopicMessage");
                        if (serviceBusTopicMessageValue4 != null && serviceBusTopicMessageValue4 instanceof NullNode == false) {
                            JobServiceBusTopicMessage serviceBusTopicMessageInstance2 = new JobServiceBusTopicMessage();
                            actionInstance.setServiceBusTopicMessage(serviceBusTopicMessageInstance2);
                            
                            JsonNode topicPathValue2 = serviceBusTopicMessageValue4.get("topicPath");
                            if (topicPathValue2 != null && topicPathValue2 instanceof NullNode == false) {
                                String topicPathInstance2;
                                topicPathInstance2 = topicPathValue2.getTextValue();
                                serviceBusTopicMessageInstance2.setTopicPath(topicPathInstance2);
                            }
                            
                            JsonNode namespaceValue3 = serviceBusTopicMessageValue4.get("namespace");
                            if (namespaceValue3 != null && namespaceValue3 instanceof NullNode == false) {
                                String namespaceInstance3;
                                namespaceInstance3 = namespaceValue3.getTextValue();
                                serviceBusTopicMessageInstance2.setNamespace(namespaceInstance3);
                            }
                            
                            JsonNode transportTypeValue3 = serviceBusTopicMessageValue4.get("transportType");
                            if (transportTypeValue3 != null && transportTypeValue3 instanceof NullNode == false) {
                                JobServiceBusTransportType transportTypeInstance3;
                                transportTypeInstance3 = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue3.getTextValue());
                                serviceBusTopicMessageInstance2.setTransportType(transportTypeInstance3);
                            }
                            
                            JsonNode authenticationValue11 = serviceBusTopicMessageValue4.get("authentication");
                            if (authenticationValue11 != null && authenticationValue11 instanceof NullNode == false) {
                                JobServiceBusAuthentication authenticationInstance3 = new JobServiceBusAuthentication();
                                serviceBusTopicMessageInstance2.setAuthentication(authenticationInstance3);
                                
                                JsonNode sasKeyNameValue3 = authenticationValue11.get("sasKeyName");
                                if (sasKeyNameValue3 != null && sasKeyNameValue3 instanceof NullNode == false) {
                                    String sasKeyNameInstance3;
                                    sasKeyNameInstance3 = sasKeyNameValue3.getTextValue();
                                    authenticationInstance3.setSasKeyName(sasKeyNameInstance3);
                                }
                                
                                JsonNode sasKeyValue3 = authenticationValue11.get("sasKey");
                                if (sasKeyValue3 != null && sasKeyValue3 instanceof NullNode == false) {
                                    String sasKeyInstance3;
                                    sasKeyInstance3 = sasKeyValue3.getTextValue();
                                    authenticationInstance3.setSasKey(sasKeyInstance3);
                                }
                                
                                JsonNode typeValue11 = authenticationValue11.get("type");
                                if (typeValue11 != null && typeValue11 instanceof NullNode == false) {
                                    JobServiceBusAuthenticationType typeInstance11;
                                    typeInstance11 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue11.getTextValue());
                                    authenticationInstance3.setType(typeInstance11);
                                }
                            }
                            
                            JsonNode messageValue5 = serviceBusTopicMessageValue4.get("message");
                            if (messageValue5 != null && messageValue5 instanceof NullNode == false) {
                                String messageInstance5;
                                messageInstance5 = messageValue5.getTextValue();
                                serviceBusTopicMessageInstance2.setMessage(messageInstance5);
                            }
                            
                            JsonNode brokeredMessagePropertiesValue7 = serviceBusTopicMessageValue4.get("brokeredMessageProperties");
                            if (brokeredMessagePropertiesValue7 != null && brokeredMessagePropertiesValue7 instanceof NullNode == false) {
                                JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance3 = new JobServiceBusBrokeredMessageProperties();
                                serviceBusTopicMessageInstance2.setBrokeredMessageProperties(brokeredMessagePropertiesInstance3);
                                
                                JsonNode contentTypeValue3 = brokeredMessagePropertiesValue7.get("contentType");
                                if (contentTypeValue3 != null && contentTypeValue3 instanceof NullNode == false) {
                                    String contentTypeInstance3;
                                    contentTypeInstance3 = contentTypeValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setContentType(contentTypeInstance3);
                                }
                                
                                JsonNode correlationIdValue3 = brokeredMessagePropertiesValue7.get("correlationId");
                                if (correlationIdValue3 != null && correlationIdValue3 instanceof NullNode == false) {
                                    String correlationIdInstance3;
                                    correlationIdInstance3 = correlationIdValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setCorrelationId(correlationIdInstance3);
                                }
                                
                                JsonNode forcePersistenceValue3 = brokeredMessagePropertiesValue7.get("forcePersistence");
                                if (forcePersistenceValue3 != null && forcePersistenceValue3 instanceof NullNode == false) {
                                    boolean forcePersistenceInstance3;
                                    forcePersistenceInstance3 = forcePersistenceValue3.getBooleanValue();
                                    brokeredMessagePropertiesInstance3.setForcePersistence(forcePersistenceInstance3);
                                }
                                
                                JsonNode labelValue3 = brokeredMessagePropertiesValue7.get("label");
                                if (labelValue3 != null && labelValue3 instanceof NullNode == false) {
                                    String labelInstance3;
                                    labelInstance3 = labelValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setLabel(labelInstance3);
                                }
                                
                                JsonNode messageIdValue3 = brokeredMessagePropertiesValue7.get("messageId");
                                if (messageIdValue3 != null && messageIdValue3 instanceof NullNode == false) {
                                    String messageIdInstance3;
                                    messageIdInstance3 = messageIdValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setMessageId(messageIdInstance3);
                                }
                                
                                JsonNode partitionKeyValue3 = brokeredMessagePropertiesValue7.get("partitionKey");
                                if (partitionKeyValue3 != null && partitionKeyValue3 instanceof NullNode == false) {
                                    String partitionKeyInstance3;
                                    partitionKeyInstance3 = partitionKeyValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setPartitionKey(partitionKeyInstance3);
                                }
                                
                                JsonNode replyToValue3 = brokeredMessagePropertiesValue7.get("replyTo");
                                if (replyToValue3 != null && replyToValue3 instanceof NullNode == false) {
                                    String replyToInstance3;
                                    replyToInstance3 = replyToValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setReplyTo(replyToInstance3);
                                }
                                
                                JsonNode replyToSessionIdValue3 = brokeredMessagePropertiesValue7.get("replyToSessionId");
                                if (replyToSessionIdValue3 != null && replyToSessionIdValue3 instanceof NullNode == false) {
                                    String replyToSessionIdInstance3;
                                    replyToSessionIdInstance3 = replyToSessionIdValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setReplyToSessionId(replyToSessionIdInstance3);
                                }
                                
                                JsonNode scheduledEnqueueTimeUtcValue3 = brokeredMessagePropertiesValue7.get("scheduledEnqueueTimeUtc");
                                if (scheduledEnqueueTimeUtcValue3 != null && scheduledEnqueueTimeUtcValue3 instanceof NullNode == false) {
                                    Calendar scheduledEnqueueTimeUtcInstance3;
                                    scheduledEnqueueTimeUtcInstance3 = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue3.getTextValue());
                                    brokeredMessagePropertiesInstance3.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance3);
                                }
                                
                                JsonNode sessionIdValue3 = brokeredMessagePropertiesValue7.get("sessionId");
                                if (sessionIdValue3 != null && sessionIdValue3 instanceof NullNode == false) {
                                    String sessionIdInstance3;
                                    sessionIdInstance3 = sessionIdValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setSessionId(sessionIdInstance3);
                                }
                                
                                JsonNode timeToLiveValue3 = brokeredMessagePropertiesValue7.get("timeToLive");
                                if (timeToLiveValue3 != null && timeToLiveValue3 instanceof NullNode == false) {
                                    Calendar timeToLiveInstance3;
                                    timeToLiveInstance3 = DatatypeConverter.parseDateTime(timeToLiveValue3.getTextValue());
                                    brokeredMessagePropertiesInstance3.setTimeToLive(timeToLiveInstance3);
                                }
                                
                                JsonNode toValue3 = brokeredMessagePropertiesValue7.get("to");
                                if (toValue3 != null && toValue3 instanceof NullNode == false) {
                                    String toInstance3;
                                    toInstance3 = toValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setTo(toInstance3);
                                }
                                
                                JsonNode viaPartitionKeyValue3 = brokeredMessagePropertiesValue7.get("viaPartitionKey");
                                if (viaPartitionKeyValue3 != null && viaPartitionKeyValue3 instanceof NullNode == false) {
                                    String viaPartitionKeyInstance3;
                                    viaPartitionKeyInstance3 = viaPartitionKeyValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setViaPartitionKey(viaPartitionKeyInstance3);
                                }
                            }
                            
                            JsonNode customMessagePropertiesSequenceElement3 = ((JsonNode) serviceBusTopicMessageValue4.get("customMessageProperties"));
                            if (customMessagePropertiesSequenceElement3 != null && customMessagePropertiesSequenceElement3 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr5 = customMessagePropertiesSequenceElement3.getFields();
                                while (itr5.hasNext()) {
                                    Map.Entry<String, JsonNode> property5 = itr5.next();
                                    String customMessagePropertiesKey7 = property5.getKey();
                                    String customMessagePropertiesValue7 = property5.getValue().getTextValue();
                                    serviceBusTopicMessageInstance2.getCustomMessageProperties().put(customMessagePropertiesKey7, customMessagePropertiesValue7);
                                }
                            }
                        }
                        
                        JsonNode serviceBusQueueMessageValue4 = actionValue2.get("serviceBusQueueMessage");
                        if (serviceBusQueueMessageValue4 != null && serviceBusQueueMessageValue4 instanceof NullNode == false) {
                            JobServiceBusQueueMessage serviceBusQueueMessageInstance2 = new JobServiceBusQueueMessage();
                            actionInstance.setServiceBusQueueMessage(serviceBusQueueMessageInstance2);
                            
                            JsonNode queueNameValue4 = serviceBusQueueMessageValue4.get("queueName");
                            if (queueNameValue4 != null && queueNameValue4 instanceof NullNode == false) {
                                String queueNameInstance4;
                                queueNameInstance4 = queueNameValue4.getTextValue();
                                serviceBusQueueMessageInstance2.setQueueName(queueNameInstance4);
                            }
                            
                            JsonNode namespaceValue4 = serviceBusQueueMessageValue4.get("namespace");
                            if (namespaceValue4 != null && namespaceValue4 instanceof NullNode == false) {
                                String namespaceInstance4;
                                namespaceInstance4 = namespaceValue4.getTextValue();
                                serviceBusQueueMessageInstance2.setNamespace(namespaceInstance4);
                            }
                            
                            JsonNode transportTypeValue4 = serviceBusQueueMessageValue4.get("transportType");
                            if (transportTypeValue4 != null && transportTypeValue4 instanceof NullNode == false) {
                                JobServiceBusTransportType transportTypeInstance4;
                                transportTypeInstance4 = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue4.getTextValue());
                                serviceBusQueueMessageInstance2.setTransportType(transportTypeInstance4);
                            }
                            
                            JsonNode authenticationValue12 = serviceBusQueueMessageValue4.get("authentication");
                            if (authenticationValue12 != null && authenticationValue12 instanceof NullNode == false) {
                                JobServiceBusAuthentication authenticationInstance4 = new JobServiceBusAuthentication();
                                serviceBusQueueMessageInstance2.setAuthentication(authenticationInstance4);
                                
                                JsonNode sasKeyNameValue4 = authenticationValue12.get("sasKeyName");
                                if (sasKeyNameValue4 != null && sasKeyNameValue4 instanceof NullNode == false) {
                                    String sasKeyNameInstance4;
                                    sasKeyNameInstance4 = sasKeyNameValue4.getTextValue();
                                    authenticationInstance4.setSasKeyName(sasKeyNameInstance4);
                                }
                                
                                JsonNode sasKeyValue4 = authenticationValue12.get("sasKey");
                                if (sasKeyValue4 != null && sasKeyValue4 instanceof NullNode == false) {
                                    String sasKeyInstance4;
                                    sasKeyInstance4 = sasKeyValue4.getTextValue();
                                    authenticationInstance4.setSasKey(sasKeyInstance4);
                                }
                                
                                JsonNode typeValue12 = authenticationValue12.get("type");
                                if (typeValue12 != null && typeValue12 instanceof NullNode == false) {
                                    JobServiceBusAuthenticationType typeInstance12;
                                    typeInstance12 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue12.getTextValue());
                                    authenticationInstance4.setType(typeInstance12);
                                }
                            }
                            
                            JsonNode messageValue6 = serviceBusQueueMessageValue4.get("message");
                            if (messageValue6 != null && messageValue6 instanceof NullNode == false) {
                                String messageInstance6;
                                messageInstance6 = messageValue6.getTextValue();
                                serviceBusQueueMessageInstance2.setMessage(messageInstance6);
                            }
                            
                            JsonNode brokeredMessagePropertiesValue8 = serviceBusQueueMessageValue4.get("brokeredMessageProperties");
                            if (brokeredMessagePropertiesValue8 != null && brokeredMessagePropertiesValue8 instanceof NullNode == false) {
                                JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance4 = new JobServiceBusBrokeredMessageProperties();
                                serviceBusQueueMessageInstance2.setBrokeredMessageProperties(brokeredMessagePropertiesInstance4);
                                
                                JsonNode contentTypeValue4 = brokeredMessagePropertiesValue8.get("contentType");
                                if (contentTypeValue4 != null && contentTypeValue4 instanceof NullNode == false) {
                                    String contentTypeInstance4;
                                    contentTypeInstance4 = contentTypeValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setContentType(contentTypeInstance4);
                                }
                                
                                JsonNode correlationIdValue4 = brokeredMessagePropertiesValue8.get("correlationId");
                                if (correlationIdValue4 != null && correlationIdValue4 instanceof NullNode == false) {
                                    String correlationIdInstance4;
                                    correlationIdInstance4 = correlationIdValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setCorrelationId(correlationIdInstance4);
                                }
                                
                                JsonNode forcePersistenceValue4 = brokeredMessagePropertiesValue8.get("forcePersistence");
                                if (forcePersistenceValue4 != null && forcePersistenceValue4 instanceof NullNode == false) {
                                    boolean forcePersistenceInstance4;
                                    forcePersistenceInstance4 = forcePersistenceValue4.getBooleanValue();
                                    brokeredMessagePropertiesInstance4.setForcePersistence(forcePersistenceInstance4);
                                }
                                
                                JsonNode labelValue4 = brokeredMessagePropertiesValue8.get("label");
                                if (labelValue4 != null && labelValue4 instanceof NullNode == false) {
                                    String labelInstance4;
                                    labelInstance4 = labelValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setLabel(labelInstance4);
                                }
                                
                                JsonNode messageIdValue4 = brokeredMessagePropertiesValue8.get("messageId");
                                if (messageIdValue4 != null && messageIdValue4 instanceof NullNode == false) {
                                    String messageIdInstance4;
                                    messageIdInstance4 = messageIdValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setMessageId(messageIdInstance4);
                                }
                                
                                JsonNode partitionKeyValue4 = brokeredMessagePropertiesValue8.get("partitionKey");
                                if (partitionKeyValue4 != null && partitionKeyValue4 instanceof NullNode == false) {
                                    String partitionKeyInstance4;
                                    partitionKeyInstance4 = partitionKeyValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setPartitionKey(partitionKeyInstance4);
                                }
                                
                                JsonNode replyToValue4 = brokeredMessagePropertiesValue8.get("replyTo");
                                if (replyToValue4 != null && replyToValue4 instanceof NullNode == false) {
                                    String replyToInstance4;
                                    replyToInstance4 = replyToValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setReplyTo(replyToInstance4);
                                }
                                
                                JsonNode replyToSessionIdValue4 = brokeredMessagePropertiesValue8.get("replyToSessionId");
                                if (replyToSessionIdValue4 != null && replyToSessionIdValue4 instanceof NullNode == false) {
                                    String replyToSessionIdInstance4;
                                    replyToSessionIdInstance4 = replyToSessionIdValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setReplyToSessionId(replyToSessionIdInstance4);
                                }
                                
                                JsonNode scheduledEnqueueTimeUtcValue4 = brokeredMessagePropertiesValue8.get("scheduledEnqueueTimeUtc");
                                if (scheduledEnqueueTimeUtcValue4 != null && scheduledEnqueueTimeUtcValue4 instanceof NullNode == false) {
                                    Calendar scheduledEnqueueTimeUtcInstance4;
                                    scheduledEnqueueTimeUtcInstance4 = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue4.getTextValue());
                                    brokeredMessagePropertiesInstance4.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance4);
                                }
                                
                                JsonNode sessionIdValue4 = brokeredMessagePropertiesValue8.get("sessionId");
                                if (sessionIdValue4 != null && sessionIdValue4 instanceof NullNode == false) {
                                    String sessionIdInstance4;
                                    sessionIdInstance4 = sessionIdValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setSessionId(sessionIdInstance4);
                                }
                                
                                JsonNode timeToLiveValue4 = brokeredMessagePropertiesValue8.get("timeToLive");
                                if (timeToLiveValue4 != null && timeToLiveValue4 instanceof NullNode == false) {
                                    Calendar timeToLiveInstance4;
                                    timeToLiveInstance4 = DatatypeConverter.parseDateTime(timeToLiveValue4.getTextValue());
                                    brokeredMessagePropertiesInstance4.setTimeToLive(timeToLiveInstance4);
                                }
                                
                                JsonNode toValue4 = brokeredMessagePropertiesValue8.get("to");
                                if (toValue4 != null && toValue4 instanceof NullNode == false) {
                                    String toInstance4;
                                    toInstance4 = toValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setTo(toInstance4);
                                }
                                
                                JsonNode viaPartitionKeyValue4 = brokeredMessagePropertiesValue8.get("viaPartitionKey");
                                if (viaPartitionKeyValue4 != null && viaPartitionKeyValue4 instanceof NullNode == false) {
                                    String viaPartitionKeyInstance4;
                                    viaPartitionKeyInstance4 = viaPartitionKeyValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setViaPartitionKey(viaPartitionKeyInstance4);
                                }
                            }
                            
                            JsonNode customMessagePropertiesSequenceElement4 = ((JsonNode) serviceBusQueueMessageValue4.get("customMessageProperties"));
                            if (customMessagePropertiesSequenceElement4 != null && customMessagePropertiesSequenceElement4 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr6 = customMessagePropertiesSequenceElement4.getFields();
                                while (itr6.hasNext()) {
                                    Map.Entry<String, JsonNode> property6 = itr6.next();
                                    String customMessagePropertiesKey8 = property6.getKey();
                                    String customMessagePropertiesValue8 = property6.getValue().getTextValue();
                                    serviceBusQueueMessageInstance2.getCustomMessageProperties().put(customMessagePropertiesKey8, customMessagePropertiesValue8);
                                }
                            }
                        }
                    }
                    
                    JsonNode recurrenceValue2 = responseDoc.get("recurrence");
                    if (recurrenceValue2 != null && recurrenceValue2 instanceof NullNode == false) {
                        JobRecurrence recurrenceInstance = new JobRecurrence();
                        jobInstance.setRecurrence(recurrenceInstance);
                        
                        JsonNode frequencyValue = recurrenceValue2.get("frequency");
                        if (frequencyValue != null && frequencyValue instanceof NullNode == false) {
                            JobRecurrenceFrequency frequencyInstance;
                            frequencyInstance = SchedulerClientImpl.parseJobRecurrenceFrequency(frequencyValue.getTextValue());
                            recurrenceInstance.setFrequency(frequencyInstance);
                        }
                        
                        JsonNode intervalValue = recurrenceValue2.get("interval");
                        if (intervalValue != null && intervalValue instanceof NullNode == false) {
                            int intervalInstance;
                            intervalInstance = intervalValue.getIntValue();
                            recurrenceInstance.setInterval(intervalInstance);
                        }
                        
                        JsonNode countValue = recurrenceValue2.get("count");
                        if (countValue != null && countValue instanceof NullNode == false) {
                            int countInstance;
                            countInstance = countValue.getIntValue();
                            recurrenceInstance.setCount(countInstance);
                        }
                        
                        JsonNode endTimeValue = recurrenceValue2.get("endTime");
                        if (endTimeValue != null && endTimeValue instanceof NullNode == false) {
                            Calendar endTimeInstance;
                            endTimeInstance = DatatypeConverter.parseDateTime(endTimeValue.getTextValue());
                            recurrenceInstance.setEndTime(endTimeInstance);
                        }
                        
                        JsonNode scheduleValue2 = recurrenceValue2.get("schedule");
                        if (scheduleValue2 != null && scheduleValue2 instanceof NullNode == false) {
                            JobRecurrenceSchedule scheduleInstance = new JobRecurrenceSchedule();
                            recurrenceInstance.setSchedule(scheduleInstance);
                            
                            JsonNode minutesArray2 = scheduleValue2.get("minutes");
                            if (minutesArray2 != null && minutesArray2 instanceof NullNode == false) {
                                scheduleInstance.setMinutes(new ArrayList<Integer>());
                                for (JsonNode minutesValue : ((ArrayNode) minutesArray2)) {
                                    scheduleInstance.getMinutes().add(minutesValue.getIntValue());
                                }
                            }
                            
                            JsonNode hoursArray2 = scheduleValue2.get("hours");
                            if (hoursArray2 != null && hoursArray2 instanceof NullNode == false) {
                                scheduleInstance.setHours(new ArrayList<Integer>());
                                for (JsonNode hoursValue : ((ArrayNode) hoursArray2)) {
                                    scheduleInstance.getHours().add(hoursValue.getIntValue());
                                }
                            }
                            
                            JsonNode weekDaysArray2 = scheduleValue2.get("weekDays");
                            if (weekDaysArray2 != null && weekDaysArray2 instanceof NullNode == false) {
                                scheduleInstance.setDays(new ArrayList<JobScheduleDay>());
                                for (JsonNode weekDaysValue : ((ArrayNode) weekDaysArray2)) {
                                    scheduleInstance.getDays().add(SchedulerClientImpl.parseJobScheduleDay(weekDaysValue.getTextValue()));
                                }
                            }
                            
                            JsonNode monthsArray2 = scheduleValue2.get("months");
                            if (monthsArray2 != null && monthsArray2 instanceof NullNode == false) {
                                scheduleInstance.setMonths(new ArrayList<Integer>());
                                for (JsonNode monthsValue : ((ArrayNode) monthsArray2)) {
                                    scheduleInstance.getMonths().add(monthsValue.getIntValue());
                                }
                            }
                            
                            JsonNode monthDaysArray2 = scheduleValue2.get("monthDays");
                            if (monthDaysArray2 != null && monthDaysArray2 instanceof NullNode == false) {
                                scheduleInstance.setMonthDays(new ArrayList<Integer>());
                                for (JsonNode monthDaysValue : ((ArrayNode) monthDaysArray2)) {
                                    scheduleInstance.getMonthDays().add(monthDaysValue.getIntValue());
                                }
                            }
                            
                            JsonNode monthlyOccurrencesArray2 = scheduleValue2.get("monthlyOccurrences");
                            if (monthlyOccurrencesArray2 != null && monthlyOccurrencesArray2 instanceof NullNode == false) {
                                scheduleInstance.setMonthlyOccurrences(new ArrayList<JobScheduleMonthlyOccurrence>());
                                for (JsonNode monthlyOccurrencesValue : ((ArrayNode) monthlyOccurrencesArray2)) {
                                    JobScheduleMonthlyOccurrence jobScheduleMonthlyOccurrenceInstance = new JobScheduleMonthlyOccurrence();
                                    scheduleInstance.getMonthlyOccurrences().add(jobScheduleMonthlyOccurrenceInstance);
                                    
                                    JsonNode dayValue = monthlyOccurrencesValue.get("day");
                                    if (dayValue != null && dayValue instanceof NullNode == false) {
                                        JobScheduleDay dayInstance;
                                        dayInstance = SchedulerClientImpl.parseJobScheduleDay(dayValue.getTextValue());
                                        jobScheduleMonthlyOccurrenceInstance.setDay(dayInstance);
                                    }
                                    
                                    JsonNode occurrenceValue = monthlyOccurrencesValue.get("occurrence");
                                    if (occurrenceValue != null && occurrenceValue instanceof NullNode == false) {
                                        int occurrenceInstance;
                                        occurrenceInstance = occurrenceValue.getIntValue();
                                        jobScheduleMonthlyOccurrenceInstance.setOccurrence(occurrenceInstance);
                                    }
                                }
                            }
                        }
                    }
                    
                    JsonNode statusValue = responseDoc.get("status");
                    if (statusValue != null && statusValue instanceof NullNode == false) {
                        JobStatus statusInstance = new JobStatus();
                        jobInstance.setStatus(statusInstance);
                        
                        JsonNode lastExecutionTimeValue = statusValue.get("lastExecutionTime");
                        if (lastExecutionTimeValue != null && lastExecutionTimeValue instanceof NullNode == false) {
                            Calendar lastExecutionTimeInstance;
                            lastExecutionTimeInstance = DatatypeConverter.parseDateTime(lastExecutionTimeValue.getTextValue());
                            statusInstance.setLastExecutionTime(lastExecutionTimeInstance);
                        }
                        
                        JsonNode nextExecutionTimeValue = statusValue.get("nextExecutionTime");
                        if (nextExecutionTimeValue != null && nextExecutionTimeValue instanceof NullNode == false) {
                            Calendar nextExecutionTimeInstance;
                            nextExecutionTimeInstance = DatatypeConverter.parseDateTime(nextExecutionTimeValue.getTextValue());
                            statusInstance.setNextExecutionTime(nextExecutionTimeInstance);
                        }
                        
                        JsonNode executionCountValue = statusValue.get("executionCount");
                        if (executionCountValue != null && executionCountValue instanceof NullNode == false) {
                            int executionCountInstance;
                            executionCountInstance = executionCountValue.getIntValue();
                            statusInstance.setExecutionCount(executionCountInstance);
                        }
                        
                        JsonNode failureCountValue = statusValue.get("failureCount");
                        if (failureCountValue != null && failureCountValue instanceof NullNode == false) {
                            int failureCountInstance;
                            failureCountInstance = failureCountValue.getIntValue();
                            statusInstance.setFailureCount(failureCountInstance);
                        }
                        
                        JsonNode faultedCountValue = statusValue.get("faultedCount");
                        if (faultedCountValue != null && faultedCountValue instanceof NullNode == false) {
                            int faultedCountInstance;
                            faultedCountInstance = faultedCountValue.getIntValue();
                            statusInstance.setFaultedCount(faultedCountInstance);
                        }
                    }
                    
                    JsonNode stateValue = responseDoc.get("state");
                    if (stateValue != null && stateValue instanceof NullNode == false) {
                        JobState stateInstance;
                        stateInstance = SchedulerClientImpl.parseJobState(stateValue.getTextValue());
                        jobInstance.setState(stateInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Deletes a job.
    *
    * @param jobId Required. Id of the job to delete.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String jobId) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(jobId);
            }
         });
    }
    
    /**
    * Deletes a job.
    *
    * @param jobId Required. Id of the job to delete.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String jobId) throws IOException, ServiceException {
        // Validate
        if (jobId == null) {
            throw new NullPointerException("jobId");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("jobId", jobId);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/cloudservices/";
        url = url + URLEncoder.encode(this.getClient().getCloudServiceName(), "UTF-8");
        url = url + "/resources/";
        url = url + "scheduler";
        url = url + "/~/";
        url = url + "JobCollections";
        url = url + "/";
        url = url + URLEncoder.encode(this.getClient().getJobCollectionName(), "UTF-8");
        url = url + "/jobs/";
        url = url + URLEncoder.encode(jobId, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2013-03-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Get the definition and status of a job.
    *
    * @param jobId Required. Id of the job to get.
    * @return The Get Job operation response.
    */
    @Override
    public Future<JobGetResponse> getAsync(final String jobId) {
        return this.getClient().getExecutorService().submit(new Callable<JobGetResponse>() { 
            @Override
            public JobGetResponse call() throws Exception {
                return get(jobId);
            }
         });
    }
    
    /**
    * Get the definition and status of a job.
    *
    * @param jobId Required. Id of the job to get.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Get Job operation response.
    */
    @Override
    public JobGetResponse get(String jobId) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (jobId == null) {
            throw new NullPointerException("jobId");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("jobId", jobId);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/cloudservices/";
        url = url + URLEncoder.encode(this.getClient().getCloudServiceName(), "UTF-8");
        url = url + "/resources/";
        url = url + "scheduler";
        url = url + "/~/";
        url = url + "JobCollections";
        url = url + "/";
        url = url + URLEncoder.encode(this.getClient().getJobCollectionName(), "UTF-8");
        url = url + "/jobs/";
        url = url + URLEncoder.encode(jobId, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2013-03-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            JobGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new JobGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    Job jobInstance = new Job();
                    result.setJob(jobInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        jobInstance.setId(idInstance);
                    }
                    
                    JsonNode startTimeValue = responseDoc.get("startTime");
                    if (startTimeValue != null && startTimeValue instanceof NullNode == false) {
                        Calendar startTimeInstance;
                        startTimeInstance = DatatypeConverter.parseDateTime(startTimeValue.getTextValue());
                        jobInstance.setStartTime(startTimeInstance);
                    }
                    
                    JsonNode actionValue = responseDoc.get("action");
                    if (actionValue != null && actionValue instanceof NullNode == false) {
                        JobAction actionInstance = new JobAction();
                        jobInstance.setAction(actionInstance);
                        
                        JsonNode typeValue = actionValue.get("type");
                        if (typeValue != null && typeValue instanceof NullNode == false) {
                            JobActionType typeInstance;
                            typeInstance = SchedulerClientImpl.parseJobActionType(typeValue.getTextValue());
                            actionInstance.setType(typeInstance);
                        }
                        
                        JsonNode retryPolicyValue = actionValue.get("retryPolicy");
                        if (retryPolicyValue != null && retryPolicyValue instanceof NullNode == false) {
                            RetryPolicy retryPolicyInstance = new RetryPolicy();
                            actionInstance.setRetryPolicy(retryPolicyInstance);
                            
                            JsonNode retryTypeValue = retryPolicyValue.get("retryType");
                            if (retryTypeValue != null && retryTypeValue instanceof NullNode == false) {
                                RetryType retryTypeInstance;
                                retryTypeInstance = SchedulerClientImpl.parseRetryType(retryTypeValue.getTextValue());
                                retryPolicyInstance.setRetryType(retryTypeInstance);
                            }
                            
                            JsonNode retryIntervalValue = retryPolicyValue.get("retryInterval");
                            if (retryIntervalValue != null && retryIntervalValue instanceof NullNode == false) {
                                Duration retryIntervalInstance;
                                retryIntervalInstance = TimeSpan8601Converter.parse(retryIntervalValue.getTextValue());
                                retryPolicyInstance.setRetryInterval(retryIntervalInstance);
                            }
                            
                            JsonNode retryCountValue = retryPolicyValue.get("retryCount");
                            if (retryCountValue != null && retryCountValue instanceof NullNode == false) {
                                int retryCountInstance;
                                retryCountInstance = retryCountValue.getIntValue();
                                retryPolicyInstance.setRetryCount(retryCountInstance);
                            }
                        }
                        
                        JsonNode errorActionValue = actionValue.get("errorAction");
                        if (errorActionValue != null && errorActionValue instanceof NullNode == false) {
                            JobErrorAction errorActionInstance = new JobErrorAction();
                            actionInstance.setErrorAction(errorActionInstance);
                            
                            JsonNode typeValue2 = errorActionValue.get("type");
                            if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                JobActionType typeInstance2;
                                typeInstance2 = SchedulerClientImpl.parseJobActionType(typeValue2.getTextValue());
                                errorActionInstance.setType(typeInstance2);
                            }
                            
                            JsonNode requestValue = errorActionValue.get("request");
                            if (requestValue != null && requestValue instanceof NullNode == false) {
                                JobHttpRequest requestInstance = new JobHttpRequest();
                                errorActionInstance.setRequest(requestInstance);
                                
                                JsonNode uriValue = requestValue.get("uri");
                                if (uriValue != null && uriValue instanceof NullNode == false) {
                                    URI uriInstance;
                                    uriInstance = new URI(uriValue.getTextValue());
                                    requestInstance.setUri(uriInstance);
                                }
                                
                                JsonNode methodValue = requestValue.get("method");
                                if (methodValue != null && methodValue instanceof NullNode == false) {
                                    String methodInstance;
                                    methodInstance = methodValue.getTextValue();
                                    requestInstance.setMethod(methodInstance);
                                }
                                
                                JsonNode headersSequenceElement = ((JsonNode) requestValue.get("headers"));
                                if (headersSequenceElement != null && headersSequenceElement instanceof NullNode == false) {
                                    Iterator<Map.Entry<String, JsonNode>> itr = headersSequenceElement.getFields();
                                    while (itr.hasNext()) {
                                        Map.Entry<String, JsonNode> property = itr.next();
                                        String headersKey = property.getKey();
                                        String headersValue = property.getValue().getTextValue();
                                        requestInstance.getHeaders().put(headersKey, headersValue);
                                    }
                                }
                                
                                JsonNode bodyValue = requestValue.get("body");
                                if (bodyValue != null && bodyValue instanceof NullNode == false) {
                                    String bodyInstance;
                                    bodyInstance = bodyValue.getTextValue();
                                    requestInstance.setBody(bodyInstance);
                                }
                                
                                JsonNode authenticationValue = requestValue.get("authentication");
                                if (authenticationValue != null && authenticationValue instanceof NullNode == false) {
                                    String typeName = authenticationValue.get("type").getTextValue();
                                    if ("ClientCertificate".equals(typeName)) {
                                        ClientCertAuthentication clientCertAuthenticationInstance = new ClientCertAuthentication();
                                        
                                        JsonNode passwordValue = authenticationValue.get("password");
                                        if (passwordValue != null && passwordValue instanceof NullNode == false) {
                                            String passwordInstance;
                                            passwordInstance = passwordValue.getTextValue();
                                            clientCertAuthenticationInstance.setPassword(passwordInstance);
                                        }
                                        
                                        JsonNode pfxValue = authenticationValue.get("pfx");
                                        if (pfxValue != null && pfxValue instanceof NullNode == false) {
                                            String pfxInstance;
                                            pfxInstance = pfxValue.getTextValue();
                                            clientCertAuthenticationInstance.setPfx(pfxInstance);
                                        }
                                        
                                        JsonNode certificateThumbprintValue = authenticationValue.get("certificateThumbprint");
                                        if (certificateThumbprintValue != null && certificateThumbprintValue instanceof NullNode == false) {
                                            String certificateThumbprintInstance;
                                            certificateThumbprintInstance = certificateThumbprintValue.getTextValue();
                                            clientCertAuthenticationInstance.setCertificateThumbprint(certificateThumbprintInstance);
                                        }
                                        
                                        JsonNode certificateExpirationValue = authenticationValue.get("certificateExpiration");
                                        if (certificateExpirationValue != null && certificateExpirationValue instanceof NullNode == false) {
                                            Calendar certificateExpirationInstance;
                                            certificateExpirationInstance = DatatypeConverter.parseDateTime(certificateExpirationValue.getTextValue());
                                            clientCertAuthenticationInstance.setCertificateExpiration(certificateExpirationInstance);
                                        }
                                        
                                        JsonNode certificateSubjectNameValue = authenticationValue.get("certificateSubjectName");
                                        if (certificateSubjectNameValue != null && certificateSubjectNameValue instanceof NullNode == false) {
                                            String certificateSubjectNameInstance;
                                            certificateSubjectNameInstance = certificateSubjectNameValue.getTextValue();
                                            clientCertAuthenticationInstance.setCertificateSubjectName(certificateSubjectNameInstance);
                                        }
                                        
                                        JsonNode typeValue3 = authenticationValue.get("type");
                                        if (typeValue3 != null && typeValue3 instanceof NullNode == false) {
                                            HttpAuthenticationType typeInstance3;
                                            typeInstance3 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue3.getTextValue());
                                            clientCertAuthenticationInstance.setType(typeInstance3);
                                        }
                                        requestInstance.setAuthentication(clientCertAuthenticationInstance);
                                    }
                                    if ("ActiveDirectoryOAuth".equals(typeName)) {
                                        AADOAuthAuthentication aADOAuthAuthenticationInstance = new AADOAuthAuthentication();
                                        
                                        JsonNode secretValue = authenticationValue.get("secret");
                                        if (secretValue != null && secretValue instanceof NullNode == false) {
                                            String secretInstance;
                                            secretInstance = secretValue.getTextValue();
                                            aADOAuthAuthenticationInstance.setSecret(secretInstance);
                                        }
                                        
                                        JsonNode tenantValue = authenticationValue.get("tenant");
                                        if (tenantValue != null && tenantValue instanceof NullNode == false) {
                                            String tenantInstance;
                                            tenantInstance = tenantValue.getTextValue();
                                            aADOAuthAuthenticationInstance.setTenant(tenantInstance);
                                        }
                                        
                                        JsonNode audienceValue = authenticationValue.get("audience");
                                        if (audienceValue != null && audienceValue instanceof NullNode == false) {
                                            String audienceInstance;
                                            audienceInstance = audienceValue.getTextValue();
                                            aADOAuthAuthenticationInstance.setAudience(audienceInstance);
                                        }
                                        
                                        JsonNode clientIdValue = authenticationValue.get("clientId");
                                        if (clientIdValue != null && clientIdValue instanceof NullNode == false) {
                                            String clientIdInstance;
                                            clientIdInstance = clientIdValue.getTextValue();
                                            aADOAuthAuthenticationInstance.setClientId(clientIdInstance);
                                        }
                                        
                                        JsonNode typeValue4 = authenticationValue.get("type");
                                        if (typeValue4 != null && typeValue4 instanceof NullNode == false) {
                                            HttpAuthenticationType typeInstance4;
                                            typeInstance4 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue4.getTextValue());
                                            aADOAuthAuthenticationInstance.setType(typeInstance4);
                                        }
                                        requestInstance.setAuthentication(aADOAuthAuthenticationInstance);
                                    }
                                    if ("Basic".equals(typeName)) {
                                        BasicAuthentication basicAuthenticationInstance = new BasicAuthentication();
                                        
                                        JsonNode usernameValue = authenticationValue.get("username");
                                        if (usernameValue != null && usernameValue instanceof NullNode == false) {
                                            String usernameInstance;
                                            usernameInstance = usernameValue.getTextValue();
                                            basicAuthenticationInstance.setUsername(usernameInstance);
                                        }
                                        
                                        JsonNode passwordValue2 = authenticationValue.get("password");
                                        if (passwordValue2 != null && passwordValue2 instanceof NullNode == false) {
                                            String passwordInstance2;
                                            passwordInstance2 = passwordValue2.getTextValue();
                                            basicAuthenticationInstance.setPassword(passwordInstance2);
                                        }
                                        
                                        JsonNode typeValue5 = authenticationValue.get("type");
                                        if (typeValue5 != null && typeValue5 instanceof NullNode == false) {
                                            HttpAuthenticationType typeInstance5;
                                            typeInstance5 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue5.getTextValue());
                                            basicAuthenticationInstance.setType(typeInstance5);
                                        }
                                        requestInstance.setAuthentication(basicAuthenticationInstance);
                                    }
                                }
                            }
                            
                            JsonNode queueMessageValue = errorActionValue.get("queueMessage");
                            if (queueMessageValue != null && queueMessageValue instanceof NullNode == false) {
                                JobQueueMessage queueMessageInstance = new JobQueueMessage();
                                errorActionInstance.setQueueMessage(queueMessageInstance);
                                
                                JsonNode storageAccountValue = queueMessageValue.get("storageAccount");
                                if (storageAccountValue != null && storageAccountValue instanceof NullNode == false) {
                                    String storageAccountInstance;
                                    storageAccountInstance = storageAccountValue.getTextValue();
                                    queueMessageInstance.setStorageAccountName(storageAccountInstance);
                                }
                                
                                JsonNode queueNameValue = queueMessageValue.get("queueName");
                                if (queueNameValue != null && queueNameValue instanceof NullNode == false) {
                                    String queueNameInstance;
                                    queueNameInstance = queueNameValue.getTextValue();
                                    queueMessageInstance.setQueueName(queueNameInstance);
                                }
                                
                                JsonNode sasTokenValue = queueMessageValue.get("sasToken");
                                if (sasTokenValue != null && sasTokenValue instanceof NullNode == false) {
                                    String sasTokenInstance;
                                    sasTokenInstance = sasTokenValue.getTextValue();
                                    queueMessageInstance.setSasToken(sasTokenInstance);
                                }
                                
                                JsonNode messageValue = queueMessageValue.get("message");
                                if (messageValue != null && messageValue instanceof NullNode == false) {
                                    String messageInstance;
                                    messageInstance = messageValue.getTextValue();
                                    queueMessageInstance.setMessage(messageInstance);
                                }
                            }
                            
                            JsonNode serviceBusTopicMessageValue = errorActionValue.get("serviceBusTopicMessage");
                            if (serviceBusTopicMessageValue != null && serviceBusTopicMessageValue instanceof NullNode == false) {
                                JobServiceBusTopicMessage serviceBusTopicMessageInstance = new JobServiceBusTopicMessage();
                                errorActionInstance.setServiceBusTopicMessage(serviceBusTopicMessageInstance);
                                
                                JsonNode topicPathValue = serviceBusTopicMessageValue.get("topicPath");
                                if (topicPathValue != null && topicPathValue instanceof NullNode == false) {
                                    String topicPathInstance;
                                    topicPathInstance = topicPathValue.getTextValue();
                                    serviceBusTopicMessageInstance.setTopicPath(topicPathInstance);
                                }
                                
                                JsonNode namespaceValue = serviceBusTopicMessageValue.get("namespace");
                                if (namespaceValue != null && namespaceValue instanceof NullNode == false) {
                                    String namespaceInstance;
                                    namespaceInstance = namespaceValue.getTextValue();
                                    serviceBusTopicMessageInstance.setNamespace(namespaceInstance);
                                }
                                
                                JsonNode transportTypeValue = serviceBusTopicMessageValue.get("transportType");
                                if (transportTypeValue != null && transportTypeValue instanceof NullNode == false) {
                                    JobServiceBusTransportType transportTypeInstance;
                                    transportTypeInstance = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue.getTextValue());
                                    serviceBusTopicMessageInstance.setTransportType(transportTypeInstance);
                                }
                                
                                JsonNode authenticationValue2 = serviceBusTopicMessageValue.get("authentication");
                                if (authenticationValue2 != null && authenticationValue2 instanceof NullNode == false) {
                                    JobServiceBusAuthentication authenticationInstance = new JobServiceBusAuthentication();
                                    serviceBusTopicMessageInstance.setAuthentication(authenticationInstance);
                                    
                                    JsonNode sasKeyNameValue = authenticationValue2.get("sasKeyName");
                                    if (sasKeyNameValue != null && sasKeyNameValue instanceof NullNode == false) {
                                        String sasKeyNameInstance;
                                        sasKeyNameInstance = sasKeyNameValue.getTextValue();
                                        authenticationInstance.setSasKeyName(sasKeyNameInstance);
                                    }
                                    
                                    JsonNode sasKeyValue = authenticationValue2.get("sasKey");
                                    if (sasKeyValue != null && sasKeyValue instanceof NullNode == false) {
                                        String sasKeyInstance;
                                        sasKeyInstance = sasKeyValue.getTextValue();
                                        authenticationInstance.setSasKey(sasKeyInstance);
                                    }
                                    
                                    JsonNode typeValue6 = authenticationValue2.get("type");
                                    if (typeValue6 != null && typeValue6 instanceof NullNode == false) {
                                        JobServiceBusAuthenticationType typeInstance6;
                                        typeInstance6 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue6.getTextValue());
                                        authenticationInstance.setType(typeInstance6);
                                    }
                                }
                                
                                JsonNode messageValue2 = serviceBusTopicMessageValue.get("message");
                                if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                    String messageInstance2;
                                    messageInstance2 = messageValue2.getTextValue();
                                    serviceBusTopicMessageInstance.setMessage(messageInstance2);
                                }
                                
                                JsonNode brokeredMessagePropertiesValue = serviceBusTopicMessageValue.get("brokeredMessageProperties");
                                if (brokeredMessagePropertiesValue != null && brokeredMessagePropertiesValue instanceof NullNode == false) {
                                    JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance = new JobServiceBusBrokeredMessageProperties();
                                    serviceBusTopicMessageInstance.setBrokeredMessageProperties(brokeredMessagePropertiesInstance);
                                    
                                    JsonNode contentTypeValue = brokeredMessagePropertiesValue.get("contentType");
                                    if (contentTypeValue != null && contentTypeValue instanceof NullNode == false) {
                                        String contentTypeInstance;
                                        contentTypeInstance = contentTypeValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setContentType(contentTypeInstance);
                                    }
                                    
                                    JsonNode correlationIdValue = brokeredMessagePropertiesValue.get("correlationId");
                                    if (correlationIdValue != null && correlationIdValue instanceof NullNode == false) {
                                        String correlationIdInstance;
                                        correlationIdInstance = correlationIdValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setCorrelationId(correlationIdInstance);
                                    }
                                    
                                    JsonNode forcePersistenceValue = brokeredMessagePropertiesValue.get("forcePersistence");
                                    if (forcePersistenceValue != null && forcePersistenceValue instanceof NullNode == false) {
                                        boolean forcePersistenceInstance;
                                        forcePersistenceInstance = forcePersistenceValue.getBooleanValue();
                                        brokeredMessagePropertiesInstance.setForcePersistence(forcePersistenceInstance);
                                    }
                                    
                                    JsonNode labelValue = brokeredMessagePropertiesValue.get("label");
                                    if (labelValue != null && labelValue instanceof NullNode == false) {
                                        String labelInstance;
                                        labelInstance = labelValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setLabel(labelInstance);
                                    }
                                    
                                    JsonNode messageIdValue = brokeredMessagePropertiesValue.get("messageId");
                                    if (messageIdValue != null && messageIdValue instanceof NullNode == false) {
                                        String messageIdInstance;
                                        messageIdInstance = messageIdValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setMessageId(messageIdInstance);
                                    }
                                    
                                    JsonNode partitionKeyValue = brokeredMessagePropertiesValue.get("partitionKey");
                                    if (partitionKeyValue != null && partitionKeyValue instanceof NullNode == false) {
                                        String partitionKeyInstance;
                                        partitionKeyInstance = partitionKeyValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setPartitionKey(partitionKeyInstance);
                                    }
                                    
                                    JsonNode replyToValue = brokeredMessagePropertiesValue.get("replyTo");
                                    if (replyToValue != null && replyToValue instanceof NullNode == false) {
                                        String replyToInstance;
                                        replyToInstance = replyToValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setReplyTo(replyToInstance);
                                    }
                                    
                                    JsonNode replyToSessionIdValue = brokeredMessagePropertiesValue.get("replyToSessionId");
                                    if (replyToSessionIdValue != null && replyToSessionIdValue instanceof NullNode == false) {
                                        String replyToSessionIdInstance;
                                        replyToSessionIdInstance = replyToSessionIdValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setReplyToSessionId(replyToSessionIdInstance);
                                    }
                                    
                                    JsonNode scheduledEnqueueTimeUtcValue = brokeredMessagePropertiesValue.get("scheduledEnqueueTimeUtc");
                                    if (scheduledEnqueueTimeUtcValue != null && scheduledEnqueueTimeUtcValue instanceof NullNode == false) {
                                        Calendar scheduledEnqueueTimeUtcInstance;
                                        scheduledEnqueueTimeUtcInstance = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue.getTextValue());
                                        brokeredMessagePropertiesInstance.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance);
                                    }
                                    
                                    JsonNode sessionIdValue = brokeredMessagePropertiesValue.get("sessionId");
                                    if (sessionIdValue != null && sessionIdValue instanceof NullNode == false) {
                                        String sessionIdInstance;
                                        sessionIdInstance = sessionIdValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setSessionId(sessionIdInstance);
                                    }
                                    
                                    JsonNode timeToLiveValue = brokeredMessagePropertiesValue.get("timeToLive");
                                    if (timeToLiveValue != null && timeToLiveValue instanceof NullNode == false) {
                                        Calendar timeToLiveInstance;
                                        timeToLiveInstance = DatatypeConverter.parseDateTime(timeToLiveValue.getTextValue());
                                        brokeredMessagePropertiesInstance.setTimeToLive(timeToLiveInstance);
                                    }
                                    
                                    JsonNode toValue = brokeredMessagePropertiesValue.get("to");
                                    if (toValue != null && toValue instanceof NullNode == false) {
                                        String toInstance;
                                        toInstance = toValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setTo(toInstance);
                                    }
                                    
                                    JsonNode viaPartitionKeyValue = brokeredMessagePropertiesValue.get("viaPartitionKey");
                                    if (viaPartitionKeyValue != null && viaPartitionKeyValue instanceof NullNode == false) {
                                        String viaPartitionKeyInstance;
                                        viaPartitionKeyInstance = viaPartitionKeyValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setViaPartitionKey(viaPartitionKeyInstance);
                                    }
                                }
                                
                                JsonNode customMessagePropertiesSequenceElement = ((JsonNode) serviceBusTopicMessageValue.get("customMessageProperties"));
                                if (customMessagePropertiesSequenceElement != null && customMessagePropertiesSequenceElement instanceof NullNode == false) {
                                    Iterator<Map.Entry<String, JsonNode>> itr2 = customMessagePropertiesSequenceElement.getFields();
                                    while (itr2.hasNext()) {
                                        Map.Entry<String, JsonNode> property2 = itr2.next();
                                        String customMessagePropertiesKey = property2.getKey();
                                        String customMessagePropertiesValue = property2.getValue().getTextValue();
                                        serviceBusTopicMessageInstance.getCustomMessageProperties().put(customMessagePropertiesKey, customMessagePropertiesValue);
                                    }
                                }
                            }
                            
                            JsonNode serviceBusQueueMessageValue = errorActionValue.get("serviceBusQueueMessage");
                            if (serviceBusQueueMessageValue != null && serviceBusQueueMessageValue instanceof NullNode == false) {
                                JobServiceBusQueueMessage serviceBusQueueMessageInstance = new JobServiceBusQueueMessage();
                                errorActionInstance.setServiceBusQueueMessage(serviceBusQueueMessageInstance);
                                
                                JsonNode queueNameValue2 = serviceBusQueueMessageValue.get("queueName");
                                if (queueNameValue2 != null && queueNameValue2 instanceof NullNode == false) {
                                    String queueNameInstance2;
                                    queueNameInstance2 = queueNameValue2.getTextValue();
                                    serviceBusQueueMessageInstance.setQueueName(queueNameInstance2);
                                }
                                
                                JsonNode namespaceValue2 = serviceBusQueueMessageValue.get("namespace");
                                if (namespaceValue2 != null && namespaceValue2 instanceof NullNode == false) {
                                    String namespaceInstance2;
                                    namespaceInstance2 = namespaceValue2.getTextValue();
                                    serviceBusQueueMessageInstance.setNamespace(namespaceInstance2);
                                }
                                
                                JsonNode transportTypeValue2 = serviceBusQueueMessageValue.get("transportType");
                                if (transportTypeValue2 != null && transportTypeValue2 instanceof NullNode == false) {
                                    JobServiceBusTransportType transportTypeInstance2;
                                    transportTypeInstance2 = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue2.getTextValue());
                                    serviceBusQueueMessageInstance.setTransportType(transportTypeInstance2);
                                }
                                
                                JsonNode authenticationValue3 = serviceBusQueueMessageValue.get("authentication");
                                if (authenticationValue3 != null && authenticationValue3 instanceof NullNode == false) {
                                    JobServiceBusAuthentication authenticationInstance2 = new JobServiceBusAuthentication();
                                    serviceBusQueueMessageInstance.setAuthentication(authenticationInstance2);
                                    
                                    JsonNode sasKeyNameValue2 = authenticationValue3.get("sasKeyName");
                                    if (sasKeyNameValue2 != null && sasKeyNameValue2 instanceof NullNode == false) {
                                        String sasKeyNameInstance2;
                                        sasKeyNameInstance2 = sasKeyNameValue2.getTextValue();
                                        authenticationInstance2.setSasKeyName(sasKeyNameInstance2);
                                    }
                                    
                                    JsonNode sasKeyValue2 = authenticationValue3.get("sasKey");
                                    if (sasKeyValue2 != null && sasKeyValue2 instanceof NullNode == false) {
                                        String sasKeyInstance2;
                                        sasKeyInstance2 = sasKeyValue2.getTextValue();
                                        authenticationInstance2.setSasKey(sasKeyInstance2);
                                    }
                                    
                                    JsonNode typeValue7 = authenticationValue3.get("type");
                                    if (typeValue7 != null && typeValue7 instanceof NullNode == false) {
                                        JobServiceBusAuthenticationType typeInstance7;
                                        typeInstance7 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue7.getTextValue());
                                        authenticationInstance2.setType(typeInstance7);
                                    }
                                }
                                
                                JsonNode messageValue3 = serviceBusQueueMessageValue.get("message");
                                if (messageValue3 != null && messageValue3 instanceof NullNode == false) {
                                    String messageInstance3;
                                    messageInstance3 = messageValue3.getTextValue();
                                    serviceBusQueueMessageInstance.setMessage(messageInstance3);
                                }
                                
                                JsonNode brokeredMessagePropertiesValue2 = serviceBusQueueMessageValue.get("brokeredMessageProperties");
                                if (brokeredMessagePropertiesValue2 != null && brokeredMessagePropertiesValue2 instanceof NullNode == false) {
                                    JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance2 = new JobServiceBusBrokeredMessageProperties();
                                    serviceBusQueueMessageInstance.setBrokeredMessageProperties(brokeredMessagePropertiesInstance2);
                                    
                                    JsonNode contentTypeValue2 = brokeredMessagePropertiesValue2.get("contentType");
                                    if (contentTypeValue2 != null && contentTypeValue2 instanceof NullNode == false) {
                                        String contentTypeInstance2;
                                        contentTypeInstance2 = contentTypeValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setContentType(contentTypeInstance2);
                                    }
                                    
                                    JsonNode correlationIdValue2 = brokeredMessagePropertiesValue2.get("correlationId");
                                    if (correlationIdValue2 != null && correlationIdValue2 instanceof NullNode == false) {
                                        String correlationIdInstance2;
                                        correlationIdInstance2 = correlationIdValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setCorrelationId(correlationIdInstance2);
                                    }
                                    
                                    JsonNode forcePersistenceValue2 = brokeredMessagePropertiesValue2.get("forcePersistence");
                                    if (forcePersistenceValue2 != null && forcePersistenceValue2 instanceof NullNode == false) {
                                        boolean forcePersistenceInstance2;
                                        forcePersistenceInstance2 = forcePersistenceValue2.getBooleanValue();
                                        brokeredMessagePropertiesInstance2.setForcePersistence(forcePersistenceInstance2);
                                    }
                                    
                                    JsonNode labelValue2 = brokeredMessagePropertiesValue2.get("label");
                                    if (labelValue2 != null && labelValue2 instanceof NullNode == false) {
                                        String labelInstance2;
                                        labelInstance2 = labelValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setLabel(labelInstance2);
                                    }
                                    
                                    JsonNode messageIdValue2 = brokeredMessagePropertiesValue2.get("messageId");
                                    if (messageIdValue2 != null && messageIdValue2 instanceof NullNode == false) {
                                        String messageIdInstance2;
                                        messageIdInstance2 = messageIdValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setMessageId(messageIdInstance2);
                                    }
                                    
                                    JsonNode partitionKeyValue2 = brokeredMessagePropertiesValue2.get("partitionKey");
                                    if (partitionKeyValue2 != null && partitionKeyValue2 instanceof NullNode == false) {
                                        String partitionKeyInstance2;
                                        partitionKeyInstance2 = partitionKeyValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setPartitionKey(partitionKeyInstance2);
                                    }
                                    
                                    JsonNode replyToValue2 = brokeredMessagePropertiesValue2.get("replyTo");
                                    if (replyToValue2 != null && replyToValue2 instanceof NullNode == false) {
                                        String replyToInstance2;
                                        replyToInstance2 = replyToValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setReplyTo(replyToInstance2);
                                    }
                                    
                                    JsonNode replyToSessionIdValue2 = brokeredMessagePropertiesValue2.get("replyToSessionId");
                                    if (replyToSessionIdValue2 != null && replyToSessionIdValue2 instanceof NullNode == false) {
                                        String replyToSessionIdInstance2;
                                        replyToSessionIdInstance2 = replyToSessionIdValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setReplyToSessionId(replyToSessionIdInstance2);
                                    }
                                    
                                    JsonNode scheduledEnqueueTimeUtcValue2 = brokeredMessagePropertiesValue2.get("scheduledEnqueueTimeUtc");
                                    if (scheduledEnqueueTimeUtcValue2 != null && scheduledEnqueueTimeUtcValue2 instanceof NullNode == false) {
                                        Calendar scheduledEnqueueTimeUtcInstance2;
                                        scheduledEnqueueTimeUtcInstance2 = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue2.getTextValue());
                                        brokeredMessagePropertiesInstance2.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance2);
                                    }
                                    
                                    JsonNode sessionIdValue2 = brokeredMessagePropertiesValue2.get("sessionId");
                                    if (sessionIdValue2 != null && sessionIdValue2 instanceof NullNode == false) {
                                        String sessionIdInstance2;
                                        sessionIdInstance2 = sessionIdValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setSessionId(sessionIdInstance2);
                                    }
                                    
                                    JsonNode timeToLiveValue2 = brokeredMessagePropertiesValue2.get("timeToLive");
                                    if (timeToLiveValue2 != null && timeToLiveValue2 instanceof NullNode == false) {
                                        Calendar timeToLiveInstance2;
                                        timeToLiveInstance2 = DatatypeConverter.parseDateTime(timeToLiveValue2.getTextValue());
                                        brokeredMessagePropertiesInstance2.setTimeToLive(timeToLiveInstance2);
                                    }
                                    
                                    JsonNode toValue2 = brokeredMessagePropertiesValue2.get("to");
                                    if (toValue2 != null && toValue2 instanceof NullNode == false) {
                                        String toInstance2;
                                        toInstance2 = toValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setTo(toInstance2);
                                    }
                                    
                                    JsonNode viaPartitionKeyValue2 = brokeredMessagePropertiesValue2.get("viaPartitionKey");
                                    if (viaPartitionKeyValue2 != null && viaPartitionKeyValue2 instanceof NullNode == false) {
                                        String viaPartitionKeyInstance2;
                                        viaPartitionKeyInstance2 = viaPartitionKeyValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setViaPartitionKey(viaPartitionKeyInstance2);
                                    }
                                }
                                
                                JsonNode customMessagePropertiesSequenceElement2 = ((JsonNode) serviceBusQueueMessageValue.get("customMessageProperties"));
                                if (customMessagePropertiesSequenceElement2 != null && customMessagePropertiesSequenceElement2 instanceof NullNode == false) {
                                    Iterator<Map.Entry<String, JsonNode>> itr3 = customMessagePropertiesSequenceElement2.getFields();
                                    while (itr3.hasNext()) {
                                        Map.Entry<String, JsonNode> property3 = itr3.next();
                                        String customMessagePropertiesKey2 = property3.getKey();
                                        String customMessagePropertiesValue2 = property3.getValue().getTextValue();
                                        serviceBusQueueMessageInstance.getCustomMessageProperties().put(customMessagePropertiesKey2, customMessagePropertiesValue2);
                                    }
                                }
                            }
                        }
                        
                        JsonNode requestValue2 = actionValue.get("request");
                        if (requestValue2 != null && requestValue2 instanceof NullNode == false) {
                            JobHttpRequest requestInstance2 = new JobHttpRequest();
                            actionInstance.setRequest(requestInstance2);
                            
                            JsonNode uriValue2 = requestValue2.get("uri");
                            if (uriValue2 != null && uriValue2 instanceof NullNode == false) {
                                URI uriInstance2;
                                uriInstance2 = new URI(uriValue2.getTextValue());
                                requestInstance2.setUri(uriInstance2);
                            }
                            
                            JsonNode methodValue2 = requestValue2.get("method");
                            if (methodValue2 != null && methodValue2 instanceof NullNode == false) {
                                String methodInstance2;
                                methodInstance2 = methodValue2.getTextValue();
                                requestInstance2.setMethod(methodInstance2);
                            }
                            
                            JsonNode headersSequenceElement2 = ((JsonNode) requestValue2.get("headers"));
                            if (headersSequenceElement2 != null && headersSequenceElement2 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr4 = headersSequenceElement2.getFields();
                                while (itr4.hasNext()) {
                                    Map.Entry<String, JsonNode> property4 = itr4.next();
                                    String headersKey2 = property4.getKey();
                                    String headersValue2 = property4.getValue().getTextValue();
                                    requestInstance2.getHeaders().put(headersKey2, headersValue2);
                                }
                            }
                            
                            JsonNode bodyValue2 = requestValue2.get("body");
                            if (bodyValue2 != null && bodyValue2 instanceof NullNode == false) {
                                String bodyInstance2;
                                bodyInstance2 = bodyValue2.getTextValue();
                                requestInstance2.setBody(bodyInstance2);
                            }
                            
                            JsonNode authenticationValue4 = requestValue2.get("authentication");
                            if (authenticationValue4 != null && authenticationValue4 instanceof NullNode == false) {
                                String typeName2 = authenticationValue4.get("type").getTextValue();
                                if ("ClientCertificate".equals(typeName2)) {
                                    ClientCertAuthentication clientCertAuthenticationInstance2 = new ClientCertAuthentication();
                                    
                                    JsonNode passwordValue3 = authenticationValue4.get("password");
                                    if (passwordValue3 != null && passwordValue3 instanceof NullNode == false) {
                                        String passwordInstance3;
                                        passwordInstance3 = passwordValue3.getTextValue();
                                        clientCertAuthenticationInstance2.setPassword(passwordInstance3);
                                    }
                                    
                                    JsonNode pfxValue2 = authenticationValue4.get("pfx");
                                    if (pfxValue2 != null && pfxValue2 instanceof NullNode == false) {
                                        String pfxInstance2;
                                        pfxInstance2 = pfxValue2.getTextValue();
                                        clientCertAuthenticationInstance2.setPfx(pfxInstance2);
                                    }
                                    
                                    JsonNode certificateThumbprintValue2 = authenticationValue4.get("certificateThumbprint");
                                    if (certificateThumbprintValue2 != null && certificateThumbprintValue2 instanceof NullNode == false) {
                                        String certificateThumbprintInstance2;
                                        certificateThumbprintInstance2 = certificateThumbprintValue2.getTextValue();
                                        clientCertAuthenticationInstance2.setCertificateThumbprint(certificateThumbprintInstance2);
                                    }
                                    
                                    JsonNode certificateExpirationValue2 = authenticationValue4.get("certificateExpiration");
                                    if (certificateExpirationValue2 != null && certificateExpirationValue2 instanceof NullNode == false) {
                                        Calendar certificateExpirationInstance2;
                                        certificateExpirationInstance2 = DatatypeConverter.parseDateTime(certificateExpirationValue2.getTextValue());
                                        clientCertAuthenticationInstance2.setCertificateExpiration(certificateExpirationInstance2);
                                    }
                                    
                                    JsonNode certificateSubjectNameValue2 = authenticationValue4.get("certificateSubjectName");
                                    if (certificateSubjectNameValue2 != null && certificateSubjectNameValue2 instanceof NullNode == false) {
                                        String certificateSubjectNameInstance2;
                                        certificateSubjectNameInstance2 = certificateSubjectNameValue2.getTextValue();
                                        clientCertAuthenticationInstance2.setCertificateSubjectName(certificateSubjectNameInstance2);
                                    }
                                    
                                    JsonNode typeValue8 = authenticationValue4.get("type");
                                    if (typeValue8 != null && typeValue8 instanceof NullNode == false) {
                                        HttpAuthenticationType typeInstance8;
                                        typeInstance8 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue8.getTextValue());
                                        clientCertAuthenticationInstance2.setType(typeInstance8);
                                    }
                                    requestInstance2.setAuthentication(clientCertAuthenticationInstance2);
                                }
                                if ("ActiveDirectoryOAuth".equals(typeName2)) {
                                    AADOAuthAuthentication aADOAuthAuthenticationInstance2 = new AADOAuthAuthentication();
                                    
                                    JsonNode secretValue2 = authenticationValue4.get("secret");
                                    if (secretValue2 != null && secretValue2 instanceof NullNode == false) {
                                        String secretInstance2;
                                        secretInstance2 = secretValue2.getTextValue();
                                        aADOAuthAuthenticationInstance2.setSecret(secretInstance2);
                                    }
                                    
                                    JsonNode tenantValue2 = authenticationValue4.get("tenant");
                                    if (tenantValue2 != null && tenantValue2 instanceof NullNode == false) {
                                        String tenantInstance2;
                                        tenantInstance2 = tenantValue2.getTextValue();
                                        aADOAuthAuthenticationInstance2.setTenant(tenantInstance2);
                                    }
                                    
                                    JsonNode audienceValue2 = authenticationValue4.get("audience");
                                    if (audienceValue2 != null && audienceValue2 instanceof NullNode == false) {
                                        String audienceInstance2;
                                        audienceInstance2 = audienceValue2.getTextValue();
                                        aADOAuthAuthenticationInstance2.setAudience(audienceInstance2);
                                    }
                                    
                                    JsonNode clientIdValue2 = authenticationValue4.get("clientId");
                                    if (clientIdValue2 != null && clientIdValue2 instanceof NullNode == false) {
                                        String clientIdInstance2;
                                        clientIdInstance2 = clientIdValue2.getTextValue();
                                        aADOAuthAuthenticationInstance2.setClientId(clientIdInstance2);
                                    }
                                    
                                    JsonNode typeValue9 = authenticationValue4.get("type");
                                    if (typeValue9 != null && typeValue9 instanceof NullNode == false) {
                                        HttpAuthenticationType typeInstance9;
                                        typeInstance9 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue9.getTextValue());
                                        aADOAuthAuthenticationInstance2.setType(typeInstance9);
                                    }
                                    requestInstance2.setAuthentication(aADOAuthAuthenticationInstance2);
                                }
                                if ("Basic".equals(typeName2)) {
                                    BasicAuthentication basicAuthenticationInstance2 = new BasicAuthentication();
                                    
                                    JsonNode usernameValue2 = authenticationValue4.get("username");
                                    if (usernameValue2 != null && usernameValue2 instanceof NullNode == false) {
                                        String usernameInstance2;
                                        usernameInstance2 = usernameValue2.getTextValue();
                                        basicAuthenticationInstance2.setUsername(usernameInstance2);
                                    }
                                    
                                    JsonNode passwordValue4 = authenticationValue4.get("password");
                                    if (passwordValue4 != null && passwordValue4 instanceof NullNode == false) {
                                        String passwordInstance4;
                                        passwordInstance4 = passwordValue4.getTextValue();
                                        basicAuthenticationInstance2.setPassword(passwordInstance4);
                                    }
                                    
                                    JsonNode typeValue10 = authenticationValue4.get("type");
                                    if (typeValue10 != null && typeValue10 instanceof NullNode == false) {
                                        HttpAuthenticationType typeInstance10;
                                        typeInstance10 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue10.getTextValue());
                                        basicAuthenticationInstance2.setType(typeInstance10);
                                    }
                                    requestInstance2.setAuthentication(basicAuthenticationInstance2);
                                }
                            }
                        }
                        
                        JsonNode queueMessageValue2 = actionValue.get("queueMessage");
                        if (queueMessageValue2 != null && queueMessageValue2 instanceof NullNode == false) {
                            JobQueueMessage queueMessageInstance2 = new JobQueueMessage();
                            actionInstance.setQueueMessage(queueMessageInstance2);
                            
                            JsonNode storageAccountValue2 = queueMessageValue2.get("storageAccount");
                            if (storageAccountValue2 != null && storageAccountValue2 instanceof NullNode == false) {
                                String storageAccountInstance2;
                                storageAccountInstance2 = storageAccountValue2.getTextValue();
                                queueMessageInstance2.setStorageAccountName(storageAccountInstance2);
                            }
                            
                            JsonNode queueNameValue3 = queueMessageValue2.get("queueName");
                            if (queueNameValue3 != null && queueNameValue3 instanceof NullNode == false) {
                                String queueNameInstance3;
                                queueNameInstance3 = queueNameValue3.getTextValue();
                                queueMessageInstance2.setQueueName(queueNameInstance3);
                            }
                            
                            JsonNode sasTokenValue2 = queueMessageValue2.get("sasToken");
                            if (sasTokenValue2 != null && sasTokenValue2 instanceof NullNode == false) {
                                String sasTokenInstance2;
                                sasTokenInstance2 = sasTokenValue2.getTextValue();
                                queueMessageInstance2.setSasToken(sasTokenInstance2);
                            }
                            
                            JsonNode messageValue4 = queueMessageValue2.get("message");
                            if (messageValue4 != null && messageValue4 instanceof NullNode == false) {
                                String messageInstance4;
                                messageInstance4 = messageValue4.getTextValue();
                                queueMessageInstance2.setMessage(messageInstance4);
                            }
                        }
                        
                        JsonNode serviceBusTopicMessageValue2 = actionValue.get("serviceBusTopicMessage");
                        if (serviceBusTopicMessageValue2 != null && serviceBusTopicMessageValue2 instanceof NullNode == false) {
                            JobServiceBusTopicMessage serviceBusTopicMessageInstance2 = new JobServiceBusTopicMessage();
                            actionInstance.setServiceBusTopicMessage(serviceBusTopicMessageInstance2);
                            
                            JsonNode topicPathValue2 = serviceBusTopicMessageValue2.get("topicPath");
                            if (topicPathValue2 != null && topicPathValue2 instanceof NullNode == false) {
                                String topicPathInstance2;
                                topicPathInstance2 = topicPathValue2.getTextValue();
                                serviceBusTopicMessageInstance2.setTopicPath(topicPathInstance2);
                            }
                            
                            JsonNode namespaceValue3 = serviceBusTopicMessageValue2.get("namespace");
                            if (namespaceValue3 != null && namespaceValue3 instanceof NullNode == false) {
                                String namespaceInstance3;
                                namespaceInstance3 = namespaceValue3.getTextValue();
                                serviceBusTopicMessageInstance2.setNamespace(namespaceInstance3);
                            }
                            
                            JsonNode transportTypeValue3 = serviceBusTopicMessageValue2.get("transportType");
                            if (transportTypeValue3 != null && transportTypeValue3 instanceof NullNode == false) {
                                JobServiceBusTransportType transportTypeInstance3;
                                transportTypeInstance3 = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue3.getTextValue());
                                serviceBusTopicMessageInstance2.setTransportType(transportTypeInstance3);
                            }
                            
                            JsonNode authenticationValue5 = serviceBusTopicMessageValue2.get("authentication");
                            if (authenticationValue5 != null && authenticationValue5 instanceof NullNode == false) {
                                JobServiceBusAuthentication authenticationInstance3 = new JobServiceBusAuthentication();
                                serviceBusTopicMessageInstance2.setAuthentication(authenticationInstance3);
                                
                                JsonNode sasKeyNameValue3 = authenticationValue5.get("sasKeyName");
                                if (sasKeyNameValue3 != null && sasKeyNameValue3 instanceof NullNode == false) {
                                    String sasKeyNameInstance3;
                                    sasKeyNameInstance3 = sasKeyNameValue3.getTextValue();
                                    authenticationInstance3.setSasKeyName(sasKeyNameInstance3);
                                }
                                
                                JsonNode sasKeyValue3 = authenticationValue5.get("sasKey");
                                if (sasKeyValue3 != null && sasKeyValue3 instanceof NullNode == false) {
                                    String sasKeyInstance3;
                                    sasKeyInstance3 = sasKeyValue3.getTextValue();
                                    authenticationInstance3.setSasKey(sasKeyInstance3);
                                }
                                
                                JsonNode typeValue11 = authenticationValue5.get("type");
                                if (typeValue11 != null && typeValue11 instanceof NullNode == false) {
                                    JobServiceBusAuthenticationType typeInstance11;
                                    typeInstance11 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue11.getTextValue());
                                    authenticationInstance3.setType(typeInstance11);
                                }
                            }
                            
                            JsonNode messageValue5 = serviceBusTopicMessageValue2.get("message");
                            if (messageValue5 != null && messageValue5 instanceof NullNode == false) {
                                String messageInstance5;
                                messageInstance5 = messageValue5.getTextValue();
                                serviceBusTopicMessageInstance2.setMessage(messageInstance5);
                            }
                            
                            JsonNode brokeredMessagePropertiesValue3 = serviceBusTopicMessageValue2.get("brokeredMessageProperties");
                            if (brokeredMessagePropertiesValue3 != null && brokeredMessagePropertiesValue3 instanceof NullNode == false) {
                                JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance3 = new JobServiceBusBrokeredMessageProperties();
                                serviceBusTopicMessageInstance2.setBrokeredMessageProperties(brokeredMessagePropertiesInstance3);
                                
                                JsonNode contentTypeValue3 = brokeredMessagePropertiesValue3.get("contentType");
                                if (contentTypeValue3 != null && contentTypeValue3 instanceof NullNode == false) {
                                    String contentTypeInstance3;
                                    contentTypeInstance3 = contentTypeValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setContentType(contentTypeInstance3);
                                }
                                
                                JsonNode correlationIdValue3 = brokeredMessagePropertiesValue3.get("correlationId");
                                if (correlationIdValue3 != null && correlationIdValue3 instanceof NullNode == false) {
                                    String correlationIdInstance3;
                                    correlationIdInstance3 = correlationIdValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setCorrelationId(correlationIdInstance3);
                                }
                                
                                JsonNode forcePersistenceValue3 = brokeredMessagePropertiesValue3.get("forcePersistence");
                                if (forcePersistenceValue3 != null && forcePersistenceValue3 instanceof NullNode == false) {
                                    boolean forcePersistenceInstance3;
                                    forcePersistenceInstance3 = forcePersistenceValue3.getBooleanValue();
                                    brokeredMessagePropertiesInstance3.setForcePersistence(forcePersistenceInstance3);
                                }
                                
                                JsonNode labelValue3 = brokeredMessagePropertiesValue3.get("label");
                                if (labelValue3 != null && labelValue3 instanceof NullNode == false) {
                                    String labelInstance3;
                                    labelInstance3 = labelValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setLabel(labelInstance3);
                                }
                                
                                JsonNode messageIdValue3 = brokeredMessagePropertiesValue3.get("messageId");
                                if (messageIdValue3 != null && messageIdValue3 instanceof NullNode == false) {
                                    String messageIdInstance3;
                                    messageIdInstance3 = messageIdValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setMessageId(messageIdInstance3);
                                }
                                
                                JsonNode partitionKeyValue3 = brokeredMessagePropertiesValue3.get("partitionKey");
                                if (partitionKeyValue3 != null && partitionKeyValue3 instanceof NullNode == false) {
                                    String partitionKeyInstance3;
                                    partitionKeyInstance3 = partitionKeyValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setPartitionKey(partitionKeyInstance3);
                                }
                                
                                JsonNode replyToValue3 = brokeredMessagePropertiesValue3.get("replyTo");
                                if (replyToValue3 != null && replyToValue3 instanceof NullNode == false) {
                                    String replyToInstance3;
                                    replyToInstance3 = replyToValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setReplyTo(replyToInstance3);
                                }
                                
                                JsonNode replyToSessionIdValue3 = brokeredMessagePropertiesValue3.get("replyToSessionId");
                                if (replyToSessionIdValue3 != null && replyToSessionIdValue3 instanceof NullNode == false) {
                                    String replyToSessionIdInstance3;
                                    replyToSessionIdInstance3 = replyToSessionIdValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setReplyToSessionId(replyToSessionIdInstance3);
                                }
                                
                                JsonNode scheduledEnqueueTimeUtcValue3 = brokeredMessagePropertiesValue3.get("scheduledEnqueueTimeUtc");
                                if (scheduledEnqueueTimeUtcValue3 != null && scheduledEnqueueTimeUtcValue3 instanceof NullNode == false) {
                                    Calendar scheduledEnqueueTimeUtcInstance3;
                                    scheduledEnqueueTimeUtcInstance3 = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue3.getTextValue());
                                    brokeredMessagePropertiesInstance3.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance3);
                                }
                                
                                JsonNode sessionIdValue3 = brokeredMessagePropertiesValue3.get("sessionId");
                                if (sessionIdValue3 != null && sessionIdValue3 instanceof NullNode == false) {
                                    String sessionIdInstance3;
                                    sessionIdInstance3 = sessionIdValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setSessionId(sessionIdInstance3);
                                }
                                
                                JsonNode timeToLiveValue3 = brokeredMessagePropertiesValue3.get("timeToLive");
                                if (timeToLiveValue3 != null && timeToLiveValue3 instanceof NullNode == false) {
                                    Calendar timeToLiveInstance3;
                                    timeToLiveInstance3 = DatatypeConverter.parseDateTime(timeToLiveValue3.getTextValue());
                                    brokeredMessagePropertiesInstance3.setTimeToLive(timeToLiveInstance3);
                                }
                                
                                JsonNode toValue3 = brokeredMessagePropertiesValue3.get("to");
                                if (toValue3 != null && toValue3 instanceof NullNode == false) {
                                    String toInstance3;
                                    toInstance3 = toValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setTo(toInstance3);
                                }
                                
                                JsonNode viaPartitionKeyValue3 = brokeredMessagePropertiesValue3.get("viaPartitionKey");
                                if (viaPartitionKeyValue3 != null && viaPartitionKeyValue3 instanceof NullNode == false) {
                                    String viaPartitionKeyInstance3;
                                    viaPartitionKeyInstance3 = viaPartitionKeyValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setViaPartitionKey(viaPartitionKeyInstance3);
                                }
                            }
                            
                            JsonNode customMessagePropertiesSequenceElement3 = ((JsonNode) serviceBusTopicMessageValue2.get("customMessageProperties"));
                            if (customMessagePropertiesSequenceElement3 != null && customMessagePropertiesSequenceElement3 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr5 = customMessagePropertiesSequenceElement3.getFields();
                                while (itr5.hasNext()) {
                                    Map.Entry<String, JsonNode> property5 = itr5.next();
                                    String customMessagePropertiesKey3 = property5.getKey();
                                    String customMessagePropertiesValue3 = property5.getValue().getTextValue();
                                    serviceBusTopicMessageInstance2.getCustomMessageProperties().put(customMessagePropertiesKey3, customMessagePropertiesValue3);
                                }
                            }
                        }
                        
                        JsonNode serviceBusQueueMessageValue2 = actionValue.get("serviceBusQueueMessage");
                        if (serviceBusQueueMessageValue2 != null && serviceBusQueueMessageValue2 instanceof NullNode == false) {
                            JobServiceBusQueueMessage serviceBusQueueMessageInstance2 = new JobServiceBusQueueMessage();
                            actionInstance.setServiceBusQueueMessage(serviceBusQueueMessageInstance2);
                            
                            JsonNode queueNameValue4 = serviceBusQueueMessageValue2.get("queueName");
                            if (queueNameValue4 != null && queueNameValue4 instanceof NullNode == false) {
                                String queueNameInstance4;
                                queueNameInstance4 = queueNameValue4.getTextValue();
                                serviceBusQueueMessageInstance2.setQueueName(queueNameInstance4);
                            }
                            
                            JsonNode namespaceValue4 = serviceBusQueueMessageValue2.get("namespace");
                            if (namespaceValue4 != null && namespaceValue4 instanceof NullNode == false) {
                                String namespaceInstance4;
                                namespaceInstance4 = namespaceValue4.getTextValue();
                                serviceBusQueueMessageInstance2.setNamespace(namespaceInstance4);
                            }
                            
                            JsonNode transportTypeValue4 = serviceBusQueueMessageValue2.get("transportType");
                            if (transportTypeValue4 != null && transportTypeValue4 instanceof NullNode == false) {
                                JobServiceBusTransportType transportTypeInstance4;
                                transportTypeInstance4 = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue4.getTextValue());
                                serviceBusQueueMessageInstance2.setTransportType(transportTypeInstance4);
                            }
                            
                            JsonNode authenticationValue6 = serviceBusQueueMessageValue2.get("authentication");
                            if (authenticationValue6 != null && authenticationValue6 instanceof NullNode == false) {
                                JobServiceBusAuthentication authenticationInstance4 = new JobServiceBusAuthentication();
                                serviceBusQueueMessageInstance2.setAuthentication(authenticationInstance4);
                                
                                JsonNode sasKeyNameValue4 = authenticationValue6.get("sasKeyName");
                                if (sasKeyNameValue4 != null && sasKeyNameValue4 instanceof NullNode == false) {
                                    String sasKeyNameInstance4;
                                    sasKeyNameInstance4 = sasKeyNameValue4.getTextValue();
                                    authenticationInstance4.setSasKeyName(sasKeyNameInstance4);
                                }
                                
                                JsonNode sasKeyValue4 = authenticationValue6.get("sasKey");
                                if (sasKeyValue4 != null && sasKeyValue4 instanceof NullNode == false) {
                                    String sasKeyInstance4;
                                    sasKeyInstance4 = sasKeyValue4.getTextValue();
                                    authenticationInstance4.setSasKey(sasKeyInstance4);
                                }
                                
                                JsonNode typeValue12 = authenticationValue6.get("type");
                                if (typeValue12 != null && typeValue12 instanceof NullNode == false) {
                                    JobServiceBusAuthenticationType typeInstance12;
                                    typeInstance12 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue12.getTextValue());
                                    authenticationInstance4.setType(typeInstance12);
                                }
                            }
                            
                            JsonNode messageValue6 = serviceBusQueueMessageValue2.get("message");
                            if (messageValue6 != null && messageValue6 instanceof NullNode == false) {
                                String messageInstance6;
                                messageInstance6 = messageValue6.getTextValue();
                                serviceBusQueueMessageInstance2.setMessage(messageInstance6);
                            }
                            
                            JsonNode brokeredMessagePropertiesValue4 = serviceBusQueueMessageValue2.get("brokeredMessageProperties");
                            if (brokeredMessagePropertiesValue4 != null && brokeredMessagePropertiesValue4 instanceof NullNode == false) {
                                JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance4 = new JobServiceBusBrokeredMessageProperties();
                                serviceBusQueueMessageInstance2.setBrokeredMessageProperties(brokeredMessagePropertiesInstance4);
                                
                                JsonNode contentTypeValue4 = brokeredMessagePropertiesValue4.get("contentType");
                                if (contentTypeValue4 != null && contentTypeValue4 instanceof NullNode == false) {
                                    String contentTypeInstance4;
                                    contentTypeInstance4 = contentTypeValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setContentType(contentTypeInstance4);
                                }
                                
                                JsonNode correlationIdValue4 = brokeredMessagePropertiesValue4.get("correlationId");
                                if (correlationIdValue4 != null && correlationIdValue4 instanceof NullNode == false) {
                                    String correlationIdInstance4;
                                    correlationIdInstance4 = correlationIdValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setCorrelationId(correlationIdInstance4);
                                }
                                
                                JsonNode forcePersistenceValue4 = brokeredMessagePropertiesValue4.get("forcePersistence");
                                if (forcePersistenceValue4 != null && forcePersistenceValue4 instanceof NullNode == false) {
                                    boolean forcePersistenceInstance4;
                                    forcePersistenceInstance4 = forcePersistenceValue4.getBooleanValue();
                                    brokeredMessagePropertiesInstance4.setForcePersistence(forcePersistenceInstance4);
                                }
                                
                                JsonNode labelValue4 = brokeredMessagePropertiesValue4.get("label");
                                if (labelValue4 != null && labelValue4 instanceof NullNode == false) {
                                    String labelInstance4;
                                    labelInstance4 = labelValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setLabel(labelInstance4);
                                }
                                
                                JsonNode messageIdValue4 = brokeredMessagePropertiesValue4.get("messageId");
                                if (messageIdValue4 != null && messageIdValue4 instanceof NullNode == false) {
                                    String messageIdInstance4;
                                    messageIdInstance4 = messageIdValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setMessageId(messageIdInstance4);
                                }
                                
                                JsonNode partitionKeyValue4 = brokeredMessagePropertiesValue4.get("partitionKey");
                                if (partitionKeyValue4 != null && partitionKeyValue4 instanceof NullNode == false) {
                                    String partitionKeyInstance4;
                                    partitionKeyInstance4 = partitionKeyValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setPartitionKey(partitionKeyInstance4);
                                }
                                
                                JsonNode replyToValue4 = brokeredMessagePropertiesValue4.get("replyTo");
                                if (replyToValue4 != null && replyToValue4 instanceof NullNode == false) {
                                    String replyToInstance4;
                                    replyToInstance4 = replyToValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setReplyTo(replyToInstance4);
                                }
                                
                                JsonNode replyToSessionIdValue4 = brokeredMessagePropertiesValue4.get("replyToSessionId");
                                if (replyToSessionIdValue4 != null && replyToSessionIdValue4 instanceof NullNode == false) {
                                    String replyToSessionIdInstance4;
                                    replyToSessionIdInstance4 = replyToSessionIdValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setReplyToSessionId(replyToSessionIdInstance4);
                                }
                                
                                JsonNode scheduledEnqueueTimeUtcValue4 = brokeredMessagePropertiesValue4.get("scheduledEnqueueTimeUtc");
                                if (scheduledEnqueueTimeUtcValue4 != null && scheduledEnqueueTimeUtcValue4 instanceof NullNode == false) {
                                    Calendar scheduledEnqueueTimeUtcInstance4;
                                    scheduledEnqueueTimeUtcInstance4 = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue4.getTextValue());
                                    brokeredMessagePropertiesInstance4.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance4);
                                }
                                
                                JsonNode sessionIdValue4 = brokeredMessagePropertiesValue4.get("sessionId");
                                if (sessionIdValue4 != null && sessionIdValue4 instanceof NullNode == false) {
                                    String sessionIdInstance4;
                                    sessionIdInstance4 = sessionIdValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setSessionId(sessionIdInstance4);
                                }
                                
                                JsonNode timeToLiveValue4 = brokeredMessagePropertiesValue4.get("timeToLive");
                                if (timeToLiveValue4 != null && timeToLiveValue4 instanceof NullNode == false) {
                                    Calendar timeToLiveInstance4;
                                    timeToLiveInstance4 = DatatypeConverter.parseDateTime(timeToLiveValue4.getTextValue());
                                    brokeredMessagePropertiesInstance4.setTimeToLive(timeToLiveInstance4);
                                }
                                
                                JsonNode toValue4 = brokeredMessagePropertiesValue4.get("to");
                                if (toValue4 != null && toValue4 instanceof NullNode == false) {
                                    String toInstance4;
                                    toInstance4 = toValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setTo(toInstance4);
                                }
                                
                                JsonNode viaPartitionKeyValue4 = brokeredMessagePropertiesValue4.get("viaPartitionKey");
                                if (viaPartitionKeyValue4 != null && viaPartitionKeyValue4 instanceof NullNode == false) {
                                    String viaPartitionKeyInstance4;
                                    viaPartitionKeyInstance4 = viaPartitionKeyValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setViaPartitionKey(viaPartitionKeyInstance4);
                                }
                            }
                            
                            JsonNode customMessagePropertiesSequenceElement4 = ((JsonNode) serviceBusQueueMessageValue2.get("customMessageProperties"));
                            if (customMessagePropertiesSequenceElement4 != null && customMessagePropertiesSequenceElement4 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr6 = customMessagePropertiesSequenceElement4.getFields();
                                while (itr6.hasNext()) {
                                    Map.Entry<String, JsonNode> property6 = itr6.next();
                                    String customMessagePropertiesKey4 = property6.getKey();
                                    String customMessagePropertiesValue4 = property6.getValue().getTextValue();
                                    serviceBusQueueMessageInstance2.getCustomMessageProperties().put(customMessagePropertiesKey4, customMessagePropertiesValue4);
                                }
                            }
                        }
                    }
                    
                    JsonNode recurrenceValue = responseDoc.get("recurrence");
                    if (recurrenceValue != null && recurrenceValue instanceof NullNode == false) {
                        JobRecurrence recurrenceInstance = new JobRecurrence();
                        jobInstance.setRecurrence(recurrenceInstance);
                        
                        JsonNode frequencyValue = recurrenceValue.get("frequency");
                        if (frequencyValue != null && frequencyValue instanceof NullNode == false) {
                            JobRecurrenceFrequency frequencyInstance;
                            frequencyInstance = SchedulerClientImpl.parseJobRecurrenceFrequency(frequencyValue.getTextValue());
                            recurrenceInstance.setFrequency(frequencyInstance);
                        }
                        
                        JsonNode intervalValue = recurrenceValue.get("interval");
                        if (intervalValue != null && intervalValue instanceof NullNode == false) {
                            int intervalInstance;
                            intervalInstance = intervalValue.getIntValue();
                            recurrenceInstance.setInterval(intervalInstance);
                        }
                        
                        JsonNode countValue = recurrenceValue.get("count");
                        if (countValue != null && countValue instanceof NullNode == false) {
                            int countInstance;
                            countInstance = countValue.getIntValue();
                            recurrenceInstance.setCount(countInstance);
                        }
                        
                        JsonNode endTimeValue = recurrenceValue.get("endTime");
                        if (endTimeValue != null && endTimeValue instanceof NullNode == false) {
                            Calendar endTimeInstance;
                            endTimeInstance = DatatypeConverter.parseDateTime(endTimeValue.getTextValue());
                            recurrenceInstance.setEndTime(endTimeInstance);
                        }
                        
                        JsonNode scheduleValue = recurrenceValue.get("schedule");
                        if (scheduleValue != null && scheduleValue instanceof NullNode == false) {
                            JobRecurrenceSchedule scheduleInstance = new JobRecurrenceSchedule();
                            recurrenceInstance.setSchedule(scheduleInstance);
                            
                            JsonNode minutesArray = scheduleValue.get("minutes");
                            if (minutesArray != null && minutesArray instanceof NullNode == false) {
                                scheduleInstance.setMinutes(new ArrayList<Integer>());
                                for (JsonNode minutesValue : ((ArrayNode) minutesArray)) {
                                    scheduleInstance.getMinutes().add(minutesValue.getIntValue());
                                }
                            }
                            
                            JsonNode hoursArray = scheduleValue.get("hours");
                            if (hoursArray != null && hoursArray instanceof NullNode == false) {
                                scheduleInstance.setHours(new ArrayList<Integer>());
                                for (JsonNode hoursValue : ((ArrayNode) hoursArray)) {
                                    scheduleInstance.getHours().add(hoursValue.getIntValue());
                                }
                            }
                            
                            JsonNode weekDaysArray = scheduleValue.get("weekDays");
                            if (weekDaysArray != null && weekDaysArray instanceof NullNode == false) {
                                scheduleInstance.setDays(new ArrayList<JobScheduleDay>());
                                for (JsonNode weekDaysValue : ((ArrayNode) weekDaysArray)) {
                                    scheduleInstance.getDays().add(SchedulerClientImpl.parseJobScheduleDay(weekDaysValue.getTextValue()));
                                }
                            }
                            
                            JsonNode monthsArray = scheduleValue.get("months");
                            if (monthsArray != null && monthsArray instanceof NullNode == false) {
                                scheduleInstance.setMonths(new ArrayList<Integer>());
                                for (JsonNode monthsValue : ((ArrayNode) monthsArray)) {
                                    scheduleInstance.getMonths().add(monthsValue.getIntValue());
                                }
                            }
                            
                            JsonNode monthDaysArray = scheduleValue.get("monthDays");
                            if (monthDaysArray != null && monthDaysArray instanceof NullNode == false) {
                                scheduleInstance.setMonthDays(new ArrayList<Integer>());
                                for (JsonNode monthDaysValue : ((ArrayNode) monthDaysArray)) {
                                    scheduleInstance.getMonthDays().add(monthDaysValue.getIntValue());
                                }
                            }
                            
                            JsonNode monthlyOccurrencesArray = scheduleValue.get("monthlyOccurrences");
                            if (monthlyOccurrencesArray != null && monthlyOccurrencesArray instanceof NullNode == false) {
                                scheduleInstance.setMonthlyOccurrences(new ArrayList<JobScheduleMonthlyOccurrence>());
                                for (JsonNode monthlyOccurrencesValue : ((ArrayNode) monthlyOccurrencesArray)) {
                                    JobScheduleMonthlyOccurrence jobScheduleMonthlyOccurrenceInstance = new JobScheduleMonthlyOccurrence();
                                    scheduleInstance.getMonthlyOccurrences().add(jobScheduleMonthlyOccurrenceInstance);
                                    
                                    JsonNode dayValue = monthlyOccurrencesValue.get("day");
                                    if (dayValue != null && dayValue instanceof NullNode == false) {
                                        JobScheduleDay dayInstance;
                                        dayInstance = SchedulerClientImpl.parseJobScheduleDay(dayValue.getTextValue());
                                        jobScheduleMonthlyOccurrenceInstance.setDay(dayInstance);
                                    }
                                    
                                    JsonNode occurrenceValue = monthlyOccurrencesValue.get("occurrence");
                                    if (occurrenceValue != null && occurrenceValue instanceof NullNode == false) {
                                        int occurrenceInstance;
                                        occurrenceInstance = occurrenceValue.getIntValue();
                                        jobScheduleMonthlyOccurrenceInstance.setOccurrence(occurrenceInstance);
                                    }
                                }
                            }
                        }
                    }
                    
                    JsonNode statusValue = responseDoc.get("status");
                    if (statusValue != null && statusValue instanceof NullNode == false) {
                        JobStatus statusInstance = new JobStatus();
                        jobInstance.setStatus(statusInstance);
                        
                        JsonNode lastExecutionTimeValue = statusValue.get("lastExecutionTime");
                        if (lastExecutionTimeValue != null && lastExecutionTimeValue instanceof NullNode == false) {
                            Calendar lastExecutionTimeInstance;
                            lastExecutionTimeInstance = DatatypeConverter.parseDateTime(lastExecutionTimeValue.getTextValue());
                            statusInstance.setLastExecutionTime(lastExecutionTimeInstance);
                        }
                        
                        JsonNode nextExecutionTimeValue = statusValue.get("nextExecutionTime");
                        if (nextExecutionTimeValue != null && nextExecutionTimeValue instanceof NullNode == false) {
                            Calendar nextExecutionTimeInstance;
                            nextExecutionTimeInstance = DatatypeConverter.parseDateTime(nextExecutionTimeValue.getTextValue());
                            statusInstance.setNextExecutionTime(nextExecutionTimeInstance);
                        }
                        
                        JsonNode executionCountValue = statusValue.get("executionCount");
                        if (executionCountValue != null && executionCountValue instanceof NullNode == false) {
                            int executionCountInstance;
                            executionCountInstance = executionCountValue.getIntValue();
                            statusInstance.setExecutionCount(executionCountInstance);
                        }
                        
                        JsonNode failureCountValue = statusValue.get("failureCount");
                        if (failureCountValue != null && failureCountValue instanceof NullNode == false) {
                            int failureCountInstance;
                            failureCountInstance = failureCountValue.getIntValue();
                            statusInstance.setFailureCount(failureCountInstance);
                        }
                        
                        JsonNode faultedCountValue = statusValue.get("faultedCount");
                        if (faultedCountValue != null && faultedCountValue instanceof NullNode == false) {
                            int faultedCountInstance;
                            faultedCountInstance = faultedCountValue.getIntValue();
                            statusInstance.setFaultedCount(faultedCountInstance);
                        }
                    }
                    
                    JsonNode stateValue = responseDoc.get("state");
                    if (stateValue != null && stateValue instanceof NullNode == false) {
                        JobState stateInstance;
                        stateInstance = SchedulerClientImpl.parseJobState(stateValue.getTextValue());
                        jobInstance.setState(stateInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Get the execution history of a Job.
    *
    * @param jobId Required. Id of the job to get the history of.
    * @param parameters Required. Parameters supplied to the Get Job History
    * operation.
    * @return The Get Job History operation response.
    */
    @Override
    public Future<JobGetHistoryResponse> getHistoryAsync(final String jobId, final JobGetHistoryParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<JobGetHistoryResponse>() { 
            @Override
            public JobGetHistoryResponse call() throws Exception {
                return getHistory(jobId, parameters);
            }
         });
    }
    
    /**
    * Get the execution history of a Job.
    *
    * @param jobId Required. Id of the job to get the history of.
    * @param parameters Required. Parameters supplied to the Get Job History
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The Get Job History operation response.
    */
    @Override
    public JobGetHistoryResponse getHistory(String jobId, JobGetHistoryParameters parameters) throws IOException, ServiceException {
        // Validate
        if (jobId == null) {
            throw new NullPointerException("jobId");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("jobId", jobId);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "getHistoryAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/cloudservices/";
        url = url + URLEncoder.encode(this.getClient().getCloudServiceName(), "UTF-8");
        url = url + "/resources/";
        url = url + "scheduler";
        url = url + "/~/";
        url = url + "JobCollections";
        url = url + "/";
        url = url + URLEncoder.encode(this.getClient().getJobCollectionName(), "UTF-8");
        url = url + "/jobs/";
        url = url + URLEncoder.encode(jobId, "UTF-8");
        url = url + "/history";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (parameters.getSkip() != null) {
            queryParameters.add("$skip=" + URLEncoder.encode(Integer.toString(parameters.getSkip()), "UTF-8"));
        }
        if (parameters.getTop() != null) {
            queryParameters.add("$top=" + URLEncoder.encode(Integer.toString(parameters.getTop()), "UTF-8"));
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2013-03-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            JobGetHistoryResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new JobGetHistoryResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode jobHistoryArray = responseDoc;
                    if (jobHistoryArray != null && jobHistoryArray instanceof NullNode == false) {
                        for (JsonNode jobHistoryValue : ((ArrayNode) jobHistoryArray)) {
                            JobGetHistoryResponse.JobHistoryEntry jobHistoryEntryInstance = new JobGetHistoryResponse.JobHistoryEntry();
                            result.getJobHistory().add(jobHistoryEntryInstance);
                            
                            JsonNode jobIdValue = jobHistoryValue.get("jobId");
                            if (jobIdValue != null && jobIdValue instanceof NullNode == false) {
                                String jobIdInstance;
                                jobIdInstance = jobIdValue.getTextValue();
                                jobHistoryEntryInstance.setId(jobIdInstance);
                            }
                            
                            JsonNode timestampValue = jobHistoryValue.get("timestamp");
                            if (timestampValue != null && timestampValue instanceof NullNode == false) {
                                Calendar timestampInstance;
                                timestampInstance = DatatypeConverter.parseDateTime(timestampValue.getTextValue());
                                jobHistoryEntryInstance.setTimestamp(timestampInstance);
                            }
                            
                            JsonNode startTimeValue = jobHistoryValue.get("startTime");
                            if (startTimeValue != null && startTimeValue instanceof NullNode == false) {
                                Calendar startTimeInstance;
                                startTimeInstance = DatatypeConverter.parseDateTime(startTimeValue.getTextValue());
                                jobHistoryEntryInstance.setStartTime(startTimeInstance);
                            }
                            
                            JsonNode endTimeValue = jobHistoryValue.get("endTime");
                            if (endTimeValue != null && endTimeValue instanceof NullNode == false) {
                                Calendar endTimeInstance;
                                endTimeInstance = DatatypeConverter.parseDateTime(endTimeValue.getTextValue());
                                jobHistoryEntryInstance.setEndTime(endTimeInstance);
                            }
                            
                            JsonNode stateValue = jobHistoryValue.get("state");
                            if (stateValue != null && stateValue instanceof NullNode == false) {
                                JobState stateInstance;
                                stateInstance = SchedulerClientImpl.parseJobState(stateValue.getTextValue());
                                jobHistoryEntryInstance.setState(stateInstance);
                            }
                            
                            JsonNode messageValue = jobHistoryValue.get("message");
                            if (messageValue != null && messageValue instanceof NullNode == false) {
                                String messageInstance;
                                messageInstance = messageValue.getTextValue();
                                jobHistoryEntryInstance.setMessage(messageInstance);
                            }
                            
                            JsonNode statusValue = jobHistoryValue.get("status");
                            if (statusValue != null && statusValue instanceof NullNode == false) {
                                JobHistoryStatus statusInstance;
                                statusInstance = SchedulerClientImpl.parseJobHistoryStatus(statusValue.getTextValue());
                                jobHistoryEntryInstance.setStatus(statusInstance);
                            }
                            
                            JsonNode actionNameValue = jobHistoryValue.get("actionName");
                            if (actionNameValue != null && actionNameValue instanceof NullNode == false) {
                                JobHistoryActionName actionNameInstance;
                                actionNameInstance = SchedulerClientImpl.parseJobHistoryActionName(actionNameValue.getTextValue());
                                jobHistoryEntryInstance.setActionName(actionNameInstance);
                            }
                            
                            JsonNode repeatCountValue = jobHistoryValue.get("repeatCount");
                            if (repeatCountValue != null && repeatCountValue instanceof NullNode == false) {
                                int repeatCountInstance;
                                repeatCountInstance = repeatCountValue.getIntValue();
                                jobHistoryEntryInstance.setRepeatCount(repeatCountInstance);
                            }
                            
                            JsonNode retryCountValue = jobHistoryValue.get("retryCount");
                            if (retryCountValue != null && retryCountValue instanceof NullNode == false) {
                                int retryCountInstance;
                                retryCountInstance = retryCountValue.getIntValue();
                                jobHistoryEntryInstance.setRetryCount(retryCountInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Get the execution history of a Job with a filter on the job Status.
    *
    * @param jobId Required. Id of the job to get the history of.
    * @param parameters Required. Parameters supplied to the Get Job History
    * With Filter operation.
    * @return The Get Job History operation response.
    */
    @Override
    public Future<JobGetHistoryResponse> getHistoryWithFilterAsync(final String jobId, final JobGetHistoryWithFilterParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<JobGetHistoryResponse>() { 
            @Override
            public JobGetHistoryResponse call() throws Exception {
                return getHistoryWithFilter(jobId, parameters);
            }
         });
    }
    
    /**
    * Get the execution history of a Job with a filter on the job Status.
    *
    * @param jobId Required. Id of the job to get the history of.
    * @param parameters Required. Parameters supplied to the Get Job History
    * With Filter operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The Get Job History operation response.
    */
    @Override
    public JobGetHistoryResponse getHistoryWithFilter(String jobId, JobGetHistoryWithFilterParameters parameters) throws IOException, ServiceException {
        // Validate
        if (jobId == null) {
            throw new NullPointerException("jobId");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getStatus() == null) {
            throw new NullPointerException("parameters.Status");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("jobId", jobId);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "getHistoryWithFilterAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/cloudservices/";
        url = url + URLEncoder.encode(this.getClient().getCloudServiceName(), "UTF-8");
        url = url + "/resources/";
        url = url + "scheduler";
        url = url + "/~/";
        url = url + "JobCollections";
        url = url + "/";
        url = url + URLEncoder.encode(this.getClient().getJobCollectionName(), "UTF-8");
        url = url + "/jobs/";
        url = url + URLEncoder.encode(jobId, "UTF-8");
        url = url + "/history";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        ArrayList<String> odataFilter = new ArrayList<String>();
        odataFilter.add("status eq " + URLEncoder.encode(SchedulerClientImpl.jobHistoryStatusToString(parameters.getStatus()), "UTF-8"));
        if (odataFilter.size() > 0) {
            queryParameters.add("$filter=" + CollectionStringBuilder.join(odataFilter, null));
        }
        if (parameters.getSkip() != null) {
            queryParameters.add("$skip=" + URLEncoder.encode(Integer.toString(parameters.getSkip()), "UTF-8"));
        }
        if (parameters.getTop() != null) {
            queryParameters.add("$top=" + URLEncoder.encode(Integer.toString(parameters.getTop()), "UTF-8"));
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2013-03-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            JobGetHistoryResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new JobGetHistoryResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode jobHistoryArray = responseDoc;
                    if (jobHistoryArray != null && jobHistoryArray instanceof NullNode == false) {
                        for (JsonNode jobHistoryValue : ((ArrayNode) jobHistoryArray)) {
                            JobGetHistoryResponse.JobHistoryEntry jobHistoryEntryInstance = new JobGetHistoryResponse.JobHistoryEntry();
                            result.getJobHistory().add(jobHistoryEntryInstance);
                            
                            JsonNode jobIdValue = jobHistoryValue.get("jobId");
                            if (jobIdValue != null && jobIdValue instanceof NullNode == false) {
                                String jobIdInstance;
                                jobIdInstance = jobIdValue.getTextValue();
                                jobHistoryEntryInstance.setId(jobIdInstance);
                            }
                            
                            JsonNode timestampValue = jobHistoryValue.get("timestamp");
                            if (timestampValue != null && timestampValue instanceof NullNode == false) {
                                Calendar timestampInstance;
                                timestampInstance = DatatypeConverter.parseDateTime(timestampValue.getTextValue());
                                jobHistoryEntryInstance.setTimestamp(timestampInstance);
                            }
                            
                            JsonNode startTimeValue = jobHistoryValue.get("startTime");
                            if (startTimeValue != null && startTimeValue instanceof NullNode == false) {
                                Calendar startTimeInstance;
                                startTimeInstance = DatatypeConverter.parseDateTime(startTimeValue.getTextValue());
                                jobHistoryEntryInstance.setStartTime(startTimeInstance);
                            }
                            
                            JsonNode endTimeValue = jobHistoryValue.get("endTime");
                            if (endTimeValue != null && endTimeValue instanceof NullNode == false) {
                                Calendar endTimeInstance;
                                endTimeInstance = DatatypeConverter.parseDateTime(endTimeValue.getTextValue());
                                jobHistoryEntryInstance.setEndTime(endTimeInstance);
                            }
                            
                            JsonNode stateValue = jobHistoryValue.get("state");
                            if (stateValue != null && stateValue instanceof NullNode == false) {
                                JobState stateInstance;
                                stateInstance = SchedulerClientImpl.parseJobState(stateValue.getTextValue());
                                jobHistoryEntryInstance.setState(stateInstance);
                            }
                            
                            JsonNode messageValue = jobHistoryValue.get("message");
                            if (messageValue != null && messageValue instanceof NullNode == false) {
                                String messageInstance;
                                messageInstance = messageValue.getTextValue();
                                jobHistoryEntryInstance.setMessage(messageInstance);
                            }
                            
                            JsonNode statusValue = jobHistoryValue.get("status");
                            if (statusValue != null && statusValue instanceof NullNode == false) {
                                JobHistoryStatus statusInstance;
                                statusInstance = SchedulerClientImpl.parseJobHistoryStatus(statusValue.getTextValue());
                                jobHistoryEntryInstance.setStatus(statusInstance);
                            }
                            
                            JsonNode actionNameValue = jobHistoryValue.get("actionName");
                            if (actionNameValue != null && actionNameValue instanceof NullNode == false) {
                                JobHistoryActionName actionNameInstance;
                                actionNameInstance = SchedulerClientImpl.parseJobHistoryActionName(actionNameValue.getTextValue());
                                jobHistoryEntryInstance.setActionName(actionNameInstance);
                            }
                            
                            JsonNode repeatCountValue = jobHistoryValue.get("repeatCount");
                            if (repeatCountValue != null && repeatCountValue instanceof NullNode == false) {
                                int repeatCountInstance;
                                repeatCountInstance = repeatCountValue.getIntValue();
                                jobHistoryEntryInstance.setRepeatCount(repeatCountInstance);
                            }
                            
                            JsonNode retryCountValue = jobHistoryValue.get("retryCount");
                            if (retryCountValue != null && retryCountValue instanceof NullNode == false) {
                                int retryCountInstance;
                                retryCountInstance = retryCountValue.getIntValue();
                                jobHistoryEntryInstance.setRetryCount(retryCountInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Get the list of all jobs in a job collection.
    *
    * @param parameters Required. Parameters supplied to the List Jobs
    * operation.
    * @return The List Jobs operation response.
    */
    @Override
    public Future<JobListResponse> listAsync(final JobListParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<JobListResponse>() { 
            @Override
            public JobListResponse call() throws Exception {
                return list(parameters);
            }
         });
    }
    
    /**
    * Get the list of all jobs in a job collection.
    *
    * @param parameters Required. Parameters supplied to the List Jobs
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The List Jobs operation response.
    */
    @Override
    public JobListResponse list(JobListParameters parameters) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/cloudservices/";
        url = url + URLEncoder.encode(this.getClient().getCloudServiceName(), "UTF-8");
        url = url + "/resources/";
        url = url + "scheduler";
        url = url + "/~/";
        url = url + "JobCollections";
        url = url + "/";
        url = url + URLEncoder.encode(this.getClient().getJobCollectionName(), "UTF-8");
        url = url + "/jobs";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (parameters.getSkip() != null) {
            queryParameters.add("$skip=" + URLEncoder.encode(Integer.toString(parameters.getSkip()), "UTF-8"));
        }
        if (parameters.getTop() != null) {
            queryParameters.add("$top=" + URLEncoder.encode(Integer.toString(parameters.getTop()), "UTF-8"));
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2013-03-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            JobListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new JobListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode jobsArray = responseDoc;
                    if (jobsArray != null && jobsArray instanceof NullNode == false) {
                        for (JsonNode jobsValue : ((ArrayNode) jobsArray)) {
                            Job jobInstance = new Job();
                            result.getJobs().add(jobInstance);
                            
                            JsonNode idValue = jobsValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                jobInstance.setId(idInstance);
                            }
                            
                            JsonNode startTimeValue = jobsValue.get("startTime");
                            if (startTimeValue != null && startTimeValue instanceof NullNode == false) {
                                Calendar startTimeInstance;
                                startTimeInstance = DatatypeConverter.parseDateTime(startTimeValue.getTextValue());
                                jobInstance.setStartTime(startTimeInstance);
                            }
                            
                            JsonNode actionValue = jobsValue.get("action");
                            if (actionValue != null && actionValue instanceof NullNode == false) {
                                JobAction actionInstance = new JobAction();
                                jobInstance.setAction(actionInstance);
                                
                                JsonNode typeValue = actionValue.get("type");
                                if (typeValue != null && typeValue instanceof NullNode == false) {
                                    JobActionType typeInstance;
                                    typeInstance = SchedulerClientImpl.parseJobActionType(typeValue.getTextValue());
                                    actionInstance.setType(typeInstance);
                                }
                                
                                JsonNode retryPolicyValue = actionValue.get("retryPolicy");
                                if (retryPolicyValue != null && retryPolicyValue instanceof NullNode == false) {
                                    RetryPolicy retryPolicyInstance = new RetryPolicy();
                                    actionInstance.setRetryPolicy(retryPolicyInstance);
                                    
                                    JsonNode retryTypeValue = retryPolicyValue.get("retryType");
                                    if (retryTypeValue != null && retryTypeValue instanceof NullNode == false) {
                                        RetryType retryTypeInstance;
                                        retryTypeInstance = SchedulerClientImpl.parseRetryType(retryTypeValue.getTextValue());
                                        retryPolicyInstance.setRetryType(retryTypeInstance);
                                    }
                                    
                                    JsonNode retryIntervalValue = retryPolicyValue.get("retryInterval");
                                    if (retryIntervalValue != null && retryIntervalValue instanceof NullNode == false) {
                                        Duration retryIntervalInstance;
                                        retryIntervalInstance = TimeSpan8601Converter.parse(retryIntervalValue.getTextValue());
                                        retryPolicyInstance.setRetryInterval(retryIntervalInstance);
                                    }
                                    
                                    JsonNode retryCountValue = retryPolicyValue.get("retryCount");
                                    if (retryCountValue != null && retryCountValue instanceof NullNode == false) {
                                        int retryCountInstance;
                                        retryCountInstance = retryCountValue.getIntValue();
                                        retryPolicyInstance.setRetryCount(retryCountInstance);
                                    }
                                }
                                
                                JsonNode errorActionValue = actionValue.get("errorAction");
                                if (errorActionValue != null && errorActionValue instanceof NullNode == false) {
                                    JobErrorAction errorActionInstance = new JobErrorAction();
                                    actionInstance.setErrorAction(errorActionInstance);
                                    
                                    JsonNode typeValue2 = errorActionValue.get("type");
                                    if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                        JobActionType typeInstance2;
                                        typeInstance2 = SchedulerClientImpl.parseJobActionType(typeValue2.getTextValue());
                                        errorActionInstance.setType(typeInstance2);
                                    }
                                    
                                    JsonNode requestValue = errorActionValue.get("request");
                                    if (requestValue != null && requestValue instanceof NullNode == false) {
                                        JobHttpRequest requestInstance = new JobHttpRequest();
                                        errorActionInstance.setRequest(requestInstance);
                                        
                                        JsonNode uriValue = requestValue.get("uri");
                                        if (uriValue != null && uriValue instanceof NullNode == false) {
                                            URI uriInstance;
                                            uriInstance = new URI(uriValue.getTextValue());
                                            requestInstance.setUri(uriInstance);
                                        }
                                        
                                        JsonNode methodValue = requestValue.get("method");
                                        if (methodValue != null && methodValue instanceof NullNode == false) {
                                            String methodInstance;
                                            methodInstance = methodValue.getTextValue();
                                            requestInstance.setMethod(methodInstance);
                                        }
                                        
                                        JsonNode headersSequenceElement = ((JsonNode) requestValue.get("headers"));
                                        if (headersSequenceElement != null && headersSequenceElement instanceof NullNode == false) {
                                            Iterator<Map.Entry<String, JsonNode>> itr = headersSequenceElement.getFields();
                                            while (itr.hasNext()) {
                                                Map.Entry<String, JsonNode> property = itr.next();
                                                String headersKey = property.getKey();
                                                String headersValue = property.getValue().getTextValue();
                                                requestInstance.getHeaders().put(headersKey, headersValue);
                                            }
                                        }
                                        
                                        JsonNode bodyValue = requestValue.get("body");
                                        if (bodyValue != null && bodyValue instanceof NullNode == false) {
                                            String bodyInstance;
                                            bodyInstance = bodyValue.getTextValue();
                                            requestInstance.setBody(bodyInstance);
                                        }
                                        
                                        JsonNode authenticationValue = requestValue.get("authentication");
                                        if (authenticationValue != null && authenticationValue instanceof NullNode == false) {
                                            String typeName = authenticationValue.get("type").getTextValue();
                                            if ("ClientCertificate".equals(typeName)) {
                                                ClientCertAuthentication clientCertAuthenticationInstance = new ClientCertAuthentication();
                                                
                                                JsonNode passwordValue = authenticationValue.get("password");
                                                if (passwordValue != null && passwordValue instanceof NullNode == false) {
                                                    String passwordInstance;
                                                    passwordInstance = passwordValue.getTextValue();
                                                    clientCertAuthenticationInstance.setPassword(passwordInstance);
                                                }
                                                
                                                JsonNode pfxValue = authenticationValue.get("pfx");
                                                if (pfxValue != null && pfxValue instanceof NullNode == false) {
                                                    String pfxInstance;
                                                    pfxInstance = pfxValue.getTextValue();
                                                    clientCertAuthenticationInstance.setPfx(pfxInstance);
                                                }
                                                
                                                JsonNode certificateThumbprintValue = authenticationValue.get("certificateThumbprint");
                                                if (certificateThumbprintValue != null && certificateThumbprintValue instanceof NullNode == false) {
                                                    String certificateThumbprintInstance;
                                                    certificateThumbprintInstance = certificateThumbprintValue.getTextValue();
                                                    clientCertAuthenticationInstance.setCertificateThumbprint(certificateThumbprintInstance);
                                                }
                                                
                                                JsonNode certificateExpirationValue = authenticationValue.get("certificateExpiration");
                                                if (certificateExpirationValue != null && certificateExpirationValue instanceof NullNode == false) {
                                                    Calendar certificateExpirationInstance;
                                                    certificateExpirationInstance = DatatypeConverter.parseDateTime(certificateExpirationValue.getTextValue());
                                                    clientCertAuthenticationInstance.setCertificateExpiration(certificateExpirationInstance);
                                                }
                                                
                                                JsonNode certificateSubjectNameValue = authenticationValue.get("certificateSubjectName");
                                                if (certificateSubjectNameValue != null && certificateSubjectNameValue instanceof NullNode == false) {
                                                    String certificateSubjectNameInstance;
                                                    certificateSubjectNameInstance = certificateSubjectNameValue.getTextValue();
                                                    clientCertAuthenticationInstance.setCertificateSubjectName(certificateSubjectNameInstance);
                                                }
                                                
                                                JsonNode typeValue3 = authenticationValue.get("type");
                                                if (typeValue3 != null && typeValue3 instanceof NullNode == false) {
                                                    HttpAuthenticationType typeInstance3;
                                                    typeInstance3 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue3.getTextValue());
                                                    clientCertAuthenticationInstance.setType(typeInstance3);
                                                }
                                                requestInstance.setAuthentication(clientCertAuthenticationInstance);
                                            }
                                            if ("ActiveDirectoryOAuth".equals(typeName)) {
                                                AADOAuthAuthentication aADOAuthAuthenticationInstance = new AADOAuthAuthentication();
                                                
                                                JsonNode secretValue = authenticationValue.get("secret");
                                                if (secretValue != null && secretValue instanceof NullNode == false) {
                                                    String secretInstance;
                                                    secretInstance = secretValue.getTextValue();
                                                    aADOAuthAuthenticationInstance.setSecret(secretInstance);
                                                }
                                                
                                                JsonNode tenantValue = authenticationValue.get("tenant");
                                                if (tenantValue != null && tenantValue instanceof NullNode == false) {
                                                    String tenantInstance;
                                                    tenantInstance = tenantValue.getTextValue();
                                                    aADOAuthAuthenticationInstance.setTenant(tenantInstance);
                                                }
                                                
                                                JsonNode audienceValue = authenticationValue.get("audience");
                                                if (audienceValue != null && audienceValue instanceof NullNode == false) {
                                                    String audienceInstance;
                                                    audienceInstance = audienceValue.getTextValue();
                                                    aADOAuthAuthenticationInstance.setAudience(audienceInstance);
                                                }
                                                
                                                JsonNode clientIdValue = authenticationValue.get("clientId");
                                                if (clientIdValue != null && clientIdValue instanceof NullNode == false) {
                                                    String clientIdInstance;
                                                    clientIdInstance = clientIdValue.getTextValue();
                                                    aADOAuthAuthenticationInstance.setClientId(clientIdInstance);
                                                }
                                                
                                                JsonNode typeValue4 = authenticationValue.get("type");
                                                if (typeValue4 != null && typeValue4 instanceof NullNode == false) {
                                                    HttpAuthenticationType typeInstance4;
                                                    typeInstance4 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue4.getTextValue());
                                                    aADOAuthAuthenticationInstance.setType(typeInstance4);
                                                }
                                                requestInstance.setAuthentication(aADOAuthAuthenticationInstance);
                                            }
                                            if ("Basic".equals(typeName)) {
                                                BasicAuthentication basicAuthenticationInstance = new BasicAuthentication();
                                                
                                                JsonNode usernameValue = authenticationValue.get("username");
                                                if (usernameValue != null && usernameValue instanceof NullNode == false) {
                                                    String usernameInstance;
                                                    usernameInstance = usernameValue.getTextValue();
                                                    basicAuthenticationInstance.setUsername(usernameInstance);
                                                }
                                                
                                                JsonNode passwordValue2 = authenticationValue.get("password");
                                                if (passwordValue2 != null && passwordValue2 instanceof NullNode == false) {
                                                    String passwordInstance2;
                                                    passwordInstance2 = passwordValue2.getTextValue();
                                                    basicAuthenticationInstance.setPassword(passwordInstance2);
                                                }
                                                
                                                JsonNode typeValue5 = authenticationValue.get("type");
                                                if (typeValue5 != null && typeValue5 instanceof NullNode == false) {
                                                    HttpAuthenticationType typeInstance5;
                                                    typeInstance5 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue5.getTextValue());
                                                    basicAuthenticationInstance.setType(typeInstance5);
                                                }
                                                requestInstance.setAuthentication(basicAuthenticationInstance);
                                            }
                                        }
                                    }
                                    
                                    JsonNode queueMessageValue = errorActionValue.get("queueMessage");
                                    if (queueMessageValue != null && queueMessageValue instanceof NullNode == false) {
                                        JobQueueMessage queueMessageInstance = new JobQueueMessage();
                                        errorActionInstance.setQueueMessage(queueMessageInstance);
                                        
                                        JsonNode storageAccountValue = queueMessageValue.get("storageAccount");
                                        if (storageAccountValue != null && storageAccountValue instanceof NullNode == false) {
                                            String storageAccountInstance;
                                            storageAccountInstance = storageAccountValue.getTextValue();
                                            queueMessageInstance.setStorageAccountName(storageAccountInstance);
                                        }
                                        
                                        JsonNode queueNameValue = queueMessageValue.get("queueName");
                                        if (queueNameValue != null && queueNameValue instanceof NullNode == false) {
                                            String queueNameInstance;
                                            queueNameInstance = queueNameValue.getTextValue();
                                            queueMessageInstance.setQueueName(queueNameInstance);
                                        }
                                        
                                        JsonNode sasTokenValue = queueMessageValue.get("sasToken");
                                        if (sasTokenValue != null && sasTokenValue instanceof NullNode == false) {
                                            String sasTokenInstance;
                                            sasTokenInstance = sasTokenValue.getTextValue();
                                            queueMessageInstance.setSasToken(sasTokenInstance);
                                        }
                                        
                                        JsonNode messageValue = queueMessageValue.get("message");
                                        if (messageValue != null && messageValue instanceof NullNode == false) {
                                            String messageInstance;
                                            messageInstance = messageValue.getTextValue();
                                            queueMessageInstance.setMessage(messageInstance);
                                        }
                                    }
                                    
                                    JsonNode serviceBusTopicMessageValue = errorActionValue.get("serviceBusTopicMessage");
                                    if (serviceBusTopicMessageValue != null && serviceBusTopicMessageValue instanceof NullNode == false) {
                                        JobServiceBusTopicMessage serviceBusTopicMessageInstance = new JobServiceBusTopicMessage();
                                        errorActionInstance.setServiceBusTopicMessage(serviceBusTopicMessageInstance);
                                        
                                        JsonNode topicPathValue = serviceBusTopicMessageValue.get("topicPath");
                                        if (topicPathValue != null && topicPathValue instanceof NullNode == false) {
                                            String topicPathInstance;
                                            topicPathInstance = topicPathValue.getTextValue();
                                            serviceBusTopicMessageInstance.setTopicPath(topicPathInstance);
                                        }
                                        
                                        JsonNode namespaceValue = serviceBusTopicMessageValue.get("namespace");
                                        if (namespaceValue != null && namespaceValue instanceof NullNode == false) {
                                            String namespaceInstance;
                                            namespaceInstance = namespaceValue.getTextValue();
                                            serviceBusTopicMessageInstance.setNamespace(namespaceInstance);
                                        }
                                        
                                        JsonNode transportTypeValue = serviceBusTopicMessageValue.get("transportType");
                                        if (transportTypeValue != null && transportTypeValue instanceof NullNode == false) {
                                            JobServiceBusTransportType transportTypeInstance;
                                            transportTypeInstance = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue.getTextValue());
                                            serviceBusTopicMessageInstance.setTransportType(transportTypeInstance);
                                        }
                                        
                                        JsonNode authenticationValue2 = serviceBusTopicMessageValue.get("authentication");
                                        if (authenticationValue2 != null && authenticationValue2 instanceof NullNode == false) {
                                            JobServiceBusAuthentication authenticationInstance = new JobServiceBusAuthentication();
                                            serviceBusTopicMessageInstance.setAuthentication(authenticationInstance);
                                            
                                            JsonNode sasKeyNameValue = authenticationValue2.get("sasKeyName");
                                            if (sasKeyNameValue != null && sasKeyNameValue instanceof NullNode == false) {
                                                String sasKeyNameInstance;
                                                sasKeyNameInstance = sasKeyNameValue.getTextValue();
                                                authenticationInstance.setSasKeyName(sasKeyNameInstance);
                                            }
                                            
                                            JsonNode sasKeyValue = authenticationValue2.get("sasKey");
                                            if (sasKeyValue != null && sasKeyValue instanceof NullNode == false) {
                                                String sasKeyInstance;
                                                sasKeyInstance = sasKeyValue.getTextValue();
                                                authenticationInstance.setSasKey(sasKeyInstance);
                                            }
                                            
                                            JsonNode typeValue6 = authenticationValue2.get("type");
                                            if (typeValue6 != null && typeValue6 instanceof NullNode == false) {
                                                JobServiceBusAuthenticationType typeInstance6;
                                                typeInstance6 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue6.getTextValue());
                                                authenticationInstance.setType(typeInstance6);
                                            }
                                        }
                                        
                                        JsonNode messageValue2 = serviceBusTopicMessageValue.get("message");
                                        if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                            String messageInstance2;
                                            messageInstance2 = messageValue2.getTextValue();
                                            serviceBusTopicMessageInstance.setMessage(messageInstance2);
                                        }
                                        
                                        JsonNode brokeredMessagePropertiesValue = serviceBusTopicMessageValue.get("brokeredMessageProperties");
                                        if (brokeredMessagePropertiesValue != null && brokeredMessagePropertiesValue instanceof NullNode == false) {
                                            JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance = new JobServiceBusBrokeredMessageProperties();
                                            serviceBusTopicMessageInstance.setBrokeredMessageProperties(brokeredMessagePropertiesInstance);
                                            
                                            JsonNode contentTypeValue = brokeredMessagePropertiesValue.get("contentType");
                                            if (contentTypeValue != null && contentTypeValue instanceof NullNode == false) {
                                                String contentTypeInstance;
                                                contentTypeInstance = contentTypeValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setContentType(contentTypeInstance);
                                            }
                                            
                                            JsonNode correlationIdValue = brokeredMessagePropertiesValue.get("correlationId");
                                            if (correlationIdValue != null && correlationIdValue instanceof NullNode == false) {
                                                String correlationIdInstance;
                                                correlationIdInstance = correlationIdValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setCorrelationId(correlationIdInstance);
                                            }
                                            
                                            JsonNode forcePersistenceValue = brokeredMessagePropertiesValue.get("forcePersistence");
                                            if (forcePersistenceValue != null && forcePersistenceValue instanceof NullNode == false) {
                                                boolean forcePersistenceInstance;
                                                forcePersistenceInstance = forcePersistenceValue.getBooleanValue();
                                                brokeredMessagePropertiesInstance.setForcePersistence(forcePersistenceInstance);
                                            }
                                            
                                            JsonNode labelValue = brokeredMessagePropertiesValue.get("label");
                                            if (labelValue != null && labelValue instanceof NullNode == false) {
                                                String labelInstance;
                                                labelInstance = labelValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setLabel(labelInstance);
                                            }
                                            
                                            JsonNode messageIdValue = brokeredMessagePropertiesValue.get("messageId");
                                            if (messageIdValue != null && messageIdValue instanceof NullNode == false) {
                                                String messageIdInstance;
                                                messageIdInstance = messageIdValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setMessageId(messageIdInstance);
                                            }
                                            
                                            JsonNode partitionKeyValue = brokeredMessagePropertiesValue.get("partitionKey");
                                            if (partitionKeyValue != null && partitionKeyValue instanceof NullNode == false) {
                                                String partitionKeyInstance;
                                                partitionKeyInstance = partitionKeyValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setPartitionKey(partitionKeyInstance);
                                            }
                                            
                                            JsonNode replyToValue = brokeredMessagePropertiesValue.get("replyTo");
                                            if (replyToValue != null && replyToValue instanceof NullNode == false) {
                                                String replyToInstance;
                                                replyToInstance = replyToValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setReplyTo(replyToInstance);
                                            }
                                            
                                            JsonNode replyToSessionIdValue = brokeredMessagePropertiesValue.get("replyToSessionId");
                                            if (replyToSessionIdValue != null && replyToSessionIdValue instanceof NullNode == false) {
                                                String replyToSessionIdInstance;
                                                replyToSessionIdInstance = replyToSessionIdValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setReplyToSessionId(replyToSessionIdInstance);
                                            }
                                            
                                            JsonNode scheduledEnqueueTimeUtcValue = brokeredMessagePropertiesValue.get("scheduledEnqueueTimeUtc");
                                            if (scheduledEnqueueTimeUtcValue != null && scheduledEnqueueTimeUtcValue instanceof NullNode == false) {
                                                Calendar scheduledEnqueueTimeUtcInstance;
                                                scheduledEnqueueTimeUtcInstance = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue.getTextValue());
                                                brokeredMessagePropertiesInstance.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance);
                                            }
                                            
                                            JsonNode sessionIdValue = brokeredMessagePropertiesValue.get("sessionId");
                                            if (sessionIdValue != null && sessionIdValue instanceof NullNode == false) {
                                                String sessionIdInstance;
                                                sessionIdInstance = sessionIdValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setSessionId(sessionIdInstance);
                                            }
                                            
                                            JsonNode timeToLiveValue = brokeredMessagePropertiesValue.get("timeToLive");
                                            if (timeToLiveValue != null && timeToLiveValue instanceof NullNode == false) {
                                                Calendar timeToLiveInstance;
                                                timeToLiveInstance = DatatypeConverter.parseDateTime(timeToLiveValue.getTextValue());
                                                brokeredMessagePropertiesInstance.setTimeToLive(timeToLiveInstance);
                                            }
                                            
                                            JsonNode toValue = brokeredMessagePropertiesValue.get("to");
                                            if (toValue != null && toValue instanceof NullNode == false) {
                                                String toInstance;
                                                toInstance = toValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setTo(toInstance);
                                            }
                                            
                                            JsonNode viaPartitionKeyValue = brokeredMessagePropertiesValue.get("viaPartitionKey");
                                            if (viaPartitionKeyValue != null && viaPartitionKeyValue instanceof NullNode == false) {
                                                String viaPartitionKeyInstance;
                                                viaPartitionKeyInstance = viaPartitionKeyValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setViaPartitionKey(viaPartitionKeyInstance);
                                            }
                                        }
                                        
                                        JsonNode customMessagePropertiesSequenceElement = ((JsonNode) serviceBusTopicMessageValue.get("customMessageProperties"));
                                        if (customMessagePropertiesSequenceElement != null && customMessagePropertiesSequenceElement instanceof NullNode == false) {
                                            Iterator<Map.Entry<String, JsonNode>> itr2 = customMessagePropertiesSequenceElement.getFields();
                                            while (itr2.hasNext()) {
                                                Map.Entry<String, JsonNode> property2 = itr2.next();
                                                String customMessagePropertiesKey = property2.getKey();
                                                String customMessagePropertiesValue = property2.getValue().getTextValue();
                                                serviceBusTopicMessageInstance.getCustomMessageProperties().put(customMessagePropertiesKey, customMessagePropertiesValue);
                                            }
                                        }
                                    }
                                    
                                    JsonNode serviceBusQueueMessageValue = errorActionValue.get("serviceBusQueueMessage");
                                    if (serviceBusQueueMessageValue != null && serviceBusQueueMessageValue instanceof NullNode == false) {
                                        JobServiceBusQueueMessage serviceBusQueueMessageInstance = new JobServiceBusQueueMessage();
                                        errorActionInstance.setServiceBusQueueMessage(serviceBusQueueMessageInstance);
                                        
                                        JsonNode queueNameValue2 = serviceBusQueueMessageValue.get("queueName");
                                        if (queueNameValue2 != null && queueNameValue2 instanceof NullNode == false) {
                                            String queueNameInstance2;
                                            queueNameInstance2 = queueNameValue2.getTextValue();
                                            serviceBusQueueMessageInstance.setQueueName(queueNameInstance2);
                                        }
                                        
                                        JsonNode namespaceValue2 = serviceBusQueueMessageValue.get("namespace");
                                        if (namespaceValue2 != null && namespaceValue2 instanceof NullNode == false) {
                                            String namespaceInstance2;
                                            namespaceInstance2 = namespaceValue2.getTextValue();
                                            serviceBusQueueMessageInstance.setNamespace(namespaceInstance2);
                                        }
                                        
                                        JsonNode transportTypeValue2 = serviceBusQueueMessageValue.get("transportType");
                                        if (transportTypeValue2 != null && transportTypeValue2 instanceof NullNode == false) {
                                            JobServiceBusTransportType transportTypeInstance2;
                                            transportTypeInstance2 = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue2.getTextValue());
                                            serviceBusQueueMessageInstance.setTransportType(transportTypeInstance2);
                                        }
                                        
                                        JsonNode authenticationValue3 = serviceBusQueueMessageValue.get("authentication");
                                        if (authenticationValue3 != null && authenticationValue3 instanceof NullNode == false) {
                                            JobServiceBusAuthentication authenticationInstance2 = new JobServiceBusAuthentication();
                                            serviceBusQueueMessageInstance.setAuthentication(authenticationInstance2);
                                            
                                            JsonNode sasKeyNameValue2 = authenticationValue3.get("sasKeyName");
                                            if (sasKeyNameValue2 != null && sasKeyNameValue2 instanceof NullNode == false) {
                                                String sasKeyNameInstance2;
                                                sasKeyNameInstance2 = sasKeyNameValue2.getTextValue();
                                                authenticationInstance2.setSasKeyName(sasKeyNameInstance2);
                                            }
                                            
                                            JsonNode sasKeyValue2 = authenticationValue3.get("sasKey");
                                            if (sasKeyValue2 != null && sasKeyValue2 instanceof NullNode == false) {
                                                String sasKeyInstance2;
                                                sasKeyInstance2 = sasKeyValue2.getTextValue();
                                                authenticationInstance2.setSasKey(sasKeyInstance2);
                                            }
                                            
                                            JsonNode typeValue7 = authenticationValue3.get("type");
                                            if (typeValue7 != null && typeValue7 instanceof NullNode == false) {
                                                JobServiceBusAuthenticationType typeInstance7;
                                                typeInstance7 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue7.getTextValue());
                                                authenticationInstance2.setType(typeInstance7);
                                            }
                                        }
                                        
                                        JsonNode messageValue3 = serviceBusQueueMessageValue.get("message");
                                        if (messageValue3 != null && messageValue3 instanceof NullNode == false) {
                                            String messageInstance3;
                                            messageInstance3 = messageValue3.getTextValue();
                                            serviceBusQueueMessageInstance.setMessage(messageInstance3);
                                        }
                                        
                                        JsonNode brokeredMessagePropertiesValue2 = serviceBusQueueMessageValue.get("brokeredMessageProperties");
                                        if (brokeredMessagePropertiesValue2 != null && brokeredMessagePropertiesValue2 instanceof NullNode == false) {
                                            JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance2 = new JobServiceBusBrokeredMessageProperties();
                                            serviceBusQueueMessageInstance.setBrokeredMessageProperties(brokeredMessagePropertiesInstance2);
                                            
                                            JsonNode contentTypeValue2 = brokeredMessagePropertiesValue2.get("contentType");
                                            if (contentTypeValue2 != null && contentTypeValue2 instanceof NullNode == false) {
                                                String contentTypeInstance2;
                                                contentTypeInstance2 = contentTypeValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setContentType(contentTypeInstance2);
                                            }
                                            
                                            JsonNode correlationIdValue2 = brokeredMessagePropertiesValue2.get("correlationId");
                                            if (correlationIdValue2 != null && correlationIdValue2 instanceof NullNode == false) {
                                                String correlationIdInstance2;
                                                correlationIdInstance2 = correlationIdValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setCorrelationId(correlationIdInstance2);
                                            }
                                            
                                            JsonNode forcePersistenceValue2 = brokeredMessagePropertiesValue2.get("forcePersistence");
                                            if (forcePersistenceValue2 != null && forcePersistenceValue2 instanceof NullNode == false) {
                                                boolean forcePersistenceInstance2;
                                                forcePersistenceInstance2 = forcePersistenceValue2.getBooleanValue();
                                                brokeredMessagePropertiesInstance2.setForcePersistence(forcePersistenceInstance2);
                                            }
                                            
                                            JsonNode labelValue2 = brokeredMessagePropertiesValue2.get("label");
                                            if (labelValue2 != null && labelValue2 instanceof NullNode == false) {
                                                String labelInstance2;
                                                labelInstance2 = labelValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setLabel(labelInstance2);
                                            }
                                            
                                            JsonNode messageIdValue2 = brokeredMessagePropertiesValue2.get("messageId");
                                            if (messageIdValue2 != null && messageIdValue2 instanceof NullNode == false) {
                                                String messageIdInstance2;
                                                messageIdInstance2 = messageIdValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setMessageId(messageIdInstance2);
                                            }
                                            
                                            JsonNode partitionKeyValue2 = brokeredMessagePropertiesValue2.get("partitionKey");
                                            if (partitionKeyValue2 != null && partitionKeyValue2 instanceof NullNode == false) {
                                                String partitionKeyInstance2;
                                                partitionKeyInstance2 = partitionKeyValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setPartitionKey(partitionKeyInstance2);
                                            }
                                            
                                            JsonNode replyToValue2 = brokeredMessagePropertiesValue2.get("replyTo");
                                            if (replyToValue2 != null && replyToValue2 instanceof NullNode == false) {
                                                String replyToInstance2;
                                                replyToInstance2 = replyToValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setReplyTo(replyToInstance2);
                                            }
                                            
                                            JsonNode replyToSessionIdValue2 = brokeredMessagePropertiesValue2.get("replyToSessionId");
                                            if (replyToSessionIdValue2 != null && replyToSessionIdValue2 instanceof NullNode == false) {
                                                String replyToSessionIdInstance2;
                                                replyToSessionIdInstance2 = replyToSessionIdValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setReplyToSessionId(replyToSessionIdInstance2);
                                            }
                                            
                                            JsonNode scheduledEnqueueTimeUtcValue2 = brokeredMessagePropertiesValue2.get("scheduledEnqueueTimeUtc");
                                            if (scheduledEnqueueTimeUtcValue2 != null && scheduledEnqueueTimeUtcValue2 instanceof NullNode == false) {
                                                Calendar scheduledEnqueueTimeUtcInstance2;
                                                scheduledEnqueueTimeUtcInstance2 = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue2.getTextValue());
                                                brokeredMessagePropertiesInstance2.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance2);
                                            }
                                            
                                            JsonNode sessionIdValue2 = brokeredMessagePropertiesValue2.get("sessionId");
                                            if (sessionIdValue2 != null && sessionIdValue2 instanceof NullNode == false) {
                                                String sessionIdInstance2;
                                                sessionIdInstance2 = sessionIdValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setSessionId(sessionIdInstance2);
                                            }
                                            
                                            JsonNode timeToLiveValue2 = brokeredMessagePropertiesValue2.get("timeToLive");
                                            if (timeToLiveValue2 != null && timeToLiveValue2 instanceof NullNode == false) {
                                                Calendar timeToLiveInstance2;
                                                timeToLiveInstance2 = DatatypeConverter.parseDateTime(timeToLiveValue2.getTextValue());
                                                brokeredMessagePropertiesInstance2.setTimeToLive(timeToLiveInstance2);
                                            }
                                            
                                            JsonNode toValue2 = brokeredMessagePropertiesValue2.get("to");
                                            if (toValue2 != null && toValue2 instanceof NullNode == false) {
                                                String toInstance2;
                                                toInstance2 = toValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setTo(toInstance2);
                                            }
                                            
                                            JsonNode viaPartitionKeyValue2 = brokeredMessagePropertiesValue2.get("viaPartitionKey");
                                            if (viaPartitionKeyValue2 != null && viaPartitionKeyValue2 instanceof NullNode == false) {
                                                String viaPartitionKeyInstance2;
                                                viaPartitionKeyInstance2 = viaPartitionKeyValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setViaPartitionKey(viaPartitionKeyInstance2);
                                            }
                                        }
                                        
                                        JsonNode customMessagePropertiesSequenceElement2 = ((JsonNode) serviceBusQueueMessageValue.get("customMessageProperties"));
                                        if (customMessagePropertiesSequenceElement2 != null && customMessagePropertiesSequenceElement2 instanceof NullNode == false) {
                                            Iterator<Map.Entry<String, JsonNode>> itr3 = customMessagePropertiesSequenceElement2.getFields();
                                            while (itr3.hasNext()) {
                                                Map.Entry<String, JsonNode> property3 = itr3.next();
                                                String customMessagePropertiesKey2 = property3.getKey();
                                                String customMessagePropertiesValue2 = property3.getValue().getTextValue();
                                                serviceBusQueueMessageInstance.getCustomMessageProperties().put(customMessagePropertiesKey2, customMessagePropertiesValue2);
                                            }
                                        }
                                    }
                                }
                                
                                JsonNode requestValue2 = actionValue.get("request");
                                if (requestValue2 != null && requestValue2 instanceof NullNode == false) {
                                    JobHttpRequest requestInstance2 = new JobHttpRequest();
                                    actionInstance.setRequest(requestInstance2);
                                    
                                    JsonNode uriValue2 = requestValue2.get("uri");
                                    if (uriValue2 != null && uriValue2 instanceof NullNode == false) {
                                        URI uriInstance2;
                                        uriInstance2 = new URI(uriValue2.getTextValue());
                                        requestInstance2.setUri(uriInstance2);
                                    }
                                    
                                    JsonNode methodValue2 = requestValue2.get("method");
                                    if (methodValue2 != null && methodValue2 instanceof NullNode == false) {
                                        String methodInstance2;
                                        methodInstance2 = methodValue2.getTextValue();
                                        requestInstance2.setMethod(methodInstance2);
                                    }
                                    
                                    JsonNode headersSequenceElement2 = ((JsonNode) requestValue2.get("headers"));
                                    if (headersSequenceElement2 != null && headersSequenceElement2 instanceof NullNode == false) {
                                        Iterator<Map.Entry<String, JsonNode>> itr4 = headersSequenceElement2.getFields();
                                        while (itr4.hasNext()) {
                                            Map.Entry<String, JsonNode> property4 = itr4.next();
                                            String headersKey2 = property4.getKey();
                                            String headersValue2 = property4.getValue().getTextValue();
                                            requestInstance2.getHeaders().put(headersKey2, headersValue2);
                                        }
                                    }
                                    
                                    JsonNode bodyValue2 = requestValue2.get("body");
                                    if (bodyValue2 != null && bodyValue2 instanceof NullNode == false) {
                                        String bodyInstance2;
                                        bodyInstance2 = bodyValue2.getTextValue();
                                        requestInstance2.setBody(bodyInstance2);
                                    }
                                    
                                    JsonNode authenticationValue4 = requestValue2.get("authentication");
                                    if (authenticationValue4 != null && authenticationValue4 instanceof NullNode == false) {
                                        String typeName2 = authenticationValue4.get("type").getTextValue();
                                        if ("ClientCertificate".equals(typeName2)) {
                                            ClientCertAuthentication clientCertAuthenticationInstance2 = new ClientCertAuthentication();
                                            
                                            JsonNode passwordValue3 = authenticationValue4.get("password");
                                            if (passwordValue3 != null && passwordValue3 instanceof NullNode == false) {
                                                String passwordInstance3;
                                                passwordInstance3 = passwordValue3.getTextValue();
                                                clientCertAuthenticationInstance2.setPassword(passwordInstance3);
                                            }
                                            
                                            JsonNode pfxValue2 = authenticationValue4.get("pfx");
                                            if (pfxValue2 != null && pfxValue2 instanceof NullNode == false) {
                                                String pfxInstance2;
                                                pfxInstance2 = pfxValue2.getTextValue();
                                                clientCertAuthenticationInstance2.setPfx(pfxInstance2);
                                            }
                                            
                                            JsonNode certificateThumbprintValue2 = authenticationValue4.get("certificateThumbprint");
                                            if (certificateThumbprintValue2 != null && certificateThumbprintValue2 instanceof NullNode == false) {
                                                String certificateThumbprintInstance2;
                                                certificateThumbprintInstance2 = certificateThumbprintValue2.getTextValue();
                                                clientCertAuthenticationInstance2.setCertificateThumbprint(certificateThumbprintInstance2);
                                            }
                                            
                                            JsonNode certificateExpirationValue2 = authenticationValue4.get("certificateExpiration");
                                            if (certificateExpirationValue2 != null && certificateExpirationValue2 instanceof NullNode == false) {
                                                Calendar certificateExpirationInstance2;
                                                certificateExpirationInstance2 = DatatypeConverter.parseDateTime(certificateExpirationValue2.getTextValue());
                                                clientCertAuthenticationInstance2.setCertificateExpiration(certificateExpirationInstance2);
                                            }
                                            
                                            JsonNode certificateSubjectNameValue2 = authenticationValue4.get("certificateSubjectName");
                                            if (certificateSubjectNameValue2 != null && certificateSubjectNameValue2 instanceof NullNode == false) {
                                                String certificateSubjectNameInstance2;
                                                certificateSubjectNameInstance2 = certificateSubjectNameValue2.getTextValue();
                                                clientCertAuthenticationInstance2.setCertificateSubjectName(certificateSubjectNameInstance2);
                                            }
                                            
                                            JsonNode typeValue8 = authenticationValue4.get("type");
                                            if (typeValue8 != null && typeValue8 instanceof NullNode == false) {
                                                HttpAuthenticationType typeInstance8;
                                                typeInstance8 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue8.getTextValue());
                                                clientCertAuthenticationInstance2.setType(typeInstance8);
                                            }
                                            requestInstance2.setAuthentication(clientCertAuthenticationInstance2);
                                        }
                                        if ("ActiveDirectoryOAuth".equals(typeName2)) {
                                            AADOAuthAuthentication aADOAuthAuthenticationInstance2 = new AADOAuthAuthentication();
                                            
                                            JsonNode secretValue2 = authenticationValue4.get("secret");
                                            if (secretValue2 != null && secretValue2 instanceof NullNode == false) {
                                                String secretInstance2;
                                                secretInstance2 = secretValue2.getTextValue();
                                                aADOAuthAuthenticationInstance2.setSecret(secretInstance2);
                                            }
                                            
                                            JsonNode tenantValue2 = authenticationValue4.get("tenant");
                                            if (tenantValue2 != null && tenantValue2 instanceof NullNode == false) {
                                                String tenantInstance2;
                                                tenantInstance2 = tenantValue2.getTextValue();
                                                aADOAuthAuthenticationInstance2.setTenant(tenantInstance2);
                                            }
                                            
                                            JsonNode audienceValue2 = authenticationValue4.get("audience");
                                            if (audienceValue2 != null && audienceValue2 instanceof NullNode == false) {
                                                String audienceInstance2;
                                                audienceInstance2 = audienceValue2.getTextValue();
                                                aADOAuthAuthenticationInstance2.setAudience(audienceInstance2);
                                            }
                                            
                                            JsonNode clientIdValue2 = authenticationValue4.get("clientId");
                                            if (clientIdValue2 != null && clientIdValue2 instanceof NullNode == false) {
                                                String clientIdInstance2;
                                                clientIdInstance2 = clientIdValue2.getTextValue();
                                                aADOAuthAuthenticationInstance2.setClientId(clientIdInstance2);
                                            }
                                            
                                            JsonNode typeValue9 = authenticationValue4.get("type");
                                            if (typeValue9 != null && typeValue9 instanceof NullNode == false) {
                                                HttpAuthenticationType typeInstance9;
                                                typeInstance9 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue9.getTextValue());
                                                aADOAuthAuthenticationInstance2.setType(typeInstance9);
                                            }
                                            requestInstance2.setAuthentication(aADOAuthAuthenticationInstance2);
                                        }
                                        if ("Basic".equals(typeName2)) {
                                            BasicAuthentication basicAuthenticationInstance2 = new BasicAuthentication();
                                            
                                            JsonNode usernameValue2 = authenticationValue4.get("username");
                                            if (usernameValue2 != null && usernameValue2 instanceof NullNode == false) {
                                                String usernameInstance2;
                                                usernameInstance2 = usernameValue2.getTextValue();
                                                basicAuthenticationInstance2.setUsername(usernameInstance2);
                                            }
                                            
                                            JsonNode passwordValue4 = authenticationValue4.get("password");
                                            if (passwordValue4 != null && passwordValue4 instanceof NullNode == false) {
                                                String passwordInstance4;
                                                passwordInstance4 = passwordValue4.getTextValue();
                                                basicAuthenticationInstance2.setPassword(passwordInstance4);
                                            }
                                            
                                            JsonNode typeValue10 = authenticationValue4.get("type");
                                            if (typeValue10 != null && typeValue10 instanceof NullNode == false) {
                                                HttpAuthenticationType typeInstance10;
                                                typeInstance10 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue10.getTextValue());
                                                basicAuthenticationInstance2.setType(typeInstance10);
                                            }
                                            requestInstance2.setAuthentication(basicAuthenticationInstance2);
                                        }
                                    }
                                }
                                
                                JsonNode queueMessageValue2 = actionValue.get("queueMessage");
                                if (queueMessageValue2 != null && queueMessageValue2 instanceof NullNode == false) {
                                    JobQueueMessage queueMessageInstance2 = new JobQueueMessage();
                                    actionInstance.setQueueMessage(queueMessageInstance2);
                                    
                                    JsonNode storageAccountValue2 = queueMessageValue2.get("storageAccount");
                                    if (storageAccountValue2 != null && storageAccountValue2 instanceof NullNode == false) {
                                        String storageAccountInstance2;
                                        storageAccountInstance2 = storageAccountValue2.getTextValue();
                                        queueMessageInstance2.setStorageAccountName(storageAccountInstance2);
                                    }
                                    
                                    JsonNode queueNameValue3 = queueMessageValue2.get("queueName");
                                    if (queueNameValue3 != null && queueNameValue3 instanceof NullNode == false) {
                                        String queueNameInstance3;
                                        queueNameInstance3 = queueNameValue3.getTextValue();
                                        queueMessageInstance2.setQueueName(queueNameInstance3);
                                    }
                                    
                                    JsonNode sasTokenValue2 = queueMessageValue2.get("sasToken");
                                    if (sasTokenValue2 != null && sasTokenValue2 instanceof NullNode == false) {
                                        String sasTokenInstance2;
                                        sasTokenInstance2 = sasTokenValue2.getTextValue();
                                        queueMessageInstance2.setSasToken(sasTokenInstance2);
                                    }
                                    
                                    JsonNode messageValue4 = queueMessageValue2.get("message");
                                    if (messageValue4 != null && messageValue4 instanceof NullNode == false) {
                                        String messageInstance4;
                                        messageInstance4 = messageValue4.getTextValue();
                                        queueMessageInstance2.setMessage(messageInstance4);
                                    }
                                }
                                
                                JsonNode serviceBusTopicMessageValue2 = actionValue.get("serviceBusTopicMessage");
                                if (serviceBusTopicMessageValue2 != null && serviceBusTopicMessageValue2 instanceof NullNode == false) {
                                    JobServiceBusTopicMessage serviceBusTopicMessageInstance2 = new JobServiceBusTopicMessage();
                                    actionInstance.setServiceBusTopicMessage(serviceBusTopicMessageInstance2);
                                    
                                    JsonNode topicPathValue2 = serviceBusTopicMessageValue2.get("topicPath");
                                    if (topicPathValue2 != null && topicPathValue2 instanceof NullNode == false) {
                                        String topicPathInstance2;
                                        topicPathInstance2 = topicPathValue2.getTextValue();
                                        serviceBusTopicMessageInstance2.setTopicPath(topicPathInstance2);
                                    }
                                    
                                    JsonNode namespaceValue3 = serviceBusTopicMessageValue2.get("namespace");
                                    if (namespaceValue3 != null && namespaceValue3 instanceof NullNode == false) {
                                        String namespaceInstance3;
                                        namespaceInstance3 = namespaceValue3.getTextValue();
                                        serviceBusTopicMessageInstance2.setNamespace(namespaceInstance3);
                                    }
                                    
                                    JsonNode transportTypeValue3 = serviceBusTopicMessageValue2.get("transportType");
                                    if (transportTypeValue3 != null && transportTypeValue3 instanceof NullNode == false) {
                                        JobServiceBusTransportType transportTypeInstance3;
                                        transportTypeInstance3 = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue3.getTextValue());
                                        serviceBusTopicMessageInstance2.setTransportType(transportTypeInstance3);
                                    }
                                    
                                    JsonNode authenticationValue5 = serviceBusTopicMessageValue2.get("authentication");
                                    if (authenticationValue5 != null && authenticationValue5 instanceof NullNode == false) {
                                        JobServiceBusAuthentication authenticationInstance3 = new JobServiceBusAuthentication();
                                        serviceBusTopicMessageInstance2.setAuthentication(authenticationInstance3);
                                        
                                        JsonNode sasKeyNameValue3 = authenticationValue5.get("sasKeyName");
                                        if (sasKeyNameValue3 != null && sasKeyNameValue3 instanceof NullNode == false) {
                                            String sasKeyNameInstance3;
                                            sasKeyNameInstance3 = sasKeyNameValue3.getTextValue();
                                            authenticationInstance3.setSasKeyName(sasKeyNameInstance3);
                                        }
                                        
                                        JsonNode sasKeyValue3 = authenticationValue5.get("sasKey");
                                        if (sasKeyValue3 != null && sasKeyValue3 instanceof NullNode == false) {
                                            String sasKeyInstance3;
                                            sasKeyInstance3 = sasKeyValue3.getTextValue();
                                            authenticationInstance3.setSasKey(sasKeyInstance3);
                                        }
                                        
                                        JsonNode typeValue11 = authenticationValue5.get("type");
                                        if (typeValue11 != null && typeValue11 instanceof NullNode == false) {
                                            JobServiceBusAuthenticationType typeInstance11;
                                            typeInstance11 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue11.getTextValue());
                                            authenticationInstance3.setType(typeInstance11);
                                        }
                                    }
                                    
                                    JsonNode messageValue5 = serviceBusTopicMessageValue2.get("message");
                                    if (messageValue5 != null && messageValue5 instanceof NullNode == false) {
                                        String messageInstance5;
                                        messageInstance5 = messageValue5.getTextValue();
                                        serviceBusTopicMessageInstance2.setMessage(messageInstance5);
                                    }
                                    
                                    JsonNode brokeredMessagePropertiesValue3 = serviceBusTopicMessageValue2.get("brokeredMessageProperties");
                                    if (brokeredMessagePropertiesValue3 != null && brokeredMessagePropertiesValue3 instanceof NullNode == false) {
                                        JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance3 = new JobServiceBusBrokeredMessageProperties();
                                        serviceBusTopicMessageInstance2.setBrokeredMessageProperties(brokeredMessagePropertiesInstance3);
                                        
                                        JsonNode contentTypeValue3 = brokeredMessagePropertiesValue3.get("contentType");
                                        if (contentTypeValue3 != null && contentTypeValue3 instanceof NullNode == false) {
                                            String contentTypeInstance3;
                                            contentTypeInstance3 = contentTypeValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setContentType(contentTypeInstance3);
                                        }
                                        
                                        JsonNode correlationIdValue3 = brokeredMessagePropertiesValue3.get("correlationId");
                                        if (correlationIdValue3 != null && correlationIdValue3 instanceof NullNode == false) {
                                            String correlationIdInstance3;
                                            correlationIdInstance3 = correlationIdValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setCorrelationId(correlationIdInstance3);
                                        }
                                        
                                        JsonNode forcePersistenceValue3 = brokeredMessagePropertiesValue3.get("forcePersistence");
                                        if (forcePersistenceValue3 != null && forcePersistenceValue3 instanceof NullNode == false) {
                                            boolean forcePersistenceInstance3;
                                            forcePersistenceInstance3 = forcePersistenceValue3.getBooleanValue();
                                            brokeredMessagePropertiesInstance3.setForcePersistence(forcePersistenceInstance3);
                                        }
                                        
                                        JsonNode labelValue3 = brokeredMessagePropertiesValue3.get("label");
                                        if (labelValue3 != null && labelValue3 instanceof NullNode == false) {
                                            String labelInstance3;
                                            labelInstance3 = labelValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setLabel(labelInstance3);
                                        }
                                        
                                        JsonNode messageIdValue3 = brokeredMessagePropertiesValue3.get("messageId");
                                        if (messageIdValue3 != null && messageIdValue3 instanceof NullNode == false) {
                                            String messageIdInstance3;
                                            messageIdInstance3 = messageIdValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setMessageId(messageIdInstance3);
                                        }
                                        
                                        JsonNode partitionKeyValue3 = brokeredMessagePropertiesValue3.get("partitionKey");
                                        if (partitionKeyValue3 != null && partitionKeyValue3 instanceof NullNode == false) {
                                            String partitionKeyInstance3;
                                            partitionKeyInstance3 = partitionKeyValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setPartitionKey(partitionKeyInstance3);
                                        }
                                        
                                        JsonNode replyToValue3 = brokeredMessagePropertiesValue3.get("replyTo");
                                        if (replyToValue3 != null && replyToValue3 instanceof NullNode == false) {
                                            String replyToInstance3;
                                            replyToInstance3 = replyToValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setReplyTo(replyToInstance3);
                                        }
                                        
                                        JsonNode replyToSessionIdValue3 = brokeredMessagePropertiesValue3.get("replyToSessionId");
                                        if (replyToSessionIdValue3 != null && replyToSessionIdValue3 instanceof NullNode == false) {
                                            String replyToSessionIdInstance3;
                                            replyToSessionIdInstance3 = replyToSessionIdValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setReplyToSessionId(replyToSessionIdInstance3);
                                        }
                                        
                                        JsonNode scheduledEnqueueTimeUtcValue3 = brokeredMessagePropertiesValue3.get("scheduledEnqueueTimeUtc");
                                        if (scheduledEnqueueTimeUtcValue3 != null && scheduledEnqueueTimeUtcValue3 instanceof NullNode == false) {
                                            Calendar scheduledEnqueueTimeUtcInstance3;
                                            scheduledEnqueueTimeUtcInstance3 = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue3.getTextValue());
                                            brokeredMessagePropertiesInstance3.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance3);
                                        }
                                        
                                        JsonNode sessionIdValue3 = brokeredMessagePropertiesValue3.get("sessionId");
                                        if (sessionIdValue3 != null && sessionIdValue3 instanceof NullNode == false) {
                                            String sessionIdInstance3;
                                            sessionIdInstance3 = sessionIdValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setSessionId(sessionIdInstance3);
                                        }
                                        
                                        JsonNode timeToLiveValue3 = brokeredMessagePropertiesValue3.get("timeToLive");
                                        if (timeToLiveValue3 != null && timeToLiveValue3 instanceof NullNode == false) {
                                            Calendar timeToLiveInstance3;
                                            timeToLiveInstance3 = DatatypeConverter.parseDateTime(timeToLiveValue3.getTextValue());
                                            brokeredMessagePropertiesInstance3.setTimeToLive(timeToLiveInstance3);
                                        }
                                        
                                        JsonNode toValue3 = brokeredMessagePropertiesValue3.get("to");
                                        if (toValue3 != null && toValue3 instanceof NullNode == false) {
                                            String toInstance3;
                                            toInstance3 = toValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setTo(toInstance3);
                                        }
                                        
                                        JsonNode viaPartitionKeyValue3 = brokeredMessagePropertiesValue3.get("viaPartitionKey");
                                        if (viaPartitionKeyValue3 != null && viaPartitionKeyValue3 instanceof NullNode == false) {
                                            String viaPartitionKeyInstance3;
                                            viaPartitionKeyInstance3 = viaPartitionKeyValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setViaPartitionKey(viaPartitionKeyInstance3);
                                        }
                                    }
                                    
                                    JsonNode customMessagePropertiesSequenceElement3 = ((JsonNode) serviceBusTopicMessageValue2.get("customMessageProperties"));
                                    if (customMessagePropertiesSequenceElement3 != null && customMessagePropertiesSequenceElement3 instanceof NullNode == false) {
                                        Iterator<Map.Entry<String, JsonNode>> itr5 = customMessagePropertiesSequenceElement3.getFields();
                                        while (itr5.hasNext()) {
                                            Map.Entry<String, JsonNode> property5 = itr5.next();
                                            String customMessagePropertiesKey3 = property5.getKey();
                                            String customMessagePropertiesValue3 = property5.getValue().getTextValue();
                                            serviceBusTopicMessageInstance2.getCustomMessageProperties().put(customMessagePropertiesKey3, customMessagePropertiesValue3);
                                        }
                                    }
                                }
                                
                                JsonNode serviceBusQueueMessageValue2 = actionValue.get("serviceBusQueueMessage");
                                if (serviceBusQueueMessageValue2 != null && serviceBusQueueMessageValue2 instanceof NullNode == false) {
                                    JobServiceBusQueueMessage serviceBusQueueMessageInstance2 = new JobServiceBusQueueMessage();
                                    actionInstance.setServiceBusQueueMessage(serviceBusQueueMessageInstance2);
                                    
                                    JsonNode queueNameValue4 = serviceBusQueueMessageValue2.get("queueName");
                                    if (queueNameValue4 != null && queueNameValue4 instanceof NullNode == false) {
                                        String queueNameInstance4;
                                        queueNameInstance4 = queueNameValue4.getTextValue();
                                        serviceBusQueueMessageInstance2.setQueueName(queueNameInstance4);
                                    }
                                    
                                    JsonNode namespaceValue4 = serviceBusQueueMessageValue2.get("namespace");
                                    if (namespaceValue4 != null && namespaceValue4 instanceof NullNode == false) {
                                        String namespaceInstance4;
                                        namespaceInstance4 = namespaceValue4.getTextValue();
                                        serviceBusQueueMessageInstance2.setNamespace(namespaceInstance4);
                                    }
                                    
                                    JsonNode transportTypeValue4 = serviceBusQueueMessageValue2.get("transportType");
                                    if (transportTypeValue4 != null && transportTypeValue4 instanceof NullNode == false) {
                                        JobServiceBusTransportType transportTypeInstance4;
                                        transportTypeInstance4 = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue4.getTextValue());
                                        serviceBusQueueMessageInstance2.setTransportType(transportTypeInstance4);
                                    }
                                    
                                    JsonNode authenticationValue6 = serviceBusQueueMessageValue2.get("authentication");
                                    if (authenticationValue6 != null && authenticationValue6 instanceof NullNode == false) {
                                        JobServiceBusAuthentication authenticationInstance4 = new JobServiceBusAuthentication();
                                        serviceBusQueueMessageInstance2.setAuthentication(authenticationInstance4);
                                        
                                        JsonNode sasKeyNameValue4 = authenticationValue6.get("sasKeyName");
                                        if (sasKeyNameValue4 != null && sasKeyNameValue4 instanceof NullNode == false) {
                                            String sasKeyNameInstance4;
                                            sasKeyNameInstance4 = sasKeyNameValue4.getTextValue();
                                            authenticationInstance4.setSasKeyName(sasKeyNameInstance4);
                                        }
                                        
                                        JsonNode sasKeyValue4 = authenticationValue6.get("sasKey");
                                        if (sasKeyValue4 != null && sasKeyValue4 instanceof NullNode == false) {
                                            String sasKeyInstance4;
                                            sasKeyInstance4 = sasKeyValue4.getTextValue();
                                            authenticationInstance4.setSasKey(sasKeyInstance4);
                                        }
                                        
                                        JsonNode typeValue12 = authenticationValue6.get("type");
                                        if (typeValue12 != null && typeValue12 instanceof NullNode == false) {
                                            JobServiceBusAuthenticationType typeInstance12;
                                            typeInstance12 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue12.getTextValue());
                                            authenticationInstance4.setType(typeInstance12);
                                        }
                                    }
                                    
                                    JsonNode messageValue6 = serviceBusQueueMessageValue2.get("message");
                                    if (messageValue6 != null && messageValue6 instanceof NullNode == false) {
                                        String messageInstance6;
                                        messageInstance6 = messageValue6.getTextValue();
                                        serviceBusQueueMessageInstance2.setMessage(messageInstance6);
                                    }
                                    
                                    JsonNode brokeredMessagePropertiesValue4 = serviceBusQueueMessageValue2.get("brokeredMessageProperties");
                                    if (brokeredMessagePropertiesValue4 != null && brokeredMessagePropertiesValue4 instanceof NullNode == false) {
                                        JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance4 = new JobServiceBusBrokeredMessageProperties();
                                        serviceBusQueueMessageInstance2.setBrokeredMessageProperties(brokeredMessagePropertiesInstance4);
                                        
                                        JsonNode contentTypeValue4 = brokeredMessagePropertiesValue4.get("contentType");
                                        if (contentTypeValue4 != null && contentTypeValue4 instanceof NullNode == false) {
                                            String contentTypeInstance4;
                                            contentTypeInstance4 = contentTypeValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setContentType(contentTypeInstance4);
                                        }
                                        
                                        JsonNode correlationIdValue4 = brokeredMessagePropertiesValue4.get("correlationId");
                                        if (correlationIdValue4 != null && correlationIdValue4 instanceof NullNode == false) {
                                            String correlationIdInstance4;
                                            correlationIdInstance4 = correlationIdValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setCorrelationId(correlationIdInstance4);
                                        }
                                        
                                        JsonNode forcePersistenceValue4 = brokeredMessagePropertiesValue4.get("forcePersistence");
                                        if (forcePersistenceValue4 != null && forcePersistenceValue4 instanceof NullNode == false) {
                                            boolean forcePersistenceInstance4;
                                            forcePersistenceInstance4 = forcePersistenceValue4.getBooleanValue();
                                            brokeredMessagePropertiesInstance4.setForcePersistence(forcePersistenceInstance4);
                                        }
                                        
                                        JsonNode labelValue4 = brokeredMessagePropertiesValue4.get("label");
                                        if (labelValue4 != null && labelValue4 instanceof NullNode == false) {
                                            String labelInstance4;
                                            labelInstance4 = labelValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setLabel(labelInstance4);
                                        }
                                        
                                        JsonNode messageIdValue4 = brokeredMessagePropertiesValue4.get("messageId");
                                        if (messageIdValue4 != null && messageIdValue4 instanceof NullNode == false) {
                                            String messageIdInstance4;
                                            messageIdInstance4 = messageIdValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setMessageId(messageIdInstance4);
                                        }
                                        
                                        JsonNode partitionKeyValue4 = brokeredMessagePropertiesValue4.get("partitionKey");
                                        if (partitionKeyValue4 != null && partitionKeyValue4 instanceof NullNode == false) {
                                            String partitionKeyInstance4;
                                            partitionKeyInstance4 = partitionKeyValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setPartitionKey(partitionKeyInstance4);
                                        }
                                        
                                        JsonNode replyToValue4 = brokeredMessagePropertiesValue4.get("replyTo");
                                        if (replyToValue4 != null && replyToValue4 instanceof NullNode == false) {
                                            String replyToInstance4;
                                            replyToInstance4 = replyToValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setReplyTo(replyToInstance4);
                                        }
                                        
                                        JsonNode replyToSessionIdValue4 = brokeredMessagePropertiesValue4.get("replyToSessionId");
                                        if (replyToSessionIdValue4 != null && replyToSessionIdValue4 instanceof NullNode == false) {
                                            String replyToSessionIdInstance4;
                                            replyToSessionIdInstance4 = replyToSessionIdValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setReplyToSessionId(replyToSessionIdInstance4);
                                        }
                                        
                                        JsonNode scheduledEnqueueTimeUtcValue4 = brokeredMessagePropertiesValue4.get("scheduledEnqueueTimeUtc");
                                        if (scheduledEnqueueTimeUtcValue4 != null && scheduledEnqueueTimeUtcValue4 instanceof NullNode == false) {
                                            Calendar scheduledEnqueueTimeUtcInstance4;
                                            scheduledEnqueueTimeUtcInstance4 = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue4.getTextValue());
                                            brokeredMessagePropertiesInstance4.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance4);
                                        }
                                        
                                        JsonNode sessionIdValue4 = brokeredMessagePropertiesValue4.get("sessionId");
                                        if (sessionIdValue4 != null && sessionIdValue4 instanceof NullNode == false) {
                                            String sessionIdInstance4;
                                            sessionIdInstance4 = sessionIdValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setSessionId(sessionIdInstance4);
                                        }
                                        
                                        JsonNode timeToLiveValue4 = brokeredMessagePropertiesValue4.get("timeToLive");
                                        if (timeToLiveValue4 != null && timeToLiveValue4 instanceof NullNode == false) {
                                            Calendar timeToLiveInstance4;
                                            timeToLiveInstance4 = DatatypeConverter.parseDateTime(timeToLiveValue4.getTextValue());
                                            brokeredMessagePropertiesInstance4.setTimeToLive(timeToLiveInstance4);
                                        }
                                        
                                        JsonNode toValue4 = brokeredMessagePropertiesValue4.get("to");
                                        if (toValue4 != null && toValue4 instanceof NullNode == false) {
                                            String toInstance4;
                                            toInstance4 = toValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setTo(toInstance4);
                                        }
                                        
                                        JsonNode viaPartitionKeyValue4 = brokeredMessagePropertiesValue4.get("viaPartitionKey");
                                        if (viaPartitionKeyValue4 != null && viaPartitionKeyValue4 instanceof NullNode == false) {
                                            String viaPartitionKeyInstance4;
                                            viaPartitionKeyInstance4 = viaPartitionKeyValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setViaPartitionKey(viaPartitionKeyInstance4);
                                        }
                                    }
                                    
                                    JsonNode customMessagePropertiesSequenceElement4 = ((JsonNode) serviceBusQueueMessageValue2.get("customMessageProperties"));
                                    if (customMessagePropertiesSequenceElement4 != null && customMessagePropertiesSequenceElement4 instanceof NullNode == false) {
                                        Iterator<Map.Entry<String, JsonNode>> itr6 = customMessagePropertiesSequenceElement4.getFields();
                                        while (itr6.hasNext()) {
                                            Map.Entry<String, JsonNode> property6 = itr6.next();
                                            String customMessagePropertiesKey4 = property6.getKey();
                                            String customMessagePropertiesValue4 = property6.getValue().getTextValue();
                                            serviceBusQueueMessageInstance2.getCustomMessageProperties().put(customMessagePropertiesKey4, customMessagePropertiesValue4);
                                        }
                                    }
                                }
                            }
                            
                            JsonNode recurrenceValue = jobsValue.get("recurrence");
                            if (recurrenceValue != null && recurrenceValue instanceof NullNode == false) {
                                JobRecurrence recurrenceInstance = new JobRecurrence();
                                jobInstance.setRecurrence(recurrenceInstance);
                                
                                JsonNode frequencyValue = recurrenceValue.get("frequency");
                                if (frequencyValue != null && frequencyValue instanceof NullNode == false) {
                                    JobRecurrenceFrequency frequencyInstance;
                                    frequencyInstance = SchedulerClientImpl.parseJobRecurrenceFrequency(frequencyValue.getTextValue());
                                    recurrenceInstance.setFrequency(frequencyInstance);
                                }
                                
                                JsonNode intervalValue = recurrenceValue.get("interval");
                                if (intervalValue != null && intervalValue instanceof NullNode == false) {
                                    int intervalInstance;
                                    intervalInstance = intervalValue.getIntValue();
                                    recurrenceInstance.setInterval(intervalInstance);
                                }
                                
                                JsonNode countValue = recurrenceValue.get("count");
                                if (countValue != null && countValue instanceof NullNode == false) {
                                    int countInstance;
                                    countInstance = countValue.getIntValue();
                                    recurrenceInstance.setCount(countInstance);
                                }
                                
                                JsonNode endTimeValue = recurrenceValue.get("endTime");
                                if (endTimeValue != null && endTimeValue instanceof NullNode == false) {
                                    Calendar endTimeInstance;
                                    endTimeInstance = DatatypeConverter.parseDateTime(endTimeValue.getTextValue());
                                    recurrenceInstance.setEndTime(endTimeInstance);
                                }
                                
                                JsonNode scheduleValue = recurrenceValue.get("schedule");
                                if (scheduleValue != null && scheduleValue instanceof NullNode == false) {
                                    JobRecurrenceSchedule scheduleInstance = new JobRecurrenceSchedule();
                                    recurrenceInstance.setSchedule(scheduleInstance);
                                    
                                    JsonNode minutesArray = scheduleValue.get("minutes");
                                    if (minutesArray != null && minutesArray instanceof NullNode == false) {
                                        scheduleInstance.setMinutes(new ArrayList<Integer>());
                                        for (JsonNode minutesValue : ((ArrayNode) minutesArray)) {
                                            scheduleInstance.getMinutes().add(minutesValue.getIntValue());
                                        }
                                    }
                                    
                                    JsonNode hoursArray = scheduleValue.get("hours");
                                    if (hoursArray != null && hoursArray instanceof NullNode == false) {
                                        scheduleInstance.setHours(new ArrayList<Integer>());
                                        for (JsonNode hoursValue : ((ArrayNode) hoursArray)) {
                                            scheduleInstance.getHours().add(hoursValue.getIntValue());
                                        }
                                    }
                                    
                                    JsonNode weekDaysArray = scheduleValue.get("weekDays");
                                    if (weekDaysArray != null && weekDaysArray instanceof NullNode == false) {
                                        scheduleInstance.setDays(new ArrayList<JobScheduleDay>());
                                        for (JsonNode weekDaysValue : ((ArrayNode) weekDaysArray)) {
                                            scheduleInstance.getDays().add(SchedulerClientImpl.parseJobScheduleDay(weekDaysValue.getTextValue()));
                                        }
                                    }
                                    
                                    JsonNode monthsArray = scheduleValue.get("months");
                                    if (monthsArray != null && monthsArray instanceof NullNode == false) {
                                        scheduleInstance.setMonths(new ArrayList<Integer>());
                                        for (JsonNode monthsValue : ((ArrayNode) monthsArray)) {
                                            scheduleInstance.getMonths().add(monthsValue.getIntValue());
                                        }
                                    }
                                    
                                    JsonNode monthDaysArray = scheduleValue.get("monthDays");
                                    if (monthDaysArray != null && monthDaysArray instanceof NullNode == false) {
                                        scheduleInstance.setMonthDays(new ArrayList<Integer>());
                                        for (JsonNode monthDaysValue : ((ArrayNode) monthDaysArray)) {
                                            scheduleInstance.getMonthDays().add(monthDaysValue.getIntValue());
                                        }
                                    }
                                    
                                    JsonNode monthlyOccurrencesArray = scheduleValue.get("monthlyOccurrences");
                                    if (monthlyOccurrencesArray != null && monthlyOccurrencesArray instanceof NullNode == false) {
                                        scheduleInstance.setMonthlyOccurrences(new ArrayList<JobScheduleMonthlyOccurrence>());
                                        for (JsonNode monthlyOccurrencesValue : ((ArrayNode) monthlyOccurrencesArray)) {
                                            JobScheduleMonthlyOccurrence jobScheduleMonthlyOccurrenceInstance = new JobScheduleMonthlyOccurrence();
                                            scheduleInstance.getMonthlyOccurrences().add(jobScheduleMonthlyOccurrenceInstance);
                                            
                                            JsonNode dayValue = monthlyOccurrencesValue.get("day");
                                            if (dayValue != null && dayValue instanceof NullNode == false) {
                                                JobScheduleDay dayInstance;
                                                dayInstance = SchedulerClientImpl.parseJobScheduleDay(dayValue.getTextValue());
                                                jobScheduleMonthlyOccurrenceInstance.setDay(dayInstance);
                                            }
                                            
                                            JsonNode occurrenceValue = monthlyOccurrencesValue.get("occurrence");
                                            if (occurrenceValue != null && occurrenceValue instanceof NullNode == false) {
                                                int occurrenceInstance;
                                                occurrenceInstance = occurrenceValue.getIntValue();
                                                jobScheduleMonthlyOccurrenceInstance.setOccurrence(occurrenceInstance);
                                            }
                                        }
                                    }
                                }
                            }
                            
                            JsonNode statusValue = jobsValue.get("status");
                            if (statusValue != null && statusValue instanceof NullNode == false) {
                                JobStatus statusInstance = new JobStatus();
                                jobInstance.setStatus(statusInstance);
                                
                                JsonNode lastExecutionTimeValue = statusValue.get("lastExecutionTime");
                                if (lastExecutionTimeValue != null && lastExecutionTimeValue instanceof NullNode == false) {
                                    Calendar lastExecutionTimeInstance;
                                    lastExecutionTimeInstance = DatatypeConverter.parseDateTime(lastExecutionTimeValue.getTextValue());
                                    statusInstance.setLastExecutionTime(lastExecutionTimeInstance);
                                }
                                
                                JsonNode nextExecutionTimeValue = statusValue.get("nextExecutionTime");
                                if (nextExecutionTimeValue != null && nextExecutionTimeValue instanceof NullNode == false) {
                                    Calendar nextExecutionTimeInstance;
                                    nextExecutionTimeInstance = DatatypeConverter.parseDateTime(nextExecutionTimeValue.getTextValue());
                                    statusInstance.setNextExecutionTime(nextExecutionTimeInstance);
                                }
                                
                                JsonNode executionCountValue = statusValue.get("executionCount");
                                if (executionCountValue != null && executionCountValue instanceof NullNode == false) {
                                    int executionCountInstance;
                                    executionCountInstance = executionCountValue.getIntValue();
                                    statusInstance.setExecutionCount(executionCountInstance);
                                }
                                
                                JsonNode failureCountValue = statusValue.get("failureCount");
                                if (failureCountValue != null && failureCountValue instanceof NullNode == false) {
                                    int failureCountInstance;
                                    failureCountInstance = failureCountValue.getIntValue();
                                    statusInstance.setFailureCount(failureCountInstance);
                                }
                                
                                JsonNode faultedCountValue = statusValue.get("faultedCount");
                                if (faultedCountValue != null && faultedCountValue instanceof NullNode == false) {
                                    int faultedCountInstance;
                                    faultedCountInstance = faultedCountValue.getIntValue();
                                    statusInstance.setFaultedCount(faultedCountInstance);
                                }
                            }
                            
                            JsonNode stateValue = jobsValue.get("state");
                            if (stateValue != null && stateValue instanceof NullNode == false) {
                                JobState stateInstance;
                                stateInstance = SchedulerClientImpl.parseJobState(stateValue.getTextValue());
                                jobInstance.setState(stateInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Get the list of jobs in a job collection matching a filter on job state.
    *
    * @param parameters Required. Parameters supplied to the List Jobs with
    * filter operation.
    * @return The List Jobs operation response.
    */
    @Override
    public Future<JobListResponse> listWithFilterAsync(final JobListWithFilterParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<JobListResponse>() { 
            @Override
            public JobListResponse call() throws Exception {
                return listWithFilter(parameters);
            }
         });
    }
    
    /**
    * Get the list of jobs in a job collection matching a filter on job state.
    *
    * @param parameters Required. Parameters supplied to the List Jobs with
    * filter operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The List Jobs operation response.
    */
    @Override
    public JobListResponse listWithFilter(JobListWithFilterParameters parameters) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getState() == null) {
            throw new NullPointerException("parameters.State");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "listWithFilterAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/cloudservices/";
        url = url + URLEncoder.encode(this.getClient().getCloudServiceName(), "UTF-8");
        url = url + "/resources/";
        url = url + "scheduler";
        url = url + "/~/";
        url = url + "JobCollections";
        url = url + "/";
        url = url + URLEncoder.encode(this.getClient().getJobCollectionName(), "UTF-8");
        url = url + "/jobs";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        ArrayList<String> odataFilter = new ArrayList<String>();
        odataFilter.add("state eq " + URLEncoder.encode(SchedulerClientImpl.jobStateToString(parameters.getState()), "UTF-8"));
        if (odataFilter.size() > 0) {
            queryParameters.add("$filter=" + CollectionStringBuilder.join(odataFilter, null));
        }
        if (parameters.getSkip() != null) {
            queryParameters.add("$skip=" + URLEncoder.encode(Integer.toString(parameters.getSkip()), "UTF-8"));
        }
        if (parameters.getTop() != null) {
            queryParameters.add("$top=" + URLEncoder.encode(Integer.toString(parameters.getTop()), "UTF-8"));
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2013-03-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            JobListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new JobListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode jobsArray = responseDoc;
                    if (jobsArray != null && jobsArray instanceof NullNode == false) {
                        for (JsonNode jobsValue : ((ArrayNode) jobsArray)) {
                            Job jobInstance = new Job();
                            result.getJobs().add(jobInstance);
                            
                            JsonNode idValue = jobsValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                jobInstance.setId(idInstance);
                            }
                            
                            JsonNode startTimeValue = jobsValue.get("startTime");
                            if (startTimeValue != null && startTimeValue instanceof NullNode == false) {
                                Calendar startTimeInstance;
                                startTimeInstance = DatatypeConverter.parseDateTime(startTimeValue.getTextValue());
                                jobInstance.setStartTime(startTimeInstance);
                            }
                            
                            JsonNode actionValue = jobsValue.get("action");
                            if (actionValue != null && actionValue instanceof NullNode == false) {
                                JobAction actionInstance = new JobAction();
                                jobInstance.setAction(actionInstance);
                                
                                JsonNode typeValue = actionValue.get("type");
                                if (typeValue != null && typeValue instanceof NullNode == false) {
                                    JobActionType typeInstance;
                                    typeInstance = SchedulerClientImpl.parseJobActionType(typeValue.getTextValue());
                                    actionInstance.setType(typeInstance);
                                }
                                
                                JsonNode retryPolicyValue = actionValue.get("retryPolicy");
                                if (retryPolicyValue != null && retryPolicyValue instanceof NullNode == false) {
                                    RetryPolicy retryPolicyInstance = new RetryPolicy();
                                    actionInstance.setRetryPolicy(retryPolicyInstance);
                                    
                                    JsonNode retryTypeValue = retryPolicyValue.get("retryType");
                                    if (retryTypeValue != null && retryTypeValue instanceof NullNode == false) {
                                        RetryType retryTypeInstance;
                                        retryTypeInstance = SchedulerClientImpl.parseRetryType(retryTypeValue.getTextValue());
                                        retryPolicyInstance.setRetryType(retryTypeInstance);
                                    }
                                    
                                    JsonNode retryIntervalValue = retryPolicyValue.get("retryInterval");
                                    if (retryIntervalValue != null && retryIntervalValue instanceof NullNode == false) {
                                        Duration retryIntervalInstance;
                                        retryIntervalInstance = TimeSpan8601Converter.parse(retryIntervalValue.getTextValue());
                                        retryPolicyInstance.setRetryInterval(retryIntervalInstance);
                                    }
                                    
                                    JsonNode retryCountValue = retryPolicyValue.get("retryCount");
                                    if (retryCountValue != null && retryCountValue instanceof NullNode == false) {
                                        int retryCountInstance;
                                        retryCountInstance = retryCountValue.getIntValue();
                                        retryPolicyInstance.setRetryCount(retryCountInstance);
                                    }
                                }
                                
                                JsonNode errorActionValue = actionValue.get("errorAction");
                                if (errorActionValue != null && errorActionValue instanceof NullNode == false) {
                                    JobErrorAction errorActionInstance = new JobErrorAction();
                                    actionInstance.setErrorAction(errorActionInstance);
                                    
                                    JsonNode typeValue2 = errorActionValue.get("type");
                                    if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                        JobActionType typeInstance2;
                                        typeInstance2 = SchedulerClientImpl.parseJobActionType(typeValue2.getTextValue());
                                        errorActionInstance.setType(typeInstance2);
                                    }
                                    
                                    JsonNode requestValue = errorActionValue.get("request");
                                    if (requestValue != null && requestValue instanceof NullNode == false) {
                                        JobHttpRequest requestInstance = new JobHttpRequest();
                                        errorActionInstance.setRequest(requestInstance);
                                        
                                        JsonNode uriValue = requestValue.get("uri");
                                        if (uriValue != null && uriValue instanceof NullNode == false) {
                                            URI uriInstance;
                                            uriInstance = new URI(uriValue.getTextValue());
                                            requestInstance.setUri(uriInstance);
                                        }
                                        
                                        JsonNode methodValue = requestValue.get("method");
                                        if (methodValue != null && methodValue instanceof NullNode == false) {
                                            String methodInstance;
                                            methodInstance = methodValue.getTextValue();
                                            requestInstance.setMethod(methodInstance);
                                        }
                                        
                                        JsonNode headersSequenceElement = ((JsonNode) requestValue.get("headers"));
                                        if (headersSequenceElement != null && headersSequenceElement instanceof NullNode == false) {
                                            Iterator<Map.Entry<String, JsonNode>> itr = headersSequenceElement.getFields();
                                            while (itr.hasNext()) {
                                                Map.Entry<String, JsonNode> property = itr.next();
                                                String headersKey = property.getKey();
                                                String headersValue = property.getValue().getTextValue();
                                                requestInstance.getHeaders().put(headersKey, headersValue);
                                            }
                                        }
                                        
                                        JsonNode bodyValue = requestValue.get("body");
                                        if (bodyValue != null && bodyValue instanceof NullNode == false) {
                                            String bodyInstance;
                                            bodyInstance = bodyValue.getTextValue();
                                            requestInstance.setBody(bodyInstance);
                                        }
                                        
                                        JsonNode authenticationValue = requestValue.get("authentication");
                                        if (authenticationValue != null && authenticationValue instanceof NullNode == false) {
                                            String typeName = authenticationValue.get("type").getTextValue();
                                            if ("ClientCertificate".equals(typeName)) {
                                                ClientCertAuthentication clientCertAuthenticationInstance = new ClientCertAuthentication();
                                                
                                                JsonNode passwordValue = authenticationValue.get("password");
                                                if (passwordValue != null && passwordValue instanceof NullNode == false) {
                                                    String passwordInstance;
                                                    passwordInstance = passwordValue.getTextValue();
                                                    clientCertAuthenticationInstance.setPassword(passwordInstance);
                                                }
                                                
                                                JsonNode pfxValue = authenticationValue.get("pfx");
                                                if (pfxValue != null && pfxValue instanceof NullNode == false) {
                                                    String pfxInstance;
                                                    pfxInstance = pfxValue.getTextValue();
                                                    clientCertAuthenticationInstance.setPfx(pfxInstance);
                                                }
                                                
                                                JsonNode certificateThumbprintValue = authenticationValue.get("certificateThumbprint");
                                                if (certificateThumbprintValue != null && certificateThumbprintValue instanceof NullNode == false) {
                                                    String certificateThumbprintInstance;
                                                    certificateThumbprintInstance = certificateThumbprintValue.getTextValue();
                                                    clientCertAuthenticationInstance.setCertificateThumbprint(certificateThumbprintInstance);
                                                }
                                                
                                                JsonNode certificateExpirationValue = authenticationValue.get("certificateExpiration");
                                                if (certificateExpirationValue != null && certificateExpirationValue instanceof NullNode == false) {
                                                    Calendar certificateExpirationInstance;
                                                    certificateExpirationInstance = DatatypeConverter.parseDateTime(certificateExpirationValue.getTextValue());
                                                    clientCertAuthenticationInstance.setCertificateExpiration(certificateExpirationInstance);
                                                }
                                                
                                                JsonNode certificateSubjectNameValue = authenticationValue.get("certificateSubjectName");
                                                if (certificateSubjectNameValue != null && certificateSubjectNameValue instanceof NullNode == false) {
                                                    String certificateSubjectNameInstance;
                                                    certificateSubjectNameInstance = certificateSubjectNameValue.getTextValue();
                                                    clientCertAuthenticationInstance.setCertificateSubjectName(certificateSubjectNameInstance);
                                                }
                                                
                                                JsonNode typeValue3 = authenticationValue.get("type");
                                                if (typeValue3 != null && typeValue3 instanceof NullNode == false) {
                                                    HttpAuthenticationType typeInstance3;
                                                    typeInstance3 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue3.getTextValue());
                                                    clientCertAuthenticationInstance.setType(typeInstance3);
                                                }
                                                requestInstance.setAuthentication(clientCertAuthenticationInstance);
                                            }
                                            if ("ActiveDirectoryOAuth".equals(typeName)) {
                                                AADOAuthAuthentication aADOAuthAuthenticationInstance = new AADOAuthAuthentication();
                                                
                                                JsonNode secretValue = authenticationValue.get("secret");
                                                if (secretValue != null && secretValue instanceof NullNode == false) {
                                                    String secretInstance;
                                                    secretInstance = secretValue.getTextValue();
                                                    aADOAuthAuthenticationInstance.setSecret(secretInstance);
                                                }
                                                
                                                JsonNode tenantValue = authenticationValue.get("tenant");
                                                if (tenantValue != null && tenantValue instanceof NullNode == false) {
                                                    String tenantInstance;
                                                    tenantInstance = tenantValue.getTextValue();
                                                    aADOAuthAuthenticationInstance.setTenant(tenantInstance);
                                                }
                                                
                                                JsonNode audienceValue = authenticationValue.get("audience");
                                                if (audienceValue != null && audienceValue instanceof NullNode == false) {
                                                    String audienceInstance;
                                                    audienceInstance = audienceValue.getTextValue();
                                                    aADOAuthAuthenticationInstance.setAudience(audienceInstance);
                                                }
                                                
                                                JsonNode clientIdValue = authenticationValue.get("clientId");
                                                if (clientIdValue != null && clientIdValue instanceof NullNode == false) {
                                                    String clientIdInstance;
                                                    clientIdInstance = clientIdValue.getTextValue();
                                                    aADOAuthAuthenticationInstance.setClientId(clientIdInstance);
                                                }
                                                
                                                JsonNode typeValue4 = authenticationValue.get("type");
                                                if (typeValue4 != null && typeValue4 instanceof NullNode == false) {
                                                    HttpAuthenticationType typeInstance4;
                                                    typeInstance4 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue4.getTextValue());
                                                    aADOAuthAuthenticationInstance.setType(typeInstance4);
                                                }
                                                requestInstance.setAuthentication(aADOAuthAuthenticationInstance);
                                            }
                                            if ("Basic".equals(typeName)) {
                                                BasicAuthentication basicAuthenticationInstance = new BasicAuthentication();
                                                
                                                JsonNode usernameValue = authenticationValue.get("username");
                                                if (usernameValue != null && usernameValue instanceof NullNode == false) {
                                                    String usernameInstance;
                                                    usernameInstance = usernameValue.getTextValue();
                                                    basicAuthenticationInstance.setUsername(usernameInstance);
                                                }
                                                
                                                JsonNode passwordValue2 = authenticationValue.get("password");
                                                if (passwordValue2 != null && passwordValue2 instanceof NullNode == false) {
                                                    String passwordInstance2;
                                                    passwordInstance2 = passwordValue2.getTextValue();
                                                    basicAuthenticationInstance.setPassword(passwordInstance2);
                                                }
                                                
                                                JsonNode typeValue5 = authenticationValue.get("type");
                                                if (typeValue5 != null && typeValue5 instanceof NullNode == false) {
                                                    HttpAuthenticationType typeInstance5;
                                                    typeInstance5 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue5.getTextValue());
                                                    basicAuthenticationInstance.setType(typeInstance5);
                                                }
                                                requestInstance.setAuthentication(basicAuthenticationInstance);
                                            }
                                        }
                                    }
                                    
                                    JsonNode queueMessageValue = errorActionValue.get("queueMessage");
                                    if (queueMessageValue != null && queueMessageValue instanceof NullNode == false) {
                                        JobQueueMessage queueMessageInstance = new JobQueueMessage();
                                        errorActionInstance.setQueueMessage(queueMessageInstance);
                                        
                                        JsonNode storageAccountValue = queueMessageValue.get("storageAccount");
                                        if (storageAccountValue != null && storageAccountValue instanceof NullNode == false) {
                                            String storageAccountInstance;
                                            storageAccountInstance = storageAccountValue.getTextValue();
                                            queueMessageInstance.setStorageAccountName(storageAccountInstance);
                                        }
                                        
                                        JsonNode queueNameValue = queueMessageValue.get("queueName");
                                        if (queueNameValue != null && queueNameValue instanceof NullNode == false) {
                                            String queueNameInstance;
                                            queueNameInstance = queueNameValue.getTextValue();
                                            queueMessageInstance.setQueueName(queueNameInstance);
                                        }
                                        
                                        JsonNode sasTokenValue = queueMessageValue.get("sasToken");
                                        if (sasTokenValue != null && sasTokenValue instanceof NullNode == false) {
                                            String sasTokenInstance;
                                            sasTokenInstance = sasTokenValue.getTextValue();
                                            queueMessageInstance.setSasToken(sasTokenInstance);
                                        }
                                        
                                        JsonNode messageValue = queueMessageValue.get("message");
                                        if (messageValue != null && messageValue instanceof NullNode == false) {
                                            String messageInstance;
                                            messageInstance = messageValue.getTextValue();
                                            queueMessageInstance.setMessage(messageInstance);
                                        }
                                    }
                                    
                                    JsonNode serviceBusTopicMessageValue = errorActionValue.get("serviceBusTopicMessage");
                                    if (serviceBusTopicMessageValue != null && serviceBusTopicMessageValue instanceof NullNode == false) {
                                        JobServiceBusTopicMessage serviceBusTopicMessageInstance = new JobServiceBusTopicMessage();
                                        errorActionInstance.setServiceBusTopicMessage(serviceBusTopicMessageInstance);
                                        
                                        JsonNode topicPathValue = serviceBusTopicMessageValue.get("topicPath");
                                        if (topicPathValue != null && topicPathValue instanceof NullNode == false) {
                                            String topicPathInstance;
                                            topicPathInstance = topicPathValue.getTextValue();
                                            serviceBusTopicMessageInstance.setTopicPath(topicPathInstance);
                                        }
                                        
                                        JsonNode namespaceValue = serviceBusTopicMessageValue.get("namespace");
                                        if (namespaceValue != null && namespaceValue instanceof NullNode == false) {
                                            String namespaceInstance;
                                            namespaceInstance = namespaceValue.getTextValue();
                                            serviceBusTopicMessageInstance.setNamespace(namespaceInstance);
                                        }
                                        
                                        JsonNode transportTypeValue = serviceBusTopicMessageValue.get("transportType");
                                        if (transportTypeValue != null && transportTypeValue instanceof NullNode == false) {
                                            JobServiceBusTransportType transportTypeInstance;
                                            transportTypeInstance = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue.getTextValue());
                                            serviceBusTopicMessageInstance.setTransportType(transportTypeInstance);
                                        }
                                        
                                        JsonNode authenticationValue2 = serviceBusTopicMessageValue.get("authentication");
                                        if (authenticationValue2 != null && authenticationValue2 instanceof NullNode == false) {
                                            JobServiceBusAuthentication authenticationInstance = new JobServiceBusAuthentication();
                                            serviceBusTopicMessageInstance.setAuthentication(authenticationInstance);
                                            
                                            JsonNode sasKeyNameValue = authenticationValue2.get("sasKeyName");
                                            if (sasKeyNameValue != null && sasKeyNameValue instanceof NullNode == false) {
                                                String sasKeyNameInstance;
                                                sasKeyNameInstance = sasKeyNameValue.getTextValue();
                                                authenticationInstance.setSasKeyName(sasKeyNameInstance);
                                            }
                                            
                                            JsonNode sasKeyValue = authenticationValue2.get("sasKey");
                                            if (sasKeyValue != null && sasKeyValue instanceof NullNode == false) {
                                                String sasKeyInstance;
                                                sasKeyInstance = sasKeyValue.getTextValue();
                                                authenticationInstance.setSasKey(sasKeyInstance);
                                            }
                                            
                                            JsonNode typeValue6 = authenticationValue2.get("type");
                                            if (typeValue6 != null && typeValue6 instanceof NullNode == false) {
                                                JobServiceBusAuthenticationType typeInstance6;
                                                typeInstance6 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue6.getTextValue());
                                                authenticationInstance.setType(typeInstance6);
                                            }
                                        }
                                        
                                        JsonNode messageValue2 = serviceBusTopicMessageValue.get("message");
                                        if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                            String messageInstance2;
                                            messageInstance2 = messageValue2.getTextValue();
                                            serviceBusTopicMessageInstance.setMessage(messageInstance2);
                                        }
                                        
                                        JsonNode brokeredMessagePropertiesValue = serviceBusTopicMessageValue.get("brokeredMessageProperties");
                                        if (brokeredMessagePropertiesValue != null && brokeredMessagePropertiesValue instanceof NullNode == false) {
                                            JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance = new JobServiceBusBrokeredMessageProperties();
                                            serviceBusTopicMessageInstance.setBrokeredMessageProperties(brokeredMessagePropertiesInstance);
                                            
                                            JsonNode contentTypeValue = brokeredMessagePropertiesValue.get("contentType");
                                            if (contentTypeValue != null && contentTypeValue instanceof NullNode == false) {
                                                String contentTypeInstance;
                                                contentTypeInstance = contentTypeValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setContentType(contentTypeInstance);
                                            }
                                            
                                            JsonNode correlationIdValue = brokeredMessagePropertiesValue.get("correlationId");
                                            if (correlationIdValue != null && correlationIdValue instanceof NullNode == false) {
                                                String correlationIdInstance;
                                                correlationIdInstance = correlationIdValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setCorrelationId(correlationIdInstance);
                                            }
                                            
                                            JsonNode forcePersistenceValue = brokeredMessagePropertiesValue.get("forcePersistence");
                                            if (forcePersistenceValue != null && forcePersistenceValue instanceof NullNode == false) {
                                                boolean forcePersistenceInstance;
                                                forcePersistenceInstance = forcePersistenceValue.getBooleanValue();
                                                brokeredMessagePropertiesInstance.setForcePersistence(forcePersistenceInstance);
                                            }
                                            
                                            JsonNode labelValue = brokeredMessagePropertiesValue.get("label");
                                            if (labelValue != null && labelValue instanceof NullNode == false) {
                                                String labelInstance;
                                                labelInstance = labelValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setLabel(labelInstance);
                                            }
                                            
                                            JsonNode messageIdValue = brokeredMessagePropertiesValue.get("messageId");
                                            if (messageIdValue != null && messageIdValue instanceof NullNode == false) {
                                                String messageIdInstance;
                                                messageIdInstance = messageIdValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setMessageId(messageIdInstance);
                                            }
                                            
                                            JsonNode partitionKeyValue = brokeredMessagePropertiesValue.get("partitionKey");
                                            if (partitionKeyValue != null && partitionKeyValue instanceof NullNode == false) {
                                                String partitionKeyInstance;
                                                partitionKeyInstance = partitionKeyValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setPartitionKey(partitionKeyInstance);
                                            }
                                            
                                            JsonNode replyToValue = brokeredMessagePropertiesValue.get("replyTo");
                                            if (replyToValue != null && replyToValue instanceof NullNode == false) {
                                                String replyToInstance;
                                                replyToInstance = replyToValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setReplyTo(replyToInstance);
                                            }
                                            
                                            JsonNode replyToSessionIdValue = brokeredMessagePropertiesValue.get("replyToSessionId");
                                            if (replyToSessionIdValue != null && replyToSessionIdValue instanceof NullNode == false) {
                                                String replyToSessionIdInstance;
                                                replyToSessionIdInstance = replyToSessionIdValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setReplyToSessionId(replyToSessionIdInstance);
                                            }
                                            
                                            JsonNode scheduledEnqueueTimeUtcValue = brokeredMessagePropertiesValue.get("scheduledEnqueueTimeUtc");
                                            if (scheduledEnqueueTimeUtcValue != null && scheduledEnqueueTimeUtcValue instanceof NullNode == false) {
                                                Calendar scheduledEnqueueTimeUtcInstance;
                                                scheduledEnqueueTimeUtcInstance = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue.getTextValue());
                                                brokeredMessagePropertiesInstance.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance);
                                            }
                                            
                                            JsonNode sessionIdValue = brokeredMessagePropertiesValue.get("sessionId");
                                            if (sessionIdValue != null && sessionIdValue instanceof NullNode == false) {
                                                String sessionIdInstance;
                                                sessionIdInstance = sessionIdValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setSessionId(sessionIdInstance);
                                            }
                                            
                                            JsonNode timeToLiveValue = brokeredMessagePropertiesValue.get("timeToLive");
                                            if (timeToLiveValue != null && timeToLiveValue instanceof NullNode == false) {
                                                Calendar timeToLiveInstance;
                                                timeToLiveInstance = DatatypeConverter.parseDateTime(timeToLiveValue.getTextValue());
                                                brokeredMessagePropertiesInstance.setTimeToLive(timeToLiveInstance);
                                            }
                                            
                                            JsonNode toValue = brokeredMessagePropertiesValue.get("to");
                                            if (toValue != null && toValue instanceof NullNode == false) {
                                                String toInstance;
                                                toInstance = toValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setTo(toInstance);
                                            }
                                            
                                            JsonNode viaPartitionKeyValue = brokeredMessagePropertiesValue.get("viaPartitionKey");
                                            if (viaPartitionKeyValue != null && viaPartitionKeyValue instanceof NullNode == false) {
                                                String viaPartitionKeyInstance;
                                                viaPartitionKeyInstance = viaPartitionKeyValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setViaPartitionKey(viaPartitionKeyInstance);
                                            }
                                        }
                                        
                                        JsonNode customMessagePropertiesSequenceElement = ((JsonNode) serviceBusTopicMessageValue.get("customMessageProperties"));
                                        if (customMessagePropertiesSequenceElement != null && customMessagePropertiesSequenceElement instanceof NullNode == false) {
                                            Iterator<Map.Entry<String, JsonNode>> itr2 = customMessagePropertiesSequenceElement.getFields();
                                            while (itr2.hasNext()) {
                                                Map.Entry<String, JsonNode> property2 = itr2.next();
                                                String customMessagePropertiesKey = property2.getKey();
                                                String customMessagePropertiesValue = property2.getValue().getTextValue();
                                                serviceBusTopicMessageInstance.getCustomMessageProperties().put(customMessagePropertiesKey, customMessagePropertiesValue);
                                            }
                                        }
                                    }
                                    
                                    JsonNode serviceBusQueueMessageValue = errorActionValue.get("serviceBusQueueMessage");
                                    if (serviceBusQueueMessageValue != null && serviceBusQueueMessageValue instanceof NullNode == false) {
                                        JobServiceBusQueueMessage serviceBusQueueMessageInstance = new JobServiceBusQueueMessage();
                                        errorActionInstance.setServiceBusQueueMessage(serviceBusQueueMessageInstance);
                                        
                                        JsonNode queueNameValue2 = serviceBusQueueMessageValue.get("queueName");
                                        if (queueNameValue2 != null && queueNameValue2 instanceof NullNode == false) {
                                            String queueNameInstance2;
                                            queueNameInstance2 = queueNameValue2.getTextValue();
                                            serviceBusQueueMessageInstance.setQueueName(queueNameInstance2);
                                        }
                                        
                                        JsonNode namespaceValue2 = serviceBusQueueMessageValue.get("namespace");
                                        if (namespaceValue2 != null && namespaceValue2 instanceof NullNode == false) {
                                            String namespaceInstance2;
                                            namespaceInstance2 = namespaceValue2.getTextValue();
                                            serviceBusQueueMessageInstance.setNamespace(namespaceInstance2);
                                        }
                                        
                                        JsonNode transportTypeValue2 = serviceBusQueueMessageValue.get("transportType");
                                        if (transportTypeValue2 != null && transportTypeValue2 instanceof NullNode == false) {
                                            JobServiceBusTransportType transportTypeInstance2;
                                            transportTypeInstance2 = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue2.getTextValue());
                                            serviceBusQueueMessageInstance.setTransportType(transportTypeInstance2);
                                        }
                                        
                                        JsonNode authenticationValue3 = serviceBusQueueMessageValue.get("authentication");
                                        if (authenticationValue3 != null && authenticationValue3 instanceof NullNode == false) {
                                            JobServiceBusAuthentication authenticationInstance2 = new JobServiceBusAuthentication();
                                            serviceBusQueueMessageInstance.setAuthentication(authenticationInstance2);
                                            
                                            JsonNode sasKeyNameValue2 = authenticationValue3.get("sasKeyName");
                                            if (sasKeyNameValue2 != null && sasKeyNameValue2 instanceof NullNode == false) {
                                                String sasKeyNameInstance2;
                                                sasKeyNameInstance2 = sasKeyNameValue2.getTextValue();
                                                authenticationInstance2.setSasKeyName(sasKeyNameInstance2);
                                            }
                                            
                                            JsonNode sasKeyValue2 = authenticationValue3.get("sasKey");
                                            if (sasKeyValue2 != null && sasKeyValue2 instanceof NullNode == false) {
                                                String sasKeyInstance2;
                                                sasKeyInstance2 = sasKeyValue2.getTextValue();
                                                authenticationInstance2.setSasKey(sasKeyInstance2);
                                            }
                                            
                                            JsonNode typeValue7 = authenticationValue3.get("type");
                                            if (typeValue7 != null && typeValue7 instanceof NullNode == false) {
                                                JobServiceBusAuthenticationType typeInstance7;
                                                typeInstance7 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue7.getTextValue());
                                                authenticationInstance2.setType(typeInstance7);
                                            }
                                        }
                                        
                                        JsonNode messageValue3 = serviceBusQueueMessageValue.get("message");
                                        if (messageValue3 != null && messageValue3 instanceof NullNode == false) {
                                            String messageInstance3;
                                            messageInstance3 = messageValue3.getTextValue();
                                            serviceBusQueueMessageInstance.setMessage(messageInstance3);
                                        }
                                        
                                        JsonNode brokeredMessagePropertiesValue2 = serviceBusQueueMessageValue.get("brokeredMessageProperties");
                                        if (brokeredMessagePropertiesValue2 != null && brokeredMessagePropertiesValue2 instanceof NullNode == false) {
                                            JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance2 = new JobServiceBusBrokeredMessageProperties();
                                            serviceBusQueueMessageInstance.setBrokeredMessageProperties(brokeredMessagePropertiesInstance2);
                                            
                                            JsonNode contentTypeValue2 = brokeredMessagePropertiesValue2.get("contentType");
                                            if (contentTypeValue2 != null && contentTypeValue2 instanceof NullNode == false) {
                                                String contentTypeInstance2;
                                                contentTypeInstance2 = contentTypeValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setContentType(contentTypeInstance2);
                                            }
                                            
                                            JsonNode correlationIdValue2 = brokeredMessagePropertiesValue2.get("correlationId");
                                            if (correlationIdValue2 != null && correlationIdValue2 instanceof NullNode == false) {
                                                String correlationIdInstance2;
                                                correlationIdInstance2 = correlationIdValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setCorrelationId(correlationIdInstance2);
                                            }
                                            
                                            JsonNode forcePersistenceValue2 = brokeredMessagePropertiesValue2.get("forcePersistence");
                                            if (forcePersistenceValue2 != null && forcePersistenceValue2 instanceof NullNode == false) {
                                                boolean forcePersistenceInstance2;
                                                forcePersistenceInstance2 = forcePersistenceValue2.getBooleanValue();
                                                brokeredMessagePropertiesInstance2.setForcePersistence(forcePersistenceInstance2);
                                            }
                                            
                                            JsonNode labelValue2 = brokeredMessagePropertiesValue2.get("label");
                                            if (labelValue2 != null && labelValue2 instanceof NullNode == false) {
                                                String labelInstance2;
                                                labelInstance2 = labelValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setLabel(labelInstance2);
                                            }
                                            
                                            JsonNode messageIdValue2 = brokeredMessagePropertiesValue2.get("messageId");
                                            if (messageIdValue2 != null && messageIdValue2 instanceof NullNode == false) {
                                                String messageIdInstance2;
                                                messageIdInstance2 = messageIdValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setMessageId(messageIdInstance2);
                                            }
                                            
                                            JsonNode partitionKeyValue2 = brokeredMessagePropertiesValue2.get("partitionKey");
                                            if (partitionKeyValue2 != null && partitionKeyValue2 instanceof NullNode == false) {
                                                String partitionKeyInstance2;
                                                partitionKeyInstance2 = partitionKeyValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setPartitionKey(partitionKeyInstance2);
                                            }
                                            
                                            JsonNode replyToValue2 = brokeredMessagePropertiesValue2.get("replyTo");
                                            if (replyToValue2 != null && replyToValue2 instanceof NullNode == false) {
                                                String replyToInstance2;
                                                replyToInstance2 = replyToValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setReplyTo(replyToInstance2);
                                            }
                                            
                                            JsonNode replyToSessionIdValue2 = brokeredMessagePropertiesValue2.get("replyToSessionId");
                                            if (replyToSessionIdValue2 != null && replyToSessionIdValue2 instanceof NullNode == false) {
                                                String replyToSessionIdInstance2;
                                                replyToSessionIdInstance2 = replyToSessionIdValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setReplyToSessionId(replyToSessionIdInstance2);
                                            }
                                            
                                            JsonNode scheduledEnqueueTimeUtcValue2 = brokeredMessagePropertiesValue2.get("scheduledEnqueueTimeUtc");
                                            if (scheduledEnqueueTimeUtcValue2 != null && scheduledEnqueueTimeUtcValue2 instanceof NullNode == false) {
                                                Calendar scheduledEnqueueTimeUtcInstance2;
                                                scheduledEnqueueTimeUtcInstance2 = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue2.getTextValue());
                                                brokeredMessagePropertiesInstance2.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance2);
                                            }
                                            
                                            JsonNode sessionIdValue2 = brokeredMessagePropertiesValue2.get("sessionId");
                                            if (sessionIdValue2 != null && sessionIdValue2 instanceof NullNode == false) {
                                                String sessionIdInstance2;
                                                sessionIdInstance2 = sessionIdValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setSessionId(sessionIdInstance2);
                                            }
                                            
                                            JsonNode timeToLiveValue2 = brokeredMessagePropertiesValue2.get("timeToLive");
                                            if (timeToLiveValue2 != null && timeToLiveValue2 instanceof NullNode == false) {
                                                Calendar timeToLiveInstance2;
                                                timeToLiveInstance2 = DatatypeConverter.parseDateTime(timeToLiveValue2.getTextValue());
                                                brokeredMessagePropertiesInstance2.setTimeToLive(timeToLiveInstance2);
                                            }
                                            
                                            JsonNode toValue2 = brokeredMessagePropertiesValue2.get("to");
                                            if (toValue2 != null && toValue2 instanceof NullNode == false) {
                                                String toInstance2;
                                                toInstance2 = toValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setTo(toInstance2);
                                            }
                                            
                                            JsonNode viaPartitionKeyValue2 = brokeredMessagePropertiesValue2.get("viaPartitionKey");
                                            if (viaPartitionKeyValue2 != null && viaPartitionKeyValue2 instanceof NullNode == false) {
                                                String viaPartitionKeyInstance2;
                                                viaPartitionKeyInstance2 = viaPartitionKeyValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setViaPartitionKey(viaPartitionKeyInstance2);
                                            }
                                        }
                                        
                                        JsonNode customMessagePropertiesSequenceElement2 = ((JsonNode) serviceBusQueueMessageValue.get("customMessageProperties"));
                                        if (customMessagePropertiesSequenceElement2 != null && customMessagePropertiesSequenceElement2 instanceof NullNode == false) {
                                            Iterator<Map.Entry<String, JsonNode>> itr3 = customMessagePropertiesSequenceElement2.getFields();
                                            while (itr3.hasNext()) {
                                                Map.Entry<String, JsonNode> property3 = itr3.next();
                                                String customMessagePropertiesKey2 = property3.getKey();
                                                String customMessagePropertiesValue2 = property3.getValue().getTextValue();
                                                serviceBusQueueMessageInstance.getCustomMessageProperties().put(customMessagePropertiesKey2, customMessagePropertiesValue2);
                                            }
                                        }
                                    }
                                }
                                
                                JsonNode requestValue2 = actionValue.get("request");
                                if (requestValue2 != null && requestValue2 instanceof NullNode == false) {
                                    JobHttpRequest requestInstance2 = new JobHttpRequest();
                                    actionInstance.setRequest(requestInstance2);
                                    
                                    JsonNode uriValue2 = requestValue2.get("uri");
                                    if (uriValue2 != null && uriValue2 instanceof NullNode == false) {
                                        URI uriInstance2;
                                        uriInstance2 = new URI(uriValue2.getTextValue());
                                        requestInstance2.setUri(uriInstance2);
                                    }
                                    
                                    JsonNode methodValue2 = requestValue2.get("method");
                                    if (methodValue2 != null && methodValue2 instanceof NullNode == false) {
                                        String methodInstance2;
                                        methodInstance2 = methodValue2.getTextValue();
                                        requestInstance2.setMethod(methodInstance2);
                                    }
                                    
                                    JsonNode headersSequenceElement2 = ((JsonNode) requestValue2.get("headers"));
                                    if (headersSequenceElement2 != null && headersSequenceElement2 instanceof NullNode == false) {
                                        Iterator<Map.Entry<String, JsonNode>> itr4 = headersSequenceElement2.getFields();
                                        while (itr4.hasNext()) {
                                            Map.Entry<String, JsonNode> property4 = itr4.next();
                                            String headersKey2 = property4.getKey();
                                            String headersValue2 = property4.getValue().getTextValue();
                                            requestInstance2.getHeaders().put(headersKey2, headersValue2);
                                        }
                                    }
                                    
                                    JsonNode bodyValue2 = requestValue2.get("body");
                                    if (bodyValue2 != null && bodyValue2 instanceof NullNode == false) {
                                        String bodyInstance2;
                                        bodyInstance2 = bodyValue2.getTextValue();
                                        requestInstance2.setBody(bodyInstance2);
                                    }
                                    
                                    JsonNode authenticationValue4 = requestValue2.get("authentication");
                                    if (authenticationValue4 != null && authenticationValue4 instanceof NullNode == false) {
                                        String typeName2 = authenticationValue4.get("type").getTextValue();
                                        if ("ClientCertificate".equals(typeName2)) {
                                            ClientCertAuthentication clientCertAuthenticationInstance2 = new ClientCertAuthentication();
                                            
                                            JsonNode passwordValue3 = authenticationValue4.get("password");
                                            if (passwordValue3 != null && passwordValue3 instanceof NullNode == false) {
                                                String passwordInstance3;
                                                passwordInstance3 = passwordValue3.getTextValue();
                                                clientCertAuthenticationInstance2.setPassword(passwordInstance3);
                                            }
                                            
                                            JsonNode pfxValue2 = authenticationValue4.get("pfx");
                                            if (pfxValue2 != null && pfxValue2 instanceof NullNode == false) {
                                                String pfxInstance2;
                                                pfxInstance2 = pfxValue2.getTextValue();
                                                clientCertAuthenticationInstance2.setPfx(pfxInstance2);
                                            }
                                            
                                            JsonNode certificateThumbprintValue2 = authenticationValue4.get("certificateThumbprint");
                                            if (certificateThumbprintValue2 != null && certificateThumbprintValue2 instanceof NullNode == false) {
                                                String certificateThumbprintInstance2;
                                                certificateThumbprintInstance2 = certificateThumbprintValue2.getTextValue();
                                                clientCertAuthenticationInstance2.setCertificateThumbprint(certificateThumbprintInstance2);
                                            }
                                            
                                            JsonNode certificateExpirationValue2 = authenticationValue4.get("certificateExpiration");
                                            if (certificateExpirationValue2 != null && certificateExpirationValue2 instanceof NullNode == false) {
                                                Calendar certificateExpirationInstance2;
                                                certificateExpirationInstance2 = DatatypeConverter.parseDateTime(certificateExpirationValue2.getTextValue());
                                                clientCertAuthenticationInstance2.setCertificateExpiration(certificateExpirationInstance2);
                                            }
                                            
                                            JsonNode certificateSubjectNameValue2 = authenticationValue4.get("certificateSubjectName");
                                            if (certificateSubjectNameValue2 != null && certificateSubjectNameValue2 instanceof NullNode == false) {
                                                String certificateSubjectNameInstance2;
                                                certificateSubjectNameInstance2 = certificateSubjectNameValue2.getTextValue();
                                                clientCertAuthenticationInstance2.setCertificateSubjectName(certificateSubjectNameInstance2);
                                            }
                                            
                                            JsonNode typeValue8 = authenticationValue4.get("type");
                                            if (typeValue8 != null && typeValue8 instanceof NullNode == false) {
                                                HttpAuthenticationType typeInstance8;
                                                typeInstance8 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue8.getTextValue());
                                                clientCertAuthenticationInstance2.setType(typeInstance8);
                                            }
                                            requestInstance2.setAuthentication(clientCertAuthenticationInstance2);
                                        }
                                        if ("ActiveDirectoryOAuth".equals(typeName2)) {
                                            AADOAuthAuthentication aADOAuthAuthenticationInstance2 = new AADOAuthAuthentication();
                                            
                                            JsonNode secretValue2 = authenticationValue4.get("secret");
                                            if (secretValue2 != null && secretValue2 instanceof NullNode == false) {
                                                String secretInstance2;
                                                secretInstance2 = secretValue2.getTextValue();
                                                aADOAuthAuthenticationInstance2.setSecret(secretInstance2);
                                            }
                                            
                                            JsonNode tenantValue2 = authenticationValue4.get("tenant");
                                            if (tenantValue2 != null && tenantValue2 instanceof NullNode == false) {
                                                String tenantInstance2;
                                                tenantInstance2 = tenantValue2.getTextValue();
                                                aADOAuthAuthenticationInstance2.setTenant(tenantInstance2);
                                            }
                                            
                                            JsonNode audienceValue2 = authenticationValue4.get("audience");
                                            if (audienceValue2 != null && audienceValue2 instanceof NullNode == false) {
                                                String audienceInstance2;
                                                audienceInstance2 = audienceValue2.getTextValue();
                                                aADOAuthAuthenticationInstance2.setAudience(audienceInstance2);
                                            }
                                            
                                            JsonNode clientIdValue2 = authenticationValue4.get("clientId");
                                            if (clientIdValue2 != null && clientIdValue2 instanceof NullNode == false) {
                                                String clientIdInstance2;
                                                clientIdInstance2 = clientIdValue2.getTextValue();
                                                aADOAuthAuthenticationInstance2.setClientId(clientIdInstance2);
                                            }
                                            
                                            JsonNode typeValue9 = authenticationValue4.get("type");
                                            if (typeValue9 != null && typeValue9 instanceof NullNode == false) {
                                                HttpAuthenticationType typeInstance9;
                                                typeInstance9 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue9.getTextValue());
                                                aADOAuthAuthenticationInstance2.setType(typeInstance9);
                                            }
                                            requestInstance2.setAuthentication(aADOAuthAuthenticationInstance2);
                                        }
                                        if ("Basic".equals(typeName2)) {
                                            BasicAuthentication basicAuthenticationInstance2 = new BasicAuthentication();
                                            
                                            JsonNode usernameValue2 = authenticationValue4.get("username");
                                            if (usernameValue2 != null && usernameValue2 instanceof NullNode == false) {
                                                String usernameInstance2;
                                                usernameInstance2 = usernameValue2.getTextValue();
                                                basicAuthenticationInstance2.setUsername(usernameInstance2);
                                            }
                                            
                                            JsonNode passwordValue4 = authenticationValue4.get("password");
                                            if (passwordValue4 != null && passwordValue4 instanceof NullNode == false) {
                                                String passwordInstance4;
                                                passwordInstance4 = passwordValue4.getTextValue();
                                                basicAuthenticationInstance2.setPassword(passwordInstance4);
                                            }
                                            
                                            JsonNode typeValue10 = authenticationValue4.get("type");
                                            if (typeValue10 != null && typeValue10 instanceof NullNode == false) {
                                                HttpAuthenticationType typeInstance10;
                                                typeInstance10 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue10.getTextValue());
                                                basicAuthenticationInstance2.setType(typeInstance10);
                                            }
                                            requestInstance2.setAuthentication(basicAuthenticationInstance2);
                                        }
                                    }
                                }
                                
                                JsonNode queueMessageValue2 = actionValue.get("queueMessage");
                                if (queueMessageValue2 != null && queueMessageValue2 instanceof NullNode == false) {
                                    JobQueueMessage queueMessageInstance2 = new JobQueueMessage();
                                    actionInstance.setQueueMessage(queueMessageInstance2);
                                    
                                    JsonNode storageAccountValue2 = queueMessageValue2.get("storageAccount");
                                    if (storageAccountValue2 != null && storageAccountValue2 instanceof NullNode == false) {
                                        String storageAccountInstance2;
                                        storageAccountInstance2 = storageAccountValue2.getTextValue();
                                        queueMessageInstance2.setStorageAccountName(storageAccountInstance2);
                                    }
                                    
                                    JsonNode queueNameValue3 = queueMessageValue2.get("queueName");
                                    if (queueNameValue3 != null && queueNameValue3 instanceof NullNode == false) {
                                        String queueNameInstance3;
                                        queueNameInstance3 = queueNameValue3.getTextValue();
                                        queueMessageInstance2.setQueueName(queueNameInstance3);
                                    }
                                    
                                    JsonNode sasTokenValue2 = queueMessageValue2.get("sasToken");
                                    if (sasTokenValue2 != null && sasTokenValue2 instanceof NullNode == false) {
                                        String sasTokenInstance2;
                                        sasTokenInstance2 = sasTokenValue2.getTextValue();
                                        queueMessageInstance2.setSasToken(sasTokenInstance2);
                                    }
                                    
                                    JsonNode messageValue4 = queueMessageValue2.get("message");
                                    if (messageValue4 != null && messageValue4 instanceof NullNode == false) {
                                        String messageInstance4;
                                        messageInstance4 = messageValue4.getTextValue();
                                        queueMessageInstance2.setMessage(messageInstance4);
                                    }
                                }
                                
                                JsonNode serviceBusTopicMessageValue2 = actionValue.get("serviceBusTopicMessage");
                                if (serviceBusTopicMessageValue2 != null && serviceBusTopicMessageValue2 instanceof NullNode == false) {
                                    JobServiceBusTopicMessage serviceBusTopicMessageInstance2 = new JobServiceBusTopicMessage();
                                    actionInstance.setServiceBusTopicMessage(serviceBusTopicMessageInstance2);
                                    
                                    JsonNode topicPathValue2 = serviceBusTopicMessageValue2.get("topicPath");
                                    if (topicPathValue2 != null && topicPathValue2 instanceof NullNode == false) {
                                        String topicPathInstance2;
                                        topicPathInstance2 = topicPathValue2.getTextValue();
                                        serviceBusTopicMessageInstance2.setTopicPath(topicPathInstance2);
                                    }
                                    
                                    JsonNode namespaceValue3 = serviceBusTopicMessageValue2.get("namespace");
                                    if (namespaceValue3 != null && namespaceValue3 instanceof NullNode == false) {
                                        String namespaceInstance3;
                                        namespaceInstance3 = namespaceValue3.getTextValue();
                                        serviceBusTopicMessageInstance2.setNamespace(namespaceInstance3);
                                    }
                                    
                                    JsonNode transportTypeValue3 = serviceBusTopicMessageValue2.get("transportType");
                                    if (transportTypeValue3 != null && transportTypeValue3 instanceof NullNode == false) {
                                        JobServiceBusTransportType transportTypeInstance3;
                                        transportTypeInstance3 = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue3.getTextValue());
                                        serviceBusTopicMessageInstance2.setTransportType(transportTypeInstance3);
                                    }
                                    
                                    JsonNode authenticationValue5 = serviceBusTopicMessageValue2.get("authentication");
                                    if (authenticationValue5 != null && authenticationValue5 instanceof NullNode == false) {
                                        JobServiceBusAuthentication authenticationInstance3 = new JobServiceBusAuthentication();
                                        serviceBusTopicMessageInstance2.setAuthentication(authenticationInstance3);
                                        
                                        JsonNode sasKeyNameValue3 = authenticationValue5.get("sasKeyName");
                                        if (sasKeyNameValue3 != null && sasKeyNameValue3 instanceof NullNode == false) {
                                            String sasKeyNameInstance3;
                                            sasKeyNameInstance3 = sasKeyNameValue3.getTextValue();
                                            authenticationInstance3.setSasKeyName(sasKeyNameInstance3);
                                        }
                                        
                                        JsonNode sasKeyValue3 = authenticationValue5.get("sasKey");
                                        if (sasKeyValue3 != null && sasKeyValue3 instanceof NullNode == false) {
                                            String sasKeyInstance3;
                                            sasKeyInstance3 = sasKeyValue3.getTextValue();
                                            authenticationInstance3.setSasKey(sasKeyInstance3);
                                        }
                                        
                                        JsonNode typeValue11 = authenticationValue5.get("type");
                                        if (typeValue11 != null && typeValue11 instanceof NullNode == false) {
                                            JobServiceBusAuthenticationType typeInstance11;
                                            typeInstance11 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue11.getTextValue());
                                            authenticationInstance3.setType(typeInstance11);
                                        }
                                    }
                                    
                                    JsonNode messageValue5 = serviceBusTopicMessageValue2.get("message");
                                    if (messageValue5 != null && messageValue5 instanceof NullNode == false) {
                                        String messageInstance5;
                                        messageInstance5 = messageValue5.getTextValue();
                                        serviceBusTopicMessageInstance2.setMessage(messageInstance5);
                                    }
                                    
                                    JsonNode brokeredMessagePropertiesValue3 = serviceBusTopicMessageValue2.get("brokeredMessageProperties");
                                    if (brokeredMessagePropertiesValue3 != null && brokeredMessagePropertiesValue3 instanceof NullNode == false) {
                                        JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance3 = new JobServiceBusBrokeredMessageProperties();
                                        serviceBusTopicMessageInstance2.setBrokeredMessageProperties(brokeredMessagePropertiesInstance3);
                                        
                                        JsonNode contentTypeValue3 = brokeredMessagePropertiesValue3.get("contentType");
                                        if (contentTypeValue3 != null && contentTypeValue3 instanceof NullNode == false) {
                                            String contentTypeInstance3;
                                            contentTypeInstance3 = contentTypeValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setContentType(contentTypeInstance3);
                                        }
                                        
                                        JsonNode correlationIdValue3 = brokeredMessagePropertiesValue3.get("correlationId");
                                        if (correlationIdValue3 != null && correlationIdValue3 instanceof NullNode == false) {
                                            String correlationIdInstance3;
                                            correlationIdInstance3 = correlationIdValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setCorrelationId(correlationIdInstance3);
                                        }
                                        
                                        JsonNode forcePersistenceValue3 = brokeredMessagePropertiesValue3.get("forcePersistence");
                                        if (forcePersistenceValue3 != null && forcePersistenceValue3 instanceof NullNode == false) {
                                            boolean forcePersistenceInstance3;
                                            forcePersistenceInstance3 = forcePersistenceValue3.getBooleanValue();
                                            brokeredMessagePropertiesInstance3.setForcePersistence(forcePersistenceInstance3);
                                        }
                                        
                                        JsonNode labelValue3 = brokeredMessagePropertiesValue3.get("label");
                                        if (labelValue3 != null && labelValue3 instanceof NullNode == false) {
                                            String labelInstance3;
                                            labelInstance3 = labelValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setLabel(labelInstance3);
                                        }
                                        
                                        JsonNode messageIdValue3 = brokeredMessagePropertiesValue3.get("messageId");
                                        if (messageIdValue3 != null && messageIdValue3 instanceof NullNode == false) {
                                            String messageIdInstance3;
                                            messageIdInstance3 = messageIdValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setMessageId(messageIdInstance3);
                                        }
                                        
                                        JsonNode partitionKeyValue3 = brokeredMessagePropertiesValue3.get("partitionKey");
                                        if (partitionKeyValue3 != null && partitionKeyValue3 instanceof NullNode == false) {
                                            String partitionKeyInstance3;
                                            partitionKeyInstance3 = partitionKeyValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setPartitionKey(partitionKeyInstance3);
                                        }
                                        
                                        JsonNode replyToValue3 = brokeredMessagePropertiesValue3.get("replyTo");
                                        if (replyToValue3 != null && replyToValue3 instanceof NullNode == false) {
                                            String replyToInstance3;
                                            replyToInstance3 = replyToValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setReplyTo(replyToInstance3);
                                        }
                                        
                                        JsonNode replyToSessionIdValue3 = brokeredMessagePropertiesValue3.get("replyToSessionId");
                                        if (replyToSessionIdValue3 != null && replyToSessionIdValue3 instanceof NullNode == false) {
                                            String replyToSessionIdInstance3;
                                            replyToSessionIdInstance3 = replyToSessionIdValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setReplyToSessionId(replyToSessionIdInstance3);
                                        }
                                        
                                        JsonNode scheduledEnqueueTimeUtcValue3 = brokeredMessagePropertiesValue3.get("scheduledEnqueueTimeUtc");
                                        if (scheduledEnqueueTimeUtcValue3 != null && scheduledEnqueueTimeUtcValue3 instanceof NullNode == false) {
                                            Calendar scheduledEnqueueTimeUtcInstance3;
                                            scheduledEnqueueTimeUtcInstance3 = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue3.getTextValue());
                                            brokeredMessagePropertiesInstance3.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance3);
                                        }
                                        
                                        JsonNode sessionIdValue3 = brokeredMessagePropertiesValue3.get("sessionId");
                                        if (sessionIdValue3 != null && sessionIdValue3 instanceof NullNode == false) {
                                            String sessionIdInstance3;
                                            sessionIdInstance3 = sessionIdValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setSessionId(sessionIdInstance3);
                                        }
                                        
                                        JsonNode timeToLiveValue3 = brokeredMessagePropertiesValue3.get("timeToLive");
                                        if (timeToLiveValue3 != null && timeToLiveValue3 instanceof NullNode == false) {
                                            Calendar timeToLiveInstance3;
                                            timeToLiveInstance3 = DatatypeConverter.parseDateTime(timeToLiveValue3.getTextValue());
                                            brokeredMessagePropertiesInstance3.setTimeToLive(timeToLiveInstance3);
                                        }
                                        
                                        JsonNode toValue3 = brokeredMessagePropertiesValue3.get("to");
                                        if (toValue3 != null && toValue3 instanceof NullNode == false) {
                                            String toInstance3;
                                            toInstance3 = toValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setTo(toInstance3);
                                        }
                                        
                                        JsonNode viaPartitionKeyValue3 = brokeredMessagePropertiesValue3.get("viaPartitionKey");
                                        if (viaPartitionKeyValue3 != null && viaPartitionKeyValue3 instanceof NullNode == false) {
                                            String viaPartitionKeyInstance3;
                                            viaPartitionKeyInstance3 = viaPartitionKeyValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setViaPartitionKey(viaPartitionKeyInstance3);
                                        }
                                    }
                                    
                                    JsonNode customMessagePropertiesSequenceElement3 = ((JsonNode) serviceBusTopicMessageValue2.get("customMessageProperties"));
                                    if (customMessagePropertiesSequenceElement3 != null && customMessagePropertiesSequenceElement3 instanceof NullNode == false) {
                                        Iterator<Map.Entry<String, JsonNode>> itr5 = customMessagePropertiesSequenceElement3.getFields();
                                        while (itr5.hasNext()) {
                                            Map.Entry<String, JsonNode> property5 = itr5.next();
                                            String customMessagePropertiesKey3 = property5.getKey();
                                            String customMessagePropertiesValue3 = property5.getValue().getTextValue();
                                            serviceBusTopicMessageInstance2.getCustomMessageProperties().put(customMessagePropertiesKey3, customMessagePropertiesValue3);
                                        }
                                    }
                                }
                                
                                JsonNode serviceBusQueueMessageValue2 = actionValue.get("serviceBusQueueMessage");
                                if (serviceBusQueueMessageValue2 != null && serviceBusQueueMessageValue2 instanceof NullNode == false) {
                                    JobServiceBusQueueMessage serviceBusQueueMessageInstance2 = new JobServiceBusQueueMessage();
                                    actionInstance.setServiceBusQueueMessage(serviceBusQueueMessageInstance2);
                                    
                                    JsonNode queueNameValue4 = serviceBusQueueMessageValue2.get("queueName");
                                    if (queueNameValue4 != null && queueNameValue4 instanceof NullNode == false) {
                                        String queueNameInstance4;
                                        queueNameInstance4 = queueNameValue4.getTextValue();
                                        serviceBusQueueMessageInstance2.setQueueName(queueNameInstance4);
                                    }
                                    
                                    JsonNode namespaceValue4 = serviceBusQueueMessageValue2.get("namespace");
                                    if (namespaceValue4 != null && namespaceValue4 instanceof NullNode == false) {
                                        String namespaceInstance4;
                                        namespaceInstance4 = namespaceValue4.getTextValue();
                                        serviceBusQueueMessageInstance2.setNamespace(namespaceInstance4);
                                    }
                                    
                                    JsonNode transportTypeValue4 = serviceBusQueueMessageValue2.get("transportType");
                                    if (transportTypeValue4 != null && transportTypeValue4 instanceof NullNode == false) {
                                        JobServiceBusTransportType transportTypeInstance4;
                                        transportTypeInstance4 = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue4.getTextValue());
                                        serviceBusQueueMessageInstance2.setTransportType(transportTypeInstance4);
                                    }
                                    
                                    JsonNode authenticationValue6 = serviceBusQueueMessageValue2.get("authentication");
                                    if (authenticationValue6 != null && authenticationValue6 instanceof NullNode == false) {
                                        JobServiceBusAuthentication authenticationInstance4 = new JobServiceBusAuthentication();
                                        serviceBusQueueMessageInstance2.setAuthentication(authenticationInstance4);
                                        
                                        JsonNode sasKeyNameValue4 = authenticationValue6.get("sasKeyName");
                                        if (sasKeyNameValue4 != null && sasKeyNameValue4 instanceof NullNode == false) {
                                            String sasKeyNameInstance4;
                                            sasKeyNameInstance4 = sasKeyNameValue4.getTextValue();
                                            authenticationInstance4.setSasKeyName(sasKeyNameInstance4);
                                        }
                                        
                                        JsonNode sasKeyValue4 = authenticationValue6.get("sasKey");
                                        if (sasKeyValue4 != null && sasKeyValue4 instanceof NullNode == false) {
                                            String sasKeyInstance4;
                                            sasKeyInstance4 = sasKeyValue4.getTextValue();
                                            authenticationInstance4.setSasKey(sasKeyInstance4);
                                        }
                                        
                                        JsonNode typeValue12 = authenticationValue6.get("type");
                                        if (typeValue12 != null && typeValue12 instanceof NullNode == false) {
                                            JobServiceBusAuthenticationType typeInstance12;
                                            typeInstance12 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue12.getTextValue());
                                            authenticationInstance4.setType(typeInstance12);
                                        }
                                    }
                                    
                                    JsonNode messageValue6 = serviceBusQueueMessageValue2.get("message");
                                    if (messageValue6 != null && messageValue6 instanceof NullNode == false) {
                                        String messageInstance6;
                                        messageInstance6 = messageValue6.getTextValue();
                                        serviceBusQueueMessageInstance2.setMessage(messageInstance6);
                                    }
                                    
                                    JsonNode brokeredMessagePropertiesValue4 = serviceBusQueueMessageValue2.get("brokeredMessageProperties");
                                    if (brokeredMessagePropertiesValue4 != null && brokeredMessagePropertiesValue4 instanceof NullNode == false) {
                                        JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance4 = new JobServiceBusBrokeredMessageProperties();
                                        serviceBusQueueMessageInstance2.setBrokeredMessageProperties(brokeredMessagePropertiesInstance4);
                                        
                                        JsonNode contentTypeValue4 = brokeredMessagePropertiesValue4.get("contentType");
                                        if (contentTypeValue4 != null && contentTypeValue4 instanceof NullNode == false) {
                                            String contentTypeInstance4;
                                            contentTypeInstance4 = contentTypeValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setContentType(contentTypeInstance4);
                                        }
                                        
                                        JsonNode correlationIdValue4 = brokeredMessagePropertiesValue4.get("correlationId");
                                        if (correlationIdValue4 != null && correlationIdValue4 instanceof NullNode == false) {
                                            String correlationIdInstance4;
                                            correlationIdInstance4 = correlationIdValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setCorrelationId(correlationIdInstance4);
                                        }
                                        
                                        JsonNode forcePersistenceValue4 = brokeredMessagePropertiesValue4.get("forcePersistence");
                                        if (forcePersistenceValue4 != null && forcePersistenceValue4 instanceof NullNode == false) {
                                            boolean forcePersistenceInstance4;
                                            forcePersistenceInstance4 = forcePersistenceValue4.getBooleanValue();
                                            brokeredMessagePropertiesInstance4.setForcePersistence(forcePersistenceInstance4);
                                        }
                                        
                                        JsonNode labelValue4 = brokeredMessagePropertiesValue4.get("label");
                                        if (labelValue4 != null && labelValue4 instanceof NullNode == false) {
                                            String labelInstance4;
                                            labelInstance4 = labelValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setLabel(labelInstance4);
                                        }
                                        
                                        JsonNode messageIdValue4 = brokeredMessagePropertiesValue4.get("messageId");
                                        if (messageIdValue4 != null && messageIdValue4 instanceof NullNode == false) {
                                            String messageIdInstance4;
                                            messageIdInstance4 = messageIdValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setMessageId(messageIdInstance4);
                                        }
                                        
                                        JsonNode partitionKeyValue4 = brokeredMessagePropertiesValue4.get("partitionKey");
                                        if (partitionKeyValue4 != null && partitionKeyValue4 instanceof NullNode == false) {
                                            String partitionKeyInstance4;
                                            partitionKeyInstance4 = partitionKeyValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setPartitionKey(partitionKeyInstance4);
                                        }
                                        
                                        JsonNode replyToValue4 = brokeredMessagePropertiesValue4.get("replyTo");
                                        if (replyToValue4 != null && replyToValue4 instanceof NullNode == false) {
                                            String replyToInstance4;
                                            replyToInstance4 = replyToValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setReplyTo(replyToInstance4);
                                        }
                                        
                                        JsonNode replyToSessionIdValue4 = brokeredMessagePropertiesValue4.get("replyToSessionId");
                                        if (replyToSessionIdValue4 != null && replyToSessionIdValue4 instanceof NullNode == false) {
                                            String replyToSessionIdInstance4;
                                            replyToSessionIdInstance4 = replyToSessionIdValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setReplyToSessionId(replyToSessionIdInstance4);
                                        }
                                        
                                        JsonNode scheduledEnqueueTimeUtcValue4 = brokeredMessagePropertiesValue4.get("scheduledEnqueueTimeUtc");
                                        if (scheduledEnqueueTimeUtcValue4 != null && scheduledEnqueueTimeUtcValue4 instanceof NullNode == false) {
                                            Calendar scheduledEnqueueTimeUtcInstance4;
                                            scheduledEnqueueTimeUtcInstance4 = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue4.getTextValue());
                                            brokeredMessagePropertiesInstance4.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance4);
                                        }
                                        
                                        JsonNode sessionIdValue4 = brokeredMessagePropertiesValue4.get("sessionId");
                                        if (sessionIdValue4 != null && sessionIdValue4 instanceof NullNode == false) {
                                            String sessionIdInstance4;
                                            sessionIdInstance4 = sessionIdValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setSessionId(sessionIdInstance4);
                                        }
                                        
                                        JsonNode timeToLiveValue4 = brokeredMessagePropertiesValue4.get("timeToLive");
                                        if (timeToLiveValue4 != null && timeToLiveValue4 instanceof NullNode == false) {
                                            Calendar timeToLiveInstance4;
                                            timeToLiveInstance4 = DatatypeConverter.parseDateTime(timeToLiveValue4.getTextValue());
                                            brokeredMessagePropertiesInstance4.setTimeToLive(timeToLiveInstance4);
                                        }
                                        
                                        JsonNode toValue4 = brokeredMessagePropertiesValue4.get("to");
                                        if (toValue4 != null && toValue4 instanceof NullNode == false) {
                                            String toInstance4;
                                            toInstance4 = toValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setTo(toInstance4);
                                        }
                                        
                                        JsonNode viaPartitionKeyValue4 = brokeredMessagePropertiesValue4.get("viaPartitionKey");
                                        if (viaPartitionKeyValue4 != null && viaPartitionKeyValue4 instanceof NullNode == false) {
                                            String viaPartitionKeyInstance4;
                                            viaPartitionKeyInstance4 = viaPartitionKeyValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setViaPartitionKey(viaPartitionKeyInstance4);
                                        }
                                    }
                                    
                                    JsonNode customMessagePropertiesSequenceElement4 = ((JsonNode) serviceBusQueueMessageValue2.get("customMessageProperties"));
                                    if (customMessagePropertiesSequenceElement4 != null && customMessagePropertiesSequenceElement4 instanceof NullNode == false) {
                                        Iterator<Map.Entry<String, JsonNode>> itr6 = customMessagePropertiesSequenceElement4.getFields();
                                        while (itr6.hasNext()) {
                                            Map.Entry<String, JsonNode> property6 = itr6.next();
                                            String customMessagePropertiesKey4 = property6.getKey();
                                            String customMessagePropertiesValue4 = property6.getValue().getTextValue();
                                            serviceBusQueueMessageInstance2.getCustomMessageProperties().put(customMessagePropertiesKey4, customMessagePropertiesValue4);
                                        }
                                    }
                                }
                            }
                            
                            JsonNode recurrenceValue = jobsValue.get("recurrence");
                            if (recurrenceValue != null && recurrenceValue instanceof NullNode == false) {
                                JobRecurrence recurrenceInstance = new JobRecurrence();
                                jobInstance.setRecurrence(recurrenceInstance);
                                
                                JsonNode frequencyValue = recurrenceValue.get("frequency");
                                if (frequencyValue != null && frequencyValue instanceof NullNode == false) {
                                    JobRecurrenceFrequency frequencyInstance;
                                    frequencyInstance = SchedulerClientImpl.parseJobRecurrenceFrequency(frequencyValue.getTextValue());
                                    recurrenceInstance.setFrequency(frequencyInstance);
                                }
                                
                                JsonNode intervalValue = recurrenceValue.get("interval");
                                if (intervalValue != null && intervalValue instanceof NullNode == false) {
                                    int intervalInstance;
                                    intervalInstance = intervalValue.getIntValue();
                                    recurrenceInstance.setInterval(intervalInstance);
                                }
                                
                                JsonNode countValue = recurrenceValue.get("count");
                                if (countValue != null && countValue instanceof NullNode == false) {
                                    int countInstance;
                                    countInstance = countValue.getIntValue();
                                    recurrenceInstance.setCount(countInstance);
                                }
                                
                                JsonNode endTimeValue = recurrenceValue.get("endTime");
                                if (endTimeValue != null && endTimeValue instanceof NullNode == false) {
                                    Calendar endTimeInstance;
                                    endTimeInstance = DatatypeConverter.parseDateTime(endTimeValue.getTextValue());
                                    recurrenceInstance.setEndTime(endTimeInstance);
                                }
                                
                                JsonNode scheduleValue = recurrenceValue.get("schedule");
                                if (scheduleValue != null && scheduleValue instanceof NullNode == false) {
                                    JobRecurrenceSchedule scheduleInstance = new JobRecurrenceSchedule();
                                    recurrenceInstance.setSchedule(scheduleInstance);
                                    
                                    JsonNode minutesArray = scheduleValue.get("minutes");
                                    if (minutesArray != null && minutesArray instanceof NullNode == false) {
                                        scheduleInstance.setMinutes(new ArrayList<Integer>());
                                        for (JsonNode minutesValue : ((ArrayNode) minutesArray)) {
                                            scheduleInstance.getMinutes().add(minutesValue.getIntValue());
                                        }
                                    }
                                    
                                    JsonNode hoursArray = scheduleValue.get("hours");
                                    if (hoursArray != null && hoursArray instanceof NullNode == false) {
                                        scheduleInstance.setHours(new ArrayList<Integer>());
                                        for (JsonNode hoursValue : ((ArrayNode) hoursArray)) {
                                            scheduleInstance.getHours().add(hoursValue.getIntValue());
                                        }
                                    }
                                    
                                    JsonNode weekDaysArray = scheduleValue.get("weekDays");
                                    if (weekDaysArray != null && weekDaysArray instanceof NullNode == false) {
                                        scheduleInstance.setDays(new ArrayList<JobScheduleDay>());
                                        for (JsonNode weekDaysValue : ((ArrayNode) weekDaysArray)) {
                                            scheduleInstance.getDays().add(SchedulerClientImpl.parseJobScheduleDay(weekDaysValue.getTextValue()));
                                        }
                                    }
                                    
                                    JsonNode monthsArray = scheduleValue.get("months");
                                    if (monthsArray != null && monthsArray instanceof NullNode == false) {
                                        scheduleInstance.setMonths(new ArrayList<Integer>());
                                        for (JsonNode monthsValue : ((ArrayNode) monthsArray)) {
                                            scheduleInstance.getMonths().add(monthsValue.getIntValue());
                                        }
                                    }
                                    
                                    JsonNode monthDaysArray = scheduleValue.get("monthDays");
                                    if (monthDaysArray != null && monthDaysArray instanceof NullNode == false) {
                                        scheduleInstance.setMonthDays(new ArrayList<Integer>());
                                        for (JsonNode monthDaysValue : ((ArrayNode) monthDaysArray)) {
                                            scheduleInstance.getMonthDays().add(monthDaysValue.getIntValue());
                                        }
                                    }
                                    
                                    JsonNode monthlyOccurrencesArray = scheduleValue.get("monthlyOccurrences");
                                    if (monthlyOccurrencesArray != null && monthlyOccurrencesArray instanceof NullNode == false) {
                                        scheduleInstance.setMonthlyOccurrences(new ArrayList<JobScheduleMonthlyOccurrence>());
                                        for (JsonNode monthlyOccurrencesValue : ((ArrayNode) monthlyOccurrencesArray)) {
                                            JobScheduleMonthlyOccurrence jobScheduleMonthlyOccurrenceInstance = new JobScheduleMonthlyOccurrence();
                                            scheduleInstance.getMonthlyOccurrences().add(jobScheduleMonthlyOccurrenceInstance);
                                            
                                            JsonNode dayValue = monthlyOccurrencesValue.get("day");
                                            if (dayValue != null && dayValue instanceof NullNode == false) {
                                                JobScheduleDay dayInstance;
                                                dayInstance = SchedulerClientImpl.parseJobScheduleDay(dayValue.getTextValue());
                                                jobScheduleMonthlyOccurrenceInstance.setDay(dayInstance);
                                            }
                                            
                                            JsonNode occurrenceValue = monthlyOccurrencesValue.get("occurrence");
                                            if (occurrenceValue != null && occurrenceValue instanceof NullNode == false) {
                                                int occurrenceInstance;
                                                occurrenceInstance = occurrenceValue.getIntValue();
                                                jobScheduleMonthlyOccurrenceInstance.setOccurrence(occurrenceInstance);
                                            }
                                        }
                                    }
                                }
                            }
                            
                            JsonNode statusValue = jobsValue.get("status");
                            if (statusValue != null && statusValue instanceof NullNode == false) {
                                JobStatus statusInstance = new JobStatus();
                                jobInstance.setStatus(statusInstance);
                                
                                JsonNode lastExecutionTimeValue = statusValue.get("lastExecutionTime");
                                if (lastExecutionTimeValue != null && lastExecutionTimeValue instanceof NullNode == false) {
                                    Calendar lastExecutionTimeInstance;
                                    lastExecutionTimeInstance = DatatypeConverter.parseDateTime(lastExecutionTimeValue.getTextValue());
                                    statusInstance.setLastExecutionTime(lastExecutionTimeInstance);
                                }
                                
                                JsonNode nextExecutionTimeValue = statusValue.get("nextExecutionTime");
                                if (nextExecutionTimeValue != null && nextExecutionTimeValue instanceof NullNode == false) {
                                    Calendar nextExecutionTimeInstance;
                                    nextExecutionTimeInstance = DatatypeConverter.parseDateTime(nextExecutionTimeValue.getTextValue());
                                    statusInstance.setNextExecutionTime(nextExecutionTimeInstance);
                                }
                                
                                JsonNode executionCountValue = statusValue.get("executionCount");
                                if (executionCountValue != null && executionCountValue instanceof NullNode == false) {
                                    int executionCountInstance;
                                    executionCountInstance = executionCountValue.getIntValue();
                                    statusInstance.setExecutionCount(executionCountInstance);
                                }
                                
                                JsonNode failureCountValue = statusValue.get("failureCount");
                                if (failureCountValue != null && failureCountValue instanceof NullNode == false) {
                                    int failureCountInstance;
                                    failureCountInstance = failureCountValue.getIntValue();
                                    statusInstance.setFailureCount(failureCountInstance);
                                }
                                
                                JsonNode faultedCountValue = statusValue.get("faultedCount");
                                if (faultedCountValue != null && faultedCountValue instanceof NullNode == false) {
                                    int faultedCountInstance;
                                    faultedCountInstance = faultedCountValue.getIntValue();
                                    statusInstance.setFaultedCount(faultedCountInstance);
                                }
                            }
                            
                            JsonNode stateValue = jobsValue.get("state");
                            if (stateValue != null && stateValue instanceof NullNode == false) {
                                JobState stateInstance;
                                stateInstance = SchedulerClientImpl.parseJobState(stateValue.getTextValue());
                                jobInstance.setState(stateInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Update the state of all jobs in a job collections.
    *
    * @param parameters Required. Parameters supplied to the Update Jobs State
    * operation.
    * @return The Update Jobs State operation response.
    */
    @Override
    public Future<JobCollectionJobsUpdateStateResponse> updateJobCollectionStateAsync(final JobCollectionJobsUpdateStateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<JobCollectionJobsUpdateStateResponse>() { 
            @Override
            public JobCollectionJobsUpdateStateResponse call() throws Exception {
                return updateJobCollectionState(parameters);
            }
         });
    }
    
    /**
    * Update the state of all jobs in a job collections.
    *
    * @param parameters Required. Parameters supplied to the Update Jobs State
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Update Jobs State operation response.
    */
    @Override
    public JobCollectionJobsUpdateStateResponse updateJobCollectionState(JobCollectionJobsUpdateStateParameters parameters) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getState() == null) {
            throw new NullPointerException("parameters.State");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "updateJobCollectionStateAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/cloudservices/";
        url = url + URLEncoder.encode(this.getClient().getCloudServiceName(), "UTF-8");
        url = url + "/resources/";
        url = url + "scheduler";
        url = url + "/~/";
        url = url + "JobCollections";
        url = url + "/";
        url = url + URLEncoder.encode(this.getClient().getJobCollectionName(), "UTF-8");
        url = url + "/jobs";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPatch httpRequest = new HttpPatch(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        httpRequest.setHeader("x-ms-version", "2013-03-01");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode jobCollectionJobsUpdateStateParametersValue = objectMapper.createObjectNode();
        requestDoc = jobCollectionJobsUpdateStateParametersValue;
        
        ((ObjectNode) jobCollectionJobsUpdateStateParametersValue).put("state", SchedulerClientImpl.jobStateToString(parameters.getState()));
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            JobCollectionJobsUpdateStateResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new JobCollectionJobsUpdateStateResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode jobsArray = responseDoc;
                    if (jobsArray != null && jobsArray instanceof NullNode == false) {
                        for (JsonNode jobsValue : ((ArrayNode) jobsArray)) {
                            Job jobInstance = new Job();
                            result.getJobs().add(jobInstance);
                            
                            JsonNode idValue = jobsValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                jobInstance.setId(idInstance);
                            }
                            
                            JsonNode startTimeValue = jobsValue.get("startTime");
                            if (startTimeValue != null && startTimeValue instanceof NullNode == false) {
                                Calendar startTimeInstance;
                                startTimeInstance = DatatypeConverter.parseDateTime(startTimeValue.getTextValue());
                                jobInstance.setStartTime(startTimeInstance);
                            }
                            
                            JsonNode actionValue = jobsValue.get("action");
                            if (actionValue != null && actionValue instanceof NullNode == false) {
                                JobAction actionInstance = new JobAction();
                                jobInstance.setAction(actionInstance);
                                
                                JsonNode typeValue = actionValue.get("type");
                                if (typeValue != null && typeValue instanceof NullNode == false) {
                                    JobActionType typeInstance;
                                    typeInstance = SchedulerClientImpl.parseJobActionType(typeValue.getTextValue());
                                    actionInstance.setType(typeInstance);
                                }
                                
                                JsonNode retryPolicyValue = actionValue.get("retryPolicy");
                                if (retryPolicyValue != null && retryPolicyValue instanceof NullNode == false) {
                                    RetryPolicy retryPolicyInstance = new RetryPolicy();
                                    actionInstance.setRetryPolicy(retryPolicyInstance);
                                    
                                    JsonNode retryTypeValue = retryPolicyValue.get("retryType");
                                    if (retryTypeValue != null && retryTypeValue instanceof NullNode == false) {
                                        RetryType retryTypeInstance;
                                        retryTypeInstance = SchedulerClientImpl.parseRetryType(retryTypeValue.getTextValue());
                                        retryPolicyInstance.setRetryType(retryTypeInstance);
                                    }
                                    
                                    JsonNode retryIntervalValue = retryPolicyValue.get("retryInterval");
                                    if (retryIntervalValue != null && retryIntervalValue instanceof NullNode == false) {
                                        Duration retryIntervalInstance;
                                        retryIntervalInstance = TimeSpan8601Converter.parse(retryIntervalValue.getTextValue());
                                        retryPolicyInstance.setRetryInterval(retryIntervalInstance);
                                    }
                                    
                                    JsonNode retryCountValue = retryPolicyValue.get("retryCount");
                                    if (retryCountValue != null && retryCountValue instanceof NullNode == false) {
                                        int retryCountInstance;
                                        retryCountInstance = retryCountValue.getIntValue();
                                        retryPolicyInstance.setRetryCount(retryCountInstance);
                                    }
                                }
                                
                                JsonNode errorActionValue = actionValue.get("errorAction");
                                if (errorActionValue != null && errorActionValue instanceof NullNode == false) {
                                    JobErrorAction errorActionInstance = new JobErrorAction();
                                    actionInstance.setErrorAction(errorActionInstance);
                                    
                                    JsonNode typeValue2 = errorActionValue.get("type");
                                    if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                        JobActionType typeInstance2;
                                        typeInstance2 = SchedulerClientImpl.parseJobActionType(typeValue2.getTextValue());
                                        errorActionInstance.setType(typeInstance2);
                                    }
                                    
                                    JsonNode requestValue = errorActionValue.get("request");
                                    if (requestValue != null && requestValue instanceof NullNode == false) {
                                        JobHttpRequest requestInstance = new JobHttpRequest();
                                        errorActionInstance.setRequest(requestInstance);
                                        
                                        JsonNode uriValue = requestValue.get("uri");
                                        if (uriValue != null && uriValue instanceof NullNode == false) {
                                            URI uriInstance;
                                            uriInstance = new URI(uriValue.getTextValue());
                                            requestInstance.setUri(uriInstance);
                                        }
                                        
                                        JsonNode methodValue = requestValue.get("method");
                                        if (methodValue != null && methodValue instanceof NullNode == false) {
                                            String methodInstance;
                                            methodInstance = methodValue.getTextValue();
                                            requestInstance.setMethod(methodInstance);
                                        }
                                        
                                        JsonNode headersSequenceElement = ((JsonNode) requestValue.get("headers"));
                                        if (headersSequenceElement != null && headersSequenceElement instanceof NullNode == false) {
                                            Iterator<Map.Entry<String, JsonNode>> itr = headersSequenceElement.getFields();
                                            while (itr.hasNext()) {
                                                Map.Entry<String, JsonNode> property = itr.next();
                                                String headersKey = property.getKey();
                                                String headersValue = property.getValue().getTextValue();
                                                requestInstance.getHeaders().put(headersKey, headersValue);
                                            }
                                        }
                                        
                                        JsonNode bodyValue = requestValue.get("body");
                                        if (bodyValue != null && bodyValue instanceof NullNode == false) {
                                            String bodyInstance;
                                            bodyInstance = bodyValue.getTextValue();
                                            requestInstance.setBody(bodyInstance);
                                        }
                                        
                                        JsonNode authenticationValue = requestValue.get("authentication");
                                        if (authenticationValue != null && authenticationValue instanceof NullNode == false) {
                                            String typeName = authenticationValue.get("type").getTextValue();
                                            if ("ClientCertificate".equals(typeName)) {
                                                ClientCertAuthentication clientCertAuthenticationInstance = new ClientCertAuthentication();
                                                
                                                JsonNode passwordValue = authenticationValue.get("password");
                                                if (passwordValue != null && passwordValue instanceof NullNode == false) {
                                                    String passwordInstance;
                                                    passwordInstance = passwordValue.getTextValue();
                                                    clientCertAuthenticationInstance.setPassword(passwordInstance);
                                                }
                                                
                                                JsonNode pfxValue = authenticationValue.get("pfx");
                                                if (pfxValue != null && pfxValue instanceof NullNode == false) {
                                                    String pfxInstance;
                                                    pfxInstance = pfxValue.getTextValue();
                                                    clientCertAuthenticationInstance.setPfx(pfxInstance);
                                                }
                                                
                                                JsonNode certificateThumbprintValue = authenticationValue.get("certificateThumbprint");
                                                if (certificateThumbprintValue != null && certificateThumbprintValue instanceof NullNode == false) {
                                                    String certificateThumbprintInstance;
                                                    certificateThumbprintInstance = certificateThumbprintValue.getTextValue();
                                                    clientCertAuthenticationInstance.setCertificateThumbprint(certificateThumbprintInstance);
                                                }
                                                
                                                JsonNode certificateExpirationValue = authenticationValue.get("certificateExpiration");
                                                if (certificateExpirationValue != null && certificateExpirationValue instanceof NullNode == false) {
                                                    Calendar certificateExpirationInstance;
                                                    certificateExpirationInstance = DatatypeConverter.parseDateTime(certificateExpirationValue.getTextValue());
                                                    clientCertAuthenticationInstance.setCertificateExpiration(certificateExpirationInstance);
                                                }
                                                
                                                JsonNode certificateSubjectNameValue = authenticationValue.get("certificateSubjectName");
                                                if (certificateSubjectNameValue != null && certificateSubjectNameValue instanceof NullNode == false) {
                                                    String certificateSubjectNameInstance;
                                                    certificateSubjectNameInstance = certificateSubjectNameValue.getTextValue();
                                                    clientCertAuthenticationInstance.setCertificateSubjectName(certificateSubjectNameInstance);
                                                }
                                                
                                                JsonNode typeValue3 = authenticationValue.get("type");
                                                if (typeValue3 != null && typeValue3 instanceof NullNode == false) {
                                                    HttpAuthenticationType typeInstance3;
                                                    typeInstance3 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue3.getTextValue());
                                                    clientCertAuthenticationInstance.setType(typeInstance3);
                                                }
                                                requestInstance.setAuthentication(clientCertAuthenticationInstance);
                                            }
                                            if ("ActiveDirectoryOAuth".equals(typeName)) {
                                                AADOAuthAuthentication aADOAuthAuthenticationInstance = new AADOAuthAuthentication();
                                                
                                                JsonNode secretValue = authenticationValue.get("secret");
                                                if (secretValue != null && secretValue instanceof NullNode == false) {
                                                    String secretInstance;
                                                    secretInstance = secretValue.getTextValue();
                                                    aADOAuthAuthenticationInstance.setSecret(secretInstance);
                                                }
                                                
                                                JsonNode tenantValue = authenticationValue.get("tenant");
                                                if (tenantValue != null && tenantValue instanceof NullNode == false) {
                                                    String tenantInstance;
                                                    tenantInstance = tenantValue.getTextValue();
                                                    aADOAuthAuthenticationInstance.setTenant(tenantInstance);
                                                }
                                                
                                                JsonNode audienceValue = authenticationValue.get("audience");
                                                if (audienceValue != null && audienceValue instanceof NullNode == false) {
                                                    String audienceInstance;
                                                    audienceInstance = audienceValue.getTextValue();
                                                    aADOAuthAuthenticationInstance.setAudience(audienceInstance);
                                                }
                                                
                                                JsonNode clientIdValue = authenticationValue.get("clientId");
                                                if (clientIdValue != null && clientIdValue instanceof NullNode == false) {
                                                    String clientIdInstance;
                                                    clientIdInstance = clientIdValue.getTextValue();
                                                    aADOAuthAuthenticationInstance.setClientId(clientIdInstance);
                                                }
                                                
                                                JsonNode typeValue4 = authenticationValue.get("type");
                                                if (typeValue4 != null && typeValue4 instanceof NullNode == false) {
                                                    HttpAuthenticationType typeInstance4;
                                                    typeInstance4 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue4.getTextValue());
                                                    aADOAuthAuthenticationInstance.setType(typeInstance4);
                                                }
                                                requestInstance.setAuthentication(aADOAuthAuthenticationInstance);
                                            }
                                            if ("Basic".equals(typeName)) {
                                                BasicAuthentication basicAuthenticationInstance = new BasicAuthentication();
                                                
                                                JsonNode usernameValue = authenticationValue.get("username");
                                                if (usernameValue != null && usernameValue instanceof NullNode == false) {
                                                    String usernameInstance;
                                                    usernameInstance = usernameValue.getTextValue();
                                                    basicAuthenticationInstance.setUsername(usernameInstance);
                                                }
                                                
                                                JsonNode passwordValue2 = authenticationValue.get("password");
                                                if (passwordValue2 != null && passwordValue2 instanceof NullNode == false) {
                                                    String passwordInstance2;
                                                    passwordInstance2 = passwordValue2.getTextValue();
                                                    basicAuthenticationInstance.setPassword(passwordInstance2);
                                                }
                                                
                                                JsonNode typeValue5 = authenticationValue.get("type");
                                                if (typeValue5 != null && typeValue5 instanceof NullNode == false) {
                                                    HttpAuthenticationType typeInstance5;
                                                    typeInstance5 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue5.getTextValue());
                                                    basicAuthenticationInstance.setType(typeInstance5);
                                                }
                                                requestInstance.setAuthentication(basicAuthenticationInstance);
                                            }
                                        }
                                    }
                                    
                                    JsonNode queueMessageValue = errorActionValue.get("queueMessage");
                                    if (queueMessageValue != null && queueMessageValue instanceof NullNode == false) {
                                        JobQueueMessage queueMessageInstance = new JobQueueMessage();
                                        errorActionInstance.setQueueMessage(queueMessageInstance);
                                        
                                        JsonNode storageAccountValue = queueMessageValue.get("storageAccount");
                                        if (storageAccountValue != null && storageAccountValue instanceof NullNode == false) {
                                            String storageAccountInstance;
                                            storageAccountInstance = storageAccountValue.getTextValue();
                                            queueMessageInstance.setStorageAccountName(storageAccountInstance);
                                        }
                                        
                                        JsonNode queueNameValue = queueMessageValue.get("queueName");
                                        if (queueNameValue != null && queueNameValue instanceof NullNode == false) {
                                            String queueNameInstance;
                                            queueNameInstance = queueNameValue.getTextValue();
                                            queueMessageInstance.setQueueName(queueNameInstance);
                                        }
                                        
                                        JsonNode sasTokenValue = queueMessageValue.get("sasToken");
                                        if (sasTokenValue != null && sasTokenValue instanceof NullNode == false) {
                                            String sasTokenInstance;
                                            sasTokenInstance = sasTokenValue.getTextValue();
                                            queueMessageInstance.setSasToken(sasTokenInstance);
                                        }
                                        
                                        JsonNode messageValue = queueMessageValue.get("message");
                                        if (messageValue != null && messageValue instanceof NullNode == false) {
                                            String messageInstance;
                                            messageInstance = messageValue.getTextValue();
                                            queueMessageInstance.setMessage(messageInstance);
                                        }
                                    }
                                    
                                    JsonNode serviceBusTopicMessageValue = errorActionValue.get("serviceBusTopicMessage");
                                    if (serviceBusTopicMessageValue != null && serviceBusTopicMessageValue instanceof NullNode == false) {
                                        JobServiceBusTopicMessage serviceBusTopicMessageInstance = new JobServiceBusTopicMessage();
                                        errorActionInstance.setServiceBusTopicMessage(serviceBusTopicMessageInstance);
                                        
                                        JsonNode topicPathValue = serviceBusTopicMessageValue.get("topicPath");
                                        if (topicPathValue != null && topicPathValue instanceof NullNode == false) {
                                            String topicPathInstance;
                                            topicPathInstance = topicPathValue.getTextValue();
                                            serviceBusTopicMessageInstance.setTopicPath(topicPathInstance);
                                        }
                                        
                                        JsonNode namespaceValue = serviceBusTopicMessageValue.get("namespace");
                                        if (namespaceValue != null && namespaceValue instanceof NullNode == false) {
                                            String namespaceInstance;
                                            namespaceInstance = namespaceValue.getTextValue();
                                            serviceBusTopicMessageInstance.setNamespace(namespaceInstance);
                                        }
                                        
                                        JsonNode transportTypeValue = serviceBusTopicMessageValue.get("transportType");
                                        if (transportTypeValue != null && transportTypeValue instanceof NullNode == false) {
                                            JobServiceBusTransportType transportTypeInstance;
                                            transportTypeInstance = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue.getTextValue());
                                            serviceBusTopicMessageInstance.setTransportType(transportTypeInstance);
                                        }
                                        
                                        JsonNode authenticationValue2 = serviceBusTopicMessageValue.get("authentication");
                                        if (authenticationValue2 != null && authenticationValue2 instanceof NullNode == false) {
                                            JobServiceBusAuthentication authenticationInstance = new JobServiceBusAuthentication();
                                            serviceBusTopicMessageInstance.setAuthentication(authenticationInstance);
                                            
                                            JsonNode sasKeyNameValue = authenticationValue2.get("sasKeyName");
                                            if (sasKeyNameValue != null && sasKeyNameValue instanceof NullNode == false) {
                                                String sasKeyNameInstance;
                                                sasKeyNameInstance = sasKeyNameValue.getTextValue();
                                                authenticationInstance.setSasKeyName(sasKeyNameInstance);
                                            }
                                            
                                            JsonNode sasKeyValue = authenticationValue2.get("sasKey");
                                            if (sasKeyValue != null && sasKeyValue instanceof NullNode == false) {
                                                String sasKeyInstance;
                                                sasKeyInstance = sasKeyValue.getTextValue();
                                                authenticationInstance.setSasKey(sasKeyInstance);
                                            }
                                            
                                            JsonNode typeValue6 = authenticationValue2.get("type");
                                            if (typeValue6 != null && typeValue6 instanceof NullNode == false) {
                                                JobServiceBusAuthenticationType typeInstance6;
                                                typeInstance6 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue6.getTextValue());
                                                authenticationInstance.setType(typeInstance6);
                                            }
                                        }
                                        
                                        JsonNode messageValue2 = serviceBusTopicMessageValue.get("message");
                                        if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                            String messageInstance2;
                                            messageInstance2 = messageValue2.getTextValue();
                                            serviceBusTopicMessageInstance.setMessage(messageInstance2);
                                        }
                                        
                                        JsonNode brokeredMessagePropertiesValue = serviceBusTopicMessageValue.get("brokeredMessageProperties");
                                        if (brokeredMessagePropertiesValue != null && brokeredMessagePropertiesValue instanceof NullNode == false) {
                                            JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance = new JobServiceBusBrokeredMessageProperties();
                                            serviceBusTopicMessageInstance.setBrokeredMessageProperties(brokeredMessagePropertiesInstance);
                                            
                                            JsonNode contentTypeValue = brokeredMessagePropertiesValue.get("contentType");
                                            if (contentTypeValue != null && contentTypeValue instanceof NullNode == false) {
                                                String contentTypeInstance;
                                                contentTypeInstance = contentTypeValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setContentType(contentTypeInstance);
                                            }
                                            
                                            JsonNode correlationIdValue = brokeredMessagePropertiesValue.get("correlationId");
                                            if (correlationIdValue != null && correlationIdValue instanceof NullNode == false) {
                                                String correlationIdInstance;
                                                correlationIdInstance = correlationIdValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setCorrelationId(correlationIdInstance);
                                            }
                                            
                                            JsonNode forcePersistenceValue = brokeredMessagePropertiesValue.get("forcePersistence");
                                            if (forcePersistenceValue != null && forcePersistenceValue instanceof NullNode == false) {
                                                boolean forcePersistenceInstance;
                                                forcePersistenceInstance = forcePersistenceValue.getBooleanValue();
                                                brokeredMessagePropertiesInstance.setForcePersistence(forcePersistenceInstance);
                                            }
                                            
                                            JsonNode labelValue = brokeredMessagePropertiesValue.get("label");
                                            if (labelValue != null && labelValue instanceof NullNode == false) {
                                                String labelInstance;
                                                labelInstance = labelValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setLabel(labelInstance);
                                            }
                                            
                                            JsonNode messageIdValue = brokeredMessagePropertiesValue.get("messageId");
                                            if (messageIdValue != null && messageIdValue instanceof NullNode == false) {
                                                String messageIdInstance;
                                                messageIdInstance = messageIdValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setMessageId(messageIdInstance);
                                            }
                                            
                                            JsonNode partitionKeyValue = brokeredMessagePropertiesValue.get("partitionKey");
                                            if (partitionKeyValue != null && partitionKeyValue instanceof NullNode == false) {
                                                String partitionKeyInstance;
                                                partitionKeyInstance = partitionKeyValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setPartitionKey(partitionKeyInstance);
                                            }
                                            
                                            JsonNode replyToValue = brokeredMessagePropertiesValue.get("replyTo");
                                            if (replyToValue != null && replyToValue instanceof NullNode == false) {
                                                String replyToInstance;
                                                replyToInstance = replyToValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setReplyTo(replyToInstance);
                                            }
                                            
                                            JsonNode replyToSessionIdValue = brokeredMessagePropertiesValue.get("replyToSessionId");
                                            if (replyToSessionIdValue != null && replyToSessionIdValue instanceof NullNode == false) {
                                                String replyToSessionIdInstance;
                                                replyToSessionIdInstance = replyToSessionIdValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setReplyToSessionId(replyToSessionIdInstance);
                                            }
                                            
                                            JsonNode scheduledEnqueueTimeUtcValue = brokeredMessagePropertiesValue.get("scheduledEnqueueTimeUtc");
                                            if (scheduledEnqueueTimeUtcValue != null && scheduledEnqueueTimeUtcValue instanceof NullNode == false) {
                                                Calendar scheduledEnqueueTimeUtcInstance;
                                                scheduledEnqueueTimeUtcInstance = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue.getTextValue());
                                                brokeredMessagePropertiesInstance.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance);
                                            }
                                            
                                            JsonNode sessionIdValue = brokeredMessagePropertiesValue.get("sessionId");
                                            if (sessionIdValue != null && sessionIdValue instanceof NullNode == false) {
                                                String sessionIdInstance;
                                                sessionIdInstance = sessionIdValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setSessionId(sessionIdInstance);
                                            }
                                            
                                            JsonNode timeToLiveValue = brokeredMessagePropertiesValue.get("timeToLive");
                                            if (timeToLiveValue != null && timeToLiveValue instanceof NullNode == false) {
                                                Calendar timeToLiveInstance;
                                                timeToLiveInstance = DatatypeConverter.parseDateTime(timeToLiveValue.getTextValue());
                                                brokeredMessagePropertiesInstance.setTimeToLive(timeToLiveInstance);
                                            }
                                            
                                            JsonNode toValue = brokeredMessagePropertiesValue.get("to");
                                            if (toValue != null && toValue instanceof NullNode == false) {
                                                String toInstance;
                                                toInstance = toValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setTo(toInstance);
                                            }
                                            
                                            JsonNode viaPartitionKeyValue = brokeredMessagePropertiesValue.get("viaPartitionKey");
                                            if (viaPartitionKeyValue != null && viaPartitionKeyValue instanceof NullNode == false) {
                                                String viaPartitionKeyInstance;
                                                viaPartitionKeyInstance = viaPartitionKeyValue.getTextValue();
                                                brokeredMessagePropertiesInstance.setViaPartitionKey(viaPartitionKeyInstance);
                                            }
                                        }
                                        
                                        JsonNode customMessagePropertiesSequenceElement = ((JsonNode) serviceBusTopicMessageValue.get("customMessageProperties"));
                                        if (customMessagePropertiesSequenceElement != null && customMessagePropertiesSequenceElement instanceof NullNode == false) {
                                            Iterator<Map.Entry<String, JsonNode>> itr2 = customMessagePropertiesSequenceElement.getFields();
                                            while (itr2.hasNext()) {
                                                Map.Entry<String, JsonNode> property2 = itr2.next();
                                                String customMessagePropertiesKey = property2.getKey();
                                                String customMessagePropertiesValue = property2.getValue().getTextValue();
                                                serviceBusTopicMessageInstance.getCustomMessageProperties().put(customMessagePropertiesKey, customMessagePropertiesValue);
                                            }
                                        }
                                    }
                                    
                                    JsonNode serviceBusQueueMessageValue = errorActionValue.get("serviceBusQueueMessage");
                                    if (serviceBusQueueMessageValue != null && serviceBusQueueMessageValue instanceof NullNode == false) {
                                        JobServiceBusQueueMessage serviceBusQueueMessageInstance = new JobServiceBusQueueMessage();
                                        errorActionInstance.setServiceBusQueueMessage(serviceBusQueueMessageInstance);
                                        
                                        JsonNode queueNameValue2 = serviceBusQueueMessageValue.get("queueName");
                                        if (queueNameValue2 != null && queueNameValue2 instanceof NullNode == false) {
                                            String queueNameInstance2;
                                            queueNameInstance2 = queueNameValue2.getTextValue();
                                            serviceBusQueueMessageInstance.setQueueName(queueNameInstance2);
                                        }
                                        
                                        JsonNode namespaceValue2 = serviceBusQueueMessageValue.get("namespace");
                                        if (namespaceValue2 != null && namespaceValue2 instanceof NullNode == false) {
                                            String namespaceInstance2;
                                            namespaceInstance2 = namespaceValue2.getTextValue();
                                            serviceBusQueueMessageInstance.setNamespace(namespaceInstance2);
                                        }
                                        
                                        JsonNode transportTypeValue2 = serviceBusQueueMessageValue.get("transportType");
                                        if (transportTypeValue2 != null && transportTypeValue2 instanceof NullNode == false) {
                                            JobServiceBusTransportType transportTypeInstance2;
                                            transportTypeInstance2 = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue2.getTextValue());
                                            serviceBusQueueMessageInstance.setTransportType(transportTypeInstance2);
                                        }
                                        
                                        JsonNode authenticationValue3 = serviceBusQueueMessageValue.get("authentication");
                                        if (authenticationValue3 != null && authenticationValue3 instanceof NullNode == false) {
                                            JobServiceBusAuthentication authenticationInstance2 = new JobServiceBusAuthentication();
                                            serviceBusQueueMessageInstance.setAuthentication(authenticationInstance2);
                                            
                                            JsonNode sasKeyNameValue2 = authenticationValue3.get("sasKeyName");
                                            if (sasKeyNameValue2 != null && sasKeyNameValue2 instanceof NullNode == false) {
                                                String sasKeyNameInstance2;
                                                sasKeyNameInstance2 = sasKeyNameValue2.getTextValue();
                                                authenticationInstance2.setSasKeyName(sasKeyNameInstance2);
                                            }
                                            
                                            JsonNode sasKeyValue2 = authenticationValue3.get("sasKey");
                                            if (sasKeyValue2 != null && sasKeyValue2 instanceof NullNode == false) {
                                                String sasKeyInstance2;
                                                sasKeyInstance2 = sasKeyValue2.getTextValue();
                                                authenticationInstance2.setSasKey(sasKeyInstance2);
                                            }
                                            
                                            JsonNode typeValue7 = authenticationValue3.get("type");
                                            if (typeValue7 != null && typeValue7 instanceof NullNode == false) {
                                                JobServiceBusAuthenticationType typeInstance7;
                                                typeInstance7 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue7.getTextValue());
                                                authenticationInstance2.setType(typeInstance7);
                                            }
                                        }
                                        
                                        JsonNode messageValue3 = serviceBusQueueMessageValue.get("message");
                                        if (messageValue3 != null && messageValue3 instanceof NullNode == false) {
                                            String messageInstance3;
                                            messageInstance3 = messageValue3.getTextValue();
                                            serviceBusQueueMessageInstance.setMessage(messageInstance3);
                                        }
                                        
                                        JsonNode brokeredMessagePropertiesValue2 = serviceBusQueueMessageValue.get("brokeredMessageProperties");
                                        if (brokeredMessagePropertiesValue2 != null && brokeredMessagePropertiesValue2 instanceof NullNode == false) {
                                            JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance2 = new JobServiceBusBrokeredMessageProperties();
                                            serviceBusQueueMessageInstance.setBrokeredMessageProperties(brokeredMessagePropertiesInstance2);
                                            
                                            JsonNode contentTypeValue2 = brokeredMessagePropertiesValue2.get("contentType");
                                            if (contentTypeValue2 != null && contentTypeValue2 instanceof NullNode == false) {
                                                String contentTypeInstance2;
                                                contentTypeInstance2 = contentTypeValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setContentType(contentTypeInstance2);
                                            }
                                            
                                            JsonNode correlationIdValue2 = brokeredMessagePropertiesValue2.get("correlationId");
                                            if (correlationIdValue2 != null && correlationIdValue2 instanceof NullNode == false) {
                                                String correlationIdInstance2;
                                                correlationIdInstance2 = correlationIdValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setCorrelationId(correlationIdInstance2);
                                            }
                                            
                                            JsonNode forcePersistenceValue2 = brokeredMessagePropertiesValue2.get("forcePersistence");
                                            if (forcePersistenceValue2 != null && forcePersistenceValue2 instanceof NullNode == false) {
                                                boolean forcePersistenceInstance2;
                                                forcePersistenceInstance2 = forcePersistenceValue2.getBooleanValue();
                                                brokeredMessagePropertiesInstance2.setForcePersistence(forcePersistenceInstance2);
                                            }
                                            
                                            JsonNode labelValue2 = brokeredMessagePropertiesValue2.get("label");
                                            if (labelValue2 != null && labelValue2 instanceof NullNode == false) {
                                                String labelInstance2;
                                                labelInstance2 = labelValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setLabel(labelInstance2);
                                            }
                                            
                                            JsonNode messageIdValue2 = brokeredMessagePropertiesValue2.get("messageId");
                                            if (messageIdValue2 != null && messageIdValue2 instanceof NullNode == false) {
                                                String messageIdInstance2;
                                                messageIdInstance2 = messageIdValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setMessageId(messageIdInstance2);
                                            }
                                            
                                            JsonNode partitionKeyValue2 = brokeredMessagePropertiesValue2.get("partitionKey");
                                            if (partitionKeyValue2 != null && partitionKeyValue2 instanceof NullNode == false) {
                                                String partitionKeyInstance2;
                                                partitionKeyInstance2 = partitionKeyValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setPartitionKey(partitionKeyInstance2);
                                            }
                                            
                                            JsonNode replyToValue2 = brokeredMessagePropertiesValue2.get("replyTo");
                                            if (replyToValue2 != null && replyToValue2 instanceof NullNode == false) {
                                                String replyToInstance2;
                                                replyToInstance2 = replyToValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setReplyTo(replyToInstance2);
                                            }
                                            
                                            JsonNode replyToSessionIdValue2 = brokeredMessagePropertiesValue2.get("replyToSessionId");
                                            if (replyToSessionIdValue2 != null && replyToSessionIdValue2 instanceof NullNode == false) {
                                                String replyToSessionIdInstance2;
                                                replyToSessionIdInstance2 = replyToSessionIdValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setReplyToSessionId(replyToSessionIdInstance2);
                                            }
                                            
                                            JsonNode scheduledEnqueueTimeUtcValue2 = brokeredMessagePropertiesValue2.get("scheduledEnqueueTimeUtc");
                                            if (scheduledEnqueueTimeUtcValue2 != null && scheduledEnqueueTimeUtcValue2 instanceof NullNode == false) {
                                                Calendar scheduledEnqueueTimeUtcInstance2;
                                                scheduledEnqueueTimeUtcInstance2 = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue2.getTextValue());
                                                brokeredMessagePropertiesInstance2.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance2);
                                            }
                                            
                                            JsonNode sessionIdValue2 = brokeredMessagePropertiesValue2.get("sessionId");
                                            if (sessionIdValue2 != null && sessionIdValue2 instanceof NullNode == false) {
                                                String sessionIdInstance2;
                                                sessionIdInstance2 = sessionIdValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setSessionId(sessionIdInstance2);
                                            }
                                            
                                            JsonNode timeToLiveValue2 = brokeredMessagePropertiesValue2.get("timeToLive");
                                            if (timeToLiveValue2 != null && timeToLiveValue2 instanceof NullNode == false) {
                                                Calendar timeToLiveInstance2;
                                                timeToLiveInstance2 = DatatypeConverter.parseDateTime(timeToLiveValue2.getTextValue());
                                                brokeredMessagePropertiesInstance2.setTimeToLive(timeToLiveInstance2);
                                            }
                                            
                                            JsonNode toValue2 = brokeredMessagePropertiesValue2.get("to");
                                            if (toValue2 != null && toValue2 instanceof NullNode == false) {
                                                String toInstance2;
                                                toInstance2 = toValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setTo(toInstance2);
                                            }
                                            
                                            JsonNode viaPartitionKeyValue2 = brokeredMessagePropertiesValue2.get("viaPartitionKey");
                                            if (viaPartitionKeyValue2 != null && viaPartitionKeyValue2 instanceof NullNode == false) {
                                                String viaPartitionKeyInstance2;
                                                viaPartitionKeyInstance2 = viaPartitionKeyValue2.getTextValue();
                                                brokeredMessagePropertiesInstance2.setViaPartitionKey(viaPartitionKeyInstance2);
                                            }
                                        }
                                        
                                        JsonNode customMessagePropertiesSequenceElement2 = ((JsonNode) serviceBusQueueMessageValue.get("customMessageProperties"));
                                        if (customMessagePropertiesSequenceElement2 != null && customMessagePropertiesSequenceElement2 instanceof NullNode == false) {
                                            Iterator<Map.Entry<String, JsonNode>> itr3 = customMessagePropertiesSequenceElement2.getFields();
                                            while (itr3.hasNext()) {
                                                Map.Entry<String, JsonNode> property3 = itr3.next();
                                                String customMessagePropertiesKey2 = property3.getKey();
                                                String customMessagePropertiesValue2 = property3.getValue().getTextValue();
                                                serviceBusQueueMessageInstance.getCustomMessageProperties().put(customMessagePropertiesKey2, customMessagePropertiesValue2);
                                            }
                                        }
                                    }
                                }
                                
                                JsonNode requestValue2 = actionValue.get("request");
                                if (requestValue2 != null && requestValue2 instanceof NullNode == false) {
                                    JobHttpRequest requestInstance2 = new JobHttpRequest();
                                    actionInstance.setRequest(requestInstance2);
                                    
                                    JsonNode uriValue2 = requestValue2.get("uri");
                                    if (uriValue2 != null && uriValue2 instanceof NullNode == false) {
                                        URI uriInstance2;
                                        uriInstance2 = new URI(uriValue2.getTextValue());
                                        requestInstance2.setUri(uriInstance2);
                                    }
                                    
                                    JsonNode methodValue2 = requestValue2.get("method");
                                    if (methodValue2 != null && methodValue2 instanceof NullNode == false) {
                                        String methodInstance2;
                                        methodInstance2 = methodValue2.getTextValue();
                                        requestInstance2.setMethod(methodInstance2);
                                    }
                                    
                                    JsonNode headersSequenceElement2 = ((JsonNode) requestValue2.get("headers"));
                                    if (headersSequenceElement2 != null && headersSequenceElement2 instanceof NullNode == false) {
                                        Iterator<Map.Entry<String, JsonNode>> itr4 = headersSequenceElement2.getFields();
                                        while (itr4.hasNext()) {
                                            Map.Entry<String, JsonNode> property4 = itr4.next();
                                            String headersKey2 = property4.getKey();
                                            String headersValue2 = property4.getValue().getTextValue();
                                            requestInstance2.getHeaders().put(headersKey2, headersValue2);
                                        }
                                    }
                                    
                                    JsonNode bodyValue2 = requestValue2.get("body");
                                    if (bodyValue2 != null && bodyValue2 instanceof NullNode == false) {
                                        String bodyInstance2;
                                        bodyInstance2 = bodyValue2.getTextValue();
                                        requestInstance2.setBody(bodyInstance2);
                                    }
                                    
                                    JsonNode authenticationValue4 = requestValue2.get("authentication");
                                    if (authenticationValue4 != null && authenticationValue4 instanceof NullNode == false) {
                                        String typeName2 = authenticationValue4.get("type").getTextValue();
                                        if ("ClientCertificate".equals(typeName2)) {
                                            ClientCertAuthentication clientCertAuthenticationInstance2 = new ClientCertAuthentication();
                                            
                                            JsonNode passwordValue3 = authenticationValue4.get("password");
                                            if (passwordValue3 != null && passwordValue3 instanceof NullNode == false) {
                                                String passwordInstance3;
                                                passwordInstance3 = passwordValue3.getTextValue();
                                                clientCertAuthenticationInstance2.setPassword(passwordInstance3);
                                            }
                                            
                                            JsonNode pfxValue2 = authenticationValue4.get("pfx");
                                            if (pfxValue2 != null && pfxValue2 instanceof NullNode == false) {
                                                String pfxInstance2;
                                                pfxInstance2 = pfxValue2.getTextValue();
                                                clientCertAuthenticationInstance2.setPfx(pfxInstance2);
                                            }
                                            
                                            JsonNode certificateThumbprintValue2 = authenticationValue4.get("certificateThumbprint");
                                            if (certificateThumbprintValue2 != null && certificateThumbprintValue2 instanceof NullNode == false) {
                                                String certificateThumbprintInstance2;
                                                certificateThumbprintInstance2 = certificateThumbprintValue2.getTextValue();
                                                clientCertAuthenticationInstance2.setCertificateThumbprint(certificateThumbprintInstance2);
                                            }
                                            
                                            JsonNode certificateExpirationValue2 = authenticationValue4.get("certificateExpiration");
                                            if (certificateExpirationValue2 != null && certificateExpirationValue2 instanceof NullNode == false) {
                                                Calendar certificateExpirationInstance2;
                                                certificateExpirationInstance2 = DatatypeConverter.parseDateTime(certificateExpirationValue2.getTextValue());
                                                clientCertAuthenticationInstance2.setCertificateExpiration(certificateExpirationInstance2);
                                            }
                                            
                                            JsonNode certificateSubjectNameValue2 = authenticationValue4.get("certificateSubjectName");
                                            if (certificateSubjectNameValue2 != null && certificateSubjectNameValue2 instanceof NullNode == false) {
                                                String certificateSubjectNameInstance2;
                                                certificateSubjectNameInstance2 = certificateSubjectNameValue2.getTextValue();
                                                clientCertAuthenticationInstance2.setCertificateSubjectName(certificateSubjectNameInstance2);
                                            }
                                            
                                            JsonNode typeValue8 = authenticationValue4.get("type");
                                            if (typeValue8 != null && typeValue8 instanceof NullNode == false) {
                                                HttpAuthenticationType typeInstance8;
                                                typeInstance8 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue8.getTextValue());
                                                clientCertAuthenticationInstance2.setType(typeInstance8);
                                            }
                                            requestInstance2.setAuthentication(clientCertAuthenticationInstance2);
                                        }
                                        if ("ActiveDirectoryOAuth".equals(typeName2)) {
                                            AADOAuthAuthentication aADOAuthAuthenticationInstance2 = new AADOAuthAuthentication();
                                            
                                            JsonNode secretValue2 = authenticationValue4.get("secret");
                                            if (secretValue2 != null && secretValue2 instanceof NullNode == false) {
                                                String secretInstance2;
                                                secretInstance2 = secretValue2.getTextValue();
                                                aADOAuthAuthenticationInstance2.setSecret(secretInstance2);
                                            }
                                            
                                            JsonNode tenantValue2 = authenticationValue4.get("tenant");
                                            if (tenantValue2 != null && tenantValue2 instanceof NullNode == false) {
                                                String tenantInstance2;
                                                tenantInstance2 = tenantValue2.getTextValue();
                                                aADOAuthAuthenticationInstance2.setTenant(tenantInstance2);
                                            }
                                            
                                            JsonNode audienceValue2 = authenticationValue4.get("audience");
                                            if (audienceValue2 != null && audienceValue2 instanceof NullNode == false) {
                                                String audienceInstance2;
                                                audienceInstance2 = audienceValue2.getTextValue();
                                                aADOAuthAuthenticationInstance2.setAudience(audienceInstance2);
                                            }
                                            
                                            JsonNode clientIdValue2 = authenticationValue4.get("clientId");
                                            if (clientIdValue2 != null && clientIdValue2 instanceof NullNode == false) {
                                                String clientIdInstance2;
                                                clientIdInstance2 = clientIdValue2.getTextValue();
                                                aADOAuthAuthenticationInstance2.setClientId(clientIdInstance2);
                                            }
                                            
                                            JsonNode typeValue9 = authenticationValue4.get("type");
                                            if (typeValue9 != null && typeValue9 instanceof NullNode == false) {
                                                HttpAuthenticationType typeInstance9;
                                                typeInstance9 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue9.getTextValue());
                                                aADOAuthAuthenticationInstance2.setType(typeInstance9);
                                            }
                                            requestInstance2.setAuthentication(aADOAuthAuthenticationInstance2);
                                        }
                                        if ("Basic".equals(typeName2)) {
                                            BasicAuthentication basicAuthenticationInstance2 = new BasicAuthentication();
                                            
                                            JsonNode usernameValue2 = authenticationValue4.get("username");
                                            if (usernameValue2 != null && usernameValue2 instanceof NullNode == false) {
                                                String usernameInstance2;
                                                usernameInstance2 = usernameValue2.getTextValue();
                                                basicAuthenticationInstance2.setUsername(usernameInstance2);
                                            }
                                            
                                            JsonNode passwordValue4 = authenticationValue4.get("password");
                                            if (passwordValue4 != null && passwordValue4 instanceof NullNode == false) {
                                                String passwordInstance4;
                                                passwordInstance4 = passwordValue4.getTextValue();
                                                basicAuthenticationInstance2.setPassword(passwordInstance4);
                                            }
                                            
                                            JsonNode typeValue10 = authenticationValue4.get("type");
                                            if (typeValue10 != null && typeValue10 instanceof NullNode == false) {
                                                HttpAuthenticationType typeInstance10;
                                                typeInstance10 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue10.getTextValue());
                                                basicAuthenticationInstance2.setType(typeInstance10);
                                            }
                                            requestInstance2.setAuthentication(basicAuthenticationInstance2);
                                        }
                                    }
                                }
                                
                                JsonNode queueMessageValue2 = actionValue.get("queueMessage");
                                if (queueMessageValue2 != null && queueMessageValue2 instanceof NullNode == false) {
                                    JobQueueMessage queueMessageInstance2 = new JobQueueMessage();
                                    actionInstance.setQueueMessage(queueMessageInstance2);
                                    
                                    JsonNode storageAccountValue2 = queueMessageValue2.get("storageAccount");
                                    if (storageAccountValue2 != null && storageAccountValue2 instanceof NullNode == false) {
                                        String storageAccountInstance2;
                                        storageAccountInstance2 = storageAccountValue2.getTextValue();
                                        queueMessageInstance2.setStorageAccountName(storageAccountInstance2);
                                    }
                                    
                                    JsonNode queueNameValue3 = queueMessageValue2.get("queueName");
                                    if (queueNameValue3 != null && queueNameValue3 instanceof NullNode == false) {
                                        String queueNameInstance3;
                                        queueNameInstance3 = queueNameValue3.getTextValue();
                                        queueMessageInstance2.setQueueName(queueNameInstance3);
                                    }
                                    
                                    JsonNode sasTokenValue2 = queueMessageValue2.get("sasToken");
                                    if (sasTokenValue2 != null && sasTokenValue2 instanceof NullNode == false) {
                                        String sasTokenInstance2;
                                        sasTokenInstance2 = sasTokenValue2.getTextValue();
                                        queueMessageInstance2.setSasToken(sasTokenInstance2);
                                    }
                                    
                                    JsonNode messageValue4 = queueMessageValue2.get("message");
                                    if (messageValue4 != null && messageValue4 instanceof NullNode == false) {
                                        String messageInstance4;
                                        messageInstance4 = messageValue4.getTextValue();
                                        queueMessageInstance2.setMessage(messageInstance4);
                                    }
                                }
                                
                                JsonNode serviceBusTopicMessageValue2 = actionValue.get("serviceBusTopicMessage");
                                if (serviceBusTopicMessageValue2 != null && serviceBusTopicMessageValue2 instanceof NullNode == false) {
                                    JobServiceBusTopicMessage serviceBusTopicMessageInstance2 = new JobServiceBusTopicMessage();
                                    actionInstance.setServiceBusTopicMessage(serviceBusTopicMessageInstance2);
                                    
                                    JsonNode topicPathValue2 = serviceBusTopicMessageValue2.get("topicPath");
                                    if (topicPathValue2 != null && topicPathValue2 instanceof NullNode == false) {
                                        String topicPathInstance2;
                                        topicPathInstance2 = topicPathValue2.getTextValue();
                                        serviceBusTopicMessageInstance2.setTopicPath(topicPathInstance2);
                                    }
                                    
                                    JsonNode namespaceValue3 = serviceBusTopicMessageValue2.get("namespace");
                                    if (namespaceValue3 != null && namespaceValue3 instanceof NullNode == false) {
                                        String namespaceInstance3;
                                        namespaceInstance3 = namespaceValue3.getTextValue();
                                        serviceBusTopicMessageInstance2.setNamespace(namespaceInstance3);
                                    }
                                    
                                    JsonNode transportTypeValue3 = serviceBusTopicMessageValue2.get("transportType");
                                    if (transportTypeValue3 != null && transportTypeValue3 instanceof NullNode == false) {
                                        JobServiceBusTransportType transportTypeInstance3;
                                        transportTypeInstance3 = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue3.getTextValue());
                                        serviceBusTopicMessageInstance2.setTransportType(transportTypeInstance3);
                                    }
                                    
                                    JsonNode authenticationValue5 = serviceBusTopicMessageValue2.get("authentication");
                                    if (authenticationValue5 != null && authenticationValue5 instanceof NullNode == false) {
                                        JobServiceBusAuthentication authenticationInstance3 = new JobServiceBusAuthentication();
                                        serviceBusTopicMessageInstance2.setAuthentication(authenticationInstance3);
                                        
                                        JsonNode sasKeyNameValue3 = authenticationValue5.get("sasKeyName");
                                        if (sasKeyNameValue3 != null && sasKeyNameValue3 instanceof NullNode == false) {
                                            String sasKeyNameInstance3;
                                            sasKeyNameInstance3 = sasKeyNameValue3.getTextValue();
                                            authenticationInstance3.setSasKeyName(sasKeyNameInstance3);
                                        }
                                        
                                        JsonNode sasKeyValue3 = authenticationValue5.get("sasKey");
                                        if (sasKeyValue3 != null && sasKeyValue3 instanceof NullNode == false) {
                                            String sasKeyInstance3;
                                            sasKeyInstance3 = sasKeyValue3.getTextValue();
                                            authenticationInstance3.setSasKey(sasKeyInstance3);
                                        }
                                        
                                        JsonNode typeValue11 = authenticationValue5.get("type");
                                        if (typeValue11 != null && typeValue11 instanceof NullNode == false) {
                                            JobServiceBusAuthenticationType typeInstance11;
                                            typeInstance11 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue11.getTextValue());
                                            authenticationInstance3.setType(typeInstance11);
                                        }
                                    }
                                    
                                    JsonNode messageValue5 = serviceBusTopicMessageValue2.get("message");
                                    if (messageValue5 != null && messageValue5 instanceof NullNode == false) {
                                        String messageInstance5;
                                        messageInstance5 = messageValue5.getTextValue();
                                        serviceBusTopicMessageInstance2.setMessage(messageInstance5);
                                    }
                                    
                                    JsonNode brokeredMessagePropertiesValue3 = serviceBusTopicMessageValue2.get("brokeredMessageProperties");
                                    if (brokeredMessagePropertiesValue3 != null && brokeredMessagePropertiesValue3 instanceof NullNode == false) {
                                        JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance3 = new JobServiceBusBrokeredMessageProperties();
                                        serviceBusTopicMessageInstance2.setBrokeredMessageProperties(brokeredMessagePropertiesInstance3);
                                        
                                        JsonNode contentTypeValue3 = brokeredMessagePropertiesValue3.get("contentType");
                                        if (contentTypeValue3 != null && contentTypeValue3 instanceof NullNode == false) {
                                            String contentTypeInstance3;
                                            contentTypeInstance3 = contentTypeValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setContentType(contentTypeInstance3);
                                        }
                                        
                                        JsonNode correlationIdValue3 = brokeredMessagePropertiesValue3.get("correlationId");
                                        if (correlationIdValue3 != null && correlationIdValue3 instanceof NullNode == false) {
                                            String correlationIdInstance3;
                                            correlationIdInstance3 = correlationIdValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setCorrelationId(correlationIdInstance3);
                                        }
                                        
                                        JsonNode forcePersistenceValue3 = brokeredMessagePropertiesValue3.get("forcePersistence");
                                        if (forcePersistenceValue3 != null && forcePersistenceValue3 instanceof NullNode == false) {
                                            boolean forcePersistenceInstance3;
                                            forcePersistenceInstance3 = forcePersistenceValue3.getBooleanValue();
                                            brokeredMessagePropertiesInstance3.setForcePersistence(forcePersistenceInstance3);
                                        }
                                        
                                        JsonNode labelValue3 = brokeredMessagePropertiesValue3.get("label");
                                        if (labelValue3 != null && labelValue3 instanceof NullNode == false) {
                                            String labelInstance3;
                                            labelInstance3 = labelValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setLabel(labelInstance3);
                                        }
                                        
                                        JsonNode messageIdValue3 = brokeredMessagePropertiesValue3.get("messageId");
                                        if (messageIdValue3 != null && messageIdValue3 instanceof NullNode == false) {
                                            String messageIdInstance3;
                                            messageIdInstance3 = messageIdValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setMessageId(messageIdInstance3);
                                        }
                                        
                                        JsonNode partitionKeyValue3 = brokeredMessagePropertiesValue3.get("partitionKey");
                                        if (partitionKeyValue3 != null && partitionKeyValue3 instanceof NullNode == false) {
                                            String partitionKeyInstance3;
                                            partitionKeyInstance3 = partitionKeyValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setPartitionKey(partitionKeyInstance3);
                                        }
                                        
                                        JsonNode replyToValue3 = brokeredMessagePropertiesValue3.get("replyTo");
                                        if (replyToValue3 != null && replyToValue3 instanceof NullNode == false) {
                                            String replyToInstance3;
                                            replyToInstance3 = replyToValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setReplyTo(replyToInstance3);
                                        }
                                        
                                        JsonNode replyToSessionIdValue3 = brokeredMessagePropertiesValue3.get("replyToSessionId");
                                        if (replyToSessionIdValue3 != null && replyToSessionIdValue3 instanceof NullNode == false) {
                                            String replyToSessionIdInstance3;
                                            replyToSessionIdInstance3 = replyToSessionIdValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setReplyToSessionId(replyToSessionIdInstance3);
                                        }
                                        
                                        JsonNode scheduledEnqueueTimeUtcValue3 = brokeredMessagePropertiesValue3.get("scheduledEnqueueTimeUtc");
                                        if (scheduledEnqueueTimeUtcValue3 != null && scheduledEnqueueTimeUtcValue3 instanceof NullNode == false) {
                                            Calendar scheduledEnqueueTimeUtcInstance3;
                                            scheduledEnqueueTimeUtcInstance3 = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue3.getTextValue());
                                            brokeredMessagePropertiesInstance3.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance3);
                                        }
                                        
                                        JsonNode sessionIdValue3 = brokeredMessagePropertiesValue3.get("sessionId");
                                        if (sessionIdValue3 != null && sessionIdValue3 instanceof NullNode == false) {
                                            String sessionIdInstance3;
                                            sessionIdInstance3 = sessionIdValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setSessionId(sessionIdInstance3);
                                        }
                                        
                                        JsonNode timeToLiveValue3 = brokeredMessagePropertiesValue3.get("timeToLive");
                                        if (timeToLiveValue3 != null && timeToLiveValue3 instanceof NullNode == false) {
                                            Calendar timeToLiveInstance3;
                                            timeToLiveInstance3 = DatatypeConverter.parseDateTime(timeToLiveValue3.getTextValue());
                                            brokeredMessagePropertiesInstance3.setTimeToLive(timeToLiveInstance3);
                                        }
                                        
                                        JsonNode toValue3 = brokeredMessagePropertiesValue3.get("to");
                                        if (toValue3 != null && toValue3 instanceof NullNode == false) {
                                            String toInstance3;
                                            toInstance3 = toValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setTo(toInstance3);
                                        }
                                        
                                        JsonNode viaPartitionKeyValue3 = brokeredMessagePropertiesValue3.get("viaPartitionKey");
                                        if (viaPartitionKeyValue3 != null && viaPartitionKeyValue3 instanceof NullNode == false) {
                                            String viaPartitionKeyInstance3;
                                            viaPartitionKeyInstance3 = viaPartitionKeyValue3.getTextValue();
                                            brokeredMessagePropertiesInstance3.setViaPartitionKey(viaPartitionKeyInstance3);
                                        }
                                    }
                                    
                                    JsonNode customMessagePropertiesSequenceElement3 = ((JsonNode) serviceBusTopicMessageValue2.get("customMessageProperties"));
                                    if (customMessagePropertiesSequenceElement3 != null && customMessagePropertiesSequenceElement3 instanceof NullNode == false) {
                                        Iterator<Map.Entry<String, JsonNode>> itr5 = customMessagePropertiesSequenceElement3.getFields();
                                        while (itr5.hasNext()) {
                                            Map.Entry<String, JsonNode> property5 = itr5.next();
                                            String customMessagePropertiesKey3 = property5.getKey();
                                            String customMessagePropertiesValue3 = property5.getValue().getTextValue();
                                            serviceBusTopicMessageInstance2.getCustomMessageProperties().put(customMessagePropertiesKey3, customMessagePropertiesValue3);
                                        }
                                    }
                                }
                                
                                JsonNode serviceBusQueueMessageValue2 = actionValue.get("serviceBusQueueMessage");
                                if (serviceBusQueueMessageValue2 != null && serviceBusQueueMessageValue2 instanceof NullNode == false) {
                                    JobServiceBusQueueMessage serviceBusQueueMessageInstance2 = new JobServiceBusQueueMessage();
                                    actionInstance.setServiceBusQueueMessage(serviceBusQueueMessageInstance2);
                                    
                                    JsonNode queueNameValue4 = serviceBusQueueMessageValue2.get("queueName");
                                    if (queueNameValue4 != null && queueNameValue4 instanceof NullNode == false) {
                                        String queueNameInstance4;
                                        queueNameInstance4 = queueNameValue4.getTextValue();
                                        serviceBusQueueMessageInstance2.setQueueName(queueNameInstance4);
                                    }
                                    
                                    JsonNode namespaceValue4 = serviceBusQueueMessageValue2.get("namespace");
                                    if (namespaceValue4 != null && namespaceValue4 instanceof NullNode == false) {
                                        String namespaceInstance4;
                                        namespaceInstance4 = namespaceValue4.getTextValue();
                                        serviceBusQueueMessageInstance2.setNamespace(namespaceInstance4);
                                    }
                                    
                                    JsonNode transportTypeValue4 = serviceBusQueueMessageValue2.get("transportType");
                                    if (transportTypeValue4 != null && transportTypeValue4 instanceof NullNode == false) {
                                        JobServiceBusTransportType transportTypeInstance4;
                                        transportTypeInstance4 = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue4.getTextValue());
                                        serviceBusQueueMessageInstance2.setTransportType(transportTypeInstance4);
                                    }
                                    
                                    JsonNode authenticationValue6 = serviceBusQueueMessageValue2.get("authentication");
                                    if (authenticationValue6 != null && authenticationValue6 instanceof NullNode == false) {
                                        JobServiceBusAuthentication authenticationInstance4 = new JobServiceBusAuthentication();
                                        serviceBusQueueMessageInstance2.setAuthentication(authenticationInstance4);
                                        
                                        JsonNode sasKeyNameValue4 = authenticationValue6.get("sasKeyName");
                                        if (sasKeyNameValue4 != null && sasKeyNameValue4 instanceof NullNode == false) {
                                            String sasKeyNameInstance4;
                                            sasKeyNameInstance4 = sasKeyNameValue4.getTextValue();
                                            authenticationInstance4.setSasKeyName(sasKeyNameInstance4);
                                        }
                                        
                                        JsonNode sasKeyValue4 = authenticationValue6.get("sasKey");
                                        if (sasKeyValue4 != null && sasKeyValue4 instanceof NullNode == false) {
                                            String sasKeyInstance4;
                                            sasKeyInstance4 = sasKeyValue4.getTextValue();
                                            authenticationInstance4.setSasKey(sasKeyInstance4);
                                        }
                                        
                                        JsonNode typeValue12 = authenticationValue6.get("type");
                                        if (typeValue12 != null && typeValue12 instanceof NullNode == false) {
                                            JobServiceBusAuthenticationType typeInstance12;
                                            typeInstance12 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue12.getTextValue());
                                            authenticationInstance4.setType(typeInstance12);
                                        }
                                    }
                                    
                                    JsonNode messageValue6 = serviceBusQueueMessageValue2.get("message");
                                    if (messageValue6 != null && messageValue6 instanceof NullNode == false) {
                                        String messageInstance6;
                                        messageInstance6 = messageValue6.getTextValue();
                                        serviceBusQueueMessageInstance2.setMessage(messageInstance6);
                                    }
                                    
                                    JsonNode brokeredMessagePropertiesValue4 = serviceBusQueueMessageValue2.get("brokeredMessageProperties");
                                    if (brokeredMessagePropertiesValue4 != null && brokeredMessagePropertiesValue4 instanceof NullNode == false) {
                                        JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance4 = new JobServiceBusBrokeredMessageProperties();
                                        serviceBusQueueMessageInstance2.setBrokeredMessageProperties(brokeredMessagePropertiesInstance4);
                                        
                                        JsonNode contentTypeValue4 = brokeredMessagePropertiesValue4.get("contentType");
                                        if (contentTypeValue4 != null && contentTypeValue4 instanceof NullNode == false) {
                                            String contentTypeInstance4;
                                            contentTypeInstance4 = contentTypeValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setContentType(contentTypeInstance4);
                                        }
                                        
                                        JsonNode correlationIdValue4 = brokeredMessagePropertiesValue4.get("correlationId");
                                        if (correlationIdValue4 != null && correlationIdValue4 instanceof NullNode == false) {
                                            String correlationIdInstance4;
                                            correlationIdInstance4 = correlationIdValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setCorrelationId(correlationIdInstance4);
                                        }
                                        
                                        JsonNode forcePersistenceValue4 = brokeredMessagePropertiesValue4.get("forcePersistence");
                                        if (forcePersistenceValue4 != null && forcePersistenceValue4 instanceof NullNode == false) {
                                            boolean forcePersistenceInstance4;
                                            forcePersistenceInstance4 = forcePersistenceValue4.getBooleanValue();
                                            brokeredMessagePropertiesInstance4.setForcePersistence(forcePersistenceInstance4);
                                        }
                                        
                                        JsonNode labelValue4 = brokeredMessagePropertiesValue4.get("label");
                                        if (labelValue4 != null && labelValue4 instanceof NullNode == false) {
                                            String labelInstance4;
                                            labelInstance4 = labelValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setLabel(labelInstance4);
                                        }
                                        
                                        JsonNode messageIdValue4 = brokeredMessagePropertiesValue4.get("messageId");
                                        if (messageIdValue4 != null && messageIdValue4 instanceof NullNode == false) {
                                            String messageIdInstance4;
                                            messageIdInstance4 = messageIdValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setMessageId(messageIdInstance4);
                                        }
                                        
                                        JsonNode partitionKeyValue4 = brokeredMessagePropertiesValue4.get("partitionKey");
                                        if (partitionKeyValue4 != null && partitionKeyValue4 instanceof NullNode == false) {
                                            String partitionKeyInstance4;
                                            partitionKeyInstance4 = partitionKeyValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setPartitionKey(partitionKeyInstance4);
                                        }
                                        
                                        JsonNode replyToValue4 = brokeredMessagePropertiesValue4.get("replyTo");
                                        if (replyToValue4 != null && replyToValue4 instanceof NullNode == false) {
                                            String replyToInstance4;
                                            replyToInstance4 = replyToValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setReplyTo(replyToInstance4);
                                        }
                                        
                                        JsonNode replyToSessionIdValue4 = brokeredMessagePropertiesValue4.get("replyToSessionId");
                                        if (replyToSessionIdValue4 != null && replyToSessionIdValue4 instanceof NullNode == false) {
                                            String replyToSessionIdInstance4;
                                            replyToSessionIdInstance4 = replyToSessionIdValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setReplyToSessionId(replyToSessionIdInstance4);
                                        }
                                        
                                        JsonNode scheduledEnqueueTimeUtcValue4 = brokeredMessagePropertiesValue4.get("scheduledEnqueueTimeUtc");
                                        if (scheduledEnqueueTimeUtcValue4 != null && scheduledEnqueueTimeUtcValue4 instanceof NullNode == false) {
                                            Calendar scheduledEnqueueTimeUtcInstance4;
                                            scheduledEnqueueTimeUtcInstance4 = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue4.getTextValue());
                                            brokeredMessagePropertiesInstance4.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance4);
                                        }
                                        
                                        JsonNode sessionIdValue4 = brokeredMessagePropertiesValue4.get("sessionId");
                                        if (sessionIdValue4 != null && sessionIdValue4 instanceof NullNode == false) {
                                            String sessionIdInstance4;
                                            sessionIdInstance4 = sessionIdValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setSessionId(sessionIdInstance4);
                                        }
                                        
                                        JsonNode timeToLiveValue4 = brokeredMessagePropertiesValue4.get("timeToLive");
                                        if (timeToLiveValue4 != null && timeToLiveValue4 instanceof NullNode == false) {
                                            Calendar timeToLiveInstance4;
                                            timeToLiveInstance4 = DatatypeConverter.parseDateTime(timeToLiveValue4.getTextValue());
                                            brokeredMessagePropertiesInstance4.setTimeToLive(timeToLiveInstance4);
                                        }
                                        
                                        JsonNode toValue4 = brokeredMessagePropertiesValue4.get("to");
                                        if (toValue4 != null && toValue4 instanceof NullNode == false) {
                                            String toInstance4;
                                            toInstance4 = toValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setTo(toInstance4);
                                        }
                                        
                                        JsonNode viaPartitionKeyValue4 = brokeredMessagePropertiesValue4.get("viaPartitionKey");
                                        if (viaPartitionKeyValue4 != null && viaPartitionKeyValue4 instanceof NullNode == false) {
                                            String viaPartitionKeyInstance4;
                                            viaPartitionKeyInstance4 = viaPartitionKeyValue4.getTextValue();
                                            brokeredMessagePropertiesInstance4.setViaPartitionKey(viaPartitionKeyInstance4);
                                        }
                                    }
                                    
                                    JsonNode customMessagePropertiesSequenceElement4 = ((JsonNode) serviceBusQueueMessageValue2.get("customMessageProperties"));
                                    if (customMessagePropertiesSequenceElement4 != null && customMessagePropertiesSequenceElement4 instanceof NullNode == false) {
                                        Iterator<Map.Entry<String, JsonNode>> itr6 = customMessagePropertiesSequenceElement4.getFields();
                                        while (itr6.hasNext()) {
                                            Map.Entry<String, JsonNode> property6 = itr6.next();
                                            String customMessagePropertiesKey4 = property6.getKey();
                                            String customMessagePropertiesValue4 = property6.getValue().getTextValue();
                                            serviceBusQueueMessageInstance2.getCustomMessageProperties().put(customMessagePropertiesKey4, customMessagePropertiesValue4);
                                        }
                                    }
                                }
                            }
                            
                            JsonNode recurrenceValue = jobsValue.get("recurrence");
                            if (recurrenceValue != null && recurrenceValue instanceof NullNode == false) {
                                JobRecurrence recurrenceInstance = new JobRecurrence();
                                jobInstance.setRecurrence(recurrenceInstance);
                                
                                JsonNode frequencyValue = recurrenceValue.get("frequency");
                                if (frequencyValue != null && frequencyValue instanceof NullNode == false) {
                                    JobRecurrenceFrequency frequencyInstance;
                                    frequencyInstance = SchedulerClientImpl.parseJobRecurrenceFrequency(frequencyValue.getTextValue());
                                    recurrenceInstance.setFrequency(frequencyInstance);
                                }
                                
                                JsonNode intervalValue = recurrenceValue.get("interval");
                                if (intervalValue != null && intervalValue instanceof NullNode == false) {
                                    int intervalInstance;
                                    intervalInstance = intervalValue.getIntValue();
                                    recurrenceInstance.setInterval(intervalInstance);
                                }
                                
                                JsonNode countValue = recurrenceValue.get("count");
                                if (countValue != null && countValue instanceof NullNode == false) {
                                    int countInstance;
                                    countInstance = countValue.getIntValue();
                                    recurrenceInstance.setCount(countInstance);
                                }
                                
                                JsonNode endTimeValue = recurrenceValue.get("endTime");
                                if (endTimeValue != null && endTimeValue instanceof NullNode == false) {
                                    Calendar endTimeInstance;
                                    endTimeInstance = DatatypeConverter.parseDateTime(endTimeValue.getTextValue());
                                    recurrenceInstance.setEndTime(endTimeInstance);
                                }
                                
                                JsonNode scheduleValue = recurrenceValue.get("schedule");
                                if (scheduleValue != null && scheduleValue instanceof NullNode == false) {
                                    JobRecurrenceSchedule scheduleInstance = new JobRecurrenceSchedule();
                                    recurrenceInstance.setSchedule(scheduleInstance);
                                    
                                    JsonNode minutesArray = scheduleValue.get("minutes");
                                    if (minutesArray != null && minutesArray instanceof NullNode == false) {
                                        scheduleInstance.setMinutes(new ArrayList<Integer>());
                                        for (JsonNode minutesValue : ((ArrayNode) minutesArray)) {
                                            scheduleInstance.getMinutes().add(minutesValue.getIntValue());
                                        }
                                    }
                                    
                                    JsonNode hoursArray = scheduleValue.get("hours");
                                    if (hoursArray != null && hoursArray instanceof NullNode == false) {
                                        scheduleInstance.setHours(new ArrayList<Integer>());
                                        for (JsonNode hoursValue : ((ArrayNode) hoursArray)) {
                                            scheduleInstance.getHours().add(hoursValue.getIntValue());
                                        }
                                    }
                                    
                                    JsonNode weekDaysArray = scheduleValue.get("weekDays");
                                    if (weekDaysArray != null && weekDaysArray instanceof NullNode == false) {
                                        scheduleInstance.setDays(new ArrayList<JobScheduleDay>());
                                        for (JsonNode weekDaysValue : ((ArrayNode) weekDaysArray)) {
                                            scheduleInstance.getDays().add(SchedulerClientImpl.parseJobScheduleDay(weekDaysValue.getTextValue()));
                                        }
                                    }
                                    
                                    JsonNode monthsArray = scheduleValue.get("months");
                                    if (monthsArray != null && monthsArray instanceof NullNode == false) {
                                        scheduleInstance.setMonths(new ArrayList<Integer>());
                                        for (JsonNode monthsValue : ((ArrayNode) monthsArray)) {
                                            scheduleInstance.getMonths().add(monthsValue.getIntValue());
                                        }
                                    }
                                    
                                    JsonNode monthDaysArray = scheduleValue.get("monthDays");
                                    if (monthDaysArray != null && monthDaysArray instanceof NullNode == false) {
                                        scheduleInstance.setMonthDays(new ArrayList<Integer>());
                                        for (JsonNode monthDaysValue : ((ArrayNode) monthDaysArray)) {
                                            scheduleInstance.getMonthDays().add(monthDaysValue.getIntValue());
                                        }
                                    }
                                    
                                    JsonNode monthlyOccurrencesArray = scheduleValue.get("monthlyOccurrences");
                                    if (monthlyOccurrencesArray != null && monthlyOccurrencesArray instanceof NullNode == false) {
                                        scheduleInstance.setMonthlyOccurrences(new ArrayList<JobScheduleMonthlyOccurrence>());
                                        for (JsonNode monthlyOccurrencesValue : ((ArrayNode) monthlyOccurrencesArray)) {
                                            JobScheduleMonthlyOccurrence jobScheduleMonthlyOccurrenceInstance = new JobScheduleMonthlyOccurrence();
                                            scheduleInstance.getMonthlyOccurrences().add(jobScheduleMonthlyOccurrenceInstance);
                                            
                                            JsonNode dayValue = monthlyOccurrencesValue.get("day");
                                            if (dayValue != null && dayValue instanceof NullNode == false) {
                                                JobScheduleDay dayInstance;
                                                dayInstance = SchedulerClientImpl.parseJobScheduleDay(dayValue.getTextValue());
                                                jobScheduleMonthlyOccurrenceInstance.setDay(dayInstance);
                                            }
                                            
                                            JsonNode occurrenceValue = monthlyOccurrencesValue.get("occurrence");
                                            if (occurrenceValue != null && occurrenceValue instanceof NullNode == false) {
                                                int occurrenceInstance;
                                                occurrenceInstance = occurrenceValue.getIntValue();
                                                jobScheduleMonthlyOccurrenceInstance.setOccurrence(occurrenceInstance);
                                            }
                                        }
                                    }
                                }
                            }
                            
                            JsonNode statusValue = jobsValue.get("status");
                            if (statusValue != null && statusValue instanceof NullNode == false) {
                                JobStatus statusInstance = new JobStatus();
                                jobInstance.setStatus(statusInstance);
                                
                                JsonNode lastExecutionTimeValue = statusValue.get("lastExecutionTime");
                                if (lastExecutionTimeValue != null && lastExecutionTimeValue instanceof NullNode == false) {
                                    Calendar lastExecutionTimeInstance;
                                    lastExecutionTimeInstance = DatatypeConverter.parseDateTime(lastExecutionTimeValue.getTextValue());
                                    statusInstance.setLastExecutionTime(lastExecutionTimeInstance);
                                }
                                
                                JsonNode nextExecutionTimeValue = statusValue.get("nextExecutionTime");
                                if (nextExecutionTimeValue != null && nextExecutionTimeValue instanceof NullNode == false) {
                                    Calendar nextExecutionTimeInstance;
                                    nextExecutionTimeInstance = DatatypeConverter.parseDateTime(nextExecutionTimeValue.getTextValue());
                                    statusInstance.setNextExecutionTime(nextExecutionTimeInstance);
                                }
                                
                                JsonNode executionCountValue = statusValue.get("executionCount");
                                if (executionCountValue != null && executionCountValue instanceof NullNode == false) {
                                    int executionCountInstance;
                                    executionCountInstance = executionCountValue.getIntValue();
                                    statusInstance.setExecutionCount(executionCountInstance);
                                }
                                
                                JsonNode failureCountValue = statusValue.get("failureCount");
                                if (failureCountValue != null && failureCountValue instanceof NullNode == false) {
                                    int failureCountInstance;
                                    failureCountInstance = failureCountValue.getIntValue();
                                    statusInstance.setFailureCount(failureCountInstance);
                                }
                                
                                JsonNode faultedCountValue = statusValue.get("faultedCount");
                                if (faultedCountValue != null && faultedCountValue instanceof NullNode == false) {
                                    int faultedCountInstance;
                                    faultedCountInstance = faultedCountValue.getIntValue();
                                    statusInstance.setFaultedCount(faultedCountInstance);
                                }
                            }
                            
                            JsonNode stateValue = jobsValue.get("state");
                            if (stateValue != null && stateValue instanceof NullNode == false) {
                                JobState stateInstance;
                                stateInstance = SchedulerClientImpl.parseJobState(stateValue.getTextValue());
                                jobInstance.setState(stateInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Update the state of a job.
    *
    * @param jobId Required. Id of the job to update.
    * @param parameters Required. Parameters supplied to the Update Job State
    * operation.
    * @return The Update Job State operation response.
    */
    @Override
    public Future<JobUpdateStateResponse> updateStateAsync(final String jobId, final JobUpdateStateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<JobUpdateStateResponse>() { 
            @Override
            public JobUpdateStateResponse call() throws Exception {
                return updateState(jobId, parameters);
            }
         });
    }
    
    /**
    * Update the state of a job.
    *
    * @param jobId Required. Id of the job to update.
    * @param parameters Required. Parameters supplied to the Update Job State
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Update Job State operation response.
    */
    @Override
    public JobUpdateStateResponse updateState(String jobId, JobUpdateStateParameters parameters) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (jobId == null) {
            throw new NullPointerException("jobId");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getState() == null) {
            throw new NullPointerException("parameters.State");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("jobId", jobId);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "updateStateAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/cloudservices/";
        url = url + URLEncoder.encode(this.getClient().getCloudServiceName(), "UTF-8");
        url = url + "/resources/";
        url = url + "scheduler";
        url = url + "/~/";
        url = url + "JobCollections";
        url = url + "/";
        url = url + URLEncoder.encode(this.getClient().getJobCollectionName(), "UTF-8");
        url = url + "/jobs/";
        url = url + URLEncoder.encode(jobId, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2014-04-01");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPatch httpRequest = new HttpPatch(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        httpRequest.setHeader("x-ms-version", "2013-03-01");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode jobUpdateStateParametersValue = objectMapper.createObjectNode();
        requestDoc = jobUpdateStateParametersValue;
        
        ((ObjectNode) jobUpdateStateParametersValue).put("state", SchedulerClientImpl.jobStateToString(parameters.getState()));
        
        if (parameters.getUpdateStateReason() != null) {
            ((ObjectNode) jobUpdateStateParametersValue).put("stateDetails", parameters.getUpdateStateReason());
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            JobUpdateStateResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new JobUpdateStateResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    Job jobInstance = new Job();
                    result.setJob(jobInstance);
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        jobInstance.setId(idInstance);
                    }
                    
                    JsonNode startTimeValue = responseDoc.get("startTime");
                    if (startTimeValue != null && startTimeValue instanceof NullNode == false) {
                        Calendar startTimeInstance;
                        startTimeInstance = DatatypeConverter.parseDateTime(startTimeValue.getTextValue());
                        jobInstance.setStartTime(startTimeInstance);
                    }
                    
                    JsonNode actionValue = responseDoc.get("action");
                    if (actionValue != null && actionValue instanceof NullNode == false) {
                        JobAction actionInstance = new JobAction();
                        jobInstance.setAction(actionInstance);
                        
                        JsonNode typeValue = actionValue.get("type");
                        if (typeValue != null && typeValue instanceof NullNode == false) {
                            JobActionType typeInstance;
                            typeInstance = SchedulerClientImpl.parseJobActionType(typeValue.getTextValue());
                            actionInstance.setType(typeInstance);
                        }
                        
                        JsonNode retryPolicyValue = actionValue.get("retryPolicy");
                        if (retryPolicyValue != null && retryPolicyValue instanceof NullNode == false) {
                            RetryPolicy retryPolicyInstance = new RetryPolicy();
                            actionInstance.setRetryPolicy(retryPolicyInstance);
                            
                            JsonNode retryTypeValue = retryPolicyValue.get("retryType");
                            if (retryTypeValue != null && retryTypeValue instanceof NullNode == false) {
                                RetryType retryTypeInstance;
                                retryTypeInstance = SchedulerClientImpl.parseRetryType(retryTypeValue.getTextValue());
                                retryPolicyInstance.setRetryType(retryTypeInstance);
                            }
                            
                            JsonNode retryIntervalValue = retryPolicyValue.get("retryInterval");
                            if (retryIntervalValue != null && retryIntervalValue instanceof NullNode == false) {
                                Duration retryIntervalInstance;
                                retryIntervalInstance = TimeSpan8601Converter.parse(retryIntervalValue.getTextValue());
                                retryPolicyInstance.setRetryInterval(retryIntervalInstance);
                            }
                            
                            JsonNode retryCountValue = retryPolicyValue.get("retryCount");
                            if (retryCountValue != null && retryCountValue instanceof NullNode == false) {
                                int retryCountInstance;
                                retryCountInstance = retryCountValue.getIntValue();
                                retryPolicyInstance.setRetryCount(retryCountInstance);
                            }
                        }
                        
                        JsonNode errorActionValue = actionValue.get("errorAction");
                        if (errorActionValue != null && errorActionValue instanceof NullNode == false) {
                            JobErrorAction errorActionInstance = new JobErrorAction();
                            actionInstance.setErrorAction(errorActionInstance);
                            
                            JsonNode typeValue2 = errorActionValue.get("type");
                            if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                JobActionType typeInstance2;
                                typeInstance2 = SchedulerClientImpl.parseJobActionType(typeValue2.getTextValue());
                                errorActionInstance.setType(typeInstance2);
                            }
                            
                            JsonNode requestValue = errorActionValue.get("request");
                            if (requestValue != null && requestValue instanceof NullNode == false) {
                                JobHttpRequest requestInstance = new JobHttpRequest();
                                errorActionInstance.setRequest(requestInstance);
                                
                                JsonNode uriValue = requestValue.get("uri");
                                if (uriValue != null && uriValue instanceof NullNode == false) {
                                    URI uriInstance;
                                    uriInstance = new URI(uriValue.getTextValue());
                                    requestInstance.setUri(uriInstance);
                                }
                                
                                JsonNode methodValue = requestValue.get("method");
                                if (methodValue != null && methodValue instanceof NullNode == false) {
                                    String methodInstance;
                                    methodInstance = methodValue.getTextValue();
                                    requestInstance.setMethod(methodInstance);
                                }
                                
                                JsonNode headersSequenceElement = ((JsonNode) requestValue.get("headers"));
                                if (headersSequenceElement != null && headersSequenceElement instanceof NullNode == false) {
                                    Iterator<Map.Entry<String, JsonNode>> itr = headersSequenceElement.getFields();
                                    while (itr.hasNext()) {
                                        Map.Entry<String, JsonNode> property = itr.next();
                                        String headersKey = property.getKey();
                                        String headersValue = property.getValue().getTextValue();
                                        requestInstance.getHeaders().put(headersKey, headersValue);
                                    }
                                }
                                
                                JsonNode bodyValue = requestValue.get("body");
                                if (bodyValue != null && bodyValue instanceof NullNode == false) {
                                    String bodyInstance;
                                    bodyInstance = bodyValue.getTextValue();
                                    requestInstance.setBody(bodyInstance);
                                }
                                
                                JsonNode authenticationValue = requestValue.get("authentication");
                                if (authenticationValue != null && authenticationValue instanceof NullNode == false) {
                                    String typeName = authenticationValue.get("type").getTextValue();
                                    if ("ClientCertificate".equals(typeName)) {
                                        ClientCertAuthentication clientCertAuthenticationInstance = new ClientCertAuthentication();
                                        
                                        JsonNode passwordValue = authenticationValue.get("password");
                                        if (passwordValue != null && passwordValue instanceof NullNode == false) {
                                            String passwordInstance;
                                            passwordInstance = passwordValue.getTextValue();
                                            clientCertAuthenticationInstance.setPassword(passwordInstance);
                                        }
                                        
                                        JsonNode pfxValue = authenticationValue.get("pfx");
                                        if (pfxValue != null && pfxValue instanceof NullNode == false) {
                                            String pfxInstance;
                                            pfxInstance = pfxValue.getTextValue();
                                            clientCertAuthenticationInstance.setPfx(pfxInstance);
                                        }
                                        
                                        JsonNode certificateThumbprintValue = authenticationValue.get("certificateThumbprint");
                                        if (certificateThumbprintValue != null && certificateThumbprintValue instanceof NullNode == false) {
                                            String certificateThumbprintInstance;
                                            certificateThumbprintInstance = certificateThumbprintValue.getTextValue();
                                            clientCertAuthenticationInstance.setCertificateThumbprint(certificateThumbprintInstance);
                                        }
                                        
                                        JsonNode certificateExpirationValue = authenticationValue.get("certificateExpiration");
                                        if (certificateExpirationValue != null && certificateExpirationValue instanceof NullNode == false) {
                                            Calendar certificateExpirationInstance;
                                            certificateExpirationInstance = DatatypeConverter.parseDateTime(certificateExpirationValue.getTextValue());
                                            clientCertAuthenticationInstance.setCertificateExpiration(certificateExpirationInstance);
                                        }
                                        
                                        JsonNode certificateSubjectNameValue = authenticationValue.get("certificateSubjectName");
                                        if (certificateSubjectNameValue != null && certificateSubjectNameValue instanceof NullNode == false) {
                                            String certificateSubjectNameInstance;
                                            certificateSubjectNameInstance = certificateSubjectNameValue.getTextValue();
                                            clientCertAuthenticationInstance.setCertificateSubjectName(certificateSubjectNameInstance);
                                        }
                                        
                                        JsonNode typeValue3 = authenticationValue.get("type");
                                        if (typeValue3 != null && typeValue3 instanceof NullNode == false) {
                                            HttpAuthenticationType typeInstance3;
                                            typeInstance3 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue3.getTextValue());
                                            clientCertAuthenticationInstance.setType(typeInstance3);
                                        }
                                        requestInstance.setAuthentication(clientCertAuthenticationInstance);
                                    }
                                    if ("ActiveDirectoryOAuth".equals(typeName)) {
                                        AADOAuthAuthentication aADOAuthAuthenticationInstance = new AADOAuthAuthentication();
                                        
                                        JsonNode secretValue = authenticationValue.get("secret");
                                        if (secretValue != null && secretValue instanceof NullNode == false) {
                                            String secretInstance;
                                            secretInstance = secretValue.getTextValue();
                                            aADOAuthAuthenticationInstance.setSecret(secretInstance);
                                        }
                                        
                                        JsonNode tenantValue = authenticationValue.get("tenant");
                                        if (tenantValue != null && tenantValue instanceof NullNode == false) {
                                            String tenantInstance;
                                            tenantInstance = tenantValue.getTextValue();
                                            aADOAuthAuthenticationInstance.setTenant(tenantInstance);
                                        }
                                        
                                        JsonNode audienceValue = authenticationValue.get("audience");
                                        if (audienceValue != null && audienceValue instanceof NullNode == false) {
                                            String audienceInstance;
                                            audienceInstance = audienceValue.getTextValue();
                                            aADOAuthAuthenticationInstance.setAudience(audienceInstance);
                                        }
                                        
                                        JsonNode clientIdValue = authenticationValue.get("clientId");
                                        if (clientIdValue != null && clientIdValue instanceof NullNode == false) {
                                            String clientIdInstance;
                                            clientIdInstance = clientIdValue.getTextValue();
                                            aADOAuthAuthenticationInstance.setClientId(clientIdInstance);
                                        }
                                        
                                        JsonNode typeValue4 = authenticationValue.get("type");
                                        if (typeValue4 != null && typeValue4 instanceof NullNode == false) {
                                            HttpAuthenticationType typeInstance4;
                                            typeInstance4 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue4.getTextValue());
                                            aADOAuthAuthenticationInstance.setType(typeInstance4);
                                        }
                                        requestInstance.setAuthentication(aADOAuthAuthenticationInstance);
                                    }
                                    if ("Basic".equals(typeName)) {
                                        BasicAuthentication basicAuthenticationInstance = new BasicAuthentication();
                                        
                                        JsonNode usernameValue = authenticationValue.get("username");
                                        if (usernameValue != null && usernameValue instanceof NullNode == false) {
                                            String usernameInstance;
                                            usernameInstance = usernameValue.getTextValue();
                                            basicAuthenticationInstance.setUsername(usernameInstance);
                                        }
                                        
                                        JsonNode passwordValue2 = authenticationValue.get("password");
                                        if (passwordValue2 != null && passwordValue2 instanceof NullNode == false) {
                                            String passwordInstance2;
                                            passwordInstance2 = passwordValue2.getTextValue();
                                            basicAuthenticationInstance.setPassword(passwordInstance2);
                                        }
                                        
                                        JsonNode typeValue5 = authenticationValue.get("type");
                                        if (typeValue5 != null && typeValue5 instanceof NullNode == false) {
                                            HttpAuthenticationType typeInstance5;
                                            typeInstance5 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue5.getTextValue());
                                            basicAuthenticationInstance.setType(typeInstance5);
                                        }
                                        requestInstance.setAuthentication(basicAuthenticationInstance);
                                    }
                                }
                            }
                            
                            JsonNode queueMessageValue = errorActionValue.get("queueMessage");
                            if (queueMessageValue != null && queueMessageValue instanceof NullNode == false) {
                                JobQueueMessage queueMessageInstance = new JobQueueMessage();
                                errorActionInstance.setQueueMessage(queueMessageInstance);
                                
                                JsonNode storageAccountValue = queueMessageValue.get("storageAccount");
                                if (storageAccountValue != null && storageAccountValue instanceof NullNode == false) {
                                    String storageAccountInstance;
                                    storageAccountInstance = storageAccountValue.getTextValue();
                                    queueMessageInstance.setStorageAccountName(storageAccountInstance);
                                }
                                
                                JsonNode queueNameValue = queueMessageValue.get("queueName");
                                if (queueNameValue != null && queueNameValue instanceof NullNode == false) {
                                    String queueNameInstance;
                                    queueNameInstance = queueNameValue.getTextValue();
                                    queueMessageInstance.setQueueName(queueNameInstance);
                                }
                                
                                JsonNode sasTokenValue = queueMessageValue.get("sasToken");
                                if (sasTokenValue != null && sasTokenValue instanceof NullNode == false) {
                                    String sasTokenInstance;
                                    sasTokenInstance = sasTokenValue.getTextValue();
                                    queueMessageInstance.setSasToken(sasTokenInstance);
                                }
                                
                                JsonNode messageValue = queueMessageValue.get("message");
                                if (messageValue != null && messageValue instanceof NullNode == false) {
                                    String messageInstance;
                                    messageInstance = messageValue.getTextValue();
                                    queueMessageInstance.setMessage(messageInstance);
                                }
                            }
                            
                            JsonNode serviceBusTopicMessageValue = errorActionValue.get("serviceBusTopicMessage");
                            if (serviceBusTopicMessageValue != null && serviceBusTopicMessageValue instanceof NullNode == false) {
                                JobServiceBusTopicMessage serviceBusTopicMessageInstance = new JobServiceBusTopicMessage();
                                errorActionInstance.setServiceBusTopicMessage(serviceBusTopicMessageInstance);
                                
                                JsonNode topicPathValue = serviceBusTopicMessageValue.get("topicPath");
                                if (topicPathValue != null && topicPathValue instanceof NullNode == false) {
                                    String topicPathInstance;
                                    topicPathInstance = topicPathValue.getTextValue();
                                    serviceBusTopicMessageInstance.setTopicPath(topicPathInstance);
                                }
                                
                                JsonNode namespaceValue = serviceBusTopicMessageValue.get("namespace");
                                if (namespaceValue != null && namespaceValue instanceof NullNode == false) {
                                    String namespaceInstance;
                                    namespaceInstance = namespaceValue.getTextValue();
                                    serviceBusTopicMessageInstance.setNamespace(namespaceInstance);
                                }
                                
                                JsonNode transportTypeValue = serviceBusTopicMessageValue.get("transportType");
                                if (transportTypeValue != null && transportTypeValue instanceof NullNode == false) {
                                    JobServiceBusTransportType transportTypeInstance;
                                    transportTypeInstance = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue.getTextValue());
                                    serviceBusTopicMessageInstance.setTransportType(transportTypeInstance);
                                }
                                
                                JsonNode authenticationValue2 = serviceBusTopicMessageValue.get("authentication");
                                if (authenticationValue2 != null && authenticationValue2 instanceof NullNode == false) {
                                    JobServiceBusAuthentication authenticationInstance = new JobServiceBusAuthentication();
                                    serviceBusTopicMessageInstance.setAuthentication(authenticationInstance);
                                    
                                    JsonNode sasKeyNameValue = authenticationValue2.get("sasKeyName");
                                    if (sasKeyNameValue != null && sasKeyNameValue instanceof NullNode == false) {
                                        String sasKeyNameInstance;
                                        sasKeyNameInstance = sasKeyNameValue.getTextValue();
                                        authenticationInstance.setSasKeyName(sasKeyNameInstance);
                                    }
                                    
                                    JsonNode sasKeyValue = authenticationValue2.get("sasKey");
                                    if (sasKeyValue != null && sasKeyValue instanceof NullNode == false) {
                                        String sasKeyInstance;
                                        sasKeyInstance = sasKeyValue.getTextValue();
                                        authenticationInstance.setSasKey(sasKeyInstance);
                                    }
                                    
                                    JsonNode typeValue6 = authenticationValue2.get("type");
                                    if (typeValue6 != null && typeValue6 instanceof NullNode == false) {
                                        JobServiceBusAuthenticationType typeInstance6;
                                        typeInstance6 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue6.getTextValue());
                                        authenticationInstance.setType(typeInstance6);
                                    }
                                }
                                
                                JsonNode messageValue2 = serviceBusTopicMessageValue.get("message");
                                if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                    String messageInstance2;
                                    messageInstance2 = messageValue2.getTextValue();
                                    serviceBusTopicMessageInstance.setMessage(messageInstance2);
                                }
                                
                                JsonNode brokeredMessagePropertiesValue = serviceBusTopicMessageValue.get("brokeredMessageProperties");
                                if (brokeredMessagePropertiesValue != null && brokeredMessagePropertiesValue instanceof NullNode == false) {
                                    JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance = new JobServiceBusBrokeredMessageProperties();
                                    serviceBusTopicMessageInstance.setBrokeredMessageProperties(brokeredMessagePropertiesInstance);
                                    
                                    JsonNode contentTypeValue = brokeredMessagePropertiesValue.get("contentType");
                                    if (contentTypeValue != null && contentTypeValue instanceof NullNode == false) {
                                        String contentTypeInstance;
                                        contentTypeInstance = contentTypeValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setContentType(contentTypeInstance);
                                    }
                                    
                                    JsonNode correlationIdValue = brokeredMessagePropertiesValue.get("correlationId");
                                    if (correlationIdValue != null && correlationIdValue instanceof NullNode == false) {
                                        String correlationIdInstance;
                                        correlationIdInstance = correlationIdValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setCorrelationId(correlationIdInstance);
                                    }
                                    
                                    JsonNode forcePersistenceValue = brokeredMessagePropertiesValue.get("forcePersistence");
                                    if (forcePersistenceValue != null && forcePersistenceValue instanceof NullNode == false) {
                                        boolean forcePersistenceInstance;
                                        forcePersistenceInstance = forcePersistenceValue.getBooleanValue();
                                        brokeredMessagePropertiesInstance.setForcePersistence(forcePersistenceInstance);
                                    }
                                    
                                    JsonNode labelValue = brokeredMessagePropertiesValue.get("label");
                                    if (labelValue != null && labelValue instanceof NullNode == false) {
                                        String labelInstance;
                                        labelInstance = labelValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setLabel(labelInstance);
                                    }
                                    
                                    JsonNode messageIdValue = brokeredMessagePropertiesValue.get("messageId");
                                    if (messageIdValue != null && messageIdValue instanceof NullNode == false) {
                                        String messageIdInstance;
                                        messageIdInstance = messageIdValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setMessageId(messageIdInstance);
                                    }
                                    
                                    JsonNode partitionKeyValue = brokeredMessagePropertiesValue.get("partitionKey");
                                    if (partitionKeyValue != null && partitionKeyValue instanceof NullNode == false) {
                                        String partitionKeyInstance;
                                        partitionKeyInstance = partitionKeyValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setPartitionKey(partitionKeyInstance);
                                    }
                                    
                                    JsonNode replyToValue = brokeredMessagePropertiesValue.get("replyTo");
                                    if (replyToValue != null && replyToValue instanceof NullNode == false) {
                                        String replyToInstance;
                                        replyToInstance = replyToValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setReplyTo(replyToInstance);
                                    }
                                    
                                    JsonNode replyToSessionIdValue = brokeredMessagePropertiesValue.get("replyToSessionId");
                                    if (replyToSessionIdValue != null && replyToSessionIdValue instanceof NullNode == false) {
                                        String replyToSessionIdInstance;
                                        replyToSessionIdInstance = replyToSessionIdValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setReplyToSessionId(replyToSessionIdInstance);
                                    }
                                    
                                    JsonNode scheduledEnqueueTimeUtcValue = brokeredMessagePropertiesValue.get("scheduledEnqueueTimeUtc");
                                    if (scheduledEnqueueTimeUtcValue != null && scheduledEnqueueTimeUtcValue instanceof NullNode == false) {
                                        Calendar scheduledEnqueueTimeUtcInstance;
                                        scheduledEnqueueTimeUtcInstance = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue.getTextValue());
                                        brokeredMessagePropertiesInstance.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance);
                                    }
                                    
                                    JsonNode sessionIdValue = brokeredMessagePropertiesValue.get("sessionId");
                                    if (sessionIdValue != null && sessionIdValue instanceof NullNode == false) {
                                        String sessionIdInstance;
                                        sessionIdInstance = sessionIdValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setSessionId(sessionIdInstance);
                                    }
                                    
                                    JsonNode timeToLiveValue = brokeredMessagePropertiesValue.get("timeToLive");
                                    if (timeToLiveValue != null && timeToLiveValue instanceof NullNode == false) {
                                        Calendar timeToLiveInstance;
                                        timeToLiveInstance = DatatypeConverter.parseDateTime(timeToLiveValue.getTextValue());
                                        brokeredMessagePropertiesInstance.setTimeToLive(timeToLiveInstance);
                                    }
                                    
                                    JsonNode toValue = brokeredMessagePropertiesValue.get("to");
                                    if (toValue != null && toValue instanceof NullNode == false) {
                                        String toInstance;
                                        toInstance = toValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setTo(toInstance);
                                    }
                                    
                                    JsonNode viaPartitionKeyValue = brokeredMessagePropertiesValue.get("viaPartitionKey");
                                    if (viaPartitionKeyValue != null && viaPartitionKeyValue instanceof NullNode == false) {
                                        String viaPartitionKeyInstance;
                                        viaPartitionKeyInstance = viaPartitionKeyValue.getTextValue();
                                        brokeredMessagePropertiesInstance.setViaPartitionKey(viaPartitionKeyInstance);
                                    }
                                }
                                
                                JsonNode customMessagePropertiesSequenceElement = ((JsonNode) serviceBusTopicMessageValue.get("customMessageProperties"));
                                if (customMessagePropertiesSequenceElement != null && customMessagePropertiesSequenceElement instanceof NullNode == false) {
                                    Iterator<Map.Entry<String, JsonNode>> itr2 = customMessagePropertiesSequenceElement.getFields();
                                    while (itr2.hasNext()) {
                                        Map.Entry<String, JsonNode> property2 = itr2.next();
                                        String customMessagePropertiesKey = property2.getKey();
                                        String customMessagePropertiesValue = property2.getValue().getTextValue();
                                        serviceBusTopicMessageInstance.getCustomMessageProperties().put(customMessagePropertiesKey, customMessagePropertiesValue);
                                    }
                                }
                            }
                            
                            JsonNode serviceBusQueueMessageValue = errorActionValue.get("serviceBusQueueMessage");
                            if (serviceBusQueueMessageValue != null && serviceBusQueueMessageValue instanceof NullNode == false) {
                                JobServiceBusQueueMessage serviceBusQueueMessageInstance = new JobServiceBusQueueMessage();
                                errorActionInstance.setServiceBusQueueMessage(serviceBusQueueMessageInstance);
                                
                                JsonNode queueNameValue2 = serviceBusQueueMessageValue.get("queueName");
                                if (queueNameValue2 != null && queueNameValue2 instanceof NullNode == false) {
                                    String queueNameInstance2;
                                    queueNameInstance2 = queueNameValue2.getTextValue();
                                    serviceBusQueueMessageInstance.setQueueName(queueNameInstance2);
                                }
                                
                                JsonNode namespaceValue2 = serviceBusQueueMessageValue.get("namespace");
                                if (namespaceValue2 != null && namespaceValue2 instanceof NullNode == false) {
                                    String namespaceInstance2;
                                    namespaceInstance2 = namespaceValue2.getTextValue();
                                    serviceBusQueueMessageInstance.setNamespace(namespaceInstance2);
                                }
                                
                                JsonNode transportTypeValue2 = serviceBusQueueMessageValue.get("transportType");
                                if (transportTypeValue2 != null && transportTypeValue2 instanceof NullNode == false) {
                                    JobServiceBusTransportType transportTypeInstance2;
                                    transportTypeInstance2 = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue2.getTextValue());
                                    serviceBusQueueMessageInstance.setTransportType(transportTypeInstance2);
                                }
                                
                                JsonNode authenticationValue3 = serviceBusQueueMessageValue.get("authentication");
                                if (authenticationValue3 != null && authenticationValue3 instanceof NullNode == false) {
                                    JobServiceBusAuthentication authenticationInstance2 = new JobServiceBusAuthentication();
                                    serviceBusQueueMessageInstance.setAuthentication(authenticationInstance2);
                                    
                                    JsonNode sasKeyNameValue2 = authenticationValue3.get("sasKeyName");
                                    if (sasKeyNameValue2 != null && sasKeyNameValue2 instanceof NullNode == false) {
                                        String sasKeyNameInstance2;
                                        sasKeyNameInstance2 = sasKeyNameValue2.getTextValue();
                                        authenticationInstance2.setSasKeyName(sasKeyNameInstance2);
                                    }
                                    
                                    JsonNode sasKeyValue2 = authenticationValue3.get("sasKey");
                                    if (sasKeyValue2 != null && sasKeyValue2 instanceof NullNode == false) {
                                        String sasKeyInstance2;
                                        sasKeyInstance2 = sasKeyValue2.getTextValue();
                                        authenticationInstance2.setSasKey(sasKeyInstance2);
                                    }
                                    
                                    JsonNode typeValue7 = authenticationValue3.get("type");
                                    if (typeValue7 != null && typeValue7 instanceof NullNode == false) {
                                        JobServiceBusAuthenticationType typeInstance7;
                                        typeInstance7 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue7.getTextValue());
                                        authenticationInstance2.setType(typeInstance7);
                                    }
                                }
                                
                                JsonNode messageValue3 = serviceBusQueueMessageValue.get("message");
                                if (messageValue3 != null && messageValue3 instanceof NullNode == false) {
                                    String messageInstance3;
                                    messageInstance3 = messageValue3.getTextValue();
                                    serviceBusQueueMessageInstance.setMessage(messageInstance3);
                                }
                                
                                JsonNode brokeredMessagePropertiesValue2 = serviceBusQueueMessageValue.get("brokeredMessageProperties");
                                if (brokeredMessagePropertiesValue2 != null && brokeredMessagePropertiesValue2 instanceof NullNode == false) {
                                    JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance2 = new JobServiceBusBrokeredMessageProperties();
                                    serviceBusQueueMessageInstance.setBrokeredMessageProperties(brokeredMessagePropertiesInstance2);
                                    
                                    JsonNode contentTypeValue2 = brokeredMessagePropertiesValue2.get("contentType");
                                    if (contentTypeValue2 != null && contentTypeValue2 instanceof NullNode == false) {
                                        String contentTypeInstance2;
                                        contentTypeInstance2 = contentTypeValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setContentType(contentTypeInstance2);
                                    }
                                    
                                    JsonNode correlationIdValue2 = brokeredMessagePropertiesValue2.get("correlationId");
                                    if (correlationIdValue2 != null && correlationIdValue2 instanceof NullNode == false) {
                                        String correlationIdInstance2;
                                        correlationIdInstance2 = correlationIdValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setCorrelationId(correlationIdInstance2);
                                    }
                                    
                                    JsonNode forcePersistenceValue2 = brokeredMessagePropertiesValue2.get("forcePersistence");
                                    if (forcePersistenceValue2 != null && forcePersistenceValue2 instanceof NullNode == false) {
                                        boolean forcePersistenceInstance2;
                                        forcePersistenceInstance2 = forcePersistenceValue2.getBooleanValue();
                                        brokeredMessagePropertiesInstance2.setForcePersistence(forcePersistenceInstance2);
                                    }
                                    
                                    JsonNode labelValue2 = brokeredMessagePropertiesValue2.get("label");
                                    if (labelValue2 != null && labelValue2 instanceof NullNode == false) {
                                        String labelInstance2;
                                        labelInstance2 = labelValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setLabel(labelInstance2);
                                    }
                                    
                                    JsonNode messageIdValue2 = brokeredMessagePropertiesValue2.get("messageId");
                                    if (messageIdValue2 != null && messageIdValue2 instanceof NullNode == false) {
                                        String messageIdInstance2;
                                        messageIdInstance2 = messageIdValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setMessageId(messageIdInstance2);
                                    }
                                    
                                    JsonNode partitionKeyValue2 = brokeredMessagePropertiesValue2.get("partitionKey");
                                    if (partitionKeyValue2 != null && partitionKeyValue2 instanceof NullNode == false) {
                                        String partitionKeyInstance2;
                                        partitionKeyInstance2 = partitionKeyValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setPartitionKey(partitionKeyInstance2);
                                    }
                                    
                                    JsonNode replyToValue2 = brokeredMessagePropertiesValue2.get("replyTo");
                                    if (replyToValue2 != null && replyToValue2 instanceof NullNode == false) {
                                        String replyToInstance2;
                                        replyToInstance2 = replyToValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setReplyTo(replyToInstance2);
                                    }
                                    
                                    JsonNode replyToSessionIdValue2 = brokeredMessagePropertiesValue2.get("replyToSessionId");
                                    if (replyToSessionIdValue2 != null && replyToSessionIdValue2 instanceof NullNode == false) {
                                        String replyToSessionIdInstance2;
                                        replyToSessionIdInstance2 = replyToSessionIdValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setReplyToSessionId(replyToSessionIdInstance2);
                                    }
                                    
                                    JsonNode scheduledEnqueueTimeUtcValue2 = brokeredMessagePropertiesValue2.get("scheduledEnqueueTimeUtc");
                                    if (scheduledEnqueueTimeUtcValue2 != null && scheduledEnqueueTimeUtcValue2 instanceof NullNode == false) {
                                        Calendar scheduledEnqueueTimeUtcInstance2;
                                        scheduledEnqueueTimeUtcInstance2 = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue2.getTextValue());
                                        brokeredMessagePropertiesInstance2.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance2);
                                    }
                                    
                                    JsonNode sessionIdValue2 = brokeredMessagePropertiesValue2.get("sessionId");
                                    if (sessionIdValue2 != null && sessionIdValue2 instanceof NullNode == false) {
                                        String sessionIdInstance2;
                                        sessionIdInstance2 = sessionIdValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setSessionId(sessionIdInstance2);
                                    }
                                    
                                    JsonNode timeToLiveValue2 = brokeredMessagePropertiesValue2.get("timeToLive");
                                    if (timeToLiveValue2 != null && timeToLiveValue2 instanceof NullNode == false) {
                                        Calendar timeToLiveInstance2;
                                        timeToLiveInstance2 = DatatypeConverter.parseDateTime(timeToLiveValue2.getTextValue());
                                        brokeredMessagePropertiesInstance2.setTimeToLive(timeToLiveInstance2);
                                    }
                                    
                                    JsonNode toValue2 = brokeredMessagePropertiesValue2.get("to");
                                    if (toValue2 != null && toValue2 instanceof NullNode == false) {
                                        String toInstance2;
                                        toInstance2 = toValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setTo(toInstance2);
                                    }
                                    
                                    JsonNode viaPartitionKeyValue2 = brokeredMessagePropertiesValue2.get("viaPartitionKey");
                                    if (viaPartitionKeyValue2 != null && viaPartitionKeyValue2 instanceof NullNode == false) {
                                        String viaPartitionKeyInstance2;
                                        viaPartitionKeyInstance2 = viaPartitionKeyValue2.getTextValue();
                                        brokeredMessagePropertiesInstance2.setViaPartitionKey(viaPartitionKeyInstance2);
                                    }
                                }
                                
                                JsonNode customMessagePropertiesSequenceElement2 = ((JsonNode) serviceBusQueueMessageValue.get("customMessageProperties"));
                                if (customMessagePropertiesSequenceElement2 != null && customMessagePropertiesSequenceElement2 instanceof NullNode == false) {
                                    Iterator<Map.Entry<String, JsonNode>> itr3 = customMessagePropertiesSequenceElement2.getFields();
                                    while (itr3.hasNext()) {
                                        Map.Entry<String, JsonNode> property3 = itr3.next();
                                        String customMessagePropertiesKey2 = property3.getKey();
                                        String customMessagePropertiesValue2 = property3.getValue().getTextValue();
                                        serviceBusQueueMessageInstance.getCustomMessageProperties().put(customMessagePropertiesKey2, customMessagePropertiesValue2);
                                    }
                                }
                            }
                        }
                        
                        JsonNode requestValue2 = actionValue.get("request");
                        if (requestValue2 != null && requestValue2 instanceof NullNode == false) {
                            JobHttpRequest requestInstance2 = new JobHttpRequest();
                            actionInstance.setRequest(requestInstance2);
                            
                            JsonNode uriValue2 = requestValue2.get("uri");
                            if (uriValue2 != null && uriValue2 instanceof NullNode == false) {
                                URI uriInstance2;
                                uriInstance2 = new URI(uriValue2.getTextValue());
                                requestInstance2.setUri(uriInstance2);
                            }
                            
                            JsonNode methodValue2 = requestValue2.get("method");
                            if (methodValue2 != null && methodValue2 instanceof NullNode == false) {
                                String methodInstance2;
                                methodInstance2 = methodValue2.getTextValue();
                                requestInstance2.setMethod(methodInstance2);
                            }
                            
                            JsonNode headersSequenceElement2 = ((JsonNode) requestValue2.get("headers"));
                            if (headersSequenceElement2 != null && headersSequenceElement2 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr4 = headersSequenceElement2.getFields();
                                while (itr4.hasNext()) {
                                    Map.Entry<String, JsonNode> property4 = itr4.next();
                                    String headersKey2 = property4.getKey();
                                    String headersValue2 = property4.getValue().getTextValue();
                                    requestInstance2.getHeaders().put(headersKey2, headersValue2);
                                }
                            }
                            
                            JsonNode bodyValue2 = requestValue2.get("body");
                            if (bodyValue2 != null && bodyValue2 instanceof NullNode == false) {
                                String bodyInstance2;
                                bodyInstance2 = bodyValue2.getTextValue();
                                requestInstance2.setBody(bodyInstance2);
                            }
                            
                            JsonNode authenticationValue4 = requestValue2.get("authentication");
                            if (authenticationValue4 != null && authenticationValue4 instanceof NullNode == false) {
                                String typeName2 = authenticationValue4.get("type").getTextValue();
                                if ("ClientCertificate".equals(typeName2)) {
                                    ClientCertAuthentication clientCertAuthenticationInstance2 = new ClientCertAuthentication();
                                    
                                    JsonNode passwordValue3 = authenticationValue4.get("password");
                                    if (passwordValue3 != null && passwordValue3 instanceof NullNode == false) {
                                        String passwordInstance3;
                                        passwordInstance3 = passwordValue3.getTextValue();
                                        clientCertAuthenticationInstance2.setPassword(passwordInstance3);
                                    }
                                    
                                    JsonNode pfxValue2 = authenticationValue4.get("pfx");
                                    if (pfxValue2 != null && pfxValue2 instanceof NullNode == false) {
                                        String pfxInstance2;
                                        pfxInstance2 = pfxValue2.getTextValue();
                                        clientCertAuthenticationInstance2.setPfx(pfxInstance2);
                                    }
                                    
                                    JsonNode certificateThumbprintValue2 = authenticationValue4.get("certificateThumbprint");
                                    if (certificateThumbprintValue2 != null && certificateThumbprintValue2 instanceof NullNode == false) {
                                        String certificateThumbprintInstance2;
                                        certificateThumbprintInstance2 = certificateThumbprintValue2.getTextValue();
                                        clientCertAuthenticationInstance2.setCertificateThumbprint(certificateThumbprintInstance2);
                                    }
                                    
                                    JsonNode certificateExpirationValue2 = authenticationValue4.get("certificateExpiration");
                                    if (certificateExpirationValue2 != null && certificateExpirationValue2 instanceof NullNode == false) {
                                        Calendar certificateExpirationInstance2;
                                        certificateExpirationInstance2 = DatatypeConverter.parseDateTime(certificateExpirationValue2.getTextValue());
                                        clientCertAuthenticationInstance2.setCertificateExpiration(certificateExpirationInstance2);
                                    }
                                    
                                    JsonNode certificateSubjectNameValue2 = authenticationValue4.get("certificateSubjectName");
                                    if (certificateSubjectNameValue2 != null && certificateSubjectNameValue2 instanceof NullNode == false) {
                                        String certificateSubjectNameInstance2;
                                        certificateSubjectNameInstance2 = certificateSubjectNameValue2.getTextValue();
                                        clientCertAuthenticationInstance2.setCertificateSubjectName(certificateSubjectNameInstance2);
                                    }
                                    
                                    JsonNode typeValue8 = authenticationValue4.get("type");
                                    if (typeValue8 != null && typeValue8 instanceof NullNode == false) {
                                        HttpAuthenticationType typeInstance8;
                                        typeInstance8 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue8.getTextValue());
                                        clientCertAuthenticationInstance2.setType(typeInstance8);
                                    }
                                    requestInstance2.setAuthentication(clientCertAuthenticationInstance2);
                                }
                                if ("ActiveDirectoryOAuth".equals(typeName2)) {
                                    AADOAuthAuthentication aADOAuthAuthenticationInstance2 = new AADOAuthAuthentication();
                                    
                                    JsonNode secretValue2 = authenticationValue4.get("secret");
                                    if (secretValue2 != null && secretValue2 instanceof NullNode == false) {
                                        String secretInstance2;
                                        secretInstance2 = secretValue2.getTextValue();
                                        aADOAuthAuthenticationInstance2.setSecret(secretInstance2);
                                    }
                                    
                                    JsonNode tenantValue2 = authenticationValue4.get("tenant");
                                    if (tenantValue2 != null && tenantValue2 instanceof NullNode == false) {
                                        String tenantInstance2;
                                        tenantInstance2 = tenantValue2.getTextValue();
                                        aADOAuthAuthenticationInstance2.setTenant(tenantInstance2);
                                    }
                                    
                                    JsonNode audienceValue2 = authenticationValue4.get("audience");
                                    if (audienceValue2 != null && audienceValue2 instanceof NullNode == false) {
                                        String audienceInstance2;
                                        audienceInstance2 = audienceValue2.getTextValue();
                                        aADOAuthAuthenticationInstance2.setAudience(audienceInstance2);
                                    }
                                    
                                    JsonNode clientIdValue2 = authenticationValue4.get("clientId");
                                    if (clientIdValue2 != null && clientIdValue2 instanceof NullNode == false) {
                                        String clientIdInstance2;
                                        clientIdInstance2 = clientIdValue2.getTextValue();
                                        aADOAuthAuthenticationInstance2.setClientId(clientIdInstance2);
                                    }
                                    
                                    JsonNode typeValue9 = authenticationValue4.get("type");
                                    if (typeValue9 != null && typeValue9 instanceof NullNode == false) {
                                        HttpAuthenticationType typeInstance9;
                                        typeInstance9 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue9.getTextValue());
                                        aADOAuthAuthenticationInstance2.setType(typeInstance9);
                                    }
                                    requestInstance2.setAuthentication(aADOAuthAuthenticationInstance2);
                                }
                                if ("Basic".equals(typeName2)) {
                                    BasicAuthentication basicAuthenticationInstance2 = new BasicAuthentication();
                                    
                                    JsonNode usernameValue2 = authenticationValue4.get("username");
                                    if (usernameValue2 != null && usernameValue2 instanceof NullNode == false) {
                                        String usernameInstance2;
                                        usernameInstance2 = usernameValue2.getTextValue();
                                        basicAuthenticationInstance2.setUsername(usernameInstance2);
                                    }
                                    
                                    JsonNode passwordValue4 = authenticationValue4.get("password");
                                    if (passwordValue4 != null && passwordValue4 instanceof NullNode == false) {
                                        String passwordInstance4;
                                        passwordInstance4 = passwordValue4.getTextValue();
                                        basicAuthenticationInstance2.setPassword(passwordInstance4);
                                    }
                                    
                                    JsonNode typeValue10 = authenticationValue4.get("type");
                                    if (typeValue10 != null && typeValue10 instanceof NullNode == false) {
                                        HttpAuthenticationType typeInstance10;
                                        typeInstance10 = SchedulerClientImpl.parseHttpAuthenticationType(typeValue10.getTextValue());
                                        basicAuthenticationInstance2.setType(typeInstance10);
                                    }
                                    requestInstance2.setAuthentication(basicAuthenticationInstance2);
                                }
                            }
                        }
                        
                        JsonNode queueMessageValue2 = actionValue.get("queueMessage");
                        if (queueMessageValue2 != null && queueMessageValue2 instanceof NullNode == false) {
                            JobQueueMessage queueMessageInstance2 = new JobQueueMessage();
                            actionInstance.setQueueMessage(queueMessageInstance2);
                            
                            JsonNode storageAccountValue2 = queueMessageValue2.get("storageAccount");
                            if (storageAccountValue2 != null && storageAccountValue2 instanceof NullNode == false) {
                                String storageAccountInstance2;
                                storageAccountInstance2 = storageAccountValue2.getTextValue();
                                queueMessageInstance2.setStorageAccountName(storageAccountInstance2);
                            }
                            
                            JsonNode queueNameValue3 = queueMessageValue2.get("queueName");
                            if (queueNameValue3 != null && queueNameValue3 instanceof NullNode == false) {
                                String queueNameInstance3;
                                queueNameInstance3 = queueNameValue3.getTextValue();
                                queueMessageInstance2.setQueueName(queueNameInstance3);
                            }
                            
                            JsonNode sasTokenValue2 = queueMessageValue2.get("sasToken");
                            if (sasTokenValue2 != null && sasTokenValue2 instanceof NullNode == false) {
                                String sasTokenInstance2;
                                sasTokenInstance2 = sasTokenValue2.getTextValue();
                                queueMessageInstance2.setSasToken(sasTokenInstance2);
                            }
                            
                            JsonNode messageValue4 = queueMessageValue2.get("message");
                            if (messageValue4 != null && messageValue4 instanceof NullNode == false) {
                                String messageInstance4;
                                messageInstance4 = messageValue4.getTextValue();
                                queueMessageInstance2.setMessage(messageInstance4);
                            }
                        }
                        
                        JsonNode serviceBusTopicMessageValue2 = actionValue.get("serviceBusTopicMessage");
                        if (serviceBusTopicMessageValue2 != null && serviceBusTopicMessageValue2 instanceof NullNode == false) {
                            JobServiceBusTopicMessage serviceBusTopicMessageInstance2 = new JobServiceBusTopicMessage();
                            actionInstance.setServiceBusTopicMessage(serviceBusTopicMessageInstance2);
                            
                            JsonNode topicPathValue2 = serviceBusTopicMessageValue2.get("topicPath");
                            if (topicPathValue2 != null && topicPathValue2 instanceof NullNode == false) {
                                String topicPathInstance2;
                                topicPathInstance2 = topicPathValue2.getTextValue();
                                serviceBusTopicMessageInstance2.setTopicPath(topicPathInstance2);
                            }
                            
                            JsonNode namespaceValue3 = serviceBusTopicMessageValue2.get("namespace");
                            if (namespaceValue3 != null && namespaceValue3 instanceof NullNode == false) {
                                String namespaceInstance3;
                                namespaceInstance3 = namespaceValue3.getTextValue();
                                serviceBusTopicMessageInstance2.setNamespace(namespaceInstance3);
                            }
                            
                            JsonNode transportTypeValue3 = serviceBusTopicMessageValue2.get("transportType");
                            if (transportTypeValue3 != null && transportTypeValue3 instanceof NullNode == false) {
                                JobServiceBusTransportType transportTypeInstance3;
                                transportTypeInstance3 = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue3.getTextValue());
                                serviceBusTopicMessageInstance2.setTransportType(transportTypeInstance3);
                            }
                            
                            JsonNode authenticationValue5 = serviceBusTopicMessageValue2.get("authentication");
                            if (authenticationValue5 != null && authenticationValue5 instanceof NullNode == false) {
                                JobServiceBusAuthentication authenticationInstance3 = new JobServiceBusAuthentication();
                                serviceBusTopicMessageInstance2.setAuthentication(authenticationInstance3);
                                
                                JsonNode sasKeyNameValue3 = authenticationValue5.get("sasKeyName");
                                if (sasKeyNameValue3 != null && sasKeyNameValue3 instanceof NullNode == false) {
                                    String sasKeyNameInstance3;
                                    sasKeyNameInstance3 = sasKeyNameValue3.getTextValue();
                                    authenticationInstance3.setSasKeyName(sasKeyNameInstance3);
                                }
                                
                                JsonNode sasKeyValue3 = authenticationValue5.get("sasKey");
                                if (sasKeyValue3 != null && sasKeyValue3 instanceof NullNode == false) {
                                    String sasKeyInstance3;
                                    sasKeyInstance3 = sasKeyValue3.getTextValue();
                                    authenticationInstance3.setSasKey(sasKeyInstance3);
                                }
                                
                                JsonNode typeValue11 = authenticationValue5.get("type");
                                if (typeValue11 != null && typeValue11 instanceof NullNode == false) {
                                    JobServiceBusAuthenticationType typeInstance11;
                                    typeInstance11 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue11.getTextValue());
                                    authenticationInstance3.setType(typeInstance11);
                                }
                            }
                            
                            JsonNode messageValue5 = serviceBusTopicMessageValue2.get("message");
                            if (messageValue5 != null && messageValue5 instanceof NullNode == false) {
                                String messageInstance5;
                                messageInstance5 = messageValue5.getTextValue();
                                serviceBusTopicMessageInstance2.setMessage(messageInstance5);
                            }
                            
                            JsonNode brokeredMessagePropertiesValue3 = serviceBusTopicMessageValue2.get("brokeredMessageProperties");
                            if (brokeredMessagePropertiesValue3 != null && brokeredMessagePropertiesValue3 instanceof NullNode == false) {
                                JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance3 = new JobServiceBusBrokeredMessageProperties();
                                serviceBusTopicMessageInstance2.setBrokeredMessageProperties(brokeredMessagePropertiesInstance3);
                                
                                JsonNode contentTypeValue3 = brokeredMessagePropertiesValue3.get("contentType");
                                if (contentTypeValue3 != null && contentTypeValue3 instanceof NullNode == false) {
                                    String contentTypeInstance3;
                                    contentTypeInstance3 = contentTypeValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setContentType(contentTypeInstance3);
                                }
                                
                                JsonNode correlationIdValue3 = brokeredMessagePropertiesValue3.get("correlationId");
                                if (correlationIdValue3 != null && correlationIdValue3 instanceof NullNode == false) {
                                    String correlationIdInstance3;
                                    correlationIdInstance3 = correlationIdValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setCorrelationId(correlationIdInstance3);
                                }
                                
                                JsonNode forcePersistenceValue3 = brokeredMessagePropertiesValue3.get("forcePersistence");
                                if (forcePersistenceValue3 != null && forcePersistenceValue3 instanceof NullNode == false) {
                                    boolean forcePersistenceInstance3;
                                    forcePersistenceInstance3 = forcePersistenceValue3.getBooleanValue();
                                    brokeredMessagePropertiesInstance3.setForcePersistence(forcePersistenceInstance3);
                                }
                                
                                JsonNode labelValue3 = brokeredMessagePropertiesValue3.get("label");
                                if (labelValue3 != null && labelValue3 instanceof NullNode == false) {
                                    String labelInstance3;
                                    labelInstance3 = labelValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setLabel(labelInstance3);
                                }
                                
                                JsonNode messageIdValue3 = brokeredMessagePropertiesValue3.get("messageId");
                                if (messageIdValue3 != null && messageIdValue3 instanceof NullNode == false) {
                                    String messageIdInstance3;
                                    messageIdInstance3 = messageIdValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setMessageId(messageIdInstance3);
                                }
                                
                                JsonNode partitionKeyValue3 = brokeredMessagePropertiesValue3.get("partitionKey");
                                if (partitionKeyValue3 != null && partitionKeyValue3 instanceof NullNode == false) {
                                    String partitionKeyInstance3;
                                    partitionKeyInstance3 = partitionKeyValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setPartitionKey(partitionKeyInstance3);
                                }
                                
                                JsonNode replyToValue3 = brokeredMessagePropertiesValue3.get("replyTo");
                                if (replyToValue3 != null && replyToValue3 instanceof NullNode == false) {
                                    String replyToInstance3;
                                    replyToInstance3 = replyToValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setReplyTo(replyToInstance3);
                                }
                                
                                JsonNode replyToSessionIdValue3 = brokeredMessagePropertiesValue3.get("replyToSessionId");
                                if (replyToSessionIdValue3 != null && replyToSessionIdValue3 instanceof NullNode == false) {
                                    String replyToSessionIdInstance3;
                                    replyToSessionIdInstance3 = replyToSessionIdValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setReplyToSessionId(replyToSessionIdInstance3);
                                }
                                
                                JsonNode scheduledEnqueueTimeUtcValue3 = brokeredMessagePropertiesValue3.get("scheduledEnqueueTimeUtc");
                                if (scheduledEnqueueTimeUtcValue3 != null && scheduledEnqueueTimeUtcValue3 instanceof NullNode == false) {
                                    Calendar scheduledEnqueueTimeUtcInstance3;
                                    scheduledEnqueueTimeUtcInstance3 = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue3.getTextValue());
                                    brokeredMessagePropertiesInstance3.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance3);
                                }
                                
                                JsonNode sessionIdValue3 = brokeredMessagePropertiesValue3.get("sessionId");
                                if (sessionIdValue3 != null && sessionIdValue3 instanceof NullNode == false) {
                                    String sessionIdInstance3;
                                    sessionIdInstance3 = sessionIdValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setSessionId(sessionIdInstance3);
                                }
                                
                                JsonNode timeToLiveValue3 = brokeredMessagePropertiesValue3.get("timeToLive");
                                if (timeToLiveValue3 != null && timeToLiveValue3 instanceof NullNode == false) {
                                    Calendar timeToLiveInstance3;
                                    timeToLiveInstance3 = DatatypeConverter.parseDateTime(timeToLiveValue3.getTextValue());
                                    brokeredMessagePropertiesInstance3.setTimeToLive(timeToLiveInstance3);
                                }
                                
                                JsonNode toValue3 = brokeredMessagePropertiesValue3.get("to");
                                if (toValue3 != null && toValue3 instanceof NullNode == false) {
                                    String toInstance3;
                                    toInstance3 = toValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setTo(toInstance3);
                                }
                                
                                JsonNode viaPartitionKeyValue3 = brokeredMessagePropertiesValue3.get("viaPartitionKey");
                                if (viaPartitionKeyValue3 != null && viaPartitionKeyValue3 instanceof NullNode == false) {
                                    String viaPartitionKeyInstance3;
                                    viaPartitionKeyInstance3 = viaPartitionKeyValue3.getTextValue();
                                    brokeredMessagePropertiesInstance3.setViaPartitionKey(viaPartitionKeyInstance3);
                                }
                            }
                            
                            JsonNode customMessagePropertiesSequenceElement3 = ((JsonNode) serviceBusTopicMessageValue2.get("customMessageProperties"));
                            if (customMessagePropertiesSequenceElement3 != null && customMessagePropertiesSequenceElement3 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr5 = customMessagePropertiesSequenceElement3.getFields();
                                while (itr5.hasNext()) {
                                    Map.Entry<String, JsonNode> property5 = itr5.next();
                                    String customMessagePropertiesKey3 = property5.getKey();
                                    String customMessagePropertiesValue3 = property5.getValue().getTextValue();
                                    serviceBusTopicMessageInstance2.getCustomMessageProperties().put(customMessagePropertiesKey3, customMessagePropertiesValue3);
                                }
                            }
                        }
                        
                        JsonNode serviceBusQueueMessageValue2 = actionValue.get("serviceBusQueueMessage");
                        if (serviceBusQueueMessageValue2 != null && serviceBusQueueMessageValue2 instanceof NullNode == false) {
                            JobServiceBusQueueMessage serviceBusQueueMessageInstance2 = new JobServiceBusQueueMessage();
                            actionInstance.setServiceBusQueueMessage(serviceBusQueueMessageInstance2);
                            
                            JsonNode queueNameValue4 = serviceBusQueueMessageValue2.get("queueName");
                            if (queueNameValue4 != null && queueNameValue4 instanceof NullNode == false) {
                                String queueNameInstance4;
                                queueNameInstance4 = queueNameValue4.getTextValue();
                                serviceBusQueueMessageInstance2.setQueueName(queueNameInstance4);
                            }
                            
                            JsonNode namespaceValue4 = serviceBusQueueMessageValue2.get("namespace");
                            if (namespaceValue4 != null && namespaceValue4 instanceof NullNode == false) {
                                String namespaceInstance4;
                                namespaceInstance4 = namespaceValue4.getTextValue();
                                serviceBusQueueMessageInstance2.setNamespace(namespaceInstance4);
                            }
                            
                            JsonNode transportTypeValue4 = serviceBusQueueMessageValue2.get("transportType");
                            if (transportTypeValue4 != null && transportTypeValue4 instanceof NullNode == false) {
                                JobServiceBusTransportType transportTypeInstance4;
                                transportTypeInstance4 = SchedulerClientImpl.parseJobServiceBusTransportType(transportTypeValue4.getTextValue());
                                serviceBusQueueMessageInstance2.setTransportType(transportTypeInstance4);
                            }
                            
                            JsonNode authenticationValue6 = serviceBusQueueMessageValue2.get("authentication");
                            if (authenticationValue6 != null && authenticationValue6 instanceof NullNode == false) {
                                JobServiceBusAuthentication authenticationInstance4 = new JobServiceBusAuthentication();
                                serviceBusQueueMessageInstance2.setAuthentication(authenticationInstance4);
                                
                                JsonNode sasKeyNameValue4 = authenticationValue6.get("sasKeyName");
                                if (sasKeyNameValue4 != null && sasKeyNameValue4 instanceof NullNode == false) {
                                    String sasKeyNameInstance4;
                                    sasKeyNameInstance4 = sasKeyNameValue4.getTextValue();
                                    authenticationInstance4.setSasKeyName(sasKeyNameInstance4);
                                }
                                
                                JsonNode sasKeyValue4 = authenticationValue6.get("sasKey");
                                if (sasKeyValue4 != null && sasKeyValue4 instanceof NullNode == false) {
                                    String sasKeyInstance4;
                                    sasKeyInstance4 = sasKeyValue4.getTextValue();
                                    authenticationInstance4.setSasKey(sasKeyInstance4);
                                }
                                
                                JsonNode typeValue12 = authenticationValue6.get("type");
                                if (typeValue12 != null && typeValue12 instanceof NullNode == false) {
                                    JobServiceBusAuthenticationType typeInstance12;
                                    typeInstance12 = SchedulerClientImpl.parseJobServiceBusAuthenticationType(typeValue12.getTextValue());
                                    authenticationInstance4.setType(typeInstance12);
                                }
                            }
                            
                            JsonNode messageValue6 = serviceBusQueueMessageValue2.get("message");
                            if (messageValue6 != null && messageValue6 instanceof NullNode == false) {
                                String messageInstance6;
                                messageInstance6 = messageValue6.getTextValue();
                                serviceBusQueueMessageInstance2.setMessage(messageInstance6);
                            }
                            
                            JsonNode brokeredMessagePropertiesValue4 = serviceBusQueueMessageValue2.get("brokeredMessageProperties");
                            if (brokeredMessagePropertiesValue4 != null && brokeredMessagePropertiesValue4 instanceof NullNode == false) {
                                JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesInstance4 = new JobServiceBusBrokeredMessageProperties();
                                serviceBusQueueMessageInstance2.setBrokeredMessageProperties(brokeredMessagePropertiesInstance4);
                                
                                JsonNode contentTypeValue4 = brokeredMessagePropertiesValue4.get("contentType");
                                if (contentTypeValue4 != null && contentTypeValue4 instanceof NullNode == false) {
                                    String contentTypeInstance4;
                                    contentTypeInstance4 = contentTypeValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setContentType(contentTypeInstance4);
                                }
                                
                                JsonNode correlationIdValue4 = brokeredMessagePropertiesValue4.get("correlationId");
                                if (correlationIdValue4 != null && correlationIdValue4 instanceof NullNode == false) {
                                    String correlationIdInstance4;
                                    correlationIdInstance4 = correlationIdValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setCorrelationId(correlationIdInstance4);
                                }
                                
                                JsonNode forcePersistenceValue4 = brokeredMessagePropertiesValue4.get("forcePersistence");
                                if (forcePersistenceValue4 != null && forcePersistenceValue4 instanceof NullNode == false) {
                                    boolean forcePersistenceInstance4;
                                    forcePersistenceInstance4 = forcePersistenceValue4.getBooleanValue();
                                    brokeredMessagePropertiesInstance4.setForcePersistence(forcePersistenceInstance4);
                                }
                                
                                JsonNode labelValue4 = brokeredMessagePropertiesValue4.get("label");
                                if (labelValue4 != null && labelValue4 instanceof NullNode == false) {
                                    String labelInstance4;
                                    labelInstance4 = labelValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setLabel(labelInstance4);
                                }
                                
                                JsonNode messageIdValue4 = brokeredMessagePropertiesValue4.get("messageId");
                                if (messageIdValue4 != null && messageIdValue4 instanceof NullNode == false) {
                                    String messageIdInstance4;
                                    messageIdInstance4 = messageIdValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setMessageId(messageIdInstance4);
                                }
                                
                                JsonNode partitionKeyValue4 = brokeredMessagePropertiesValue4.get("partitionKey");
                                if (partitionKeyValue4 != null && partitionKeyValue4 instanceof NullNode == false) {
                                    String partitionKeyInstance4;
                                    partitionKeyInstance4 = partitionKeyValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setPartitionKey(partitionKeyInstance4);
                                }
                                
                                JsonNode replyToValue4 = brokeredMessagePropertiesValue4.get("replyTo");
                                if (replyToValue4 != null && replyToValue4 instanceof NullNode == false) {
                                    String replyToInstance4;
                                    replyToInstance4 = replyToValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setReplyTo(replyToInstance4);
                                }
                                
                                JsonNode replyToSessionIdValue4 = brokeredMessagePropertiesValue4.get("replyToSessionId");
                                if (replyToSessionIdValue4 != null && replyToSessionIdValue4 instanceof NullNode == false) {
                                    String replyToSessionIdInstance4;
                                    replyToSessionIdInstance4 = replyToSessionIdValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setReplyToSessionId(replyToSessionIdInstance4);
                                }
                                
                                JsonNode scheduledEnqueueTimeUtcValue4 = brokeredMessagePropertiesValue4.get("scheduledEnqueueTimeUtc");
                                if (scheduledEnqueueTimeUtcValue4 != null && scheduledEnqueueTimeUtcValue4 instanceof NullNode == false) {
                                    Calendar scheduledEnqueueTimeUtcInstance4;
                                    scheduledEnqueueTimeUtcInstance4 = DatatypeConverter.parseDateTime(scheduledEnqueueTimeUtcValue4.getTextValue());
                                    brokeredMessagePropertiesInstance4.setScheduledEnqueueTimeUtc(scheduledEnqueueTimeUtcInstance4);
                                }
                                
                                JsonNode sessionIdValue4 = brokeredMessagePropertiesValue4.get("sessionId");
                                if (sessionIdValue4 != null && sessionIdValue4 instanceof NullNode == false) {
                                    String sessionIdInstance4;
                                    sessionIdInstance4 = sessionIdValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setSessionId(sessionIdInstance4);
                                }
                                
                                JsonNode timeToLiveValue4 = brokeredMessagePropertiesValue4.get("timeToLive");
                                if (timeToLiveValue4 != null && timeToLiveValue4 instanceof NullNode == false) {
                                    Calendar timeToLiveInstance4;
                                    timeToLiveInstance4 = DatatypeConverter.parseDateTime(timeToLiveValue4.getTextValue());
                                    brokeredMessagePropertiesInstance4.setTimeToLive(timeToLiveInstance4);
                                }
                                
                                JsonNode toValue4 = brokeredMessagePropertiesValue4.get("to");
                                if (toValue4 != null && toValue4 instanceof NullNode == false) {
                                    String toInstance4;
                                    toInstance4 = toValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setTo(toInstance4);
                                }
                                
                                JsonNode viaPartitionKeyValue4 = brokeredMessagePropertiesValue4.get("viaPartitionKey");
                                if (viaPartitionKeyValue4 != null && viaPartitionKeyValue4 instanceof NullNode == false) {
                                    String viaPartitionKeyInstance4;
                                    viaPartitionKeyInstance4 = viaPartitionKeyValue4.getTextValue();
                                    brokeredMessagePropertiesInstance4.setViaPartitionKey(viaPartitionKeyInstance4);
                                }
                            }
                            
                            JsonNode customMessagePropertiesSequenceElement4 = ((JsonNode) serviceBusQueueMessageValue2.get("customMessageProperties"));
                            if (customMessagePropertiesSequenceElement4 != null && customMessagePropertiesSequenceElement4 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr6 = customMessagePropertiesSequenceElement4.getFields();
                                while (itr6.hasNext()) {
                                    Map.Entry<String, JsonNode> property6 = itr6.next();
                                    String customMessagePropertiesKey4 = property6.getKey();
                                    String customMessagePropertiesValue4 = property6.getValue().getTextValue();
                                    serviceBusQueueMessageInstance2.getCustomMessageProperties().put(customMessagePropertiesKey4, customMessagePropertiesValue4);
                                }
                            }
                        }
                    }
                    
                    JsonNode recurrenceValue = responseDoc.get("recurrence");
                    if (recurrenceValue != null && recurrenceValue instanceof NullNode == false) {
                        JobRecurrence recurrenceInstance = new JobRecurrence();
                        jobInstance.setRecurrence(recurrenceInstance);
                        
                        JsonNode frequencyValue = recurrenceValue.get("frequency");
                        if (frequencyValue != null && frequencyValue instanceof NullNode == false) {
                            JobRecurrenceFrequency frequencyInstance;
                            frequencyInstance = SchedulerClientImpl.parseJobRecurrenceFrequency(frequencyValue.getTextValue());
                            recurrenceInstance.setFrequency(frequencyInstance);
                        }
                        
                        JsonNode intervalValue = recurrenceValue.get("interval");
                        if (intervalValue != null && intervalValue instanceof NullNode == false) {
                            int intervalInstance;
                            intervalInstance = intervalValue.getIntValue();
                            recurrenceInstance.setInterval(intervalInstance);
                        }
                        
                        JsonNode countValue = recurrenceValue.get("count");
                        if (countValue != null && countValue instanceof NullNode == false) {
                            int countInstance;
                            countInstance = countValue.getIntValue();
                            recurrenceInstance.setCount(countInstance);
                        }
                        
                        JsonNode endTimeValue = recurrenceValue.get("endTime");
                        if (endTimeValue != null && endTimeValue instanceof NullNode == false) {
                            Calendar endTimeInstance;
                            endTimeInstance = DatatypeConverter.parseDateTime(endTimeValue.getTextValue());
                            recurrenceInstance.setEndTime(endTimeInstance);
                        }
                        
                        JsonNode scheduleValue = recurrenceValue.get("schedule");
                        if (scheduleValue != null && scheduleValue instanceof NullNode == false) {
                            JobRecurrenceSchedule scheduleInstance = new JobRecurrenceSchedule();
                            recurrenceInstance.setSchedule(scheduleInstance);
                            
                            JsonNode minutesArray = scheduleValue.get("minutes");
                            if (minutesArray != null && minutesArray instanceof NullNode == false) {
                                scheduleInstance.setMinutes(new ArrayList<Integer>());
                                for (JsonNode minutesValue : ((ArrayNode) minutesArray)) {
                                    scheduleInstance.getMinutes().add(minutesValue.getIntValue());
                                }
                            }
                            
                            JsonNode hoursArray = scheduleValue.get("hours");
                            if (hoursArray != null && hoursArray instanceof NullNode == false) {
                                scheduleInstance.setHours(new ArrayList<Integer>());
                                for (JsonNode hoursValue : ((ArrayNode) hoursArray)) {
                                    scheduleInstance.getHours().add(hoursValue.getIntValue());
                                }
                            }
                            
                            JsonNode weekDaysArray = scheduleValue.get("weekDays");
                            if (weekDaysArray != null && weekDaysArray instanceof NullNode == false) {
                                scheduleInstance.setDays(new ArrayList<JobScheduleDay>());
                                for (JsonNode weekDaysValue : ((ArrayNode) weekDaysArray)) {
                                    scheduleInstance.getDays().add(SchedulerClientImpl.parseJobScheduleDay(weekDaysValue.getTextValue()));
                                }
                            }
                            
                            JsonNode monthsArray = scheduleValue.get("months");
                            if (monthsArray != null && monthsArray instanceof NullNode == false) {
                                scheduleInstance.setMonths(new ArrayList<Integer>());
                                for (JsonNode monthsValue : ((ArrayNode) monthsArray)) {
                                    scheduleInstance.getMonths().add(monthsValue.getIntValue());
                                }
                            }
                            
                            JsonNode monthDaysArray = scheduleValue.get("monthDays");
                            if (monthDaysArray != null && monthDaysArray instanceof NullNode == false) {
                                scheduleInstance.setMonthDays(new ArrayList<Integer>());
                                for (JsonNode monthDaysValue : ((ArrayNode) monthDaysArray)) {
                                    scheduleInstance.getMonthDays().add(monthDaysValue.getIntValue());
                                }
                            }
                            
                            JsonNode monthlyOccurrencesArray = scheduleValue.get("monthlyOccurrences");
                            if (monthlyOccurrencesArray != null && monthlyOccurrencesArray instanceof NullNode == false) {
                                scheduleInstance.setMonthlyOccurrences(new ArrayList<JobScheduleMonthlyOccurrence>());
                                for (JsonNode monthlyOccurrencesValue : ((ArrayNode) monthlyOccurrencesArray)) {
                                    JobScheduleMonthlyOccurrence jobScheduleMonthlyOccurrenceInstance = new JobScheduleMonthlyOccurrence();
                                    scheduleInstance.getMonthlyOccurrences().add(jobScheduleMonthlyOccurrenceInstance);
                                    
                                    JsonNode dayValue = monthlyOccurrencesValue.get("day");
                                    if (dayValue != null && dayValue instanceof NullNode == false) {
                                        JobScheduleDay dayInstance;
                                        dayInstance = SchedulerClientImpl.parseJobScheduleDay(dayValue.getTextValue());
                                        jobScheduleMonthlyOccurrenceInstance.setDay(dayInstance);
                                    }
                                    
                                    JsonNode occurrenceValue = monthlyOccurrencesValue.get("occurrence");
                                    if (occurrenceValue != null && occurrenceValue instanceof NullNode == false) {
                                        int occurrenceInstance;
                                        occurrenceInstance = occurrenceValue.getIntValue();
                                        jobScheduleMonthlyOccurrenceInstance.setOccurrence(occurrenceInstance);
                                    }
                                }
                            }
                        }
                    }
                    
                    JsonNode statusValue = responseDoc.get("status");
                    if (statusValue != null && statusValue instanceof NullNode == false) {
                        JobStatus statusInstance = new JobStatus();
                        jobInstance.setStatus(statusInstance);
                        
                        JsonNode lastExecutionTimeValue = statusValue.get("lastExecutionTime");
                        if (lastExecutionTimeValue != null && lastExecutionTimeValue instanceof NullNode == false) {
                            Calendar lastExecutionTimeInstance;
                            lastExecutionTimeInstance = DatatypeConverter.parseDateTime(lastExecutionTimeValue.getTextValue());
                            statusInstance.setLastExecutionTime(lastExecutionTimeInstance);
                        }
                        
                        JsonNode nextExecutionTimeValue = statusValue.get("nextExecutionTime");
                        if (nextExecutionTimeValue != null && nextExecutionTimeValue instanceof NullNode == false) {
                            Calendar nextExecutionTimeInstance;
                            nextExecutionTimeInstance = DatatypeConverter.parseDateTime(nextExecutionTimeValue.getTextValue());
                            statusInstance.setNextExecutionTime(nextExecutionTimeInstance);
                        }
                        
                        JsonNode executionCountValue = statusValue.get("executionCount");
                        if (executionCountValue != null && executionCountValue instanceof NullNode == false) {
                            int executionCountInstance;
                            executionCountInstance = executionCountValue.getIntValue();
                            statusInstance.setExecutionCount(executionCountInstance);
                        }
                        
                        JsonNode failureCountValue = statusValue.get("failureCount");
                        if (failureCountValue != null && failureCountValue instanceof NullNode == false) {
                            int failureCountInstance;
                            failureCountInstance = failureCountValue.getIntValue();
                            statusInstance.setFailureCount(failureCountInstance);
                        }
                        
                        JsonNode faultedCountValue = statusValue.get("faultedCount");
                        if (faultedCountValue != null && faultedCountValue instanceof NullNode == false) {
                            int faultedCountInstance;
                            faultedCountInstance = faultedCountValue.getIntValue();
                            statusInstance.setFaultedCount(faultedCountInstance);
                        }
                    }
                    
                    JsonNode stateValue = responseDoc.get("state");
                    if (stateValue != null && stateValue instanceof NullNode == false) {
                        JobState stateInstance;
                        stateInstance = SchedulerClientImpl.parseJobState(stateValue.getTextValue());
                        jobInstance.setState(stateInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
