/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.scheduler.models;

/**
* Basic authentication for job
*/
public class BasicAuthentication extends HttpAuthentication {
    private String password;
    
    /**
    * Optional. Gets or sets the password.
    * @return The Password value.
    */
    public String getPassword() {
        return this.password;
    }
    
    /**
    * Optional. Gets or sets the password.
    * @param passwordValue The Password value.
    */
    public void setPassword(final String passwordValue) {
        this.password = passwordValue;
    }
    
    private String username;
    
    /**
    * Required. Gets or sets the username.
    * @return The Username value.
    */
    public String getUsername() {
        return this.username;
    }
    
    /**
    * Required. Gets or sets the username.
    * @param usernameValue The Username value.
    */
    public void setUsername(final String usernameValue) {
        this.username = usernameValue;
    }
    
    /**
    * Initializes a new instance of the BasicAuthentication class.
    *
    */
    public BasicAuthentication() {
        super();
    }
    
    /**
    * Initializes a new instance of the BasicAuthentication class with required
    * arguments.
    *
    * @param username Gets or sets the username.
    */
    public BasicAuthentication(String username) {
        if (username == null) {
            throw new NullPointerException("username");
        }
        this.setUsername(username);
    }
}
