/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.scheduler.models;

import java.util.Calendar;

/**
* Client certification authentication for job
*/
public class ClientCertAuthentication extends HttpAuthentication {
    private Calendar certificateExpiration;
    
    /**
    * Optional. Gets or sets the certificate expiration.
    * @return The CertificateExpiration value.
    */
    public Calendar getCertificateExpiration() {
        return this.certificateExpiration;
    }
    
    /**
    * Optional. Gets or sets the certificate expiration.
    * @param certificateExpirationValue The CertificateExpiration value.
    */
    public void setCertificateExpiration(final Calendar certificateExpirationValue) {
        this.certificateExpiration = certificateExpirationValue;
    }
    
    private String certificateSubjectName;
    
    /**
    * Optional. Gets or sets the certificate subjectname.
    * @return The CertificateSubjectName value.
    */
    public String getCertificateSubjectName() {
        return this.certificateSubjectName;
    }
    
    /**
    * Optional. Gets or sets the certificate subjectname.
    * @param certificateSubjectNameValue The CertificateSubjectName value.
    */
    public void setCertificateSubjectName(final String certificateSubjectNameValue) {
        this.certificateSubjectName = certificateSubjectNameValue;
    }
    
    private String certificateThumbprint;
    
    /**
    * Optional. Gets or sets the certificate thumbprint.
    * @return The CertificateThumbprint value.
    */
    public String getCertificateThumbprint() {
        return this.certificateThumbprint;
    }
    
    /**
    * Optional. Gets or sets the certificate thumbprint.
    * @param certificateThumbprintValue The CertificateThumbprint value.
    */
    public void setCertificateThumbprint(final String certificateThumbprintValue) {
        this.certificateThumbprint = certificateThumbprintValue;
    }
    
    private String password;
    
    /**
    * Optional. Gets or sets the password.
    * @return The Password value.
    */
    public String getPassword() {
        return this.password;
    }
    
    /**
    * Optional. Gets or sets the password.
    * @param passwordValue The Password value.
    */
    public void setPassword(final String passwordValue) {
        this.password = passwordValue;
    }
    
    private String pfx;
    
    /**
    * Optional. Gets or sets the pfx.
    * @return The Pfx value.
    */
    public String getPfx() {
        return this.pfx;
    }
    
    /**
    * Optional. Gets or sets the pfx.
    * @param pfxValue The Pfx value.
    */
    public void setPfx(final String pfxValue) {
        this.pfx = pfxValue;
    }
}
