/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.scheduler.models;

import java.util.Calendar;

/**
* The definition of a Windows Azure Scheduler job.
*/
public class Job {
    private JobAction action;
    
    /**
    * Required. Action to invoke for the job.
    * @return The Action value.
    */
    public JobAction getAction() {
        return this.action;
    }
    
    /**
    * Required. Action to invoke for the job.
    * @param actionValue The Action value.
    */
    public void setAction(final JobAction actionValue) {
        this.action = actionValue;
    }
    
    private String id;
    
    /**
    * Required. Job identifier.
    * @return The Id value.
    */
    public String getId() {
        return this.id;
    }
    
    /**
    * Required. Job identifier.
    * @param idValue The Id value.
    */
    public void setId(final String idValue) {
        this.id = idValue;
    }
    
    private JobRecurrence recurrence;
    
    /**
    * Optional. Recurrence schedule for the job.
    * @return The Recurrence value.
    */
    public JobRecurrence getRecurrence() {
        return this.recurrence;
    }
    
    /**
    * Optional. Recurrence schedule for the job.
    * @param recurrenceValue The Recurrence value.
    */
    public void setRecurrence(final JobRecurrence recurrenceValue) {
        this.recurrence = recurrenceValue;
    }
    
    private Calendar startTime;
    
    /**
    * Optional. Start time for the job.  Defined as ISO-8601.
    * @return The StartTime value.
    */
    public Calendar getStartTime() {
        return this.startTime;
    }
    
    /**
    * Optional. Start time for the job.  Defined as ISO-8601.
    * @param startTimeValue The StartTime value.
    */
    public void setStartTime(final Calendar startTimeValue) {
        this.startTime = startTimeValue;
    }
    
    private JobState state;
    
    /**
    * Optional. Current state of the job.
    * @return The State value.
    */
    public JobState getState() {
        return this.state;
    }
    
    /**
    * Optional. Current state of the job.
    * @param stateValue The State value.
    */
    public void setState(final JobState stateValue) {
        this.state = stateValue;
    }
    
    private JobStatus status;
    
    /**
    * Optional. Current status of the job.
    * @return The Status value.
    */
    public JobStatus getStatus() {
        return this.status;
    }
    
    /**
    * Optional. Current status of the job.
    * @param statusValue The Status value.
    */
    public void setStatus(final JobStatus statusValue) {
        this.status = statusValue;
    }
    
    /**
    * Initializes a new instance of the Job class.
    *
    */
    public Job() {
    }
    
    /**
    * Initializes a new instance of the Job class with required arguments.
    *
    * @param id Job identifier.
    * @param action Action to invoke for the job.
    */
    public Job(String id, JobAction action) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (action == null) {
            throw new NullPointerException("action");
        }
        this.setId(id);
        this.setAction(action);
    }
}
