/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.scheduler.models;

/**
* Action to invoke for the job.
*/
public class JobAction {
    private JobErrorAction errorAction;
    
    /**
    * Optional. Error Action for the job.
    * @return The ErrorAction value.
    */
    public JobErrorAction getErrorAction() {
        return this.errorAction;
    }
    
    /**
    * Optional. Error Action for the job.
    * @param errorActionValue The ErrorAction value.
    */
    public void setErrorAction(final JobErrorAction errorActionValue) {
        this.errorAction = errorActionValue;
    }
    
    private JobQueueMessage queueMessage;
    
    /**
    * Optional. Queue and content for a queue message action type.
    * @return The QueueMessage value.
    */
    public JobQueueMessage getQueueMessage() {
        return this.queueMessage;
    }
    
    /**
    * Optional. Queue and content for a queue message action type.
    * @param queueMessageValue The QueueMessage value.
    */
    public void setQueueMessage(final JobQueueMessage queueMessageValue) {
        this.queueMessage = queueMessageValue;
    }
    
    private JobHttpRequest request;
    
    /**
    * Optional. Request for a http or https action type.
    * @return The Request value.
    */
    public JobHttpRequest getRequest() {
        return this.request;
    }
    
    /**
    * Optional. Request for a http or https action type.
    * @param requestValue The Request value.
    */
    public void setRequest(final JobHttpRequest requestValue) {
        this.request = requestValue;
    }
    
    private RetryPolicy retryPolicy;
    
    /**
    * Optional. Retry Policy for the job action.
    * @return The RetryPolicy value.
    */
    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }
    
    /**
    * Optional. Retry Policy for the job action.
    * @param retryPolicyValue The RetryPolicy value.
    */
    public void setRetryPolicy(final RetryPolicy retryPolicyValue) {
        this.retryPolicy = retryPolicyValue;
    }
    
    private JobServiceBusQueueMessage serviceBusQueueMessage;
    
    /**
    * Optional. Queue and content for a service bus topic message action type.
    * @return The ServiceBusQueueMessage value.
    */
    public JobServiceBusQueueMessage getServiceBusQueueMessage() {
        return this.serviceBusQueueMessage;
    }
    
    /**
    * Optional. Queue and content for a service bus topic message action type.
    * @param serviceBusQueueMessageValue The ServiceBusQueueMessage value.
    */
    public void setServiceBusQueueMessage(final JobServiceBusQueueMessage serviceBusQueueMessageValue) {
        this.serviceBusQueueMessage = serviceBusQueueMessageValue;
    }
    
    private JobServiceBusTopicMessage serviceBusTopicMessage;
    
    /**
    * Optional. Topic and content for a service bus topic message action type.
    * @return The ServiceBusTopicMessage value.
    */
    public JobServiceBusTopicMessage getServiceBusTopicMessage() {
        return this.serviceBusTopicMessage;
    }
    
    /**
    * Optional. Topic and content for a service bus topic message action type.
    * @param serviceBusTopicMessageValue The ServiceBusTopicMessage value.
    */
    public void setServiceBusTopicMessage(final JobServiceBusTopicMessage serviceBusTopicMessageValue) {
        this.serviceBusTopicMessage = serviceBusTopicMessageValue;
    }
    
    private JobActionType type;
    
    /**
    * Required. Type of action. Can be one of http, https, storageQueue.
    * @return The Type value.
    */
    public JobActionType getType() {
        return this.type;
    }
    
    /**
    * Required. Type of action. Can be one of http, https, storageQueue.
    * @param typeValue The Type value.
    */
    public void setType(final JobActionType typeValue) {
        this.type = typeValue;
    }
    
    /**
    * Initializes a new instance of the JobAction class.
    *
    */
    public JobAction() {
    }
    
    /**
    * Initializes a new instance of the JobAction class with required arguments.
    *
    * @param type Type of action. Can be one of http, https, storageQueue.
    */
    public JobAction(JobActionType type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.setType(type);
    }
}
