/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.scheduler.models;

import java.util.Calendar;

/**
* Parameters specifying the job definition for a CreateOrUpdate Job operation.
*/
public class JobCreateOrUpdateParameters {
    private JobAction action;
    
    /**
    * Required. Action to invoke for the job.
    * @return The Action value.
    */
    public JobAction getAction() {
        return this.action;
    }
    
    /**
    * Required. Action to invoke for the job.
    * @param actionValue The Action value.
    */
    public void setAction(final JobAction actionValue) {
        this.action = actionValue;
    }
    
    private JobRecurrence recurrence;
    
    /**
    * Optional. Recurrence schedule for the job.
    * @return The Recurrence value.
    */
    public JobRecurrence getRecurrence() {
        return this.recurrence;
    }
    
    /**
    * Optional. Recurrence schedule for the job.
    * @param recurrenceValue The Recurrence value.
    */
    public void setRecurrence(final JobRecurrence recurrenceValue) {
        this.recurrence = recurrenceValue;
    }
    
    private Calendar startTime;
    
    /**
    * Optional. Start time for the job. Defined as ISO-8601.
    * @return The StartTime value.
    */
    public Calendar getStartTime() {
        return this.startTime;
    }
    
    /**
    * Optional. Start time for the job. Defined as ISO-8601.
    * @param startTimeValue The StartTime value.
    */
    public void setStartTime(final Calendar startTimeValue) {
        this.startTime = startTimeValue;
    }
    
    /**
    * Initializes a new instance of the JobCreateOrUpdateParameters class.
    *
    */
    public JobCreateOrUpdateParameters() {
    }
    
    /**
    * Initializes a new instance of the JobCreateOrUpdateParameters class with
    * required arguments.
    *
    * @param action Action to invoke for the job.
    */
    public JobCreateOrUpdateParameters(JobAction action) {
        if (action == null) {
            throw new NullPointerException("action");
        }
        this.setAction(action);
    }
}
