/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.scheduler.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Iterator;

/**
* The List Jobs operation response.
*/
public class JobListResponse extends OperationResponse implements Iterable<Job> {
    private ArrayList<Job> jobs;
    
    /**
    * Optional. The relevant jobs.
    * @return The Jobs value.
    */
    public ArrayList<Job> getJobs() {
        return this.jobs;
    }
    
    /**
    * Optional. The relevant jobs.
    * @param jobsValue The Jobs value.
    */
    public void setJobs(final ArrayList<Job> jobsValue) {
        this.jobs = jobsValue;
    }
    
    /**
    * Initializes a new instance of the JobListResponse class.
    *
    */
    public JobListResponse() {
        super();
        this.setJobs(new LazyArrayList<Job>());
    }
    
    /**
    * Gets the sequence of Jobs.
    *
    */
    public Iterator<Job> iterator() {
        return this.getJobs().iterator();
    }
}
