/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.scheduler.models;

/**
* Parameters supplied to the List Jobs with filter operation.
*/
public class JobListWithFilterParameters extends JobListParameters {
    private JobState state;
    
    /**
    * Required. Filter the job history to have it only return job execution
    * attempts having a particular State, enabled, disabled, faulted, or
    * completed.
    * @return The State value.
    */
    public JobState getState() {
        return this.state;
    }
    
    /**
    * Required. Filter the job history to have it only return job execution
    * attempts having a particular State, enabled, disabled, faulted, or
    * completed.
    * @param stateValue The State value.
    */
    public void setState(final JobState stateValue) {
        this.state = stateValue;
    }
    
    /**
    * Initializes a new instance of the JobListWithFilterParameters class.
    *
    */
    public JobListWithFilterParameters() {
        super();
    }
    
    /**
    * Initializes a new instance of the JobListWithFilterParameters class with
    * required arguments.
    *
    * @param state Filter the job history to have it only return job execution
    * attempts having a particular State, enabled, disabled, faulted, or
    * completed.
    */
    public JobListWithFilterParameters(JobState state) {
        if (state == null) {
            throw new NullPointerException("state");
        }
        this.setState(state);
    }
}
