/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.scheduler.models;

/**
* Queue and content for a queue message action type.
*/
public class JobQueueMessage {
    private String message;
    
    /**
    * Required. Content of the message to send to the queue.
    * @return The Message value.
    */
    public String getMessage() {
        return this.message;
    }
    
    /**
    * Required. Content of the message to send to the queue.
    * @param messageValue The Message value.
    */
    public void setMessage(final String messageValue) {
        this.message = messageValue;
    }
    
    private String queueName;
    
    /**
    * Required. Name of the queue to send to.
    * @return The QueueName value.
    */
    public String getQueueName() {
        return this.queueName;
    }
    
    /**
    * Required. Name of the queue to send to.
    * @param queueNameValue The QueueName value.
    */
    public void setQueueName(final String queueNameValue) {
        this.queueName = queueNameValue;
    }
    
    private String sasToken;
    
    /**
    * Required. SAS key for the storage account to send message to the queue.
    * @return The SasToken value.
    */
    public String getSasToken() {
        return this.sasToken;
    }
    
    /**
    * Required. SAS key for the storage account to send message to the queue.
    * @param sasTokenValue The SasToken value.
    */
    public void setSasToken(final String sasTokenValue) {
        this.sasToken = sasTokenValue;
    }
    
    private String storageAccountName;
    
    /**
    * Required. Name of the storage account for the queue.
    * @return The StorageAccountName value.
    */
    public String getStorageAccountName() {
        return this.storageAccountName;
    }
    
    /**
    * Required. Name of the storage account for the queue.
    * @param storageAccountNameValue The StorageAccountName value.
    */
    public void setStorageAccountName(final String storageAccountNameValue) {
        this.storageAccountName = storageAccountNameValue;
    }
}
