/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.scheduler.models;

import java.util.Calendar;

/**
* Recurrence schedule for the job.
*/
public class JobRecurrence {
    private Integer count;
    
    /**
    * Optional. Count of occurrences that will execute. Optional. Default will
    * recur infinitely
    * @return The Count value.
    */
    public Integer getCount() {
        return this.count;
    }
    
    /**
    * Optional. Count of occurrences that will execute. Optional. Default will
    * recur infinitely
    * @param countValue The Count value.
    */
    public void setCount(final Integer countValue) {
        this.count = countValue;
    }
    
    private Calendar endTime;
    
    /**
    * Optional. Time in ISO-8601 format after which no more occurrences will
    * execute.
    * @return The EndTime value.
    */
    public Calendar getEndTime() {
        return this.endTime;
    }
    
    /**
    * Optional. Time in ISO-8601 format after which no more occurrences will
    * execute.
    * @param endTimeValue The EndTime value.
    */
    public void setEndTime(final Calendar endTimeValue) {
        this.endTime = endTimeValue;
    }
    
    private JobRecurrenceFrequency frequency;
    
    /**
    * Required. The frequency of recurrence.
    * @return The Frequency value.
    */
    public JobRecurrenceFrequency getFrequency() {
        return this.frequency;
    }
    
    /**
    * Required. The frequency of recurrence.
    * @param frequencyValue The Frequency value.
    */
    public void setFrequency(final JobRecurrenceFrequency frequencyValue) {
        this.frequency = frequencyValue;
    }
    
    private Integer interval;
    
    /**
    * Optional. Interval of the recurrence at the given frequency.
    * @return The Interval value.
    */
    public Integer getInterval() {
        return this.interval;
    }
    
    /**
    * Optional. Interval of the recurrence at the given frequency.
    * @param intervalValue The Interval value.
    */
    public void setInterval(final Integer intervalValue) {
        this.interval = intervalValue;
    }
    
    private JobRecurrenceSchedule schedule;
    
    /**
    * Optional. Recurrence schedule for the job.
    * @return The Schedule value.
    */
    public JobRecurrenceSchedule getSchedule() {
        return this.schedule;
    }
    
    /**
    * Optional. Recurrence schedule for the job.
    * @param scheduleValue The Schedule value.
    */
    public void setSchedule(final JobRecurrenceSchedule scheduleValue) {
        this.schedule = scheduleValue;
    }
    
    /**
    * Initializes a new instance of the JobRecurrence class.
    *
    */
    public JobRecurrence() {
    }
    
    /**
    * Initializes a new instance of the JobRecurrence class with required
    * arguments.
    *
    * @param frequency The frequency of recurrence.
    */
    public JobRecurrence(JobRecurrenceFrequency frequency) {
        if (frequency == null) {
            throw new NullPointerException("frequency");
        }
        this.setFrequency(frequency);
    }
}
