/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.scheduler.models;

import com.microsoft.windowsazure.core.LazyHashMap;

import java.util.HashMap;

/**
* Specifies service bus message for the base service bus action type
*/
public abstract class JobServiceBusMessage {
    private JobServiceBusAuthentication authentication;
    
    /**
    * Required. Gets or sets the service bus authentication.
    * @return The Authentication value.
    */
    public JobServiceBusAuthentication getAuthentication() {
        return this.authentication;
    }
    
    /**
    * Required. Gets or sets the service bus authentication.
    * @param authenticationValue The Authentication value.
    */
    public void setAuthentication(final JobServiceBusAuthentication authenticationValue) {
        this.authentication = authenticationValue;
    }
    
    private JobServiceBusBrokeredMessageProperties brokeredMessageProperties;
    
    /**
    * Optional. Gets or sets the service bus brokered message properties.
    * @return The BrokeredMessageProperties value.
    */
    public JobServiceBusBrokeredMessageProperties getBrokeredMessageProperties() {
        return this.brokeredMessageProperties;
    }
    
    /**
    * Optional. Gets or sets the service bus brokered message properties.
    * @param brokeredMessagePropertiesValue The BrokeredMessageProperties value.
    */
    public void setBrokeredMessageProperties(final JobServiceBusBrokeredMessageProperties brokeredMessagePropertiesValue) {
        this.brokeredMessageProperties = brokeredMessagePropertiesValue;
    }
    
    private HashMap<String, String> customMessageProperties;
    
    /**
    * Optional. Gets or sets the custom message properties.
    * @return The CustomMessageProperties value.
    */
    public HashMap<String, String> getCustomMessageProperties() {
        return this.customMessageProperties;
    }
    
    /**
    * Optional. Gets or sets the custom message properties.
    * @param customMessagePropertiesValue The CustomMessageProperties value.
    */
    public void setCustomMessageProperties(final HashMap<String, String> customMessagePropertiesValue) {
        this.customMessageProperties = customMessagePropertiesValue;
    }
    
    private String message;
    
    /**
    * Required. Gets or sets the service bus message.
    * @return The Message value.
    */
    public String getMessage() {
        return this.message;
    }
    
    /**
    * Required. Gets or sets the service bus message.
    * @param messageValue The Message value.
    */
    public void setMessage(final String messageValue) {
        this.message = messageValue;
    }
    
    private String namespace;
    
    /**
    * Required. Gets or sets the service bus namespace.
    * @return The Namespace value.
    */
    public String getNamespace() {
        return this.namespace;
    }
    
    /**
    * Required. Gets or sets the service bus namespace.
    * @param namespaceValue The Namespace value.
    */
    public void setNamespace(final String namespaceValue) {
        this.namespace = namespaceValue;
    }
    
    private JobServiceBusTransportType transportType;
    
    /**
    * Required. Gets or sets the service bus transport type.
    * @return The TransportType value.
    */
    public JobServiceBusTransportType getTransportType() {
        return this.transportType;
    }
    
    /**
    * Required. Gets or sets the service bus transport type.
    * @param transportTypeValue The TransportType value.
    */
    public void setTransportType(final JobServiceBusTransportType transportTypeValue) {
        this.transportType = transportTypeValue;
    }
    
    /**
    * Initializes a new instance of the JobServiceBusMessage class.
    *
    */
    public JobServiceBusMessage() {
        this.setCustomMessageProperties(new LazyHashMap<String, String>());
    }
}
