/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.scheduler.models;

import java.util.Calendar;

/**
* Current status of the job.
*/
public class JobStatus {
    private int executionCount;
    
    /**
    * Required. Number of times this job has executed.
    * @return The ExecutionCount value.
    */
    public int getExecutionCount() {
        return this.executionCount;
    }
    
    /**
    * Required. Number of times this job has executed.
    * @param executionCountValue The ExecutionCount value.
    */
    public void setExecutionCount(final int executionCountValue) {
        this.executionCount = executionCountValue;
    }
    
    private int failureCount;
    
    /**
    * Optional. Number of times this job has failed.
    * @return The FailureCount value.
    */
    public int getFailureCount() {
        return this.failureCount;
    }
    
    /**
    * Optional. Number of times this job has failed.
    * @param failureCountValue The FailureCount value.
    */
    public void setFailureCount(final int failureCountValue) {
        this.failureCount = failureCountValue;
    }
    
    private int faultedCount;
    
    /**
    * Optional. Number of faulted occurrences (occurrences that were retried
    * and failed as many times as the retry policy states).
    * @return The FaultedCount value.
    */
    public int getFaultedCount() {
        return this.faultedCount;
    }
    
    /**
    * Optional. Number of faulted occurrences (occurrences that were retried
    * and failed as many times as the retry policy states).
    * @param faultedCountValue The FaultedCount value.
    */
    public void setFaultedCount(final int faultedCountValue) {
        this.faultedCount = faultedCountValue;
    }
    
    private Calendar lastExecutionTime;
    
    /**
    * Optional. Time the last occurrence executed in ISO-8601 format. Could be
    * empty if job has not run yet.
    * @return The LastExecutionTime value.
    */
    public Calendar getLastExecutionTime() {
        return this.lastExecutionTime;
    }
    
    /**
    * Optional. Time the last occurrence executed in ISO-8601 format. Could be
    * empty if job has not run yet.
    * @param lastExecutionTimeValue The LastExecutionTime value.
    */
    public void setLastExecutionTime(final Calendar lastExecutionTimeValue) {
        this.lastExecutionTime = lastExecutionTimeValue;
    }
    
    private Calendar nextExecutionTime;
    
    /**
    * Optional. Time of the next occurrence in ISO-8601 format. Could be empty
    * if the job is completed.
    * @return The NextExecutionTime value.
    */
    public Calendar getNextExecutionTime() {
        return this.nextExecutionTime;
    }
    
    /**
    * Optional. Time of the next occurrence in ISO-8601 format. Could be empty
    * if the job is completed.
    * @param nextExecutionTimeValue The NextExecutionTime value.
    */
    public void setNextExecutionTime(final Calendar nextExecutionTimeValue) {
        this.nextExecutionTime = nextExecutionTimeValue;
    }
    
    /**
    * Initializes a new instance of the JobStatus class.
    *
    */
    public JobStatus() {
    }
    
    /**
    * Initializes a new instance of the JobStatus class with required arguments.
    *
    * @param executionCount Number of times this job has executed.
    */
    public JobStatus(int executionCount) {
        this.setExecutionCount(executionCount);
    }
}
