/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.scheduler.models;

import javax.xml.datatype.Duration;

/**
* Retry Policy for the job action.
*/
public class RetryPolicy {
    private Integer retryCount;
    
    /**
    * Optional. Number of times a retry should be attempted.
    * @return The RetryCount value.
    */
    public Integer getRetryCount() {
        return this.retryCount;
    }
    
    /**
    * Optional. Number of times a retry should be attempted.
    * @param retryCountValue The RetryCount value.
    */
    public void setRetryCount(final Integer retryCountValue) {
        this.retryCount = retryCountValue;
    }
    
    private Duration retryInterval;
    
    /**
    * Optional. The interval between retries.
    * @return The RetryInterval value.
    */
    public Duration getRetryInterval() {
        return this.retryInterval;
    }
    
    /**
    * Optional. The interval between retries.
    * @param retryIntervalValue The RetryInterval value.
    */
    public void setRetryInterval(final Duration retryIntervalValue) {
        this.retryInterval = retryIntervalValue;
    }
    
    private RetryType retryType;
    
    /**
    * Required.  The Retry Type of the Retry Policy. Can be either 'fixed' or
    * 'none'.
    * @return The RetryType value.
    */
    public RetryType getRetryType() {
        return this.retryType;
    }
    
    /**
    * Required.  The Retry Type of the Retry Policy. Can be either 'fixed' or
    * 'none'.
    * @param retryTypeValue The RetryType value.
    */
    public void setRetryType(final RetryType retryTypeValue) {
        this.retryType = retryTypeValue;
    }
    
    /**
    * Initializes a new instance of the RetryPolicy class.
    *
    */
    public RetryPolicy() {
    }
    
    /**
    * Initializes a new instance of the RetryPolicy class with required
    * arguments.
    *
    * @param retryType  The Retry Type of the Retry Policy. Can be either
    * 'fixed' or 'none'.
    */
    public RetryPolicy(RetryType retryType) {
        if (retryType == null) {
            throw new NullPointerException("retryType");
        }
        this.setRetryType(retryType);
    }
}
