/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.servicebus;

import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.servicebus.models.AccessRight;
import com.microsoft.windowsazure.management.servicebus.models.CheckNamespaceAvailabilityResponse;
import com.microsoft.windowsazure.management.servicebus.models.NamespaceDescription;
import com.microsoft.windowsazure.management.servicebus.models.NamespaceType;
import com.microsoft.windowsazure.management.servicebus.models.ServiceBusAuthorizationRuleResponse;
import com.microsoft.windowsazure.management.servicebus.models.ServiceBusAuthorizationRulesResponse;
import com.microsoft.windowsazure.management.servicebus.models.ServiceBusNamespace;
import com.microsoft.windowsazure.management.servicebus.models.ServiceBusNamespaceCreateParameters;
import com.microsoft.windowsazure.management.servicebus.models.ServiceBusNamespaceDescriptionResponse;
import com.microsoft.windowsazure.management.servicebus.models.ServiceBusNamespaceResponse;
import com.microsoft.windowsazure.management.servicebus.models.ServiceBusNamespacesResponse;
import com.microsoft.windowsazure.management.servicebus.models.ServiceBusSharedAccessAuthorizationRule;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
* The Service Bus Management API includes operations for managing Service Bus
* namespaces.
*/
public class NamespaceOperationsImpl implements ServiceOperations<ServiceBusManagementClientImpl>, NamespaceOperations {
    /**
    * Initializes a new instance of the NamespaceOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    NamespaceOperationsImpl(ServiceBusManagementClientImpl client) {
        this.client = client;
    }
    
    private ServiceBusManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.windowsazure.management.servicebus.ServiceBusManagementClientImpl.
    * @return The Client value.
    */
    public ServiceBusManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Checks the availability of the given service namespace across all Windows
    * Azure subscriptions. This is useful because the domain name is created
    * based on the service namespace name.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj870968.aspx for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @return The response to a query for the availability status of a
    * namespace name.
    */
    @Override
    public Future<CheckNamespaceAvailabilityResponse> checkAvailabilityAsync(final String namespaceName) {
        return this.getClient().getExecutorService().submit(new Callable<CheckNamespaceAvailabilityResponse>() { 
            @Override
            public CheckNamespaceAvailabilityResponse call() throws Exception {
                return checkAvailability(namespaceName);
            }
         });
    }
    
    /**
    * Checks the availability of the given service namespace across all Windows
    * Azure subscriptions. This is useful because the domain name is created
    * based on the service namespace name.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj870968.aspx for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response to a query for the availability status of a
    * namespace name.
    */
    @Override
    public CheckNamespaceAvailabilityResponse checkAvailability(String namespaceName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("namespaceName", namespaceName);
            CloudTracing.enter(invocationId, this, "checkAvailabilityAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/ServiceBus/CheckNamespaceAvailability";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("namespace=" + URLEncoder.encode(namespaceName, "UTF-8"));
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Accept", "application/atom+xml");
        httpRequest.setHeader("Content-Type", "application/atom+xml");
        httpRequest.setHeader("x-ms-version", "2013-06-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            CheckNamespaceAvailabilityResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new CheckNamespaceAvailabilityResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element entryElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://www.w3.org/2005/Atom", "entry");
                if (entryElement != null) {
                    Element contentElement = XmlUtility.getElementByTagNameNS(entryElement, "http://www.w3.org/2005/Atom", "content");
                    if (contentElement != null) {
                        Element namespaceAvailabilityElement = XmlUtility.getElementByTagNameNS(contentElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "NamespaceAvailability");
                        if (namespaceAvailabilityElement != null) {
                            Element resultElement = XmlUtility.getElementByTagNameNS(namespaceAvailabilityElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Result");
                            if (resultElement != null) {
                                boolean resultInstance;
                                resultInstance = DatatypeConverter.parseBoolean(resultElement.getTextContent().toLowerCase());
                                result.setIsAvailable(resultInstance);
                            }
                            
                            Element reasonDetailElement = XmlUtility.getElementByTagNameNS(namespaceAvailabilityElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ReasonDetail");
                            if (reasonDetailElement != null) {
                                String reasonDetailInstance;
                                reasonDetailInstance = reasonDetailElement.getTextContent();
                                result.setReasonDetails(reasonDetailInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Creates a new service namespace. Once created, this namespace's resource
    * manifest is immutable. This operation is idempotent.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj856303.aspx for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @param region Optional. The namespace region.
    * @return The response to a request for a particular namespace.
    */
    @Override
    public Future<ServiceBusNamespaceResponse> createAsync(final String namespaceName, final String region) {
        return this.getClient().getExecutorService().submit(new Callable<ServiceBusNamespaceResponse>() { 
            @Override
            public ServiceBusNamespaceResponse call() throws Exception {
                return create(namespaceName, region);
            }
         });
    }
    
    /**
    * Creates a new service namespace. Once created, this namespace's resource
    * manifest is immutable. This operation is idempotent.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj856303.aspx for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @param region Optional. The namespace region.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The response to a request for a particular namespace.
    */
    @Override
    public ServiceBusNamespaceResponse create(String namespaceName, String region) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException, URISyntaxException {
        // Validate
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("region", region);
            CloudTracing.enter(invocationId, this, "createAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/servicebus/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Accept", "application/atom+xml");
        httpRequest.setHeader("Content-Type", "application/atom+xml");
        httpRequest.setHeader("type", "entry");
        httpRequest.setHeader("x-ms-version", "2013-07-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element entryElement = requestDoc.createElementNS("http://www.w3.org/2005/Atom", "entry");
        requestDoc.appendChild(entryElement);
        
        Element contentElement = requestDoc.createElementNS("http://www.w3.org/2005/Atom", "content");
        entryElement.appendChild(contentElement);
        
        Attr typeAttribute = requestDoc.createAttribute("type");
        typeAttribute.setValue("application/xml");
        contentElement.setAttributeNode(typeAttribute);
        
        Element namespaceDescriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "NamespaceDescription");
        contentElement.appendChild(namespaceDescriptionElement);
        
        if (region != null) {
            Element regionElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Region");
            regionElement.appendChild(requestDoc.createTextNode(region));
            namespaceDescriptionElement.appendChild(regionElement);
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/atom+xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ServiceBusNamespaceResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ServiceBusNamespaceResponse();
                DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
                documentBuilderFactory2.setNamespaceAware(true);
                DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
                Document responseDoc = documentBuilder2.parse(new BOMInputStream(responseContent));
                
                Element entryElement2 = XmlUtility.getElementByTagNameNS(responseDoc, "http://www.w3.org/2005/Atom", "entry");
                if (entryElement2 != null) {
                    Element contentElement2 = XmlUtility.getElementByTagNameNS(entryElement2, "http://www.w3.org/2005/Atom", "content");
                    if (contentElement2 != null) {
                        Element namespaceDescriptionElement2 = XmlUtility.getElementByTagNameNS(contentElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "NamespaceDescription");
                        if (namespaceDescriptionElement2 != null) {
                            ServiceBusNamespace namespaceDescriptionInstance = new ServiceBusNamespace();
                            result.setNamespace(namespaceDescriptionInstance);
                            
                            Element nameElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Name");
                            if (nameElement != null) {
                                String nameInstance;
                                nameInstance = nameElement.getTextContent();
                                namespaceDescriptionInstance.setName(nameInstance);
                            }
                            
                            Element regionElement2 = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Region");
                            if (regionElement2 != null) {
                                String regionInstance;
                                regionInstance = regionElement2.getTextContent();
                                namespaceDescriptionInstance.setRegion(regionInstance);
                            }
                            
                            Element statusElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Status");
                            if (statusElement != null) {
                                String statusInstance;
                                statusInstance = statusElement.getTextContent();
                                namespaceDescriptionInstance.setStatus(statusInstance);
                            }
                            
                            Element createdAtElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedAt");
                            if (createdAtElement != null) {
                                Calendar createdAtInstance;
                                createdAtInstance = DatatypeConverter.parseDateTime(createdAtElement.getTextContent());
                                namespaceDescriptionInstance.setCreatedAt(createdAtInstance);
                            }
                            
                            Element acsManagementEndpointElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AcsManagementEndpoint");
                            if (acsManagementEndpointElement != null) {
                                URI acsManagementEndpointInstance;
                                acsManagementEndpointInstance = new URI(acsManagementEndpointElement.getTextContent());
                                namespaceDescriptionInstance.setAcsManagementEndpoint(acsManagementEndpointInstance);
                            }
                            
                            Element serviceBusEndpointElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ServiceBusEndpoint");
                            if (serviceBusEndpointElement != null) {
                                URI serviceBusEndpointInstance;
                                serviceBusEndpointInstance = new URI(serviceBusEndpointElement.getTextContent());
                                namespaceDescriptionInstance.setServiceBusEndpoint(serviceBusEndpointInstance);
                            }
                            
                            Element subscriptionIdElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SubscriptionId");
                            if (subscriptionIdElement != null) {
                                String subscriptionIdInstance;
                                subscriptionIdInstance = subscriptionIdElement.getTextContent();
                                namespaceDescriptionInstance.setSubscriptionId(subscriptionIdInstance);
                            }
                            
                            Element enabledElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Enabled");
                            if (enabledElement != null) {
                                boolean enabledInstance;
                                enabledInstance = DatatypeConverter.parseBoolean(enabledElement.getTextContent().toLowerCase());
                                namespaceDescriptionInstance.setEnabled(enabledInstance);
                            }
                            
                            Element createACSNamespaceElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreateACSNamespace");
                            if (createACSNamespaceElement != null) {
                                boolean createACSNamespaceInstance;
                                createACSNamespaceInstance = DatatypeConverter.parseBoolean(createACSNamespaceElement.getTextContent().toLowerCase());
                                namespaceDescriptionInstance.setCreateACSNamespace(createACSNamespaceInstance);
                            }
                            
                            Element namespaceTypeElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "NamespaceType");
                            if (namespaceTypeElement != null && namespaceTypeElement.getTextContent() != null && !namespaceTypeElement.getTextContent().isEmpty()) {
                                NamespaceType namespaceTypeInstance;
                                namespaceTypeInstance = NamespaceType.valueOf(namespaceTypeElement.getTextContent());
                                namespaceDescriptionInstance.setNamespaceType(namespaceTypeInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The create namespace authorization rule operation creates an
    * authorization rule for a namespace
    *
    * @param namespaceName Required. The namespace name.
    * @param rule Required. The shared access authorization rule.
    * @return A response to a request for a particular authorization rule.
    */
    @Override
    public Future<ServiceBusAuthorizationRuleResponse> createAuthorizationRuleAsync(final String namespaceName, final ServiceBusSharedAccessAuthorizationRule rule) {
        return this.getClient().getExecutorService().submit(new Callable<ServiceBusAuthorizationRuleResponse>() { 
            @Override
            public ServiceBusAuthorizationRuleResponse call() throws Exception {
                return createAuthorizationRule(namespaceName, rule);
            }
         });
    }
    
    /**
    * The create namespace authorization rule operation creates an
    * authorization rule for a namespace
    *
    * @param namespaceName Required. The namespace name.
    * @param rule Required. The shared access authorization rule.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A response to a request for a particular authorization rule.
    */
    @Override
    public ServiceBusAuthorizationRuleResponse createAuthorizationRule(String namespaceName, ServiceBusSharedAccessAuthorizationRule rule) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (rule == null) {
            throw new NullPointerException("rule");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("rule", rule);
            CloudTracing.enter(invocationId, this, "createAuthorizationRuleAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/servicebus/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/AuthorizationRules";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Accept", "application/atom+xml");
        httpRequest.setHeader("Content-Type", "application/atom+xml");
        httpRequest.setHeader("type", "entry");
        httpRequest.setHeader("x-ms-version", "2013-08-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element entryElement = requestDoc.createElementNS("http://www.w3.org/2005/Atom", "entry");
        requestDoc.appendChild(entryElement);
        
        Element contentElement = requestDoc.createElementNS("http://www.w3.org/2005/Atom", "content");
        entryElement.appendChild(contentElement);
        
        Attr typeAttribute = requestDoc.createAttribute("type");
        typeAttribute.setValue("application/atom+xml");
        contentElement.setAttributeNode(typeAttribute);
        
        Element sharedAccessAuthorizationRuleElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SharedAccessAuthorizationRule");
        contentElement.appendChild(sharedAccessAuthorizationRuleElement);
        
        if (rule.getClaimType() != null) {
            Element claimTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimType");
            claimTypeElement.appendChild(requestDoc.createTextNode(rule.getClaimType()));
            sharedAccessAuthorizationRuleElement.appendChild(claimTypeElement);
        }
        
        if (rule.getClaimValue() != null) {
            Element claimValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimValue");
            claimValueElement.appendChild(requestDoc.createTextNode(rule.getClaimValue()));
            sharedAccessAuthorizationRuleElement.appendChild(claimValueElement);
        }
        
        if (rule.getRights() != null) {
            if (rule.getRights() instanceof LazyCollection == false || ((LazyCollection) rule.getRights()).isInitialized()) {
                Element rightsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Rights");
                for (AccessRight rightsItem : rule.getRights()) {
                    Element rightsItemElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights");
                    rightsItemElement.appendChild(requestDoc.createTextNode(rightsItem.toString()));
                    rightsSequenceElement.appendChild(rightsItemElement);
                }
                sharedAccessAuthorizationRuleElement.appendChild(rightsSequenceElement);
            }
        }
        
        Element createdTimeElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedTime");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        createdTimeElement.appendChild(requestDoc.createTextNode(simpleDateFormat.format(rule.getCreatedTime().getTime())));
        sharedAccessAuthorizationRuleElement.appendChild(createdTimeElement);
        
        Element modifiedTimeElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ModifiedTime");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
        modifiedTimeElement.appendChild(requestDoc.createTextNode(simpleDateFormat2.format(rule.getModifiedTime().getTime())));
        sharedAccessAuthorizationRuleElement.appendChild(modifiedTimeElement);
        
        Element revisionElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Revision");
        revisionElement.appendChild(requestDoc.createTextNode(Integer.toString(rule.getRevision())));
        sharedAccessAuthorizationRuleElement.appendChild(revisionElement);
        
        if (rule.getKeyName() != null) {
            Element keyNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "KeyName");
            keyNameElement.appendChild(requestDoc.createTextNode(rule.getKeyName()));
            sharedAccessAuthorizationRuleElement.appendChild(keyNameElement);
        }
        
        if (rule.getPrimaryKey() != null) {
            Element primaryKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "PrimaryKey");
            primaryKeyElement.appendChild(requestDoc.createTextNode(rule.getPrimaryKey()));
            sharedAccessAuthorizationRuleElement.appendChild(primaryKeyElement);
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/atom+xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ServiceBusAuthorizationRuleResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ServiceBusAuthorizationRuleResponse();
                DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
                documentBuilderFactory2.setNamespaceAware(true);
                DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
                Document responseDoc = documentBuilder2.parse(new BOMInputStream(responseContent));
                
                Element entryElement2 = XmlUtility.getElementByTagNameNS(responseDoc, "http://www.w3.org/2005/Atom", "entry");
                if (entryElement2 != null) {
                    Element contentElement2 = XmlUtility.getElementByTagNameNS(entryElement2, "http://www.w3.org/2005/Atom", "content");
                    if (contentElement2 != null) {
                        Element sharedAccessAuthorizationRuleElement2 = XmlUtility.getElementByTagNameNS(contentElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SharedAccessAuthorizationRule");
                        if (sharedAccessAuthorizationRuleElement2 != null) {
                            ServiceBusSharedAccessAuthorizationRule sharedAccessAuthorizationRuleInstance = new ServiceBusSharedAccessAuthorizationRule();
                            result.setAuthorizationRule(sharedAccessAuthorizationRuleInstance);
                            
                            Element claimTypeElement2 = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimType");
                            if (claimTypeElement2 != null) {
                                String claimTypeInstance;
                                claimTypeInstance = claimTypeElement2.getTextContent();
                                sharedAccessAuthorizationRuleInstance.setClaimType(claimTypeInstance);
                            }
                            
                            Element claimValueElement2 = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimValue");
                            if (claimValueElement2 != null) {
                                String claimValueInstance;
                                claimValueInstance = claimValueElement2.getTextContent();
                                sharedAccessAuthorizationRuleInstance.setClaimValue(claimValueInstance);
                            }
                            
                            Element rightsSequenceElement2 = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Rights");
                            if (rightsSequenceElement2 != null) {
                                for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").size(); i1 = i1 + 1) {
                                    org.w3c.dom.Element rightsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").get(i1));
                                    sharedAccessAuthorizationRuleInstance.getRights().add(AccessRight.valueOf(rightsElement.getTextContent()));
                                }
                            }
                            
                            Element createdTimeElement2 = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedTime");
                            if (createdTimeElement2 != null) {
                                Calendar createdTimeInstance;
                                createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeElement2.getTextContent());
                                sharedAccessAuthorizationRuleInstance.setCreatedTime(createdTimeInstance);
                            }
                            
                            Element modifiedTimeElement2 = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ModifiedTime");
                            if (modifiedTimeElement2 != null) {
                                Calendar modifiedTimeInstance;
                                modifiedTimeInstance = DatatypeConverter.parseDateTime(modifiedTimeElement2.getTextContent());
                                sharedAccessAuthorizationRuleInstance.setModifiedTime(modifiedTimeInstance);
                            }
                            
                            Element keyNameElement2 = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "KeyName");
                            if (keyNameElement2 != null) {
                                String keyNameInstance;
                                keyNameInstance = keyNameElement2.getTextContent();
                                sharedAccessAuthorizationRuleInstance.setKeyName(keyNameInstance);
                            }
                            
                            Element primaryKeyElement2 = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "PrimaryKey");
                            if (primaryKeyElement2 != null) {
                                String primaryKeyInstance;
                                primaryKeyInstance = primaryKeyElement2.getTextContent();
                                sharedAccessAuthorizationRuleInstance.setPrimaryKey(primaryKeyInstance);
                            }
                            
                            Element secondaryKeyElement = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SecondaryKey");
                            if (secondaryKeyElement != null) {
                                String secondaryKeyInstance;
                                secondaryKeyInstance = secondaryKeyElement.getTextContent();
                                sharedAccessAuthorizationRuleInstance.setSecondaryKey(secondaryKeyInstance);
                            }
                            
                            Element revisionElement2 = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Revision");
                            if (revisionElement2 != null) {
                                int revisionInstance;
                                revisionInstance = DatatypeConverter.parseInt(revisionElement2.getTextContent());
                                sharedAccessAuthorizationRuleInstance.setRevision(revisionInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Creates a new service namespace. Once created, this namespace's resource
    * manifest is immutable. This operation is idempotent.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj856303.aspx for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @param namespaceEntity Required. The service bus namespace.
    * @return The response to a request for a particular namespace.
    */
    @Override
    public Future<ServiceBusNamespaceResponse> createNamespaceAsync(final String namespaceName, final ServiceBusNamespaceCreateParameters namespaceEntity) {
        return this.getClient().getExecutorService().submit(new Callable<ServiceBusNamespaceResponse>() { 
            @Override
            public ServiceBusNamespaceResponse call() throws Exception {
                return createNamespace(namespaceName, namespaceEntity);
            }
         });
    }
    
    /**
    * Creates a new service namespace. Once created, this namespace's resource
    * manifest is immutable. This operation is idempotent.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj856303.aspx for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @param namespaceEntity Required. The service bus namespace.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The response to a request for a particular namespace.
    */
    @Override
    public ServiceBusNamespaceResponse createNamespace(String namespaceName, ServiceBusNamespaceCreateParameters namespaceEntity) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException, URISyntaxException {
        // Validate
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (namespaceEntity == null) {
            throw new NullPointerException("namespaceEntity");
        }
        if (namespaceEntity.getNamespaceType() == null) {
            throw new NullPointerException("namespaceEntity.NamespaceType");
        }
        if (namespaceEntity.getRegion() == null) {
            throw new NullPointerException("namespaceEntity.Region");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("namespaceEntity", namespaceEntity);
            CloudTracing.enter(invocationId, this, "createNamespaceAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/servicebus/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Accept", "application/atom+xml");
        httpRequest.setHeader("Content-Type", "application/atom+xml");
        httpRequest.setHeader("type", "entry");
        httpRequest.setHeader("x-ms-version", "2014-06-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element entryElement = requestDoc.createElementNS("http://www.w3.org/2005/Atom", "entry");
        requestDoc.appendChild(entryElement);
        
        Element contentElement = requestDoc.createElementNS("http://www.w3.org/2005/Atom", "content");
        entryElement.appendChild(contentElement);
        
        Attr typeAttribute = requestDoc.createAttribute("type");
        typeAttribute.setValue("application/atom+xml;type=entry;charset=utf-8");
        contentElement.setAttributeNode(typeAttribute);
        
        Element namespaceDescriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "NamespaceDescription");
        contentElement.appendChild(namespaceDescriptionElement);
        
        if (namespaceEntity.getRegion() != null) {
            Element regionElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Region");
            regionElement.appendChild(requestDoc.createTextNode(namespaceEntity.getRegion()));
            namespaceDescriptionElement.appendChild(regionElement);
        }
        
        Element createACSNamespaceElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreateACSNamespace");
        createACSNamespaceElement.appendChild(requestDoc.createTextNode(Boolean.toString(namespaceEntity.isCreateACSNamespace()).toLowerCase()));
        namespaceDescriptionElement.appendChild(createACSNamespaceElement);
        
        if (namespaceEntity.getNamespaceType() != null) {
            Element namespaceTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "NamespaceType");
            namespaceTypeElement.appendChild(requestDoc.createTextNode(namespaceEntity.getNamespaceType().toString()));
            namespaceDescriptionElement.appendChild(namespaceTypeElement);
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/atom+xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ServiceBusNamespaceResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ServiceBusNamespaceResponse();
                DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
                documentBuilderFactory2.setNamespaceAware(true);
                DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
                Document responseDoc = documentBuilder2.parse(new BOMInputStream(responseContent));
                
                Element entryElement2 = XmlUtility.getElementByTagNameNS(responseDoc, "http://www.w3.org/2005/Atom", "entry");
                if (entryElement2 != null) {
                    Element contentElement2 = XmlUtility.getElementByTagNameNS(entryElement2, "http://www.w3.org/2005/Atom", "content");
                    if (contentElement2 != null) {
                        Element namespaceDescriptionElement2 = XmlUtility.getElementByTagNameNS(contentElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "NamespaceDescription");
                        if (namespaceDescriptionElement2 != null) {
                            ServiceBusNamespace namespaceDescriptionInstance = new ServiceBusNamespace();
                            result.setNamespace(namespaceDescriptionInstance);
                            
                            Element nameElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Name");
                            if (nameElement != null) {
                                String nameInstance;
                                nameInstance = nameElement.getTextContent();
                                namespaceDescriptionInstance.setName(nameInstance);
                            }
                            
                            Element regionElement2 = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Region");
                            if (regionElement2 != null) {
                                String regionInstance;
                                regionInstance = regionElement2.getTextContent();
                                namespaceDescriptionInstance.setRegion(regionInstance);
                            }
                            
                            Element statusElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Status");
                            if (statusElement != null) {
                                String statusInstance;
                                statusInstance = statusElement.getTextContent();
                                namespaceDescriptionInstance.setStatus(statusInstance);
                            }
                            
                            Element createdAtElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedAt");
                            if (createdAtElement != null) {
                                Calendar createdAtInstance;
                                createdAtInstance = DatatypeConverter.parseDateTime(createdAtElement.getTextContent());
                                namespaceDescriptionInstance.setCreatedAt(createdAtInstance);
                            }
                            
                            Element acsManagementEndpointElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AcsManagementEndpoint");
                            if (acsManagementEndpointElement != null) {
                                URI acsManagementEndpointInstance;
                                acsManagementEndpointInstance = new URI(acsManagementEndpointElement.getTextContent());
                                namespaceDescriptionInstance.setAcsManagementEndpoint(acsManagementEndpointInstance);
                            }
                            
                            Element serviceBusEndpointElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ServiceBusEndpoint");
                            if (serviceBusEndpointElement != null) {
                                URI serviceBusEndpointInstance;
                                serviceBusEndpointInstance = new URI(serviceBusEndpointElement.getTextContent());
                                namespaceDescriptionInstance.setServiceBusEndpoint(serviceBusEndpointInstance);
                            }
                            
                            Element subscriptionIdElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SubscriptionId");
                            if (subscriptionIdElement != null) {
                                String subscriptionIdInstance;
                                subscriptionIdInstance = subscriptionIdElement.getTextContent();
                                namespaceDescriptionInstance.setSubscriptionId(subscriptionIdInstance);
                            }
                            
                            Element enabledElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Enabled");
                            if (enabledElement != null) {
                                boolean enabledInstance;
                                enabledInstance = DatatypeConverter.parseBoolean(enabledElement.getTextContent().toLowerCase());
                                namespaceDescriptionInstance.setEnabled(enabledInstance);
                            }
                            
                            Element createACSNamespaceElement2 = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreateACSNamespace");
                            if (createACSNamespaceElement2 != null) {
                                boolean createACSNamespaceInstance;
                                createACSNamespaceInstance = DatatypeConverter.parseBoolean(createACSNamespaceElement2.getTextContent().toLowerCase());
                                namespaceDescriptionInstance.setCreateACSNamespace(createACSNamespaceInstance);
                            }
                            
                            Element namespaceTypeElement2 = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "NamespaceType");
                            if (namespaceTypeElement2 != null && namespaceTypeElement2.getTextContent() != null && !namespaceTypeElement2.getTextContent().isEmpty()) {
                                NamespaceType namespaceTypeInstance;
                                namespaceTypeInstance = NamespaceType.valueOf(namespaceTypeElement2.getTextContent());
                                namespaceDescriptionInstance.setNamespaceType(namespaceTypeInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Deletes an existing namespace. This operation also removes all associated
    * entities including queues, topics, relay points, and messages stored
    * under the namespace.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj856296.aspx for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String namespaceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(namespaceName);
            }
         });
    }
    
    /**
    * Deletes an existing namespace. This operation also removes all associated
    * entities including queues, topics, relay points, and messages stored
    * under the namespace.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj856296.aspx for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String namespaceName) throws IOException, ServiceException {
        // Validate
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("namespaceName", namespaceName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/servicebus/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Accept", "application/atom+xml");
        httpRequest.setHeader("Content-Type", "application/atom+xml");
        httpRequest.setHeader("x-ms-version", "2013-08-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The delete namespace authorization rule operation deletes an
    * authorization rule for a namespace
    *
    * @param namespaceName Required. The namespace name.
    * @param ruleName Required. The rule name.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAuthorizationRuleAsync(final String namespaceName, final String ruleName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return deleteAuthorizationRule(namespaceName, ruleName);
            }
         });
    }
    
    /**
    * The delete namespace authorization rule operation deletes an
    * authorization rule for a namespace
    *
    * @param namespaceName Required. The namespace name.
    * @param ruleName Required. The rule name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse deleteAuthorizationRule(String namespaceName, String ruleName) throws IOException, ServiceException {
        // Validate
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (ruleName == null) {
            throw new NullPointerException("ruleName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("ruleName", ruleName);
            CloudTracing.enter(invocationId, this, "deleteAuthorizationRuleAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/servicebus/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/AuthorizationRules/";
        url = url + URLEncoder.encode(ruleName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Returns the description for the specified namespace.  (see
    * http://msdn.microsoft.com/library/azure/dn140232.aspx for more
    * information)
    *
    * @param namespaceName Required. The namespace name.
    * @return The response to a request for a particular namespace.
    */
    @Override
    public Future<ServiceBusNamespaceResponse> getAsync(final String namespaceName) {
        return this.getClient().getExecutorService().submit(new Callable<ServiceBusNamespaceResponse>() { 
            @Override
            public ServiceBusNamespaceResponse call() throws Exception {
                return get(namespaceName);
            }
         });
    }
    
    /**
    * Returns the description for the specified namespace.  (see
    * http://msdn.microsoft.com/library/azure/dn140232.aspx for more
    * information)
    *
    * @param namespaceName Required. The namespace name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The response to a request for a particular namespace.
    */
    @Override
    public ServiceBusNamespaceResponse get(String namespaceName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        // Validate
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("namespaceName", namespaceName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/servicebus/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Accept", "application/atom+xml");
        httpRequest.setHeader("Content-Type", "application/atom+xml");
        httpRequest.setHeader("x-ms-version", "2013-08-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ServiceBusNamespaceResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ServiceBusNamespaceResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element entryElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://www.w3.org/2005/Atom", "entry");
                if (entryElement != null) {
                    Element contentElement = XmlUtility.getElementByTagNameNS(entryElement, "http://www.w3.org/2005/Atom", "content");
                    if (contentElement != null) {
                        Element namespaceDescriptionElement = XmlUtility.getElementByTagNameNS(contentElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "NamespaceDescription");
                        if (namespaceDescriptionElement != null) {
                            ServiceBusNamespace namespaceDescriptionInstance = new ServiceBusNamespace();
                            result.setNamespace(namespaceDescriptionInstance);
                            
                            Element nameElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Name");
                            if (nameElement != null) {
                                String nameInstance;
                                nameInstance = nameElement.getTextContent();
                                namespaceDescriptionInstance.setName(nameInstance);
                            }
                            
                            Element regionElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Region");
                            if (regionElement != null) {
                                String regionInstance;
                                regionInstance = regionElement.getTextContent();
                                namespaceDescriptionInstance.setRegion(regionInstance);
                            }
                            
                            Element statusElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Status");
                            if (statusElement != null) {
                                String statusInstance;
                                statusInstance = statusElement.getTextContent();
                                namespaceDescriptionInstance.setStatus(statusInstance);
                            }
                            
                            Element createdAtElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedAt");
                            if (createdAtElement != null) {
                                Calendar createdAtInstance;
                                createdAtInstance = DatatypeConverter.parseDateTime(createdAtElement.getTextContent());
                                namespaceDescriptionInstance.setCreatedAt(createdAtInstance);
                            }
                            
                            Element acsManagementEndpointElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AcsManagementEndpoint");
                            if (acsManagementEndpointElement != null) {
                                URI acsManagementEndpointInstance;
                                acsManagementEndpointInstance = new URI(acsManagementEndpointElement.getTextContent());
                                namespaceDescriptionInstance.setAcsManagementEndpoint(acsManagementEndpointInstance);
                            }
                            
                            Element serviceBusEndpointElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ServiceBusEndpoint");
                            if (serviceBusEndpointElement != null) {
                                URI serviceBusEndpointInstance;
                                serviceBusEndpointInstance = new URI(serviceBusEndpointElement.getTextContent());
                                namespaceDescriptionInstance.setServiceBusEndpoint(serviceBusEndpointInstance);
                            }
                            
                            Element subscriptionIdElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SubscriptionId");
                            if (subscriptionIdElement != null) {
                                String subscriptionIdInstance;
                                subscriptionIdInstance = subscriptionIdElement.getTextContent();
                                namespaceDescriptionInstance.setSubscriptionId(subscriptionIdInstance);
                            }
                            
                            Element enabledElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Enabled");
                            if (enabledElement != null) {
                                boolean enabledInstance;
                                enabledInstance = DatatypeConverter.parseBoolean(enabledElement.getTextContent().toLowerCase());
                                namespaceDescriptionInstance.setEnabled(enabledInstance);
                            }
                            
                            Element createACSNamespaceElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreateACSNamespace");
                            if (createACSNamespaceElement != null) {
                                boolean createACSNamespaceInstance;
                                createACSNamespaceInstance = DatatypeConverter.parseBoolean(createACSNamespaceElement.getTextContent().toLowerCase());
                                namespaceDescriptionInstance.setCreateACSNamespace(createACSNamespaceInstance);
                            }
                            
                            Element namespaceTypeElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "NamespaceType");
                            if (namespaceTypeElement != null && namespaceTypeElement.getTextContent() != null && !namespaceTypeElement.getTextContent().isEmpty()) {
                                NamespaceType namespaceTypeInstance;
                                namespaceTypeInstance = NamespaceType.valueOf(namespaceTypeElement.getTextContent());
                                namespaceDescriptionInstance.setNamespaceType(namespaceTypeInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The get authorization rule operation gets an authorization rule for a
    * namespace by name.
    *
    * @param namespaceName Required. The namespace to get the authorization
    * rule for.
    * @param entityName Required. The entity name to get the authorization rule
    * for.
    * @return A response to a request for a particular authorization rule.
    */
    @Override
    public Future<ServiceBusAuthorizationRuleResponse> getAuthorizationRuleAsync(final String namespaceName, final String entityName) {
        return this.getClient().getExecutorService().submit(new Callable<ServiceBusAuthorizationRuleResponse>() { 
            @Override
            public ServiceBusAuthorizationRuleResponse call() throws Exception {
                return getAuthorizationRule(namespaceName, entityName);
            }
         });
    }
    
    /**
    * The get authorization rule operation gets an authorization rule for a
    * namespace by name.
    *
    * @param namespaceName Required. The namespace to get the authorization
    * rule for.
    * @param entityName Required. The entity name to get the authorization rule
    * for.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return A response to a request for a particular authorization rule.
    */
    @Override
    public ServiceBusAuthorizationRuleResponse getAuthorizationRule(String namespaceName, String entityName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (entityName == null) {
            throw new NullPointerException("entityName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("entityName", entityName);
            CloudTracing.enter(invocationId, this, "getAuthorizationRuleAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/servicebus/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/AuthorizationRules/";
        url = url + URLEncoder.encode(entityName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Accept", "application/atom+xml");
        httpRequest.setHeader("Content-Type", "application/xml; charset=utf-8");
        httpRequest.setHeader("x-ms-version", "2013-08-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ServiceBusAuthorizationRuleResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ServiceBusAuthorizationRuleResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element entryElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://www.w3.org/2005/Atom", "entry");
                if (entryElement != null) {
                    Element contentElement = XmlUtility.getElementByTagNameNS(entryElement, "http://www.w3.org/2005/Atom", "content");
                    if (contentElement != null) {
                        Element sharedAccessAuthorizationRuleElement = XmlUtility.getElementByTagNameNS(contentElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SharedAccessAuthorizationRule");
                        if (sharedAccessAuthorizationRuleElement != null) {
                            ServiceBusSharedAccessAuthorizationRule sharedAccessAuthorizationRuleInstance = new ServiceBusSharedAccessAuthorizationRule();
                            result.setAuthorizationRule(sharedAccessAuthorizationRuleInstance);
                            
                            Element claimTypeElement = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimType");
                            if (claimTypeElement != null) {
                                String claimTypeInstance;
                                claimTypeInstance = claimTypeElement.getTextContent();
                                sharedAccessAuthorizationRuleInstance.setClaimType(claimTypeInstance);
                            }
                            
                            Element claimValueElement = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimValue");
                            if (claimValueElement != null) {
                                String claimValueInstance;
                                claimValueInstance = claimValueElement.getTextContent();
                                sharedAccessAuthorizationRuleInstance.setClaimValue(claimValueInstance);
                            }
                            
                            Element rightsSequenceElement = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Rights");
                            if (rightsSequenceElement != null) {
                                for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").size(); i1 = i1 + 1) {
                                    org.w3c.dom.Element rightsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").get(i1));
                                    sharedAccessAuthorizationRuleInstance.getRights().add(AccessRight.valueOf(rightsElement.getTextContent()));
                                }
                            }
                            
                            Element createdTimeElement = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedTime");
                            if (createdTimeElement != null) {
                                Calendar createdTimeInstance;
                                createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeElement.getTextContent());
                                sharedAccessAuthorizationRuleInstance.setCreatedTime(createdTimeInstance);
                            }
                            
                            Element modifiedTimeElement = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ModifiedTime");
                            if (modifiedTimeElement != null) {
                                Calendar modifiedTimeInstance;
                                modifiedTimeInstance = DatatypeConverter.parseDateTime(modifiedTimeElement.getTextContent());
                                sharedAccessAuthorizationRuleInstance.setModifiedTime(modifiedTimeInstance);
                            }
                            
                            Element keyNameElement = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "KeyName");
                            if (keyNameElement != null) {
                                String keyNameInstance;
                                keyNameInstance = keyNameElement.getTextContent();
                                sharedAccessAuthorizationRuleInstance.setKeyName(keyNameInstance);
                            }
                            
                            Element primaryKeyElement = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "PrimaryKey");
                            if (primaryKeyElement != null) {
                                String primaryKeyInstance;
                                primaryKeyInstance = primaryKeyElement.getTextContent();
                                sharedAccessAuthorizationRuleInstance.setPrimaryKey(primaryKeyInstance);
                            }
                            
                            Element secondaryKeyElement = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SecondaryKey");
                            if (secondaryKeyElement != null) {
                                String secondaryKeyInstance;
                                secondaryKeyInstance = secondaryKeyElement.getTextContent();
                                sharedAccessAuthorizationRuleInstance.setSecondaryKey(secondaryKeyInstance);
                            }
                            
                            Element revisionElement = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Revision");
                            if (revisionElement != null) {
                                int revisionInstance;
                                revisionInstance = DatatypeConverter.parseInt(revisionElement.getTextContent());
                                sharedAccessAuthorizationRuleInstance.setRevision(revisionInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The namespace description is an XML AtomPub document that defines the
    * desired semantics for a service namespace. The namespace description
    * contains the following properties.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj873988.aspx for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @return A response to a request for a list of namespaces.
    */
    @Override
    public Future<ServiceBusNamespaceDescriptionResponse> getNamespaceDescriptionAsync(final String namespaceName) {
        return this.getClient().getExecutorService().submit(new Callable<ServiceBusNamespaceDescriptionResponse>() { 
            @Override
            public ServiceBusNamespaceDescriptionResponse call() throws Exception {
                return getNamespaceDescription(namespaceName);
            }
         });
    }
    
    /**
    * The namespace description is an XML AtomPub document that defines the
    * desired semantics for a service namespace. The namespace description
    * contains the following properties.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj873988.aspx for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return A response to a request for a list of namespaces.
    */
    @Override
    public ServiceBusNamespaceDescriptionResponse getNamespaceDescription(String namespaceName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("namespaceName", namespaceName);
            CloudTracing.enter(invocationId, this, "getNamespaceDescriptionAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/servicebus/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/ConnectionDetails";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Accept", "application/atom+xml");
        httpRequest.setHeader("Content-Type", "application/xml; charset=utf-8");
        httpRequest.setHeader("x-ms-version", "2013-08-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ServiceBusNamespaceDescriptionResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ServiceBusNamespaceDescriptionResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element feedElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://www.w3.org/2005/Atom", "feed");
                if (feedElement != null) {
                    if (feedElement != null) {
                        for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(feedElement, "http://www.w3.org/2005/Atom", "entry").size(); i1 = i1 + 1) {
                            org.w3c.dom.Element entriesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(feedElement, "http://www.w3.org/2005/Atom", "entry").get(i1));
                            NamespaceDescription entryInstance = new NamespaceDescription();
                            result.getNamespaceDescriptions().add(entryInstance);
                            
                            Element contentElement = XmlUtility.getElementByTagNameNS(entriesElement, "http://www.w3.org/2005/Atom", "content");
                            if (contentElement != null) {
                                Element connectionDetailElement = XmlUtility.getElementByTagNameNS(contentElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ConnectionDetail");
                                if (connectionDetailElement != null) {
                                    Element keyNameElement = XmlUtility.getElementByTagNameNS(connectionDetailElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "KeyName");
                                    if (keyNameElement != null) {
                                        String keyNameInstance;
                                        keyNameInstance = keyNameElement.getTextContent();
                                        entryInstance.setKeyName(keyNameInstance);
                                    }
                                    
                                    Element connectionStringElement = XmlUtility.getElementByTagNameNS(connectionDetailElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ConnectionString");
                                    if (connectionStringElement != null) {
                                        String connectionStringInstance;
                                        connectionStringInstance = connectionStringElement.getTextContent();
                                        entryInstance.setConnectionString(connectionStringInstance);
                                    }
                                    
                                    Element authorizationTypeElement = XmlUtility.getElementByTagNameNS(connectionDetailElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationType");
                                    if (authorizationTypeElement != null) {
                                        String authorizationTypeInstance;
                                        authorizationTypeInstance = authorizationTypeElement.getTextContent();
                                        entryInstance.setAuthorizationType(authorizationTypeInstance);
                                    }
                                    
                                    Element rightsSequenceElement = XmlUtility.getElementByTagNameNS(connectionDetailElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Rights");
                                    if (rightsSequenceElement != null) {
                                        for (int i2 = 0; i2 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").size(); i2 = i2 + 1) {
                                            org.w3c.dom.Element rightsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").get(i2));
                                            entryInstance.getRights().add(AccessRight.valueOf(rightsElement.getTextContent()));
                                        }
                                    }
                                    
                                    Element secondaryConnectionStringElement = XmlUtility.getElementByTagNameNS(connectionDetailElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SecondaryConnectionString");
                                    if (secondaryConnectionStringElement != null) {
                                        String secondaryConnectionStringInstance;
                                        secondaryConnectionStringInstance = secondaryConnectionStringElement.getTextContent();
                                        entryInstance.setSecondaryConnectionString(secondaryConnectionStringInstance);
                                    }
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Lists the available namespaces.  (see
    * http://msdn.microsoft.com/en-us/library/azure/hh780759.aspx for more
    * information)
    *
    * @return The response to the request for a listing of namespaces.
    */
    @Override
    public Future<ServiceBusNamespacesResponse> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<ServiceBusNamespacesResponse>() { 
            @Override
            public ServiceBusNamespacesResponse call() throws Exception {
                return list();
            }
         });
    }
    
    /**
    * Lists the available namespaces.  (see
    * http://msdn.microsoft.com/en-us/library/azure/hh780759.aspx for more
    * information)
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The response to the request for a listing of namespaces.
    */
    @Override
    public ServiceBusNamespacesResponse list() throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        // Validate
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/servicebus/namespaces/";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Accept", "application/atom+xml");
        httpRequest.setHeader("Content-Type", "application/atom+xml");
        httpRequest.setHeader("x-ms-version", "2013-08-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ServiceBusNamespacesResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ServiceBusNamespacesResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element feedElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://www.w3.org/2005/Atom", "feed");
                if (feedElement != null) {
                    if (feedElement != null) {
                        for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(feedElement, "http://www.w3.org/2005/Atom", "entry").size(); i1 = i1 + 1) {
                            org.w3c.dom.Element entriesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(feedElement, "http://www.w3.org/2005/Atom", "entry").get(i1));
                            ServiceBusNamespace entryInstance = new ServiceBusNamespace();
                            result.getNamespaces().add(entryInstance);
                            
                            Element contentElement = XmlUtility.getElementByTagNameNS(entriesElement, "http://www.w3.org/2005/Atom", "content");
                            if (contentElement != null) {
                                Element namespaceDescriptionElement = XmlUtility.getElementByTagNameNS(contentElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "NamespaceDescription");
                                if (namespaceDescriptionElement != null) {
                                    Element nameElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Name");
                                    if (nameElement != null) {
                                        String nameInstance;
                                        nameInstance = nameElement.getTextContent();
                                        entryInstance.setName(nameInstance);
                                    }
                                    
                                    Element regionElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Region");
                                    if (regionElement != null) {
                                        String regionInstance;
                                        regionInstance = regionElement.getTextContent();
                                        entryInstance.setRegion(regionInstance);
                                    }
                                    
                                    Element statusElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Status");
                                    if (statusElement != null) {
                                        String statusInstance;
                                        statusInstance = statusElement.getTextContent();
                                        entryInstance.setStatus(statusInstance);
                                    }
                                    
                                    Element createdAtElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedAt");
                                    if (createdAtElement != null) {
                                        Calendar createdAtInstance;
                                        createdAtInstance = DatatypeConverter.parseDateTime(createdAtElement.getTextContent());
                                        entryInstance.setCreatedAt(createdAtInstance);
                                    }
                                    
                                    Element acsManagementEndpointElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AcsManagementEndpoint");
                                    if (acsManagementEndpointElement != null) {
                                        URI acsManagementEndpointInstance;
                                        acsManagementEndpointInstance = new URI(acsManagementEndpointElement.getTextContent());
                                        entryInstance.setAcsManagementEndpoint(acsManagementEndpointInstance);
                                    }
                                    
                                    Element serviceBusEndpointElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ServiceBusEndpoint");
                                    if (serviceBusEndpointElement != null) {
                                        URI serviceBusEndpointInstance;
                                        serviceBusEndpointInstance = new URI(serviceBusEndpointElement.getTextContent());
                                        entryInstance.setServiceBusEndpoint(serviceBusEndpointInstance);
                                    }
                                    
                                    Element subscriptionIdElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SubscriptionId");
                                    if (subscriptionIdElement != null) {
                                        String subscriptionIdInstance;
                                        subscriptionIdInstance = subscriptionIdElement.getTextContent();
                                        entryInstance.setSubscriptionId(subscriptionIdInstance);
                                    }
                                    
                                    Element enabledElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Enabled");
                                    if (enabledElement != null) {
                                        boolean enabledInstance;
                                        enabledInstance = DatatypeConverter.parseBoolean(enabledElement.getTextContent().toLowerCase());
                                        entryInstance.setEnabled(enabledInstance);
                                    }
                                    
                                    Element createACSNamespaceElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreateACSNamespace");
                                    if (createACSNamespaceElement != null) {
                                        boolean createACSNamespaceInstance;
                                        createACSNamespaceInstance = DatatypeConverter.parseBoolean(createACSNamespaceElement.getTextContent().toLowerCase());
                                        entryInstance.setCreateACSNamespace(createACSNamespaceInstance);
                                    }
                                    
                                    Element namespaceTypeElement = XmlUtility.getElementByTagNameNS(namespaceDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "NamespaceType");
                                    if (namespaceTypeElement != null && namespaceTypeElement.getTextContent() != null && !namespaceTypeElement.getTextContent().isEmpty()) {
                                        NamespaceType namespaceTypeInstance;
                                        namespaceTypeInstance = NamespaceType.valueOf(namespaceTypeElement.getTextContent());
                                        entryInstance.setNamespaceType(namespaceTypeInstance);
                                    }
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The get authorization rules operation gets the authorization rules for a
    * namespace.
    *
    * @param namespaceName Required. The namespace to get the authorization
    * rule for.
    * @return A response to a request for a list of authorization rules.
    */
    @Override
    public Future<ServiceBusAuthorizationRulesResponse> listAuthorizationRulesAsync(final String namespaceName) {
        return this.getClient().getExecutorService().submit(new Callable<ServiceBusAuthorizationRulesResponse>() { 
            @Override
            public ServiceBusAuthorizationRulesResponse call() throws Exception {
                return listAuthorizationRules(namespaceName);
            }
         });
    }
    
    /**
    * The get authorization rules operation gets the authorization rules for a
    * namespace.
    *
    * @param namespaceName Required. The namespace to get the authorization
    * rule for.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return A response to a request for a list of authorization rules.
    */
    @Override
    public ServiceBusAuthorizationRulesResponse listAuthorizationRules(String namespaceName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("namespaceName", namespaceName);
            CloudTracing.enter(invocationId, this, "listAuthorizationRulesAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/servicebus/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/AuthorizationRules";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Accept", "application/atom+xml");
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2013-08-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ServiceBusAuthorizationRulesResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ServiceBusAuthorizationRulesResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element feedElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://www.w3.org/2005/Atom", "feed");
                if (feedElement != null) {
                    if (feedElement != null) {
                        for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(feedElement, "http://www.w3.org/2005/Atom", "entry").size(); i1 = i1 + 1) {
                            org.w3c.dom.Element entriesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(feedElement, "http://www.w3.org/2005/Atom", "entry").get(i1));
                            ServiceBusSharedAccessAuthorizationRule entryInstance = new ServiceBusSharedAccessAuthorizationRule();
                            result.getAuthorizationRules().add(entryInstance);
                            
                            Element contentElement = XmlUtility.getElementByTagNameNS(entriesElement, "http://www.w3.org/2005/Atom", "content");
                            if (contentElement != null) {
                                Element sharedAccessAuthorizationRuleElement = XmlUtility.getElementByTagNameNS(contentElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SharedAccessAuthorizationRule");
                                if (sharedAccessAuthorizationRuleElement != null) {
                                    Element claimTypeElement = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimType");
                                    if (claimTypeElement != null) {
                                        String claimTypeInstance;
                                        claimTypeInstance = claimTypeElement.getTextContent();
                                        entryInstance.setClaimType(claimTypeInstance);
                                    }
                                    
                                    Element claimValueElement = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimValue");
                                    if (claimValueElement != null) {
                                        String claimValueInstance;
                                        claimValueInstance = claimValueElement.getTextContent();
                                        entryInstance.setClaimValue(claimValueInstance);
                                    }
                                    
                                    Element rightsSequenceElement = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Rights");
                                    if (rightsSequenceElement != null) {
                                        for (int i2 = 0; i2 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").size(); i2 = i2 + 1) {
                                            org.w3c.dom.Element rightsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").get(i2));
                                            entryInstance.getRights().add(AccessRight.valueOf(rightsElement.getTextContent()));
                                        }
                                    }
                                    
                                    Element createdTimeElement = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedTime");
                                    if (createdTimeElement != null) {
                                        Calendar createdTimeInstance;
                                        createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeElement.getTextContent());
                                        entryInstance.setCreatedTime(createdTimeInstance);
                                    }
                                    
                                    Element modifiedTimeElement = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ModifiedTime");
                                    if (modifiedTimeElement != null) {
                                        Calendar modifiedTimeInstance;
                                        modifiedTimeInstance = DatatypeConverter.parseDateTime(modifiedTimeElement.getTextContent());
                                        entryInstance.setModifiedTime(modifiedTimeInstance);
                                    }
                                    
                                    Element keyNameElement = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "KeyName");
                                    if (keyNameElement != null) {
                                        String keyNameInstance;
                                        keyNameInstance = keyNameElement.getTextContent();
                                        entryInstance.setKeyName(keyNameInstance);
                                    }
                                    
                                    Element primaryKeyElement = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "PrimaryKey");
                                    if (primaryKeyElement != null) {
                                        String primaryKeyInstance;
                                        primaryKeyInstance = primaryKeyElement.getTextContent();
                                        entryInstance.setPrimaryKey(primaryKeyInstance);
                                    }
                                    
                                    Element secondaryKeyElement = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SecondaryKey");
                                    if (secondaryKeyElement != null) {
                                        String secondaryKeyInstance;
                                        secondaryKeyInstance = secondaryKeyElement.getTextContent();
                                        entryInstance.setSecondaryKey(secondaryKeyInstance);
                                    }
                                    
                                    Element revisionElement = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Revision");
                                    if (revisionElement != null) {
                                        int revisionInstance;
                                        revisionInstance = DatatypeConverter.parseInt(revisionElement.getTextContent());
                                        entryInstance.setRevision(revisionInstance);
                                    }
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The update authorization rule operation updates an authorization rule for
    * a namespace.
    *
    * @param namespaceName Required. The namespace name.
    * @param rule Optional. Updated access authorization rule.
    * @return A response to a request for a particular authorization rule.
    */
    @Override
    public Future<ServiceBusAuthorizationRuleResponse> updateAuthorizationRuleAsync(final String namespaceName, final ServiceBusSharedAccessAuthorizationRule rule) {
        return this.getClient().getExecutorService().submit(new Callable<ServiceBusAuthorizationRuleResponse>() { 
            @Override
            public ServiceBusAuthorizationRuleResponse call() throws Exception {
                return updateAuthorizationRule(namespaceName, rule);
            }
         });
    }
    
    /**
    * The update authorization rule operation updates an authorization rule for
    * a namespace.
    *
    * @param namespaceName Required. The namespace name.
    * @param rule Optional. Updated access authorization rule.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A response to a request for a particular authorization rule.
    */
    @Override
    public ServiceBusAuthorizationRuleResponse updateAuthorizationRule(String namespaceName, ServiceBusSharedAccessAuthorizationRule rule) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("rule", rule);
            CloudTracing.enter(invocationId, this, "updateAuthorizationRuleAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/servicebus/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/AuthorizationRules/";
        if (rule != null && rule.getKeyName() != null) {
            url = url + URLEncoder.encode(rule.getKeyName(), "UTF-8");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Accept", "application/atom+xml");
        httpRequest.setHeader("Content-Type", "application/atom+xml");
        httpRequest.setHeader("if-match", "*");
        httpRequest.setHeader("type", "entry");
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        if (rule != null) {
            Element entryElement = requestDoc.createElementNS("http://www.w3.org/2005/Atom", "entry");
            requestDoc.appendChild(entryElement);
            
            Element contentElement = requestDoc.createElementNS("http://www.w3.org/2005/Atom", "content");
            entryElement.appendChild(contentElement);
            
            Attr typeAttribute = requestDoc.createAttribute("type");
            typeAttribute.setValue("application/atom+xml");
            contentElement.setAttributeNode(typeAttribute);
            
            Element sharedAccessAuthorizationRuleElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SharedAccessAuthorizationRule");
            contentElement.appendChild(sharedAccessAuthorizationRuleElement);
            
            if (rule.getClaimType() != null) {
                Element claimTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimType");
                claimTypeElement.appendChild(requestDoc.createTextNode(rule.getClaimType()));
                sharedAccessAuthorizationRuleElement.appendChild(claimTypeElement);
            }
            
            if (rule.getClaimValue() != null) {
                Element claimValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimValue");
                claimValueElement.appendChild(requestDoc.createTextNode(rule.getClaimValue()));
                sharedAccessAuthorizationRuleElement.appendChild(claimValueElement);
            }
            
            if (rule.getRights() != null) {
                if (rule.getRights() instanceof LazyCollection == false || ((LazyCollection) rule.getRights()).isInitialized()) {
                    Element rightsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Rights");
                    for (AccessRight rightsItem : rule.getRights()) {
                        Element rightsItemElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights");
                        rightsItemElement.appendChild(requestDoc.createTextNode(rightsItem.toString()));
                        rightsSequenceElement.appendChild(rightsItemElement);
                    }
                    sharedAccessAuthorizationRuleElement.appendChild(rightsSequenceElement);
                }
            }
            
            Element createdTimeElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedTime");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            createdTimeElement.appendChild(requestDoc.createTextNode(simpleDateFormat.format(rule.getCreatedTime().getTime())));
            sharedAccessAuthorizationRuleElement.appendChild(createdTimeElement);
            
            Element modifiedTimeElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ModifiedTime");
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
            simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
            modifiedTimeElement.appendChild(requestDoc.createTextNode(simpleDateFormat2.format(rule.getModifiedTime().getTime())));
            sharedAccessAuthorizationRuleElement.appendChild(modifiedTimeElement);
            
            Element revisionElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Revision");
            revisionElement.appendChild(requestDoc.createTextNode(Integer.toString(rule.getRevision())));
            sharedAccessAuthorizationRuleElement.appendChild(revisionElement);
            
            if (rule.getKeyName() != null) {
                Element keyNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "KeyName");
                keyNameElement.appendChild(requestDoc.createTextNode(rule.getKeyName()));
                sharedAccessAuthorizationRuleElement.appendChild(keyNameElement);
            }
            
            if (rule.getPrimaryKey() != null) {
                Element primaryKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "PrimaryKey");
                primaryKeyElement.appendChild(requestDoc.createTextNode(rule.getPrimaryKey()));
                sharedAccessAuthorizationRuleElement.appendChild(primaryKeyElement);
            }
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/atom+xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ServiceBusAuthorizationRuleResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ServiceBusAuthorizationRuleResponse();
                DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
                documentBuilderFactory2.setNamespaceAware(true);
                DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
                Document responseDoc = documentBuilder2.parse(new BOMInputStream(responseContent));
                
                Element entryElement2 = XmlUtility.getElementByTagNameNS(responseDoc, "http://www.w3.org/2005/Atom", "entry");
                if (entryElement2 != null) {
                    Element contentElement2 = XmlUtility.getElementByTagNameNS(entryElement2, "http://www.w3.org/2005/Atom", "content");
                    if (contentElement2 != null) {
                        Element sharedAccessAuthorizationRuleElement2 = XmlUtility.getElementByTagNameNS(contentElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SharedAccessAuthorizationRule");
                        if (sharedAccessAuthorizationRuleElement2 != null) {
                            ServiceBusSharedAccessAuthorizationRule sharedAccessAuthorizationRuleInstance = new ServiceBusSharedAccessAuthorizationRule();
                            result.setAuthorizationRule(sharedAccessAuthorizationRuleInstance);
                            
                            Element claimTypeElement2 = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimType");
                            if (claimTypeElement2 != null) {
                                String claimTypeInstance;
                                claimTypeInstance = claimTypeElement2.getTextContent();
                                sharedAccessAuthorizationRuleInstance.setClaimType(claimTypeInstance);
                            }
                            
                            Element claimValueElement2 = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimValue");
                            if (claimValueElement2 != null) {
                                String claimValueInstance;
                                claimValueInstance = claimValueElement2.getTextContent();
                                sharedAccessAuthorizationRuleInstance.setClaimValue(claimValueInstance);
                            }
                            
                            Element rightsSequenceElement2 = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Rights");
                            if (rightsSequenceElement2 != null) {
                                for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").size(); i1 = i1 + 1) {
                                    org.w3c.dom.Element rightsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").get(i1));
                                    sharedAccessAuthorizationRuleInstance.getRights().add(AccessRight.valueOf(rightsElement.getTextContent()));
                                }
                            }
                            
                            Element createdTimeElement2 = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedTime");
                            if (createdTimeElement2 != null) {
                                Calendar createdTimeInstance;
                                createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeElement2.getTextContent());
                                sharedAccessAuthorizationRuleInstance.setCreatedTime(createdTimeInstance);
                            }
                            
                            Element modifiedTimeElement2 = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ModifiedTime");
                            if (modifiedTimeElement2 != null) {
                                Calendar modifiedTimeInstance;
                                modifiedTimeInstance = DatatypeConverter.parseDateTime(modifiedTimeElement2.getTextContent());
                                sharedAccessAuthorizationRuleInstance.setModifiedTime(modifiedTimeInstance);
                            }
                            
                            Element keyNameElement2 = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "KeyName");
                            if (keyNameElement2 != null) {
                                String keyNameInstance;
                                keyNameInstance = keyNameElement2.getTextContent();
                                sharedAccessAuthorizationRuleInstance.setKeyName(keyNameInstance);
                            }
                            
                            Element primaryKeyElement2 = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "PrimaryKey");
                            if (primaryKeyElement2 != null) {
                                String primaryKeyInstance;
                                primaryKeyInstance = primaryKeyElement2.getTextContent();
                                sharedAccessAuthorizationRuleInstance.setPrimaryKey(primaryKeyInstance);
                            }
                            
                            Element secondaryKeyElement = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SecondaryKey");
                            if (secondaryKeyElement != null) {
                                String secondaryKeyInstance;
                                secondaryKeyInstance = secondaryKeyElement.getTextContent();
                                sharedAccessAuthorizationRuleInstance.setSecondaryKey(secondaryKeyInstance);
                            }
                            
                            Element revisionElement2 = XmlUtility.getElementByTagNameNS(sharedAccessAuthorizationRuleElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Revision");
                            if (revisionElement2 != null) {
                                int revisionInstance;
                                revisionInstance = DatatypeConverter.parseInt(revisionElement2.getTextContent());
                                sharedAccessAuthorizationRuleInstance.setRevision(revisionInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
