/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.servicebus;

import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.servicebus.models.AccessRight;
import com.microsoft.windowsazure.management.servicebus.models.CountDetails;
import com.microsoft.windowsazure.management.servicebus.models.ServiceBusConnectionDetail;
import com.microsoft.windowsazure.management.servicebus.models.ServiceBusConnectionDetailsResponse;
import com.microsoft.windowsazure.management.servicebus.models.ServiceBusQueue;
import com.microsoft.windowsazure.management.servicebus.models.ServiceBusQueueCreateParameters;
import com.microsoft.windowsazure.management.servicebus.models.ServiceBusQueueResponse;
import com.microsoft.windowsazure.management.servicebus.models.ServiceBusQueuesResponse;
import com.microsoft.windowsazure.management.servicebus.models.ServiceBusSharedAccessAuthorizationRule;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
* The Service Bus Management API includes operations for managing Service Bus
* queues.
*/
public class QueueOperationsImpl implements ServiceOperations<ServiceBusManagementClientImpl>, QueueOperations {
    /**
    * Initializes a new instance of the QueueOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    QueueOperationsImpl(ServiceBusManagementClientImpl client) {
        this.client = client;
    }
    
    private ServiceBusManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.windowsazure.management.servicebus.ServiceBusManagementClientImpl.
    * @return The Client value.
    */
    public ServiceBusManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Creates a new queue. Once created, this queue's resource manifest is
    * immutable. This operation is idempotent. Repeating the create call,
    * after a queue with same name has been created successfully, will result
    * in a 409 Conflict error message.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj856295.aspx for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @param queue Required. The service bus queue.
    * @return A response to a request for a particular queue.
    */
    @Override
    public Future<ServiceBusQueueResponse> createAsync(final String namespaceName, final ServiceBusQueueCreateParameters queue) {
        return this.getClient().getExecutorService().submit(new Callable<ServiceBusQueueResponse>() { 
            @Override
            public ServiceBusQueueResponse call() throws Exception {
                return create(namespaceName, queue);
            }
         });
    }
    
    /**
    * Creates a new queue. Once created, this queue's resource manifest is
    * immutable. This operation is idempotent. Repeating the create call,
    * after a queue with same name has been created successfully, will result
    * in a 409 Conflict error message.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj856295.aspx for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @param queue Required. The service bus queue.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return A response to a request for a particular queue.
    */
    @Override
    public ServiceBusQueueResponse create(String namespaceName, ServiceBusQueueCreateParameters queue) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException, URISyntaxException {
        // Validate
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (queue == null) {
            throw new NullPointerException("queue");
        }
        if (queue.getName() == null) {
            throw new NullPointerException("queue.Name");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("queue", queue);
            CloudTracing.enter(invocationId, this, "createAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/servicebus/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/queues/";
        url = url + URLEncoder.encode(queue.getName(), "UTF-8");
        url = url + "/";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/atom+xml");
        httpRequest.setHeader("type", "entry");
        httpRequest.setHeader("x-ms-version", "2013-08-01");
        httpRequest.setHeader("x-process-at", "ServiceBus");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element entryElement = requestDoc.createElementNS("http://www.w3.org/2005/Atom", "entry");
        requestDoc.appendChild(entryElement);
        
        Element contentElement = requestDoc.createElementNS("http://www.w3.org/2005/Atom", "content");
        entryElement.appendChild(contentElement);
        
        Attr typeAttribute = requestDoc.createAttribute("type");
        typeAttribute.setValue("application/atom+xml;type=entry;charset=utf-8");
        contentElement.setAttributeNode(typeAttribute);
        
        Element queueDescriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "QueueDescription");
        contentElement.appendChild(queueDescriptionElement);
        
        if (queue.getLockDuration() != null) {
            Element lockDurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "LockDuration");
            lockDurationElement.appendChild(requestDoc.createTextNode(queue.getLockDuration()));
            queueDescriptionElement.appendChild(lockDurationElement);
        }
        
        Element maxSizeInMegabytesElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MaxSizeInMegabytes");
        maxSizeInMegabytesElement.appendChild(requestDoc.createTextNode(Integer.toString(queue.getMaxSizeInMegabytes())));
        queueDescriptionElement.appendChild(maxSizeInMegabytesElement);
        
        Element requiresDuplicateDetectionElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "RequiresDuplicateDetection");
        requiresDuplicateDetectionElement.appendChild(requestDoc.createTextNode(Boolean.toString(queue.isRequiresDuplicateDetection()).toLowerCase()));
        queueDescriptionElement.appendChild(requiresDuplicateDetectionElement);
        
        Element requiresSessionElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "RequiresSession");
        requiresSessionElement.appendChild(requestDoc.createTextNode(Boolean.toString(queue.isRequiresSession()).toLowerCase()));
        queueDescriptionElement.appendChild(requiresSessionElement);
        
        if (queue.getDefaultMessageTimeToLive() != null) {
            Element defaultMessageTimeToLiveElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DefaultMessageTimeToLive");
            defaultMessageTimeToLiveElement.appendChild(requestDoc.createTextNode(queue.getDefaultMessageTimeToLive()));
            queueDescriptionElement.appendChild(defaultMessageTimeToLiveElement);
        }
        
        Element deadLetteringOnMessageExpirationElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DeadLetteringOnMessageExpiration");
        deadLetteringOnMessageExpirationElement.appendChild(requestDoc.createTextNode(Boolean.toString(queue.isDeadLetteringOnMessageExpiration()).toLowerCase()));
        queueDescriptionElement.appendChild(deadLetteringOnMessageExpirationElement);
        
        if (queue.getDuplicateDetectionHistoryTimeWindow() != null) {
            Element duplicateDetectionHistoryTimeWindowElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DuplicateDetectionHistoryTimeWindow");
            duplicateDetectionHistoryTimeWindowElement.appendChild(requestDoc.createTextNode(queue.getDuplicateDetectionHistoryTimeWindow()));
            queueDescriptionElement.appendChild(duplicateDetectionHistoryTimeWindowElement);
        }
        
        Element enableBatchedOperationsElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EnableBatchedOperations");
        enableBatchedOperationsElement.appendChild(requestDoc.createTextNode(Boolean.toString(queue.isEnableBatchedOperations()).toLowerCase()));
        queueDescriptionElement.appendChild(enableBatchedOperationsElement);
        
        Element sizeInBytesElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SizeInBytes");
        sizeInBytesElement.appendChild(requestDoc.createTextNode(Integer.toString(queue.getSizeInBytes())));
        queueDescriptionElement.appendChild(sizeInBytesElement);
        
        Element messageCountElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MessageCount");
        messageCountElement.appendChild(requestDoc.createTextNode(Integer.toString(queue.getMessageCount())));
        queueDescriptionElement.appendChild(messageCountElement);
        
        Element isAnonymousAccessibleElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "IsAnonymousAccessible");
        isAnonymousAccessibleElement.appendChild(requestDoc.createTextNode(Boolean.toString(queue.isAnonymousAccessible()).toLowerCase()));
        queueDescriptionElement.appendChild(isAnonymousAccessibleElement);
        
        if (queue.getAuthorizationRules() != null) {
            if (queue.getAuthorizationRules() instanceof LazyCollection == false || ((LazyCollection) queue.getAuthorizationRules()).isInitialized()) {
                Element authorizationRulesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRules");
                for (ServiceBusSharedAccessAuthorizationRule authorizationRulesItem : queue.getAuthorizationRules()) {
                    Element authorizationRuleElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRule");
                    authorizationRulesSequenceElement.appendChild(authorizationRuleElement);
                    
                    Attr typeAttribute2 = requestDoc.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                    typeAttribute2.setValue("SharedAccessAuthorizationRule");
                    authorizationRuleElement.setAttributeNode(typeAttribute2);
                    
                    if (authorizationRulesItem.getClaimType() != null) {
                        Element claimTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimType");
                        claimTypeElement.appendChild(requestDoc.createTextNode(authorizationRulesItem.getClaimType()));
                        authorizationRuleElement.appendChild(claimTypeElement);
                    }
                    
                    if (authorizationRulesItem.getClaimValue() != null) {
                        Element claimValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimValue");
                        claimValueElement.appendChild(requestDoc.createTextNode(authorizationRulesItem.getClaimValue()));
                        authorizationRuleElement.appendChild(claimValueElement);
                    }
                    
                    if (authorizationRulesItem.getRights() != null) {
                        if (authorizationRulesItem.getRights() instanceof LazyCollection == false || ((LazyCollection) authorizationRulesItem.getRights()).isInitialized()) {
                            Element rightsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Rights");
                            for (AccessRight rightsItem : authorizationRulesItem.getRights()) {
                                Element rightsItemElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights");
                                rightsItemElement.appendChild(requestDoc.createTextNode(rightsItem.toString()));
                                rightsSequenceElement.appendChild(rightsItemElement);
                            }
                            authorizationRuleElement.appendChild(rightsSequenceElement);
                        }
                    }
                    
                    Element createdTimeElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedTime");
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    createdTimeElement.appendChild(requestDoc.createTextNode(simpleDateFormat.format(authorizationRulesItem.getCreatedTime().getTime())));
                    authorizationRuleElement.appendChild(createdTimeElement);
                    
                    if (authorizationRulesItem.getKeyName() != null) {
                        Element keyNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "KeyName");
                        keyNameElement.appendChild(requestDoc.createTextNode(authorizationRulesItem.getKeyName()));
                        authorizationRuleElement.appendChild(keyNameElement);
                    }
                    
                    Element modifiedTimeElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ModifiedTime");
                    SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
                    modifiedTimeElement.appendChild(requestDoc.createTextNode(simpleDateFormat2.format(authorizationRulesItem.getModifiedTime().getTime())));
                    authorizationRuleElement.appendChild(modifiedTimeElement);
                    
                    if (authorizationRulesItem.getPrimaryKey() != null) {
                        Element primaryKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "PrimaryKey");
                        primaryKeyElement.appendChild(requestDoc.createTextNode(authorizationRulesItem.getPrimaryKey()));
                        authorizationRuleElement.appendChild(primaryKeyElement);
                    }
                    
                    if (authorizationRulesItem.getSecondaryKey() != null) {
                        Element secondaryKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SecondaryKey");
                        secondaryKeyElement.appendChild(requestDoc.createTextNode(authorizationRulesItem.getSecondaryKey()));
                        authorizationRuleElement.appendChild(secondaryKeyElement);
                    }
                }
                queueDescriptionElement.appendChild(authorizationRulesSequenceElement);
            }
        }
        
        if (queue.getStatus() != null) {
            Element statusElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Status");
            statusElement.appendChild(requestDoc.createTextNode(queue.getStatus()));
            queueDescriptionElement.appendChild(statusElement);
        }
        
        Element supportOrderingElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SupportOrdering");
        supportOrderingElement.appendChild(requestDoc.createTextNode(Boolean.toString(queue.isSupportOrdering()).toLowerCase()));
        queueDescriptionElement.appendChild(supportOrderingElement);
        
        if (queue.getCountDetails() != null) {
            Element countDetailsElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CountDetails");
            queueDescriptionElement.appendChild(countDetailsElement);
            
            Element activeMessageCountElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2011/06/servicebus", "ActiveMessageCount");
            activeMessageCountElement.appendChild(requestDoc.createTextNode(Integer.toString(queue.getCountDetails().getActiveMessageCount())));
            countDetailsElement.appendChild(activeMessageCountElement);
            
            Element deadLetterMessageCountElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2011/06/servicebus", "DeadLetterMessageCount");
            deadLetterMessageCountElement.appendChild(requestDoc.createTextNode(Integer.toString(queue.getCountDetails().getDeadLetterMessageCount())));
            countDetailsElement.appendChild(deadLetterMessageCountElement);
            
            Element scheduledMessageCountElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2011/06/servicebus", "ScheduledMessageCount");
            scheduledMessageCountElement.appendChild(requestDoc.createTextNode(Integer.toString(queue.getCountDetails().getScheduledMessageCount())));
            countDetailsElement.appendChild(scheduledMessageCountElement);
            
            Element transferDeadLetterMessageCountElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2011/06/servicebus", "TransferDeadLetterMessageCount");
            transferDeadLetterMessageCountElement.appendChild(requestDoc.createTextNode(Integer.toString(queue.getCountDetails().getTransferDeadLetterMessageCount())));
            countDetailsElement.appendChild(transferDeadLetterMessageCountElement);
            
            Element transferMessageCountElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2011/06/servicebus", "TransferMessageCount");
            transferMessageCountElement.appendChild(requestDoc.createTextNode(Integer.toString(queue.getCountDetails().getTransferMessageCount())));
            countDetailsElement.appendChild(transferMessageCountElement);
        }
        
        if (queue.getAutoDeleteOnIdle() != null) {
            Element autoDeleteOnIdleElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AutoDeleteOnIdle");
            autoDeleteOnIdleElement.appendChild(requestDoc.createTextNode(queue.getAutoDeleteOnIdle()));
            queueDescriptionElement.appendChild(autoDeleteOnIdleElement);
        }
        
        if (queue.getEntityAvailabilityStatus() != null) {
            Element entityAvailabilityStatusElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EntityAvailabilityStatus");
            entityAvailabilityStatusElement.appendChild(requestDoc.createTextNode(queue.getEntityAvailabilityStatus()));
            queueDescriptionElement.appendChild(entityAvailabilityStatusElement);
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/atom+xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ServiceBusQueueResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ServiceBusQueueResponse();
                DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
                documentBuilderFactory2.setNamespaceAware(true);
                DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
                Document responseDoc = documentBuilder2.parse(new BOMInputStream(responseContent));
                
                Element entryElement2 = XmlUtility.getElementByTagNameNS(responseDoc, "http://www.w3.org/2005/Atom", "entry");
                if (entryElement2 != null) {
                    Element titleElement = XmlUtility.getElementByTagNameNS(entryElement2, "http://www.w3.org/2005/Atom", "title");
                    if (titleElement != null) {
                    }
                    
                    Element contentElement2 = XmlUtility.getElementByTagNameNS(entryElement2, "http://www.w3.org/2005/Atom", "content");
                    if (contentElement2 != null) {
                        Element queueDescriptionElement2 = XmlUtility.getElementByTagNameNS(contentElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "QueueDescription");
                        if (queueDescriptionElement2 != null) {
                            ServiceBusQueue queueDescriptionInstance = new ServiceBusQueue();
                            result.setQueue(queueDescriptionInstance);
                            
                            Element lockDurationElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "LockDuration");
                            if (lockDurationElement2 != null) {
                                String lockDurationInstance;
                                lockDurationInstance = lockDurationElement2.getTextContent();
                                queueDescriptionInstance.setLockDuration(lockDurationInstance);
                            }
                            
                            Element maxSizeInMegabytesElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MaxSizeInMegabytes");
                            if (maxSizeInMegabytesElement2 != null) {
                                int maxSizeInMegabytesInstance;
                                maxSizeInMegabytesInstance = DatatypeConverter.parseInt(maxSizeInMegabytesElement2.getTextContent());
                                queueDescriptionInstance.setMaxSizeInMegabytes(maxSizeInMegabytesInstance);
                            }
                            
                            Element requiresDuplicateDetectionElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "RequiresDuplicateDetection");
                            if (requiresDuplicateDetectionElement2 != null) {
                                boolean requiresDuplicateDetectionInstance;
                                requiresDuplicateDetectionInstance = DatatypeConverter.parseBoolean(requiresDuplicateDetectionElement2.getTextContent().toLowerCase());
                                queueDescriptionInstance.setRequiresDuplicateDetection(requiresDuplicateDetectionInstance);
                            }
                            
                            Element requiresSessionElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "RequiresSession");
                            if (requiresSessionElement2 != null) {
                                boolean requiresSessionInstance;
                                requiresSessionInstance = DatatypeConverter.parseBoolean(requiresSessionElement2.getTextContent().toLowerCase());
                                queueDescriptionInstance.setRequiresSession(requiresSessionInstance);
                            }
                            
                            Element defaultMessageTimeToLiveElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DefaultMessageTimeToLive");
                            if (defaultMessageTimeToLiveElement2 != null) {
                                String defaultMessageTimeToLiveInstance;
                                defaultMessageTimeToLiveInstance = defaultMessageTimeToLiveElement2.getTextContent();
                                queueDescriptionInstance.setDefaultMessageTimeToLive(defaultMessageTimeToLiveInstance);
                            }
                            
                            Element deadLetteringOnMessageExpirationElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DeadLetteringOnMessageExpiration");
                            if (deadLetteringOnMessageExpirationElement2 != null) {
                                boolean deadLetteringOnMessageExpirationInstance;
                                deadLetteringOnMessageExpirationInstance = DatatypeConverter.parseBoolean(deadLetteringOnMessageExpirationElement2.getTextContent().toLowerCase());
                                queueDescriptionInstance.setDeadLetteringOnMessageExpiration(deadLetteringOnMessageExpirationInstance);
                            }
                            
                            Element duplicateDetectionHistoryTimeWindowElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DuplicateDetectionHistoryTimeWindow");
                            if (duplicateDetectionHistoryTimeWindowElement2 != null) {
                                String duplicateDetectionHistoryTimeWindowInstance;
                                duplicateDetectionHistoryTimeWindowInstance = duplicateDetectionHistoryTimeWindowElement2.getTextContent();
                                queueDescriptionInstance.setDuplicateDetectionHistoryTimeWindow(duplicateDetectionHistoryTimeWindowInstance);
                            }
                            
                            Element maxDeliveryCountElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MaxDeliveryCount");
                            if (maxDeliveryCountElement != null) {
                                int maxDeliveryCountInstance;
                                maxDeliveryCountInstance = DatatypeConverter.parseInt(maxDeliveryCountElement.getTextContent());
                                queueDescriptionInstance.setMaxDeliveryCount(maxDeliveryCountInstance);
                            }
                            
                            Element enableBatchedOperationsElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EnableBatchedOperations");
                            if (enableBatchedOperationsElement2 != null) {
                                boolean enableBatchedOperationsInstance;
                                enableBatchedOperationsInstance = DatatypeConverter.parseBoolean(enableBatchedOperationsElement2.getTextContent().toLowerCase());
                                queueDescriptionInstance.setEnableBatchedOperations(enableBatchedOperationsInstance);
                            }
                            
                            Element sizeInBytesElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SizeInBytes");
                            if (sizeInBytesElement2 != null) {
                                int sizeInBytesInstance;
                                sizeInBytesInstance = DatatypeConverter.parseInt(sizeInBytesElement2.getTextContent());
                                queueDescriptionInstance.setSizeInBytes(sizeInBytesInstance);
                            }
                            
                            Element messageCountElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MessageCount");
                            if (messageCountElement2 != null) {
                                int messageCountInstance;
                                messageCountInstance = DatatypeConverter.parseInt(messageCountElement2.getTextContent());
                                queueDescriptionInstance.setMessageCount(messageCountInstance);
                            }
                            
                            Element isAnonymousAccessibleElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "IsAnonymousAccessible");
                            if (isAnonymousAccessibleElement2 != null) {
                                boolean isAnonymousAccessibleInstance;
                                isAnonymousAccessibleInstance = DatatypeConverter.parseBoolean(isAnonymousAccessibleElement2.getTextContent().toLowerCase());
                                queueDescriptionInstance.setIsAnonymousAccessible(isAnonymousAccessibleInstance);
                            }
                            
                            Element authorizationRulesSequenceElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRules");
                            if (authorizationRulesSequenceElement2 != null) {
                                for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(authorizationRulesSequenceElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRule").size(); i1 = i1 + 1) {
                                    org.w3c.dom.Element authorizationRulesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(authorizationRulesSequenceElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRule").get(i1));
                                    ServiceBusSharedAccessAuthorizationRule authorizationRuleInstance = new ServiceBusSharedAccessAuthorizationRule();
                                    queueDescriptionInstance.getAuthorizationRules().add(authorizationRuleInstance);
                                    
                                    Element claimTypeElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimType");
                                    if (claimTypeElement2 != null) {
                                        String claimTypeInstance;
                                        claimTypeInstance = claimTypeElement2.getTextContent();
                                        authorizationRuleInstance.setClaimType(claimTypeInstance);
                                    }
                                    
                                    Element claimValueElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimValue");
                                    if (claimValueElement2 != null) {
                                        String claimValueInstance;
                                        claimValueInstance = claimValueElement2.getTextContent();
                                        authorizationRuleInstance.setClaimValue(claimValueInstance);
                                    }
                                    
                                    Element rightsSequenceElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Rights");
                                    if (rightsSequenceElement2 != null) {
                                        for (int i2 = 0; i2 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").size(); i2 = i2 + 1) {
                                            org.w3c.dom.Element rightsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").get(i2));
                                            authorizationRuleInstance.getRights().add(AccessRight.valueOf(rightsElement.getTextContent()));
                                        }
                                    }
                                    
                                    Element createdTimeElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedTime");
                                    if (createdTimeElement2 != null) {
                                        Calendar createdTimeInstance;
                                        createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeElement2.getTextContent());
                                        authorizationRuleInstance.setCreatedTime(createdTimeInstance);
                                    }
                                    
                                    Element keyNameElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "KeyName");
                                    if (keyNameElement2 != null) {
                                        String keyNameInstance;
                                        keyNameInstance = keyNameElement2.getTextContent();
                                        authorizationRuleInstance.setKeyName(keyNameInstance);
                                    }
                                    
                                    Element modifiedTimeElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ModifiedTime");
                                    if (modifiedTimeElement2 != null) {
                                        Calendar modifiedTimeInstance;
                                        modifiedTimeInstance = DatatypeConverter.parseDateTime(modifiedTimeElement2.getTextContent());
                                        authorizationRuleInstance.setModifiedTime(modifiedTimeInstance);
                                    }
                                    
                                    Element primaryKeyElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "PrimaryKey");
                                    if (primaryKeyElement2 != null) {
                                        String primaryKeyInstance;
                                        primaryKeyInstance = primaryKeyElement2.getTextContent();
                                        authorizationRuleInstance.setPrimaryKey(primaryKeyInstance);
                                    }
                                    
                                    Element secondaryKeyElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SecondaryKey");
                                    if (secondaryKeyElement2 != null) {
                                        String secondaryKeyInstance;
                                        secondaryKeyInstance = secondaryKeyElement2.getTextContent();
                                        authorizationRuleInstance.setSecondaryKey(secondaryKeyInstance);
                                    }
                                }
                            }
                            
                            Element statusElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Status");
                            if (statusElement2 != null) {
                                String statusInstance;
                                statusInstance = statusElement2.getTextContent();
                                queueDescriptionInstance.setStatus(statusInstance);
                            }
                            
                            Element createdAtElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedAt");
                            if (createdAtElement != null) {
                                Calendar createdAtInstance;
                                createdAtInstance = DatatypeConverter.parseDateTime(createdAtElement.getTextContent());
                                queueDescriptionInstance.setCreatedAt(createdAtInstance);
                            }
                            
                            Element updatedAtElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "UpdatedAt");
                            if (updatedAtElement != null) {
                                Calendar updatedAtInstance;
                                updatedAtInstance = DatatypeConverter.parseDateTime(updatedAtElement.getTextContent());
                                queueDescriptionInstance.setUpdatedAt(updatedAtInstance);
                            }
                            
                            Element accessedAtElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessedAt");
                            if (accessedAtElement != null) {
                                Calendar accessedAtInstance;
                                accessedAtInstance = DatatypeConverter.parseDateTime(accessedAtElement.getTextContent());
                                queueDescriptionInstance.setAccessedAt(accessedAtInstance);
                            }
                            
                            Element supportOrderingElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SupportOrdering");
                            if (supportOrderingElement2 != null) {
                                boolean supportOrderingInstance;
                                supportOrderingInstance = DatatypeConverter.parseBoolean(supportOrderingElement2.getTextContent().toLowerCase());
                                queueDescriptionInstance.setSupportOrdering(supportOrderingInstance);
                            }
                            
                            Element countDetailsElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CountDetails");
                            if (countDetailsElement2 != null) {
                                CountDetails countDetailsInstance = new CountDetails();
                                queueDescriptionInstance.setCountDetails(countDetailsInstance);
                                
                                Element activeMessageCountElement2 = XmlUtility.getElementByTagNameNS(countDetailsElement2, "http://schemas.microsoft.com/netservices/2011/06/servicebus", "ActiveMessageCount");
                                if (activeMessageCountElement2 != null) {
                                    int activeMessageCountInstance;
                                    activeMessageCountInstance = DatatypeConverter.parseInt(activeMessageCountElement2.getTextContent());
                                    countDetailsInstance.setActiveMessageCount(activeMessageCountInstance);
                                }
                                
                                Element deadLetterMessageCountElement2 = XmlUtility.getElementByTagNameNS(countDetailsElement2, "http://schemas.microsoft.com/netservices/2011/06/servicebus", "DeadLetterMessageCount");
                                if (deadLetterMessageCountElement2 != null) {
                                    int deadLetterMessageCountInstance;
                                    deadLetterMessageCountInstance = DatatypeConverter.parseInt(deadLetterMessageCountElement2.getTextContent());
                                    countDetailsInstance.setDeadLetterMessageCount(deadLetterMessageCountInstance);
                                }
                                
                                Element scheduledMessageCountElement2 = XmlUtility.getElementByTagNameNS(countDetailsElement2, "http://schemas.microsoft.com/netservices/2011/06/servicebus", "ScheduledMessageCount");
                                if (scheduledMessageCountElement2 != null) {
                                    int scheduledMessageCountInstance;
                                    scheduledMessageCountInstance = DatatypeConverter.parseInt(scheduledMessageCountElement2.getTextContent());
                                    countDetailsInstance.setScheduledMessageCount(scheduledMessageCountInstance);
                                }
                                
                                Element transferDeadLetterMessageCountElement2 = XmlUtility.getElementByTagNameNS(countDetailsElement2, "http://schemas.microsoft.com/netservices/2011/06/servicebus", "TransferDeadLetterMessageCount");
                                if (transferDeadLetterMessageCountElement2 != null) {
                                    int transferDeadLetterMessageCountInstance;
                                    transferDeadLetterMessageCountInstance = DatatypeConverter.parseInt(transferDeadLetterMessageCountElement2.getTextContent());
                                    countDetailsInstance.setTransferDeadLetterMessageCount(transferDeadLetterMessageCountInstance);
                                }
                                
                                Element transferMessageCountElement2 = XmlUtility.getElementByTagNameNS(countDetailsElement2, "http://schemas.microsoft.com/netservices/2011/06/servicebus", "TransferMessageCount");
                                if (transferMessageCountElement2 != null) {
                                    int transferMessageCountInstance;
                                    transferMessageCountInstance = DatatypeConverter.parseInt(transferMessageCountElement2.getTextContent());
                                    countDetailsInstance.setTransferMessageCount(transferMessageCountInstance);
                                }
                            }
                            
                            Element autoDeleteOnIdleElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AutoDeleteOnIdle");
                            if (autoDeleteOnIdleElement2 != null) {
                                String autoDeleteOnIdleInstance;
                                autoDeleteOnIdleInstance = autoDeleteOnIdleElement2.getTextContent();
                                queueDescriptionInstance.setAutoDeleteOnIdle(autoDeleteOnIdleInstance);
                            }
                            
                            Element entityAvailabilityStatusElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EntityAvailabilityStatus");
                            if (entityAvailabilityStatusElement2 != null) {
                                String entityAvailabilityStatusInstance;
                                entityAvailabilityStatusInstance = entityAvailabilityStatusElement2.getTextContent();
                                queueDescriptionInstance.setEntityAvailabilityStatus(entityAvailabilityStatusInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Deletes an existing queue. This operation will also remove all associated
    * state including messages in the queue.  (see
    * http://msdn.microsoft.com/en-us/library/hh780747.aspx for more
    * information)
    *
    * @param namespaceName Required. The namespace name.
    * @param queueName Required. The queue name.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String namespaceName, final String queueName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(namespaceName, queueName);
            }
         });
    }
    
    /**
    * Deletes an existing queue. This operation will also remove all associated
    * state including messages in the queue.  (see
    * http://msdn.microsoft.com/en-us/library/hh780747.aspx for more
    * information)
    *
    * @param namespaceName Required. The namespace name.
    * @param queueName Required. The queue name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String namespaceName, String queueName) throws IOException, ServiceException {
        // Validate
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (queueName == null) {
            throw new NullPointerException("queueName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("queueName", queueName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/servicebus/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/Queues/";
        url = url + URLEncoder.encode(queueName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2013-08-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The queue description is an XML AtomPub document that defines the desired
    * semantics for a subscription. The queue description contains the
    * following properties. For more information, see the QueueDescription
    * Properties topic.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh780773.aspx for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @param queueName Required. The queue name.
    * @return A response to a request for a particular queue.
    */
    @Override
    public Future<ServiceBusQueueResponse> getAsync(final String namespaceName, final String queueName) {
        return this.getClient().getExecutorService().submit(new Callable<ServiceBusQueueResponse>() { 
            @Override
            public ServiceBusQueueResponse call() throws Exception {
                return get(namespaceName, queueName);
            }
         });
    }
    
    /**
    * The queue description is an XML AtomPub document that defines the desired
    * semantics for a subscription. The queue description contains the
    * following properties. For more information, see the QueueDescription
    * Properties topic.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh780773.aspx for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @param queueName Required. The queue name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return A response to a request for a particular queue.
    */
    @Override
    public ServiceBusQueueResponse get(String namespaceName, String queueName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        // Validate
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (queueName == null) {
            throw new NullPointerException("queueName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("queueName", queueName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/servicebus/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/Queues/";
        url = url + URLEncoder.encode(queueName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml; charset=utf-8");
        httpRequest.setHeader("x-ms-version", "2013-08-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ServiceBusQueueResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ServiceBusQueueResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element entryElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://www.w3.org/2005/Atom", "entry");
                if (entryElement != null) {
                    Element titleElement = XmlUtility.getElementByTagNameNS(entryElement, "http://www.w3.org/2005/Atom", "title");
                    if (titleElement != null) {
                    }
                    
                    Element contentElement = XmlUtility.getElementByTagNameNS(entryElement, "http://www.w3.org/2005/Atom", "content");
                    if (contentElement != null) {
                        Element queueDescriptionElement = XmlUtility.getElementByTagNameNS(contentElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "QueueDescription");
                        if (queueDescriptionElement != null) {
                            ServiceBusQueue queueDescriptionInstance = new ServiceBusQueue();
                            result.setQueue(queueDescriptionInstance);
                            
                            Element lockDurationElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "LockDuration");
                            if (lockDurationElement != null) {
                                String lockDurationInstance;
                                lockDurationInstance = lockDurationElement.getTextContent();
                                queueDescriptionInstance.setLockDuration(lockDurationInstance);
                            }
                            
                            Element maxSizeInMegabytesElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MaxSizeInMegabytes");
                            if (maxSizeInMegabytesElement != null) {
                                int maxSizeInMegabytesInstance;
                                maxSizeInMegabytesInstance = DatatypeConverter.parseInt(maxSizeInMegabytesElement.getTextContent());
                                queueDescriptionInstance.setMaxSizeInMegabytes(maxSizeInMegabytesInstance);
                            }
                            
                            Element requiresDuplicateDetectionElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "RequiresDuplicateDetection");
                            if (requiresDuplicateDetectionElement != null) {
                                boolean requiresDuplicateDetectionInstance;
                                requiresDuplicateDetectionInstance = DatatypeConverter.parseBoolean(requiresDuplicateDetectionElement.getTextContent().toLowerCase());
                                queueDescriptionInstance.setRequiresDuplicateDetection(requiresDuplicateDetectionInstance);
                            }
                            
                            Element requiresSessionElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "RequiresSession");
                            if (requiresSessionElement != null) {
                                boolean requiresSessionInstance;
                                requiresSessionInstance = DatatypeConverter.parseBoolean(requiresSessionElement.getTextContent().toLowerCase());
                                queueDescriptionInstance.setRequiresSession(requiresSessionInstance);
                            }
                            
                            Element defaultMessageTimeToLiveElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DefaultMessageTimeToLive");
                            if (defaultMessageTimeToLiveElement != null) {
                                String defaultMessageTimeToLiveInstance;
                                defaultMessageTimeToLiveInstance = defaultMessageTimeToLiveElement.getTextContent();
                                queueDescriptionInstance.setDefaultMessageTimeToLive(defaultMessageTimeToLiveInstance);
                            }
                            
                            Element deadLetteringOnMessageExpirationElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DeadLetteringOnMessageExpiration");
                            if (deadLetteringOnMessageExpirationElement != null) {
                                boolean deadLetteringOnMessageExpirationInstance;
                                deadLetteringOnMessageExpirationInstance = DatatypeConverter.parseBoolean(deadLetteringOnMessageExpirationElement.getTextContent().toLowerCase());
                                queueDescriptionInstance.setDeadLetteringOnMessageExpiration(deadLetteringOnMessageExpirationInstance);
                            }
                            
                            Element duplicateDetectionHistoryTimeWindowElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DuplicateDetectionHistoryTimeWindow");
                            if (duplicateDetectionHistoryTimeWindowElement != null) {
                                String duplicateDetectionHistoryTimeWindowInstance;
                                duplicateDetectionHistoryTimeWindowInstance = duplicateDetectionHistoryTimeWindowElement.getTextContent();
                                queueDescriptionInstance.setDuplicateDetectionHistoryTimeWindow(duplicateDetectionHistoryTimeWindowInstance);
                            }
                            
                            Element maxDeliveryCountElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MaxDeliveryCount");
                            if (maxDeliveryCountElement != null) {
                                int maxDeliveryCountInstance;
                                maxDeliveryCountInstance = DatatypeConverter.parseInt(maxDeliveryCountElement.getTextContent());
                                queueDescriptionInstance.setMaxDeliveryCount(maxDeliveryCountInstance);
                            }
                            
                            Element enableBatchedOperationsElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EnableBatchedOperations");
                            if (enableBatchedOperationsElement != null) {
                                boolean enableBatchedOperationsInstance;
                                enableBatchedOperationsInstance = DatatypeConverter.parseBoolean(enableBatchedOperationsElement.getTextContent().toLowerCase());
                                queueDescriptionInstance.setEnableBatchedOperations(enableBatchedOperationsInstance);
                            }
                            
                            Element sizeInBytesElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SizeInBytes");
                            if (sizeInBytesElement != null) {
                                int sizeInBytesInstance;
                                sizeInBytesInstance = DatatypeConverter.parseInt(sizeInBytesElement.getTextContent());
                                queueDescriptionInstance.setSizeInBytes(sizeInBytesInstance);
                            }
                            
                            Element messageCountElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MessageCount");
                            if (messageCountElement != null) {
                                int messageCountInstance;
                                messageCountInstance = DatatypeConverter.parseInt(messageCountElement.getTextContent());
                                queueDescriptionInstance.setMessageCount(messageCountInstance);
                            }
                            
                            Element isAnonymousAccessibleElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "IsAnonymousAccessible");
                            if (isAnonymousAccessibleElement != null) {
                                boolean isAnonymousAccessibleInstance;
                                isAnonymousAccessibleInstance = DatatypeConverter.parseBoolean(isAnonymousAccessibleElement.getTextContent().toLowerCase());
                                queueDescriptionInstance.setIsAnonymousAccessible(isAnonymousAccessibleInstance);
                            }
                            
                            Element authorizationRulesSequenceElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRules");
                            if (authorizationRulesSequenceElement != null) {
                                for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(authorizationRulesSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRule").size(); i1 = i1 + 1) {
                                    org.w3c.dom.Element authorizationRulesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(authorizationRulesSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRule").get(i1));
                                    ServiceBusSharedAccessAuthorizationRule authorizationRuleInstance = new ServiceBusSharedAccessAuthorizationRule();
                                    queueDescriptionInstance.getAuthorizationRules().add(authorizationRuleInstance);
                                    
                                    Element claimTypeElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimType");
                                    if (claimTypeElement != null) {
                                        String claimTypeInstance;
                                        claimTypeInstance = claimTypeElement.getTextContent();
                                        authorizationRuleInstance.setClaimType(claimTypeInstance);
                                    }
                                    
                                    Element claimValueElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimValue");
                                    if (claimValueElement != null) {
                                        String claimValueInstance;
                                        claimValueInstance = claimValueElement.getTextContent();
                                        authorizationRuleInstance.setClaimValue(claimValueInstance);
                                    }
                                    
                                    Element rightsSequenceElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Rights");
                                    if (rightsSequenceElement != null) {
                                        for (int i2 = 0; i2 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").size(); i2 = i2 + 1) {
                                            org.w3c.dom.Element rightsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").get(i2));
                                            authorizationRuleInstance.getRights().add(AccessRight.valueOf(rightsElement.getTextContent()));
                                        }
                                    }
                                    
                                    Element createdTimeElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedTime");
                                    if (createdTimeElement != null) {
                                        Calendar createdTimeInstance;
                                        createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeElement.getTextContent());
                                        authorizationRuleInstance.setCreatedTime(createdTimeInstance);
                                    }
                                    
                                    Element keyNameElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "KeyName");
                                    if (keyNameElement != null) {
                                        String keyNameInstance;
                                        keyNameInstance = keyNameElement.getTextContent();
                                        authorizationRuleInstance.setKeyName(keyNameInstance);
                                    }
                                    
                                    Element modifiedTimeElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ModifiedTime");
                                    if (modifiedTimeElement != null) {
                                        Calendar modifiedTimeInstance;
                                        modifiedTimeInstance = DatatypeConverter.parseDateTime(modifiedTimeElement.getTextContent());
                                        authorizationRuleInstance.setModifiedTime(modifiedTimeInstance);
                                    }
                                    
                                    Element primaryKeyElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "PrimaryKey");
                                    if (primaryKeyElement != null) {
                                        String primaryKeyInstance;
                                        primaryKeyInstance = primaryKeyElement.getTextContent();
                                        authorizationRuleInstance.setPrimaryKey(primaryKeyInstance);
                                    }
                                    
                                    Element secondaryKeyElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SecondaryKey");
                                    if (secondaryKeyElement != null) {
                                        String secondaryKeyInstance;
                                        secondaryKeyInstance = secondaryKeyElement.getTextContent();
                                        authorizationRuleInstance.setSecondaryKey(secondaryKeyInstance);
                                    }
                                }
                            }
                            
                            Element statusElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Status");
                            if (statusElement != null) {
                                String statusInstance;
                                statusInstance = statusElement.getTextContent();
                                queueDescriptionInstance.setStatus(statusInstance);
                            }
                            
                            Element createdAtElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedAt");
                            if (createdAtElement != null) {
                                Calendar createdAtInstance;
                                createdAtInstance = DatatypeConverter.parseDateTime(createdAtElement.getTextContent());
                                queueDescriptionInstance.setCreatedAt(createdAtInstance);
                            }
                            
                            Element updatedAtElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "UpdatedAt");
                            if (updatedAtElement != null) {
                                Calendar updatedAtInstance;
                                updatedAtInstance = DatatypeConverter.parseDateTime(updatedAtElement.getTextContent());
                                queueDescriptionInstance.setUpdatedAt(updatedAtInstance);
                            }
                            
                            Element accessedAtElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessedAt");
                            if (accessedAtElement != null) {
                                Calendar accessedAtInstance;
                                accessedAtInstance = DatatypeConverter.parseDateTime(accessedAtElement.getTextContent());
                                queueDescriptionInstance.setAccessedAt(accessedAtInstance);
                            }
                            
                            Element supportOrderingElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SupportOrdering");
                            if (supportOrderingElement != null) {
                                boolean supportOrderingInstance;
                                supportOrderingInstance = DatatypeConverter.parseBoolean(supportOrderingElement.getTextContent().toLowerCase());
                                queueDescriptionInstance.setSupportOrdering(supportOrderingInstance);
                            }
                            
                            Element countDetailsElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CountDetails");
                            if (countDetailsElement != null) {
                                CountDetails countDetailsInstance = new CountDetails();
                                queueDescriptionInstance.setCountDetails(countDetailsInstance);
                                
                                Element activeMessageCountElement = XmlUtility.getElementByTagNameNS(countDetailsElement, "http://schemas.microsoft.com/netservices/2011/06/servicebus", "ActiveMessageCount");
                                if (activeMessageCountElement != null) {
                                    int activeMessageCountInstance;
                                    activeMessageCountInstance = DatatypeConverter.parseInt(activeMessageCountElement.getTextContent());
                                    countDetailsInstance.setActiveMessageCount(activeMessageCountInstance);
                                }
                                
                                Element deadLetterMessageCountElement = XmlUtility.getElementByTagNameNS(countDetailsElement, "http://schemas.microsoft.com/netservices/2011/06/servicebus", "DeadLetterMessageCount");
                                if (deadLetterMessageCountElement != null) {
                                    int deadLetterMessageCountInstance;
                                    deadLetterMessageCountInstance = DatatypeConverter.parseInt(deadLetterMessageCountElement.getTextContent());
                                    countDetailsInstance.setDeadLetterMessageCount(deadLetterMessageCountInstance);
                                }
                                
                                Element scheduledMessageCountElement = XmlUtility.getElementByTagNameNS(countDetailsElement, "http://schemas.microsoft.com/netservices/2011/06/servicebus", "ScheduledMessageCount");
                                if (scheduledMessageCountElement != null) {
                                    int scheduledMessageCountInstance;
                                    scheduledMessageCountInstance = DatatypeConverter.parseInt(scheduledMessageCountElement.getTextContent());
                                    countDetailsInstance.setScheduledMessageCount(scheduledMessageCountInstance);
                                }
                                
                                Element transferDeadLetterMessageCountElement = XmlUtility.getElementByTagNameNS(countDetailsElement, "http://schemas.microsoft.com/netservices/2011/06/servicebus", "TransferDeadLetterMessageCount");
                                if (transferDeadLetterMessageCountElement != null) {
                                    int transferDeadLetterMessageCountInstance;
                                    transferDeadLetterMessageCountInstance = DatatypeConverter.parseInt(transferDeadLetterMessageCountElement.getTextContent());
                                    countDetailsInstance.setTransferDeadLetterMessageCount(transferDeadLetterMessageCountInstance);
                                }
                                
                                Element transferMessageCountElement = XmlUtility.getElementByTagNameNS(countDetailsElement, "http://schemas.microsoft.com/netservices/2011/06/servicebus", "TransferMessageCount");
                                if (transferMessageCountElement != null) {
                                    int transferMessageCountInstance;
                                    transferMessageCountInstance = DatatypeConverter.parseInt(transferMessageCountElement.getTextContent());
                                    countDetailsInstance.setTransferMessageCount(transferMessageCountInstance);
                                }
                            }
                            
                            Element autoDeleteOnIdleElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AutoDeleteOnIdle");
                            if (autoDeleteOnIdleElement != null) {
                                String autoDeleteOnIdleInstance;
                                autoDeleteOnIdleInstance = autoDeleteOnIdleElement.getTextContent();
                                queueDescriptionInstance.setAutoDeleteOnIdle(autoDeleteOnIdleInstance);
                            }
                            
                            Element entityAvailabilityStatusElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EntityAvailabilityStatus");
                            if (entityAvailabilityStatusElement != null) {
                                String entityAvailabilityStatusInstance;
                                entityAvailabilityStatusInstance = entityAvailabilityStatusElement.getTextContent();
                                queueDescriptionInstance.setEntityAvailabilityStatus(entityAvailabilityStatusInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets the set of connection strings for a queue.
    *
    * @param namespaceName Required. The namespace name.
    * @param queueName Required. The queue name.
    * @return The set of connection details for a service bus entity.
    */
    @Override
    public Future<ServiceBusConnectionDetailsResponse> getConnectionDetailsAsync(final String namespaceName, final String queueName) {
        return this.getClient().getExecutorService().submit(new Callable<ServiceBusConnectionDetailsResponse>() { 
            @Override
            public ServiceBusConnectionDetailsResponse call() throws Exception {
                return getConnectionDetails(namespaceName, queueName);
            }
         });
    }
    
    /**
    * Gets the set of connection strings for a queue.
    *
    * @param namespaceName Required. The namespace name.
    * @param queueName Required. The queue name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The set of connection details for a service bus entity.
    */
    @Override
    public ServiceBusConnectionDetailsResponse getConnectionDetails(String namespaceName, String queueName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (queueName == null) {
            throw new NullPointerException("queueName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("queueName", queueName);
            CloudTracing.enter(invocationId, this, "getConnectionDetailsAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/servicebus/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/Queues/";
        url = url + URLEncoder.encode(queueName, "UTF-8");
        url = url + "/ConnectionDetails";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml; charset=utf-8");
        httpRequest.setHeader("x-ms-version", "2013-08-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ServiceBusConnectionDetailsResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ServiceBusConnectionDetailsResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element feedElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://www.w3.org/2005/Atom", "feed");
                if (feedElement != null) {
                    if (feedElement != null) {
                        for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(feedElement, "http://www.w3.org/2005/Atom", "entry").size(); i1 = i1 + 1) {
                            org.w3c.dom.Element entriesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(feedElement, "http://www.w3.org/2005/Atom", "entry").get(i1));
                            ServiceBusConnectionDetail entryInstance = new ServiceBusConnectionDetail();
                            result.getConnectionDetails().add(entryInstance);
                            
                            Element contentElement = XmlUtility.getElementByTagNameNS(entriesElement, "http://www.w3.org/2005/Atom", "content");
                            if (contentElement != null) {
                                Element connectionDetailElement = XmlUtility.getElementByTagNameNS(contentElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ConnectionDetail");
                                if (connectionDetailElement != null) {
                                    Element keyNameElement = XmlUtility.getElementByTagNameNS(connectionDetailElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "KeyName");
                                    if (keyNameElement != null) {
                                        String keyNameInstance;
                                        keyNameInstance = keyNameElement.getTextContent();
                                        entryInstance.setKeyName(keyNameInstance);
                                    }
                                    
                                    Element connectionStringElement = XmlUtility.getElementByTagNameNS(connectionDetailElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ConnectionString");
                                    if (connectionStringElement != null) {
                                        String connectionStringInstance;
                                        connectionStringInstance = connectionStringElement.getTextContent();
                                        entryInstance.setConnectionString(connectionStringInstance);
                                    }
                                    
                                    Element authorizationTypeElement = XmlUtility.getElementByTagNameNS(connectionDetailElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationType");
                                    if (authorizationTypeElement != null) {
                                        String authorizationTypeInstance;
                                        authorizationTypeInstance = authorizationTypeElement.getTextContent();
                                        entryInstance.setAuthorizationType(authorizationTypeInstance);
                                    }
                                    
                                    Element rightsSequenceElement = XmlUtility.getElementByTagNameNS(connectionDetailElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Rights");
                                    if (rightsSequenceElement != null) {
                                        for (int i2 = 0; i2 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").size(); i2 = i2 + 1) {
                                            org.w3c.dom.Element rightsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").get(i2));
                                            entryInstance.getRights().add(AccessRight.valueOf(rightsElement.getTextContent()));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Enumerates the queues in the service namespace. The result is returned in
    * pages, each containing up to 100 queues. If the namespace contains more
    * than 100 queues, a feed is returned that contains the first page and a
    * next link with the URI to view the next page of data.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh780759.asp for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @return A response to a request for a list of queues.
    */
    @Override
    public Future<ServiceBusQueuesResponse> listAsync(final String namespaceName) {
        return this.getClient().getExecutorService().submit(new Callable<ServiceBusQueuesResponse>() { 
            @Override
            public ServiceBusQueuesResponse call() throws Exception {
                return list(namespaceName);
            }
         });
    }
    
    /**
    * Enumerates the queues in the service namespace. The result is returned in
    * pages, each containing up to 100 queues. If the namespace contains more
    * than 100 queues, a feed is returned that contains the first page and a
    * next link with the URI to view the next page of data.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh780759.asp for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return A response to a request for a list of queues.
    */
    @Override
    public ServiceBusQueuesResponse list(String namespaceName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        // Validate
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("namespaceName", namespaceName);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/servicebus/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/Queues";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml; charset=utf-8");
        httpRequest.setHeader("x-ms-version", "2013-08-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ServiceBusQueuesResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ServiceBusQueuesResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element feedElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://www.w3.org/2005/Atom", "feed");
                if (feedElement != null) {
                    if (feedElement != null) {
                        for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(feedElement, "http://www.w3.org/2005/Atom", "entry").size(); i1 = i1 + 1) {
                            org.w3c.dom.Element entriesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(feedElement, "http://www.w3.org/2005/Atom", "entry").get(i1));
                            ServiceBusQueue entryInstance = new ServiceBusQueue();
                            result.getQueues().add(entryInstance);
                            
                            Element titleElement = XmlUtility.getElementByTagNameNS(entriesElement, "http://www.w3.org/2005/Atom", "title");
                            if (titleElement != null) {
                                String titleInstance;
                                titleInstance = titleElement.getTextContent();
                                entryInstance.setName(titleInstance);
                            }
                            
                            Element contentElement = XmlUtility.getElementByTagNameNS(entriesElement, "http://www.w3.org/2005/Atom", "content");
                            if (contentElement != null) {
                                Element queueDescriptionElement = XmlUtility.getElementByTagNameNS(contentElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "QueueDescription");
                                if (queueDescriptionElement != null) {
                                    Element lockDurationElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "LockDuration");
                                    if (lockDurationElement != null) {
                                        String lockDurationInstance;
                                        lockDurationInstance = lockDurationElement.getTextContent();
                                        entryInstance.setLockDuration(lockDurationInstance);
                                    }
                                    
                                    Element maxSizeInMegabytesElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MaxSizeInMegabytes");
                                    if (maxSizeInMegabytesElement != null) {
                                        int maxSizeInMegabytesInstance;
                                        maxSizeInMegabytesInstance = DatatypeConverter.parseInt(maxSizeInMegabytesElement.getTextContent());
                                        entryInstance.setMaxSizeInMegabytes(maxSizeInMegabytesInstance);
                                    }
                                    
                                    Element requiresDuplicateDetectionElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "RequiresDuplicateDetection");
                                    if (requiresDuplicateDetectionElement != null) {
                                        boolean requiresDuplicateDetectionInstance;
                                        requiresDuplicateDetectionInstance = DatatypeConverter.parseBoolean(requiresDuplicateDetectionElement.getTextContent().toLowerCase());
                                        entryInstance.setRequiresDuplicateDetection(requiresDuplicateDetectionInstance);
                                    }
                                    
                                    Element requiresSessionElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "RequiresSession");
                                    if (requiresSessionElement != null) {
                                        boolean requiresSessionInstance;
                                        requiresSessionInstance = DatatypeConverter.parseBoolean(requiresSessionElement.getTextContent().toLowerCase());
                                        entryInstance.setRequiresSession(requiresSessionInstance);
                                    }
                                    
                                    Element defaultMessageTimeToLiveElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DefaultMessageTimeToLive");
                                    if (defaultMessageTimeToLiveElement != null) {
                                        String defaultMessageTimeToLiveInstance;
                                        defaultMessageTimeToLiveInstance = defaultMessageTimeToLiveElement.getTextContent();
                                        entryInstance.setDefaultMessageTimeToLive(defaultMessageTimeToLiveInstance);
                                    }
                                    
                                    Element deadLetteringOnMessageExpirationElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DeadLetteringOnMessageExpiration");
                                    if (deadLetteringOnMessageExpirationElement != null) {
                                        boolean deadLetteringOnMessageExpirationInstance;
                                        deadLetteringOnMessageExpirationInstance = DatatypeConverter.parseBoolean(deadLetteringOnMessageExpirationElement.getTextContent().toLowerCase());
                                        entryInstance.setDeadLetteringOnMessageExpiration(deadLetteringOnMessageExpirationInstance);
                                    }
                                    
                                    Element duplicateDetectionHistoryTimeWindowElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DuplicateDetectionHistoryTimeWindow");
                                    if (duplicateDetectionHistoryTimeWindowElement != null) {
                                        String duplicateDetectionHistoryTimeWindowInstance;
                                        duplicateDetectionHistoryTimeWindowInstance = duplicateDetectionHistoryTimeWindowElement.getTextContent();
                                        entryInstance.setDuplicateDetectionHistoryTimeWindow(duplicateDetectionHistoryTimeWindowInstance);
                                    }
                                    
                                    Element maxDeliveryCountElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MaxDeliveryCount");
                                    if (maxDeliveryCountElement != null) {
                                        int maxDeliveryCountInstance;
                                        maxDeliveryCountInstance = DatatypeConverter.parseInt(maxDeliveryCountElement.getTextContent());
                                        entryInstance.setMaxDeliveryCount(maxDeliveryCountInstance);
                                    }
                                    
                                    Element enableBatchedOperationsElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EnableBatchedOperations");
                                    if (enableBatchedOperationsElement != null) {
                                        boolean enableBatchedOperationsInstance;
                                        enableBatchedOperationsInstance = DatatypeConverter.parseBoolean(enableBatchedOperationsElement.getTextContent().toLowerCase());
                                        entryInstance.setEnableBatchedOperations(enableBatchedOperationsInstance);
                                    }
                                    
                                    Element sizeInBytesElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SizeInBytes");
                                    if (sizeInBytesElement != null) {
                                        int sizeInBytesInstance;
                                        sizeInBytesInstance = DatatypeConverter.parseInt(sizeInBytesElement.getTextContent());
                                        entryInstance.setSizeInBytes(sizeInBytesInstance);
                                    }
                                    
                                    Element messageCountElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MessageCount");
                                    if (messageCountElement != null) {
                                        int messageCountInstance;
                                        messageCountInstance = DatatypeConverter.parseInt(messageCountElement.getTextContent());
                                        entryInstance.setMessageCount(messageCountInstance);
                                    }
                                    
                                    Element isAnonymousAccessibleElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "IsAnonymousAccessible");
                                    if (isAnonymousAccessibleElement != null) {
                                        boolean isAnonymousAccessibleInstance;
                                        isAnonymousAccessibleInstance = DatatypeConverter.parseBoolean(isAnonymousAccessibleElement.getTextContent().toLowerCase());
                                        entryInstance.setIsAnonymousAccessible(isAnonymousAccessibleInstance);
                                    }
                                    
                                    Element authorizationRulesSequenceElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRules");
                                    if (authorizationRulesSequenceElement != null) {
                                        for (int i2 = 0; i2 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(authorizationRulesSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRule").size(); i2 = i2 + 1) {
                                            org.w3c.dom.Element authorizationRulesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(authorizationRulesSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRule").get(i2));
                                            ServiceBusSharedAccessAuthorizationRule authorizationRuleInstance = new ServiceBusSharedAccessAuthorizationRule();
                                            entryInstance.getAuthorizationRules().add(authorizationRuleInstance);
                                            
                                            Element claimTypeElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimType");
                                            if (claimTypeElement != null) {
                                                String claimTypeInstance;
                                                claimTypeInstance = claimTypeElement.getTextContent();
                                                authorizationRuleInstance.setClaimType(claimTypeInstance);
                                            }
                                            
                                            Element claimValueElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimValue");
                                            if (claimValueElement != null) {
                                                String claimValueInstance;
                                                claimValueInstance = claimValueElement.getTextContent();
                                                authorizationRuleInstance.setClaimValue(claimValueInstance);
                                            }
                                            
                                            Element rightsSequenceElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Rights");
                                            if (rightsSequenceElement != null) {
                                                for (int i3 = 0; i3 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").size(); i3 = i3 + 1) {
                                                    org.w3c.dom.Element rightsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").get(i3));
                                                    authorizationRuleInstance.getRights().add(AccessRight.valueOf(rightsElement.getTextContent()));
                                                }
                                            }
                                            
                                            Element createdTimeElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedTime");
                                            if (createdTimeElement != null) {
                                                Calendar createdTimeInstance;
                                                createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeElement.getTextContent());
                                                authorizationRuleInstance.setCreatedTime(createdTimeInstance);
                                            }
                                            
                                            Element keyNameElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "KeyName");
                                            if (keyNameElement != null) {
                                                String keyNameInstance;
                                                keyNameInstance = keyNameElement.getTextContent();
                                                authorizationRuleInstance.setKeyName(keyNameInstance);
                                            }
                                            
                                            Element modifiedTimeElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ModifiedTime");
                                            if (modifiedTimeElement != null) {
                                                Calendar modifiedTimeInstance;
                                                modifiedTimeInstance = DatatypeConverter.parseDateTime(modifiedTimeElement.getTextContent());
                                                authorizationRuleInstance.setModifiedTime(modifiedTimeInstance);
                                            }
                                            
                                            Element primaryKeyElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "PrimaryKey");
                                            if (primaryKeyElement != null) {
                                                String primaryKeyInstance;
                                                primaryKeyInstance = primaryKeyElement.getTextContent();
                                                authorizationRuleInstance.setPrimaryKey(primaryKeyInstance);
                                            }
                                            
                                            Element secondaryKeyElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SecondaryKey");
                                            if (secondaryKeyElement != null) {
                                                String secondaryKeyInstance;
                                                secondaryKeyInstance = secondaryKeyElement.getTextContent();
                                                authorizationRuleInstance.setSecondaryKey(secondaryKeyInstance);
                                            }
                                        }
                                    }
                                    
                                    Element statusElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Status");
                                    if (statusElement != null) {
                                        String statusInstance;
                                        statusInstance = statusElement.getTextContent();
                                        entryInstance.setStatus(statusInstance);
                                    }
                                    
                                    Element createdAtElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedAt");
                                    if (createdAtElement != null) {
                                        Calendar createdAtInstance;
                                        createdAtInstance = DatatypeConverter.parseDateTime(createdAtElement.getTextContent());
                                        entryInstance.setCreatedAt(createdAtInstance);
                                    }
                                    
                                    Element updatedAtElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "UpdatedAt");
                                    if (updatedAtElement != null) {
                                        Calendar updatedAtInstance;
                                        updatedAtInstance = DatatypeConverter.parseDateTime(updatedAtElement.getTextContent());
                                        entryInstance.setUpdatedAt(updatedAtInstance);
                                    }
                                    
                                    Element accessedAtElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessedAt");
                                    if (accessedAtElement != null) {
                                        Calendar accessedAtInstance;
                                        accessedAtInstance = DatatypeConverter.parseDateTime(accessedAtElement.getTextContent());
                                        entryInstance.setAccessedAt(accessedAtInstance);
                                    }
                                    
                                    Element supportOrderingElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SupportOrdering");
                                    if (supportOrderingElement != null) {
                                        boolean supportOrderingInstance;
                                        supportOrderingInstance = DatatypeConverter.parseBoolean(supportOrderingElement.getTextContent().toLowerCase());
                                        entryInstance.setSupportOrdering(supportOrderingInstance);
                                    }
                                    
                                    Element countDetailsElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CountDetails");
                                    if (countDetailsElement != null) {
                                        CountDetails countDetailsInstance = new CountDetails();
                                        entryInstance.setCountDetails(countDetailsInstance);
                                        
                                        Element activeMessageCountElement = XmlUtility.getElementByTagNameNS(countDetailsElement, "http://schemas.microsoft.com/netservices/2011/06/servicebus", "ActiveMessageCount");
                                        if (activeMessageCountElement != null) {
                                            int activeMessageCountInstance;
                                            activeMessageCountInstance = DatatypeConverter.parseInt(activeMessageCountElement.getTextContent());
                                            countDetailsInstance.setActiveMessageCount(activeMessageCountInstance);
                                        }
                                        
                                        Element deadLetterMessageCountElement = XmlUtility.getElementByTagNameNS(countDetailsElement, "http://schemas.microsoft.com/netservices/2011/06/servicebus", "DeadLetterMessageCount");
                                        if (deadLetterMessageCountElement != null) {
                                            int deadLetterMessageCountInstance;
                                            deadLetterMessageCountInstance = DatatypeConverter.parseInt(deadLetterMessageCountElement.getTextContent());
                                            countDetailsInstance.setDeadLetterMessageCount(deadLetterMessageCountInstance);
                                        }
                                        
                                        Element scheduledMessageCountElement = XmlUtility.getElementByTagNameNS(countDetailsElement, "http://schemas.microsoft.com/netservices/2011/06/servicebus", "ScheduledMessageCount");
                                        if (scheduledMessageCountElement != null) {
                                            int scheduledMessageCountInstance;
                                            scheduledMessageCountInstance = DatatypeConverter.parseInt(scheduledMessageCountElement.getTextContent());
                                            countDetailsInstance.setScheduledMessageCount(scheduledMessageCountInstance);
                                        }
                                        
                                        Element transferDeadLetterMessageCountElement = XmlUtility.getElementByTagNameNS(countDetailsElement, "http://schemas.microsoft.com/netservices/2011/06/servicebus", "TransferDeadLetterMessageCount");
                                        if (transferDeadLetterMessageCountElement != null) {
                                            int transferDeadLetterMessageCountInstance;
                                            transferDeadLetterMessageCountInstance = DatatypeConverter.parseInt(transferDeadLetterMessageCountElement.getTextContent());
                                            countDetailsInstance.setTransferDeadLetterMessageCount(transferDeadLetterMessageCountInstance);
                                        }
                                        
                                        Element transferMessageCountElement = XmlUtility.getElementByTagNameNS(countDetailsElement, "http://schemas.microsoft.com/netservices/2011/06/servicebus", "TransferMessageCount");
                                        if (transferMessageCountElement != null) {
                                            int transferMessageCountInstance;
                                            transferMessageCountInstance = DatatypeConverter.parseInt(transferMessageCountElement.getTextContent());
                                            countDetailsInstance.setTransferMessageCount(transferMessageCountInstance);
                                        }
                                    }
                                    
                                    Element autoDeleteOnIdleElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AutoDeleteOnIdle");
                                    if (autoDeleteOnIdleElement != null) {
                                        String autoDeleteOnIdleInstance;
                                        autoDeleteOnIdleInstance = autoDeleteOnIdleElement.getTextContent();
                                        entryInstance.setAutoDeleteOnIdle(autoDeleteOnIdleInstance);
                                    }
                                    
                                    Element entityAvailabilityStatusElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EntityAvailabilityStatus");
                                    if (entityAvailabilityStatusElement != null) {
                                        String entityAvailabilityStatusInstance;
                                        entityAvailabilityStatusInstance = entityAvailabilityStatusElement.getTextContent();
                                        entryInstance.setEntityAvailabilityStatus(entityAvailabilityStatusInstance);
                                    }
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Updates the queue description and makes a call to update corresponding DB
    * entries.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj856305.aspx for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @param queue Required. The service bus queue.
    * @return A response to a request for a particular queue.
    */
    @Override
    public Future<ServiceBusQueueResponse> updateAsync(final String namespaceName, final ServiceBusQueue queue) {
        return this.getClient().getExecutorService().submit(new Callable<ServiceBusQueueResponse>() { 
            @Override
            public ServiceBusQueueResponse call() throws Exception {
                return update(namespaceName, queue);
            }
         });
    }
    
    /**
    * Updates the queue description and makes a call to update corresponding DB
    * entries.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj856305.aspx for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @param queue Required. The service bus queue.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A response to a request for a particular queue.
    */
    @Override
    public ServiceBusQueueResponse update(String namespaceName, ServiceBusQueue queue) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (queue == null) {
            throw new NullPointerException("queue");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("queue", queue);
            CloudTracing.enter(invocationId, this, "updateAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/servicebus/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/queues/";
        if (queue.getName() != null) {
            url = url + URLEncoder.encode(queue.getName(), "UTF-8");
        }
        url = url + "/";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/atom+xml");
        httpRequest.setHeader("if-match", "*");
        httpRequest.setHeader("type", "entry");
        httpRequest.setHeader("x-ms-version", "2013-08-01");
        httpRequest.setHeader("x-process-at", "ServiceBus");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element entryElement = requestDoc.createElementNS("http://www.w3.org/2005/Atom", "entry");
        requestDoc.appendChild(entryElement);
        
        Element contentElement = requestDoc.createElementNS("http://www.w3.org/2005/Atom", "content");
        entryElement.appendChild(contentElement);
        
        Attr typeAttribute = requestDoc.createAttribute("type");
        typeAttribute.setValue("application/atom+xml;type=entry;charset=utf-8");
        contentElement.setAttributeNode(typeAttribute);
        
        Element queueDescriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "QueueDescription");
        contentElement.appendChild(queueDescriptionElement);
        
        if (queue.getLockDuration() != null) {
            Element lockDurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "LockDuration");
            lockDurationElement.appendChild(requestDoc.createTextNode(queue.getLockDuration()));
            queueDescriptionElement.appendChild(lockDurationElement);
        }
        
        Element maxSizeInMegabytesElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MaxSizeInMegabytes");
        maxSizeInMegabytesElement.appendChild(requestDoc.createTextNode(Integer.toString(queue.getMaxSizeInMegabytes())));
        queueDescriptionElement.appendChild(maxSizeInMegabytesElement);
        
        Element requiresDuplicateDetectionElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "RequiresDuplicateDetection");
        requiresDuplicateDetectionElement.appendChild(requestDoc.createTextNode(Boolean.toString(queue.isRequiresDuplicateDetection()).toLowerCase()));
        queueDescriptionElement.appendChild(requiresDuplicateDetectionElement);
        
        Element requiresSessionElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "RequiresSession");
        requiresSessionElement.appendChild(requestDoc.createTextNode(Boolean.toString(queue.isRequiresSession()).toLowerCase()));
        queueDescriptionElement.appendChild(requiresSessionElement);
        
        if (queue.getDefaultMessageTimeToLive() != null) {
            Element defaultMessageTimeToLiveElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DefaultMessageTimeToLive");
            defaultMessageTimeToLiveElement.appendChild(requestDoc.createTextNode(queue.getDefaultMessageTimeToLive()));
            queueDescriptionElement.appendChild(defaultMessageTimeToLiveElement);
        }
        
        Element deadLetteringOnMessageExpirationElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DeadLetteringOnMessageExpiration");
        deadLetteringOnMessageExpirationElement.appendChild(requestDoc.createTextNode(Boolean.toString(queue.isDeadLetteringOnMessageExpiration()).toLowerCase()));
        queueDescriptionElement.appendChild(deadLetteringOnMessageExpirationElement);
        
        if (queue.getDuplicateDetectionHistoryTimeWindow() != null) {
            Element duplicateDetectionHistoryTimeWindowElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DuplicateDetectionHistoryTimeWindow");
            duplicateDetectionHistoryTimeWindowElement.appendChild(requestDoc.createTextNode(queue.getDuplicateDetectionHistoryTimeWindow()));
            queueDescriptionElement.appendChild(duplicateDetectionHistoryTimeWindowElement);
        }
        
        Element enableBatchedOperationsElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EnableBatchedOperations");
        enableBatchedOperationsElement.appendChild(requestDoc.createTextNode(Boolean.toString(queue.isEnableBatchedOperations()).toLowerCase()));
        queueDescriptionElement.appendChild(enableBatchedOperationsElement);
        
        Element sizeInBytesElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SizeInBytes");
        sizeInBytesElement.appendChild(requestDoc.createTextNode(Integer.toString(queue.getSizeInBytes())));
        queueDescriptionElement.appendChild(sizeInBytesElement);
        
        Element messageCountElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MessageCount");
        messageCountElement.appendChild(requestDoc.createTextNode(Integer.toString(queue.getMessageCount())));
        queueDescriptionElement.appendChild(messageCountElement);
        
        Element isAnonymousAccessibleElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "IsAnonymousAccessible");
        isAnonymousAccessibleElement.appendChild(requestDoc.createTextNode(Boolean.toString(queue.isAnonymousAccessible()).toLowerCase()));
        queueDescriptionElement.appendChild(isAnonymousAccessibleElement);
        
        if (queue.getAuthorizationRules() != null) {
            if (queue.getAuthorizationRules() instanceof LazyCollection == false || ((LazyCollection) queue.getAuthorizationRules()).isInitialized()) {
                Element authorizationRulesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRules");
                for (ServiceBusSharedAccessAuthorizationRule authorizationRulesItem : queue.getAuthorizationRules()) {
                    Element authorizationRuleElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRule");
                    authorizationRulesSequenceElement.appendChild(authorizationRuleElement);
                    
                    Attr typeAttribute2 = requestDoc.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                    typeAttribute2.setValue("SharedAccessAuthorizationRule");
                    authorizationRuleElement.setAttributeNode(typeAttribute2);
                    
                    if (authorizationRulesItem.getClaimType() != null) {
                        Element claimTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimType");
                        claimTypeElement.appendChild(requestDoc.createTextNode(authorizationRulesItem.getClaimType()));
                        authorizationRuleElement.appendChild(claimTypeElement);
                    }
                    
                    if (authorizationRulesItem.getClaimValue() != null) {
                        Element claimValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimValue");
                        claimValueElement.appendChild(requestDoc.createTextNode(authorizationRulesItem.getClaimValue()));
                        authorizationRuleElement.appendChild(claimValueElement);
                    }
                    
                    if (authorizationRulesItem.getRights() != null) {
                        if (authorizationRulesItem.getRights() instanceof LazyCollection == false || ((LazyCollection) authorizationRulesItem.getRights()).isInitialized()) {
                            Element rightsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Rights");
                            for (AccessRight rightsItem : authorizationRulesItem.getRights()) {
                                Element rightsItemElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights");
                                rightsItemElement.appendChild(requestDoc.createTextNode(rightsItem.toString()));
                                rightsSequenceElement.appendChild(rightsItemElement);
                            }
                            authorizationRuleElement.appendChild(rightsSequenceElement);
                        }
                    }
                    
                    Element createdTimeElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedTime");
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    createdTimeElement.appendChild(requestDoc.createTextNode(simpleDateFormat.format(authorizationRulesItem.getCreatedTime().getTime())));
                    authorizationRuleElement.appendChild(createdTimeElement);
                    
                    if (authorizationRulesItem.getKeyName() != null) {
                        Element keyNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "KeyName");
                        keyNameElement.appendChild(requestDoc.createTextNode(authorizationRulesItem.getKeyName()));
                        authorizationRuleElement.appendChild(keyNameElement);
                    }
                    
                    Element modifiedTimeElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ModifiedTime");
                    SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
                    modifiedTimeElement.appendChild(requestDoc.createTextNode(simpleDateFormat2.format(authorizationRulesItem.getModifiedTime().getTime())));
                    authorizationRuleElement.appendChild(modifiedTimeElement);
                    
                    if (authorizationRulesItem.getPrimaryKey() != null) {
                        Element primaryKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "PrimaryKey");
                        primaryKeyElement.appendChild(requestDoc.createTextNode(authorizationRulesItem.getPrimaryKey()));
                        authorizationRuleElement.appendChild(primaryKeyElement);
                    }
                    
                    if (authorizationRulesItem.getSecondaryKey() != null) {
                        Element secondaryKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SecondaryKey");
                        secondaryKeyElement.appendChild(requestDoc.createTextNode(authorizationRulesItem.getSecondaryKey()));
                        authorizationRuleElement.appendChild(secondaryKeyElement);
                    }
                }
                queueDescriptionElement.appendChild(authorizationRulesSequenceElement);
            }
        }
        
        if (queue.getStatus() != null) {
            Element statusElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Status");
            statusElement.appendChild(requestDoc.createTextNode(queue.getStatus()));
            queueDescriptionElement.appendChild(statusElement);
        }
        
        Element supportOrderingElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SupportOrdering");
        supportOrderingElement.appendChild(requestDoc.createTextNode(Boolean.toString(queue.isSupportOrdering()).toLowerCase()));
        queueDescriptionElement.appendChild(supportOrderingElement);
        
        if (queue.getCountDetails() != null) {
            Element countDetailsElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CountDetails");
            queueDescriptionElement.appendChild(countDetailsElement);
            
            Element activeMessageCountElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2011/06/servicebus", "ActiveMessageCount");
            activeMessageCountElement.appendChild(requestDoc.createTextNode(Integer.toString(queue.getCountDetails().getActiveMessageCount())));
            countDetailsElement.appendChild(activeMessageCountElement);
            
            Element deadLetterMessageCountElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2011/06/servicebus", "DeadLetterMessageCount");
            deadLetterMessageCountElement.appendChild(requestDoc.createTextNode(Integer.toString(queue.getCountDetails().getDeadLetterMessageCount())));
            countDetailsElement.appendChild(deadLetterMessageCountElement);
            
            Element scheduledMessageCountElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2011/06/servicebus", "ScheduledMessageCount");
            scheduledMessageCountElement.appendChild(requestDoc.createTextNode(Integer.toString(queue.getCountDetails().getScheduledMessageCount())));
            countDetailsElement.appendChild(scheduledMessageCountElement);
            
            Element transferDeadLetterMessageCountElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2011/06/servicebus", "TransferDeadLetterMessageCount");
            transferDeadLetterMessageCountElement.appendChild(requestDoc.createTextNode(Integer.toString(queue.getCountDetails().getTransferDeadLetterMessageCount())));
            countDetailsElement.appendChild(transferDeadLetterMessageCountElement);
            
            Element transferMessageCountElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2011/06/servicebus", "TransferMessageCount");
            transferMessageCountElement.appendChild(requestDoc.createTextNode(Integer.toString(queue.getCountDetails().getTransferMessageCount())));
            countDetailsElement.appendChild(transferMessageCountElement);
        }
        
        if (queue.getAutoDeleteOnIdle() != null) {
            Element autoDeleteOnIdleElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AutoDeleteOnIdle");
            autoDeleteOnIdleElement.appendChild(requestDoc.createTextNode(queue.getAutoDeleteOnIdle()));
            queueDescriptionElement.appendChild(autoDeleteOnIdleElement);
        }
        
        if (queue.getEntityAvailabilityStatus() != null) {
            Element entityAvailabilityStatusElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EntityAvailabilityStatus");
            entityAvailabilityStatusElement.appendChild(requestDoc.createTextNode(queue.getEntityAvailabilityStatus()));
            queueDescriptionElement.appendChild(entityAvailabilityStatusElement);
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/atom+xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ServiceBusQueueResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ServiceBusQueueResponse();
                DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
                documentBuilderFactory2.setNamespaceAware(true);
                DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
                Document responseDoc = documentBuilder2.parse(new BOMInputStream(responseContent));
                
                Element entryElement2 = XmlUtility.getElementByTagNameNS(responseDoc, "http://www.w3.org/2005/Atom", "entry");
                if (entryElement2 != null) {
                    Element titleElement = XmlUtility.getElementByTagNameNS(entryElement2, "http://www.w3.org/2005/Atom", "title");
                    if (titleElement != null) {
                    }
                    
                    Element contentElement2 = XmlUtility.getElementByTagNameNS(entryElement2, "http://www.w3.org/2005/Atom", "content");
                    if (contentElement2 != null) {
                        Element queueDescriptionElement2 = XmlUtility.getElementByTagNameNS(contentElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "QueueDescription");
                        if (queueDescriptionElement2 != null) {
                            ServiceBusQueue queueDescriptionInstance = new ServiceBusQueue();
                            result.setQueue(queueDescriptionInstance);
                            
                            Element lockDurationElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "LockDuration");
                            if (lockDurationElement2 != null) {
                                String lockDurationInstance;
                                lockDurationInstance = lockDurationElement2.getTextContent();
                                queueDescriptionInstance.setLockDuration(lockDurationInstance);
                            }
                            
                            Element maxSizeInMegabytesElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MaxSizeInMegabytes");
                            if (maxSizeInMegabytesElement2 != null) {
                                int maxSizeInMegabytesInstance;
                                maxSizeInMegabytesInstance = DatatypeConverter.parseInt(maxSizeInMegabytesElement2.getTextContent());
                                queueDescriptionInstance.setMaxSizeInMegabytes(maxSizeInMegabytesInstance);
                            }
                            
                            Element requiresDuplicateDetectionElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "RequiresDuplicateDetection");
                            if (requiresDuplicateDetectionElement2 != null) {
                                boolean requiresDuplicateDetectionInstance;
                                requiresDuplicateDetectionInstance = DatatypeConverter.parseBoolean(requiresDuplicateDetectionElement2.getTextContent().toLowerCase());
                                queueDescriptionInstance.setRequiresDuplicateDetection(requiresDuplicateDetectionInstance);
                            }
                            
                            Element requiresSessionElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "RequiresSession");
                            if (requiresSessionElement2 != null) {
                                boolean requiresSessionInstance;
                                requiresSessionInstance = DatatypeConverter.parseBoolean(requiresSessionElement2.getTextContent().toLowerCase());
                                queueDescriptionInstance.setRequiresSession(requiresSessionInstance);
                            }
                            
                            Element defaultMessageTimeToLiveElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DefaultMessageTimeToLive");
                            if (defaultMessageTimeToLiveElement2 != null) {
                                String defaultMessageTimeToLiveInstance;
                                defaultMessageTimeToLiveInstance = defaultMessageTimeToLiveElement2.getTextContent();
                                queueDescriptionInstance.setDefaultMessageTimeToLive(defaultMessageTimeToLiveInstance);
                            }
                            
                            Element deadLetteringOnMessageExpirationElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DeadLetteringOnMessageExpiration");
                            if (deadLetteringOnMessageExpirationElement2 != null) {
                                boolean deadLetteringOnMessageExpirationInstance;
                                deadLetteringOnMessageExpirationInstance = DatatypeConverter.parseBoolean(deadLetteringOnMessageExpirationElement2.getTextContent().toLowerCase());
                                queueDescriptionInstance.setDeadLetteringOnMessageExpiration(deadLetteringOnMessageExpirationInstance);
                            }
                            
                            Element duplicateDetectionHistoryTimeWindowElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DuplicateDetectionHistoryTimeWindow");
                            if (duplicateDetectionHistoryTimeWindowElement2 != null) {
                                String duplicateDetectionHistoryTimeWindowInstance;
                                duplicateDetectionHistoryTimeWindowInstance = duplicateDetectionHistoryTimeWindowElement2.getTextContent();
                                queueDescriptionInstance.setDuplicateDetectionHistoryTimeWindow(duplicateDetectionHistoryTimeWindowInstance);
                            }
                            
                            Element maxDeliveryCountElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MaxDeliveryCount");
                            if (maxDeliveryCountElement != null) {
                                int maxDeliveryCountInstance;
                                maxDeliveryCountInstance = DatatypeConverter.parseInt(maxDeliveryCountElement.getTextContent());
                                queueDescriptionInstance.setMaxDeliveryCount(maxDeliveryCountInstance);
                            }
                            
                            Element enableBatchedOperationsElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EnableBatchedOperations");
                            if (enableBatchedOperationsElement2 != null) {
                                boolean enableBatchedOperationsInstance;
                                enableBatchedOperationsInstance = DatatypeConverter.parseBoolean(enableBatchedOperationsElement2.getTextContent().toLowerCase());
                                queueDescriptionInstance.setEnableBatchedOperations(enableBatchedOperationsInstance);
                            }
                            
                            Element sizeInBytesElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SizeInBytes");
                            if (sizeInBytesElement2 != null) {
                                int sizeInBytesInstance;
                                sizeInBytesInstance = DatatypeConverter.parseInt(sizeInBytesElement2.getTextContent());
                                queueDescriptionInstance.setSizeInBytes(sizeInBytesInstance);
                            }
                            
                            Element messageCountElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MessageCount");
                            if (messageCountElement2 != null) {
                                int messageCountInstance;
                                messageCountInstance = DatatypeConverter.parseInt(messageCountElement2.getTextContent());
                                queueDescriptionInstance.setMessageCount(messageCountInstance);
                            }
                            
                            Element isAnonymousAccessibleElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "IsAnonymousAccessible");
                            if (isAnonymousAccessibleElement2 != null) {
                                boolean isAnonymousAccessibleInstance;
                                isAnonymousAccessibleInstance = DatatypeConverter.parseBoolean(isAnonymousAccessibleElement2.getTextContent().toLowerCase());
                                queueDescriptionInstance.setIsAnonymousAccessible(isAnonymousAccessibleInstance);
                            }
                            
                            Element authorizationRulesSequenceElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRules");
                            if (authorizationRulesSequenceElement2 != null) {
                                for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(authorizationRulesSequenceElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRule").size(); i1 = i1 + 1) {
                                    org.w3c.dom.Element authorizationRulesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(authorizationRulesSequenceElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRule").get(i1));
                                    ServiceBusSharedAccessAuthorizationRule authorizationRuleInstance = new ServiceBusSharedAccessAuthorizationRule();
                                    queueDescriptionInstance.getAuthorizationRules().add(authorizationRuleInstance);
                                    
                                    Element claimTypeElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimType");
                                    if (claimTypeElement2 != null) {
                                        String claimTypeInstance;
                                        claimTypeInstance = claimTypeElement2.getTextContent();
                                        authorizationRuleInstance.setClaimType(claimTypeInstance);
                                    }
                                    
                                    Element claimValueElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimValue");
                                    if (claimValueElement2 != null) {
                                        String claimValueInstance;
                                        claimValueInstance = claimValueElement2.getTextContent();
                                        authorizationRuleInstance.setClaimValue(claimValueInstance);
                                    }
                                    
                                    Element rightsSequenceElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Rights");
                                    if (rightsSequenceElement2 != null) {
                                        for (int i2 = 0; i2 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").size(); i2 = i2 + 1) {
                                            org.w3c.dom.Element rightsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").get(i2));
                                            authorizationRuleInstance.getRights().add(AccessRight.valueOf(rightsElement.getTextContent()));
                                        }
                                    }
                                    
                                    Element createdTimeElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedTime");
                                    if (createdTimeElement2 != null) {
                                        Calendar createdTimeInstance;
                                        createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeElement2.getTextContent());
                                        authorizationRuleInstance.setCreatedTime(createdTimeInstance);
                                    }
                                    
                                    Element keyNameElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "KeyName");
                                    if (keyNameElement2 != null) {
                                        String keyNameInstance;
                                        keyNameInstance = keyNameElement2.getTextContent();
                                        authorizationRuleInstance.setKeyName(keyNameInstance);
                                    }
                                    
                                    Element modifiedTimeElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ModifiedTime");
                                    if (modifiedTimeElement2 != null) {
                                        Calendar modifiedTimeInstance;
                                        modifiedTimeInstance = DatatypeConverter.parseDateTime(modifiedTimeElement2.getTextContent());
                                        authorizationRuleInstance.setModifiedTime(modifiedTimeInstance);
                                    }
                                    
                                    Element primaryKeyElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "PrimaryKey");
                                    if (primaryKeyElement2 != null) {
                                        String primaryKeyInstance;
                                        primaryKeyInstance = primaryKeyElement2.getTextContent();
                                        authorizationRuleInstance.setPrimaryKey(primaryKeyInstance);
                                    }
                                    
                                    Element secondaryKeyElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SecondaryKey");
                                    if (secondaryKeyElement2 != null) {
                                        String secondaryKeyInstance;
                                        secondaryKeyInstance = secondaryKeyElement2.getTextContent();
                                        authorizationRuleInstance.setSecondaryKey(secondaryKeyInstance);
                                    }
                                }
                            }
                            
                            Element statusElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Status");
                            if (statusElement2 != null) {
                                String statusInstance;
                                statusInstance = statusElement2.getTextContent();
                                queueDescriptionInstance.setStatus(statusInstance);
                            }
                            
                            Element createdAtElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedAt");
                            if (createdAtElement != null) {
                                Calendar createdAtInstance;
                                createdAtInstance = DatatypeConverter.parseDateTime(createdAtElement.getTextContent());
                                queueDescriptionInstance.setCreatedAt(createdAtInstance);
                            }
                            
                            Element updatedAtElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "UpdatedAt");
                            if (updatedAtElement != null) {
                                Calendar updatedAtInstance;
                                updatedAtInstance = DatatypeConverter.parseDateTime(updatedAtElement.getTextContent());
                                queueDescriptionInstance.setUpdatedAt(updatedAtInstance);
                            }
                            
                            Element accessedAtElement = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessedAt");
                            if (accessedAtElement != null) {
                                Calendar accessedAtInstance;
                                accessedAtInstance = DatatypeConverter.parseDateTime(accessedAtElement.getTextContent());
                                queueDescriptionInstance.setAccessedAt(accessedAtInstance);
                            }
                            
                            Element supportOrderingElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SupportOrdering");
                            if (supportOrderingElement2 != null) {
                                boolean supportOrderingInstance;
                                supportOrderingInstance = DatatypeConverter.parseBoolean(supportOrderingElement2.getTextContent().toLowerCase());
                                queueDescriptionInstance.setSupportOrdering(supportOrderingInstance);
                            }
                            
                            Element countDetailsElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CountDetails");
                            if (countDetailsElement2 != null) {
                                CountDetails countDetailsInstance = new CountDetails();
                                queueDescriptionInstance.setCountDetails(countDetailsInstance);
                                
                                Element activeMessageCountElement2 = XmlUtility.getElementByTagNameNS(countDetailsElement2, "http://schemas.microsoft.com/netservices/2011/06/servicebus", "ActiveMessageCount");
                                if (activeMessageCountElement2 != null) {
                                    int activeMessageCountInstance;
                                    activeMessageCountInstance = DatatypeConverter.parseInt(activeMessageCountElement2.getTextContent());
                                    countDetailsInstance.setActiveMessageCount(activeMessageCountInstance);
                                }
                                
                                Element deadLetterMessageCountElement2 = XmlUtility.getElementByTagNameNS(countDetailsElement2, "http://schemas.microsoft.com/netservices/2011/06/servicebus", "DeadLetterMessageCount");
                                if (deadLetterMessageCountElement2 != null) {
                                    int deadLetterMessageCountInstance;
                                    deadLetterMessageCountInstance = DatatypeConverter.parseInt(deadLetterMessageCountElement2.getTextContent());
                                    countDetailsInstance.setDeadLetterMessageCount(deadLetterMessageCountInstance);
                                }
                                
                                Element scheduledMessageCountElement2 = XmlUtility.getElementByTagNameNS(countDetailsElement2, "http://schemas.microsoft.com/netservices/2011/06/servicebus", "ScheduledMessageCount");
                                if (scheduledMessageCountElement2 != null) {
                                    int scheduledMessageCountInstance;
                                    scheduledMessageCountInstance = DatatypeConverter.parseInt(scheduledMessageCountElement2.getTextContent());
                                    countDetailsInstance.setScheduledMessageCount(scheduledMessageCountInstance);
                                }
                                
                                Element transferDeadLetterMessageCountElement2 = XmlUtility.getElementByTagNameNS(countDetailsElement2, "http://schemas.microsoft.com/netservices/2011/06/servicebus", "TransferDeadLetterMessageCount");
                                if (transferDeadLetterMessageCountElement2 != null) {
                                    int transferDeadLetterMessageCountInstance;
                                    transferDeadLetterMessageCountInstance = DatatypeConverter.parseInt(transferDeadLetterMessageCountElement2.getTextContent());
                                    countDetailsInstance.setTransferDeadLetterMessageCount(transferDeadLetterMessageCountInstance);
                                }
                                
                                Element transferMessageCountElement2 = XmlUtility.getElementByTagNameNS(countDetailsElement2, "http://schemas.microsoft.com/netservices/2011/06/servicebus", "TransferMessageCount");
                                if (transferMessageCountElement2 != null) {
                                    int transferMessageCountInstance;
                                    transferMessageCountInstance = DatatypeConverter.parseInt(transferMessageCountElement2.getTextContent());
                                    countDetailsInstance.setTransferMessageCount(transferMessageCountInstance);
                                }
                            }
                            
                            Element autoDeleteOnIdleElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AutoDeleteOnIdle");
                            if (autoDeleteOnIdleElement2 != null) {
                                String autoDeleteOnIdleInstance;
                                autoDeleteOnIdleInstance = autoDeleteOnIdleElement2.getTextContent();
                                queueDescriptionInstance.setAutoDeleteOnIdle(autoDeleteOnIdleInstance);
                            }
                            
                            Element entityAvailabilityStatusElement2 = XmlUtility.getElementByTagNameNS(queueDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EntityAvailabilityStatus");
                            if (entityAvailabilityStatusElement2 != null) {
                                String entityAvailabilityStatusInstance;
                                entityAvailabilityStatusInstance = entityAvailabilityStatusElement2.getTextContent();
                                queueDescriptionInstance.setEntityAvailabilityStatus(entityAvailabilityStatusInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
