/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.servicebus;

import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.servicebus.models.AccessRight;
import com.microsoft.windowsazure.management.servicebus.models.CountDetails;
import com.microsoft.windowsazure.management.servicebus.models.ServiceBusConnectionDetail;
import com.microsoft.windowsazure.management.servicebus.models.ServiceBusConnectionDetailsResponse;
import com.microsoft.windowsazure.management.servicebus.models.ServiceBusSharedAccessAuthorizationRule;
import com.microsoft.windowsazure.management.servicebus.models.ServiceBusTopic;
import com.microsoft.windowsazure.management.servicebus.models.ServiceBusTopicResponse;
import com.microsoft.windowsazure.management.servicebus.models.ServiceBusTopicsResponse;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
* The Service Bus Management API includes operations for managing Service Bus
* topics for a namespace.
*/
public class TopicOperationsImpl implements ServiceOperations<ServiceBusManagementClientImpl>, TopicOperations {
    /**
    * Initializes a new instance of the TopicOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    TopicOperationsImpl(ServiceBusManagementClientImpl client) {
        this.client = client;
    }
    
    private ServiceBusManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.windowsazure.management.servicebus.ServiceBusManagementClientImpl.
    * @return The Client value.
    */
    public ServiceBusManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Creates a new topic. Once created, this topic resource manifest is
    * immutable. This operation is not idempotent. Repeating the create call,
    * after a topic with same name has been created successfully, will result
    * in a 409 Conflict error message.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh780728.aspx for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @param topic Required. The Service Bus topic.
    * @return A response to a request for a particular topic.
    */
    @Override
    public Future<ServiceBusTopicResponse> createAsync(final String namespaceName, final ServiceBusTopic topic) {
        return this.getClient().getExecutorService().submit(new Callable<ServiceBusTopicResponse>() { 
            @Override
            public ServiceBusTopicResponse call() throws Exception {
                return create(namespaceName, topic);
            }
         });
    }
    
    /**
    * Creates a new topic. Once created, this topic resource manifest is
    * immutable. This operation is not idempotent. Repeating the create call,
    * after a topic with same name has been created successfully, will result
    * in a 409 Conflict error message.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh780728.aspx for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @param topic Required. The Service Bus topic.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return A response to a request for a particular topic.
    */
    @Override
    public ServiceBusTopicResponse create(String namespaceName, ServiceBusTopic topic) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException, URISyntaxException {
        // Validate
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (topic == null) {
            throw new NullPointerException("topic");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("topic", topic);
            CloudTracing.enter(invocationId, this, "createAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/servicebus/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/topics/";
        if (topic.getName() != null) {
            url = url + URLEncoder.encode(topic.getName(), "UTF-8");
        }
        url = url + "/";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/atom+xml");
        httpRequest.setHeader("type", "entry");
        httpRequest.setHeader("x-ms-version", "2013-08-01");
        httpRequest.setHeader("x-process-at", "ServiceBus");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element entryElement = requestDoc.createElementNS("http://www.w3.org/2005/Atom", "entry");
        requestDoc.appendChild(entryElement);
        
        Element contentElement = requestDoc.createElementNS("http://www.w3.org/2005/Atom", "content");
        entryElement.appendChild(contentElement);
        
        Attr typeAttribute = requestDoc.createAttribute("type");
        typeAttribute.setValue("application/atom+xml;type=entry;charset=utf-8");
        contentElement.setAttributeNode(typeAttribute);
        
        Element topicDescriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "TopicDescription");
        contentElement.appendChild(topicDescriptionElement);
        
        if (topic.getDefaultMessageTimeToLive() != null) {
            Element defaultMessageTimeToLiveElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DefaultMessageTimeToLive");
            defaultMessageTimeToLiveElement.appendChild(requestDoc.createTextNode(topic.getDefaultMessageTimeToLive()));
            topicDescriptionElement.appendChild(defaultMessageTimeToLiveElement);
        }
        
        Element maxSizeInMegabytesElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MaxSizeInMegabytes");
        maxSizeInMegabytesElement.appendChild(requestDoc.createTextNode(Integer.toString(topic.getMaxSizeInMegabytes())));
        topicDescriptionElement.appendChild(maxSizeInMegabytesElement);
        
        Element requiresDuplicateDetectionElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "RequiresDuplicateDetection");
        requiresDuplicateDetectionElement.appendChild(requestDoc.createTextNode(Boolean.toString(topic.isRequiresDuplicateDetection()).toLowerCase()));
        topicDescriptionElement.appendChild(requiresDuplicateDetectionElement);
        
        if (topic.getDuplicateDetectionHistoryTimeWindow() != null) {
            Element duplicateDetectionHistoryTimeWindowElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DuplicateDetectionHistoryTimeWindow");
            duplicateDetectionHistoryTimeWindowElement.appendChild(requestDoc.createTextNode(topic.getDuplicateDetectionHistoryTimeWindow()));
            topicDescriptionElement.appendChild(duplicateDetectionHistoryTimeWindowElement);
        }
        
        Element enableBatchedOperationsElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EnableBatchedOperations");
        enableBatchedOperationsElement.appendChild(requestDoc.createTextNode(Boolean.toString(topic.isEnableBatchedOperations()).toLowerCase()));
        topicDescriptionElement.appendChild(enableBatchedOperationsElement);
        
        Element sizeInBytesElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SizeInBytes");
        sizeInBytesElement.appendChild(requestDoc.createTextNode(Integer.toString(topic.getSizeInBytes())));
        topicDescriptionElement.appendChild(sizeInBytesElement);
        
        Element filteringMessagesBeforePublishingElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "FilteringMessagesBeforePublishing");
        filteringMessagesBeforePublishingElement.appendChild(requestDoc.createTextNode(Boolean.toString(topic.isFilteringMessagesBeforePublishing()).toLowerCase()));
        topicDescriptionElement.appendChild(filteringMessagesBeforePublishingElement);
        
        Element isAnonymousAccessibleElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "IsAnonymousAccessible");
        isAnonymousAccessibleElement.appendChild(requestDoc.createTextNode(Boolean.toString(topic.isAnonymousAccessible()).toLowerCase()));
        topicDescriptionElement.appendChild(isAnonymousAccessibleElement);
        
        if (topic.getAuthorizationRules() != null) {
            if (topic.getAuthorizationRules() instanceof LazyCollection == false || ((LazyCollection) topic.getAuthorizationRules()).isInitialized()) {
                Element authorizationRulesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRules");
                for (ServiceBusSharedAccessAuthorizationRule authorizationRulesItem : topic.getAuthorizationRules()) {
                    Element authorizationRuleElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRule");
                    authorizationRulesSequenceElement.appendChild(authorizationRuleElement);
                    
                    Attr typeAttribute2 = requestDoc.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                    typeAttribute2.setValue("SharedAccessAuthorizationRule");
                    authorizationRuleElement.setAttributeNode(typeAttribute2);
                    
                    if (authorizationRulesItem.getClaimType() != null) {
                        Element claimTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimType");
                        claimTypeElement.appendChild(requestDoc.createTextNode(authorizationRulesItem.getClaimType()));
                        authorizationRuleElement.appendChild(claimTypeElement);
                    }
                    
                    if (authorizationRulesItem.getClaimValue() != null) {
                        Element claimValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimValue");
                        claimValueElement.appendChild(requestDoc.createTextNode(authorizationRulesItem.getClaimValue()));
                        authorizationRuleElement.appendChild(claimValueElement);
                    }
                    
                    if (authorizationRulesItem.getRights() != null) {
                        if (authorizationRulesItem.getRights() instanceof LazyCollection == false || ((LazyCollection) authorizationRulesItem.getRights()).isInitialized()) {
                            Element rightsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Rights");
                            for (AccessRight rightsItem : authorizationRulesItem.getRights()) {
                                Element rightsItemElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights");
                                rightsItemElement.appendChild(requestDoc.createTextNode(rightsItem.toString()));
                                rightsSequenceElement.appendChild(rightsItemElement);
                            }
                            authorizationRuleElement.appendChild(rightsSequenceElement);
                        }
                    }
                    
                    Element createdTimeElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedTime");
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    createdTimeElement.appendChild(requestDoc.createTextNode(simpleDateFormat.format(authorizationRulesItem.getCreatedTime().getTime())));
                    authorizationRuleElement.appendChild(createdTimeElement);
                    
                    if (authorizationRulesItem.getKeyName() != null) {
                        Element keyNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "KeyName");
                        keyNameElement.appendChild(requestDoc.createTextNode(authorizationRulesItem.getKeyName()));
                        authorizationRuleElement.appendChild(keyNameElement);
                    }
                    
                    Element modifiedTimeElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ModifiedTime");
                    SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
                    modifiedTimeElement.appendChild(requestDoc.createTextNode(simpleDateFormat2.format(authorizationRulesItem.getModifiedTime().getTime())));
                    authorizationRuleElement.appendChild(modifiedTimeElement);
                    
                    if (authorizationRulesItem.getPrimaryKey() != null) {
                        Element primaryKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "PrimaryKey");
                        primaryKeyElement.appendChild(requestDoc.createTextNode(authorizationRulesItem.getPrimaryKey()));
                        authorizationRuleElement.appendChild(primaryKeyElement);
                    }
                    
                    if (authorizationRulesItem.getSecondaryKey() != null) {
                        Element secondaryKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SecondaryKey");
                        secondaryKeyElement.appendChild(requestDoc.createTextNode(authorizationRulesItem.getSecondaryKey()));
                        authorizationRuleElement.appendChild(secondaryKeyElement);
                    }
                }
                topicDescriptionElement.appendChild(authorizationRulesSequenceElement);
            }
        }
        
        if (topic.getStatus() != null) {
            Element statusElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Status");
            statusElement.appendChild(requestDoc.createTextNode(topic.getStatus()));
            topicDescriptionElement.appendChild(statusElement);
        }
        
        Element createdAtElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedAt");
        SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat3.setTimeZone(TimeZone.getTimeZone("UTC"));
        createdAtElement.appendChild(requestDoc.createTextNode(simpleDateFormat3.format(topic.getCreatedAt().getTime())));
        topicDescriptionElement.appendChild(createdAtElement);
        
        Element updatedAtElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "UpdatedAt");
        SimpleDateFormat simpleDateFormat4 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat4.setTimeZone(TimeZone.getTimeZone("UTC"));
        updatedAtElement.appendChild(requestDoc.createTextNode(simpleDateFormat4.format(topic.getUpdatedAt().getTime())));
        topicDescriptionElement.appendChild(updatedAtElement);
        
        Element accessedAtElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessedAt");
        SimpleDateFormat simpleDateFormat5 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat5.setTimeZone(TimeZone.getTimeZone("UTC"));
        accessedAtElement.appendChild(requestDoc.createTextNode(simpleDateFormat5.format(topic.getAccessedAt().getTime())));
        topicDescriptionElement.appendChild(accessedAtElement);
        
        Element supportOrderingElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SupportOrdering");
        supportOrderingElement.appendChild(requestDoc.createTextNode(Boolean.toString(topic.isSupportOrdering()).toLowerCase()));
        topicDescriptionElement.appendChild(supportOrderingElement);
        
        if (topic.getCountDetails() != null) {
            Element countDetailsElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CountDetails");
            topicDescriptionElement.appendChild(countDetailsElement);
            
            Element activeMessageCountElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2011/06/servicebus", "ActiveMessageCount");
            activeMessageCountElement.appendChild(requestDoc.createTextNode(Integer.toString(topic.getCountDetails().getActiveMessageCount())));
            countDetailsElement.appendChild(activeMessageCountElement);
            
            Element deadLetterMessageCountElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2011/06/servicebus", "DeadLetterMessageCount");
            deadLetterMessageCountElement.appendChild(requestDoc.createTextNode(Integer.toString(topic.getCountDetails().getDeadLetterMessageCount())));
            countDetailsElement.appendChild(deadLetterMessageCountElement);
            
            Element scheduledMessageCountElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2011/06/servicebus", "ScheduledMessageCount");
            scheduledMessageCountElement.appendChild(requestDoc.createTextNode(Integer.toString(topic.getCountDetails().getScheduledMessageCount())));
            countDetailsElement.appendChild(scheduledMessageCountElement);
            
            Element transferDeadLetterMessageCountElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2011/06/servicebus", "TransferDeadLetterMessageCount");
            transferDeadLetterMessageCountElement.appendChild(requestDoc.createTextNode(Integer.toString(topic.getCountDetails().getTransferDeadLetterMessageCount())));
            countDetailsElement.appendChild(transferDeadLetterMessageCountElement);
            
            Element transferMessageCountElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2011/06/servicebus", "TransferMessageCount");
            transferMessageCountElement.appendChild(requestDoc.createTextNode(Integer.toString(topic.getCountDetails().getTransferMessageCount())));
            countDetailsElement.appendChild(transferMessageCountElement);
        }
        
        Element subscriptionCountElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SubscriptionCount");
        subscriptionCountElement.appendChild(requestDoc.createTextNode(Integer.toString(topic.getSubscriptionCount())));
        topicDescriptionElement.appendChild(subscriptionCountElement);
        
        if (topic.getAutoDeleteOnIdle() != null) {
            Element autoDeleteOnIdleElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AutoDeleteOnIdle");
            autoDeleteOnIdleElement.appendChild(requestDoc.createTextNode(topic.getAutoDeleteOnIdle()));
            topicDescriptionElement.appendChild(autoDeleteOnIdleElement);
        }
        
        if (topic.getEntityAvailabilityStatus() != null) {
            Element entityAvailabilityStatusElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EntityAvailabilityStatus");
            entityAvailabilityStatusElement.appendChild(requestDoc.createTextNode(topic.getEntityAvailabilityStatus()));
            topicDescriptionElement.appendChild(entityAvailabilityStatusElement);
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/atom+xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ServiceBusTopicResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ServiceBusTopicResponse();
                DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
                documentBuilderFactory2.setNamespaceAware(true);
                DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
                Document responseDoc = documentBuilder2.parse(new BOMInputStream(responseContent));
                
                Element entryElement2 = XmlUtility.getElementByTagNameNS(responseDoc, "http://www.w3.org/2005/Atom", "entry");
                if (entryElement2 != null) {
                    Element titleElement = XmlUtility.getElementByTagNameNS(entryElement2, "http://www.w3.org/2005/Atom", "title");
                    if (titleElement != null) {
                    }
                    
                    Element contentElement2 = XmlUtility.getElementByTagNameNS(entryElement2, "http://www.w3.org/2005/Atom", "content");
                    if (contentElement2 != null) {
                        Element topicDescriptionElement2 = XmlUtility.getElementByTagNameNS(contentElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "TopicDescription");
                        if (topicDescriptionElement2 != null) {
                            ServiceBusTopic topicDescriptionInstance = new ServiceBusTopic();
                            result.setTopic(topicDescriptionInstance);
                            
                            Element defaultMessageTimeToLiveElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DefaultMessageTimeToLive");
                            if (defaultMessageTimeToLiveElement2 != null) {
                                String defaultMessageTimeToLiveInstance;
                                defaultMessageTimeToLiveInstance = defaultMessageTimeToLiveElement2.getTextContent();
                                topicDescriptionInstance.setDefaultMessageTimeToLive(defaultMessageTimeToLiveInstance);
                            }
                            
                            Element maxSizeInMegabytesElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MaxSizeInMegabytes");
                            if (maxSizeInMegabytesElement2 != null) {
                                int maxSizeInMegabytesInstance;
                                maxSizeInMegabytesInstance = DatatypeConverter.parseInt(maxSizeInMegabytesElement2.getTextContent());
                                topicDescriptionInstance.setMaxSizeInMegabytes(maxSizeInMegabytesInstance);
                            }
                            
                            Element requiresDuplicateDetectionElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "RequiresDuplicateDetection");
                            if (requiresDuplicateDetectionElement2 != null) {
                                boolean requiresDuplicateDetectionInstance;
                                requiresDuplicateDetectionInstance = DatatypeConverter.parseBoolean(requiresDuplicateDetectionElement2.getTextContent().toLowerCase());
                                topicDescriptionInstance.setRequiresDuplicateDetection(requiresDuplicateDetectionInstance);
                            }
                            
                            Element duplicateDetectionHistoryTimeWindowElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DuplicateDetectionHistoryTimeWindow");
                            if (duplicateDetectionHistoryTimeWindowElement2 != null) {
                                String duplicateDetectionHistoryTimeWindowInstance;
                                duplicateDetectionHistoryTimeWindowInstance = duplicateDetectionHistoryTimeWindowElement2.getTextContent();
                                topicDescriptionInstance.setDuplicateDetectionHistoryTimeWindow(duplicateDetectionHistoryTimeWindowInstance);
                            }
                            
                            Element enableBatchedOperationsElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EnableBatchedOperations");
                            if (enableBatchedOperationsElement2 != null) {
                                boolean enableBatchedOperationsInstance;
                                enableBatchedOperationsInstance = DatatypeConverter.parseBoolean(enableBatchedOperationsElement2.getTextContent().toLowerCase());
                                topicDescriptionInstance.setEnableBatchedOperations(enableBatchedOperationsInstance);
                            }
                            
                            Element sizeInBytesElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SizeInBytes");
                            if (sizeInBytesElement2 != null) {
                                int sizeInBytesInstance;
                                sizeInBytesInstance = DatatypeConverter.parseInt(sizeInBytesElement2.getTextContent());
                                topicDescriptionInstance.setSizeInBytes(sizeInBytesInstance);
                            }
                            
                            Element filteringMessagesBeforePublishingElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "FilteringMessagesBeforePublishing");
                            if (filteringMessagesBeforePublishingElement2 != null) {
                                boolean filteringMessagesBeforePublishingInstance;
                                filteringMessagesBeforePublishingInstance = DatatypeConverter.parseBoolean(filteringMessagesBeforePublishingElement2.getTextContent().toLowerCase());
                                topicDescriptionInstance.setFilteringMessagesBeforePublishing(filteringMessagesBeforePublishingInstance);
                            }
                            
                            Element isAnonymousAccessibleElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "IsAnonymousAccessible");
                            if (isAnonymousAccessibleElement2 != null) {
                                boolean isAnonymousAccessibleInstance;
                                isAnonymousAccessibleInstance = DatatypeConverter.parseBoolean(isAnonymousAccessibleElement2.getTextContent().toLowerCase());
                                topicDescriptionInstance.setIsAnonymousAccessible(isAnonymousAccessibleInstance);
                            }
                            
                            Element authorizationRulesSequenceElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRules");
                            if (authorizationRulesSequenceElement2 != null) {
                                for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(authorizationRulesSequenceElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRule").size(); i1 = i1 + 1) {
                                    org.w3c.dom.Element authorizationRulesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(authorizationRulesSequenceElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRule").get(i1));
                                    ServiceBusSharedAccessAuthorizationRule authorizationRuleInstance = new ServiceBusSharedAccessAuthorizationRule();
                                    topicDescriptionInstance.getAuthorizationRules().add(authorizationRuleInstance);
                                    
                                    Element claimTypeElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimType");
                                    if (claimTypeElement2 != null) {
                                        String claimTypeInstance;
                                        claimTypeInstance = claimTypeElement2.getTextContent();
                                        authorizationRuleInstance.setClaimType(claimTypeInstance);
                                    }
                                    
                                    Element claimValueElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimValue");
                                    if (claimValueElement2 != null) {
                                        String claimValueInstance;
                                        claimValueInstance = claimValueElement2.getTextContent();
                                        authorizationRuleInstance.setClaimValue(claimValueInstance);
                                    }
                                    
                                    Element rightsSequenceElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Rights");
                                    if (rightsSequenceElement2 != null) {
                                        for (int i2 = 0; i2 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").size(); i2 = i2 + 1) {
                                            org.w3c.dom.Element rightsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").get(i2));
                                            authorizationRuleInstance.getRights().add(AccessRight.valueOf(rightsElement.getTextContent()));
                                        }
                                    }
                                    
                                    Element createdTimeElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedTime");
                                    if (createdTimeElement2 != null) {
                                        Calendar createdTimeInstance;
                                        createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeElement2.getTextContent());
                                        authorizationRuleInstance.setCreatedTime(createdTimeInstance);
                                    }
                                    
                                    Element keyNameElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "KeyName");
                                    if (keyNameElement2 != null) {
                                        String keyNameInstance;
                                        keyNameInstance = keyNameElement2.getTextContent();
                                        authorizationRuleInstance.setKeyName(keyNameInstance);
                                    }
                                    
                                    Element modifiedTimeElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ModifiedTime");
                                    if (modifiedTimeElement2 != null) {
                                        Calendar modifiedTimeInstance;
                                        modifiedTimeInstance = DatatypeConverter.parseDateTime(modifiedTimeElement2.getTextContent());
                                        authorizationRuleInstance.setModifiedTime(modifiedTimeInstance);
                                    }
                                    
                                    Element primaryKeyElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "PrimaryKey");
                                    if (primaryKeyElement2 != null) {
                                        String primaryKeyInstance;
                                        primaryKeyInstance = primaryKeyElement2.getTextContent();
                                        authorizationRuleInstance.setPrimaryKey(primaryKeyInstance);
                                    }
                                    
                                    Element secondaryKeyElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SecondaryKey");
                                    if (secondaryKeyElement2 != null) {
                                        String secondaryKeyInstance;
                                        secondaryKeyInstance = secondaryKeyElement2.getTextContent();
                                        authorizationRuleInstance.setSecondaryKey(secondaryKeyInstance);
                                    }
                                }
                            }
                            
                            Element statusElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Status");
                            if (statusElement2 != null) {
                                String statusInstance;
                                statusInstance = statusElement2.getTextContent();
                                topicDescriptionInstance.setStatus(statusInstance);
                            }
                            
                            Element createdAtElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedAt");
                            if (createdAtElement2 != null) {
                                Calendar createdAtInstance;
                                createdAtInstance = DatatypeConverter.parseDateTime(createdAtElement2.getTextContent());
                                topicDescriptionInstance.setCreatedAt(createdAtInstance);
                            }
                            
                            Element updatedAtElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "UpdatedAt");
                            if (updatedAtElement2 != null) {
                                Calendar updatedAtInstance;
                                updatedAtInstance = DatatypeConverter.parseDateTime(updatedAtElement2.getTextContent());
                                topicDescriptionInstance.setUpdatedAt(updatedAtInstance);
                            }
                            
                            Element accessedAtElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessedAt");
                            if (accessedAtElement2 != null) {
                                Calendar accessedAtInstance;
                                accessedAtInstance = DatatypeConverter.parseDateTime(accessedAtElement2.getTextContent());
                                topicDescriptionInstance.setAccessedAt(accessedAtInstance);
                            }
                            
                            Element supportOrderingElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SupportOrdering");
                            if (supportOrderingElement2 != null) {
                                boolean supportOrderingInstance;
                                supportOrderingInstance = DatatypeConverter.parseBoolean(supportOrderingElement2.getTextContent().toLowerCase());
                                topicDescriptionInstance.setSupportOrdering(supportOrderingInstance);
                            }
                            
                            Element countDetailsElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CountDetails");
                            if (countDetailsElement2 != null) {
                                CountDetails countDetailsInstance = new CountDetails();
                                topicDescriptionInstance.setCountDetails(countDetailsInstance);
                            }
                            
                            Element subscriptionCountElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SubscriptionCount");
                            if (subscriptionCountElement2 != null) {
                                int subscriptionCountInstance;
                                subscriptionCountInstance = DatatypeConverter.parseInt(subscriptionCountElement2.getTextContent());
                                topicDescriptionInstance.setSubscriptionCount(subscriptionCountInstance);
                            }
                            
                            Element autoDeleteOnIdleElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AutoDeleteOnIdle");
                            if (autoDeleteOnIdleElement2 != null) {
                                String autoDeleteOnIdleInstance;
                                autoDeleteOnIdleInstance = autoDeleteOnIdleElement2.getTextContent();
                                topicDescriptionInstance.setAutoDeleteOnIdle(autoDeleteOnIdleInstance);
                            }
                            
                            Element entityAvailabilityStatusElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EntityAvailabilityStatus");
                            if (entityAvailabilityStatusElement2 != null) {
                                String entityAvailabilityStatusInstance;
                                entityAvailabilityStatusInstance = entityAvailabilityStatusElement2.getTextContent();
                                topicDescriptionInstance.setEntityAvailabilityStatus(entityAvailabilityStatusInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Deletes an existing topic. This operation will also remove all associated
    * state including associated subscriptions.  (see
    * http://msdn.microsoft.com/en-us/library/hh780721.aspx for more
    * information)
    *
    * @param namespaceName Required. The namespace name.
    * @param topicName Required. The topic.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String namespaceName, final String topicName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(namespaceName, topicName);
            }
         });
    }
    
    /**
    * Deletes an existing topic. This operation will also remove all associated
    * state including associated subscriptions.  (see
    * http://msdn.microsoft.com/en-us/library/hh780721.aspx for more
    * information)
    *
    * @param namespaceName Required. The namespace name.
    * @param topicName Required. The topic.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String namespaceName, String topicName) throws IOException, ServiceException {
        // Validate
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (topicName == null) {
            throw new NullPointerException("topicName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("topicName", topicName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/servicebus/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/topics/";
        url = url + URLEncoder.encode(topicName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2013-08-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The topic description is an XML AtomPub document that defines the desired
    * semantics for a topic. The topic description contains the following
    * properties. For more information, see the TopicDescription Properties
    * topic.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh780749.aspx for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @param topicName Required. The topic.
    * @return A response to a request for a particular topic.
    */
    @Override
    public Future<ServiceBusTopicResponse> getAsync(final String namespaceName, final String topicName) {
        return this.getClient().getExecutorService().submit(new Callable<ServiceBusTopicResponse>() { 
            @Override
            public ServiceBusTopicResponse call() throws Exception {
                return get(namespaceName, topicName);
            }
         });
    }
    
    /**
    * The topic description is an XML AtomPub document that defines the desired
    * semantics for a topic. The topic description contains the following
    * properties. For more information, see the TopicDescription Properties
    * topic.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh780749.aspx for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @param topicName Required. The topic.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return A response to a request for a particular topic.
    */
    @Override
    public ServiceBusTopicResponse get(String namespaceName, String topicName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        // Validate
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (topicName == null) {
            throw new NullPointerException("topicName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("topicName", topicName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/servicebus/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/topics/";
        url = url + URLEncoder.encode(topicName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml; charset=utf-8");
        httpRequest.setHeader("x-ms-version", "2013-08-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ServiceBusTopicResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ServiceBusTopicResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element entryElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://www.w3.org/2005/Atom", "entry");
                if (entryElement != null) {
                    Element titleElement = XmlUtility.getElementByTagNameNS(entryElement, "http://www.w3.org/2005/Atom", "title");
                    if (titleElement != null) {
                    }
                    
                    Element contentElement = XmlUtility.getElementByTagNameNS(entryElement, "http://www.w3.org/2005/Atom", "content");
                    if (contentElement != null) {
                        Element topicDescriptionElement = XmlUtility.getElementByTagNameNS(contentElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "TopicDescription");
                        if (topicDescriptionElement != null) {
                            ServiceBusTopic topicDescriptionInstance = new ServiceBusTopic();
                            result.setTopic(topicDescriptionInstance);
                            
                            Element defaultMessageTimeToLiveElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DefaultMessageTimeToLive");
                            if (defaultMessageTimeToLiveElement != null) {
                                String defaultMessageTimeToLiveInstance;
                                defaultMessageTimeToLiveInstance = defaultMessageTimeToLiveElement.getTextContent();
                                topicDescriptionInstance.setDefaultMessageTimeToLive(defaultMessageTimeToLiveInstance);
                            }
                            
                            Element maxSizeInMegabytesElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MaxSizeInMegabytes");
                            if (maxSizeInMegabytesElement != null) {
                                int maxSizeInMegabytesInstance;
                                maxSizeInMegabytesInstance = DatatypeConverter.parseInt(maxSizeInMegabytesElement.getTextContent());
                                topicDescriptionInstance.setMaxSizeInMegabytes(maxSizeInMegabytesInstance);
                            }
                            
                            Element requiresDuplicateDetectionElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "RequiresDuplicateDetection");
                            if (requiresDuplicateDetectionElement != null) {
                                boolean requiresDuplicateDetectionInstance;
                                requiresDuplicateDetectionInstance = DatatypeConverter.parseBoolean(requiresDuplicateDetectionElement.getTextContent().toLowerCase());
                                topicDescriptionInstance.setRequiresDuplicateDetection(requiresDuplicateDetectionInstance);
                            }
                            
                            Element duplicateDetectionHistoryTimeWindowElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DuplicateDetectionHistoryTimeWindow");
                            if (duplicateDetectionHistoryTimeWindowElement != null) {
                                String duplicateDetectionHistoryTimeWindowInstance;
                                duplicateDetectionHistoryTimeWindowInstance = duplicateDetectionHistoryTimeWindowElement.getTextContent();
                                topicDescriptionInstance.setDuplicateDetectionHistoryTimeWindow(duplicateDetectionHistoryTimeWindowInstance);
                            }
                            
                            Element enableBatchedOperationsElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EnableBatchedOperations");
                            if (enableBatchedOperationsElement != null) {
                                boolean enableBatchedOperationsInstance;
                                enableBatchedOperationsInstance = DatatypeConverter.parseBoolean(enableBatchedOperationsElement.getTextContent().toLowerCase());
                                topicDescriptionInstance.setEnableBatchedOperations(enableBatchedOperationsInstance);
                            }
                            
                            Element sizeInBytesElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SizeInBytes");
                            if (sizeInBytesElement != null) {
                                int sizeInBytesInstance;
                                sizeInBytesInstance = DatatypeConverter.parseInt(sizeInBytesElement.getTextContent());
                                topicDescriptionInstance.setSizeInBytes(sizeInBytesInstance);
                            }
                            
                            Element filteringMessagesBeforePublishingElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "FilteringMessagesBeforePublishing");
                            if (filteringMessagesBeforePublishingElement != null) {
                                boolean filteringMessagesBeforePublishingInstance;
                                filteringMessagesBeforePublishingInstance = DatatypeConverter.parseBoolean(filteringMessagesBeforePublishingElement.getTextContent().toLowerCase());
                                topicDescriptionInstance.setFilteringMessagesBeforePublishing(filteringMessagesBeforePublishingInstance);
                            }
                            
                            Element isAnonymousAccessibleElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "IsAnonymousAccessible");
                            if (isAnonymousAccessibleElement != null) {
                                boolean isAnonymousAccessibleInstance;
                                isAnonymousAccessibleInstance = DatatypeConverter.parseBoolean(isAnonymousAccessibleElement.getTextContent().toLowerCase());
                                topicDescriptionInstance.setIsAnonymousAccessible(isAnonymousAccessibleInstance);
                            }
                            
                            Element authorizationRulesSequenceElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRules");
                            if (authorizationRulesSequenceElement != null) {
                                for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(authorizationRulesSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRule").size(); i1 = i1 + 1) {
                                    org.w3c.dom.Element authorizationRulesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(authorizationRulesSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRule").get(i1));
                                    ServiceBusSharedAccessAuthorizationRule authorizationRuleInstance = new ServiceBusSharedAccessAuthorizationRule();
                                    topicDescriptionInstance.getAuthorizationRules().add(authorizationRuleInstance);
                                    
                                    Element claimTypeElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimType");
                                    if (claimTypeElement != null) {
                                        String claimTypeInstance;
                                        claimTypeInstance = claimTypeElement.getTextContent();
                                        authorizationRuleInstance.setClaimType(claimTypeInstance);
                                    }
                                    
                                    Element claimValueElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimValue");
                                    if (claimValueElement != null) {
                                        String claimValueInstance;
                                        claimValueInstance = claimValueElement.getTextContent();
                                        authorizationRuleInstance.setClaimValue(claimValueInstance);
                                    }
                                    
                                    Element rightsSequenceElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Rights");
                                    if (rightsSequenceElement != null) {
                                        for (int i2 = 0; i2 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").size(); i2 = i2 + 1) {
                                            org.w3c.dom.Element rightsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").get(i2));
                                            authorizationRuleInstance.getRights().add(AccessRight.valueOf(rightsElement.getTextContent()));
                                        }
                                    }
                                    
                                    Element createdTimeElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedTime");
                                    if (createdTimeElement != null) {
                                        Calendar createdTimeInstance;
                                        createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeElement.getTextContent());
                                        authorizationRuleInstance.setCreatedTime(createdTimeInstance);
                                    }
                                    
                                    Element keyNameElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "KeyName");
                                    if (keyNameElement != null) {
                                        String keyNameInstance;
                                        keyNameInstance = keyNameElement.getTextContent();
                                        authorizationRuleInstance.setKeyName(keyNameInstance);
                                    }
                                    
                                    Element modifiedTimeElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ModifiedTime");
                                    if (modifiedTimeElement != null) {
                                        Calendar modifiedTimeInstance;
                                        modifiedTimeInstance = DatatypeConverter.parseDateTime(modifiedTimeElement.getTextContent());
                                        authorizationRuleInstance.setModifiedTime(modifiedTimeInstance);
                                    }
                                    
                                    Element primaryKeyElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "PrimaryKey");
                                    if (primaryKeyElement != null) {
                                        String primaryKeyInstance;
                                        primaryKeyInstance = primaryKeyElement.getTextContent();
                                        authorizationRuleInstance.setPrimaryKey(primaryKeyInstance);
                                    }
                                    
                                    Element secondaryKeyElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SecondaryKey");
                                    if (secondaryKeyElement != null) {
                                        String secondaryKeyInstance;
                                        secondaryKeyInstance = secondaryKeyElement.getTextContent();
                                        authorizationRuleInstance.setSecondaryKey(secondaryKeyInstance);
                                    }
                                }
                            }
                            
                            Element statusElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Status");
                            if (statusElement != null) {
                                String statusInstance;
                                statusInstance = statusElement.getTextContent();
                                topicDescriptionInstance.setStatus(statusInstance);
                            }
                            
                            Element createdAtElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedAt");
                            if (createdAtElement != null) {
                                Calendar createdAtInstance;
                                createdAtInstance = DatatypeConverter.parseDateTime(createdAtElement.getTextContent());
                                topicDescriptionInstance.setCreatedAt(createdAtInstance);
                            }
                            
                            Element updatedAtElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "UpdatedAt");
                            if (updatedAtElement != null) {
                                Calendar updatedAtInstance;
                                updatedAtInstance = DatatypeConverter.parseDateTime(updatedAtElement.getTextContent());
                                topicDescriptionInstance.setUpdatedAt(updatedAtInstance);
                            }
                            
                            Element accessedAtElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessedAt");
                            if (accessedAtElement != null) {
                                Calendar accessedAtInstance;
                                accessedAtInstance = DatatypeConverter.parseDateTime(accessedAtElement.getTextContent());
                                topicDescriptionInstance.setAccessedAt(accessedAtInstance);
                            }
                            
                            Element supportOrderingElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SupportOrdering");
                            if (supportOrderingElement != null) {
                                boolean supportOrderingInstance;
                                supportOrderingInstance = DatatypeConverter.parseBoolean(supportOrderingElement.getTextContent().toLowerCase());
                                topicDescriptionInstance.setSupportOrdering(supportOrderingInstance);
                            }
                            
                            Element countDetailsElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CountDetails");
                            if (countDetailsElement != null) {
                                CountDetails countDetailsInstance = new CountDetails();
                                topicDescriptionInstance.setCountDetails(countDetailsInstance);
                            }
                            
                            Element subscriptionCountElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SubscriptionCount");
                            if (subscriptionCountElement != null) {
                                int subscriptionCountInstance;
                                subscriptionCountInstance = DatatypeConverter.parseInt(subscriptionCountElement.getTextContent());
                                topicDescriptionInstance.setSubscriptionCount(subscriptionCountInstance);
                            }
                            
                            Element autoDeleteOnIdleElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AutoDeleteOnIdle");
                            if (autoDeleteOnIdleElement != null) {
                                String autoDeleteOnIdleInstance;
                                autoDeleteOnIdleInstance = autoDeleteOnIdleElement.getTextContent();
                                topicDescriptionInstance.setAutoDeleteOnIdle(autoDeleteOnIdleInstance);
                            }
                            
                            Element entityAvailabilityStatusElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EntityAvailabilityStatus");
                            if (entityAvailabilityStatusElement != null) {
                                String entityAvailabilityStatusInstance;
                                entityAvailabilityStatusInstance = entityAvailabilityStatusElement.getTextContent();
                                topicDescriptionInstance.setEntityAvailabilityStatus(entityAvailabilityStatusInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets the set of connection strings for a topic.
    *
    * @param namespaceName Required. The namespace name.
    * @param topicName Required. The topic.
    * @return The set of connection details for a service bus entity.
    */
    @Override
    public Future<ServiceBusConnectionDetailsResponse> getConnectionDetailsAsync(final String namespaceName, final String topicName) {
        return this.getClient().getExecutorService().submit(new Callable<ServiceBusConnectionDetailsResponse>() { 
            @Override
            public ServiceBusConnectionDetailsResponse call() throws Exception {
                return getConnectionDetails(namespaceName, topicName);
            }
         });
    }
    
    /**
    * Gets the set of connection strings for a topic.
    *
    * @param namespaceName Required. The namespace name.
    * @param topicName Required. The topic.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The set of connection details for a service bus entity.
    */
    @Override
    public ServiceBusConnectionDetailsResponse getConnectionDetails(String namespaceName, String topicName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (topicName == null) {
            throw new NullPointerException("topicName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("topicName", topicName);
            CloudTracing.enter(invocationId, this, "getConnectionDetailsAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/servicebus/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/Topics/";
        url = url + URLEncoder.encode(topicName, "UTF-8");
        url = url + "/ConnectionDetails";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml; charset=utf-8");
        httpRequest.setHeader("x-ms-version", "2013-08-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ServiceBusConnectionDetailsResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ServiceBusConnectionDetailsResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element feedElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://www.w3.org/2005/Atom", "feed");
                if (feedElement != null) {
                    if (feedElement != null) {
                        for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(feedElement, "http://www.w3.org/2005/Atom", "entry").size(); i1 = i1 + 1) {
                            org.w3c.dom.Element entriesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(feedElement, "http://www.w3.org/2005/Atom", "entry").get(i1));
                            ServiceBusConnectionDetail entryInstance = new ServiceBusConnectionDetail();
                            result.getConnectionDetails().add(entryInstance);
                            
                            Element contentElement = XmlUtility.getElementByTagNameNS(entriesElement, "http://www.w3.org/2005/Atom", "content");
                            if (contentElement != null) {
                                Element connectionDetailElement = XmlUtility.getElementByTagNameNS(contentElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ConnectionDetail");
                                if (connectionDetailElement != null) {
                                    Element keyNameElement = XmlUtility.getElementByTagNameNS(connectionDetailElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "KeyName");
                                    if (keyNameElement != null) {
                                        String keyNameInstance;
                                        keyNameInstance = keyNameElement.getTextContent();
                                        entryInstance.setKeyName(keyNameInstance);
                                    }
                                    
                                    Element connectionStringElement = XmlUtility.getElementByTagNameNS(connectionDetailElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ConnectionString");
                                    if (connectionStringElement != null) {
                                        String connectionStringInstance;
                                        connectionStringInstance = connectionStringElement.getTextContent();
                                        entryInstance.setConnectionString(connectionStringInstance);
                                    }
                                    
                                    Element authorizationTypeElement = XmlUtility.getElementByTagNameNS(connectionDetailElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationType");
                                    if (authorizationTypeElement != null) {
                                        String authorizationTypeInstance;
                                        authorizationTypeInstance = authorizationTypeElement.getTextContent();
                                        entryInstance.setAuthorizationType(authorizationTypeInstance);
                                    }
                                    
                                    Element rightsSequenceElement = XmlUtility.getElementByTagNameNS(connectionDetailElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Rights");
                                    if (rightsSequenceElement != null) {
                                        for (int i2 = 0; i2 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").size(); i2 = i2 + 1) {
                                            org.w3c.dom.Element rightsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").get(i2));
                                            entryInstance.getRights().add(AccessRight.valueOf(rightsElement.getTextContent()));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Enumerates the topics in the service namespace. An empty feed is returned
    * if no topic exists in the service namespace.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh780744.aspx for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @return A response to a request for a list of topics.
    */
    @Override
    public Future<ServiceBusTopicsResponse> listAsync(final String namespaceName) {
        return this.getClient().getExecutorService().submit(new Callable<ServiceBusTopicsResponse>() { 
            @Override
            public ServiceBusTopicsResponse call() throws Exception {
                return list(namespaceName);
            }
         });
    }
    
    /**
    * Enumerates the topics in the service namespace. An empty feed is returned
    * if no topic exists in the service namespace.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh780744.aspx for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return A response to a request for a list of topics.
    */
    @Override
    public ServiceBusTopicsResponse list(String namespaceName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        // Validate
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("namespaceName", namespaceName);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/servicebus/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/topics/";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml; charset=utf-8");
        httpRequest.setHeader("x-ms-version", "2013-08-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ServiceBusTopicsResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ServiceBusTopicsResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element feedElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://www.w3.org/2005/Atom", "feed");
                if (feedElement != null) {
                    if (feedElement != null) {
                        for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(feedElement, "http://www.w3.org/2005/Atom", "entry").size(); i1 = i1 + 1) {
                            org.w3c.dom.Element entriesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(feedElement, "http://www.w3.org/2005/Atom", "entry").get(i1));
                            ServiceBusTopic entryInstance = new ServiceBusTopic();
                            result.getTopics().add(entryInstance);
                            
                            Element titleElement = XmlUtility.getElementByTagNameNS(entriesElement, "http://www.w3.org/2005/Atom", "title");
                            if (titleElement != null) {
                                String titleInstance;
                                titleInstance = titleElement.getTextContent();
                                entryInstance.setName(titleInstance);
                            }
                            
                            Element contentElement = XmlUtility.getElementByTagNameNS(entriesElement, "http://www.w3.org/2005/Atom", "content");
                            if (contentElement != null) {
                                Element topicDescriptionElement = XmlUtility.getElementByTagNameNS(contentElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "TopicDescription");
                                if (topicDescriptionElement != null) {
                                    Element defaultMessageTimeToLiveElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DefaultMessageTimeToLive");
                                    if (defaultMessageTimeToLiveElement != null) {
                                        String defaultMessageTimeToLiveInstance;
                                        defaultMessageTimeToLiveInstance = defaultMessageTimeToLiveElement.getTextContent();
                                        entryInstance.setDefaultMessageTimeToLive(defaultMessageTimeToLiveInstance);
                                    }
                                    
                                    Element maxSizeInMegabytesElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MaxSizeInMegabytes");
                                    if (maxSizeInMegabytesElement != null) {
                                        int maxSizeInMegabytesInstance;
                                        maxSizeInMegabytesInstance = DatatypeConverter.parseInt(maxSizeInMegabytesElement.getTextContent());
                                        entryInstance.setMaxSizeInMegabytes(maxSizeInMegabytesInstance);
                                    }
                                    
                                    Element requiresDuplicateDetectionElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "RequiresDuplicateDetection");
                                    if (requiresDuplicateDetectionElement != null) {
                                        boolean requiresDuplicateDetectionInstance;
                                        requiresDuplicateDetectionInstance = DatatypeConverter.parseBoolean(requiresDuplicateDetectionElement.getTextContent().toLowerCase());
                                        entryInstance.setRequiresDuplicateDetection(requiresDuplicateDetectionInstance);
                                    }
                                    
                                    Element duplicateDetectionHistoryTimeWindowElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DuplicateDetectionHistoryTimeWindow");
                                    if (duplicateDetectionHistoryTimeWindowElement != null) {
                                        String duplicateDetectionHistoryTimeWindowInstance;
                                        duplicateDetectionHistoryTimeWindowInstance = duplicateDetectionHistoryTimeWindowElement.getTextContent();
                                        entryInstance.setDuplicateDetectionHistoryTimeWindow(duplicateDetectionHistoryTimeWindowInstance);
                                    }
                                    
                                    Element enableBatchedOperationsElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EnableBatchedOperations");
                                    if (enableBatchedOperationsElement != null) {
                                        boolean enableBatchedOperationsInstance;
                                        enableBatchedOperationsInstance = DatatypeConverter.parseBoolean(enableBatchedOperationsElement.getTextContent().toLowerCase());
                                        entryInstance.setEnableBatchedOperations(enableBatchedOperationsInstance);
                                    }
                                    
                                    Element sizeInBytesElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SizeInBytes");
                                    if (sizeInBytesElement != null) {
                                        int sizeInBytesInstance;
                                        sizeInBytesInstance = DatatypeConverter.parseInt(sizeInBytesElement.getTextContent());
                                        entryInstance.setSizeInBytes(sizeInBytesInstance);
                                    }
                                    
                                    Element filteringMessagesBeforePublishingElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "FilteringMessagesBeforePublishing");
                                    if (filteringMessagesBeforePublishingElement != null) {
                                        boolean filteringMessagesBeforePublishingInstance;
                                        filteringMessagesBeforePublishingInstance = DatatypeConverter.parseBoolean(filteringMessagesBeforePublishingElement.getTextContent().toLowerCase());
                                        entryInstance.setFilteringMessagesBeforePublishing(filteringMessagesBeforePublishingInstance);
                                    }
                                    
                                    Element isAnonymousAccessibleElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "IsAnonymousAccessible");
                                    if (isAnonymousAccessibleElement != null) {
                                        boolean isAnonymousAccessibleInstance;
                                        isAnonymousAccessibleInstance = DatatypeConverter.parseBoolean(isAnonymousAccessibleElement.getTextContent().toLowerCase());
                                        entryInstance.setIsAnonymousAccessible(isAnonymousAccessibleInstance);
                                    }
                                    
                                    Element authorizationRulesSequenceElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRules");
                                    if (authorizationRulesSequenceElement != null) {
                                        for (int i2 = 0; i2 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(authorizationRulesSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRule").size(); i2 = i2 + 1) {
                                            org.w3c.dom.Element authorizationRulesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(authorizationRulesSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRule").get(i2));
                                            ServiceBusSharedAccessAuthorizationRule authorizationRuleInstance = new ServiceBusSharedAccessAuthorizationRule();
                                            entryInstance.getAuthorizationRules().add(authorizationRuleInstance);
                                            
                                            Element claimTypeElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimType");
                                            if (claimTypeElement != null) {
                                                String claimTypeInstance;
                                                claimTypeInstance = claimTypeElement.getTextContent();
                                                authorizationRuleInstance.setClaimType(claimTypeInstance);
                                            }
                                            
                                            Element claimValueElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimValue");
                                            if (claimValueElement != null) {
                                                String claimValueInstance;
                                                claimValueInstance = claimValueElement.getTextContent();
                                                authorizationRuleInstance.setClaimValue(claimValueInstance);
                                            }
                                            
                                            Element rightsSequenceElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Rights");
                                            if (rightsSequenceElement != null) {
                                                for (int i3 = 0; i3 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").size(); i3 = i3 + 1) {
                                                    org.w3c.dom.Element rightsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").get(i3));
                                                    authorizationRuleInstance.getRights().add(AccessRight.valueOf(rightsElement.getTextContent()));
                                                }
                                            }
                                            
                                            Element createdTimeElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedTime");
                                            if (createdTimeElement != null) {
                                                Calendar createdTimeInstance;
                                                createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeElement.getTextContent());
                                                authorizationRuleInstance.setCreatedTime(createdTimeInstance);
                                            }
                                            
                                            Element keyNameElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "KeyName");
                                            if (keyNameElement != null) {
                                                String keyNameInstance;
                                                keyNameInstance = keyNameElement.getTextContent();
                                                authorizationRuleInstance.setKeyName(keyNameInstance);
                                            }
                                            
                                            Element modifiedTimeElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ModifiedTime");
                                            if (modifiedTimeElement != null) {
                                                Calendar modifiedTimeInstance;
                                                modifiedTimeInstance = DatatypeConverter.parseDateTime(modifiedTimeElement.getTextContent());
                                                authorizationRuleInstance.setModifiedTime(modifiedTimeInstance);
                                            }
                                            
                                            Element primaryKeyElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "PrimaryKey");
                                            if (primaryKeyElement != null) {
                                                String primaryKeyInstance;
                                                primaryKeyInstance = primaryKeyElement.getTextContent();
                                                authorizationRuleInstance.setPrimaryKey(primaryKeyInstance);
                                            }
                                            
                                            Element secondaryKeyElement = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SecondaryKey");
                                            if (secondaryKeyElement != null) {
                                                String secondaryKeyInstance;
                                                secondaryKeyInstance = secondaryKeyElement.getTextContent();
                                                authorizationRuleInstance.setSecondaryKey(secondaryKeyInstance);
                                            }
                                        }
                                    }
                                    
                                    Element statusElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Status");
                                    if (statusElement != null) {
                                        String statusInstance;
                                        statusInstance = statusElement.getTextContent();
                                        entryInstance.setStatus(statusInstance);
                                    }
                                    
                                    Element createdAtElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedAt");
                                    if (createdAtElement != null) {
                                        Calendar createdAtInstance;
                                        createdAtInstance = DatatypeConverter.parseDateTime(createdAtElement.getTextContent());
                                        entryInstance.setCreatedAt(createdAtInstance);
                                    }
                                    
                                    Element updatedAtElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "UpdatedAt");
                                    if (updatedAtElement != null) {
                                        Calendar updatedAtInstance;
                                        updatedAtInstance = DatatypeConverter.parseDateTime(updatedAtElement.getTextContent());
                                        entryInstance.setUpdatedAt(updatedAtInstance);
                                    }
                                    
                                    Element accessedAtElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessedAt");
                                    if (accessedAtElement != null) {
                                        Calendar accessedAtInstance;
                                        accessedAtInstance = DatatypeConverter.parseDateTime(accessedAtElement.getTextContent());
                                        entryInstance.setAccessedAt(accessedAtInstance);
                                    }
                                    
                                    Element supportOrderingElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SupportOrdering");
                                    if (supportOrderingElement != null) {
                                        boolean supportOrderingInstance;
                                        supportOrderingInstance = DatatypeConverter.parseBoolean(supportOrderingElement.getTextContent().toLowerCase());
                                        entryInstance.setSupportOrdering(supportOrderingInstance);
                                    }
                                    
                                    Element countDetailsElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CountDetails");
                                    if (countDetailsElement != null) {
                                        CountDetails countDetailsInstance = new CountDetails();
                                        entryInstance.setCountDetails(countDetailsInstance);
                                    }
                                    
                                    Element subscriptionCountElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SubscriptionCount");
                                    if (subscriptionCountElement != null) {
                                        int subscriptionCountInstance;
                                        subscriptionCountInstance = DatatypeConverter.parseInt(subscriptionCountElement.getTextContent());
                                        entryInstance.setSubscriptionCount(subscriptionCountInstance);
                                    }
                                    
                                    Element autoDeleteOnIdleElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AutoDeleteOnIdle");
                                    if (autoDeleteOnIdleElement != null) {
                                        String autoDeleteOnIdleInstance;
                                        autoDeleteOnIdleInstance = autoDeleteOnIdleElement.getTextContent();
                                        entryInstance.setAutoDeleteOnIdle(autoDeleteOnIdleInstance);
                                    }
                                    
                                    Element entityAvailabilityStatusElement = XmlUtility.getElementByTagNameNS(topicDescriptionElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EntityAvailabilityStatus");
                                    if (entityAvailabilityStatusElement != null) {
                                        String entityAvailabilityStatusInstance;
                                        entityAvailabilityStatusInstance = entityAvailabilityStatusElement.getTextContent();
                                        entryInstance.setEntityAvailabilityStatus(entityAvailabilityStatusInstance);
                                    }
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Updates a topic.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj839740.aspx for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @param topic Required. The Service Bus topic.
    * @return A response to a request for a particular topic.
    */
    @Override
    public Future<ServiceBusTopicResponse> updateAsync(final String namespaceName, final ServiceBusTopic topic) {
        return this.getClient().getExecutorService().submit(new Callable<ServiceBusTopicResponse>() { 
            @Override
            public ServiceBusTopicResponse call() throws Exception {
                return update(namespaceName, topic);
            }
         });
    }
    
    /**
    * Updates a topic.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj839740.aspx for
    * more information)
    *
    * @param namespaceName Required. The namespace name.
    * @param topic Required. The Service Bus topic.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A response to a request for a particular topic.
    */
    @Override
    public ServiceBusTopicResponse update(String namespaceName, ServiceBusTopic topic) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (namespaceName == null) {
            throw new NullPointerException("namespaceName");
        }
        if (topic == null) {
            throw new NullPointerException("topic");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("namespaceName", namespaceName);
            tracingParameters.put("topic", topic);
            CloudTracing.enter(invocationId, this, "updateAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/servicebus/namespaces/";
        url = url + URLEncoder.encode(namespaceName, "UTF-8");
        url = url + "/topics/";
        if (topic.getName() != null) {
            url = url + URLEncoder.encode(topic.getName(), "UTF-8");
        }
        url = url + "/";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/atom+xml");
        httpRequest.setHeader("if-match", "*");
        httpRequest.setHeader("type", "entry");
        httpRequest.setHeader("x-ms-version", "2013-08-01");
        httpRequest.setHeader("x-process-at", "ServiceBus");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element entryElement = requestDoc.createElementNS("http://www.w3.org/2005/Atom", "entry");
        requestDoc.appendChild(entryElement);
        
        Element contentElement = requestDoc.createElementNS("http://www.w3.org/2005/Atom", "content");
        entryElement.appendChild(contentElement);
        
        Attr typeAttribute = requestDoc.createAttribute("type");
        typeAttribute.setValue("application/atom+xml;type=entry;charset=utf-8");
        contentElement.setAttributeNode(typeAttribute);
        
        Element topicDescriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "TopicDescription");
        contentElement.appendChild(topicDescriptionElement);
        
        if (topic.getDefaultMessageTimeToLive() != null) {
            Element defaultMessageTimeToLiveElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DefaultMessageTimeToLive");
            defaultMessageTimeToLiveElement.appendChild(requestDoc.createTextNode(topic.getDefaultMessageTimeToLive()));
            topicDescriptionElement.appendChild(defaultMessageTimeToLiveElement);
        }
        
        Element maxSizeInMegabytesElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MaxSizeInMegabytes");
        maxSizeInMegabytesElement.appendChild(requestDoc.createTextNode(Integer.toString(topic.getMaxSizeInMegabytes())));
        topicDescriptionElement.appendChild(maxSizeInMegabytesElement);
        
        Element requiresDuplicateDetectionElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "RequiresDuplicateDetection");
        requiresDuplicateDetectionElement.appendChild(requestDoc.createTextNode(Boolean.toString(topic.isRequiresDuplicateDetection()).toLowerCase()));
        topicDescriptionElement.appendChild(requiresDuplicateDetectionElement);
        
        if (topic.getDuplicateDetectionHistoryTimeWindow() != null) {
            Element duplicateDetectionHistoryTimeWindowElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DuplicateDetectionHistoryTimeWindow");
            duplicateDetectionHistoryTimeWindowElement.appendChild(requestDoc.createTextNode(topic.getDuplicateDetectionHistoryTimeWindow()));
            topicDescriptionElement.appendChild(duplicateDetectionHistoryTimeWindowElement);
        }
        
        Element enableBatchedOperationsElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EnableBatchedOperations");
        enableBatchedOperationsElement.appendChild(requestDoc.createTextNode(Boolean.toString(topic.isEnableBatchedOperations()).toLowerCase()));
        topicDescriptionElement.appendChild(enableBatchedOperationsElement);
        
        Element sizeInBytesElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SizeInBytes");
        sizeInBytesElement.appendChild(requestDoc.createTextNode(Integer.toString(topic.getSizeInBytes())));
        topicDescriptionElement.appendChild(sizeInBytesElement);
        
        Element filteringMessagesBeforePublishingElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "FilteringMessagesBeforePublishing");
        filteringMessagesBeforePublishingElement.appendChild(requestDoc.createTextNode(Boolean.toString(topic.isFilteringMessagesBeforePublishing()).toLowerCase()));
        topicDescriptionElement.appendChild(filteringMessagesBeforePublishingElement);
        
        Element isAnonymousAccessibleElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "IsAnonymousAccessible");
        isAnonymousAccessibleElement.appendChild(requestDoc.createTextNode(Boolean.toString(topic.isAnonymousAccessible()).toLowerCase()));
        topicDescriptionElement.appendChild(isAnonymousAccessibleElement);
        
        if (topic.getAuthorizationRules() != null) {
            if (topic.getAuthorizationRules() instanceof LazyCollection == false || ((LazyCollection) topic.getAuthorizationRules()).isInitialized()) {
                Element authorizationRulesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRules");
                for (ServiceBusSharedAccessAuthorizationRule authorizationRulesItem : topic.getAuthorizationRules()) {
                    Element authorizationRuleElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRule");
                    authorizationRulesSequenceElement.appendChild(authorizationRuleElement);
                    
                    Attr typeAttribute2 = requestDoc.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                    typeAttribute2.setValue("SharedAccessAuthorizationRule");
                    authorizationRuleElement.setAttributeNode(typeAttribute2);
                    
                    if (authorizationRulesItem.getClaimType() != null) {
                        Element claimTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimType");
                        claimTypeElement.appendChild(requestDoc.createTextNode(authorizationRulesItem.getClaimType()));
                        authorizationRuleElement.appendChild(claimTypeElement);
                    }
                    
                    if (authorizationRulesItem.getClaimValue() != null) {
                        Element claimValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimValue");
                        claimValueElement.appendChild(requestDoc.createTextNode(authorizationRulesItem.getClaimValue()));
                        authorizationRuleElement.appendChild(claimValueElement);
                    }
                    
                    if (authorizationRulesItem.getRights() != null) {
                        if (authorizationRulesItem.getRights() instanceof LazyCollection == false || ((LazyCollection) authorizationRulesItem.getRights()).isInitialized()) {
                            Element rightsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Rights");
                            for (AccessRight rightsItem : authorizationRulesItem.getRights()) {
                                Element rightsItemElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights");
                                rightsItemElement.appendChild(requestDoc.createTextNode(rightsItem.toString()));
                                rightsSequenceElement.appendChild(rightsItemElement);
                            }
                            authorizationRuleElement.appendChild(rightsSequenceElement);
                        }
                    }
                    
                    Element createdTimeElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedTime");
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    createdTimeElement.appendChild(requestDoc.createTextNode(simpleDateFormat.format(authorizationRulesItem.getCreatedTime().getTime())));
                    authorizationRuleElement.appendChild(createdTimeElement);
                    
                    if (authorizationRulesItem.getKeyName() != null) {
                        Element keyNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "KeyName");
                        keyNameElement.appendChild(requestDoc.createTextNode(authorizationRulesItem.getKeyName()));
                        authorizationRuleElement.appendChild(keyNameElement);
                    }
                    
                    Element modifiedTimeElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ModifiedTime");
                    SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
                    modifiedTimeElement.appendChild(requestDoc.createTextNode(simpleDateFormat2.format(authorizationRulesItem.getModifiedTime().getTime())));
                    authorizationRuleElement.appendChild(modifiedTimeElement);
                    
                    if (authorizationRulesItem.getPrimaryKey() != null) {
                        Element primaryKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "PrimaryKey");
                        primaryKeyElement.appendChild(requestDoc.createTextNode(authorizationRulesItem.getPrimaryKey()));
                        authorizationRuleElement.appendChild(primaryKeyElement);
                    }
                    
                    if (authorizationRulesItem.getSecondaryKey() != null) {
                        Element secondaryKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SecondaryKey");
                        secondaryKeyElement.appendChild(requestDoc.createTextNode(authorizationRulesItem.getSecondaryKey()));
                        authorizationRuleElement.appendChild(secondaryKeyElement);
                    }
                }
                topicDescriptionElement.appendChild(authorizationRulesSequenceElement);
            }
        }
        
        if (topic.getStatus() != null) {
            Element statusElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Status");
            statusElement.appendChild(requestDoc.createTextNode(topic.getStatus()));
            topicDescriptionElement.appendChild(statusElement);
        }
        
        Element createdAtElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedAt");
        SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat3.setTimeZone(TimeZone.getTimeZone("UTC"));
        createdAtElement.appendChild(requestDoc.createTextNode(simpleDateFormat3.format(topic.getCreatedAt().getTime())));
        topicDescriptionElement.appendChild(createdAtElement);
        
        Element updatedAtElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "UpdatedAt");
        SimpleDateFormat simpleDateFormat4 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat4.setTimeZone(TimeZone.getTimeZone("UTC"));
        updatedAtElement.appendChild(requestDoc.createTextNode(simpleDateFormat4.format(topic.getUpdatedAt().getTime())));
        topicDescriptionElement.appendChild(updatedAtElement);
        
        Element accessedAtElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessedAt");
        SimpleDateFormat simpleDateFormat5 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat5.setTimeZone(TimeZone.getTimeZone("UTC"));
        accessedAtElement.appendChild(requestDoc.createTextNode(simpleDateFormat5.format(topic.getAccessedAt().getTime())));
        topicDescriptionElement.appendChild(accessedAtElement);
        
        Element supportOrderingElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SupportOrdering");
        supportOrderingElement.appendChild(requestDoc.createTextNode(Boolean.toString(topic.isSupportOrdering()).toLowerCase()));
        topicDescriptionElement.appendChild(supportOrderingElement);
        
        if (topic.getCountDetails() != null) {
            Element countDetailsElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CountDetails");
            topicDescriptionElement.appendChild(countDetailsElement);
            
            Element activeMessageCountElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2011/06/servicebus", "ActiveMessageCount");
            activeMessageCountElement.appendChild(requestDoc.createTextNode(Integer.toString(topic.getCountDetails().getActiveMessageCount())));
            countDetailsElement.appendChild(activeMessageCountElement);
            
            Element deadLetterMessageCountElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2011/06/servicebus", "DeadLetterMessageCount");
            deadLetterMessageCountElement.appendChild(requestDoc.createTextNode(Integer.toString(topic.getCountDetails().getDeadLetterMessageCount())));
            countDetailsElement.appendChild(deadLetterMessageCountElement);
            
            Element scheduledMessageCountElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2011/06/servicebus", "ScheduledMessageCount");
            scheduledMessageCountElement.appendChild(requestDoc.createTextNode(Integer.toString(topic.getCountDetails().getScheduledMessageCount())));
            countDetailsElement.appendChild(scheduledMessageCountElement);
            
            Element transferDeadLetterMessageCountElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2011/06/servicebus", "TransferDeadLetterMessageCount");
            transferDeadLetterMessageCountElement.appendChild(requestDoc.createTextNode(Integer.toString(topic.getCountDetails().getTransferDeadLetterMessageCount())));
            countDetailsElement.appendChild(transferDeadLetterMessageCountElement);
            
            Element transferMessageCountElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2011/06/servicebus", "TransferMessageCount");
            transferMessageCountElement.appendChild(requestDoc.createTextNode(Integer.toString(topic.getCountDetails().getTransferMessageCount())));
            countDetailsElement.appendChild(transferMessageCountElement);
        }
        
        Element subscriptionCountElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SubscriptionCount");
        subscriptionCountElement.appendChild(requestDoc.createTextNode(Integer.toString(topic.getSubscriptionCount())));
        topicDescriptionElement.appendChild(subscriptionCountElement);
        
        if (topic.getAutoDeleteOnIdle() != null) {
            Element autoDeleteOnIdleElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AutoDeleteOnIdle");
            autoDeleteOnIdleElement.appendChild(requestDoc.createTextNode(topic.getAutoDeleteOnIdle()));
            topicDescriptionElement.appendChild(autoDeleteOnIdleElement);
        }
        
        if (topic.getEntityAvailabilityStatus() != null) {
            Element entityAvailabilityStatusElement = requestDoc.createElementNS("http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EntityAvailabilityStatus");
            entityAvailabilityStatusElement.appendChild(requestDoc.createTextNode(topic.getEntityAvailabilityStatus()));
            topicDescriptionElement.appendChild(entityAvailabilityStatusElement);
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/atom+xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ServiceBusTopicResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ServiceBusTopicResponse();
                DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
                documentBuilderFactory2.setNamespaceAware(true);
                DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
                Document responseDoc = documentBuilder2.parse(new BOMInputStream(responseContent));
                
                Element entryElement2 = XmlUtility.getElementByTagNameNS(responseDoc, "http://www.w3.org/2005/Atom", "entry");
                if (entryElement2 != null) {
                    Element titleElement = XmlUtility.getElementByTagNameNS(entryElement2, "http://www.w3.org/2005/Atom", "title");
                    if (titleElement != null) {
                    }
                    
                    Element contentElement2 = XmlUtility.getElementByTagNameNS(entryElement2, "http://www.w3.org/2005/Atom", "content");
                    if (contentElement2 != null) {
                        Element topicDescriptionElement2 = XmlUtility.getElementByTagNameNS(contentElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "TopicDescription");
                        if (topicDescriptionElement2 != null) {
                            ServiceBusTopic topicDescriptionInstance = new ServiceBusTopic();
                            result.setTopic(topicDescriptionInstance);
                            
                            Element defaultMessageTimeToLiveElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DefaultMessageTimeToLive");
                            if (defaultMessageTimeToLiveElement2 != null) {
                                String defaultMessageTimeToLiveInstance;
                                defaultMessageTimeToLiveInstance = defaultMessageTimeToLiveElement2.getTextContent();
                                topicDescriptionInstance.setDefaultMessageTimeToLive(defaultMessageTimeToLiveInstance);
                            }
                            
                            Element maxSizeInMegabytesElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "MaxSizeInMegabytes");
                            if (maxSizeInMegabytesElement2 != null) {
                                int maxSizeInMegabytesInstance;
                                maxSizeInMegabytesInstance = DatatypeConverter.parseInt(maxSizeInMegabytesElement2.getTextContent());
                                topicDescriptionInstance.setMaxSizeInMegabytes(maxSizeInMegabytesInstance);
                            }
                            
                            Element requiresDuplicateDetectionElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "RequiresDuplicateDetection");
                            if (requiresDuplicateDetectionElement2 != null) {
                                boolean requiresDuplicateDetectionInstance;
                                requiresDuplicateDetectionInstance = DatatypeConverter.parseBoolean(requiresDuplicateDetectionElement2.getTextContent().toLowerCase());
                                topicDescriptionInstance.setRequiresDuplicateDetection(requiresDuplicateDetectionInstance);
                            }
                            
                            Element duplicateDetectionHistoryTimeWindowElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "DuplicateDetectionHistoryTimeWindow");
                            if (duplicateDetectionHistoryTimeWindowElement2 != null) {
                                String duplicateDetectionHistoryTimeWindowInstance;
                                duplicateDetectionHistoryTimeWindowInstance = duplicateDetectionHistoryTimeWindowElement2.getTextContent();
                                topicDescriptionInstance.setDuplicateDetectionHistoryTimeWindow(duplicateDetectionHistoryTimeWindowInstance);
                            }
                            
                            Element enableBatchedOperationsElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EnableBatchedOperations");
                            if (enableBatchedOperationsElement2 != null) {
                                boolean enableBatchedOperationsInstance;
                                enableBatchedOperationsInstance = DatatypeConverter.parseBoolean(enableBatchedOperationsElement2.getTextContent().toLowerCase());
                                topicDescriptionInstance.setEnableBatchedOperations(enableBatchedOperationsInstance);
                            }
                            
                            Element sizeInBytesElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SizeInBytes");
                            if (sizeInBytesElement2 != null) {
                                int sizeInBytesInstance;
                                sizeInBytesInstance = DatatypeConverter.parseInt(sizeInBytesElement2.getTextContent());
                                topicDescriptionInstance.setSizeInBytes(sizeInBytesInstance);
                            }
                            
                            Element filteringMessagesBeforePublishingElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "FilteringMessagesBeforePublishing");
                            if (filteringMessagesBeforePublishingElement2 != null) {
                                boolean filteringMessagesBeforePublishingInstance;
                                filteringMessagesBeforePublishingInstance = DatatypeConverter.parseBoolean(filteringMessagesBeforePublishingElement2.getTextContent().toLowerCase());
                                topicDescriptionInstance.setFilteringMessagesBeforePublishing(filteringMessagesBeforePublishingInstance);
                            }
                            
                            Element isAnonymousAccessibleElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "IsAnonymousAccessible");
                            if (isAnonymousAccessibleElement2 != null) {
                                boolean isAnonymousAccessibleInstance;
                                isAnonymousAccessibleInstance = DatatypeConverter.parseBoolean(isAnonymousAccessibleElement2.getTextContent().toLowerCase());
                                topicDescriptionInstance.setIsAnonymousAccessible(isAnonymousAccessibleInstance);
                            }
                            
                            Element authorizationRulesSequenceElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRules");
                            if (authorizationRulesSequenceElement2 != null) {
                                for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(authorizationRulesSequenceElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRule").size(); i1 = i1 + 1) {
                                    org.w3c.dom.Element authorizationRulesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(authorizationRulesSequenceElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AuthorizationRule").get(i1));
                                    ServiceBusSharedAccessAuthorizationRule authorizationRuleInstance = new ServiceBusSharedAccessAuthorizationRule();
                                    topicDescriptionInstance.getAuthorizationRules().add(authorizationRuleInstance);
                                    
                                    Element claimTypeElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimType");
                                    if (claimTypeElement2 != null) {
                                        String claimTypeInstance;
                                        claimTypeInstance = claimTypeElement2.getTextContent();
                                        authorizationRuleInstance.setClaimType(claimTypeInstance);
                                    }
                                    
                                    Element claimValueElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ClaimValue");
                                    if (claimValueElement2 != null) {
                                        String claimValueInstance;
                                        claimValueInstance = claimValueElement2.getTextContent();
                                        authorizationRuleInstance.setClaimValue(claimValueInstance);
                                    }
                                    
                                    Element rightsSequenceElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Rights");
                                    if (rightsSequenceElement2 != null) {
                                        for (int i2 = 0; i2 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").size(); i2 = i2 + 1) {
                                            org.w3c.dom.Element rightsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rightsSequenceElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessRights").get(i2));
                                            authorizationRuleInstance.getRights().add(AccessRight.valueOf(rightsElement.getTextContent()));
                                        }
                                    }
                                    
                                    Element createdTimeElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedTime");
                                    if (createdTimeElement2 != null) {
                                        Calendar createdTimeInstance;
                                        createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeElement2.getTextContent());
                                        authorizationRuleInstance.setCreatedTime(createdTimeInstance);
                                    }
                                    
                                    Element keyNameElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "KeyName");
                                    if (keyNameElement2 != null) {
                                        String keyNameInstance;
                                        keyNameInstance = keyNameElement2.getTextContent();
                                        authorizationRuleInstance.setKeyName(keyNameInstance);
                                    }
                                    
                                    Element modifiedTimeElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "ModifiedTime");
                                    if (modifiedTimeElement2 != null) {
                                        Calendar modifiedTimeInstance;
                                        modifiedTimeInstance = DatatypeConverter.parseDateTime(modifiedTimeElement2.getTextContent());
                                        authorizationRuleInstance.setModifiedTime(modifiedTimeInstance);
                                    }
                                    
                                    Element primaryKeyElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "PrimaryKey");
                                    if (primaryKeyElement2 != null) {
                                        String primaryKeyInstance;
                                        primaryKeyInstance = primaryKeyElement2.getTextContent();
                                        authorizationRuleInstance.setPrimaryKey(primaryKeyInstance);
                                    }
                                    
                                    Element secondaryKeyElement2 = XmlUtility.getElementByTagNameNS(authorizationRulesElement, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SecondaryKey");
                                    if (secondaryKeyElement2 != null) {
                                        String secondaryKeyInstance;
                                        secondaryKeyInstance = secondaryKeyElement2.getTextContent();
                                        authorizationRuleInstance.setSecondaryKey(secondaryKeyInstance);
                                    }
                                }
                            }
                            
                            Element statusElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "Status");
                            if (statusElement2 != null) {
                                String statusInstance;
                                statusInstance = statusElement2.getTextContent();
                                topicDescriptionInstance.setStatus(statusInstance);
                            }
                            
                            Element createdAtElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CreatedAt");
                            if (createdAtElement2 != null) {
                                Calendar createdAtInstance;
                                createdAtInstance = DatatypeConverter.parseDateTime(createdAtElement2.getTextContent());
                                topicDescriptionInstance.setCreatedAt(createdAtInstance);
                            }
                            
                            Element updatedAtElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "UpdatedAt");
                            if (updatedAtElement2 != null) {
                                Calendar updatedAtInstance;
                                updatedAtInstance = DatatypeConverter.parseDateTime(updatedAtElement2.getTextContent());
                                topicDescriptionInstance.setUpdatedAt(updatedAtInstance);
                            }
                            
                            Element accessedAtElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AccessedAt");
                            if (accessedAtElement2 != null) {
                                Calendar accessedAtInstance;
                                accessedAtInstance = DatatypeConverter.parseDateTime(accessedAtElement2.getTextContent());
                                topicDescriptionInstance.setAccessedAt(accessedAtInstance);
                            }
                            
                            Element supportOrderingElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SupportOrdering");
                            if (supportOrderingElement2 != null) {
                                boolean supportOrderingInstance;
                                supportOrderingInstance = DatatypeConverter.parseBoolean(supportOrderingElement2.getTextContent().toLowerCase());
                                topicDescriptionInstance.setSupportOrdering(supportOrderingInstance);
                            }
                            
                            Element countDetailsElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "CountDetails");
                            if (countDetailsElement2 != null) {
                                CountDetails countDetailsInstance = new CountDetails();
                                topicDescriptionInstance.setCountDetails(countDetailsInstance);
                            }
                            
                            Element subscriptionCountElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "SubscriptionCount");
                            if (subscriptionCountElement2 != null) {
                                int subscriptionCountInstance;
                                subscriptionCountInstance = DatatypeConverter.parseInt(subscriptionCountElement2.getTextContent());
                                topicDescriptionInstance.setSubscriptionCount(subscriptionCountInstance);
                            }
                            
                            Element autoDeleteOnIdleElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "AutoDeleteOnIdle");
                            if (autoDeleteOnIdleElement2 != null) {
                                String autoDeleteOnIdleInstance;
                                autoDeleteOnIdleInstance = autoDeleteOnIdleElement2.getTextContent();
                                topicDescriptionInstance.setAutoDeleteOnIdle(autoDeleteOnIdleInstance);
                            }
                            
                            Element entityAvailabilityStatusElement2 = XmlUtility.getElementByTagNameNS(topicDescriptionElement2, "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect", "EntityAvailabilityStatus");
                            if (entityAvailabilityStatusElement2 != null) {
                                String entityAvailabilityStatusInstance;
                                entityAvailabilityStatusInstance = entityAvailabilityStatusElement2.getTextContent();
                                topicDescriptionInstance.setEntityAvailabilityStatus(entityAvailabilityStatusInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
