/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.servicebus.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Iterator;

/**
* A response to a request for a list of authorization rules.
*/
public class ServiceBusAuthorizationRulesResponse extends OperationResponse implements Iterable<ServiceBusSharedAccessAuthorizationRule> {
    private ArrayList<ServiceBusSharedAccessAuthorizationRule> authorizationRules;
    
    /**
    * Optional. The list of authorization rules.
    * @return The AuthorizationRules value.
    */
    public ArrayList<ServiceBusSharedAccessAuthorizationRule> getAuthorizationRules() {
        return this.authorizationRules;
    }
    
    /**
    * Optional. The list of authorization rules.
    * @param authorizationRulesValue The AuthorizationRules value.
    */
    public void setAuthorizationRules(final ArrayList<ServiceBusSharedAccessAuthorizationRule> authorizationRulesValue) {
        this.authorizationRules = authorizationRulesValue;
    }
    
    /**
    * Initializes a new instance of the ServiceBusAuthorizationRulesResponse
    * class.
    *
    */
    public ServiceBusAuthorizationRulesResponse() {
        super();
        this.setAuthorizationRules(new LazyArrayList<ServiceBusSharedAccessAuthorizationRule>());
    }
    
    /**
    * Gets the sequence of AuthorizationRules.
    *
    */
    public Iterator<ServiceBusSharedAccessAuthorizationRule> iterator() {
        return this.getAuthorizationRules().iterator();
    }
}
