/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.servicebus.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Iterator;

/**
* The response to the request for a listing of namespaces.
*/
public class ServiceBusNamespacesResponse extends OperationResponse implements Iterable<ServiceBusNamespace> {
    private ArrayList<ServiceBusNamespace> namespaces;
    
    /**
    * Optional. The list of namespaces.
    * @return The Namespaces value.
    */
    public ArrayList<ServiceBusNamespace> getNamespaces() {
        return this.namespaces;
    }
    
    /**
    * Optional. The list of namespaces.
    * @param namespacesValue The Namespaces value.
    */
    public void setNamespaces(final ArrayList<ServiceBusNamespace> namespacesValue) {
        this.namespaces = namespacesValue;
    }
    
    /**
    * Initializes a new instance of the ServiceBusNamespacesResponse class.
    *
    */
    public ServiceBusNamespacesResponse() {
        super();
        this.setNamespaces(new LazyArrayList<ServiceBusNamespace>());
    }
    
    /**
    * Gets the sequence of Namespaces.
    *
    */
    public Iterator<ServiceBusNamespace> iterator() {
        return this.getNamespaces().iterator();
    }
}
