/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.sql;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.sql.models.DatabaseCopyCreateParameters;
import com.microsoft.windowsazure.management.sql.models.DatabaseCopyCreateResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseCopyGetResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseCopyListResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseCopyUpdateParameters;
import com.microsoft.windowsazure.management.sql.models.DatabaseCopyUpdateResponse;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import java.io.IOException;
import java.util.concurrent.Future;

/**
* Represents the SQL Database Management API includes operations for managing
* SQL Server database copies for a subscription.
*/
public interface DatabaseCopyOperations {
    /**
    * Starts a SQL Server database copy.
    *
    * @param serverName Required. The name of the SQL Server where the source
    * database resides.
    * @param databaseName Required. The name of the source database.
    * @param parameters Required. The additional parameters for the create
    * database copy operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents a response to the create request.
    */
    DatabaseCopyCreateResponse create(String serverName, String databaseName, DatabaseCopyCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * Starts a SQL Server database copy.
    *
    * @param serverName Required. The name of the SQL Server where the source
    * database resides.
    * @param databaseName Required. The name of the source database.
    * @param parameters Required. The additional parameters for the create
    * database copy operation.
    * @return Represents a response to the create request.
    */
    Future<DatabaseCopyCreateResponse> createAsync(String serverName, String databaseName, DatabaseCopyCreateParameters parameters);
    
    /**
    * Stops a SQL Server database copy.
    *
    * @param serverName Required. The name of the source or destination SQL
    * Server instance.
    * @param databaseName Required. The name of the database.
    * @param databaseCopyName Required. The unique identifier for the database
    * copy to stop.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse delete(String serverName, String databaseName, String databaseCopyName) throws IOException, ServiceException;
    
    /**
    * Stops a SQL Server database copy.
    *
    * @param serverName Required. The name of the source or destination SQL
    * Server instance.
    * @param databaseName Required. The name of the database.
    * @param databaseCopyName Required. The unique identifier for the database
    * copy to stop.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteAsync(String serverName, String databaseName, String databaseCopyName);
    
    /**
    * Retrieves information about a SQL Server database copy.
    *
    * @param serverName Required. The name of the source or destination SQL
    * Server instance.
    * @param databaseName Required. The name of the database.
    * @param databaseCopyName Required. The unique identifier for the database
    * copy to retrieve.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return Represents a response to the get request.
    */
    DatabaseCopyGetResponse get(String serverName, String databaseName, String databaseCopyName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * Retrieves information about a SQL Server database copy.
    *
    * @param serverName Required. The name of the source or destination SQL
    * Server instance.
    * @param databaseName Required. The name of the database.
    * @param databaseCopyName Required. The unique identifier for the database
    * copy to retrieve.
    * @return Represents a response to the get request.
    */
    Future<DatabaseCopyGetResponse> getAsync(String serverName, String databaseName, String databaseCopyName);
    
    /**
    * Retrieves the list of SQL Server database copies for a database.
    *
    * @param serverName Required. The name of the database server to be queried.
    * @param databaseName Required. The name of the database to be queried.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return Represents the response containing the list of database copies
    * for a given database.
    */
    DatabaseCopyListResponse list(String serverName, String databaseName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * Retrieves the list of SQL Server database copies for a database.
    *
    * @param serverName Required. The name of the database server to be queried.
    * @param databaseName Required. The name of the database to be queried.
    * @return Represents the response containing the list of database copies
    * for a given database.
    */
    Future<DatabaseCopyListResponse> listAsync(String serverName, String databaseName);
    
    /**
    * Updates a SQL Server database copy.
    *
    * @param serverName Required. The name of the source or destination SQL
    * Server instance.
    * @param databaseName Required. The name of the database.
    * @param databaseCopyName Required. The unique identifier for the database
    * copy to update.
    * @param parameters Required. The additional parameters for the update
    * database copy operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents a response to the update request.
    */
    DatabaseCopyUpdateResponse update(String serverName, String databaseName, String databaseCopyName, DatabaseCopyUpdateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * Updates a SQL Server database copy.
    *
    * @param serverName Required. The name of the source or destination SQL
    * Server instance.
    * @param databaseName Required. The name of the database.
    * @param databaseCopyName Required. The unique identifier for the database
    * copy to update.
    * @param parameters Required. The additional parameters for the update
    * database copy operation.
    * @return Represents a response to the update request.
    */
    Future<DatabaseCopyUpdateResponse> updateAsync(String serverName, String databaseName, String databaseCopyName, DatabaseCopyUpdateParameters parameters);
}
