/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.sql;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.sql.models.DatabaseCopy;
import com.microsoft.windowsazure.management.sql.models.DatabaseCopyCreateParameters;
import com.microsoft.windowsazure.management.sql.models.DatabaseCopyCreateResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseCopyGetResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseCopyListResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseCopyUpdateParameters;
import com.microsoft.windowsazure.management.sql.models.DatabaseCopyUpdateResponse;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
* Represents the SQL Database Management API includes operations for managing
* SQL Server database copies for a subscription.
*/
public class DatabaseCopyOperationsImpl implements ServiceOperations<SqlManagementClientImpl>, DatabaseCopyOperations {
    /**
    * Initializes a new instance of the DatabaseCopyOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    DatabaseCopyOperationsImpl(SqlManagementClientImpl client) {
        this.client = client;
    }
    
    private SqlManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.windowsazure.management.sql.SqlManagementClientImpl.
    * @return The Client value.
    */
    public SqlManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Starts a SQL Server database copy.
    *
    * @param serverName Required. The name of the SQL Server where the source
    * database resides.
    * @param databaseName Required. The name of the source database.
    * @param parameters Required. The additional parameters for the create
    * database copy operation.
    * @return Represents a response to the create request.
    */
    @Override
    public Future<DatabaseCopyCreateResponse> createAsync(final String serverName, final String databaseName, final DatabaseCopyCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseCopyCreateResponse>() { 
            @Override
            public DatabaseCopyCreateResponse call() throws Exception {
                return create(serverName, databaseName, parameters);
            }
         });
    }
    
    /**
    * Starts a SQL Server database copy.
    *
    * @param serverName Required. The name of the SQL Server where the source
    * database resides.
    * @param databaseName Required. The name of the source database.
    * @param parameters Required. The additional parameters for the create
    * database copy operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents a response to the create request.
    */
    @Override
    public DatabaseCopyCreateResponse create(String serverName, String databaseName, DatabaseCopyCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getPartnerDatabase() == null) {
            throw new NullPointerException("parameters.PartnerDatabase");
        }
        if (parameters.getPartnerServer() == null) {
            throw new NullPointerException("parameters.PartnerServer");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/databasecopies";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element serviceResourceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ServiceResource");
        requestDoc.appendChild(serviceResourceElement);
        
        Element partnerServerElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PartnerServer");
        partnerServerElement.appendChild(requestDoc.createTextNode(parameters.getPartnerServer()));
        serviceResourceElement.appendChild(partnerServerElement);
        
        Element partnerDatabaseElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PartnerDatabase");
        partnerDatabaseElement.appendChild(requestDoc.createTextNode(parameters.getPartnerDatabase()));
        serviceResourceElement.appendChild(partnerDatabaseElement);
        
        Element isContinuousElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IsContinuous");
        isContinuousElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isContinuous()).toLowerCase()));
        serviceResourceElement.appendChild(isContinuousElement);
        
        Element isOfflineSecondaryElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IsOfflineSecondary");
        isOfflineSecondaryElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isOfflineSecondary()).toLowerCase()));
        serviceResourceElement.appendChild(isOfflineSecondaryElement);
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DatabaseCopyCreateResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DatabaseCopyCreateResponse();
                DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
                documentBuilderFactory2.setNamespaceAware(true);
                DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
                Document responseDoc = documentBuilder2.parse(new BOMInputStream(responseContent));
                
                Element serviceResourceElement2 = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "ServiceResource");
                if (serviceResourceElement2 != null) {
                    DatabaseCopy serviceResourceInstance = new DatabaseCopy();
                    result.setDatabaseCopy(serviceResourceInstance);
                    
                    Element sourceServerNameElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "SourceServerName");
                    if (sourceServerNameElement != null) {
                        String sourceServerNameInstance;
                        sourceServerNameInstance = sourceServerNameElement.getTextContent();
                        serviceResourceInstance.setSourceServerName(sourceServerNameInstance);
                    }
                    
                    Element sourceDatabaseNameElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "SourceDatabaseName");
                    if (sourceDatabaseNameElement != null) {
                        String sourceDatabaseNameInstance;
                        sourceDatabaseNameInstance = sourceDatabaseNameElement.getTextContent();
                        serviceResourceInstance.setSourceDatabaseName(sourceDatabaseNameInstance);
                    }
                    
                    Element destinationServerNameElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "DestinationServerName");
                    if (destinationServerNameElement != null) {
                        String destinationServerNameInstance;
                        destinationServerNameInstance = destinationServerNameElement.getTextContent();
                        serviceResourceInstance.setDestinationServerName(destinationServerNameInstance);
                    }
                    
                    Element destinationDatabaseNameElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "DestinationDatabaseName");
                    if (destinationDatabaseNameElement != null) {
                        String destinationDatabaseNameInstance;
                        destinationDatabaseNameInstance = destinationDatabaseNameElement.getTextContent();
                        serviceResourceInstance.setDestinationDatabaseName(destinationDatabaseNameInstance);
                    }
                    
                    Element isContinuousElement2 = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "IsContinuous");
                    if (isContinuousElement2 != null) {
                        boolean isContinuousInstance;
                        isContinuousInstance = DatatypeConverter.parseBoolean(isContinuousElement2.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsContinuous(isContinuousInstance);
                    }
                    
                    Element replicationStateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "ReplicationState");
                    if (replicationStateElement != null) {
                        byte replicationStateInstance;
                        replicationStateInstance = DatatypeConverter.parseByte(replicationStateElement.getTextContent());
                        serviceResourceInstance.setReplicationState(replicationStateInstance);
                    }
                    
                    Element replicationStateDescriptionElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "ReplicationStateDescription");
                    if (replicationStateDescriptionElement != null) {
                        String replicationStateDescriptionInstance;
                        replicationStateDescriptionInstance = replicationStateDescriptionElement.getTextContent();
                        serviceResourceInstance.setReplicationStateDescription(replicationStateDescriptionInstance);
                    }
                    
                    Element localDatabaseIdElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "LocalDatabaseId");
                    if (localDatabaseIdElement != null) {
                        int localDatabaseIdInstance;
                        localDatabaseIdInstance = DatatypeConverter.parseInt(localDatabaseIdElement.getTextContent());
                        serviceResourceInstance.setLocalDatabaseId(localDatabaseIdInstance);
                    }
                    
                    Element isLocalDatabaseReplicationTargetElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "IsLocalDatabaseReplicationTarget");
                    if (isLocalDatabaseReplicationTargetElement != null) {
                        boolean isLocalDatabaseReplicationTargetInstance;
                        isLocalDatabaseReplicationTargetInstance = DatatypeConverter.parseBoolean(isLocalDatabaseReplicationTargetElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsLocalDatabaseReplicationTarget(isLocalDatabaseReplicationTargetInstance);
                    }
                    
                    Element isInterlinkConnectedElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "IsInterlinkConnected");
                    if (isInterlinkConnectedElement != null) {
                        boolean isInterlinkConnectedInstance;
                        isInterlinkConnectedInstance = DatatypeConverter.parseBoolean(isInterlinkConnectedElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsInterlinkConnected(isInterlinkConnectedInstance);
                    }
                    
                    Element startDateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "StartDate");
                    if (startDateElement != null) {
                        String startDateInstance;
                        startDateInstance = startDateElement.getTextContent();
                        serviceResourceInstance.setStartDate(startDateInstance);
                    }
                    
                    Element modifyDateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "ModifyDate");
                    if (modifyDateElement != null) {
                        String modifyDateInstance;
                        modifyDateInstance = modifyDateElement.getTextContent();
                        serviceResourceInstance.setModifyDate(modifyDateInstance);
                    }
                    
                    Element percentCompleteElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "PercentComplete");
                    if (percentCompleteElement != null) {
                        float percentCompleteInstance;
                        percentCompleteInstance = DatatypeConverter.parseFloat(percentCompleteElement.getTextContent());
                        serviceResourceInstance.setPercentComplete(percentCompleteInstance);
                    }
                    
                    Element isOfflineSecondaryElement2 = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "IsOfflineSecondary");
                    if (isOfflineSecondaryElement2 != null) {
                        boolean isOfflineSecondaryInstance;
                        isOfflineSecondaryInstance = DatatypeConverter.parseBoolean(isOfflineSecondaryElement2.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsOfflineSecondary(isOfflineSecondaryInstance);
                    }
                    
                    Element isTerminationAllowedElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "IsTerminationAllowed");
                    if (isTerminationAllowedElement != null) {
                        boolean isTerminationAllowedInstance;
                        isTerminationAllowedInstance = DatatypeConverter.parseBoolean(isTerminationAllowedElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsTerminationAllowed(isTerminationAllowedInstance);
                    }
                    
                    Element nameElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "Name");
                    if (nameElement != null) {
                        String nameInstance;
                        nameInstance = nameElement.getTextContent();
                        serviceResourceInstance.setName(nameInstance);
                    }
                    
                    Element typeElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "Type");
                    if (typeElement != null) {
                        String typeInstance;
                        typeInstance = typeElement.getTextContent();
                        serviceResourceInstance.setType(typeInstance);
                    }
                    
                    Element stateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "State");
                    if (stateElement != null) {
                        String stateInstance;
                        stateInstance = stateElement.getTextContent();
                        serviceResourceInstance.setState(stateInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Stops a SQL Server database copy.
    *
    * @param serverName Required. The name of the source or destination SQL
    * Server instance.
    * @param databaseName Required. The name of the database.
    * @param databaseCopyName Required. The unique identifier for the database
    * copy to stop.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String serverName, final String databaseName, final String databaseCopyName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(serverName, databaseName, databaseCopyName);
            }
         });
    }
    
    /**
    * Stops a SQL Server database copy.
    *
    * @param serverName Required. The name of the source or destination SQL
    * Server instance.
    * @param databaseName Required. The name of the database.
    * @param databaseCopyName Required. The unique identifier for the database
    * copy to stop.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String serverName, String databaseName, String databaseCopyName) throws IOException, ServiceException {
        // Validate
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        if (databaseCopyName == null) {
            throw new NullPointerException("databaseCopyName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            tracingParameters.put("databaseCopyName", databaseCopyName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/databasecopies/";
        url = url + URLEncoder.encode(databaseCopyName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Retrieves information about a SQL Server database copy.
    *
    * @param serverName Required. The name of the source or destination SQL
    * Server instance.
    * @param databaseName Required. The name of the database.
    * @param databaseCopyName Required. The unique identifier for the database
    * copy to retrieve.
    * @return Represents a response to the get request.
    */
    @Override
    public Future<DatabaseCopyGetResponse> getAsync(final String serverName, final String databaseName, final String databaseCopyName) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseCopyGetResponse>() { 
            @Override
            public DatabaseCopyGetResponse call() throws Exception {
                return get(serverName, databaseName, databaseCopyName);
            }
         });
    }
    
    /**
    * Retrieves information about a SQL Server database copy.
    *
    * @param serverName Required. The name of the source or destination SQL
    * Server instance.
    * @param databaseName Required. The name of the database.
    * @param databaseCopyName Required. The unique identifier for the database
    * copy to retrieve.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return Represents a response to the get request.
    */
    @Override
    public DatabaseCopyGetResponse get(String serverName, String databaseName, String databaseCopyName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        if (databaseCopyName == null) {
            throw new NullPointerException("databaseCopyName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            tracingParameters.put("databaseCopyName", databaseCopyName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/databasecopies/";
        url = url + URLEncoder.encode(databaseCopyName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DatabaseCopyGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DatabaseCopyGetResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element serviceResourceElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "ServiceResource");
                if (serviceResourceElement != null) {
                    DatabaseCopy serviceResourceInstance = new DatabaseCopy();
                    result.setDatabaseCopy(serviceResourceInstance);
                    
                    Element sourceServerNameElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "SourceServerName");
                    if (sourceServerNameElement != null) {
                        String sourceServerNameInstance;
                        sourceServerNameInstance = sourceServerNameElement.getTextContent();
                        serviceResourceInstance.setSourceServerName(sourceServerNameInstance);
                    }
                    
                    Element sourceDatabaseNameElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "SourceDatabaseName");
                    if (sourceDatabaseNameElement != null) {
                        String sourceDatabaseNameInstance;
                        sourceDatabaseNameInstance = sourceDatabaseNameElement.getTextContent();
                        serviceResourceInstance.setSourceDatabaseName(sourceDatabaseNameInstance);
                    }
                    
                    Element destinationServerNameElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "DestinationServerName");
                    if (destinationServerNameElement != null) {
                        String destinationServerNameInstance;
                        destinationServerNameInstance = destinationServerNameElement.getTextContent();
                        serviceResourceInstance.setDestinationServerName(destinationServerNameInstance);
                    }
                    
                    Element destinationDatabaseNameElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "DestinationDatabaseName");
                    if (destinationDatabaseNameElement != null) {
                        String destinationDatabaseNameInstance;
                        destinationDatabaseNameInstance = destinationDatabaseNameElement.getTextContent();
                        serviceResourceInstance.setDestinationDatabaseName(destinationDatabaseNameInstance);
                    }
                    
                    Element isContinuousElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "IsContinuous");
                    if (isContinuousElement != null) {
                        boolean isContinuousInstance;
                        isContinuousInstance = DatatypeConverter.parseBoolean(isContinuousElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsContinuous(isContinuousInstance);
                    }
                    
                    Element replicationStateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "ReplicationState");
                    if (replicationStateElement != null) {
                        byte replicationStateInstance;
                        replicationStateInstance = DatatypeConverter.parseByte(replicationStateElement.getTextContent());
                        serviceResourceInstance.setReplicationState(replicationStateInstance);
                    }
                    
                    Element replicationStateDescriptionElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "ReplicationStateDescription");
                    if (replicationStateDescriptionElement != null) {
                        String replicationStateDescriptionInstance;
                        replicationStateDescriptionInstance = replicationStateDescriptionElement.getTextContent();
                        serviceResourceInstance.setReplicationStateDescription(replicationStateDescriptionInstance);
                    }
                    
                    Element localDatabaseIdElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "LocalDatabaseId");
                    if (localDatabaseIdElement != null) {
                        int localDatabaseIdInstance;
                        localDatabaseIdInstance = DatatypeConverter.parseInt(localDatabaseIdElement.getTextContent());
                        serviceResourceInstance.setLocalDatabaseId(localDatabaseIdInstance);
                    }
                    
                    Element isLocalDatabaseReplicationTargetElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "IsLocalDatabaseReplicationTarget");
                    if (isLocalDatabaseReplicationTargetElement != null) {
                        boolean isLocalDatabaseReplicationTargetInstance;
                        isLocalDatabaseReplicationTargetInstance = DatatypeConverter.parseBoolean(isLocalDatabaseReplicationTargetElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsLocalDatabaseReplicationTarget(isLocalDatabaseReplicationTargetInstance);
                    }
                    
                    Element isInterlinkConnectedElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "IsInterlinkConnected");
                    if (isInterlinkConnectedElement != null) {
                        boolean isInterlinkConnectedInstance;
                        isInterlinkConnectedInstance = DatatypeConverter.parseBoolean(isInterlinkConnectedElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsInterlinkConnected(isInterlinkConnectedInstance);
                    }
                    
                    Element startDateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "StartDate");
                    if (startDateElement != null) {
                        String startDateInstance;
                        startDateInstance = startDateElement.getTextContent();
                        serviceResourceInstance.setStartDate(startDateInstance);
                    }
                    
                    Element modifyDateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "ModifyDate");
                    if (modifyDateElement != null) {
                        String modifyDateInstance;
                        modifyDateInstance = modifyDateElement.getTextContent();
                        serviceResourceInstance.setModifyDate(modifyDateInstance);
                    }
                    
                    Element percentCompleteElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "PercentComplete");
                    if (percentCompleteElement != null) {
                        float percentCompleteInstance;
                        percentCompleteInstance = DatatypeConverter.parseFloat(percentCompleteElement.getTextContent());
                        serviceResourceInstance.setPercentComplete(percentCompleteInstance);
                    }
                    
                    Element isOfflineSecondaryElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "IsOfflineSecondary");
                    if (isOfflineSecondaryElement != null) {
                        boolean isOfflineSecondaryInstance;
                        isOfflineSecondaryInstance = DatatypeConverter.parseBoolean(isOfflineSecondaryElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsOfflineSecondary(isOfflineSecondaryInstance);
                    }
                    
                    Element isTerminationAllowedElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "IsTerminationAllowed");
                    if (isTerminationAllowedElement != null) {
                        boolean isTerminationAllowedInstance;
                        isTerminationAllowedInstance = DatatypeConverter.parseBoolean(isTerminationAllowedElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsTerminationAllowed(isTerminationAllowedInstance);
                    }
                    
                    Element nameElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "Name");
                    if (nameElement != null) {
                        String nameInstance;
                        nameInstance = nameElement.getTextContent();
                        serviceResourceInstance.setName(nameInstance);
                    }
                    
                    Element typeElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "Type");
                    if (typeElement != null) {
                        String typeInstance;
                        typeInstance = typeElement.getTextContent();
                        serviceResourceInstance.setType(typeInstance);
                    }
                    
                    Element stateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "State");
                    if (stateElement != null) {
                        String stateInstance;
                        stateInstance = stateElement.getTextContent();
                        serviceResourceInstance.setState(stateInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Retrieves the list of SQL Server database copies for a database.
    *
    * @param serverName Required. The name of the database server to be queried.
    * @param databaseName Required. The name of the database to be queried.
    * @return Represents the response containing the list of database copies
    * for a given database.
    */
    @Override
    public Future<DatabaseCopyListResponse> listAsync(final String serverName, final String databaseName) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseCopyListResponse>() { 
            @Override
            public DatabaseCopyListResponse call() throws Exception {
                return list(serverName, databaseName);
            }
         });
    }
    
    /**
    * Retrieves the list of SQL Server database copies for a database.
    *
    * @param serverName Required. The name of the database server to be queried.
    * @param databaseName Required. The name of the database to be queried.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return Represents the response containing the list of database copies
    * for a given database.
    */
    @Override
    public DatabaseCopyListResponse list(String serverName, String databaseName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/databasecopies";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DatabaseCopyListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DatabaseCopyListResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element serviceResourcesSequenceElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "ServiceResources");
                if (serviceResourcesSequenceElement != null) {
                    for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(serviceResourcesSequenceElement, "http://schemas.microsoft.com/windowsazure", "ServiceResource").size(); i1 = i1 + 1) {
                        org.w3c.dom.Element serviceResourcesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(serviceResourcesSequenceElement, "http://schemas.microsoft.com/windowsazure", "ServiceResource").get(i1));
                        DatabaseCopy serviceResourceInstance = new DatabaseCopy();
                        result.getDatabaseCopies().add(serviceResourceInstance);
                        
                        Element sourceServerNameElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "SourceServerName");
                        if (sourceServerNameElement != null) {
                            String sourceServerNameInstance;
                            sourceServerNameInstance = sourceServerNameElement.getTextContent();
                            serviceResourceInstance.setSourceServerName(sourceServerNameInstance);
                        }
                        
                        Element sourceDatabaseNameElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "SourceDatabaseName");
                        if (sourceDatabaseNameElement != null) {
                            String sourceDatabaseNameInstance;
                            sourceDatabaseNameInstance = sourceDatabaseNameElement.getTextContent();
                            serviceResourceInstance.setSourceDatabaseName(sourceDatabaseNameInstance);
                        }
                        
                        Element destinationServerNameElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "DestinationServerName");
                        if (destinationServerNameElement != null) {
                            String destinationServerNameInstance;
                            destinationServerNameInstance = destinationServerNameElement.getTextContent();
                            serviceResourceInstance.setDestinationServerName(destinationServerNameInstance);
                        }
                        
                        Element destinationDatabaseNameElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "DestinationDatabaseName");
                        if (destinationDatabaseNameElement != null) {
                            String destinationDatabaseNameInstance;
                            destinationDatabaseNameInstance = destinationDatabaseNameElement.getTextContent();
                            serviceResourceInstance.setDestinationDatabaseName(destinationDatabaseNameInstance);
                        }
                        
                        Element isContinuousElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "IsContinuous");
                        if (isContinuousElement != null) {
                            boolean isContinuousInstance;
                            isContinuousInstance = DatatypeConverter.parseBoolean(isContinuousElement.getTextContent().toLowerCase());
                            serviceResourceInstance.setIsContinuous(isContinuousInstance);
                        }
                        
                        Element replicationStateElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "ReplicationState");
                        if (replicationStateElement != null) {
                            byte replicationStateInstance;
                            replicationStateInstance = DatatypeConverter.parseByte(replicationStateElement.getTextContent());
                            serviceResourceInstance.setReplicationState(replicationStateInstance);
                        }
                        
                        Element replicationStateDescriptionElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "ReplicationStateDescription");
                        if (replicationStateDescriptionElement != null) {
                            String replicationStateDescriptionInstance;
                            replicationStateDescriptionInstance = replicationStateDescriptionElement.getTextContent();
                            serviceResourceInstance.setReplicationStateDescription(replicationStateDescriptionInstance);
                        }
                        
                        Element localDatabaseIdElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "LocalDatabaseId");
                        if (localDatabaseIdElement != null) {
                            int localDatabaseIdInstance;
                            localDatabaseIdInstance = DatatypeConverter.parseInt(localDatabaseIdElement.getTextContent());
                            serviceResourceInstance.setLocalDatabaseId(localDatabaseIdInstance);
                        }
                        
                        Element isLocalDatabaseReplicationTargetElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "IsLocalDatabaseReplicationTarget");
                        if (isLocalDatabaseReplicationTargetElement != null) {
                            boolean isLocalDatabaseReplicationTargetInstance;
                            isLocalDatabaseReplicationTargetInstance = DatatypeConverter.parseBoolean(isLocalDatabaseReplicationTargetElement.getTextContent().toLowerCase());
                            serviceResourceInstance.setIsLocalDatabaseReplicationTarget(isLocalDatabaseReplicationTargetInstance);
                        }
                        
                        Element isInterlinkConnectedElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "IsInterlinkConnected");
                        if (isInterlinkConnectedElement != null) {
                            boolean isInterlinkConnectedInstance;
                            isInterlinkConnectedInstance = DatatypeConverter.parseBoolean(isInterlinkConnectedElement.getTextContent().toLowerCase());
                            serviceResourceInstance.setIsInterlinkConnected(isInterlinkConnectedInstance);
                        }
                        
                        Element startDateElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "StartDate");
                        if (startDateElement != null) {
                            String startDateInstance;
                            startDateInstance = startDateElement.getTextContent();
                            serviceResourceInstance.setStartDate(startDateInstance);
                        }
                        
                        Element modifyDateElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "ModifyDate");
                        if (modifyDateElement != null) {
                            String modifyDateInstance;
                            modifyDateInstance = modifyDateElement.getTextContent();
                            serviceResourceInstance.setModifyDate(modifyDateInstance);
                        }
                        
                        Element percentCompleteElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "PercentComplete");
                        if (percentCompleteElement != null) {
                            float percentCompleteInstance;
                            percentCompleteInstance = DatatypeConverter.parseFloat(percentCompleteElement.getTextContent());
                            serviceResourceInstance.setPercentComplete(percentCompleteInstance);
                        }
                        
                        Element isOfflineSecondaryElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "IsOfflineSecondary");
                        if (isOfflineSecondaryElement != null) {
                            boolean isOfflineSecondaryInstance;
                            isOfflineSecondaryInstance = DatatypeConverter.parseBoolean(isOfflineSecondaryElement.getTextContent().toLowerCase());
                            serviceResourceInstance.setIsOfflineSecondary(isOfflineSecondaryInstance);
                        }
                        
                        Element isTerminationAllowedElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "IsTerminationAllowed");
                        if (isTerminationAllowedElement != null) {
                            boolean isTerminationAllowedInstance;
                            isTerminationAllowedInstance = DatatypeConverter.parseBoolean(isTerminationAllowedElement.getTextContent().toLowerCase());
                            serviceResourceInstance.setIsTerminationAllowed(isTerminationAllowedInstance);
                        }
                        
                        Element nameElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "Name");
                        if (nameElement != null) {
                            String nameInstance;
                            nameInstance = nameElement.getTextContent();
                            serviceResourceInstance.setName(nameInstance);
                        }
                        
                        Element typeElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "Type");
                        if (typeElement != null) {
                            String typeInstance;
                            typeInstance = typeElement.getTextContent();
                            serviceResourceInstance.setType(typeInstance);
                        }
                        
                        Element stateElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "State");
                        if (stateElement != null) {
                            String stateInstance;
                            stateInstance = stateElement.getTextContent();
                            serviceResourceInstance.setState(stateInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Updates a SQL Server database copy.
    *
    * @param serverName Required. The name of the source or destination SQL
    * Server instance.
    * @param databaseName Required. The name of the database.
    * @param databaseCopyName Required. The unique identifier for the database
    * copy to update.
    * @param parameters Required. The additional parameters for the update
    * database copy operation.
    * @return Represents a response to the update request.
    */
    @Override
    public Future<DatabaseCopyUpdateResponse> updateAsync(final String serverName, final String databaseName, final String databaseCopyName, final DatabaseCopyUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseCopyUpdateResponse>() { 
            @Override
            public DatabaseCopyUpdateResponse call() throws Exception {
                return update(serverName, databaseName, databaseCopyName, parameters);
            }
         });
    }
    
    /**
    * Updates a SQL Server database copy.
    *
    * @param serverName Required. The name of the source or destination SQL
    * Server instance.
    * @param databaseName Required. The name of the database.
    * @param databaseCopyName Required. The unique identifier for the database
    * copy to update.
    * @param parameters Required. The additional parameters for the update
    * database copy operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents a response to the update request.
    */
    @Override
    public DatabaseCopyUpdateResponse update(String serverName, String databaseName, String databaseCopyName, DatabaseCopyUpdateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        if (databaseCopyName == null) {
            throw new NullPointerException("databaseCopyName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            tracingParameters.put("databaseCopyName", databaseCopyName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "updateAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/databasecopies/";
        url = url + URLEncoder.encode(databaseCopyName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element serviceResourceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ServiceResource");
        requestDoc.appendChild(serviceResourceElement);
        
        if (parameters.isForcedTerminate() != null) {
            Element isForcedTerminateElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IsForcedTerminate");
            isForcedTerminateElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isForcedTerminate()).toLowerCase()));
            serviceResourceElement.appendChild(isForcedTerminateElement);
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DatabaseCopyUpdateResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DatabaseCopyUpdateResponse();
                DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
                documentBuilderFactory2.setNamespaceAware(true);
                DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
                Document responseDoc = documentBuilder2.parse(new BOMInputStream(responseContent));
                
                Element serviceResourceElement2 = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "ServiceResource");
                if (serviceResourceElement2 != null) {
                    DatabaseCopy serviceResourceInstance = new DatabaseCopy();
                    result.setDatabaseCopy(serviceResourceInstance);
                    
                    Element sourceServerNameElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "SourceServerName");
                    if (sourceServerNameElement != null) {
                        String sourceServerNameInstance;
                        sourceServerNameInstance = sourceServerNameElement.getTextContent();
                        serviceResourceInstance.setSourceServerName(sourceServerNameInstance);
                    }
                    
                    Element sourceDatabaseNameElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "SourceDatabaseName");
                    if (sourceDatabaseNameElement != null) {
                        String sourceDatabaseNameInstance;
                        sourceDatabaseNameInstance = sourceDatabaseNameElement.getTextContent();
                        serviceResourceInstance.setSourceDatabaseName(sourceDatabaseNameInstance);
                    }
                    
                    Element destinationServerNameElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "DestinationServerName");
                    if (destinationServerNameElement != null) {
                        String destinationServerNameInstance;
                        destinationServerNameInstance = destinationServerNameElement.getTextContent();
                        serviceResourceInstance.setDestinationServerName(destinationServerNameInstance);
                    }
                    
                    Element destinationDatabaseNameElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "DestinationDatabaseName");
                    if (destinationDatabaseNameElement != null) {
                        String destinationDatabaseNameInstance;
                        destinationDatabaseNameInstance = destinationDatabaseNameElement.getTextContent();
                        serviceResourceInstance.setDestinationDatabaseName(destinationDatabaseNameInstance);
                    }
                    
                    Element isContinuousElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "IsContinuous");
                    if (isContinuousElement != null) {
                        boolean isContinuousInstance;
                        isContinuousInstance = DatatypeConverter.parseBoolean(isContinuousElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsContinuous(isContinuousInstance);
                    }
                    
                    Element replicationStateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "ReplicationState");
                    if (replicationStateElement != null) {
                        byte replicationStateInstance;
                        replicationStateInstance = DatatypeConverter.parseByte(replicationStateElement.getTextContent());
                        serviceResourceInstance.setReplicationState(replicationStateInstance);
                    }
                    
                    Element replicationStateDescriptionElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "ReplicationStateDescription");
                    if (replicationStateDescriptionElement != null) {
                        String replicationStateDescriptionInstance;
                        replicationStateDescriptionInstance = replicationStateDescriptionElement.getTextContent();
                        serviceResourceInstance.setReplicationStateDescription(replicationStateDescriptionInstance);
                    }
                    
                    Element localDatabaseIdElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "LocalDatabaseId");
                    if (localDatabaseIdElement != null) {
                        int localDatabaseIdInstance;
                        localDatabaseIdInstance = DatatypeConverter.parseInt(localDatabaseIdElement.getTextContent());
                        serviceResourceInstance.setLocalDatabaseId(localDatabaseIdInstance);
                    }
                    
                    Element isLocalDatabaseReplicationTargetElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "IsLocalDatabaseReplicationTarget");
                    if (isLocalDatabaseReplicationTargetElement != null) {
                        boolean isLocalDatabaseReplicationTargetInstance;
                        isLocalDatabaseReplicationTargetInstance = DatatypeConverter.parseBoolean(isLocalDatabaseReplicationTargetElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsLocalDatabaseReplicationTarget(isLocalDatabaseReplicationTargetInstance);
                    }
                    
                    Element isInterlinkConnectedElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "IsInterlinkConnected");
                    if (isInterlinkConnectedElement != null) {
                        boolean isInterlinkConnectedInstance;
                        isInterlinkConnectedInstance = DatatypeConverter.parseBoolean(isInterlinkConnectedElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsInterlinkConnected(isInterlinkConnectedInstance);
                    }
                    
                    Element startDateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "StartDate");
                    if (startDateElement != null) {
                        String startDateInstance;
                        startDateInstance = startDateElement.getTextContent();
                        serviceResourceInstance.setStartDate(startDateInstance);
                    }
                    
                    Element modifyDateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "ModifyDate");
                    if (modifyDateElement != null) {
                        String modifyDateInstance;
                        modifyDateInstance = modifyDateElement.getTextContent();
                        serviceResourceInstance.setModifyDate(modifyDateInstance);
                    }
                    
                    Element percentCompleteElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "PercentComplete");
                    if (percentCompleteElement != null) {
                        float percentCompleteInstance;
                        percentCompleteInstance = DatatypeConverter.parseFloat(percentCompleteElement.getTextContent());
                        serviceResourceInstance.setPercentComplete(percentCompleteInstance);
                    }
                    
                    Element isOfflineSecondaryElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "IsOfflineSecondary");
                    if (isOfflineSecondaryElement != null) {
                        boolean isOfflineSecondaryInstance;
                        isOfflineSecondaryInstance = DatatypeConverter.parseBoolean(isOfflineSecondaryElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsOfflineSecondary(isOfflineSecondaryInstance);
                    }
                    
                    Element isTerminationAllowedElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "IsTerminationAllowed");
                    if (isTerminationAllowedElement != null) {
                        boolean isTerminationAllowedInstance;
                        isTerminationAllowedInstance = DatatypeConverter.parseBoolean(isTerminationAllowedElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsTerminationAllowed(isTerminationAllowedInstance);
                    }
                    
                    Element nameElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "Name");
                    if (nameElement != null) {
                        String nameInstance;
                        nameInstance = nameElement.getTextContent();
                        serviceResourceInstance.setName(nameInstance);
                    }
                    
                    Element typeElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "Type");
                    if (typeElement != null) {
                        String typeInstance;
                        typeInstance = typeElement.getTextContent();
                        serviceResourceInstance.setType(typeInstance);
                    }
                    
                    Element stateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "State");
                    if (stateElement != null) {
                        String stateInstance;
                        stateInstance = stateElement.getTextContent();
                        serviceResourceInstance.setState(stateInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
