/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.sql;

import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.sql.models.DatabaseOperationGetResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseOperationListResponse;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;
import java.util.concurrent.Future;

/**
* The Azure SQL Database Management API includes operations for getting
* database operations. Specifically, this API allows you to get a specific
* operation, or to list all the operations that happened on a specific
* database or on all databases in the Azure SQL Database Server.
*/
public interface DatabaseOperationOperations {
    /**
    * Returns information about a specific operation by using the operation
    * Guid.
    *
    * @param serverName Required. The name of the Azure SQL Database Server
    * where the database is hosted.
    * @param operationGuid Required. The Guid of the Azure SQL Database
    * operation to be obtained.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return Represents the database operation for a given operation Guid.
    */
    DatabaseOperationGetResponse get(String serverName, String operationGuid) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * Returns information about a specific operation by using the operation
    * Guid.
    *
    * @param serverName Required. The name of the Azure SQL Database Server
    * where the database is hosted.
    * @param operationGuid Required. The Guid of the Azure SQL Database
    * operation to be obtained.
    * @return Represents the database operation for a given operation Guid.
    */
    Future<DatabaseOperationGetResponse> getAsync(String serverName, String operationGuid);
    
    /**
    * Retrieves all of the operations that took place on a specific database.
    *
    * @param serverName Required. The name of the Azure SQL Database Server
    * that hosts the database.
    * @param databaseName Required. The name of the database for which the
    * operations should be retrieved.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return Represents the response containing the list of database
    * operations for a given server or database.
    */
    DatabaseOperationListResponse listByDatabase(String serverName, String databaseName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * Retrieves all of the operations that took place on a specific database.
    *
    * @param serverName Required. The name of the Azure SQL Database Server
    * that hosts the database.
    * @param databaseName Required. The name of the database for which the
    * operations should be retrieved.
    * @return Represents the response containing the list of database
    * operations for a given server or database.
    */
    Future<DatabaseOperationListResponse> listByDatabaseAsync(String serverName, String databaseName);
    
    /**
    * Retrieves all of the operations that occured on the Azure SQL Database
    * Server.
    *
    * @param serverName Required. The name of the Azure SQL Database Server to
    * be queried.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return Represents the response containing the list of database
    * operations for a given server or database.
    */
    DatabaseOperationListResponse listByServer(String serverName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * Retrieves all of the operations that occured on the Azure SQL Database
    * Server.
    *
    * @param serverName Required. The name of the Azure SQL Database Server to
    * be queried.
    * @return Represents the response containing the list of database
    * operations for a given server or database.
    */
    Future<DatabaseOperationListResponse> listByServerAsync(String serverName);
}
