/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.sql;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.sql.models.DatabaseCreateParameters;
import com.microsoft.windowsazure.management.sql.models.DatabaseCreateResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseGetEventLogsParameters;
import com.microsoft.windowsazure.management.sql.models.DatabaseGetEventLogsResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseGetResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseListResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseUpdateParameters;
import com.microsoft.windowsazure.management.sql.models.DatabaseUpdateResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseUsagesListResponse;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import java.io.IOException;
import java.util.concurrent.Future;

/**
* Represents all the operations for operating on Azure SQL Databases.  Contains
* operations to: Create, Retrieve, Update, and Delete databases, and also
* includes the ability to get the event logs for a database.
*/
public interface DatabaseOperations {
    /**
    * Creates a database in an Azure SQL Database Server.
    *
    * @param serverName Required. The name of the Azure SQL Database Server
    * where the database will be created.
    * @param parameters Required. The parameters for the create database
    * operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a create database request from the
    * service.
    */
    DatabaseCreateResponse create(String serverName, DatabaseCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * Creates a database in an Azure SQL Database Server.
    *
    * @param serverName Required. The name of the Azure SQL Database Server
    * where the database will be created.
    * @param parameters Required. The parameters for the create database
    * operation.
    * @return Represents the response to a create database request from the
    * service.
    */
    Future<DatabaseCreateResponse> createAsync(String serverName, DatabaseCreateParameters parameters);
    
    /**
    * Drops a database from an Azure SQL Database Server.
    *
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database to be
    * deleted.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse delete(String serverName, String databaseName) throws IOException, ServiceException;
    
    /**
    * Drops a database from an Azure SQL Database Server.
    *
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database to be
    * deleted.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteAsync(String serverName, String databaseName);
    
    /**
    * Returns information about an Azure SQL Database.
    *
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database to be
    * retrieved.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return Contains the response to a Get Database request.
    */
    DatabaseGetResponse get(String serverName, String databaseName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * Returns information about an Azure SQL Database.
    *
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database to be
    * retrieved.
    * @return Contains the response to a Get Database request.
    */
    Future<DatabaseGetResponse> getAsync(String serverName, String databaseName);
    
    /**
    * Returns information about an Azure SQL Database event logs.
    *
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database to be
    * retrieved.
    * @param parameters Required. The parameters for the Get Database Event
    * Logs operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return Contains the response to a Get Database Event Logs request.
    */
    DatabaseGetEventLogsResponse getEventLogs(String serverName, String databaseName, DatabaseGetEventLogsParameters parameters) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * Returns information about an Azure SQL Database event logs.
    *
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database to be
    * retrieved.
    * @param parameters Required. The parameters for the Get Database Event
    * Logs operation.
    * @return Contains the response to a Get Database Event Logs request.
    */
    Future<DatabaseGetEventLogsResponse> getEventLogsAsync(String serverName, String databaseName, DatabaseGetEventLogsParameters parameters);
    
    /**
    * Returns the usage information for an Azure SQL Database.
    *
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return Contains the response to a Get Database Usages request.
    */
    DatabaseUsagesListResponse getUsages(String serverName, String databaseName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * Returns the usage information for an Azure SQL Database.
    *
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database.
    * @return Contains the response to a Get Database Usages request.
    */
    Future<DatabaseUsagesListResponse> getUsagesAsync(String serverName, String databaseName);
    
    /**
    * Returns a collection of Azure SQL Databases.
    *
    * @param serverName Required. The name of the Azure SQL Database Server
    * from which to retrieve the database.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return Contains a collection of databases for a given Azure SQL Database
    * Server.
    */
    DatabaseListResponse list(String serverName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * Returns a collection of Azure SQL Databases.
    *
    * @param serverName Required. The name of the Azure SQL Database Server
    * from which to retrieve the database.
    * @return Contains a collection of databases for a given Azure SQL Database
    * Server.
    */
    Future<DatabaseListResponse> listAsync(String serverName);
    
    /**
    * Updates the properties of an Azure SQL Database.
    *
    * @param serverName Required. The name of the Azure SQL Database Server
    * where the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database to be
    * updated.
    * @param parameters Required. The parameters for the Update Database
    * operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Contains the response from a request to Update Database.
    */
    DatabaseUpdateResponse update(String serverName, String databaseName, DatabaseUpdateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * Updates the properties of an Azure SQL Database.
    *
    * @param serverName Required. The name of the Azure SQL Database Server
    * where the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database to be
    * updated.
    * @param parameters Required. The parameters for the Update Database
    * operation.
    * @return Contains the response from a request to Update Database.
    */
    Future<DatabaseUpdateResponse> updateAsync(String serverName, String databaseName, DatabaseUpdateParameters parameters);
}
