/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.sql;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.sql.models.Database;
import com.microsoft.windowsazure.management.sql.models.DatabaseCreateParameters;
import com.microsoft.windowsazure.management.sql.models.DatabaseCreateResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseEventLog;
import com.microsoft.windowsazure.management.sql.models.DatabaseGetEventLogsParameters;
import com.microsoft.windowsazure.management.sql.models.DatabaseGetEventLogsResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseGetResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseListResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseUpdateParameters;
import com.microsoft.windowsazure.management.sql.models.DatabaseUpdateResponse;
import com.microsoft.windowsazure.management.sql.models.DatabaseUsageMetric;
import com.microsoft.windowsazure.management.sql.models.DatabaseUsagesListResponse;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
* Represents all the operations for operating on Azure SQL Databases.  Contains
* operations to: Create, Retrieve, Update, and Delete databases, and also
* includes the ability to get the event logs for a database.
*/
public class DatabaseOperationsImpl implements ServiceOperations<SqlManagementClientImpl>, DatabaseOperations {
    /**
    * Initializes a new instance of the DatabaseOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    DatabaseOperationsImpl(SqlManagementClientImpl client) {
        this.client = client;
    }
    
    private SqlManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.windowsazure.management.sql.SqlManagementClientImpl.
    * @return The Client value.
    */
    public SqlManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Creates a database in an Azure SQL Database Server.
    *
    * @param serverName Required. The name of the Azure SQL Database Server
    * where the database will be created.
    * @param parameters Required. The parameters for the create database
    * operation.
    * @return Represents the response to a create database request from the
    * service.
    */
    @Override
    public Future<DatabaseCreateResponse> createAsync(final String serverName, final DatabaseCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseCreateResponse>() { 
            @Override
            public DatabaseCreateResponse call() throws Exception {
                return create(serverName, parameters);
            }
         });
    }
    
    /**
    * Creates a database in an Azure SQL Database Server.
    *
    * @param serverName Required. The name of the Azure SQL Database Server
    * where the database will be created.
    * @param parameters Required. The parameters for the create database
    * operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Represents the response to a create database request from the
    * service.
    */
    @Override
    public DatabaseCreateResponse create(String serverName, DatabaseCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getName() == null) {
            throw new NullPointerException("parameters.Name");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element serviceResourceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ServiceResource");
        requestDoc.appendChild(serviceResourceElement);
        
        Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
        nameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
        serviceResourceElement.appendChild(nameElement);
        
        if (parameters.getEdition() != null) {
            Element editionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Edition");
            editionElement.appendChild(requestDoc.createTextNode(parameters.getEdition()));
            serviceResourceElement.appendChild(editionElement);
        }
        
        if (parameters.getMaximumDatabaseSizeInGB() != null) {
            Element maxSizeGBElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MaxSizeGB");
            maxSizeGBElement.appendChild(requestDoc.createTextNode(Integer.toString(parameters.getMaximumDatabaseSizeInGB())));
            serviceResourceElement.appendChild(maxSizeGBElement);
        }
        
        if (parameters.getCollationName() != null) {
            Element collationNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CollationName");
            collationNameElement.appendChild(requestDoc.createTextNode(parameters.getCollationName()));
            serviceResourceElement.appendChild(collationNameElement);
        }
        
        if (parameters.getMaximumDatabaseSizeInBytes() != null) {
            Element maxSizeBytesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MaxSizeBytes");
            maxSizeBytesElement.appendChild(requestDoc.createTextNode(Long.toString(parameters.getMaximumDatabaseSizeInBytes())));
            serviceResourceElement.appendChild(maxSizeBytesElement);
        }
        
        if (parameters.getServiceObjectiveId() != null) {
            Element serviceObjectiveIdElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ServiceObjectiveId");
            serviceObjectiveIdElement.appendChild(requestDoc.createTextNode(parameters.getServiceObjectiveId()));
            serviceResourceElement.appendChild(serviceObjectiveIdElement);
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DatabaseCreateResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DatabaseCreateResponse();
                DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
                documentBuilderFactory2.setNamespaceAware(true);
                DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
                Document responseDoc = documentBuilder2.parse(new BOMInputStream(responseContent));
                
                Element serviceResourceElement2 = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "ServiceResource");
                if (serviceResourceElement2 != null) {
                    Database serviceResourceInstance = new Database();
                    result.setDatabase(serviceResourceInstance);
                    
                    Element idElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "Id");
                    if (idElement != null) {
                        int idInstance;
                        idInstance = DatatypeConverter.parseInt(idElement.getTextContent());
                        serviceResourceInstance.setId(idInstance);
                    }
                    
                    Element editionElement2 = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "Edition");
                    if (editionElement2 != null) {
                        String editionInstance;
                        editionInstance = editionElement2.getTextContent();
                        serviceResourceInstance.setEdition(editionInstance);
                    }
                    
                    Element maxSizeGBElement2 = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "MaxSizeGB");
                    if (maxSizeGBElement2 != null) {
                        int maxSizeGBInstance;
                        maxSizeGBInstance = DatatypeConverter.parseInt(maxSizeGBElement2.getTextContent());
                        serviceResourceInstance.setMaximumDatabaseSizeInGB(maxSizeGBInstance);
                    }
                    
                    Element maxSizeBytesElement2 = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "MaxSizeBytes");
                    if (maxSizeBytesElement2 != null) {
                        long maxSizeBytesInstance;
                        maxSizeBytesInstance = DatatypeConverter.parseLong(maxSizeBytesElement2.getTextContent());
                        serviceResourceInstance.setMaximumDatabaseSizeInBytes(maxSizeBytesInstance);
                    }
                    
                    Element collationNameElement2 = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "CollationName");
                    if (collationNameElement2 != null) {
                        String collationNameInstance;
                        collationNameInstance = collationNameElement2.getTextContent();
                        serviceResourceInstance.setCollationName(collationNameInstance);
                    }
                    
                    Element creationDateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "CreationDate");
                    if (creationDateElement != null) {
                        Calendar creationDateInstance;
                        creationDateInstance = DatatypeConverter.parseDateTime(creationDateElement.getTextContent());
                        serviceResourceInstance.setCreationDate(creationDateInstance);
                    }
                    
                    Element isFederationRootElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "IsFederationRoot");
                    if (isFederationRootElement != null) {
                        boolean isFederationRootInstance;
                        isFederationRootInstance = DatatypeConverter.parseBoolean(isFederationRootElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsFederationRoot(isFederationRootInstance);
                    }
                    
                    Element isSystemObjectElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "IsSystemObject");
                    if (isSystemObjectElement != null) {
                        boolean isSystemObjectInstance;
                        isSystemObjectInstance = DatatypeConverter.parseBoolean(isSystemObjectElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsSystemObject(isSystemObjectInstance);
                    }
                    
                    Element sizeMBElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "SizeMB");
                    if (sizeMBElement != null) {
                        String sizeMBInstance;
                        sizeMBInstance = sizeMBElement.getTextContent();
                        serviceResourceInstance.setSizeMB(sizeMBInstance);
                    }
                    
                    Element serviceObjectiveAssignmentErrorCodeElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "ServiceObjectiveAssignmentErrorCode");
                    if (serviceObjectiveAssignmentErrorCodeElement != null) {
                        String serviceObjectiveAssignmentErrorCodeInstance;
                        serviceObjectiveAssignmentErrorCodeInstance = serviceObjectiveAssignmentErrorCodeElement.getTextContent();
                        serviceResourceInstance.setServiceObjectiveAssignmentErrorCode(serviceObjectiveAssignmentErrorCodeInstance);
                    }
                    
                    Element serviceObjectiveAssignmentErrorDescriptionElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "ServiceObjectiveAssignmentErrorDescription");
                    if (serviceObjectiveAssignmentErrorDescriptionElement != null) {
                        String serviceObjectiveAssignmentErrorDescriptionInstance;
                        serviceObjectiveAssignmentErrorDescriptionInstance = serviceObjectiveAssignmentErrorDescriptionElement.getTextContent();
                        serviceResourceInstance.setServiceObjectiveAssignmentErrorDescription(serviceObjectiveAssignmentErrorDescriptionInstance);
                    }
                    
                    Element serviceObjectiveAssignmentStateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "ServiceObjectiveAssignmentState");
                    if (serviceObjectiveAssignmentStateElement != null) {
                        String serviceObjectiveAssignmentStateInstance;
                        serviceObjectiveAssignmentStateInstance = serviceObjectiveAssignmentStateElement.getTextContent();
                        serviceResourceInstance.setServiceObjectiveAssignmentState(serviceObjectiveAssignmentStateInstance);
                    }
                    
                    Element serviceObjectiveAssignmentStateDescriptionElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "ServiceObjectiveAssignmentStateDescription");
                    if (serviceObjectiveAssignmentStateDescriptionElement != null) {
                        String serviceObjectiveAssignmentStateDescriptionInstance;
                        serviceObjectiveAssignmentStateDescriptionInstance = serviceObjectiveAssignmentStateDescriptionElement.getTextContent();
                        serviceResourceInstance.setServiceObjectiveAssignmentStateDescription(serviceObjectiveAssignmentStateDescriptionInstance);
                    }
                    
                    Element serviceObjectiveAssignmentSuccessDateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "ServiceObjectiveAssignmentSuccessDate");
                    if (serviceObjectiveAssignmentSuccessDateElement != null) {
                        String serviceObjectiveAssignmentSuccessDateInstance;
                        serviceObjectiveAssignmentSuccessDateInstance = serviceObjectiveAssignmentSuccessDateElement.getTextContent();
                        serviceResourceInstance.setServiceObjectiveAssignmentSuccessDate(serviceObjectiveAssignmentSuccessDateInstance);
                    }
                    
                    Element serviceObjectiveIdElement2 = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "ServiceObjectiveId");
                    if (serviceObjectiveIdElement2 != null) {
                        String serviceObjectiveIdInstance;
                        serviceObjectiveIdInstance = serviceObjectiveIdElement2.getTextContent();
                        serviceResourceInstance.setServiceObjectiveId(serviceObjectiveIdInstance);
                    }
                    
                    Element assignedServiceObjectiveIdElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "AssignedServiceObjectiveId");
                    if (assignedServiceObjectiveIdElement != null) {
                        String assignedServiceObjectiveIdInstance;
                        assignedServiceObjectiveIdInstance = assignedServiceObjectiveIdElement.getTextContent();
                        serviceResourceInstance.setAssignedServiceObjectiveId(assignedServiceObjectiveIdInstance);
                    }
                    
                    Element recoveryPeriodStartDateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "RecoveryPeriodStartDate");
                    if (recoveryPeriodStartDateElement != null && recoveryPeriodStartDateElement.getTextContent() != null && !recoveryPeriodStartDateElement.getTextContent().isEmpty()) {
                        Calendar recoveryPeriodStartDateInstance;
                        recoveryPeriodStartDateInstance = DatatypeConverter.parseDateTime(recoveryPeriodStartDateElement.getTextContent());
                        serviceResourceInstance.setRecoveryPeriodStartDate(recoveryPeriodStartDateInstance);
                    }
                    
                    Element nameElement2 = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "Name");
                    if (nameElement2 != null) {
                        String nameInstance;
                        nameInstance = nameElement2.getTextContent();
                        serviceResourceInstance.setName(nameInstance);
                    }
                    
                    Element typeElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "Type");
                    if (typeElement != null) {
                        String typeInstance;
                        typeInstance = typeElement.getTextContent();
                        serviceResourceInstance.setType(typeInstance);
                    }
                    
                    Element stateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "State");
                    if (stateElement != null) {
                        String stateInstance;
                        stateInstance = stateElement.getTextContent();
                        serviceResourceInstance.setState(stateInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Drops a database from an Azure SQL Database Server.
    *
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database to be
    * deleted.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String serverName, final String databaseName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(serverName, databaseName);
            }
         });
    }
    
    /**
    * Drops a database from an Azure SQL Database Server.
    *
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database to be
    * deleted.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String serverName, String databaseName) throws IOException, ServiceException {
        // Validate
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Returns information about an Azure SQL Database.
    *
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database to be
    * retrieved.
    * @return Contains the response to a Get Database request.
    */
    @Override
    public Future<DatabaseGetResponse> getAsync(final String serverName, final String databaseName) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseGetResponse>() { 
            @Override
            public DatabaseGetResponse call() throws Exception {
                return get(serverName, databaseName);
            }
         });
    }
    
    /**
    * Returns information about an Azure SQL Database.
    *
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database to be
    * retrieved.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return Contains the response to a Get Database request.
    */
    @Override
    public DatabaseGetResponse get(String serverName, String databaseName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DatabaseGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DatabaseGetResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element serviceResourceElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "ServiceResource");
                if (serviceResourceElement != null) {
                    Database serviceResourceInstance = new Database();
                    result.setDatabase(serviceResourceInstance);
                    
                    Element idElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "Id");
                    if (idElement != null) {
                        int idInstance;
                        idInstance = DatatypeConverter.parseInt(idElement.getTextContent());
                        serviceResourceInstance.setId(idInstance);
                    }
                    
                    Element editionElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "Edition");
                    if (editionElement != null) {
                        String editionInstance;
                        editionInstance = editionElement.getTextContent();
                        serviceResourceInstance.setEdition(editionInstance);
                    }
                    
                    Element maxSizeGBElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "MaxSizeGB");
                    if (maxSizeGBElement != null) {
                        int maxSizeGBInstance;
                        maxSizeGBInstance = DatatypeConverter.parseInt(maxSizeGBElement.getTextContent());
                        serviceResourceInstance.setMaximumDatabaseSizeInGB(maxSizeGBInstance);
                    }
                    
                    Element maxSizeBytesElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "MaxSizeBytes");
                    if (maxSizeBytesElement != null) {
                        long maxSizeBytesInstance;
                        maxSizeBytesInstance = DatatypeConverter.parseLong(maxSizeBytesElement.getTextContent());
                        serviceResourceInstance.setMaximumDatabaseSizeInBytes(maxSizeBytesInstance);
                    }
                    
                    Element collationNameElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "CollationName");
                    if (collationNameElement != null) {
                        String collationNameInstance;
                        collationNameInstance = collationNameElement.getTextContent();
                        serviceResourceInstance.setCollationName(collationNameInstance);
                    }
                    
                    Element creationDateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "CreationDate");
                    if (creationDateElement != null) {
                        Calendar creationDateInstance;
                        creationDateInstance = DatatypeConverter.parseDateTime(creationDateElement.getTextContent());
                        serviceResourceInstance.setCreationDate(creationDateInstance);
                    }
                    
                    Element isFederationRootElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "IsFederationRoot");
                    if (isFederationRootElement != null) {
                        boolean isFederationRootInstance;
                        isFederationRootInstance = DatatypeConverter.parseBoolean(isFederationRootElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsFederationRoot(isFederationRootInstance);
                    }
                    
                    Element isSystemObjectElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "IsSystemObject");
                    if (isSystemObjectElement != null) {
                        boolean isSystemObjectInstance;
                        isSystemObjectInstance = DatatypeConverter.parseBoolean(isSystemObjectElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsSystemObject(isSystemObjectInstance);
                    }
                    
                    Element sizeMBElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "SizeMB");
                    if (sizeMBElement != null) {
                        String sizeMBInstance;
                        sizeMBInstance = sizeMBElement.getTextContent();
                        serviceResourceInstance.setSizeMB(sizeMBInstance);
                    }
                    
                    Element serviceObjectiveAssignmentErrorCodeElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "ServiceObjectiveAssignmentErrorCode");
                    if (serviceObjectiveAssignmentErrorCodeElement != null) {
                        String serviceObjectiveAssignmentErrorCodeInstance;
                        serviceObjectiveAssignmentErrorCodeInstance = serviceObjectiveAssignmentErrorCodeElement.getTextContent();
                        serviceResourceInstance.setServiceObjectiveAssignmentErrorCode(serviceObjectiveAssignmentErrorCodeInstance);
                    }
                    
                    Element serviceObjectiveAssignmentErrorDescriptionElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "ServiceObjectiveAssignmentErrorDescription");
                    if (serviceObjectiveAssignmentErrorDescriptionElement != null) {
                        String serviceObjectiveAssignmentErrorDescriptionInstance;
                        serviceObjectiveAssignmentErrorDescriptionInstance = serviceObjectiveAssignmentErrorDescriptionElement.getTextContent();
                        serviceResourceInstance.setServiceObjectiveAssignmentErrorDescription(serviceObjectiveAssignmentErrorDescriptionInstance);
                    }
                    
                    Element serviceObjectiveAssignmentStateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "ServiceObjectiveAssignmentState");
                    if (serviceObjectiveAssignmentStateElement != null) {
                        String serviceObjectiveAssignmentStateInstance;
                        serviceObjectiveAssignmentStateInstance = serviceObjectiveAssignmentStateElement.getTextContent();
                        serviceResourceInstance.setServiceObjectiveAssignmentState(serviceObjectiveAssignmentStateInstance);
                    }
                    
                    Element serviceObjectiveAssignmentStateDescriptionElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "ServiceObjectiveAssignmentStateDescription");
                    if (serviceObjectiveAssignmentStateDescriptionElement != null) {
                        String serviceObjectiveAssignmentStateDescriptionInstance;
                        serviceObjectiveAssignmentStateDescriptionInstance = serviceObjectiveAssignmentStateDescriptionElement.getTextContent();
                        serviceResourceInstance.setServiceObjectiveAssignmentStateDescription(serviceObjectiveAssignmentStateDescriptionInstance);
                    }
                    
                    Element serviceObjectiveAssignmentSuccessDateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "ServiceObjectiveAssignmentSuccessDate");
                    if (serviceObjectiveAssignmentSuccessDateElement != null) {
                        String serviceObjectiveAssignmentSuccessDateInstance;
                        serviceObjectiveAssignmentSuccessDateInstance = serviceObjectiveAssignmentSuccessDateElement.getTextContent();
                        serviceResourceInstance.setServiceObjectiveAssignmentSuccessDate(serviceObjectiveAssignmentSuccessDateInstance);
                    }
                    
                    Element serviceObjectiveIdElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "ServiceObjectiveId");
                    if (serviceObjectiveIdElement != null) {
                        String serviceObjectiveIdInstance;
                        serviceObjectiveIdInstance = serviceObjectiveIdElement.getTextContent();
                        serviceResourceInstance.setServiceObjectiveId(serviceObjectiveIdInstance);
                    }
                    
                    Element assignedServiceObjectiveIdElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "AssignedServiceObjectiveId");
                    if (assignedServiceObjectiveIdElement != null) {
                        String assignedServiceObjectiveIdInstance;
                        assignedServiceObjectiveIdInstance = assignedServiceObjectiveIdElement.getTextContent();
                        serviceResourceInstance.setAssignedServiceObjectiveId(assignedServiceObjectiveIdInstance);
                    }
                    
                    Element recoveryPeriodStartDateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "RecoveryPeriodStartDate");
                    if (recoveryPeriodStartDateElement != null && recoveryPeriodStartDateElement.getTextContent() != null && !recoveryPeriodStartDateElement.getTextContent().isEmpty()) {
                        Calendar recoveryPeriodStartDateInstance;
                        recoveryPeriodStartDateInstance = DatatypeConverter.parseDateTime(recoveryPeriodStartDateElement.getTextContent());
                        serviceResourceInstance.setRecoveryPeriodStartDate(recoveryPeriodStartDateInstance);
                    }
                    
                    Element nameElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "Name");
                    if (nameElement != null) {
                        String nameInstance;
                        nameInstance = nameElement.getTextContent();
                        serviceResourceInstance.setName(nameInstance);
                    }
                    
                    Element typeElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "Type");
                    if (typeElement != null) {
                        String typeInstance;
                        typeInstance = typeElement.getTextContent();
                        serviceResourceInstance.setType(typeInstance);
                    }
                    
                    Element stateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement, "http://schemas.microsoft.com/windowsazure", "State");
                    if (stateElement != null) {
                        String stateInstance;
                        stateInstance = stateElement.getTextContent();
                        serviceResourceInstance.setState(stateInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Returns information about an Azure SQL Database event logs.
    *
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database to be
    * retrieved.
    * @param parameters Required. The parameters for the Get Database Event
    * Logs operation.
    * @return Contains the response to a Get Database Event Logs request.
    */
    @Override
    public Future<DatabaseGetEventLogsResponse> getEventLogsAsync(final String serverName, final String databaseName, final DatabaseGetEventLogsParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseGetEventLogsResponse>() { 
            @Override
            public DatabaseGetEventLogsResponse call() throws Exception {
                return getEventLogs(serverName, databaseName, parameters);
            }
         });
    }
    
    /**
    * Returns information about an Azure SQL Database event logs.
    *
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database to be
    * retrieved.
    * @param parameters Required. The parameters for the Get Database Event
    * Logs operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return Contains the response to a Get Database Event Logs request.
    */
    @Override
    public DatabaseGetEventLogsResponse getEventLogs(String serverName, String databaseName, DatabaseGetEventLogsParameters parameters) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getEventTypes() == null) {
            throw new NullPointerException("parameters.EventTypes");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "getEventLogsAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/events";
        ArrayList<String> queryParameters = new ArrayList<String>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        queryParameters.add("startDate=" + URLEncoder.encode(simpleDateFormat.format(parameters.getStartDate().getTime()), "UTF-8"));
        queryParameters.add("intervalSizeInMinutes=" + URLEncoder.encode(Integer.toString(parameters.getIntervalSizeInMinutes()), "UTF-8"));
        queryParameters.add("eventTypes=" + URLEncoder.encode(parameters.getEventTypes(), "UTF-8"));
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DatabaseGetEventLogsResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DatabaseGetEventLogsResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element serviceResourcesSequenceElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "ServiceResources");
                if (serviceResourcesSequenceElement != null) {
                    for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(serviceResourcesSequenceElement, "http://schemas.microsoft.com/windowsazure", "ServiceResource").size(); i1 = i1 + 1) {
                        org.w3c.dom.Element serviceResourcesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(serviceResourcesSequenceElement, "http://schemas.microsoft.com/windowsazure", "ServiceResource").get(i1));
                        DatabaseEventLog serviceResourceInstance = new DatabaseEventLog();
                        result.getEventLogs().add(serviceResourceInstance);
                        
                        Element databaseNameElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "DatabaseName");
                        if (databaseNameElement != null) {
                            String databaseNameInstance;
                            databaseNameInstance = databaseNameElement.getTextContent();
                            serviceResourceInstance.setDatabaseName(databaseNameInstance);
                        }
                        
                        Element startTimeUtcElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "StartTimeUtc");
                        if (startTimeUtcElement != null) {
                            Calendar startTimeUtcInstance;
                            startTimeUtcInstance = DatatypeConverter.parseDateTime(startTimeUtcElement.getTextContent());
                            serviceResourceInstance.setStartTimeUtc(startTimeUtcInstance);
                        }
                        
                        Element intervalSizeInMinutesElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "IntervalSizeInMinutes");
                        if (intervalSizeInMinutesElement != null) {
                            int intervalSizeInMinutesInstance;
                            intervalSizeInMinutesInstance = DatatypeConverter.parseInt(intervalSizeInMinutesElement.getTextContent());
                            serviceResourceInstance.setIntervalSizeInMinutes(intervalSizeInMinutesInstance);
                        }
                        
                        Element eventCategoryElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "EventCategory");
                        if (eventCategoryElement != null) {
                            String eventCategoryInstance;
                            eventCategoryInstance = eventCategoryElement.getTextContent();
                            serviceResourceInstance.setEventCategory(eventCategoryInstance);
                        }
                        
                        Element eventTypeElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "EventType");
                        if (eventTypeElement != null) {
                            String eventTypeInstance;
                            eventTypeInstance = eventTypeElement.getTextContent();
                            serviceResourceInstance.setEventType(eventTypeInstance);
                        }
                        
                        Element eventSubtypeElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "EventSubtype");
                        if (eventSubtypeElement != null) {
                            String eventSubtypeInstance;
                            eventSubtypeInstance = eventSubtypeElement.getTextContent();
                            serviceResourceInstance.setEventSubtype(eventSubtypeInstance);
                        }
                        
                        Element eventSubtypeDescriptionElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "EventSubtypeDescription");
                        if (eventSubtypeDescriptionElement != null) {
                            String eventSubtypeDescriptionInstance;
                            eventSubtypeDescriptionInstance = eventSubtypeDescriptionElement.getTextContent();
                            serviceResourceInstance.setEventSubtypeDescription(eventSubtypeDescriptionInstance);
                        }
                        
                        Element numberOfEventsElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "NumberOfEvents");
                        if (numberOfEventsElement != null) {
                            int numberOfEventsInstance;
                            numberOfEventsInstance = DatatypeConverter.parseInt(numberOfEventsElement.getTextContent());
                            serviceResourceInstance.setNumberOfEvents(numberOfEventsInstance);
                        }
                        
                        Element severityElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "Severity");
                        if (severityElement != null) {
                            int severityInstance;
                            severityInstance = DatatypeConverter.parseInt(severityElement.getTextContent());
                            serviceResourceInstance.setSeverity(severityInstance);
                        }
                        
                        Element descriptionElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "Description");
                        if (descriptionElement != null) {
                            String descriptionInstance;
                            descriptionInstance = descriptionElement.getTextContent();
                            serviceResourceInstance.setDescription(descriptionInstance);
                        }
                        
                        Element additionalDataElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "AdditionalData");
                        if (additionalDataElement != null) {
                            boolean isNil = false;
                            Attr nilAttribute = additionalDataElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
                            if (nilAttribute != null) {
                                isNil = "true".equals(nilAttribute.getValue());
                            }
                            if (isNil == false) {
                                String additionalDataInstance;
                                additionalDataInstance = additionalDataElement.getTextContent();
                                serviceResourceInstance.setAdditionalData(additionalDataInstance);
                            }
                        }
                        
                        Element nameElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "Name");
                        if (nameElement != null) {
                            String nameInstance;
                            nameInstance = nameElement.getTextContent();
                            serviceResourceInstance.setName(nameInstance);
                        }
                        
                        Element typeElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "Type");
                        if (typeElement != null) {
                            String typeInstance;
                            typeInstance = typeElement.getTextContent();
                            serviceResourceInstance.setType(typeInstance);
                        }
                        
                        Element stateElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "State");
                        if (stateElement != null) {
                            String stateInstance;
                            stateInstance = stateElement.getTextContent();
                            serviceResourceInstance.setState(stateInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Returns the usage information for an Azure SQL Database.
    *
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database.
    * @return Contains the response to a Get Database Usages request.
    */
    @Override
    public Future<DatabaseUsagesListResponse> getUsagesAsync(final String serverName, final String databaseName) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseUsagesListResponse>() { 
            @Override
            public DatabaseUsagesListResponse call() throws Exception {
                return getUsages(serverName, databaseName);
            }
         });
    }
    
    /**
    * Returns the usage information for an Azure SQL Database.
    *
    * @param serverName Required. The name of the Azure SQL Database Server on
    * which the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return Contains the response to a Get Database Usages request.
    */
    @Override
    public DatabaseUsagesListResponse getUsages(String serverName, String databaseName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            CloudTracing.enter(invocationId, this, "getUsagesAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        url = url + "/usages";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DatabaseUsagesListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DatabaseUsagesListResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element usagesSequenceElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "Usages");
                if (usagesSequenceElement != null) {
                    for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(usagesSequenceElement, "http://schemas.microsoft.com/windowsazure", "Usage").size(); i1 = i1 + 1) {
                        org.w3c.dom.Element usagesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(usagesSequenceElement, "http://schemas.microsoft.com/windowsazure", "Usage").get(i1));
                        DatabaseUsageMetric usageInstance = new DatabaseUsageMetric();
                        result.getUsages().add(usageInstance);
                        
                        Element nameElement = XmlUtility.getElementByTagNameNS(usagesElement, "http://schemas.microsoft.com/windowsazure", "Name");
                        if (nameElement != null) {
                            String nameInstance;
                            nameInstance = nameElement.getTextContent();
                            usageInstance.setName(nameInstance);
                        }
                        
                        Element resourceNameElement = XmlUtility.getElementByTagNameNS(usagesElement, "http://schemas.microsoft.com/windowsazure", "ResourceName");
                        if (resourceNameElement != null) {
                            String resourceNameInstance;
                            resourceNameInstance = resourceNameElement.getTextContent();
                            usageInstance.setResourceName(resourceNameInstance);
                        }
                        
                        Element currentValueElement = XmlUtility.getElementByTagNameNS(usagesElement, "http://schemas.microsoft.com/windowsazure", "CurrentValue");
                        if (currentValueElement != null) {
                            String currentValueInstance;
                            currentValueInstance = currentValueElement.getTextContent();
                            usageInstance.setCurrentValue(currentValueInstance);
                        }
                        
                        Element limitElement = XmlUtility.getElementByTagNameNS(usagesElement, "http://schemas.microsoft.com/windowsazure", "Limit");
                        if (limitElement != null) {
                            String limitInstance;
                            limitInstance = limitElement.getTextContent();
                            usageInstance.setLimit(limitInstance);
                        }
                        
                        Element unitElement = XmlUtility.getElementByTagNameNS(usagesElement, "http://schemas.microsoft.com/windowsazure", "Unit");
                        if (unitElement != null) {
                            String unitInstance;
                            unitInstance = unitElement.getTextContent();
                            usageInstance.setUnit(unitInstance);
                        }
                        
                        Element nextResetTimeElement = XmlUtility.getElementByTagNameNS(usagesElement, "http://schemas.microsoft.com/windowsazure", "NextResetTime");
                        if (nextResetTimeElement != null && nextResetTimeElement.getTextContent() != null && !nextResetTimeElement.getTextContent().isEmpty()) {
                            Calendar nextResetTimeInstance;
                            nextResetTimeInstance = DatatypeConverter.parseDateTime(nextResetTimeElement.getTextContent());
                            usageInstance.setNextResetTime(nextResetTimeInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Returns a collection of Azure SQL Databases.
    *
    * @param serverName Required. The name of the Azure SQL Database Server
    * from which to retrieve the database.
    * @return Contains a collection of databases for a given Azure SQL Database
    * Server.
    */
    @Override
    public Future<DatabaseListResponse> listAsync(final String serverName) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseListResponse>() { 
            @Override
            public DatabaseListResponse call() throws Exception {
                return list(serverName);
            }
         });
    }
    
    /**
    * Returns a collection of Azure SQL Databases.
    *
    * @param serverName Required. The name of the Azure SQL Database Server
    * from which to retrieve the database.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return Contains a collection of databases for a given Azure SQL Database
    * Server.
    */
    @Override
    public DatabaseListResponse list(String serverName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serverName", serverName);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("contentview=generic");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DatabaseListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DatabaseListResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element serviceResourcesSequenceElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "ServiceResources");
                if (serviceResourcesSequenceElement != null) {
                    for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(serviceResourcesSequenceElement, "http://schemas.microsoft.com/windowsazure", "ServiceResource").size(); i1 = i1 + 1) {
                        org.w3c.dom.Element serviceResourcesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(serviceResourcesSequenceElement, "http://schemas.microsoft.com/windowsazure", "ServiceResource").get(i1));
                        Database serviceResourceInstance = new Database();
                        result.getDatabases().add(serviceResourceInstance);
                        
                        Element idElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "Id");
                        if (idElement != null) {
                            int idInstance;
                            idInstance = DatatypeConverter.parseInt(idElement.getTextContent());
                            serviceResourceInstance.setId(idInstance);
                        }
                        
                        Element editionElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "Edition");
                        if (editionElement != null) {
                            String editionInstance;
                            editionInstance = editionElement.getTextContent();
                            serviceResourceInstance.setEdition(editionInstance);
                        }
                        
                        Element maxSizeGBElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "MaxSizeGB");
                        if (maxSizeGBElement != null) {
                            int maxSizeGBInstance;
                            maxSizeGBInstance = DatatypeConverter.parseInt(maxSizeGBElement.getTextContent());
                            serviceResourceInstance.setMaximumDatabaseSizeInGB(maxSizeGBInstance);
                        }
                        
                        Element maxSizeBytesElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "MaxSizeBytes");
                        if (maxSizeBytesElement != null) {
                            long maxSizeBytesInstance;
                            maxSizeBytesInstance = DatatypeConverter.parseLong(maxSizeBytesElement.getTextContent());
                            serviceResourceInstance.setMaximumDatabaseSizeInBytes(maxSizeBytesInstance);
                        }
                        
                        Element collationNameElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "CollationName");
                        if (collationNameElement != null) {
                            String collationNameInstance;
                            collationNameInstance = collationNameElement.getTextContent();
                            serviceResourceInstance.setCollationName(collationNameInstance);
                        }
                        
                        Element creationDateElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "CreationDate");
                        if (creationDateElement != null) {
                            Calendar creationDateInstance;
                            creationDateInstance = DatatypeConverter.parseDateTime(creationDateElement.getTextContent());
                            serviceResourceInstance.setCreationDate(creationDateInstance);
                        }
                        
                        Element isFederationRootElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "IsFederationRoot");
                        if (isFederationRootElement != null) {
                            boolean isFederationRootInstance;
                            isFederationRootInstance = DatatypeConverter.parseBoolean(isFederationRootElement.getTextContent().toLowerCase());
                            serviceResourceInstance.setIsFederationRoot(isFederationRootInstance);
                        }
                        
                        Element isSystemObjectElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "IsSystemObject");
                        if (isSystemObjectElement != null) {
                            boolean isSystemObjectInstance;
                            isSystemObjectInstance = DatatypeConverter.parseBoolean(isSystemObjectElement.getTextContent().toLowerCase());
                            serviceResourceInstance.setIsSystemObject(isSystemObjectInstance);
                        }
                        
                        Element sizeMBElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "SizeMB");
                        if (sizeMBElement != null) {
                            String sizeMBInstance;
                            sizeMBInstance = sizeMBElement.getTextContent();
                            serviceResourceInstance.setSizeMB(sizeMBInstance);
                        }
                        
                        Element serviceObjectiveAssignmentErrorCodeElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "ServiceObjectiveAssignmentErrorCode");
                        if (serviceObjectiveAssignmentErrorCodeElement != null) {
                            String serviceObjectiveAssignmentErrorCodeInstance;
                            serviceObjectiveAssignmentErrorCodeInstance = serviceObjectiveAssignmentErrorCodeElement.getTextContent();
                            serviceResourceInstance.setServiceObjectiveAssignmentErrorCode(serviceObjectiveAssignmentErrorCodeInstance);
                        }
                        
                        Element serviceObjectiveAssignmentErrorDescriptionElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "ServiceObjectiveAssignmentErrorDescription");
                        if (serviceObjectiveAssignmentErrorDescriptionElement != null) {
                            String serviceObjectiveAssignmentErrorDescriptionInstance;
                            serviceObjectiveAssignmentErrorDescriptionInstance = serviceObjectiveAssignmentErrorDescriptionElement.getTextContent();
                            serviceResourceInstance.setServiceObjectiveAssignmentErrorDescription(serviceObjectiveAssignmentErrorDescriptionInstance);
                        }
                        
                        Element serviceObjectiveAssignmentStateElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "ServiceObjectiveAssignmentState");
                        if (serviceObjectiveAssignmentStateElement != null) {
                            String serviceObjectiveAssignmentStateInstance;
                            serviceObjectiveAssignmentStateInstance = serviceObjectiveAssignmentStateElement.getTextContent();
                            serviceResourceInstance.setServiceObjectiveAssignmentState(serviceObjectiveAssignmentStateInstance);
                        }
                        
                        Element serviceObjectiveAssignmentStateDescriptionElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "ServiceObjectiveAssignmentStateDescription");
                        if (serviceObjectiveAssignmentStateDescriptionElement != null) {
                            String serviceObjectiveAssignmentStateDescriptionInstance;
                            serviceObjectiveAssignmentStateDescriptionInstance = serviceObjectiveAssignmentStateDescriptionElement.getTextContent();
                            serviceResourceInstance.setServiceObjectiveAssignmentStateDescription(serviceObjectiveAssignmentStateDescriptionInstance);
                        }
                        
                        Element serviceObjectiveAssignmentSuccessDateElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "ServiceObjectiveAssignmentSuccessDate");
                        if (serviceObjectiveAssignmentSuccessDateElement != null) {
                            String serviceObjectiveAssignmentSuccessDateInstance;
                            serviceObjectiveAssignmentSuccessDateInstance = serviceObjectiveAssignmentSuccessDateElement.getTextContent();
                            serviceResourceInstance.setServiceObjectiveAssignmentSuccessDate(serviceObjectiveAssignmentSuccessDateInstance);
                        }
                        
                        Element serviceObjectiveIdElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "ServiceObjectiveId");
                        if (serviceObjectiveIdElement != null) {
                            String serviceObjectiveIdInstance;
                            serviceObjectiveIdInstance = serviceObjectiveIdElement.getTextContent();
                            serviceResourceInstance.setServiceObjectiveId(serviceObjectiveIdInstance);
                        }
                        
                        Element assignedServiceObjectiveIdElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "AssignedServiceObjectiveId");
                        if (assignedServiceObjectiveIdElement != null) {
                            String assignedServiceObjectiveIdInstance;
                            assignedServiceObjectiveIdInstance = assignedServiceObjectiveIdElement.getTextContent();
                            serviceResourceInstance.setAssignedServiceObjectiveId(assignedServiceObjectiveIdInstance);
                        }
                        
                        Element recoveryPeriodStartDateElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "RecoveryPeriodStartDate");
                        if (recoveryPeriodStartDateElement != null && recoveryPeriodStartDateElement.getTextContent() != null && !recoveryPeriodStartDateElement.getTextContent().isEmpty()) {
                            Calendar recoveryPeriodStartDateInstance;
                            recoveryPeriodStartDateInstance = DatatypeConverter.parseDateTime(recoveryPeriodStartDateElement.getTextContent());
                            serviceResourceInstance.setRecoveryPeriodStartDate(recoveryPeriodStartDateInstance);
                        }
                        
                        Element nameElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "Name");
                        if (nameElement != null) {
                            String nameInstance;
                            nameInstance = nameElement.getTextContent();
                            serviceResourceInstance.setName(nameInstance);
                        }
                        
                        Element typeElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "Type");
                        if (typeElement != null) {
                            String typeInstance;
                            typeInstance = typeElement.getTextContent();
                            serviceResourceInstance.setType(typeInstance);
                        }
                        
                        Element stateElement = XmlUtility.getElementByTagNameNS(serviceResourcesElement, "http://schemas.microsoft.com/windowsazure", "State");
                        if (stateElement != null) {
                            String stateInstance;
                            stateInstance = stateElement.getTextContent();
                            serviceResourceInstance.setState(stateInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Updates the properties of an Azure SQL Database.
    *
    * @param serverName Required. The name of the Azure SQL Database Server
    * where the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database to be
    * updated.
    * @param parameters Required. The parameters for the Update Database
    * operation.
    * @return Contains the response from a request to Update Database.
    */
    @Override
    public Future<DatabaseUpdateResponse> updateAsync(final String serverName, final String databaseName, final DatabaseUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<DatabaseUpdateResponse>() { 
            @Override
            public DatabaseUpdateResponse call() throws Exception {
                return update(serverName, databaseName, parameters);
            }
         });
    }
    
    /**
    * Updates the properties of an Azure SQL Database.
    *
    * @param serverName Required. The name of the Azure SQL Database Server
    * where the database is hosted.
    * @param databaseName Required. The name of the Azure SQL Database to be
    * updated.
    * @param parameters Required. The parameters for the Update Database
    * operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Contains the response from a request to Update Database.
    */
    @Override
    public DatabaseUpdateResponse update(String serverName, String databaseName, DatabaseUpdateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        if (databaseName == null) {
            throw new NullPointerException("databaseName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getEdition() == null) {
            throw new NullPointerException("parameters.Edition");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serverName", serverName);
            tracingParameters.put("databaseName", databaseName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "updateAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/sqlservers/servers/";
        url = url + URLEncoder.encode(serverName, "UTF-8");
        url = url + "/databases/";
        url = url + URLEncoder.encode(databaseName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2012-03-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element serviceResourceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ServiceResource");
        requestDoc.appendChild(serviceResourceElement);
        
        if (parameters.getName() != null) {
            Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
            nameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
            serviceResourceElement.appendChild(nameElement);
        }
        
        Element editionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Edition");
        editionElement.appendChild(requestDoc.createTextNode(parameters.getEdition()));
        serviceResourceElement.appendChild(editionElement);
        
        if (parameters.getMaximumDatabaseSizeInGB() != null) {
            Element maxSizeGBElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MaxSizeGB");
            maxSizeGBElement.appendChild(requestDoc.createTextNode(Integer.toString(parameters.getMaximumDatabaseSizeInGB())));
            serviceResourceElement.appendChild(maxSizeGBElement);
        }
        
        if (parameters.getMaximumDatabaseSizeInBytes() != null) {
            Element maxSizeBytesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MaxSizeBytes");
            maxSizeBytesElement.appendChild(requestDoc.createTextNode(Long.toString(parameters.getMaximumDatabaseSizeInBytes())));
            serviceResourceElement.appendChild(maxSizeBytesElement);
        }
        
        if (parameters.getServiceObjectiveId() != null) {
            Element serviceObjectiveIdElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ServiceObjectiveId");
            serviceObjectiveIdElement.appendChild(requestDoc.createTextNode(parameters.getServiceObjectiveId()));
            serviceResourceElement.appendChild(serviceObjectiveIdElement);
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DatabaseUpdateResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DatabaseUpdateResponse();
                DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
                documentBuilderFactory2.setNamespaceAware(true);
                DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
                Document responseDoc = documentBuilder2.parse(new BOMInputStream(responseContent));
                
                Element serviceResourceElement2 = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "ServiceResource");
                if (serviceResourceElement2 != null) {
                    Database serviceResourceInstance = new Database();
                    result.setDatabase(serviceResourceInstance);
                    
                    Element idElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "Id");
                    if (idElement != null) {
                        int idInstance;
                        idInstance = DatatypeConverter.parseInt(idElement.getTextContent());
                        serviceResourceInstance.setId(idInstance);
                    }
                    
                    Element editionElement2 = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "Edition");
                    if (editionElement2 != null) {
                        String editionInstance;
                        editionInstance = editionElement2.getTextContent();
                        serviceResourceInstance.setEdition(editionInstance);
                    }
                    
                    Element maxSizeGBElement2 = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "MaxSizeGB");
                    if (maxSizeGBElement2 != null) {
                        int maxSizeGBInstance;
                        maxSizeGBInstance = DatatypeConverter.parseInt(maxSizeGBElement2.getTextContent());
                        serviceResourceInstance.setMaximumDatabaseSizeInGB(maxSizeGBInstance);
                    }
                    
                    Element maxSizeBytesElement2 = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "MaxSizeBytes");
                    if (maxSizeBytesElement2 != null) {
                        long maxSizeBytesInstance;
                        maxSizeBytesInstance = DatatypeConverter.parseLong(maxSizeBytesElement2.getTextContent());
                        serviceResourceInstance.setMaximumDatabaseSizeInBytes(maxSizeBytesInstance);
                    }
                    
                    Element collationNameElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "CollationName");
                    if (collationNameElement != null) {
                        String collationNameInstance;
                        collationNameInstance = collationNameElement.getTextContent();
                        serviceResourceInstance.setCollationName(collationNameInstance);
                    }
                    
                    Element creationDateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "CreationDate");
                    if (creationDateElement != null) {
                        Calendar creationDateInstance;
                        creationDateInstance = DatatypeConverter.parseDateTime(creationDateElement.getTextContent());
                        serviceResourceInstance.setCreationDate(creationDateInstance);
                    }
                    
                    Element isFederationRootElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "IsFederationRoot");
                    if (isFederationRootElement != null) {
                        boolean isFederationRootInstance;
                        isFederationRootInstance = DatatypeConverter.parseBoolean(isFederationRootElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsFederationRoot(isFederationRootInstance);
                    }
                    
                    Element isSystemObjectElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "IsSystemObject");
                    if (isSystemObjectElement != null) {
                        boolean isSystemObjectInstance;
                        isSystemObjectInstance = DatatypeConverter.parseBoolean(isSystemObjectElement.getTextContent().toLowerCase());
                        serviceResourceInstance.setIsSystemObject(isSystemObjectInstance);
                    }
                    
                    Element sizeMBElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "SizeMB");
                    if (sizeMBElement != null) {
                        String sizeMBInstance;
                        sizeMBInstance = sizeMBElement.getTextContent();
                        serviceResourceInstance.setSizeMB(sizeMBInstance);
                    }
                    
                    Element serviceObjectiveAssignmentErrorCodeElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "ServiceObjectiveAssignmentErrorCode");
                    if (serviceObjectiveAssignmentErrorCodeElement != null) {
                        String serviceObjectiveAssignmentErrorCodeInstance;
                        serviceObjectiveAssignmentErrorCodeInstance = serviceObjectiveAssignmentErrorCodeElement.getTextContent();
                        serviceResourceInstance.setServiceObjectiveAssignmentErrorCode(serviceObjectiveAssignmentErrorCodeInstance);
                    }
                    
                    Element serviceObjectiveAssignmentErrorDescriptionElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "ServiceObjectiveAssignmentErrorDescription");
                    if (serviceObjectiveAssignmentErrorDescriptionElement != null) {
                        String serviceObjectiveAssignmentErrorDescriptionInstance;
                        serviceObjectiveAssignmentErrorDescriptionInstance = serviceObjectiveAssignmentErrorDescriptionElement.getTextContent();
                        serviceResourceInstance.setServiceObjectiveAssignmentErrorDescription(serviceObjectiveAssignmentErrorDescriptionInstance);
                    }
                    
                    Element serviceObjectiveAssignmentStateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "ServiceObjectiveAssignmentState");
                    if (serviceObjectiveAssignmentStateElement != null) {
                        String serviceObjectiveAssignmentStateInstance;
                        serviceObjectiveAssignmentStateInstance = serviceObjectiveAssignmentStateElement.getTextContent();
                        serviceResourceInstance.setServiceObjectiveAssignmentState(serviceObjectiveAssignmentStateInstance);
                    }
                    
                    Element serviceObjectiveAssignmentStateDescriptionElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "ServiceObjectiveAssignmentStateDescription");
                    if (serviceObjectiveAssignmentStateDescriptionElement != null) {
                        String serviceObjectiveAssignmentStateDescriptionInstance;
                        serviceObjectiveAssignmentStateDescriptionInstance = serviceObjectiveAssignmentStateDescriptionElement.getTextContent();
                        serviceResourceInstance.setServiceObjectiveAssignmentStateDescription(serviceObjectiveAssignmentStateDescriptionInstance);
                    }
                    
                    Element serviceObjectiveAssignmentSuccessDateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "ServiceObjectiveAssignmentSuccessDate");
                    if (serviceObjectiveAssignmentSuccessDateElement != null) {
                        String serviceObjectiveAssignmentSuccessDateInstance;
                        serviceObjectiveAssignmentSuccessDateInstance = serviceObjectiveAssignmentSuccessDateElement.getTextContent();
                        serviceResourceInstance.setServiceObjectiveAssignmentSuccessDate(serviceObjectiveAssignmentSuccessDateInstance);
                    }
                    
                    Element serviceObjectiveIdElement2 = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "ServiceObjectiveId");
                    if (serviceObjectiveIdElement2 != null) {
                        String serviceObjectiveIdInstance;
                        serviceObjectiveIdInstance = serviceObjectiveIdElement2.getTextContent();
                        serviceResourceInstance.setServiceObjectiveId(serviceObjectiveIdInstance);
                    }
                    
                    Element assignedServiceObjectiveIdElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "AssignedServiceObjectiveId");
                    if (assignedServiceObjectiveIdElement != null) {
                        String assignedServiceObjectiveIdInstance;
                        assignedServiceObjectiveIdInstance = assignedServiceObjectiveIdElement.getTextContent();
                        serviceResourceInstance.setAssignedServiceObjectiveId(assignedServiceObjectiveIdInstance);
                    }
                    
                    Element recoveryPeriodStartDateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "RecoveryPeriodStartDate");
                    if (recoveryPeriodStartDateElement != null && recoveryPeriodStartDateElement.getTextContent() != null && !recoveryPeriodStartDateElement.getTextContent().isEmpty()) {
                        Calendar recoveryPeriodStartDateInstance;
                        recoveryPeriodStartDateInstance = DatatypeConverter.parseDateTime(recoveryPeriodStartDateElement.getTextContent());
                        serviceResourceInstance.setRecoveryPeriodStartDate(recoveryPeriodStartDateInstance);
                    }
                    
                    Element nameElement2 = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "Name");
                    if (nameElement2 != null) {
                        String nameInstance;
                        nameInstance = nameElement2.getTextContent();
                        serviceResourceInstance.setName(nameInstance);
                    }
                    
                    Element typeElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "Type");
                    if (typeElement != null) {
                        String typeInstance;
                        typeInstance = typeElement.getTextContent();
                        serviceResourceInstance.setType(typeInstance);
                    }
                    
                    Element stateElement = XmlUtility.getElementByTagNameNS(serviceResourceElement2, "http://schemas.microsoft.com/windowsazure", "State");
                    if (stateElement != null) {
                        String stateInstance;
                        stateInstance = stateElement.getTextContent();
                        serviceResourceInstance.setState(stateInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
