/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.sql;

import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.sql.models.QuotaGetResponse;
import com.microsoft.windowsazure.management.sql.models.QuotaListResponse;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;
import java.util.concurrent.Future;

/**
* The Azure SQL Database Management API includes operations for getting Azure
* SQL Database Server quotas. Specifically, using the APIs you can get a
* specific quota or list all of the quotas for the Azure SQL Database Server.
*/
public interface QuotaOperations {
    /**
    * Retrieves the specified quota from the server.
    *
    * @param serverName Required. The name of the Azure SQL Database Server
    * from which to retrieve the quota.
    * @param quotaName Required. The name of the quota to retrieve.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return Represents the response structure for the Quota Get operation.
    */
    QuotaGetResponse get(String serverName, String quotaName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * Retrieves the specified quota from the server.
    *
    * @param serverName Required. The name of the Azure SQL Database Server
    * from which to retrieve the quota.
    * @param quotaName Required. The name of the quota to retrieve.
    * @return Represents the response structure for the Quota Get operation.
    */
    Future<QuotaGetResponse> getAsync(String serverName, String quotaName);
    
    /**
    * Returns a list of quotas from the server.
    *
    * @param serverName Required. The name of the Azure SQL Database Server
    * from which to get the quotas.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return Represents the response structure for the Quota List operation.
    */
    QuotaListResponse list(String serverName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * Returns a list of quotas from the server.
    *
    * @param serverName Required. The name of the Azure SQL Database Server
    * from which to get the quotas.
    * @return Represents the response structure for the Quota List operation.
    */
    Future<QuotaListResponse> listAsync(String serverName);
}
