/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.sql.models;

/**
* Represents the parameters that are needed to retrieve the status of an Azure
* SQL Database import or export operation.
*/
public class DacGetStatusParameters {
    private String password;
    
    /**
    * Required. Gets or sets the password for the Azure SQL Database server
    * where the import or export operation is occurring.
    * @return The Password value.
    */
    public String getPassword() {
        return this.password;
    }
    
    /**
    * Required. Gets or sets the password for the Azure SQL Database server
    * where the import or export operation is occurring.
    * @param passwordValue The Password value.
    */
    public void setPassword(final String passwordValue) {
        this.password = passwordValue;
    }
    
    private String requestId;
    
    /**
    * Required. Gets or sets the Id for the import or export operation of which
    * to query the status.
    * @return The RequestId value.
    */
    public String getRequestId() {
        return this.requestId;
    }
    
    /**
    * Required. Gets or sets the Id for the import or export operation of which
    * to query the status.
    * @param requestIdValue The RequestId value.
    */
    public void setRequestId(final String requestIdValue) {
        this.requestId = requestIdValue;
    }
    
    private String serverName;
    
    /**
    * Required. Gets or sets the fully qualified name of the Azure SQL Database
    * server where the import or export operation is occurring.
    * @return The ServerName value.
    */
    public String getServerName() {
        return this.serverName;
    }
    
    /**
    * Required. Gets or sets the fully qualified name of the Azure SQL Database
    * server where the import or export operation is occurring.
    * @param serverNameValue The ServerName value.
    */
    public void setServerName(final String serverNameValue) {
        this.serverName = serverNameValue;
    }
    
    private String userName;
    
    /**
    * Required. Gets or sets the username for the Azure SQL Database server
    * where the import or export operation is occurring.
    * @return The UserName value.
    */
    public String getUserName() {
        return this.userName;
    }
    
    /**
    * Required. Gets or sets the username for the Azure SQL Database server
    * where the import or export operation is occurring.
    * @param userNameValue The UserName value.
    */
    public void setUserName(final String userNameValue) {
        this.userName = userNameValue;
    }
}
