/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.sql.models;

import java.net.URI;

/**
* Represents the parameters that are needed to initiate an Azure SQL Database
* import operation.
*/
public class DacImportParameters {
    private String azureEdition;
    
    /**
    * Optional. Gets or sets the edition for the database that will be created
    * upon import.
    * @return The AzureEdition value.
    */
    public String getAzureEdition() {
        return this.azureEdition;
    }
    
    /**
    * Optional. Gets or sets the edition for the database that will be created
    * upon import.
    * @param azureEditionValue The AzureEdition value.
    */
    public void setAzureEdition(final String azureEditionValue) {
        this.azureEdition = azureEditionValue;
    }
    
    private DacImportParameters.BlobCredentialsParameter blobCredentials;
    
    /**
    * Optional. Gets or sets the credentials for retrieving the DACPAC from
    * Azure Blob Storage.
    * @return The BlobCredentials value.
    */
    public DacImportParameters.BlobCredentialsParameter getBlobCredentials() {
        return this.blobCredentials;
    }
    
    /**
    * Optional. Gets or sets the credentials for retrieving the DACPAC from
    * Azure Blob Storage.
    * @param blobCredentialsValue The BlobCredentials value.
    */
    public void setBlobCredentials(final DacImportParameters.BlobCredentialsParameter blobCredentialsValue) {
        this.blobCredentials = blobCredentialsValue;
    }
    
    private DacImportParameters.ConnectionInfoParameter connectionInfo;
    
    /**
    * Optional. Gets or sets the connection information needed for connecting
    * to SQL Azure and creating a database to import into.
    * @return The ConnectionInfo value.
    */
    public DacImportParameters.ConnectionInfoParameter getConnectionInfo() {
        return this.connectionInfo;
    }
    
    /**
    * Optional. Gets or sets the connection information needed for connecting
    * to SQL Azure and creating a database to import into.
    * @param connectionInfoValue The ConnectionInfo value.
    */
    public void setConnectionInfo(final DacImportParameters.ConnectionInfoParameter connectionInfoValue) {
        this.connectionInfo = connectionInfoValue;
    }
    
    private int databaseSizeInGB;
    
    /**
    * Optional. Gets or sets the size for the database that will be created
    * upon import.
    * @return The DatabaseSizeInGB value.
    */
    public int getDatabaseSizeInGB() {
        return this.databaseSizeInGB;
    }
    
    /**
    * Optional. Gets or sets the size for the database that will be created
    * upon import.
    * @param databaseSizeInGBValue The DatabaseSizeInGB value.
    */
    public void setDatabaseSizeInGB(final int databaseSizeInGBValue) {
        this.databaseSizeInGB = databaseSizeInGBValue;
    }
    
    /**
    * Represents the Azure Blob Storage information needed for connecting and
    * retrieving the DACPAC file.
    */
    public static class BlobCredentialsParameter {
        private String storageAccessKey;
        
        /**
        * Required. Gets or sets the access key for the Azure Blob Storage
        * account where the DACPAC file is stored.
        * @return The StorageAccessKey value.
        */
        public String getStorageAccessKey() {
            return this.storageAccessKey;
        }
        
        /**
        * Required. Gets or sets the access key for the Azure Blob Storage
        * account where the DACPAC file is stored.
        * @param storageAccessKeyValue The StorageAccessKey value.
        */
        public void setStorageAccessKey(final String storageAccessKeyValue) {
            this.storageAccessKey = storageAccessKeyValue;
        }
        
        private URI uri;
        
        /**
        * Required. Gets or sets the URI of the DACPAC file stored in Azure
        * Blob Storage to be imported.
        * @return The Uri value.
        */
        public URI getUri() {
            return this.uri;
        }
        
        /**
        * Required. Gets or sets the URI of the DACPAC file stored in Azure
        * Blob Storage to be imported.
        * @param uriValue The Uri value.
        */
        public void setUri(final URI uriValue) {
            this.uri = uriValue;
        }
        
        /**
        * Initializes a new instance of the BlobCredentialsParameter class.
        *
        */
        public BlobCredentialsParameter() {
        }
        
        /**
        * Initializes a new instance of the BlobCredentialsParameter class with
        * required arguments.
        *
        * @param uri Gets or sets the URI of the DACPAC file stored in Azure
        * Blob Storage to be imported.
        * @param storageAccessKey Gets or sets the access key for the Azure
        * Blob Storage account where the DACPAC file is stored.
        */
        public BlobCredentialsParameter(URI uri, String storageAccessKey) {
            if (uri == null) {
                throw new NullPointerException("uri");
            }
            if (storageAccessKey == null) {
                throw new NullPointerException("storageAccessKey");
            }
            this.setUri(uri);
            this.setStorageAccessKey(storageAccessKey);
        }
    }
    
    /**
    * Represents the connection information for the Azure SQL Database into
    * which the DACPAC file will be imported.
    */
    public static class ConnectionInfoParameter {
        private String databaseName;
        
        /**
        * Required. Gets or sets the name of the database into which the DACPAC
        * file will be imported.
        * @return The DatabaseName value.
        */
        public String getDatabaseName() {
            return this.databaseName;
        }
        
        /**
        * Required. Gets or sets the name of the database into which the DACPAC
        * file will be imported.
        * @param databaseNameValue The DatabaseName value.
        */
        public void setDatabaseName(final String databaseNameValue) {
            this.databaseName = databaseNameValue;
        }
        
        private String password;
        
        /**
        * Required. Gets or sets the password for the server administrator.
        * @return The Password value.
        */
        public String getPassword() {
            return this.password;
        }
        
        /**
        * Required. Gets or sets the password for the server administrator.
        * @param passwordValue The Password value.
        */
        public void setPassword(final String passwordValue) {
            this.password = passwordValue;
        }
        
        private String serverName;
        
        /**
        * Required. Gets or sets the Azure SQL Database Server name where the
        * imported database will be created.
        * @return The ServerName value.
        */
        public String getServerName() {
            return this.serverName;
        }
        
        /**
        * Required. Gets or sets the Azure SQL Database Server name where the
        * imported database will be created.
        * @param serverNameValue The ServerName value.
        */
        public void setServerName(final String serverNameValue) {
            this.serverName = serverNameValue;
        }
        
        private String userName;
        
        /**
        * Required. Gets or sets the username of the server administration.
        * @return The UserName value.
        */
        public String getUserName() {
            return this.userName;
        }
        
        /**
        * Required. Gets or sets the username of the server administration.
        * @param userNameValue The UserName value.
        */
        public void setUserName(final String userNameValue) {
            this.userName = userNameValue;
        }
    }
}
