/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.sql.models;

import java.util.Calendar;

/**
* Represents a database in the Azure SQL Database service.
*/
public class Database extends SqlModelCommon {
    private String assignedServiceObjectiveId;
    
    /**
    * Optional. Gets the ID of the assigned service objective for this
    * database.  This is the ID of the service objective being applied.
    * @return The AssignedServiceObjectiveId value.
    */
    public String getAssignedServiceObjectiveId() {
        return this.assignedServiceObjectiveId;
    }
    
    /**
    * Optional. Gets the ID of the assigned service objective for this
    * database.  This is the ID of the service objective being applied.
    * @param assignedServiceObjectiveIdValue The AssignedServiceObjectiveId
    * value.
    */
    public void setAssignedServiceObjectiveId(final String assignedServiceObjectiveIdValue) {
        this.assignedServiceObjectiveId = assignedServiceObjectiveIdValue;
    }
    
    private String collationName;
    
    /**
    * Optional. Gets the name of the collation for this database.
    * @return The CollationName value.
    */
    public String getCollationName() {
        return this.collationName;
    }
    
    /**
    * Optional. Gets the name of the collation for this database.
    * @param collationNameValue The CollationName value.
    */
    public void setCollationName(final String collationNameValue) {
        this.collationName = collationNameValue;
    }
    
    private Calendar creationDate;
    
    /**
    * Optional. Gets the date this database was created.
    * @return The CreationDate value.
    */
    public Calendar getCreationDate() {
        return this.creationDate;
    }
    
    /**
    * Optional. Gets the date this database was created.
    * @param creationDateValue The CreationDate value.
    */
    public void setCreationDate(final Calendar creationDateValue) {
        this.creationDate = creationDateValue;
    }
    
    private String edition;
    
    /**
    * Optional. Gets the edition of the Azure SQL Database.  The
    * DatabaseEditions enumeration contains all the valid editions.
    * @return The Edition value.
    */
    public String getEdition() {
        return this.edition;
    }
    
    /**
    * Optional. Gets the edition of the Azure SQL Database.  The
    * DatabaseEditions enumeration contains all the valid editions.
    * @param editionValue The Edition value.
    */
    public void setEdition(final String editionValue) {
        this.edition = editionValue;
    }
    
    private int id;
    
    /**
    * Optional. Gets the ID of the database.  This ID is unique within the
    * server that contains the database.
    * @return The Id value.
    */
    public int getId() {
        return this.id;
    }
    
    /**
    * Optional. Gets the ID of the database.  This ID is unique within the
    * server that contains the database.
    * @param idValue The Id value.
    */
    public void setId(final int idValue) {
        this.id = idValue;
    }
    
    private boolean isFederationRoot;
    
    /**
    * Optional. Gets whether or not the database is a federation root.
    * @return The IsFederationRoot value.
    */
    public boolean isFederationRoot() {
        return this.isFederationRoot;
    }
    
    /**
    * Optional. Gets whether or not the database is a federation root.
    * @param isFederationRootValue The IsFederationRoot value.
    */
    public void setIsFederationRoot(final boolean isFederationRootValue) {
        this.isFederationRoot = isFederationRootValue;
    }
    
    private boolean isSystemObject;
    
    /**
    * Optional. Gets whether or not the database is a system object.
    * @return The IsSystemObject value.
    */
    public boolean isSystemObject() {
        return this.isSystemObject;
    }
    
    /**
    * Optional. Gets whether or not the database is a system object.
    * @param isSystemObjectValue The IsSystemObject value.
    */
    public void setIsSystemObject(final boolean isSystemObjectValue) {
        this.isSystemObject = isSystemObjectValue;
    }
    
    private long maximumDatabaseSizeInBytes;
    
    /**
    * Optional. Gets the maximum size of this database expressed in bytes.
    * @return The MaximumDatabaseSizeInBytes value.
    */
    public long getMaximumDatabaseSizeInBytes() {
        return this.maximumDatabaseSizeInBytes;
    }
    
    /**
    * Optional. Gets the maximum size of this database expressed in bytes.
    * @param maximumDatabaseSizeInBytesValue The MaximumDatabaseSizeInBytes
    * value.
    */
    public void setMaximumDatabaseSizeInBytes(final long maximumDatabaseSizeInBytesValue) {
        this.maximumDatabaseSizeInBytes = maximumDatabaseSizeInBytesValue;
    }
    
    private int maximumDatabaseSizeInGB;
    
    /**
    * Optional. Gets the maximum size of this database expressed in gigabytes.
    * @return The MaximumDatabaseSizeInGB value.
    */
    public int getMaximumDatabaseSizeInGB() {
        return this.maximumDatabaseSizeInGB;
    }
    
    /**
    * Optional. Gets the maximum size of this database expressed in gigabytes.
    * @param maximumDatabaseSizeInGBValue The MaximumDatabaseSizeInGB value.
    */
    public void setMaximumDatabaseSizeInGB(final int maximumDatabaseSizeInGBValue) {
        this.maximumDatabaseSizeInGB = maximumDatabaseSizeInGBValue;
    }
    
    private Calendar recoveryPeriodStartDate;
    
    /**
    * Optional. Gets the starting date of the restorable period for this
    * database.
    * @return The RecoveryPeriodStartDate value.
    */
    public Calendar getRecoveryPeriodStartDate() {
        return this.recoveryPeriodStartDate;
    }
    
    /**
    * Optional. Gets the starting date of the restorable period for this
    * database.
    * @param recoveryPeriodStartDateValue The RecoveryPeriodStartDate value.
    */
    public void setRecoveryPeriodStartDate(final Calendar recoveryPeriodStartDateValue) {
        this.recoveryPeriodStartDate = recoveryPeriodStartDateValue;
    }
    
    private String serviceObjectiveAssignmentErrorCode;
    
    /**
    * Optional. Gets the error code raised when assigning a new service
    * objective if there was one.
    * @return The ServiceObjectiveAssignmentErrorCode value.
    */
    public String getServiceObjectiveAssignmentErrorCode() {
        return this.serviceObjectiveAssignmentErrorCode;
    }
    
    /**
    * Optional. Gets the error code raised when assigning a new service
    * objective if there was one.
    * @param serviceObjectiveAssignmentErrorCodeValue The
    * ServiceObjectiveAssignmentErrorCode value.
    */
    public void setServiceObjectiveAssignmentErrorCode(final String serviceObjectiveAssignmentErrorCodeValue) {
        this.serviceObjectiveAssignmentErrorCode = serviceObjectiveAssignmentErrorCodeValue;
    }
    
    private String serviceObjectiveAssignmentErrorDescription;
    
    /**
    * Optional. Gets the description of the error if an error occured while
    * applying a new service objective.
    * @return The ServiceObjectiveAssignmentErrorDescription value.
    */
    public String getServiceObjectiveAssignmentErrorDescription() {
        return this.serviceObjectiveAssignmentErrorDescription;
    }
    
    /**
    * Optional. Gets the description of the error if an error occured while
    * applying a new service objective.
    * @param serviceObjectiveAssignmentErrorDescriptionValue The
    * ServiceObjectiveAssignmentErrorDescription value.
    */
    public void setServiceObjectiveAssignmentErrorDescription(final String serviceObjectiveAssignmentErrorDescriptionValue) {
        this.serviceObjectiveAssignmentErrorDescription = serviceObjectiveAssignmentErrorDescriptionValue;
    }
    
    private String serviceObjectiveAssignmentState;
    
    /**
    * Optional. Gets the state of the current service objective assignment in
    * numerical format.
    * @return The ServiceObjectiveAssignmentState value.
    */
    public String getServiceObjectiveAssignmentState() {
        return this.serviceObjectiveAssignmentState;
    }
    
    /**
    * Optional. Gets the state of the current service objective assignment in
    * numerical format.
    * @param serviceObjectiveAssignmentStateValue The
    * ServiceObjectiveAssignmentState value.
    */
    public void setServiceObjectiveAssignmentState(final String serviceObjectiveAssignmentStateValue) {
        this.serviceObjectiveAssignmentState = serviceObjectiveAssignmentStateValue;
    }
    
    private String serviceObjectiveAssignmentStateDescription;
    
    /**
    * Optional. Gets the description of the state of the current service
    * objective assignment.
    * @return The ServiceObjectiveAssignmentStateDescription value.
    */
    public String getServiceObjectiveAssignmentStateDescription() {
        return this.serviceObjectiveAssignmentStateDescription;
    }
    
    /**
    * Optional. Gets the description of the state of the current service
    * objective assignment.
    * @param serviceObjectiveAssignmentStateDescriptionValue The
    * ServiceObjectiveAssignmentStateDescription value.
    */
    public void setServiceObjectiveAssignmentStateDescription(final String serviceObjectiveAssignmentStateDescriptionValue) {
        this.serviceObjectiveAssignmentStateDescription = serviceObjectiveAssignmentStateDescriptionValue;
    }
    
    private String serviceObjectiveAssignmentSuccessDate;
    
    /**
    * Optional. Gets the date the service objective assignment succeeded.
    * @return The ServiceObjectiveAssignmentSuccessDate value.
    */
    public String getServiceObjectiveAssignmentSuccessDate() {
        return this.serviceObjectiveAssignmentSuccessDate;
    }
    
    /**
    * Optional. Gets the date the service objective assignment succeeded.
    * @param serviceObjectiveAssignmentSuccessDateValue The
    * ServiceObjectiveAssignmentSuccessDate value.
    */
    public void setServiceObjectiveAssignmentSuccessDate(final String serviceObjectiveAssignmentSuccessDateValue) {
        this.serviceObjectiveAssignmentSuccessDate = serviceObjectiveAssignmentSuccessDateValue;
    }
    
    private String serviceObjectiveId;
    
    /**
    * Optional. Gets the ID of the current service objective.
    * @return The ServiceObjectiveId value.
    */
    public String getServiceObjectiveId() {
        return this.serviceObjectiveId;
    }
    
    /**
    * Optional. Gets the ID of the current service objective.
    * @param serviceObjectiveIdValue The ServiceObjectiveId value.
    */
    public void setServiceObjectiveId(final String serviceObjectiveIdValue) {
        this.serviceObjectiveId = serviceObjectiveIdValue;
    }
    
    private String sizeMB;
    
    /**
    * Optional. Gets the current usage of the database in megabytes.
    * @return The SizeMB value.
    */
    public String getSizeMB() {
        return this.sizeMB;
    }
    
    /**
    * Optional. Gets the current usage of the database in megabytes.
    * @param sizeMBValue The SizeMB value.
    */
    public void setSizeMB(final String sizeMBValue) {
        this.sizeMB = sizeMBValue;
    }
}
