/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.sql.models;

/**
* Represents the Azure SQL Database copy.
*/
public class DatabaseCopy extends SqlModelCommon {
    private String destinationDatabaseName;
    
    /**
    * Optional. Gets the name of the destination database.
    * @return The DestinationDatabaseName value.
    */
    public String getDestinationDatabaseName() {
        return this.destinationDatabaseName;
    }
    
    /**
    * Optional. Gets the name of the destination database.
    * @param destinationDatabaseNameValue The DestinationDatabaseName value.
    */
    public void setDestinationDatabaseName(final String destinationDatabaseNameValue) {
        this.destinationDatabaseName = destinationDatabaseNameValue;
    }
    
    private String destinationServerName;
    
    /**
    * Optional. Gets the name of the destination server.
    * @return The DestinationServerName value.
    */
    public String getDestinationServerName() {
        return this.destinationServerName;
    }
    
    /**
    * Optional. Gets the name of the destination server.
    * @param destinationServerNameValue The DestinationServerName value.
    */
    public void setDestinationServerName(final String destinationServerNameValue) {
        this.destinationServerName = destinationServerNameValue;
    }
    
    private boolean isContinuous;
    
    /**
    * Optional. Gets a value that indicates whether the copy is continous.
    * @return The IsContinuous value.
    */
    public boolean isContinuous() {
        return this.isContinuous;
    }
    
    /**
    * Optional. Gets a value that indicates whether the copy is continous.
    * @param isContinuousValue The IsContinuous value.
    */
    public void setIsContinuous(final boolean isContinuousValue) {
        this.isContinuous = isContinuousValue;
    }
    
    private boolean isInterlinkConnected;
    
    /**
    * Optional. Gets a value that indicates whether the database copy is
    * interlink connected.
    * @return The IsInterlinkConnected value.
    */
    public boolean isInterlinkConnected() {
        return this.isInterlinkConnected;
    }
    
    /**
    * Optional. Gets a value that indicates whether the database copy is
    * interlink connected.
    * @param isInterlinkConnectedValue The IsInterlinkConnected value.
    */
    public void setIsInterlinkConnected(final boolean isInterlinkConnectedValue) {
        this.isInterlinkConnected = isInterlinkConnectedValue;
    }
    
    private boolean isLocalDatabaseReplicationTarget;
    
    /**
    * Optional. Gets a value that indicates whether the local database is the
    * replication target.
    * @return The IsLocalDatabaseReplicationTarget value.
    */
    public boolean isLocalDatabaseReplicationTarget() {
        return this.isLocalDatabaseReplicationTarget;
    }
    
    /**
    * Optional. Gets a value that indicates whether the local database is the
    * replication target.
    * @param isLocalDatabaseReplicationTargetValue The
    * IsLocalDatabaseReplicationTarget value.
    */
    public void setIsLocalDatabaseReplicationTarget(final boolean isLocalDatabaseReplicationTargetValue) {
        this.isLocalDatabaseReplicationTarget = isLocalDatabaseReplicationTargetValue;
    }
    
    private boolean isOfflineSecondary;
    
    /**
    * Optional. Gets a value indicating whether it is an offline secondary copy.
    * @return The IsOfflineSecondary value.
    */
    public boolean isOfflineSecondary() {
        return this.isOfflineSecondary;
    }
    
    /**
    * Optional. Gets a value indicating whether it is an offline secondary copy.
    * @param isOfflineSecondaryValue The IsOfflineSecondary value.
    */
    public void setIsOfflineSecondary(final boolean isOfflineSecondaryValue) {
        this.isOfflineSecondary = isOfflineSecondaryValue;
    }
    
    private boolean isTerminationAllowed;
    
    /**
    * Optional. Gets a value indicating whether forced termination of this
    * continuous copy is allowed.
    * @return The IsTerminationAllowed value.
    */
    public boolean isTerminationAllowed() {
        return this.isTerminationAllowed;
    }
    
    /**
    * Optional. Gets a value indicating whether forced termination of this
    * continuous copy is allowed.
    * @param isTerminationAllowedValue The IsTerminationAllowed value.
    */
    public void setIsTerminationAllowed(final boolean isTerminationAllowedValue) {
        this.isTerminationAllowed = isTerminationAllowedValue;
    }
    
    private int localDatabaseId;
    
    /**
    * Optional. Gets the ID of the local database.
    * @return The LocalDatabaseId value.
    */
    public int getLocalDatabaseId() {
        return this.localDatabaseId;
    }
    
    /**
    * Optional. Gets the ID of the local database.
    * @param localDatabaseIdValue The LocalDatabaseId value.
    */
    public void setLocalDatabaseId(final int localDatabaseIdValue) {
        this.localDatabaseId = localDatabaseIdValue;
    }
    
    private String modifyDate;
    
    /**
    * Optional. Gets the UTC date when the database copy became transactionally
    * consistent.
    * @return The ModifyDate value.
    */
    public String getModifyDate() {
        return this.modifyDate;
    }
    
    /**
    * Optional. Gets the UTC date when the database copy became transactionally
    * consistent.
    * @param modifyDateValue The ModifyDate value.
    */
    public void setModifyDate(final String modifyDateValue) {
        this.modifyDate = modifyDateValue;
    }
    
    private float percentComplete;
    
    /**
    * Optional. Gets the progress towards copy completion.
    * @return The PercentComplete value.
    */
    public float getPercentComplete() {
        return this.percentComplete;
    }
    
    /**
    * Optional. Gets the progress towards copy completion.
    * @param percentCompleteValue The PercentComplete value.
    */
    public void setPercentComplete(final float percentCompleteValue) {
        this.percentComplete = percentCompleteValue;
    }
    
    private byte replicationState;
    
    /**
    * Optional. Gets a value indicating the replication state for the database.
    * @return The ReplicationState value.
    */
    public byte getReplicationState() {
        return this.replicationState;
    }
    
    /**
    * Optional. Gets a value indicating the replication state for the database.
    * @param replicationStateValue The ReplicationState value.
    */
    public void setReplicationState(final byte replicationStateValue) {
        this.replicationState = replicationStateValue;
    }
    
    private String replicationStateDescription;
    
    /**
    * Optional. Gets a description of the replication state for the database.
    * @return The ReplicationStateDescription value.
    */
    public String getReplicationStateDescription() {
        return this.replicationStateDescription;
    }
    
    /**
    * Optional. Gets a description of the replication state for the database.
    * @param replicationStateDescriptionValue The ReplicationStateDescription
    * value.
    */
    public void setReplicationStateDescription(final String replicationStateDescriptionValue) {
        this.replicationStateDescription = replicationStateDescriptionValue;
    }
    
    private String sourceDatabaseName;
    
    /**
    * Optional. Gets the name of the source database.
    * @return The SourceDatabaseName value.
    */
    public String getSourceDatabaseName() {
        return this.sourceDatabaseName;
    }
    
    /**
    * Optional. Gets the name of the source database.
    * @param sourceDatabaseNameValue The SourceDatabaseName value.
    */
    public void setSourceDatabaseName(final String sourceDatabaseNameValue) {
        this.sourceDatabaseName = sourceDatabaseNameValue;
    }
    
    private String sourceServerName;
    
    /**
    * Optional. Gets the name of the source server.
    * @return The SourceServerName value.
    */
    public String getSourceServerName() {
        return this.sourceServerName;
    }
    
    /**
    * Optional. Gets the name of the source server.
    * @param sourceServerNameValue The SourceServerName value.
    */
    public void setSourceServerName(final String sourceServerNameValue) {
        this.sourceServerName = sourceServerNameValue;
    }
    
    private String startDate;
    
    /**
    * Optional. Gets the UTC date when the database copy was initiated.
    * @return The StartDate value.
    */
    public String getStartDate() {
        return this.startDate;
    }
    
    /**
    * Optional. Gets the UTC date when the database copy was initiated.
    * @param startDateValue The StartDate value.
    */
    public void setStartDate(final String startDateValue) {
        this.startDate = startDateValue;
    }
}
