/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.sql.models;

/**
* Represents the parameters supplied to the Create Database Copy operation.
*/
public class DatabaseCopyCreateParameters {
    private boolean isContinuous;
    
    /**
    * Required. Gets a value that indicates whether the copy should be
    * continuous.
    * @return The IsContinuous value.
    */
    public boolean isContinuous() {
        return this.isContinuous;
    }
    
    /**
    * Required. Gets a value that indicates whether the copy should be
    * continuous.
    * @param isContinuousValue The IsContinuous value.
    */
    public void setIsContinuous(final boolean isContinuousValue) {
        this.isContinuous = isContinuousValue;
    }
    
    private boolean isOfflineSecondary;
    
    /**
    * Optional. Gets a value that indicates whether it is an offline secondary
    * copy.
    * @return The IsOfflineSecondary value.
    */
    public boolean isOfflineSecondary() {
        return this.isOfflineSecondary;
    }
    
    /**
    * Optional. Gets a value that indicates whether it is an offline secondary
    * copy.
    * @param isOfflineSecondaryValue The IsOfflineSecondary value.
    */
    public void setIsOfflineSecondary(final boolean isOfflineSecondaryValue) {
        this.isOfflineSecondary = isOfflineSecondaryValue;
    }
    
    private String partnerDatabase;
    
    /**
    * Required. Gets the name of the destination database for the copy.
    * @return The PartnerDatabase value.
    */
    public String getPartnerDatabase() {
        return this.partnerDatabase;
    }
    
    /**
    * Required. Gets the name of the destination database for the copy.
    * @param partnerDatabaseValue The PartnerDatabase value.
    */
    public void setPartnerDatabase(final String partnerDatabaseValue) {
        this.partnerDatabase = partnerDatabaseValue;
    }
    
    private String partnerServer;
    
    /**
    * Required. Gets the name of the destination server for the copy.
    * @return The PartnerServer value.
    */
    public String getPartnerServer() {
        return this.partnerServer;
    }
    
    /**
    * Required. Gets the name of the destination server for the copy.
    * @param partnerServerValue The PartnerServer value.
    */
    public void setPartnerServer(final String partnerServerValue) {
        this.partnerServer = partnerServerValue;
    }
    
    /**
    * Initializes a new instance of the DatabaseCopyCreateParameters class.
    *
    */
    public DatabaseCopyCreateParameters() {
    }
    
    /**
    * Initializes a new instance of the DatabaseCopyCreateParameters class with
    * required arguments.
    *
    * @param partnerServer Gets the name of the destination server for the copy.
    * @param partnerDatabase Gets the name of the destination database for the
    * copy.
    * @param isContinuous Gets a value that indicates whether the copy should
    * be continuous.
    */
    public DatabaseCopyCreateParameters(String partnerServer, String partnerDatabase, boolean isContinuous) {
        if (partnerServer == null) {
            throw new NullPointerException("partnerServer");
        }
        if (partnerDatabase == null) {
            throw new NullPointerException("partnerDatabase");
        }
        this.setPartnerServer(partnerServer);
        this.setPartnerDatabase(partnerDatabase);
        this.setIsContinuous(isContinuous);
    }
}
